(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20157,        700]
NotebookOptionsPosition[     16248,        575]
NotebookOutlinePosition[     17861,        617]
CellTagsIndexPosition[     17776,        612]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions with Variable Numbers of Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functions with Variable Numbers of Arguments\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Blank" :> Documentation`HelpLookup["paclet:ref/Blank"], 
          "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], "Pattern" :> 
          Documentation`HelpLookup["paclet:ref/Pattern"], "SlotSequence" :> 
          Documentation`HelpLookup["paclet:ref/SlotSequence"], 
          "OptionsPattern" :> 
          Documentation`HelpLookup["paclet:ref/OptionsPattern"], 
          "RepeatedNull" :> 
          Documentation`HelpLookup["paclet:ref/RepeatedNull"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Blank\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"Pattern\"\>", 
       4->"\<\"SlotSequence\"\>", 5->"\<\"OptionsPattern\"\>", 
       6->"\<\"RepeatedNull\"\>", 
       7->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "BlankNullSequence ",
 StyleBox["(___)", "OperatorCharacter"]
}], "ObjectName",
 CellID->3524],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["___"], "InlineFormula"],
     " (three ",
     Cell[BoxData["_"], "InlineFormula"],
     " characters) or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BlankNullSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankNullSequence"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is a pattern object that can stand for any sequence of \
zero or more ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expressions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      StyleBox[
       RowBox[{"___", 
        StyleBox["h", "TI"]}]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BlankNullSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankNullSequence"], "[", 
       StyleBox["h", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]can stand for any sequence of expressions, all of which \
have head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1215]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Blank sequences work slightly differently depending on whether or not the \
head of the expression in which they appear is a symbol with the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28599],

Cell[TextData[{
 "Consider matching the pattern ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", "___", ",", 
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " against the expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a symbol with attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", then the ",
 Cell[BoxData["___"], "InlineFormula"],
 " will be taken to stand for the expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is not a symbol with attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", then ",
 Cell[BoxData["___"], "InlineFormula"],
 " will be taken to stand for the sequence of expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", \[Ellipsis]. With a named pattern, such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "___"}]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " can be used only as an element in an expression. The sequence of \
expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", \[Ellipsis] is \[OpenCurlyDoubleQuote]spliced in\[CloseCurlyDoubleQuote] \
to replace ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", thereby usually increasing the length of the expression. "
}], "Notes",
 CellID->17670],

Cell[TextData[{
 "If ",
 Cell[BoxData["___"], "InlineFormula"],
 " matches a sequence of length more than one, then the sequence will be \
represented by a ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " object. In most uses of ",
 Cell[BoxData["___"], "InlineFormula"],
 ", however, the ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " object will automatically be spliced into another expression, and will \
never appear explicitly. "
}], "Notes",
 CellID->12455]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200352834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->188085267],

Cell["A function that works with any number of arguments:", "ExampleText",
 CellID->2236641],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x___", "]"}], " ", ":=", " ", 
  RowBox[{"p", "[", 
   RowBox[{"x", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118468302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "]"}], ",", 
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "a"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->957551690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "a", ",", "1", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28613628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187584860],

Cell["A function that works with any number of integer arguments:", \
"ExampleText",
 CellID->386914525],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x___Integer", "]"}], " ", ":=", " ", 
  RowBox[{"p", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Plus", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136207016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "]"}], ",", 
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2", ",", "3"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "b", ",", "3"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->325019429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "0", "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "2", ",", "3", ",", "6"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "b", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->782789967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->323581642],

Cell["\<\
A function that works with an integer followed by any number of arguments:\
\>", "ExampleText",
 CellID->94174688],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_Integer", ",", " ", "y___"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Plus", "[", "y", "]"}], "^", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153357612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2."}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2.", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "1", ",", "y"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->965735730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2.`", ",", 
   RowBox[{"2.`", "\[InvisibleSpace]", "+", "x"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "1", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->444708437]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18569],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RepeatedNull",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RepeatedNull"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24711],

Cell[TextData[ButtonBox["Functions with Variable Numbers of Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"]], "Tutorials",
 CellID->6221],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->647121032],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->31079473],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->97716509]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BlankNullSequence (___) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 20.6147346}", "context" -> "System`", 
    "keywords" -> {
     "all expressions", "match sequence of expressions", 
      "zero or more expressions", "any number of arguments", 
      "seqeunce of arguments", "pattern language"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "___(three _characters) or BlankNullSequence[] is a pattern object that \
can stand for any sequence of zero or more Mathematica expressions. ___h or \
BlankNullSequence[h] can stand for any sequence of expressions, all of which \
have head h. ", "synonyms" -> {"blank null sequence", "___", "varargs"}, 
    "title" -> "BlankNullSequence", "type" -> "Symbol", "uri" -> 
    "ref/BlankNullSequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8843, 287, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->200352834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17633, 605}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2748, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3371, 90, 111, 4, 70, "ObjectName",
 CellID->3524],
Cell[3485, 96, 1257, 41, 70, "Usage",
 CellID->1215]
}, Open  ]],
Cell[CellGroupData[{
Cell[4779, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5257, 159, 317, 9, 70, "Notes",
 CellID->28599],
Cell[5577, 170, 2608, 91, 70, "Notes",
 CellID->17670],
Cell[8188, 263, 618, 19, 70, "Notes",
 CellID->12455]
}, Closed]],
Cell[CellGroupData[{
Cell[8843, 287, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200352834],
Cell[CellGroupData[{
Cell[9228, 301, 148, 5, 70, "ExampleSection",
 CellID->188085267],
Cell[9379, 308, 92, 1, 70, "ExampleText",
 CellID->2236641],
Cell[9474, 311, 186, 6, 70, "Input",
 CellID->118468302],
Cell[CellGroupData[{
Cell[9685, 321, 232, 8, 28, "Input",
 CellID->957551690],
Cell[9920, 331, 365, 12, 36, "Output",
 CellID->28613628]
}, Open  ]],
Cell[10300, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->187584860],
Cell[10428, 351, 104, 2, 70, "ExampleText",
 CellID->386914525],
Cell[10535, 355, 226, 7, 70, "Input",
 CellID->136207016],
Cell[CellGroupData[{
Cell[10786, 366, 316, 10, 70, "Input",
 CellID->325019429],
Cell[11105, 378, 445, 14, 36, "Output",
 CellID->782789967]
}, Open  ]],
Cell[11565, 395, 125, 3, 70, "ExampleDelimiter",
 CellID->323581642],
Cell[11693, 400, 124, 3, 70, "ExampleText",
 CellID->94174688],
Cell[11820, 405, 226, 7, 70, "Input",
 CellID->153357612],
Cell[CellGroupData[{
Cell[12071, 416, 348, 11, 70, "Input",
 CellID->965735730],
Cell[12422, 429, 337, 10, 36, "Output",
 CellID->444708437]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12820, 446, 311, 9, 70, "SeeAlsoSection",
 CellID->18569],
Cell[13134, 457, 1721, 62, 70, "SeeAlso",
 CellID->2807]
}, Open  ]],
Cell[CellGroupData[{
Cell[14892, 524, 314, 9, 70, "TutorialsSection",
 CellID->24711],
Cell[15209, 535, 196, 4, 70, "Tutorials",
 CellID->6221],
Cell[15408, 541, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[15584, 549, 319, 9, 70, "MoreAboutSection",
 CellID->647121032],
Cell[15906, 560, 127, 3, 70, "MoreAbout",
 CellID->31079473],
Cell[16036, 565, 140, 3, 70, "MoreAbout",
 CellID->97716509]
}, Open  ]],
Cell[16191, 571, 27, 0, 70, "History"],
Cell[16221, 573, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

