(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18857,        537]
NotebookOptionsPosition[     16067,        443]
NotebookOutlinePosition[     17279,        479]
CellTagsIndexPosition[     17194,        474]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightBlue" :> Documentation`HelpLookup["paclet:ref/LightBlue"],
           "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightBlue\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Colors\"\>", 2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Blue", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Blue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
     "\[LineSeparator]represents the color blue in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"0", ",", "0", ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244372907],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51560461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->13784154]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261164880],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWTtsFFcUHe/PXoNh8a7XzhqbxXHIJjjGsRBZgkMWRQo0kShdYiEkU0Sx
CAUFCk0iSjooKSkpKSkpKSkpKSkpX+7nvbkzZz6rXVuwM/d9zv3f95k/Dh4e
3vvz4OH9uwf9mw8Ojg7v3/27//tfD6ipOhNF0XP6v78S0bujN/n/3Dl6Zn9n
6bdKAypM8YuTv6hCr//JiDnoqfJPzegoqsOIx9pc1Qf/VQI5FocHXGay/uqV
u3XLDYduNHIvXrjotyml2eWf5pcv7vZtt7/v3rxx7965t2/d4SGDf/7sohtT
Iv8oNCEQzuvXzvcTOknMuKNj4ZLyJCu/NoR+/z7g/hp7ju3agCfPrjx54poy
i+Qivfn1usxaBl6XAvbOjtDzQpOdyPz8+kvJLJpCE23Wp0+u33dk6YJZ20KT
L8n0/HpS6KdP3aNHQu/Fs1gPHU1ohEnI0QLQe7k8fhD62TN3dCT0KaCv5c7a
AuzTQF9LSYY8WkD/XMKDAD9+TMwyHvmzLgpNgUDhwK+LQhMjYsevV0tmkePJ
/Tbrwwc3GMAs1udi8N7KivR2IP6GqXhL5nHI7Qbw/15ocis51xAtFhVRZqUy
YRZwsGYoLolJwhqu2XA3WCc5P1OJNOESbMfy/Q7k74J+O0JTURmNhK5NoB+T
im9Zp/iWlYp/5457+bIUv+6sFiT5DIKdWi3JzxWhKRgoJFycmdZfL8FP4iKt
fEhIEpVflY9l+Db0K58QWeGZj2rxqKiURuR1Q7V+RQ3RrbOtNvWEJkeRu1yc
lxb9jXh2UoZvhbba1QN6CzQtQ6HlghYJQ6GaTrxZti3wi6GwJm16sjtaoD9G
65IfL3XDt7V9W8fZeh9nc0bOdoKOYo6mHXLsJCKFvOv5pGNHMOu0MKUyj+Xg
LcsMP3Nl6QAttbkW29DbZEnQdRSvkVHE9mwXSEEWnlCKJaAXwAfJ/RMjdhPy
aBP5QnQJngz1OPBPy1lJeb6byz3tjzCuKp63HFvMYHML7xCyHMttkEXSddLi
OcixnPaGj+58SUK8j7MDxmcl5m9ewMrRdSETrDos+jaVRufq2hCkz8+JTW+1
8y5dwy6AL5opz30DFuo7n/GtVmK29TdzeX8Nem64dA3bdOkaNl+CYvsURbEa
tgl0GYrx3gDeimL2VhTOn3+ytvWccs8Gx6BroAnuwSE71SQ+qybkOhvTTmof
RUW8xcCxpre31QbYajPXz7YvKEbVKI9LYnTOudTKgnGmcWgr/sm0fBrO0bhY
VxQSjkTkV0DxyXUetLwAWvZBywSKrwUqN+o0AJ3WQacFsI7JvQ56DUCvddBr
ISORSn8ONBuAZuugWQLHok8ViNZAO93rWp6dBe1O5WF5v62Bfopl+XAW9DOs
SiiE3ndrIIUiWbYrkp00ElI1kpmhSq7C7C1Ax/3Q6QI0VVPRrJ5tgZY9sEIR
mqq6CtGE+8Ie+NrQ7FRkmuge1U5c27n9pqnssKROFZ2xMPcroB0j8vp0Kac9
c1rVk0jp2SRzI+TS8TfuDKH9dkcwCd9qbAM78+geiJwzHAqtZyJyNTnc+u3M
dGZKPZWvneW6IMcOyNEFOYr4hrMZ+lHXKrsX6EBk7IKd4zMv9fNOd7GEX5YP
0nhGtzjZBVr7YV8ZR2w4u9VSWlol7EA0KDreOVh+KDruPRQV7zXM55fH9LdL
UPGOxTyqqHb6xzuYfNQGaNwKGvtz6JXcfvN7J0atxFFbfOd0BbyD/Z0SGYvv
vX4a07+Ui4qy4h3ccEx/GWrxfeDVMf3dlD31dhTvIuEOr6S/mytjE3yK96Jy
Z5lYY7B/uQSVIGkij5qHKN+DKNd+ymy/6zBU1vyES94PW8RcBw11z2x7BKnn
0lr0vQArzgmhc+6xvR6j0O/1wP6vhGMTULP351jZlC9lEpUTu5fXih7f91f1
i0Bef29KvhIjTUKIvzQQD/3S4JHlG4b/FkH/kiP8t4jVCXjzAMkd/61kbi58
K7kpraRbqnVtSr0eH2teWCHC94l/pTX7JSqa+R89SU8m\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->46366013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 0, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->213172455,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightBlue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightBlue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->102792221],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->232391178],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->173674917]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Blue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 26.7086406}", "context" -> "System`", 
    "keywords" -> {"color", "blue", "rgb color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Blue represents the color blue in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "Blue", "type" -> "Symbol", "uri" -> 
    "ref/Blue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4002, 126, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244372907]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17051, 467}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1976, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2599, 68, 41, 1, 70, "ObjectName",
 CellID->6361],
Cell[2643, 71, 440, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[3120, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3598, 107, 367, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[4002, 126, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244372907],
Cell[CellGroupData[{
Cell[4387, 140, 147, 5, 70, "ExampleSection",
 CellID->51560461],
Cell[CellGroupData[{
Cell[4559, 149, 182, 6, 28, "Input",
 CellID->511908593],
Cell[4744, 157, 262, 8, 121, "Output",
 CellID->13784154]
}, Open  ]],
Cell[CellGroupData[{
Cell[5043, 170, 265, 8, 28, "Input",
 CellID->261164880],
Cell[5311, 180, 2320, 42, 109, "Output",
 Evaluatable->False,
 CellID->46366013]
}, Open  ]],
Cell[CellGroupData[{
Cell[7668, 227, 185, 6, 70, "Input",
 CellID->82364862],
Cell[7856, 235, 5304, 92, 129, 86, 2, "CachedBoxData", "BoxData", "Output",
 CellID->213172455]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13221, 334, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[13535, 345, 1657, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[15229, 412, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[15551, 423, 124, 3, 70, "MoreAbout",
 CellID->102792221],
Cell[15678, 428, 149, 3, 70, "MoreAbout",
 CellID->232391178],
Cell[15830, 433, 163, 3, 70, "MoreAbout",
 CellID->173674917]
}, Open  ]],
Cell[16008, 439, 29, 0, 70, "History"],
Cell[16040, 441, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

