(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16168,        547]
NotebookOptionsPosition[     13013,        440]
NotebookOutlinePosition[     14159,        475]
CellTagsIndexPosition[     14074,        470]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Underlined" :> 
          Documentation`HelpLookup["paclet:ref/Underlined"], "Plain" :> 
          Documentation`HelpLookup["paclet:ref/Plain"], "Italic" :> 
          Documentation`HelpLookup["paclet:ref/Italic"], "FontWeight" :> 
          Documentation`HelpLookup["paclet:ref/FontWeight"], "FontVariations" :> 
          Documentation`HelpLookup["paclet:ref/FontVariations"], "FontSize" :> 
          Documentation`HelpLookup["paclet:ref/FontSize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Underlined\"\>", 2->"\<\"Plain\"\>",
        3->"\<\"Italic\"\>", 4->"\<\"FontWeight\"\>", 
       5->"\<\"FontVariations\"\>", 
       6->"\<\"FontSize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Directives\"\>", 
       4->"\<\"Mathematical Typesetting\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>", 6->"\<\"Text Styling\"\>", 
       7->"\<\"New in 6.0: Formatting & Styling\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Bold", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Bold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
     " \[LineSeparator]represents a bold font weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4550]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "Bold"}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be displayed with fonts bold."
}], "Notes",
 CellID->6941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FontWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontWeight"], "->", "Bold"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " can be negated using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FontWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontWeight"], "->", 
   ButtonBox["Plain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plain"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " uses the bold version of fonts if these exist; otherwise it has no \
effect."
}], "Notes",
 CellID->25994]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220161316],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->162008021],

Cell["Display an expression bold:", "ExampleText",
 CellID->31935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", "Bold"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17072],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    SuperscriptBox["x", "2"], ",", 
    SuperscriptBox["x", "3"]}], "}"}],
  StripOnInput->False,
  FontWeight->Bold]], "Output",
 ImageSize->{92, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491376990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12920],

Cell["Display an expression in its default plain weight: ", "ExampleText",
 CellID->20002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", "Plain"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19202],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    SuperscriptBox["x", "2"], ",", 
    SuperscriptBox["x", "3"]}], "}"}],
  StripOnInput->False,
  FontWeight->Plain,
  FontSlant->Plain,
  FontVariations->{"Underline"->False}]], "Output",
 ImageSize->{91, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12378928]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24466],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underlined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underlined"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plain"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Italic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Italic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontVariations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontVariations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->86705266],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->638208712],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->22634150],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->171857336],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->173147591],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->4384364],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->457135919],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->42335003],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->17838196]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bold - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 26.9898978}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Bold represents a bold font weight.", "synonyms" -> {}, "title" -> 
    "Bold", "type" -> "Symbol", "uri" -> "ref/Bold"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7385, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->220161316]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13931, 463}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2866, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3489, 88, 1569, 37, 70, "ObjectNameGrid"],
Cell[5061, 127, 405, 13, 70, "Usage",
 CellID->4550]
}, Open  ]],
Cell[CellGroupData[{
Cell[5503, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5981, 162, 360, 13, 70, "Notes",
 CellID->6941],
Cell[6344, 177, 348, 13, 70, "Notes",
 CellID->16502],
Cell[6695, 192, 414, 16, 70, "Notes",
 CellID->9793],
Cell[7112, 210, 236, 8, 70, "Notes",
 CellID->25994]
}, Closed]],
Cell[CellGroupData[{
Cell[7385, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220161316],
Cell[CellGroupData[{
Cell[7770, 237, 148, 5, 70, "ExampleSection",
 CellID->162008021],
Cell[7921, 244, 66, 1, 70, "ExampleText",
 CellID->31935],
Cell[CellGroupData[{
Cell[8012, 249, 244, 8, 28, "Input",
 CellID->17072],
Cell[8259, 259, 332, 12, 39, "Output",
 CellID->491376990]
}, Open  ]],
Cell[8606, 274, 121, 3, 70, "ExampleDelimiter",
 CellID->12920],
Cell[8730, 279, 90, 1, 70, "ExampleText",
 CellID->20002],
Cell[CellGroupData[{
Cell[8845, 284, 245, 8, 70, "Input",
 CellID->19202],
Cell[9093, 294, 392, 14, 39, "Output",
 CellID->12378928]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9546, 315, 311, 9, 70, "SeeAlsoSection",
 CellID->24466],
Cell[9860, 326, 1441, 53, 70, "SeeAlso",
 CellID->10828]
}, Open  ]],
Cell[CellGroupData[{
Cell[11338, 384, 318, 9, 70, "MoreAboutSection",
 CellID->86705266],
Cell[11659, 395, 135, 3, 70, "MoreAbout",
 CellID->638208712],
Cell[11797, 400, 174, 3, 70, "MoreAbout",
 CellID->22634150],
Cell[11974, 405, 149, 3, 70, "MoreAbout",
 CellID->171857336],
Cell[12126, 410, 159, 3, 70, "MoreAbout",
 CellID->173147591],
Cell[12288, 415, 167, 3, 70, "MoreAbout",
 CellID->4384364],
Cell[12458, 420, 135, 3, 70, "MoreAbout",
 CellID->457135919],
Cell[12596, 425, 170, 3, 70, "MoreAbout",
 CellID->42335003],
Cell[12769, 430, 172, 3, 70, "MoreAbout",
 CellID->17838196]
}, Open  ]],
Cell[12956, 436, 27, 0, 70, "History"],
Cell[12986, 438, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

