(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21022,        812]
NotebookOptionsPosition[     16126,        640]
NotebookOutlinePosition[     17368,        676]
CellTagsIndexPosition[     17283,        671]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "True" :> Documentation`HelpLookup["paclet:ref/True"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"True\"\>", 4->"\<\"False\"\>", 
       5->"\<\"Integers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Assumptions and Domains\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Booleans", "ObjectName",
 CellID->18166],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Booleans",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Booleans"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of Booleans, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], "Booleans"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30261]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The domain of Booleans is taken to consist of the symbols ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4981],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], "Booleans"}]], "InlineFormula"],
 " evaluates immediately if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is explicitly ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], "\[Element]", "Booleans"}], "]"}]], 
  "InlineFormula"],
 " can be used to try to determine whether an expression is Boolean, with no \
undetermined variables. "
}], "Notes",
 CellID->16461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Booleans",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Booleans"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalB]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29443]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->371864208],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->79601631],

Cell["Constants and variables: ", "ExampleText",
 CellID->1320237096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"True", ",", " ", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1423831668],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874062918]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"x", ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->558399706],

Cell[BoxData[
 RowBox[{"x", "\[Element]", "Booleans"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1587317346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72530497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415637676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "True"}], ",", 
    RowBox[{"y", "\[Rule]", "False"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2000771188]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24523],

Cell[TextData[{
 "Domain for ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->361758379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"p", "&&", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"!", "p"}], "||", 
       RowBox[{"!", "q"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546871196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "True"}], ",", 
    RowBox[{"q", "\[Rule]", "True"}]}], "}"}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1662411990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"a", " ", "&&", " ", 
    RowBox[{"x", "<", "y"}], " ", "&&", " ", 
    RowBox[{"Element", "[", 
     RowBox[{"a", ",", "Booleans"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6464020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "True"}], ",", 
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1396068460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1118941935],

Cell[TextData[{
 "Domain for ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", in this case solving satisfiability:"
}], "ExampleText",
 CellID->542804766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], ",", 
     RowBox[{"p", "||", 
      RowBox[{"q", "&&", 
       RowBox[{"!", "q"}]}]}]}], "]"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1929233769],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316280098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1729511878],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for formatting:"
}], "ExampleText",
 CellID->1714971401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Booleans", " ", "//", " ", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146310220],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalB]",
   Function[{}, Booleans]], TraditionalForm]], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->697580761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8388],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to determine whether an expression is Boolean, with no undetermined \
variables:"
}], "ExampleText",
 CellID->1447085826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["n", "2"], "<", 
     SuperscriptBox[
      RowBox[{"EulerPhi", "[", "n", "]"}], "3"]}], "\[Element]", "Booleans"}],
    ",", 
   RowBox[{
    RowBox[{"n", ">", "42"}], "&&", 
    RowBox[{"n", "\[Element]", "Integers"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->919175307],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1126621154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->788],

Cell[TextData[{
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 " are not used to stand for ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->644934232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"0", ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1059670815],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758419679]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"1", ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354262450],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1444100008]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12245],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->3696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->343043981]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Booleans - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 27.3492820}", "context" -> "System`", 
    "keywords" -> {"Booleans", "False", "logic values", "True"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Booleans represents the domain of Booleans, as in x \\[Element] \
Booleans. ", "synonyms" -> {}, "title" -> "Booleans", "type" -> "Symbol", 
    "uri" -> "ref/Booleans"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5531, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->371864208]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17140, 664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2096, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2719, 77, 46, 1, 70, "ObjectName",
 CellID->18166],
Cell[2768, 80, 568, 18, 70, "Usage",
 CellID->30261]
}, Open  ]],
Cell[CellGroupData[{
Cell[3373, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3851, 120, 346, 13, 70, "Notes",
 CellID->4981],
Cell[4200, 135, 506, 20, 70, "Notes",
 CellID->941],
Cell[4709, 157, 366, 12, 70, "Notes",
 CellID->16461],
Cell[5078, 171, 416, 15, 70, "Notes",
 CellID->29443]
}, Closed]],
Cell[CellGroupData[{
Cell[5531, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->371864208],
Cell[CellGroupData[{
Cell[5916, 205, 147, 5, 70, "ExampleSection",
 CellID->79601631],
Cell[6066, 212, 69, 1, 70, "ExampleText",
 CellID->1320237096],
Cell[CellGroupData[{
Cell[6160, 217, 142, 4, 28, "Input",
 CellID->1423831668],
Cell[6305, 223, 161, 5, 36, "Output",
 CellID->874062918]
}, Open  ]],
Cell[CellGroupData[{
Cell[6503, 233, 133, 4, 28, "Input",
 CellID->558399706],
Cell[6639, 239, 197, 6, 36, "Output",
 CellID->1587317346]
}, Open  ]],
Cell[6851, 248, 124, 3, 70, "ExampleDelimiter",
 CellID->72530497],
Cell[CellGroupData[{
Cell[7000, 255, 253, 8, 70, "Input",
 CellID->415637676],
Cell[7256, 265, 298, 10, 36, "Output",
 CellID->2000771188]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7603, 281, 216, 7, 70, "ExampleSection",
 CellID->24523],
Cell[7822, 290, 202, 8, 70, "ExampleText",
 CellID->361758379],
Cell[CellGroupData[{
Cell[8049, 302, 342, 12, 70, "Input",
 CellID->546871196],
Cell[8394, 316, 297, 10, 36, "Output",
 CellID->1662411990]
}, Open  ]],
Cell[CellGroupData[{
Cell[8728, 331, 338, 10, 70, "Input",
 CellID->6464020],
Cell[9069, 343, 335, 11, 36, "Output",
 CellID->1396068460]
}, Open  ]],
Cell[9419, 357, 126, 3, 70, "ExampleDelimiter",
 CellID->1118941935],
Cell[9548, 362, 229, 8, 70, "ExampleText",
 CellID->542804766],
Cell[CellGroupData[{
Cell[9802, 374, 324, 11, 70, "Input",
 CellID->1929233769],
Cell[10129, 387, 161, 5, 36, "Output",
 CellID->316280098]
}, Open  ]],
Cell[10305, 395, 126, 3, 70, "ExampleDelimiter",
 CellID->1729511878],
Cell[10434, 400, 208, 7, 70, "ExampleText",
 CellID->1714971401],
Cell[CellGroupData[{
Cell[10667, 411, 125, 3, 70, "Input",
 CellID->2146310220],
Cell[10795, 416, 263, 8, 50, "Output",
 CellID->697580761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11107, 430, 222, 7, 70, "ExampleSection",
 CellID->8388],
Cell[11332, 439, 268, 9, 70, "ExampleText",
 CellID->1447085826],
Cell[CellGroupData[{
Cell[11625, 452, 381, 13, 70, "Input",
 CellID->919175307],
Cell[12009, 467, 162, 5, 36, "Output",
 CellID->1126621154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12220, 478, 224, 7, 70, "ExampleSection",
 CellID->788],
Cell[12447, 487, 411, 16, 70, "ExampleText",
 CellID->644934232],
Cell[CellGroupData[{
Cell[12883, 507, 134, 4, 70, "Input",
 CellID->1059670815],
Cell[13020, 513, 162, 5, 36, "Output",
 CellID->758419679]
}, Open  ]],
Cell[CellGroupData[{
Cell[13219, 523, 133, 4, 70, "Input",
 CellID->354262450],
Cell[13355, 529, 163, 5, 36, "Output",
 CellID->1444100008]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13579, 541, 311, 9, 70, "SeeAlsoSection",
 CellID->23900],
Cell[13893, 552, 1169, 44, 70, "SeeAlso",
 CellID->3650]
}, Open  ]],
Cell[CellGroupData[{
Cell[15099, 601, 314, 9, 70, "TutorialsSection",
 CellID->12245],
Cell[15416, 612, 143, 3, 70, "Tutorials",
 CellID->3696]
}, Open  ]],
Cell[CellGroupData[{
Cell[15596, 620, 299, 8, 70, "MoreAboutSection"],
Cell[15898, 630, 156, 3, 70, "MoreAbout",
 CellID->343043981]
}, Open  ]],
Cell[16069, 636, 27, 0, 70, "History"],
Cell[16099, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

