(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42194,        968]
NotebookOptionsPosition[     38970,        860]
NotebookOutlinePosition[     40269,        898]
CellTagsIndexPosition[     40184,        893]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Top" :> Documentation`HelpLookup["paclet:ref/Top"], "Center" :> 
         Documentation`HelpLookup["paclet:ref/Center"], "Axis" :> 
         Documentation`HelpLookup["paclet:ref/Axis"], "Baseline" :> 
         Documentation`HelpLookup["paclet:ref/Baseline"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Top\"\>", 2->"\<\"Center\"\>", 3->"\<\"Axis\"\>", 
      4->"\<\"Baseline\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bottom", "ObjectName",
 CellID->1616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Bottom",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the bottom for purposes of \
alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->470644473],

Cell["Align the contents of a grid to the bottom:", "ExampleText",
 CellID->94306447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      SqrtBox["x"], ",", "b", ",", 
      FractionBox["x", "y"], ",", "c"}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Bottom"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176068346],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     SqrtBox["x"], "b", 
     FractionBox["x", "y"], "c"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Automatic}}, "Rows" -> {{Bottom}}},
   GridBoxFrame->{"Columns" -> True, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{102, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275211971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->825938041],

Cell[TextData[{
 "Place the control of ",
 Cell[BoxData[
  ButtonBox["MenuView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuView"]], "InlineFormula"],
 " at the bottom of the panel:"
}], "ExampleText",
 CellID->156257647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MenuView", "[", 
  RowBox[{
   RowBox[{"Range", "[", "2", "]"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115448565],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    StyleBox[
     PanelBox[
      TagBox[GridBox[{
         {
          ItemBox[
           StyleBox[Cell[BoxData[
             PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
              Alignment->{Left, Top},
              ImageSize->All]],
             Background->GrayLevel[1]],
            Deployed->False,
            StripOnInput->False],
           Background->GrayLevel[1],
           Frame->True,
           FrameStyle->GrayLevel[0.8235294117647058],
           StripOnInput->False]},
         {
          ItemBox[
           PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
            DefaultBaseStyle->"MenuViewLabel",
            Enabled->Automatic],
           Alignment->Left,
           StripOnInput->False]}
        },
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        RowsEqual->False],
       "Grid"],
      BaselinePosition->Automatic,
      DefaultBaseStyle->"MenuView",
      FrameMargins->6,
      ImageMargins->Automatic],
     Deployed->True,
     StripOnInput->False],
    MenuView[{1, 2}, ControlPlacement -> Bottom]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{70, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167390359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleText",
 CellID->467567170],

Cell["Align the bottom of a grid with the baseline of the text:", \
"ExampleText",
 CellID->458844947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94197876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Bottom,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->503826134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338216689],

Cell["Align text to the bottom of the enclosing graphic:", "ExampleText",
 CellID->125552549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Bottom"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Bottom"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186093363],

Cell[BoxData[
 GraphicsBox[{
   InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.}], {Automatic, Bottom}], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->504656970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493017311],

Cell["View 3D objects from the bottom:", "ExampleText",
 CellID->727675960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Bottom"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198155887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ViewPoint->Bottom,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->494636835]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4530],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Top",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Top"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Baseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Baseline"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10072]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bottom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 29.4743364}", "context" -> "System`", 
    "keywords" -> {
     "view point", "view position", "camera position", "grid alignment", 
      "control placement"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Bottom is a symbol that represents the bottom for purposes of alignment \
and positioning. ", "synonyms" -> {}, "title" -> "Bottom", "type" -> "Symbol",
     "uri" -> "ref/Bottom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1980, 66, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40050, 886}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 810, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1433, 44, 43, 1, 70, "ObjectName",
 CellID->1616],
Cell[1479, 47, 464, 14, 70, "Usage",
 CellID->26358]
}, Open  ]],
Cell[CellGroupData[{
Cell[1980, 66, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2357, 80, 148, 5, 70, "ExampleSection",
 CellID->470644473],
Cell[2508, 87, 85, 1, 70, "ExampleText",
 CellID->94306447],
Cell[CellGroupData[{
Cell[2618, 92, 471, 15, 42, "Input",
 CellID->176068346],
Cell[3092, 109, 511, 16, 48, "Output",
 CellID->275211971]
}, Open  ]],
Cell[3618, 128, 125, 3, 70, "ExampleDelimiter",
 CellID->825938041],
Cell[3746, 133, 231, 8, 70, "ExampleText",
 CellID->156257647],
Cell[CellGroupData[{
Cell[4002, 145, 210, 6, 28, "Input",
 CellID->115448565],
Cell[4215, 153, 1472, 47, 82, "Output",
 CellID->167390359]
}, Open  ]],
Cell[5702, 203, 120, 3, 70, "ExampleText",
 CellID->467567170],
Cell[5825, 208, 102, 2, 70, "ExampleText",
 CellID->458844947],
Cell[CellGroupData[{
Cell[5952, 214, 451, 15, 70, "Input",
 CellID->94197876],
Cell[6406, 231, 559, 18, 62, "Output",
 CellID->503826134]
}, Open  ]],
Cell[6980, 252, 125, 3, 70, "ExampleDelimiter",
 CellID->338216689],
Cell[7108, 257, 93, 1, 70, "ExampleText",
 CellID->125552549],
Cell[CellGroupData[{
Cell[7226, 262, 514, 15, 70, "Input",
 CellID->186093363],
Cell[7743, 279, 353, 11, 121, "Output",
 CellID->504656970]
}, Open  ]],
Cell[8111, 293, 125, 3, 70, "ExampleDelimiter",
 CellID->493017311],
Cell[8239, 298, 75, 1, 70, "ExampleText",
 CellID->727675960],
Cell[CellGroupData[{
Cell[8339, 303, 495, 16, 70, "Input",
 CellID->198155887],
Cell[8837, 321, 28768, 479, 131, "Output",
 CellID->494636835]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37666, 807, 310, 9, 70, "SeeAlsoSection",
 CellID->4530],
Cell[37979, 818, 919, 35, 70, "SeeAlso",
 CellID->10072]
}, Open  ]],
Cell[38913, 856, 27, 0, 70, "History"],
Cell[38943, 858, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

