(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115605,       4206]
NotebookOptionsPosition[     97303,       3563]
NotebookOutlinePosition[     99058,       3615]
CellTagsIndexPosition[     98946,       3609]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DefaultButton" :> 
          Documentation`HelpLookup["paclet:ref/DefaultButton"], 
          "CancelButton" :> 
          Documentation`HelpLookup["paclet:ref/CancelButton"], "PasteButton" :> 
          Documentation`HelpLookup["paclet:ref/PasteButton"], "Hyperlink" :> 
          Documentation`HelpLookup["paclet:ref/Hyperlink"], "ActionMenu" :> 
          Documentation`HelpLookup["paclet:ref/ActionMenu"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"], "RadioButton" :> 
          Documentation`HelpLookup["paclet:ref/RadioButton"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "ButtonNotebook" :> 
          Documentation`HelpLookup["paclet:ref/ButtonNotebook"], 
          "DialogReturn" :> 
          Documentation`HelpLookup["paclet:ref/DialogReturn"], "PopupWindow" :> 
          Documentation`HelpLookup["paclet:ref/PopupWindow"], "ClickPane" :> 
          Documentation`HelpLookup["paclet:ref/ClickPane"], "Trigger" :> 
          Documentation`HelpLookup["paclet:ref/Trigger"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DefaultButton\"\>", 2->"\<\"CancelButton\"\>", 
       3->"\<\"PasteButton\"\>", 4->"\<\"Hyperlink\"\>", 
       5->"\<\"ActionMenu\"\>", 6->"\<\"Setter\"\>", 7->"\<\"RadioButton\"\>",
        8->"\<\"Panel\"\>", 9->"\<\"Dynamic\"\>", 10->"\<\"Input\"\>", 
       11->"\<\"ButtonNotebook\"\>", 12->"\<\"DialogReturn\"\>", 
       13->"\<\"PopupWindow\"\>", 14->"\<\"ClickPane\"\>", 
       15->"\<\"Trigger\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 3->"\<\"Dialog Boxes\"\>", 
       4->"\<\"Palettes\"\>", 5->"\<\"Stand-Alone Interfaces\"\>", 
       6->"\<\"Toolbars\"\>", 
       7->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Button", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Button",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Button"], "[", 
       RowBox[{
        StyleBox["label", "TI"], ",", 
        StyleBox["action", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a button that is labeled with ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     ", and evaluates ",
     Cell[BoxData[
      StyleBox["action", "TI"]], "InlineFormula"],
     " whenever it is pressed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " can be any expression, including a dynamic one."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " by default displays ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<Button\>\""], "InlineFormula"],
 " style, which typically uses the system button font. "
}], "Notes",
 CellID->21110],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"], "[", 
   RowBox[{
    StyleBox["label", "TI"], ",", 
    StyleBox["action", "TI"]}], "]"}]], "InlineFormula"],
 " maintains ",
 Cell[BoxData[
  StyleBox["action", "TI"]], "InlineFormula"],
 " in unevaluated form, evaluating it each time the button is pressed. "
}], "Notes",
 CellID->32480],

Cell["The following options can be given: ", "Notes",
 CellID->31604],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align contents within the button", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the button ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to press the button automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "button background color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the button", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the button is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the kernel in which to evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "minimum margins to leave inside the frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed button ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "the overall image size of the displayed button ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], "\"\<Preemptive\>\"", Cell[
    "the evaluation method to use ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->15154],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " a button will be sized to fill out its enclosing region in a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or related construct. "
}], "Notes",
 CellID->27322],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that the button will be sized to fit its contents, but will not \
expand to fill out an enclosing region."
}], "Notes",
 CellID->58640300],

Cell[TextData[{
 "Settings of ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " specify buttons with certain system-standard minimum sizes."
}], "Notes",
 CellID->298564569],

Cell[TextData[{
 "Typical possible settings for the ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " option include ",
 Cell[BoxData["\"\<DialogBox\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Frameless\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Palette\>\""], "InlineFormula"],
 ". In some cases, ",
 Cell[BoxData["\"\<AbuttingLeftRight\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AbuttingRight\>\""], "InlineFormula"],
 ", etc. are also supported."
}], "Notes",
 CellID->12747],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", "\"\<Pressed\>\""}]], 
  "InlineFormula"],
 " gives a button with a pressed appearance. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["type", "TI"], ",", "\"\<Pressed\>\""}], "}"}]}]], 
  "InlineFormula"],
 " gives a button of a certain type with a pressed appearance."
}], "Notes",
 CellID->514171523],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " is displayed literally, without being placed in a button."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1703],

Cell[TextData[{
 "Typical possible settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option include ",
 Cell[BoxData["\"\<Preemptive\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Queued\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1227],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Button\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->399660119],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"], "[", 
   StyleBox["label", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " displays as a button labeled with ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 ", but performs no action."
}], "Notes",
 CellID->32535],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"], "[", 
   RowBox[{
    StyleBox["prims", "TI"], ",", 
    StyleBox["action", "TI"]}], "]"}]], "InlineFormula"],
 " can be used within graphics objects to specify that ",
 Cell[BoxData[
  StyleBox["action", "TI"]], "InlineFormula"],
 " should be evaluated whenever the graphics primitives ",
 Cell[BoxData[
  StyleBox["prims", "TI"]], "InlineFormula"],
 " are clicked."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->127659472]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204346735],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->952696652],

Cell["Create a button that prints a number:", "ExampleText",
 CellID->20921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Click Here\>\"", ",", 
   RowBox[{"Print", "[", 
    RowBox[{"10", "!"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27465],

Cell[BoxData[
 ButtonBox["\<\"Click Here\"\>",
  Appearance->"DialogBox",
  ButtonData->"paclet:ref/Click Here",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[
    Factorial[10]],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{61, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23005]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14705],

Cell[CellGroupData[{

Cell[TextData[{
 "Button Content",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSubsection",
 CellID->311729416],

Cell[TextData[{
 "Use any expression as labels: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24904]
}], "ExampleText",
 CellID->993536701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", "a", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[MathematicaIcon]\>\"", ",", "Large"}], "]"}], ",", 
       "\"\<string\>\"", ",", 
       RowBox[{"Framed", "[", 
        RowBox[{"x", "+", "y"}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1889358125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox[
    StyleBox["\<\"\[MathematicaIcon]\"\>",
     StripOnInput->False,
     FontSize->Large],
    Appearance->Automatic,
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"string\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/string",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"], ",", 
   ButtonBox[
    FrameBox[
     RowBox[{"x", "+", "y"}],
     StripOnInput->False],
    Appearance->Automatic,
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"], ",", 
   ButtonBox[
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20],
    Appearance->Automatic,
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{195, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299518974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411329874],

Cell[TextData[{
 "Use a dynamic label: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24904]
}], "ExampleText",
 CellID->605355859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"Button", "[", 
   RowBox[{
    RowBox[{"Dynamic", "[", "x", "]"}], ",", 
    RowBox[{"x", "++"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1585886374],

Cell[BoxData[
 ButtonBox[
  DynamicBox[ToBoxes[$CellContext`x, StandardForm],
   ImageSizeCache->{6., {0., 6.}}],
  Appearance->Automatic,
  ButtonFrame->"DialogBox",
  ButtonFunction:>Increment[$CellContext`x],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{20, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46399337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305194257],

Cell[TextData[{
 "Use a graphics primitive as button: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->127659472]
}], "ExampleText",
 CellID->699182426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Button", "[", 
   RowBox[{
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"SelectionMove", "[", 
     RowBox[{
      RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}], 
     "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128517398],

Cell[BoxData[
 GraphicsBox[
  TagBox[DiskBox[{0, 0}],
   EventHandlerTag[{"MouseClicked" :> SelectionMove[
       ButtonNotebook[], All, ButtonCell], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53228971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Button Control",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSubsection",
 CellID->1523679679],

Cell[TextData[{
 "Create a list of buttons; use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " to ensure evaluation of ",
 Cell[BoxData["i"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "i"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"i", ",", 
       RowBox[{"Print", "[", 
        RowBox[{"i", "!"}], "]"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["1",
    Appearance->Automatic,
    ButtonData->"paclet:ref/1",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[1]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["2",
    Appearance->Automatic,
    ButtonData->"paclet:ref/2",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[2]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["3",
    Appearance->Automatic,
    ButtonData->"paclet:ref/3",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[3]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["4",
    Appearance->Automatic,
    ButtonData->"paclet:ref/4",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[4]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["5",
    Appearance->Automatic,
    ButtonData->"paclet:ref/5",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[5]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["6",
    Appearance->Automatic,
    ButtonData->"paclet:ref/6",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[6]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["7",
    Appearance->Automatic,
    ButtonData->"paclet:ref/7",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[7]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["8",
    Appearance->Automatic,
    ButtonData->"paclet:ref/8",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[8]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["9",
    Appearance->Automatic,
    ButtonData->"paclet:ref/9",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[9]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["10",
    Appearance->Automatic,
    ButtonData->"paclet:ref/10",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[10]],
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{285, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467254941]
}, Open  ]],

Cell["Another way to get the contents of a button evaluated:", "ExampleText",
 CellID->30534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Print", "[", 
      RowBox[{"#", "!"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["1",
    Appearance->Automatic,
    ButtonData->"paclet:ref/1",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[1]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["2",
    Appearance->Automatic,
    ButtonData->"paclet:ref/2",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[2]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["3",
    Appearance->Automatic,
    ButtonData->"paclet:ref/3",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[3]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["4",
    Appearance->Automatic,
    ButtonData->"paclet:ref/4",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[4]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["5",
    Appearance->Automatic,
    ButtonData->"paclet:ref/5",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[5]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["6",
    Appearance->Automatic,
    ButtonData->"paclet:ref/6",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[6]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["7",
    Appearance->Automatic,
    ButtonData->"paclet:ref/7",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[7]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["8",
    Appearance->Automatic,
    ButtonData->"paclet:ref/8",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[8]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["9",
    Appearance->Automatic,
    ButtonData->"paclet:ref/9",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[9]],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["10",
    Appearance->Automatic,
    ButtonData->"paclet:ref/10",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Print[
      Factorial[10]],
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{285, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31669008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670078793],

Cell[TextData[{
 "Display the label literally, without the appearance of a button: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1703]
}], "ExampleText",
 CellID->1922176848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{
   RowBox[{"Mouseover", "[", 
    RowBox[{"fish", ",", 
     RowBox[{"Style", "[", 
      RowBox[{"fish", ",", "Red"}], "]"}]}], "]"}], ",", "1", ",", 
   RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1359],

Cell[BoxData[
 ButtonBox[
  PaneSelectorBox[{False->"fish", True->
   StyleBox["fish",
    StripOnInput->False,
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}, Dynamic[
    CurrentValue["MouseOver"]],
   FrameMargins->0,
   ImageSize->Automatic],
  Appearance->None,
  ButtonFrame->None,
  ButtonFunction:>1,
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{21, 13},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193373602]
}, Open  ]],

Cell[TextData[{
 "Create your own ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 ": ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1703]
}], "ExampleText",
 CellID->1429782515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"\"\<link\>\"", ",", "\"\<Hyperlink\>\""}], "]"}], ",", "1", ",", 
   
   RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12719675],

Cell[BoxData[
 ButtonBox[
  StyleBox["\<\"link\"\>", "Hyperlink",
   StripOnInput->False],
  Appearance->None,
  ButtonFrame->None,
  ButtonFunction:>1,
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{19, 13},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1296907]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2526],

Cell["Get the mouse position, in screen coordinates: ", "ExampleText",
 CellID->23271697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{"MousePosition", "[", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7208],

Cell[BoxData[
 ButtonBox[
  GraphicsBox[DiskBox[{0, 0}]],
  Appearance->Automatic,
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[
    MousePosition[]],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25267405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"668", ",", "522"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->162128034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363136369],

Cell["Get the mouse position, in graphics coordinates: ", "ExampleText",
 CellID->273765216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104598850],

Cell[BoxData[
 ButtonBox[
  GraphicsBox[DiskBox[{0, 0}]],
  Appearance->Automatic,
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[
    MousePosition["Graphics"]],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71626710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.27351024208566144`", ",", "0.24856610800744885`"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->15845955]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->49738227],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->566567855],

Cell["Different predefined alignment options:", "ExampleText",
 CellID->569627317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "50"}], "}"}]}], ",", 
       RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618910655],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ButtonBox["\<\"y\"\>",
    Alignment->Top,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Center,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Bottom,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"]}],
  Row[{
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Top], 
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Center], 
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{106, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584138253]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4499585],

Cell["Predefined button appearances:", "ExampleText",
 CellID->387788436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<DialogBox\>\"", ",", "\"\<Palette\>\"", ",", "\"\<Frameless\>\""}],
       "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->993682088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->"DialogBox",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Palette",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"Palette",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Frameless",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"Frameless",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{111, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48875376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155664593],

Cell["On some platforms, the following appearances also defined:", \
"ExampleText",
 CellID->2094858854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<AbuttingLeft\>\"", ",", "\"\<AbuttingRight\>\""}], "}"}]}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1024882956],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{94, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1267058328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31630761],

Cell["\<\
Use a second element to get the appearance of a pressed button:\
\>", "ExampleText",
 CellID->2090955629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"Appearance", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "\"\<Pressed\>\""}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<DialogBox\>\"", ",", "\"\<Palette\>\""}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702742541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->{"DialogBox", "Pressed"},
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->{"Palette", "Pressed"},
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"Palette",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{80, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37791802]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5467863],

Cell["\<\
By default the button function does not evaluate until you click on it:\
\>", "ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Button", "[", 
     RowBox[{"\"\<xxx\>\"", ",", 
      RowBox[{"x", "++"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2083591643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Increment[$CellContext`x],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{65, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340512590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236942049],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the button function evaluates as you mouse over the button area:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Button", "[", 
     RowBox[{"\"\<yyy\>\"", ",", 
      RowBox[{"y", "++"}], ",", 
      RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29537832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"yyy\"\>",
    Appearance->Automatic,
    AutoAction->True,
    ButtonData->"paclet:ref/yyy",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Increment[$CellContext`y],
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{65, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10898741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->112768781],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155850066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    Background->RGBColor[1, 0.5, 0.5],
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    Background->RGBColor[0, 1, 0],
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    Background->GrayLevel[0.5],
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    Background->RGBColor[1, 1, 0],
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{140, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1705940604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425224822],

Cell["Change the background color on every click:", "ExampleText",
 CellID->375560463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"x", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"1", "/", "10"}]}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Hue", "[", "x", "]"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179308],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = Rational[2, 5]}, 
  ButtonBox["\<\"xxx\"\>",
   Appearance->Automatic,
   Background->Dynamic[
     Hue[$CellContext`x$$]],
   ButtonData->"paclet:ref/xxx",
   ButtonFrame->"DialogBox",
   ButtonFunction:>($CellContext`x$$ = Mod[$CellContext`x$$ + 1/10, 1]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253056403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->166336729],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->555827094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340562913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    BaselinePosition->Top,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    BaselinePosition->Center,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    BaselinePosition->Bottom,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"]}],
  Row[{
    Button["xxx", Null, BaselinePosition -> Top], 
    Button["xxx", Null, BaselinePosition -> Center], 
    Button["xxx", Null, BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{142, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137906829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1041677070],

Cell["Change the baseline position on every button click:", "ExampleText",
 CellID->353206981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<xxx\>\"", ",", 
        RowBox[{"x", "=", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"x", "+", "1"}], ",", "3", ",", "1"}], "]"}]}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"Part", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}], ",", "x"}],
            "]"}], "]"}]}]}], "]"}], ",", "\"\<x\>\""}], "}"}], "//", 
    "Row"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385391123],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 3}, 
  InterpretationBox[
   RowBox[{"\<\"x\"\>", "\[InvisibleSpace]", 
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     BaselinePosition->Dynamic[
       Part[{Top, Center, Bottom}, $CellContext`x$$]],
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>($CellContext`x$$ = Mod[$CellContext`x$$ + 1, 3, 1]),
     Evaluator->Automatic,
     Method->"Preemptive"], "\[InvisibleSpace]", "\<\"x\"\>"}],
   Row[{"x", 
     Button[
     "xxx", $CellContext`x$$ = Mod[$CellContext`x$$ + 1, 3, 1], 
      BaselinePosition -> Dynamic[
        Part[{Top, Center, Bottom}, $CellContext`x$$]]], "x"}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{46, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->933861131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25014151],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<aaa\>\"", ",", "Null"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 ButtonBox["\<\"aaa\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/aaa",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Null,
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{32, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62262819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496435830],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the button is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<aaa\>\"", ",", "Null", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 ButtonBox["\<\"aaa\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/aaa",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Null,
  Enabled->False,
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{32, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349817533]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Evaluator",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->232464115],

Cell["\<\
By default the button function is sent to kernel for evaluation:\
\>", "ExampleText",
 CellID->96906759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Kernel\>\"", ",", 
   RowBox[{"SelectionMove", "[", 
    RowBox[{
     RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1786402438],

Cell[BoxData[
 ButtonBox["\<\"Kernel\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Kernel",
  ButtonFrame->"DialogBox",
  ButtonFunction:>SelectionMove[
    ButtonNotebook[], All, ButtonCell],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{44, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29699695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283531173],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Evaluator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
 ", the button function is evaluated in the front end:"
}], "ExampleText",
 CellID->1578363691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Front End\>\"", ",", 
   RowBox[{"SelectionMove", "[", 
    RowBox[{
     RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}], 
    "]"}], ",", 
   RowBox[{"Evaluator", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1840546893],

Cell[BoxData[
 ButtonBox["\<\"Front End\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Front End",
  ButtonFrame->"DialogBox",
  ButtonFunction:>SelectionMove[
    ButtonNotebook[], All, ButtonCell],
  Evaluator->None,
  Method->"Preemptive"]], "Output",
 ImageSize->{61, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349801740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70437627],

Cell["Not all functionalities are available in the front end:", "ExampleText",
 CellID->73049552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<No Front End\>\"", ",", 
   RowBox[{"Print", "[", "10", "]"}], ",", 
   RowBox[{"Evaluator", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1530658027],

Cell[BoxData[
 ButtonBox["\<\"No Front End\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/No Front End",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[10],
  Evaluator->None,
  Method->"Preemptive"]], "Output",
 ImageSize->{77, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229987244]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->837226577],

Cell["\<\
By setting FrameMargins you make the button content area larger:\
\>", "ExampleText",
 CellID->592492429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2099775161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    FrameMargins->0,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    FrameMargins->5,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    FrameMargins->10,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    FrameMargins->20,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{218, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486104472]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->527576866],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " you make the button area larger:"
}], "ExampleText",
 CellID->33301087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405109056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>Null,
     Evaluator->Automatic,
     ImageMargins->0,
     Method->"Preemptive"],
    StripOnInput->False], ",", 
   FrameBox[
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>Null,
     Evaluator->Automatic,
     ImageMargins->5,
     Method->"Preemptive"],
    StripOnInput->False], ",", 
   FrameBox[
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>Null,
     Evaluator->Automatic,
     ImageMargins->10,
     Method->"Preemptive"],
    StripOnInput->False], ",", 
   FrameBox[
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>Null,
     Evaluator->Automatic,
     ImageMargins->20,
     Method->"Preemptive"],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{274, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1144743202]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->220778943],

Cell["Use preset values:", "ExampleText",
 CellID->127350395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234360116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    ImageSize->Tiny,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    ImageSize->Small,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    ImageSize->Medium,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    ImageSize->Large,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{164, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1293283300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11032924],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Button", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
      RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "100", ",", "150", ",", "200"}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289053222],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>Null,
      Evaluator->Automatic,
      ImageSize->50,
      Method->"Preemptive"]},
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>Null,
      Evaluator->Automatic,
      ImageSize->100,
      Method->"Preemptive"]},
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>Null,
      Evaluator->Automatic,
      ImageSize->150,
      Method->"Preemptive"]},
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>Null,
      Evaluator->Automatic,
      ImageSize->200,
      Method->"Preemptive"]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{204, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->714985696]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81570851],

Cell["\<\
By setting the second element you can also control the height:\
\>", "ExampleText",
 CellID->25763139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "50"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643525534],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/xxx",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Null,
  Evaluator->Automatic,
  ImageSize->{Automatic, 50},
  Method->"Preemptive"]], "Output",
 ImageSize->{32, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1593587707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490623302],

Cell["A fully custom image size:", "ExampleText",
 CellID->39865681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "50"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700558927],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/xxx",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Null,
  Evaluator->Automatic,
  ImageSize->{100, 50},
  Method->"Preemptive"]], "Output",
 ImageSize->{104, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409997749]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->118347657],

Cell["\<\
By default, button functions are evaluated on a preemptive link, which times \
out after 5 seconds:\
\>", "ExampleText",
 CellID->782983146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "=", "\"\<start\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<does time out\>\"", ",", 
       RowBox[{
        RowBox[{"Pause", "[", "6", "]"}], ";", 
        RowBox[{"a", "=", "\"\<end\>\""}]}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "a", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1965429653],

Cell[BoxData[
 DynamicModuleBox[{Cell$$3057`a$$ = "start"}, 
  RowBox[{"{", 
   RowBox[{
    ButtonBox["\<\"does time out\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/does time out",
     ButtonFrame->"DialogBox",
     ButtonFunction:>(Pause[6]; Cell$$3057`a$$ = "end"),
     Evaluator->Automatic,
     Method->"Preemptive"], ",", 
    DynamicBox[ToBoxes[Cell$$3057`a$$, StandardForm],
     ImageSizeCache->{35., {0., 7.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{140, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1602308048]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "\[Rule]", "\"\<Queued\>\""}]], 
  "InlineFormula"],
 " to evaluate button functions on the main link which never times out:"
}], "ExampleText",
 CellID->382719817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "=", "\"\<start\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<does not time out\>\"", ",", 
       RowBox[{
        RowBox[{"Pause", "[", "6", "]"}], ";", 
        RowBox[{"a", "=", "\"\<end\>\""}]}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "a", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658441554],

Cell[BoxData[
 DynamicModuleBox[{Cell$$3057`a$$ = "end"}, 
  RowBox[{"{", 
   RowBox[{
    ButtonBox["\<\"does not time out\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/does not time out",
     ButtonFrame->"DialogBox",
     ButtonFunction:>(Pause[6]; Cell$$3057`a$$ = "end"),
     Evaluator->Automatic,
     Method->"Queued"], ",", 
    DynamicBox[ToBoxes[Cell$$3057`a$$, StandardForm],
     ImageSizeCache->{21., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{145, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->546429356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2040967411],

Cell["\<\
Specify that the stop button event needs to preemptively interrupt an \
evaluation: \
\>", "ExampleText",
 CellID->282711838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Start\>\"", ",", 
     RowBox[{
      RowBox[{"t", "=", "True"}], ";", 
      RowBox[{"x", "=", "0"}], ";", 
      RowBox[{"While", "[", 
       RowBox[{"t", ",", 
        RowBox[{"x", "++"}]}], "]"}]}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Stop\>\"", ",", 
     RowBox[{"t", "=", "False"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Refresh", "[", 
     RowBox[{"x", ",", 
      RowBox[{"UpdateInterval", "\[Rule]", "0"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378791829],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"Start\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/Start",
    ButtonFrame->"DialogBox",
    ButtonFunction:>($CellContext`t = True; $CellContext`x = 0; 
     While[$CellContext`t, 
       Increment[$CellContext`x]]),
    Evaluator->Automatic,
    Method->"Queued"], ",", 
   ButtonBox["\<\"Stop\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/Stop",
    ButtonFrame->"DialogBox",
    ButtonFunction:>($CellContext`t = False),
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   DynamicBox[ToBoxes[
     Refresh[$CellContext`x, UpdateInterval -> 0], StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{114, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250422289]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->65660056],

Cell["Make button that prints the current date:", "ExampleText",
 CellID->450529530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Print Date\>\"", ",", 
   RowBox[{"Print", "[", 
    RowBox[{"DateString", "[", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15357],

Cell[BoxData[
 ButtonBox["\<\"Print Date\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Print Date",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[
    DateString[]],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{62, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365149841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106811598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<New Document\>\"", ",", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "}"}], "]"}]}], "]"}]], "Input",
 CellTags->"Button",
 CellLabel->"In[1]:=",
 CellID->23761],

Cell[BoxData[
 ButtonBox["\<\"New Document\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/New Document",
  ButtonFrame->"DialogBox",
  ButtonFunction:>CreateDocument[{}],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{86, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Button",
 CellLabel->"Out[1]=",
 CellID->524851307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34270821],

Cell["Open the system color selector:", "ExampleText",
 CellID->658548267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Color...\>\"", ",", 
   RowBox[{"SystemDialogInput", "[", "\"\<Color\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->90006831],

Cell[BoxData[
 ButtonBox["\<\"Color...\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Color...",
  ButtonFrame->"DialogBox",
  ButtonFunction:>SystemDialogInput["Color"],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{51, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23760815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->595882948],

Cell["Create a button that deletes itself:", "ExampleText",
 CellID->1154291583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Delete Me\>\"", ",", 
   RowBox[{
    RowBox[{"SelectionMove", "[", 
     RowBox[{
      RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}], 
     "]"}], ";", 
    RowBox[{"NotebookDelete", "[", 
     RowBox[{"ButtonNotebook", "[", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1958852130],

Cell[BoxData[
 ButtonBox["\<\"Delete Me\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Delete Me",
  ButtonFrame->"DialogBox",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell]; NotebookDelete[
     ButtonNotebook[]]),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{62, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45498667]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->149758654],

Cell["Create a grid of tightly spaced buttons:", "ExampleText",
 CellID->1704627867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Button", "[", 
       RowBox[{
        RowBox[{"List", "[", "##", "]"}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Palette\>\""}]}], "]"}], "&"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1977259986],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]},
    {
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]},
    {
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox[
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}],
      Appearance->"Palette",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]}
   },
   GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{97, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134026091]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Button", "[", 
        RowBox[{"#", ",", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Palette\>\""}]}], "]"}], "&"}],
       "/@", 
      RowBox[{"Range", "[", "9", "]"}]}], ",", "3"}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1090204324],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["1",
      Appearance->"Palette",
      ButtonData->"paclet:ref/1",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["2",
      Appearance->"Palette",
      ButtonData->"paclet:ref/2",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["3",
      Appearance->"Palette",
      ButtonData->"paclet:ref/3",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]},
    {
     ButtonBox["4",
      Appearance->"Palette",
      ButtonData->"paclet:ref/4",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["5",
      Appearance->"Palette",
      ButtonData->"paclet:ref/5",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["6",
      Appearance->"Palette",
      ButtonData->"paclet:ref/6",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]},
    {
     ButtonBox["7",
      Appearance->"Palette",
      ButtonData->"paclet:ref/7",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["8",
      Appearance->"Palette",
      ButtonData->"paclet:ref/8",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["9",
      Appearance->"Palette",
      ButtonData->"paclet:ref/9",
      ButtonFrame->"Palette",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]}
   },
   GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{34, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7200908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104634848],

Cell["Create a button that make the button the current selection:", \
"ExampleText",
 CellID->72682333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{
    RowBox[{"SelectionMove", "[", 
     RowBox[{
      RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "ButtonCell"}], 
     "]"}], ";", 
    RowBox[{"SelectionMove", "[", 
     RowBox[{
      RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", "CellContents"}],
      "]"}]}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Frameless\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1162841235],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->"Frameless",
  ButtonData->"paclet:ref/xxx",
  ButtonFrame->"Frameless",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell]; SelectionMove[
     ButtonNotebook[], All, CellContents]),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{24, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8335434]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->810560353],

Cell["Some functions require the kernel to evaluate:", "ExampleText",
 CellID->1159175613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Evaluate\>\"", ",", 
   RowBox[{"Print", "[", "1", "]"}], ",", 
   RowBox[{"Evaluator", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292882107],

Cell[BoxData[
 ButtonBox["\<\"Evaluate\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Evaluate",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Print[1],
  Evaluator->None,
  Method->"Preemptive"]], "Output",
 ImageSize->{56, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38060692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395426126],

Cell[TextData[{
 "Specifying ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " option forces a generic appearance for the button:"
}], "ExampleText",
 CellID->686990886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<DialogBox\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1329193747],

Cell[BoxData[
 ButtonBox["\<\"xxx\"\>",
  Appearance->"DialogBox",
  Background->RGBColor[1, 0.5, 0.5],
  ButtonData->"paclet:ref/xxx",
  ButtonFrame->"DialogBox",
  ButtonFunction:>{},
  Evaluator->None,
  Method->"Preemptive"]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261249284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8823189],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " to control buttons in a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1330051528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<xxx\>\"", ",", 
        RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<xxx\>\"", ",", 
        RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<xxx\>\"", ",", 
        RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}], "}"}], ",", 
     RowBox[{"{", "\"\<zzzzzzzzzzzzzzzzzzzzzzzz\>\"", "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235275180],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      ImageSize->All,
      Method->"Preemptive"]},
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      ImageSize->Automatic,
      Method->"Preemptive"]},
    {
     ButtonBox["\<\"xxx\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/xxx",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      ImageSize->Full,
      Method->"Preemptive"]},
    {"\<\"zzzzzzzzzzzzzzzzzzzzzzzz\"\>"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{182, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36771283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->83961162],

Cell["This button changes color each time you click it:", "ExampleText",
 CellID->8106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "=", "Automatic"}], "}"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"b", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"RGBColor", ",", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}], "]"}]}], 
      "]"}], ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", "b", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"50", ",", "50"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellTags->"Button",
 CellLabel->"In[1]:=",
 CellID->17792],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`b$$ = RGBColor[
  0.06862400125757562, 0.4945468447389765, 0.5587807189901908]}, 
  ButtonBox["\<\"\"\>",
   Appearance->Automatic,
   Background->Dynamic[$CellContext`b$$],
   ButtonData->"paclet:ref/",
   ButtonFrame->"DialogBox",
   ButtonFunction:>Dynamic[$CellContext`b$$ = Apply[RGBColor, 
       RandomReal[{0, 1}, 3]]],
   Evaluator->Automatic,
   ImageSize->{50, 50},
   Method->"Preemptive"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{54, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Button",
 CellLabel->"Out[1]=",
 CellID->389348566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190587858],

Cell["This button changes position every time you click on it:", "ExampleText",
 CellID->177324581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Click Me\>\"", ",", 
          RowBox[{"pt", "=", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "]"}]}]}], 
         "]"}], ",", 
        RowBox[{"Dynamic", "[", "pt", "]"}]}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342747554],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.6286148212502178, 
  0.022294545960772627`}}, 
  FrameBox[
   GraphicsBox[InsetBox[
     ButtonBox["\<\"Click Me\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/Click Me",
      ButtonFrame->"DialogBox",
      ButtonFunction:>($CellContext`pt$$ = RandomReal[{-1, 1}, 2]),
      Evaluator->Automatic,
      Method->"Preemptive"], Dynamic[$CellContext`pt$$]],
    PlotRange->1],
   StripOnInput->False],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259118573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174004883],

Cell["Use a graphics primitive as the button:", "ExampleText",
 CellID->2086773317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", 
       RowBox[{"Button", "[", 
        RowBox[{
         RowBox[{"Disk", "[", 
          RowBox[{"pt", ",", "0.1"}], "]"}], ",", 
         RowBox[{"pt", "=", 
          RowBox[{"RandomReal", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "]"}]}]}], 
        "]"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1843699662],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0.405356434437528, 
  0.6983834254117514}}, 
  FrameBox[
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      Button[
       Disk[$CellContext`pt$$, 0.1], $CellContext`pt$$ = 
       RandomReal[{-1, 1}, 2]], StandardForm, Graphics],
     ImageSizeCache->{{117.5, 135.5}, {-73.875, -55.875}}],
    PlotRange->1],
   StripOnInput->False],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1018676671]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15634],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PasteButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PasteButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ActionMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trigger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trigger"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9376],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1086103],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->457697909],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->77654175],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->431647205],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->204171587],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->350005719],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->329262884],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->100634256]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Button - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 51.9749124}", "context" -> "System`", 
    "keywords" -> {
     "abutting left right", "abutting right", "button action", "button click",
       "button events", "dialog box", "general button"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Button[label, action] represents a button that is labeled with label, \
and evaluates action whenever it is pressed. ", "synonyms" -> {}, "title" -> 
    "Button", "type" -> "Symbol", "uri" -> "ref/Button"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17621, 531, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->204346735]},
 "Button"->{
  Cell[72482, 2628, 223, 7, 70, "Input",
   CellTags->"Button",
   CellID->23761],
  Cell[72708, 2637, 391, 13, 70, "Output",
   CellTags->"Button",
   CellID->524851307],
  Cell[86450, 3173, 752, 23, 70, "Input",
   CellTags->"Button",
   CellID->17792],
  Cell[87205, 3198, 638, 19, 70, "Output",
   CellTags->"Button",
   CellID->389348566]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 98443, 3589},
 {"Button", 98577, 3593}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4223, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4846, 111, 1571, 37, 70, "ObjectNameGrid"],
Cell[6420, 150, 740, 23, 70, "Usage",
 CellID->32756]
}, Open  ]],
Cell[CellGroupData[{
Cell[7197, 178, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7675, 195, 205, 6, 70, "Notes",
 CellID->24904],
Cell[7883, 203, 363, 12, 70, "Notes",
 CellID->21110],
Cell[8249, 217, 416, 14, 70, "Notes",
 CellID->32480],
Cell[8668, 233, 69, 1, 70, "Notes",
 CellID->31604],
Cell[8740, 236, 3927, 107, 70, "3ColumnTableMod",
 CellID->15154],
Cell[12670, 345, 503, 17, 70, "Notes",
 CellID->27322],
Cell[13176, 364, 418, 13, 70, "Notes",
 CellID->58640300],
Cell[13597, 379, 736, 28, 70, "Notes",
 CellID->298564569],
Cell[14336, 409, 583, 18, 70, "Notes",
 CellID->12747],
Cell[14922, 429, 568, 19, 70, "Notes",
 CellID->514171523],
Cell[15493, 450, 457, 16, 70, "Notes",
 CellID->1703],
Cell[15953, 468, 340, 12, 70, "Notes",
 CellID->1227],
Cell[16296, 482, 343, 10, 70, "Notes",
 CellID->399660119],
Cell[16642, 494, 365, 12, 70, "Notes",
 CellID->32535],
Cell[17010, 508, 574, 18, 70, "Notes",
 CellID->127659472]
}, Closed]],
Cell[CellGroupData[{
Cell[17621, 531, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204346735],
Cell[CellGroupData[{
Cell[18006, 545, 148, 5, 70, "ExampleSection",
 CellID->952696652],
Cell[18157, 552, 76, 1, 70, "ExampleText",
 CellID->20921],
Cell[CellGroupData[{
Cell[18258, 557, 192, 6, 28, "Input",
 CellID->27465],
Cell[18453, 565, 371, 13, 46, "Output",
 CellID->23005]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18873, 584, 216, 7, 70, "ExampleSection",
 CellID->14705],
Cell[CellGroupData[{
Cell[19114, 595, 151, 5, 70, "ExampleSubsection",
 CellID->311729416],
Cell[19268, 602, 171, 6, 70, "ExampleText",
 CellID->993536701],
Cell[CellGroupData[{
Cell[19464, 612, 619, 19, 70, "Input",
 CellID->1889358125],
Cell[20086, 633, 1056, 40, 70, "Output",
 CellID->299518974]
}, Open  ]],
Cell[21157, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->411329874],
Cell[21285, 681, 162, 6, 70, "ExampleText",
 CellID->605355859],
Cell[CellGroupData[{
Cell[21472, 691, 230, 8, 70, "Input",
 CellID->1585886374],
Cell[21705, 701, 400, 13, 70, "Output",
 CellID->46399337]
}, Open  ]],
Cell[22120, 717, 125, 3, 70, "ExampleDelimiter",
 CellID->305194257],
Cell[22248, 722, 181, 6, 70, "ExampleText",
 CellID->699182426],
Cell[CellGroupData[{
Cell[22454, 732, 324, 10, 70, "Input",
 CellID->128517398],
Cell[22781, 744, 352, 10, 201, "Output",
 CellID->53228971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23182, 760, 152, 5, 70, "ExampleSubsection",
 CellID->1523679679],
Cell[23337, 767, 268, 10, 70, "ExampleText",
 CellID->3238],
Cell[CellGroupData[{
Cell[23630, 781, 404, 14, 70, "Input",
 CellID->21100],
Cell[24037, 797, 2327, 87, 70, "Output",
 CellID->467254941]
}, Open  ]],
Cell[26379, 887, 93, 1, 70, "ExampleText",
 CellID->30534],
Cell[CellGroupData[{
Cell[26497, 892, 256, 9, 70, "Input",
 CellID->13933],
Cell[26756, 903, 2326, 87, 70, "Output",
 CellID->31669008]
}, Open  ]],
Cell[29097, 993, 125, 3, 70, "ExampleDelimiter",
 CellID->670078793],
Cell[29225, 998, 206, 6, 70, "ExampleText",
 CellID->1922176848],
Cell[CellGroupData[{
Cell[29456, 1008, 304, 9, 70, "Input",
 CellID->1359],
Cell[29763, 1019, 601, 21, 70, "Output",
 CellID->193373602]
}, Open  ]],
Cell[30379, 1043, 285, 11, 70, "ExampleText",
 CellID->1429782515],
Cell[CellGroupData[{
Cell[30689, 1058, 265, 8, 70, "Input",
 CellID->12719675],
Cell[30957, 1068, 340, 13, 70, "Output",
 CellID->1296907]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31358, 1088, 238, 7, 70, "ExampleSection",
 CellID->2526],
Cell[31599, 1097, 89, 1, 70, "ExampleText",
 CellID->23271697],
Cell[CellGroupData[{
Cell[31713, 1102, 312, 10, 70, "Input",
 CellID->7208],
Cell[32028, 1114, 348, 13, 70, "Output",
 CellID->25267405],
Cell[32379, 1129, 140, 4, 70, "Print",
 CellID->162128034]
}, Open  ]],
Cell[32534, 1136, 125, 3, 70, "ExampleDelimiter",
 CellID->363136369],
Cell[32662, 1141, 92, 1, 70, "ExampleText",
 CellID->273765216],
Cell[CellGroupData[{
Cell[32779, 1146, 340, 11, 70, "Input",
 CellID->104598850],
Cell[33122, 1159, 358, 13, 70, "Output",
 CellID->71626710],
Cell[33483, 1174, 176, 5, 70, "Print",
 CellID->15845955]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33708, 1185, 222, 7, 70, "ExampleSection",
 CellID->49738227],
Cell[CellGroupData[{
Cell[33955, 1196, 230, 7, 70, "ExampleSubsection",
 CellID->566567855],
Cell[34188, 1205, 82, 1, 70, "ExampleText",
 CellID->569627317],
Cell[CellGroupData[{
Cell[34295, 1210, 560, 17, 70, "Input",
 CellID->618910655],
Cell[34858, 1229, 1152, 39, 70, "Output",
 CellID->584138253]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36059, 1274, 229, 7, 70, "ExampleSubsection",
 CellID->4499585],
Cell[36291, 1283, 73, 1, 70, "ExampleText",
 CellID->387788436],
Cell[CellGroupData[{
Cell[36389, 1288, 419, 13, 70, "Input",
 CellID->993682088],
Cell[36811, 1303, 797, 28, 70, "Output",
 CellID->48875376]
}, Open  ]],
Cell[37623, 1334, 125, 3, 70, "ExampleDelimiter",
 CellID->155664593],
Cell[37751, 1339, 104, 2, 70, "ExampleText",
 CellID->2094858854],
Cell[CellGroupData[{
Cell[37880, 1345, 394, 12, 70, "Input",
 CellID->1024882956],
Cell[38277, 1359, 2501, 45, 70, "Output",
 Evaluatable->False,
 CellID->1267058328]
}, Open  ]],
Cell[40793, 1407, 124, 3, 70, "ExampleDelimiter",
 CellID->31630761],
Cell[40920, 1412, 115, 3, 70, "ExampleText",
 CellID->2090955629],
Cell[CellGroupData[{
Cell[41060, 1419, 451, 14, 70, "Input",
 CellID->702742541],
Cell[41514, 1435, 616, 21, 70, "Output",
 CellID->37791802]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42179, 1462, 229, 7, 70, "ExampleSubsection",
 CellID->5467863],
Cell[42411, 1471, 122, 3, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[42558, 1478, 293, 10, 70, "Input",
 CellID->2083591643],
Cell[42854, 1490, 504, 16, 70, "Output",
 CellID->340512590]
}, Open  ]],
Cell[43373, 1509, 125, 3, 70, "ExampleDelimiter",
 CellID->236942049],
Cell[43501, 1514, 263, 8, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[43789, 1526, 346, 11, 70, "Input",
 CellID->29537832],
Cell[44138, 1539, 525, 17, 70, "Output",
 CellID->10898741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44712, 1562, 231, 7, 70, "ExampleSubsection",
 CellID->112768781],
Cell[44946, 1571, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[45043, 1576, 389, 12, 70, "Input",
 CellID->155850066],
Cell[45435, 1590, 1142, 39, 70, "Output",
 CellID->1705940604]
}, Open  ]],
Cell[46592, 1632, 125, 3, 70, "ExampleDelimiter",
 CellID->425224822],
Cell[46720, 1637, 86, 1, 70, "ExampleText",
 CellID->375560463],
Cell[CellGroupData[{
Cell[46831, 1642, 519, 16, 70, "Input",
 CellID->179308],
Cell[47353, 1660, 530, 16, 70, "Output",
 CellID->253056403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47932, 1682, 237, 7, 70, "ExampleSubsection",
 CellID->166336729],
Cell[48172, 1691, 75, 1, 70, "ExampleText",
 CellID->555827094],
Cell[CellGroupData[{
Cell[48272, 1696, 462, 14, 70, "Input",
 CellID->340562913],
Cell[48737, 1712, 1061, 35, 70, "Output",
 CellID->137906829]
}, Open  ]],
Cell[49813, 1750, 126, 3, 70, "ExampleDelimiter",
 CellID->1041677070],
Cell[49942, 1755, 94, 1, 70, "ExampleText",
 CellID->353206981],
Cell[CellGroupData[{
Cell[50061, 1760, 777, 23, 70, "Input",
 CellID->385391123],
Cell[50841, 1785, 860, 23, 70, "Output",
 CellID->933861131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51750, 1814, 227, 7, 70, "ExampleSubsection",
 CellID->25014151],
Cell[51980, 1823, 202, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[52207, 1835, 137, 4, 70, "Input",
 CellID->94729581],
Cell[52347, 1841, 337, 12, 70, "Output",
 CellID->62262819]
}, Open  ]],
Cell[52699, 1856, 125, 3, 70, "ExampleDelimiter",
 CellID->496435830],
Cell[52827, 1861, 354, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[53206, 1877, 188, 5, 70, "Input",
 CellID->227336428],
Cell[53397, 1884, 356, 13, 70, "Output",
 CellID->349817533]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53802, 1903, 230, 7, 70, "ExampleSubsection",
 CellID->232464115],
Cell[54035, 1912, 114, 3, 70, "ExampleText",
 CellID->96906759],
Cell[CellGroupData[{
Cell[54174, 1919, 270, 8, 70, "Input",
 CellID->1786402438],
Cell[54447, 1929, 392, 13, 70, "Output",
 CellID->29699695]
}, Open  ]],
Cell[54854, 1945, 125, 3, 70, "ExampleDelimiter",
 CellID->283531173],
Cell[54982, 1950, 248, 8, 70, "ExampleText",
 CellID->1578363691],
Cell[CellGroupData[{
Cell[55255, 1962, 324, 9, 70, "Input",
 CellID->1840546893],
Cell[55582, 1973, 394, 13, 70, "Output",
 CellID->349801740]
}, Open  ]],
Cell[55991, 1989, 124, 3, 70, "ExampleDelimiter",
 CellID->70437627],
Cell[56118, 1994, 97, 1, 70, "ExampleText",
 CellID->73049552],
Cell[CellGroupData[{
Cell[56240, 1999, 230, 6, 70, "Input",
 CellID->1530658027],
Cell[56473, 2007, 356, 12, 70, "Output",
 CellID->229987244]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56878, 2025, 233, 7, 70, "ExampleSubsection",
 CellID->837226577],
Cell[57114, 2034, 115, 3, 70, "ExampleText",
 CellID->592492429],
Cell[CellGroupData[{
Cell[57254, 2041, 377, 12, 70, "Input",
 CellID->2099775161],
Cell[57634, 2055, 1086, 39, 70, "Output",
 CellID->486104472]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58769, 2100, 233, 7, 70, "ExampleSubsection",
 CellID->527576866],
Cell[59005, 2109, 233, 8, 70, "ExampleText",
 CellID->33301087],
Cell[CellGroupData[{
Cell[59263, 2121, 408, 13, 70, "Input",
 CellID->405109056],
Cell[59674, 2136, 1275, 47, 70, "Output",
 CellID->1144743202]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60998, 2189, 230, 7, 70, "ExampleSubsection",
 CellID->220778943],
Cell[61231, 2198, 61, 1, 70, "ExampleText",
 CellID->127350395],
Cell[CellGroupData[{
Cell[61317, 2203, 389, 12, 70, "Input",
 CellID->234360116],
Cell[61709, 2217, 1089, 39, 70, "Output",
 CellID->1293283300]
}, Open  ]],
Cell[62813, 2259, 124, 3, 70, "ExampleDelimiter",
 CellID->11032924],
Cell[62940, 2264, 60, 1, 70, "ExampleText",
 CellID->27069804],
Cell[CellGroupData[{
Cell[63025, 2269, 420, 13, 70, "Input",
 CellID->289053222],
Cell[63448, 2284, 1202, 45, 70, "Output",
 CellID->714985696]
}, Open  ]],
Cell[64665, 2332, 124, 3, 70, "ExampleDelimiter",
 CellID->81570851],
Cell[64792, 2337, 112, 3, 70, "ExampleText",
 CellID->25763139],
Cell[CellGroupData[{
Cell[64929, 2344, 246, 7, 70, "Input",
 CellID->643525534],
Cell[65178, 2353, 369, 13, 70, "Output",
 CellID->1593587707]
}, Open  ]],
Cell[65562, 2369, 125, 3, 70, "ExampleDelimiter",
 CellID->490623302],
Cell[65690, 2374, 68, 1, 70, "ExampleText",
 CellID->39865681],
Cell[CellGroupData[{
Cell[65783, 2379, 240, 7, 70, "Input",
 CellID->700558927],
Cell[66026, 2388, 363, 13, 70, "Output",
 CellID->409997749]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66438, 2407, 227, 7, 70, "ExampleSubsection",
 CellID->118347657],
Cell[66668, 2416, 150, 4, 70, "ExampleText",
 CellID->782983146],
Cell[CellGroupData[{
Cell[66843, 2424, 468, 14, 70, "Input",
 CellID->1965429653],
Cell[67314, 2440, 622, 18, 70, "Output",
 CellID->1602308048]
}, Open  ]],
Cell[67951, 2461, 299, 10, 70, "ExampleText",
 CellID->382719817],
Cell[CellGroupData[{
Cell[68275, 2475, 533, 15, 70, "Input",
 CellID->658441554],
Cell[68811, 2492, 623, 18, 70, "Output",
 CellID->546429356]
}, Open  ]],
Cell[69449, 2513, 126, 3, 70, "ExampleDelimiter",
 CellID->2040967411],
Cell[69578, 2518, 135, 4, 70, "ExampleText",
 CellID->282711838],
Cell[CellGroupData[{
Cell[69738, 2526, 748, 22, 70, "Input",
 CellID->378791829],
Cell[70489, 2550, 849, 26, 70, "Output",
 CellID->250422289]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[71399, 2583, 226, 7, 70, "ExampleSection",
 CellID->65660056],
Cell[71628, 2592, 84, 1, 70, "ExampleText",
 CellID->450529530],
Cell[CellGroupData[{
Cell[71737, 2597, 205, 6, 70, "Input",
 CellID->15357],
Cell[71945, 2605, 372, 13, 70, "Output",
 CellID->365149841]
}, Open  ]],
Cell[72332, 2621, 125, 3, 70, "ExampleDelimiter",
 CellID->106811598],
Cell[CellGroupData[{
Cell[72482, 2628, 223, 7, 70, "Input",
 CellTags->"Button",
 CellID->23761],
Cell[72708, 2637, 391, 13, 70, "Output",
 CellTags->"Button",
 CellID->524851307]
}, Open  ]],
Cell[73114, 2653, 124, 3, 70, "ExampleDelimiter",
 CellID->34270821],
Cell[73241, 2658, 74, 1, 70, "ExampleText",
 CellID->658548267],
Cell[CellGroupData[{
Cell[73340, 2663, 198, 6, 70, "Input",
 CellID->90006831],
Cell[73541, 2671, 369, 12, 70, "Output",
 CellID->23760815]
}, Open  ]],
Cell[73925, 2686, 125, 3, 70, "ExampleDelimiter",
 CellID->595882948],
Cell[74053, 2691, 80, 1, 70, "ExampleText",
 CellID->1154291583],
Cell[CellGroupData[{
Cell[74158, 2696, 383, 11, 70, "Input",
 CellID->1958852130],
Cell[74544, 2709, 441, 14, 70, "Output",
 CellID->45498667]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75034, 2729, 237, 7, 70, "ExampleSection",
 CellID->149758654],
Cell[75274, 2738, 84, 1, 70, "ExampleText",
 CellID->1704627867],
Cell[CellGroupData[{
Cell[75383, 2743, 506, 17, 70, "Input",
 CellID->1977259986],
Cell[75892, 2762, 2183, 84, 70, "Output",
 CellID->134026091]
}, Open  ]],
Cell[CellGroupData[{
Cell[78112, 2851, 492, 16, 70, "Input",
 CellID->1090204324],
Cell[78607, 2869, 1992, 75, 70, "Output",
 CellID->7200908]
}, Open  ]],
Cell[80614, 2947, 125, 3, 70, "ExampleDelimiter",
 CellID->104634848],
Cell[80742, 2952, 103, 2, 70, "ExampleText",
 CellID->72682333],
Cell[CellGroupData[{
Cell[80870, 2958, 497, 14, 70, "Input",
 CellID->1162841235],
Cell[81370, 2974, 448, 14, 70, "Output",
 CellID->8335434]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81867, 2994, 230, 7, 70, "ExampleSection",
 CellID->810560353],
Cell[82100, 3003, 90, 1, 70, "ExampleText",
 CellID->1159175613],
Cell[CellGroupData[{
Cell[82215, 3008, 224, 6, 70, "Input",
 CellID->292882107],
Cell[82442, 3016, 346, 12, 70, "Output",
 CellID->38060692]
}, Open  ]],
Cell[82803, 3031, 125, 3, 70, "ExampleDelimiter",
 CellID->395426126],
Cell[82931, 3036, 248, 8, 70, "ExampleText",
 CellID->686990886],
Cell[CellGroupData[{
Cell[83204, 3048, 243, 6, 70, "Input",
 CellID->1329193747],
Cell[83450, 3056, 370, 13, 70, "Output",
 CellID->261249284]
}, Open  ]],
Cell[83835, 3072, 123, 3, 70, "ExampleDelimiter",
 CellID->8823189],
Cell[83961, 3077, 331, 13, 70, "ExampleText",
 CellID->1330051528],
Cell[CellGroupData[{
Cell[84317, 3094, 733, 20, 70, "Input",
 CellID->235275180],
Cell[85053, 3116, 1006, 37, 70, "Output",
 CellID->36771283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86108, 3159, 227, 7, 70, "ExampleSection",
 CellID->83961162],
Cell[86338, 3168, 87, 1, 70, "ExampleText",
 CellID->8106],
Cell[CellGroupData[{
Cell[86450, 3173, 752, 23, 70, "Input",
 CellTags->"Button",
 CellID->17792],
Cell[87205, 3198, 638, 19, 70, "Output",
 CellTags->"Button",
 CellID->389348566]
}, Open  ]],
Cell[87858, 3220, 125, 3, 70, "ExampleDelimiter",
 CellID->190587858],
Cell[87986, 3225, 99, 1, 70, "ExampleText",
 CellID->177324581],
Cell[CellGroupData[{
Cell[88110, 3230, 778, 24, 70, "Input",
 CellID->342747554],
Cell[88891, 3256, 646, 19, 70, "Output",
 CellID->259118573]
}, Open  ]],
Cell[89552, 3278, 125, 3, 70, "ExampleDelimiter",
 CellID->174004883],
Cell[89680, 3283, 83, 1, 70, "ExampleText",
 CellID->2086773317],
Cell[CellGroupData[{
Cell[89788, 3288, 760, 24, 70, "Input",
 CellID->1843699662],
Cell[90551, 3314, 563, 17, 70, "Output",
 CellID->1018676671]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91175, 3338, 311, 9, 70, "SeeAlsoSection",
 CellID->15634],
Cell[91489, 3349, 3679, 134, 70, "SeeAlso",
 CellID->3886]
}, Open  ]],
Cell[CellGroupData[{
Cell[95205, 3488, 313, 9, 70, "TutorialsSection",
 CellID->9376],
Cell[95521, 3499, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[95683, 3504, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[95868, 3512, 317, 9, 70, "MoreAboutSection",
 CellID->1086103],
Cell[96188, 3523, 141, 3, 70, "MoreAbout",
 CellID->457697909],
Cell[96332, 3528, 167, 3, 70, "MoreAbout",
 CellID->77654175],
Cell[96502, 3533, 135, 3, 70, "MoreAbout",
 CellID->431647205],
Cell[96640, 3538, 128, 3, 70, "MoreAbout",
 CellID->204171587],
Cell[96771, 3543, 154, 3, 70, "MoreAbout",
 CellID->350005719],
Cell[96928, 3548, 128, 3, 70, "MoreAbout",
 CellID->329262884],
Cell[97059, 3553, 172, 3, 70, "MoreAbout",
 CellID->100634256]
}, Open  ]],
Cell[97246, 3559, 27, 0, 70, "History"],
Cell[97276, 3561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

