(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43231,       1547]
NotebookOptionsPosition[     34627,       1229]
NotebookOutlinePosition[     35887,       1265]
CellTagsIndexPosition[     35801,       1260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LeafCount" :> Documentation`HelpLookup["paclet:ref/LeafCount"],
           "MemoryInUse" :> 
          Documentation`HelpLookup["paclet:ref/MemoryInUse"], "MaxMemoryUsed" :> 
          Documentation`HelpLookup["paclet:ref/MaxMemoryUsed"], "Length" :> 
          Documentation`HelpLookup["paclet:ref/Length"], "StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], "Depth" :> 
          Documentation`HelpLookup["paclet:ref/Depth"], "Share" :> 
          Documentation`HelpLookup["paclet:ref/Share"], "BitLength" :> 
          Documentation`HelpLookup["paclet:ref/BitLength"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"], "Compress" :> 
          Documentation`HelpLookup["paclet:ref/Compress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LeafCount\"\>", 
       2->"\<\"MemoryInUse\"\>", 3->"\<\"MaxMemoryUsed\"\>", 
       4->"\<\"Length\"\>", 5->"\<\"StringLength\"\>", 6->"\<\"Depth\"\>", 
       7->"\<\"Share\"\>", 8->"\<\"BitLength\"\>", 9->"\<\"Hash\"\>", 
       10->"\<\"Compress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Expression Structure\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ByteCount", "ObjectName",
 CellID->8964],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ByteCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ByteCount"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of bytes used internally by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " to store ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17867]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " does not take account of any sharing of subexpressions. The results it \
gives assume that every part of the expression is stored separately. ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " will therefore often give an overestimate of the amount of memory \
currently needed to store a particular expression. When you manipulate the \
expression, however, subexpressions will often stop being shared, and the \
amount of memory needed will be close to the value returned by ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11227,
  ButtonNote->"11227"]
}], "Notes",
 CellID->21088],

Cell[TextData[{
 "Results from ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " may be different on different computer systems."
}], "Notes",
 CellID->29465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108883816],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->400250554],

Cell["Find the number of bytes used to store an expression:", "ExampleText",
 CellID->18655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28516],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Range", "[", "10000", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1012],

Cell[BoxData["40056"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26974]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25274],

Cell["Growth of storage sizes for a sequence of integrals:", "ExampleText",
 CellID->19622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "n"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "72", ",", "368", ",", "840", ",", "488", ",", "3296", ",", "1568", ",", 
   "3360", ",", "2104", ",", "3720", ",", "6472"}], "}"}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24500],

Cell[TextData[{
 "Make ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " pick expressions with minimum ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"50", 
    RowBox[{"Log", "[", "10000", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "->", "ByteCount"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4224],

Cell[BoxData[
 RowBox[{"50", " ", 
  RowBox[{"Log", "[", "10000", "]"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " does not account for sizes of numbers:"
}], "ExampleText",
 CellID->6408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"50", 
    RowBox[{"Log", "[", "10000", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "->", "LeafCount"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32077],

Cell[BoxData[
 RowBox[{"Log", "[", 
  "100000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000", "]"}]], "Output",
 ImageSize->{580, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13876],

Cell["\<\
Show that lists with symbolic elements require more storage than lists of \
numbers:\
\>", "ExampleText",
 CellID->2021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ByteCount", "[", 
       RowBox[{"Range", "[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ByteCount", "[", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{
         RowBox[{"Range", "[", "n", "]"}], ",", "x", ",", "1"}], "]"}], "]"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26691],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE9IFGEU/9wZ62IFaRCYurXe7Fb091IbFBhd7CKeWpfAPUS2eclDVock
kDIICiIm6BQdvCwYBAmBSRHVIZIKEgq0CLFIUPAwvXnfzHxvZt/83RVa2G/2
zff7fu/P9977ZvZUYWjg7LnCUKlYyJ4oFwYHSsWL2ePny3BLaxBCVOBb3i7g
twm/8FsxTbjScR+MGkzl7GsGrhm4Zm1Z6AizPx0g6ASl4eRBa7TAJn7ETmvQ
lSzxFNHukzWf3GYNjVJ2R2SxHGuwruukuZ1lWG+tHUTmPd1vR7wzni6FsNft
iqWB8uTiaWqkmoSdOWIDXRcUxwPENiebnNzL2KmXsbOOzsuso1m81WeZkfju
FhgfOT5WYRp9ckvE/P+G11ivOmuUeVYVZWuvpCWLv2a/zU2triyJe+wabDLa
04kzY5cFAENRXz5OTD8f+bM0F4AyYlj1kMU0oVx50vvYOLL8d0GMh6Du38yC
rZYVPIq3Qnowcn1abB4bGHxmR2f202JvoTLzep5wqdgt/V69++D9wo9lW1ar
dWc1WHJntE3cCLFXsbg2lIq5K8NHq2y4yrI0R9jiZ7nEsrQmZLngiUdnwtWl
EBtg5yCLPrw1xKa4UbZZ+5HVey7S81DtnF8nZDbsFCSX2Ba0JwGe9KEy7E2B
HVmI6g7tl6UdUIdgys+Fd2JHwoj21MmOfEK93TXodZ5uhAa7DfGHbU+cSfk6
+e23Y3fC3DtcJzv6YuVfcDy6pB5N1QA9m7kKKLCext8BjJzbCcoJV7e6q6lN
6AU5m04m3I2WEFZ1lp2OFWvF2hTCqs4+/w5GRUBnWcfjeOxGfS/OqvOxn/Os
SscelNV5yXdliZr/PgMhW1tbCUAZEXeDz3asHA1MAEPcfAxAgXvgZDDKq+8Y
zqrzpI9dIzueOgEkyv8uxVVOnuUXG+SFjkm7gPSj9m4iebSQVWG9Of1qKuMJ
QTprjx0l6lc67wKYE/Q+b77IfqC6TjebL6iFdJEw1KsXo5BS1nnOo4yIu8FV
I7uMqvh8CEpVeBhKVTiP8lpVNL1Ve4hd0x8LlT4K2ItIBWKvQkDUzsuVqurt
lQSVJtcD7KmRVUaC5jUiIirIYbJEfFrXvn6eBFctu+RTQu39RfKqCuyqi7+S
FbIatsfK2q7Yuxonk4ZNb5Xn2DX4lkSqPAylqpxHefVfw9k3L29BwCz9/BMQ
vuuRyg1DRXHFiQpfX/jeSuq3uQaUV99tnFXvO/yzlXwKUlUqUb68jcgJyQE6
gGBqcpDnSF2VFoXYaDo16P5IUte+FQnq2mEwU3UGKuM/NqRD6HVmVj1CT7GH
kkN1BP551nDvqoyW/0KKhn/rpn/u\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403942809]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10365],

Cell["\<\
On the computer system used for this example, each ordinary integer takes 4 \
bytes to store:\
\>", "ExampleText",
 CellID->32249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Range", "[", "1000", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30336],

Cell[BoxData["4056"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28007]
}, Open  ]],

Cell["Approximate numbers take double:", "ExampleText",
 CellID->17646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"1.", ",", "1000"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12436],

Cell[BoxData["8056"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20049],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " does not account for sharing in the actual storage of expressions:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11227],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"1000", "!"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3144],

Cell[BoxData["1096"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30220],

Cell[BoxData["3320"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->30809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31740],

Cell["\<\
Symbols are effectively always shared, so they give 0 byte count:\
\>", "ExampleText",
 CellID->9699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", "s", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19563],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21425],

Cell[TextData[{
 "For ASCII strings, ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " on average increases by 1 for each character:"
}], "ExampleText",
 CellID->6298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<x\>\"", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"x\"\>", ",", "\<\"xx\"\>", ",", "\<\"xxx\"\>", 
   ",", "\<\"xxxx\"\>", ",", "\<\"xxxxx\"\>", ",", "\<\"xxxxxx\"\>", 
   ",", "\<\"xxxxxxx\"\>", ",", "\<\"xxxxxxxx\"\>", ",", "\<\"xxxxxxxxx\"\>", 
   ",", "\<\"xxxxxxxxxx\"\>"}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", "24", ",", "24", ",", "24", ",", "24", ",", "24", ",", "24", ",",
    "32", ",", "32", ",", "32"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ByteCount", "[", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Table", "[", 
       RowBox[{"\"\<x\>\"", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19999],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1u00AQXseOEwSq0p6QoI2JQMoBRdxyASknOABS71yIKiRXEaIyvXFB
4pADSDxAK+UBeIAcOPQFWvEMfZJlfxxnvRmP10McbMlj73r9zcw3s7Nrv52e
xx8+Ts9PT6bRq2R6Fp+efI5efkpEl+8xxm7F+e0+E/dc3KnzgHPOfHmnDnYt
Bavc2xO98/lcyPF4XCrjOL7KvxtFkZCe55XKbre7frclOtjeZDJJkqRULhaL
K5p3NfVK62/AMfek2HcnNKOVtcSbgbhvpfgDiRRkyGnvo/Tqp9fIavfF1TdQ
fONaZK17CLNAary2Rsqk0mri9/M+ACMOpQjNEfC4h47jDlGNKxuVL/KKsLJc
Lh3TM0tSFjj5KwewduZFale/gUwMgDc2dNjPczpdvZJIrWKEmv04QrX74JOj
muOwmt0uOortVwhts4pA/u8yp+yKBde5geFRUZ2z61txnfv32q8YItX1hcLb
E/KP6AlA9I5L+0C0kaIknoJFyY6hjR1SbGlw2/YndGL8gdV+bLWfVLRivwQP
tmrbu5EqeE85NcN/IniUvQWGR1mVYbxt80eP3QuVQDDzap/cgXn/CmI/V2gw
7xoNZh1B64Gsj0aj4XAIUg5jaa9Dnq/YbXCU6nVYkex29bdlc1s64Z1CUMhD
+coM6+rw/Opoc/iaU+fyGRg5jUeZy2s8aecbTp3DsF3N+/57R2b+PYJHYR7D
o0QAxtvN2rSLyjEjR+64sl7ZnJEje5xjo7zezMgxr+7Ztiu5W8zrzr8v5NyY
IHiU2GN4lAjDeM3ZG/0gM/8MRP9OZh7DozAP42nv08/E9LD/5cFzYLMOQN/m
5TOOhrPeRf1fO+rDSX8tqMP+62BH5IKctRGYFRfkrF3jSTsvydkK29W8/dcv
MvM9BI/CPIZHiQCMV8/6t/o7rY/VBCr62jDm2Z2sVwOYssp8tUeh/9Tt9m8p
7uI5ICMegvp8o41VO60FzwyZB3Qtmz7heSOzxNC245qH5dOtIZn3F8IRrqs=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->156363950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10573],

Cell["Unicode characters on average add 2 bytes each:", "ExampleText",
 CellID->22304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<\[Alpha]\>\"", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23776],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWU1PwkAQnbZ8RBC9iRcNBzjhSW960Yt4wfgXGmICB6IBfjTxLGfcrUND
pkPTRrq7HUvSnX0v05k3G/LSpuNwNX2fh6vZJOyNFuHndDZZ9p4/FooKPADv
GwDOL0Htt2oXXfq3URdATa/BjtvCCcEXBF8R3Cd4SPAtwfcEPxI8IviV4CBS
HRC2pRZfwS7Ga4wDjDcY7zA+YHzC+ILxjdT12W4+Zvtc9h5uHMo79r0m6tnq
4VLfDFqaNrW4flaSNUueI8Nse05Zj9mIg9gv6xgbGXvmzS+qhsm6tnul9W9a
6u/imUjTKU37oXmSnsU6WcLDOiz799yiKpit60I3nj1zQIO7pyNZr+QpeJb6
tBfx/DMZfadtGz3Dyt8qf3ONLZteyVPwLP/8Vvmb5P9S5W//Va/kKXL7G2E1
xE8hmobTHVeLuXxZx7uvyEpma6d26xTfzfa05VRUTo2pqjkHSPqCXr7YTPqN
Vy9rwv2209tNhh14P2WfjxY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{500, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2134962]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", "24", ",", "32", ",", "32", ",", "32", ",", "40", ",", "40", ",",
    "48", ",", "48", ",", "48"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FromDigits", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"5", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5", ",", "55", ",", "555", ",", "5555", ",", "55555", ",", "555555", ",", 
   "5555555", ",", "55555555", ",", "555555555", ",", "5555555555", ",", 
   "55555555555", ",", "555555555555", ",", "5555555555555", ",", 
   "55555555555555", ",", "555555555555555"}], "}"}]], "Output",
 ImageSize->{556, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "16", ",", "16", ",", "16", ",", "16", ",", "16", ",", "16", ",", "16", ",",
    "16", ",", "16", ",", "32", ",", "32", ",", "32", ",", "32", ",", "32", 
   ",", "32"}], "}"}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1254]
}, Open  ]],

Cell["\<\
For integers, there is a jump in going beyond machine numbers:\
\>", "ExampleText",
 CellID->25532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ByteCount", "[", 
     RowBox[{"FromDigits", "[", 
      RowBox[{"Table", "[", 
       RowBox[{"5", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22901],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1OGzEQ9mYTCJUqoEKol4YtERT1jnLNiR4Kb8AlipCWA2q1pI8AeQiQ
8gB9gJzhDYr6AjxJmPFudr322Ov9S0IiZby2Z8afvf7Gs74YjPyrm8Hoejjw
fgSD3/718NY7+xVAk+swxl7hf/+ZwfMMnvj/dTaDMpQfUbrYyn/sH9nqgWhC
tQFlA8ouNjbj/qj1MCrdqPwq1dGLK3hxhVIdE61ZK6zHktvKyAQkhEYHxYao
Qet9sdTrGEecY8Sld7BM5rYHTePxGGSv18slfd/ftZonKrBWjD7C463ICqAC
23Uc3mMt2+02+0T4VxDJ/SmEtmuAnhp6D0Xf+3Q67ff7QRDkkpPJJGvmB0a8
LtlzUPN7VvhpMZZ+HmIciBsXz14pMonxi46GXWFGumgoR8F0NMTaC4mAjtL5
W7dA/ofGJqmzmbPeLmlft79F+98gV/VYqh9l9Gfp06Mkb73+XVTHKIv25woM
bNEaQisVgeR6GasoCLDYIhWxkK1oEuqq/XUiM63TDop9XYoDSYxN9gNqf1Nv
jWc++57nMU12oOuS1BKvKmbd8QwHsM3JDWq090Xv8tXgkrQjNbul3O6lM92m
pMtj5bdiSXcZCZuY3YWYjFnpnMkhTpuNXK3E3HqOc5YRcdR1LZbUlpFAtEJ4
8+/L93Cm1TnKTxTfVeZYRvFKKHSZmtM5R6RyxPIEqIQsl4a1UtlgeXpUQosQ
2WplMTZWSR5ThNFzmxiDZRQQv8vWg/8jFCdVUTMXy0H5NDXHPxxLVaTMxW9Q
PjWsT1V0zMVsUKYxld0vImPMrLe5GdF8idRumUQAd82Y/4BiSdnndmoujxzJ
cvLLbcPaLCeDpBGtRky35TzvNO7jogzJ/horf/dQ1K5ENAqvOKOfLgI8ofhg
yHrhIblvQw/P3MKQlcIDfUMXjmXIGuEh627PtpU5b72PJdQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->110170260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2129],

Cell["Each element of a list effectively adds an internal pointer:", \
"ExampleText",
 CellID->22767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"24", ",", "32", ",", "32", ",", "40", ",", "40"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10233]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ByteCount", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29004],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmT9v00AYxt04aTMAQqhDh9I6FBADSAxQGEDKUAFDkRhAYgERVUXuUAGl
GTp0YICKgUodGBhQxdChQweGEnVgYGCoVBa+QT+JuT927mw/fmwnFkJEqu2L
73nv9z6+e3NJ73dW/cXlzurSQse7u9J56S8tvPbuvFgRb7kjjuMci7/NCUdc
B+JK/R0HgTinj7Pi6IoONXGuibMnzvVEW953w/Y5qZIdgugl320lerkq9o14
3zCq45p3puShodv9Y6qXZ7XR/enccVoggjRqRJ4LsuaPksd5NvTWafTTDXvO
VMCXN/pU+GxqqUjTSBnr8Tf48v3NzqCVeadWkE4+G2fU7lG1y2oONuyVg52c
Dcwaqlm5Re1iK3LG4jArUq/5Mwnmo4rePSWOv8Nc0n0a/1l79B/jKdvWMyL5
lC7ktC+W7I9HyZtbcsb+Gkg5xChm9W9sbIhr3/cP0V3P88R1s9mEd3u9Xrvd
3t7ePhyYST2psT6EDeT8gPq6UvTBbEiq6MPa4BkKTH6CsB7EsjpJGA9IbMyI
FZpR+mdXyOTMHyfMX1WEpqVAVT7ZHie5DRMR5148omxqT0aDrM+lOvRQVTf4
acWoJ4mzuyrGWBD/XEo+m0ni5C585pPEKaPIrijnCfMXosCMTIEZsSJeEa4Q
xk9Qf5kwMgVmxIoyVfcayWArlut1Qr5FYmNyrMCMtwjje6LArEYhs7pNGHFs
5q5etNHL3uOhNTVH8nqjAmXsm0vUqzniRLVjYA+HGcNUyeEZ54nXa5WOgb3W
Y4TbLvWyv5Oj2TFPXF0jczCa2Y9Ixq+g/iHhZwrMiBVlatMTkoEfy/UpIfdJ
bEyOFZhxkTA+IwrMahQyq+eEEcfGjMuE8TFRYEamwKxGUfb7Q5eQP1CK6Dcb
/YrkWWuqS/LS8ZJr2rXaRWpAl/hQzQhHA0eRzXXi6D0TOfW7Rf7+dJ14a0VO
7V3dgpGxpzqyXVfrAd/J4pn2lvjS7itkvHckzzaJjfmxokyV/EDIbxIFzsAo
ZK6bhBzHxowfCeNVosCMTIFZjSK7An0mjJeIAjMyBWbEiiK/vewQco8oMLlW
2P9ryKqmOyQbHUV/XY2Kkj6W3VVVtQPcIy5NqBishrKaukfcHDxymh07PRE6
bXszjNNl9qj7xNPTcObtE6+MQo71jeSMY5epmt8JeZMoMDlT4AyMIntd/1Rt
w1UnvQwL62XGx72K/9LrjPwBgmU4nQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->1916886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13404],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemoryConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFormula"],
 " aborts the generation of expressions that exceed a specified ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"10", "^", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23704],

Cell[BoxData["4000056"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryConstrained", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"10", "^", "6"}], "]"}], ",", "10000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32535],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27582],

Cell["Small changes can have large effects on memory usage:", "ExampleText",
 CellID->15371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"1.", ",", "1000"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13237],

Cell[BoxData["8076"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130850104]
}, Open  ]],

Cell[TextData[{
 "The presence of the exact ",
 Cell[BoxData["0"], "InlineFormula"],
 " prevents the data from being packed:"
}], "ExampleText",
 CellID->356451982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"1.", ",", "1000"}], "]"}], ",", "0"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5713905],

Cell[BoxData["20048"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19981718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13095],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " only gives the size of handles to external objects:"
}], "ExampleText",
 CellID->9710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"SelectedNotebook", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->995],

Cell[BoxData["160"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7705]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15418],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryInUse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryInUse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxMemoryUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxMemoryUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Share",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Share"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3568],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->5392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->214801452],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->46327602],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->507763566],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->187143658]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ByteCount - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 59.1782218}", "context" -> "System`", 
    "keywords" -> {"expressions", "memory", "size"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ByteCount[expr] gives the number of bytes used internally by Mathematica \
to store expr. ", "synonyms" -> {"byte count"}, "title" -> "ByteCount", 
    "type" -> "Symbol", "uri" -> "ref/ByteCount"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6041, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->108883816]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35658, 1253}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2975, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3598, 91, 46, 1, 70, "ObjectName",
 CellID->8964],
Cell[3647, 94, 647, 21, 70, "Usage",
 CellID->17867]
}, Open  ]],
Cell[CellGroupData[{
Cell[4331, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4809, 137, 957, 25, 70, "Notes",
 CellID->21088],
Cell[5769, 164, 235, 8, 70, "Notes",
 CellID->29465]
}, Closed]],
Cell[CellGroupData[{
Cell[6041, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108883816],
Cell[CellGroupData[{
Cell[6426, 191, 148, 5, 70, "ExampleSection",
 CellID->400250554],
Cell[6577, 198, 92, 1, 70, "ExampleText",
 CellID->18655],
Cell[CellGroupData[{
Cell[6694, 203, 181, 6, 28, "Input",
 CellID->28516],
Cell[6878, 211, 156, 5, 36, "Output",
 CellID->23303]
}, Open  ]],
Cell[CellGroupData[{
Cell[7071, 221, 136, 4, 28, "Input",
 CellID->1012],
Cell[7210, 227, 158, 5, 36, "Output",
 CellID->26974]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7417, 238, 223, 7, 70, "ExampleSection",
 CellID->25274],
Cell[7643, 247, 91, 1, 70, "ExampleText",
 CellID->19622],
Cell[CellGroupData[{
Cell[7759, 252, 390, 14, 70, "Input",
 CellID->11453],
Cell[8152, 268, 312, 9, 36, "Output",
 CellID->21650]
}, Open  ]],
Cell[8479, 280, 121, 3, 70, "ExampleDelimiter",
 CellID->24500],
Cell[8603, 285, 341, 13, 70, "ExampleText",
 CellID->26008],
Cell[CellGroupData[{
Cell[8969, 302, 228, 7, 70, "Input",
 CellID->4224],
Cell[9200, 311, 209, 7, 36, "Output",
 CellID->703]
}, Open  ]],
Cell[9424, 321, 213, 7, 70, "ExampleText",
 CellID->6408],
Cell[CellGroupData[{
Cell[9662, 332, 229, 7, 70, "Input",
 CellID->32077],
Cell[9894, 341, 391, 9, 88, "Output",
 CellID->20627]
}, Open  ]],
Cell[10300, 353, 121, 3, 70, "ExampleDelimiter",
 CellID->13876],
Cell[10424, 358, 130, 4, 70, "ExampleText",
 CellID->2021],
Cell[CellGroupData[{
Cell[10579, 366, 624, 20, 70, "Input",
 CellID->26691],
Cell[11206, 388, 1583, 30, 70, "Output",
 Evaluatable->False,
 CellID->403942809]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12838, 424, 233, 7, 70, "ExampleSection",
 CellID->10365],
Cell[13074, 433, 140, 4, 70, "ExampleText",
 CellID->32249],
Cell[CellGroupData[{
Cell[13239, 441, 136, 4, 70, "Input",
 CellID->30336],
Cell[13378, 447, 157, 5, 36, "Output",
 CellID->28007]
}, Open  ]],
Cell[13550, 455, 71, 1, 70, "ExampleText",
 CellID->17646],
Cell[CellGroupData[{
Cell[13646, 460, 161, 5, 70, "Input",
 CellID->12436],
Cell[13810, 467, 157, 5, 36, "Output",
 CellID->25126]
}, Open  ]],
Cell[13982, 475, 121, 3, 70, "ExampleDelimiter",
 CellID->20049],
Cell[14106, 480, 290, 8, 70, "ExampleText",
 CellID->11227],
Cell[14399, 490, 128, 5, 70, "Input",
 CellID->32522],
Cell[CellGroupData[{
Cell[14552, 499, 100, 3, 70, "Input",
 CellID->3144],
Cell[14655, 504, 157, 5, 36, "Output",
 CellID->12705]
}, Open  ]],
Cell[CellGroupData[{
Cell[14849, 514, 158, 5, 70, "Input",
 CellID->30220],
Cell[15010, 521, 157, 5, 36, "Output",
 CellID->30809]
}, Open  ]],
Cell[15182, 529, 121, 3, 70, "ExampleDelimiter",
 CellID->31740],
Cell[15306, 534, 111, 3, 70, "ExampleText",
 CellID->9699],
Cell[CellGroupData[{
Cell[15442, 541, 101, 3, 70, "Input",
 CellID->19563],
Cell[15546, 546, 154, 5, 36, "Output",
 CellID->25611]
}, Open  ]],
Cell[15715, 554, 121, 3, 70, "ExampleDelimiter",
 CellID->21425],
Cell[15839, 559, 244, 8, 70, "ExampleText",
 CellID->6298],
Cell[CellGroupData[{
Cell[16108, 571, 303, 10, 70, "Input",
 CellID->10240],
Cell[16414, 583, 417, 10, 36, "Output",
 CellID->21086]
}, Open  ]],
Cell[CellGroupData[{
Cell[16868, 598, 97, 3, 70, "Input",
 CellID->12483],
Cell[16968, 603, 296, 9, 36, "Output",
 CellID->1925]
}, Open  ]],
Cell[CellGroupData[{
Cell[17301, 617, 388, 12, 70, "Input",
 CellID->19999],
Cell[17692, 631, 1302, 26, 70, "Output",
 Evaluatable->False,
 CellID->156363950]
}, Open  ]],
Cell[19009, 660, 121, 3, 70, "ExampleDelimiter",
 CellID->10573],
Cell[19133, 665, 86, 1, 70, "ExampleText",
 CellID->22304],
Cell[CellGroupData[{
Cell[19244, 670, 310, 10, 70, "Input",
 CellID->23776],
Cell[19557, 682, 722, 16, 70, "Output",
 Evaluatable->False,
 CellID->2134962]
}, Open  ]],
Cell[CellGroupData[{
Cell[20316, 703, 97, 3, 70, "Input",
 CellID->23615],
Cell[20416, 708, 297, 9, 36, "Output",
 CellID->29294]
}, Open  ]],
Cell[20728, 720, 121, 3, 70, "ExampleDelimiter",
 CellID->31696],
Cell[CellGroupData[{
Cell[20874, 727, 295, 10, 70, "Input",
 CellID->32713],
Cell[21172, 739, 450, 11, 54, "Output",
 CellID->18352]
}, Open  ]],
Cell[CellGroupData[{
Cell[21659, 755, 96, 3, 70, "Input",
 CellID->6134],
Cell[21758, 760, 355, 10, 36, "Output",
 CellID->1254]
}, Open  ]],
Cell[22128, 773, 109, 3, 70, "ExampleText",
 CellID->25532],
Cell[CellGroupData[{
Cell[22262, 780, 380, 12, 70, "Input",
 CellID->22901],
Cell[22645, 794, 1228, 24, 70, "Output",
 Evaluatable->False,
 CellID->110170260]
}, Open  ]],
Cell[23888, 821, 120, 3, 70, "ExampleDelimiter",
 CellID->2129],
Cell[24011, 826, 101, 2, 70, "ExampleText",
 CellID->22767],
Cell[CellGroupData[{
Cell[24137, 832, 252, 9, 70, "Input",
 CellID->3279],
Cell[24392, 843, 513, 17, 36, "Output",
 CellID->12592]
}, Open  ]],
Cell[CellGroupData[{
Cell[24942, 865, 97, 3, 70, "Input",
 CellID->12413],
Cell[25042, 870, 237, 8, 36, "Output",
 CellID->10233]
}, Open  ]],
Cell[CellGroupData[{
Cell[25316, 883, 336, 11, 70, "Input",
 CellID->29004],
Cell[25655, 896, 1515, 29, 70, "Output",
 Evaluatable->False,
 CellID->1916886]
}, Open  ]],
Cell[27185, 928, 121, 3, 70, "ExampleDelimiter",
 CellID->13404],
Cell[27309, 933, 380, 12, 70, "ExampleText",
 CellID->17662],
Cell[CellGroupData[{
Cell[27714, 949, 158, 5, 70, "Input",
 CellID->23704],
Cell[27875, 956, 160, 5, 36, "Output",
 CellID->22655]
}, Open  ]],
Cell[CellGroupData[{
Cell[28072, 966, 195, 6, 70, "Input",
 CellID->32535],
Cell[28270, 974, 161, 5, 36, "Output",
 CellID->21780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28480, 985, 226, 7, 70, "ExampleSection",
 CellID->27582],
Cell[28709, 994, 92, 1, 70, "ExampleText",
 CellID->15371],
Cell[CellGroupData[{
Cell[28826, 999, 161, 5, 70, "Input",
 CellID->13237],
Cell[28990, 1006, 161, 5, 36, "Output",
 CellID->130850104]
}, Open  ]],
Cell[29166, 1014, 164, 5, 70, "ExampleText",
 CellID->356451982],
Cell[CellGroupData[{
Cell[29355, 1023, 225, 7, 70, "Input",
 CellID->5713905],
Cell[29583, 1032, 161, 5, 36, "Output",
 CellID->19981718]
}, Open  ]],
Cell[29759, 1040, 121, 3, 70, "ExampleDelimiter",
 CellID->13095],
Cell[29883, 1045, 226, 7, 70, "ExampleText",
 CellID->9710],
Cell[CellGroupData[{
Cell[30134, 1056, 137, 4, 70, "Input",
 CellID->995],
Cell[30274, 1062, 155, 5, 36, "Output",
 CellID->7705]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30490, 1074, 311, 9, 70, "SeeAlsoSection",
 CellID->15418],
Cell[30804, 1085, 2415, 89, 70, "SeeAlso",
 CellID->25105]
}, Open  ]],
Cell[CellGroupData[{
Cell[33256, 1179, 313, 9, 70, "TutorialsSection",
 CellID->3568],
Cell[33572, 1190, 143, 3, 70, "Tutorials",
 CellID->5392]
}, Open  ]],
Cell[CellGroupData[{
Cell[33752, 1198, 319, 9, 70, "MoreAboutSection",
 CellID->214801452],
Cell[34074, 1209, 150, 3, 70, "MoreAbout",
 CellID->46327602],
Cell[34227, 1214, 177, 3, 70, "MoreAbout",
 CellID->507763566],
Cell[34407, 1219, 148, 3, 70, "MoreAbout",
 CellID->187143658]
}, Open  ]],
Cell[34570, 1225, 27, 0, 70, "History"],
Cell[34600, 1227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

