(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28626,       1060]
NotebookOptionsPosition[     23027,        864]
NotebookOutlinePosition[     24288,        900]
CellTagsIndexPosition[     24203,        895]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BrayCurtisDistance" :> 
          Documentation`HelpLookup["paclet:ref/BrayCurtisDistance"], 
          "EuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/EuclideanDistance"], 
          "ManhattanDistance" :> 
          Documentation`HelpLookup["paclet:ref/ManhattanDistance"], 
          "ChebyshevDistance" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BrayCurtisDistance\"\>", 
       2->"\<\"EuclideanDistance\"\>", 3->"\<\"ManhattanDistance\"\>", 
       4->"\<\"ChebyshevDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CanberraDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CanberraDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CanberraDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Canberra distance between vectors ",
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CanberraDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CanberraDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     RowBox[{
      StyleBox["u", "TI"], "-", 
      StyleBox["v", "TI"]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       ButtonBox["Abs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Abs"], "[", 
       StyleBox["u", "TI"], "]"}], "+", 
      RowBox[{
       ButtonBox["Abs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Abs"], "[", 
       StyleBox["v", "TI"], "]"}]}], ")"}]}], "]"}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->709349618,
  ButtonNote->"709349618"]
}], "Notes",
 CellID->24221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->771145605],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->60338728],

Cell["Canberra distance between two vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanberraDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196650888],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "x", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "b", "]"}], "+", 
    RowBox[{"Abs", "[", "y", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "c", "]"}], "+", 
    RowBox[{"Abs", "[", "z", "]"}]}]]}]], "Output",
 ImageSize->{332, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->825250891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125461358],

Cell["Canberra distance between numeric vectors:", "ExampleText",
 CellID->319587507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanberraDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190454384],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342152554]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20556],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanberraDistance", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["42.11643498610037`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98755431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any precision:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanberraDistance", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10"}], "}"}], ",", 
     "50"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "15", ",", "20", ",", "5", ",", "5"}], "}"}], ",", 
     "50"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["2.\
5015151515151515151515151515151515151515151515151515151515151515152`49.\
5230541469313"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145065055]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13357],

Cell["Cluster data using Canberra distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "CanberraDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184647700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124651963],

Cell["Demonstrate the triangle inequality:", "ExampleText",
 CellID->162085005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"CanberraDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395493032],

Cell[BoxData[
 FractionBox[
  RowBox[{"Abs", "[", 
   RowBox[{"b", "-", "c"}], "]"}], 
  RowBox[{
   RowBox[{"Abs", "[", "b", "]"}], "+", 
   RowBox[{"Abs", "[", "c", "]"}]}]]], "Output",
 ImageSize->{105, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12645633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", "=", 
  RowBox[{"CanberraDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13424126],

Cell[BoxData[
 FractionBox[
  RowBox[{"Abs", "[", 
   RowBox[{"a", "-", "d"}], "]"}], 
  RowBox[{
   RowBox[{"Abs", "[", "a", "]"}], "+", 
   RowBox[{"Abs", "[", "d", "]"}]}]]], "Output",
 ImageSize->{105, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97106920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3", "=", 
  RowBox[{"CanberraDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51893016],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "c"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "b", "]"}], "+", 
    RowBox[{"Abs", "[", "c", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "d"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "d", "]"}]}]]}]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->131113847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"d3", "<=", 
   RowBox[{"d1", "+", "d2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->175054461],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->569633539]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29337],

Cell["Canberra distance is a sum of scaled absolute differences:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->709349618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanberraDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418619957],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "x", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "b", "]"}], "+", 
    RowBox[{"Abs", "[", "y", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "c", "]"}], "+", 
    RowBox[{"Abs", "[", "z", "]"}]}]]}]], "Output",
 ImageSize->{332, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552150937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "+", 
     RowBox[{"Abs", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], ")"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->290219153],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "x", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "b", "]"}], "+", 
    RowBox[{"Abs", "[", "y", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}], 
   RowBox[{
    RowBox[{"Abs", "[", "c", "]"}], "+", 
    RowBox[{"Abs", "[", "z", "]"}]}]]}]], "Output",
 ImageSize->{332, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8352191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533993557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CanberraDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CanberraDistance"]], "InlineFormula"],
 " is equivalent to a ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 " of scaled differences:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->214729278],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->191874222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scaleddiff", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"u", "-", "v"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Abs", "[", "u", "]"}], "+", 
     RowBox[{"Abs", "[", "v", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415031076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "-", "x"}], 
    RowBox[{
     RowBox[{"Abs", "[", "a", "]"}], "+", 
     RowBox[{"Abs", "[", "x", "]"}]}]], ",", 
   FractionBox[
    RowBox[{"b", "-", "y"}], 
    RowBox[{
     RowBox[{"Abs", "[", "b", "]"}], "+", 
     RowBox[{"Abs", "[", "y", "]"}]}]], ",", 
   FractionBox[
    RowBox[{"c", "-", "z"}], 
    RowBox[{
     RowBox[{"Abs", "[", "c", "]"}], "+", 
     RowBox[{"Abs", "[", "z", "]"}]}]]}], "}"}]], "Output",
 ImageSize->{343, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49166111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Norm", "[", 
    RowBox[{"scaleddiff", ",", "1"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{"CanberraDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->205579525],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370684100]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12835],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BrayCurtisDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BrayCurtisDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ManhattanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ManhattanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19405],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CanberraDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
CanberraDistance"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->306856129]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CanberraDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 6.5065344}", "context" -> "System`", 
    "keywords" -> {"Canberra distance"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CanberraDistance[u, v] gives the Canberra distance between vectors u and \
v.", "synonyms" -> {"canberra distance"}, "title" -> "CanberraDistance", 
    "type" -> "Symbol", "uri" -> "ref/CanberraDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6862, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->771145605]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24060, 888}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2277, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2900, 83, 1581, 37, 70, "ObjectNameGrid"],
Cell[4484, 122, 723, 23, 70, "Usage",
 CellID->8909]
}, Open  ]],
Cell[CellGroupData[{
Cell[5244, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5722, 167, 1103, 41, 70, "Notes",
 CellID->24221]
}, Closed]],
Cell[CellGroupData[{
Cell[6862, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->771145605],
Cell[CellGroupData[{
Cell[7247, 227, 147, 5, 70, "ExampleSection",
 CellID->60338728],
Cell[7397, 234, 81, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[7503, 239, 253, 8, 28, "Input",
 CellID->196650888],
Cell[7759, 249, 686, 24, 53, "Output",
 CellID->825250891]
}, Open  ]],
Cell[8460, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->125461358],
Cell[8588, 281, 85, 1, 70, "ExampleText",
 CellID->319587507],
Cell[CellGroupData[{
Cell[8698, 286, 253, 8, 70, "Input",
 CellID->190454384],
Cell[8954, 296, 158, 5, 36, "Output",
 CellID->342152554]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9161, 307, 216, 7, 70, "ExampleSection",
 CellID->20556],
Cell[9380, 316, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9500, 321, 265, 8, 70, "Input",
 CellID->488208944],
Cell[9768, 331, 174, 5, 36, "Output",
 CellID->98755431]
}, Open  ]],
Cell[9957, 339, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[10085, 344, 92, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[10202, 349, 426, 14, 70, "Input",
 CellID->323525768],
Cell[10631, 365, 248, 7, 36, "Output",
 CellID->145065055]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10928, 378, 223, 7, 70, "ExampleSection",
 CellID->13357],
Cell[11154, 387, 80, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[11259, 392, 476, 16, 70, "Input",
 CellID->108189764],
Cell[11738, 410, 515, 19, 36, "Output",
 CellID->184647700]
}, Open  ]],
Cell[12268, 432, 125, 3, 70, "ExampleDelimiter",
 CellID->124651963],
Cell[12396, 437, 79, 1, 70, "ExampleText",
 CellID->162085005],
Cell[CellGroupData[{
Cell[12500, 442, 262, 9, 70, "Input",
 CellID->395493032],
Cell[12765, 453, 317, 11, 53, "Output",
 CellID->12645633]
}, Open  ]],
Cell[CellGroupData[{
Cell[13119, 469, 261, 9, 70, "Input",
 CellID->13424126],
Cell[13383, 480, 317, 11, 53, "Output",
 CellID->97106920]
}, Open  ]],
Cell[CellGroupData[{
Cell[13737, 496, 261, 9, 70, "Input",
 CellID->51893016],
Cell[14001, 507, 511, 18, 53, "Output",
 CellID->131113847]
}, Open  ]],
Cell[CellGroupData[{
Cell[14549, 530, 155, 5, 70, "Input",
 CellID->175054461],
Cell[14707, 537, 161, 5, 36, "Output",
 CellID->569633539]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14917, 548, 233, 7, 70, "ExampleSection",
 CellID->29337],
Cell[15153, 557, 151, 3, 70, "ExampleText",
 CellID->709349618],
Cell[CellGroupData[{
Cell[15329, 564, 253, 8, 70, "Input",
 CellID->418619957],
Cell[15585, 574, 686, 24, 53, "Output",
 CellID->552150937]
}, Open  ]],
Cell[CellGroupData[{
Cell[16308, 603, 554, 19, 70, "Input",
 CellID->290219153],
Cell[16865, 624, 684, 24, 53, "Output",
 CellID->8352191]
}, Open  ]],
Cell[17564, 651, 125, 3, 70, "ExampleDelimiter",
 CellID->533993557],
Cell[17692, 656, 400, 13, 70, "ExampleText",
 CellID->214729278],
Cell[18095, 671, 281, 10, 70, "Input",
 CellID->191874222],
Cell[CellGroupData[{
Cell[18401, 685, 288, 10, 70, "Input",
 CellID->415031076],
Cell[18692, 697, 627, 22, 53, "Output",
 CellID->49166111]
}, Open  ]],
Cell[CellGroupData[{
Cell[19356, 724, 267, 8, 70, "Input",
 CellID->205579525],
Cell[19626, 734, 161, 5, 36, "Output",
 CellID->370684100]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19848, 746, 311, 9, 70, "SeeAlsoSection",
 CellID->12835],
Cell[20162, 757, 1015, 35, 70, "SeeAlso",
 CellID->32525]
}, Open  ]],
Cell[CellGroupData[{
Cell[21214, 797, 314, 9, 70, "TutorialsSection",
 CellID->19405],
Cell[21531, 808, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[21738, 816, 305, 8, 70, "RelatedLinksSection"],
Cell[22046, 826, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22457, 843, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[22776, 854, 179, 3, 70, "MoreAbout",
 CellID->306856129]
}, Open  ]],
Cell[22970, 860, 27, 0, 70, "History"],
Cell[23000, 862, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

