(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32736,       1188]
NotebookOptionsPosition[     26512,        968]
NotebookOutlinePosition[     27804,       1006]
CellTagsIndexPosition[     27719,       1001]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Rational Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apart" :> Documentation`HelpLookup["paclet:ref/Apart"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"], "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], 
          "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Apart\"\>", 2->"\<\"GCD\"\>", 
       3->"\<\"PolynomialGCD\"\>", 
       4->"\<\"PolynomialQuotient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 3->"\<\"Polynomial Division\"\>", 
       4->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Cancel", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cancel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cancel"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]cancels out common factors in the numerator and \
denominator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32493]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " cancels out the greatest common divisor of the numerator and denominator. \
"
}], "Notes",
 CellID->27372],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " generates a result modulo ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11902],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " allows operations to be performed on algebraic numbers in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Trig",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trig"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " treats trigonometric functions as rational functions of exponentials, and \
manipulates them accordingly. "
}], "Notes",
 CellID->7315],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->230452180],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->6591889],

Cell["Cancel common factors:", "ExampleText",
 CellID->578055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"x", "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47621889],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}]]], "Output",
 ImageSize->{48, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452196589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->625933287],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245929050]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26100],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " threads over sums:"
}], "ExampleText",
 CellID->329793398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "27"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "9"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "x", "+", "1"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285610575],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  FractionBox[
   RowBox[{"9", "+", 
    RowBox[{"3", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"3", "+", "x"}]], "+", 
  FractionBox["1", 
   RowBox[{"x", "+", "y"}]]}]], "Output",
 ImageSize->{153, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520064481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111258154],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " threads over Boolean combinations of equations and inequalities:"
}], "ExampleText",
 CellID->56601517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], "\[Equal]", "0"}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", "x"}], "+", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "\[GreaterEqual]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4219671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", "x"}]], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "\[GreaterEqual]", "0"}]}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102385154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4592],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6607],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " treats algebraic numbers as independent variables:"
}], "ExampleText",
 CellID->295457362],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->4220154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21424822],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   SqrtBox["2"], "+", "x"}]]], "Output",
 ImageSize->{52, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250400538]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " recognizes algebraically dependent coefficients:"
}], "ExampleText",
 CellID->19319446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{"r", ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->414093647],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["2"]}], "+", "x"}]], "Output",
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102604715]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28523],

Cell["\<\
Over the rational numbers the numerator and the denominator have no common \
factors:\
\>", "ExampleText",
 CellID->156603598],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86674971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->733479477],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{41, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185683288]
}, Open  ]],

Cell["\<\
Over the integers modulo 2, the denominator divides the numerator:\
\>", "ExampleText",
 CellID->255935911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{"r", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->372493661],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77607906]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7777],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " treats trigonometric functions as independent variables:"
}], "ExampleText",
 CellID->411074813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], "/", 
   RowBox[{"Sin", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->806955372],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "x", "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390971282]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " recognizes dependencies between trigonometric functions:"
}], "ExampleText",
 CellID->25147952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", "x"}], "]"}], "/", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143217436],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6748842]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30597],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " cancels common factors between numerators and denominators:"
}], "ExampleText",
 CellID->171692318],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109988960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542592671],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", "x"}]], "+", 
  FractionBox["1", 
   RowBox[{"2", "+", "x"}]]}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338738634]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " combines terms over a common denominator and cancels common factors:"
}], "ExampleText",
 CellID->268979689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "r", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36687592],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", 
   RowBox[{"2", " ", "x"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{93, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->565961636]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11653],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27425],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->19428],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->11075]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->362937109],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->111706495],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->377441747],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->52107405],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->8913366]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cancel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 7.8503188}", "context" -> "System`", 
    "keywords" -> {
     "cancel out", "greatest common divisor", "common factors", 
      "rational function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cancel[expr] cancels out common factors in the numerator and denominator \
of expr. ", "synonyms" -> {}, "title" -> "Cancel", "type" -> "Symbol", "uri" -> 
    "ref/Cancel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11001, 305, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->230452180]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27575, 994}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2824, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3447, 91, 4190, 83, 70, "ObjectNameGrid"],
Cell[7640, 176, 585, 19, 70, "Usage",
 CellID->32493]
}, Open  ]],
Cell[CellGroupData[{
Cell[8262, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8740, 217, 240, 8, 70, "Notes",
 CellID->27372],
Cell[8983, 227, 469, 18, 70, "Notes",
 CellID->11902],
Cell[9455, 247, 577, 20, 70, "Notes",
 CellID->4425],
Cell[10035, 269, 538, 18, 70, "Notes",
 CellID->7315],
Cell[10576, 289, 388, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[11001, 305, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->230452180],
Cell[CellGroupData[{
Cell[11386, 319, 146, 5, 70, "ExampleSection",
 CellID->6591889],
Cell[11535, 326, 62, 1, 70, "ExampleText",
 CellID->578055],
Cell[CellGroupData[{
Cell[11622, 331, 210, 8, 28, "Input",
 CellID->47621889],
Cell[11835, 341, 287, 11, 54, "Output",
 CellID->452196589]
}, Open  ]],
Cell[CellGroupData[{
Cell[12159, 357, 102, 3, 28, "Input",
 CellID->625933287],
Cell[12264, 362, 180, 6, 36, "Output",
 CellID->245929050]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12493, 374, 216, 7, 70, "ExampleSection",
 CellID->26100],
Cell[12712, 383, 192, 7, 70, "ExampleText",
 CellID->329793398],
Cell[CellGroupData[{
Cell[12929, 394, 689, 26, 70, "Input",
 CellID->285610575],
Cell[13621, 422, 376, 13, 56, "Output",
 CellID->520064481]
}, Open  ]],
Cell[14012, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->111258154],
Cell[14140, 443, 237, 7, 70, "ExampleText",
 CellID->56601517],
Cell[CellGroupData[{
Cell[14402, 454, 575, 21, 70, "Input",
 CellID->4219671],
Cell[14980, 477, 340, 12, 51, "Output",
 CellID->102385154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15369, 495, 217, 7, 70, "ExampleSection",
 CellID->4592],
Cell[CellGroupData[{
Cell[15611, 506, 225, 7, 70, "ExampleSubsection",
 CellID->6607],
Cell[15839, 515, 241, 8, 70, "ExampleText",
 CellID->295457362],
Cell[16083, 525, 298, 12, 70, "Input",
 CellID->4220154],
Cell[CellGroupData[{
Cell[16406, 541, 101, 3, 70, "Input",
 CellID->21424822],
Cell[16510, 546, 281, 11, 58, "Output",
 CellID->250400538]
}, Open  ]],
Cell[16806, 560, 472, 17, 70, "ExampleText",
 CellID->19319446],
Cell[CellGroupData[{
Cell[17303, 581, 171, 5, 70, "Input",
 CellID->414093647],
Cell[17477, 588, 211, 8, 38, "Output",
 CellID->102604715]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17737, 602, 224, 7, 70, "ExampleSubsection",
 CellID->28523],
Cell[17964, 611, 136, 4, 70, "ExampleText",
 CellID->156603598],
Cell[18103, 617, 262, 10, 70, "Input",
 CellID->86674971],
Cell[CellGroupData[{
Cell[18390, 631, 102, 3, 70, "Input",
 CellID->733479477],
Cell[18495, 636, 249, 9, 54, "Output",
 CellID->185683288]
}, Open  ]],
Cell[18759, 648, 117, 3, 70, "ExampleText",
 CellID->255935911],
Cell[CellGroupData[{
Cell[18901, 655, 161, 5, 70, "Input",
 CellID->372493661],
Cell[19065, 662, 179, 6, 36, "Output",
 CellID->77607906]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19293, 674, 220, 7, 70, "ExampleSubsection",
 CellID->7777],
Cell[19516, 683, 247, 8, 70, "ExampleText",
 CellID->411074813],
Cell[CellGroupData[{
Cell[19788, 695, 207, 7, 70, "Input",
 CellID->806955372],
Cell[19998, 704, 265, 9, 36, "Output",
 CellID->390971282]
}, Open  ]],
Cell[20278, 716, 460, 17, 70, "ExampleText",
 CellID->25147952],
Cell[CellGroupData[{
Cell[20763, 737, 270, 9, 70, "Input",
 CellID->143217436],
Cell[21036, 748, 208, 7, 36, "Output",
 CellID->6748842]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21305, 762, 233, 7, 70, "ExampleSection",
 CellID->30597],
Cell[21541, 771, 233, 7, 70, "ExampleText",
 CellID->171692318],
Cell[21777, 780, 452, 17, 70, "Input",
 CellID->109988960],
Cell[CellGroupData[{
Cell[22254, 801, 102, 3, 70, "Input",
 CellID->542592671],
Cell[22359, 806, 270, 10, 51, "Output",
 CellID->338738634]
}, Open  ]],
Cell[22644, 819, 246, 7, 70, "ExampleText",
 CellID->268979689],
Cell[CellGroupData[{
Cell[22915, 830, 103, 3, 70, "Input",
 CellID->36687592],
Cell[23021, 835, 346, 13, 53, "Output",
 CellID->565961636]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23428, 855, 311, 9, 70, "SeeAlsoSection",
 CellID->11653],
Cell[23742, 866, 955, 35, 70, "SeeAlso",
 CellID->10210]
}, Open  ]],
Cell[CellGroupData[{
Cell[24734, 906, 314, 9, 70, "TutorialsSection",
 CellID->27425],
Cell[25051, 917, 190, 4, 70, "Tutorials",
 CellID->19428],
Cell[25244, 923, 200, 4, 70, "Tutorials",
 CellID->11075]
}, Open  ]],
Cell[CellGroupData[{
Cell[25481, 932, 319, 9, 70, "MoreAboutSection",
 CellID->362937109],
Cell[25803, 943, 161, 3, 70, "MoreAbout",
 CellID->111706495],
Cell[25967, 948, 151, 3, 70, "MoreAbout",
 CellID->377441747],
Cell[26121, 953, 148, 3, 70, "MoreAbout",
 CellID->52107405],
Cell[26272, 958, 145, 3, 70, "MoreAbout",
 CellID->8913366]
}, Open  ]],
Cell[26432, 964, 50, 0, 70, "History"],
Cell[26485, 966, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

