(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35422,       1018]
NotebookOptionsPosition[     29978,        842]
NotebookOutlinePosition[     32066,        899]
CellTagsIndexPosition[     31948,        893]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "DefaultButton" :> 
          Documentation`HelpLookup["paclet:ref/DefaultButton"], 
          "DialogReturn" :> 
          Documentation`HelpLookup["paclet:ref/DialogReturn"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Button\"\>", 
       2->"\<\"DefaultButton\"\>", 3->"\<\"DialogReturn\"\>", 
       4->"\<\"DialogInput\"\>", 
       5->"\<\"CreateDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CancelButton", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CancelButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CancelButton"], "[", "]"}]], "InlineFormula"],
     
     " \[LineSeparator]represents a ",
     StyleBox["Cancel", "DialogElementName"],
     " button in a dialog that closes the dialog window when pressed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CancelButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CancelButton"], "[", 
       StyleBox["action", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a button labeled ",
     StyleBox["Cancel", "DialogElementName"],
     " that evaluates ",
     Cell[BoxData[
      StyleBox["action", "TI"]], "InlineFormula"],
     " when pressed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CancelButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CancelButton"], "[", 
       RowBox[{
        StyleBox["label", "TI"], ",", 
        StyleBox["action", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     " as the label for the button."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"], "[", 
   RowBox[{
    ButtonBox["DialogReturn",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DialogReturn"], "[", 
    ButtonBox["$Canceled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Canceled"], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6334],

Cell[TextData[{
 "In dialogs created with ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 ", pressing ",
 StyleBox["Esc", "KeyEvent"],
 " is effectively equivalent to pressing the ",
 StyleBox["Cancel", "DialogElementName"],
 " button."
}], "Notes",
 CellID->26500],

Cell[TextData[{
 "If there are several ",
 StyleBox["Cancel", "DialogElementName"],
 " buttons in a single dialog, ",
 StyleBox["Esc", "KeyEvent"],
 " will use the first one in the dialog."
}], "Notes",
 CellID->19169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->250243919],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->258046560],

Cell[TextData[{
 "Create dialog input and use ",
 Cell[BoxData[
  ButtonBox["CancelButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CancelButton"]], "InlineFormula"],
 " to cancel the action: "
}], "ExampleText",
 CellID->514893692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"CancelButton", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471235],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->678100393],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl91TG1UYh5nxf/DeC/8E7xwv1AvHGe2MU73QGUsYCcVOdep4oePYi06h
WqxTCiSFApYUaKG0lCAUqSGBkJAPCJDv74R88B1IAkuDBI/v7tkctkmgie4K
meHMkzPvefd39jyzycXmtYqvP6p4pays7A34vAUfuhaLL5cue+n9koOYP+h5
VkJkmR/7V18gec2DgXBeFoKRxejy+tpGPJ5MJre3tgol9Tz1UjJhanuboqid
7S0qGlk+zIT8tgs093kDkVDwB2nf659cLXvzW4F49YPLF+q6EolYMrHFl7nb
6aqs6Xj/UoNcodZqHAKh0mre++pm9fV7m5sJvsydNjs8EOWUQThtzLBCAQet
rcb4M7fBt4kQmpkOCAocAQctL63ybm6ejwBlnJG3Q/rc+rAt3Bg2X1pc4d3c
7liCI2Dmwu3g+ujOEQHhzOH+LvdSFtwmro/u5C5J5382x+eSUaB53i2Cmq+s
UUeAA9xYbueIgKDmO8/3cyFPL2vJzR+WIUuYhTNPpekjYOYdfFvhzPeZwX2k
+zwNfCuhzYUYXPNF/swdVovQ5nhg82iUt3dFeObwlqg0eZHAQ2nywEELCxEe
zb9r7Pn4R5lq1iecti2wDEd839jr9wX5MnfZnQGPA+SFfj8X13YE/S6vx8uX
OTwEkIdfu91SHGaT8aWQMNwfvlw4iMdnfnI4NT81PzU/yZyaH6/5hYt1Pm9w
YFB3va6zJNj7a0+rc1z6pl588QaYAy6XvyTgmrucYeYFNn3y+Xs/zTW320J7
e2lqJwXsMLA1BfMuWVIUG4AmCZM6Q7H51O3Wnrazb3efeafrzLu5QB+uQgZv
TKV2KWqXmJvnA4kktR5LrMfizJzI1PHseoMbIPn4i8vC80mY5Wc/TDc0orsy
1N6eh7syuAoZvDG2QW8h5rOz3sXlWCiyFgqvhMKrNLiOYFZZwkwd5sBeWqHz
bKCoPL30VInQ8BDq7z2U4SHI4L3h6Fo4sk7MjdNub2DR5Qln4WaLyEHT/eKS
rkPZmSLyITjCLRYh+QB6eJ/9gwEFhizlA5BhtkTc3ojHt0jMdXqnxRaYt/iA
OSszWw5mbpEPf26mwDyOZZvD6OPUGXO8y2z1We0LxBwKo8lpmHHoZxyGaYd+
2qkzOvV0AUsonHhmOlA7DPiqkQ7oZ5xswYSLzNNNt7gcyftRbxdN1uj+DXW1
o8c9YK7H95xxmua8xFyjtU1qLWoas1pjpguNZUKLC+jQlyZwQJOZM0ywSzMp
isgz93d9cY52lt1BshbU0Xyg3S5BbY3ozi2Qd1Wey2wx6wxO5fg8Np/U2sZU
swTFOFOMm5glPStUJm6AjWWu4pgiUxSexx3avLMNNdej2/XZz7zhBrr1C2pr
BnNyn0mt9fdhHTZXa6wjo/o/nhkYjJmCZoTGyDZH6ZpejhqZS1CTvHEk0ykq
D7Wrshy1N6dv1hHf3V8P6p2fryFpk7uyfAT7jBpUE3MPesdY80nr4LB26Knu
PzD1r/L0TP/OpU3Ja7VYdfun2iQDXm7W1KCmRsiQvQqlqbV9MGNu6x+Ygpeu
Y8F3XoQkkvUrVzZrruYCfSSV+KrKcfiJXDf652x9Qy9rrrb3PZx8/Eh7LJiq
P0UtUiQFJHmQSFBL6/SXn+Pwoz7t02ETvDFic5XKIutQdHcqjwV4J5mt/Mxf
XeGtEuXiPy8yVYkgg8Nd98ae9OtOiHlRnJofu/mE2tIpU9zvVp58urvG5AMH
5uHIhs+/6vOvlATRaJyYlyJg/g/KIy6O
   "], {{0, 0}, {62, 53}}, {0, 255}],
  ImageSize->{62 0.75, 53 0.75},
  PlotRange->{{0, 62}, {0, 53}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->344541808]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->617418671],

Cell["\<\
Create a dialog with both a default button and a cancel button: \
\>", "ExampleText",
 CellID->241947900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LocatorPane", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "prim", "]"}], ",", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "prim", "]"}], ",", 
    RowBox[{"DefaultButton", "[", 
     RowBox[{"DialogReturn", "[", "prim", "]"}], "]"}], ",", 
    RowBox[{"CancelButton", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855253469],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40456569],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnEtQVNkZx7sqC3fuzMZVajI142QxZjGpSVXcJKlJKlVoVcqZRaxk1Io4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   "], {{0, 0}, {134, 247}}, {0, 255}],
  ImageSize->{134 0.75, 247 0.75},
  PlotRange->{{0, 134}, {0, 247}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->29939086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172005215],

Cell["Create a dialog with a close button: ", "ExampleText",
 CellID->237161552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LocatorPane", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "prim", "]"}], ",", 
       RowBox[{"Framed", "@", 
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "prim", "]"}], ",", 
     RowBox[{"CancelButton", "[", 
      RowBox[{"\"\<Close\>\"", ",", 
       RowBox[{"DialogReturn", "[", "]"}]}], "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421586138],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnF1QU+kZxzPTC++8szdedbY7s9qLtRfb2c7Um7az7XRGnem4e1GnXXEK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   "], {{0, 0}, {134, 208}}, {0, 255}],
  ImageSize->{134 0.75, 208 0.75},
  PlotRange->{{0, 134}, {0, 208}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->431498034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->387154010],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CancelButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CancelButton"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1385754336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CancelButton", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->912973437],

Cell[BoxData[
 ButtonBox["\<\"Cancel\"\>",
  Appearance->"CancelButton",
  ButtonData->"paclet:ref/Cancel",
  ButtonFrame->"CancelButton",
  ButtonFunction:>DialogReturn[$Canceled],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{42, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1318619378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Cancel\>\"", ",", 
   RowBox[{"DialogReturn", "[", "$Canceled", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->692896157],

Cell[BoxData[
 ButtonBox["\<\"Cancel\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Cancel",
  ButtonFrame->"DialogBox",
  ButtonFunction:>DialogReturn[$Canceled],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{46, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->838949736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161237286],

Cell[TextData[{
 "Create a dialog with a cancel button; the dialog is dismissed by pressing \
the button or ",
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->237458103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CreateDialog", "[", 
  RowBox[{"CancelButton", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1251346509],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["in6_shm", 1, 1]], 32]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["None",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["in6_shm", 1, 1]], 32],
  Editable->False]], "Output",
 ImageSize->{177, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507487844],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl91TG1UYh5nxf/DeC/8E7xwv1AvHGe2MU73QGUsYCcVOdep4oePYi06h
WqxTCiSFApYUaKG0lCAUqSGBkJAPCJDv74R88B1IAkuDBI/v7tkctkmgie4K
meHMkzPvefd39jyzycXmtYqvP6p4pays7A34vAUfuhaLL5cue+n9koOYP+h5
VkJkmR/7V18gec2DgXBeFoKRxejy+tpGPJ5MJre3tgol9Tz1UjJhanuboqid
7S0qGlk+zIT8tgs093kDkVDwB2nf659cLXvzW4F49YPLF+q6EolYMrHFl7nb
6aqs6Xj/UoNcodZqHAKh0mre++pm9fV7m5sJvsydNjs8EOWUQThtzLBCAQet
rcb4M7fBt4kQmpkOCAocAQctL63ybm6ejwBlnJG3Q/rc+rAt3Bg2X1pc4d3c
7liCI2Dmwu3g+ujOEQHhzOH+LvdSFtwmro/u5C5J5382x+eSUaB53i2Cmq+s
UUeAA9xYbueIgKDmO8/3cyFPL2vJzR+WIUuYhTNPpekjYOYdfFvhzPeZwX2k
+zwNfCuhzYUYXPNF/swdVovQ5nhg82iUt3dFeObwlqg0eZHAQ2nywEELCxEe
zb9r7Pn4R5lq1iecti2wDEd839jr9wX5MnfZnQGPA+SFfj8X13YE/S6vx8uX
OTwEkIdfu91SHGaT8aWQMNwfvlw4iMdnfnI4NT81PzU/yZyaH6/5hYt1Pm9w
YFB3va6zJNj7a0+rc1z6pl588QaYAy6XvyTgmrucYeYFNn3y+Xs/zTW320J7
e2lqJwXsMLA1BfMuWVIUG4AmCZM6Q7H51O3Wnrazb3efeafrzLu5QB+uQgZv
TKV2KWqXmJvnA4kktR5LrMfizJzI1PHseoMbIPn4i8vC80mY5Wc/TDc0orsy
1N6eh7syuAoZvDG2QW8h5rOz3sXlWCiyFgqvhMKrNLiOYFZZwkwd5sBeWqHz
bKCoPL30VInQ8BDq7z2U4SHI4L3h6Fo4sk7MjdNub2DR5Qln4WaLyEHT/eKS
rkPZmSLyITjCLRYh+QB6eJ/9gwEFhizlA5BhtkTc3ojHt0jMdXqnxRaYt/iA
OSszWw5mbpEPf26mwDyOZZvD6OPUGXO8y2z1We0LxBwKo8lpmHHoZxyGaYd+
2qkzOvV0AUsonHhmOlA7DPiqkQ7oZ5xswYSLzNNNt7gcyftRbxdN1uj+DXW1
o8c9YK7H95xxmua8xFyjtU1qLWoas1pjpguNZUKLC+jQlyZwQJOZM0ywSzMp
isgz93d9cY52lt1BshbU0Xyg3S5BbY3ozi2Qd1Wey2wx6wxO5fg8Np/U2sZU
swTFOFOMm5glPStUJm6AjWWu4pgiUxSexx3avLMNNdej2/XZz7zhBrr1C2pr
BnNyn0mt9fdhHTZXa6wjo/o/nhkYjJmCZoTGyDZH6ZpejhqZS1CTvHEk0ykq
D7Wrshy1N6dv1hHf3V8P6p2fryFpk7uyfAT7jBpUE3MPesdY80nr4LB26Knu
PzD1r/L0TP/OpU3Ja7VYdfun2iQDXm7W1KCmRsiQvQqlqbV9MGNu6x+Ygpeu
Y8F3XoQkkvUrVzZrruYCfSSV+KrKcfiJXDf652x9Qy9rrrb3PZx8/Eh7LJiq
P0UtUiQFJHmQSFBL6/SXn+Pwoz7t02ETvDFic5XKIutQdHcqjwV4J5mt/Mxf
XeGtEuXiPy8yVYkgg8Nd98ae9OtOiHlRnJofu/mE2tIpU9zvVp58urvG5AMH
5uHIhs+/6vOvlATRaJyYlyJg/g/KIy6O
   "], {{0, 0}, {62, 53}}, {0, 255}],
  ImageSize->{62 0.75, 53 0.75},
  PlotRange->{{0, 62}, {0, 53}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->390064623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56950265],

Cell["\<\
Create a dialog that holds evaluations until the dialog is dismissed:\
\>", "ExampleText",
 CellID->2135742644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"CancelButton", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848524908],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217367832],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl91TG1UYh5nxf/DeC/8E7xwv1AvHGe2MU73QGUsYCcVOdep4oePYi06h
WqxTCiSFApYUaKG0lCAUqSGBkJAPCJDv74R88B1IAkuDBI/v7tkctkmgie4K
meHMkzPvefd39jyzycXmtYqvP6p4pays7A34vAUfuhaLL5cue+n9koOYP+h5
VkJkmR/7V18gec2DgXBeFoKRxejy+tpGPJ5MJre3tgol9Tz1UjJhanuboqid
7S0qGlk+zIT8tgs093kDkVDwB2nf659cLXvzW4F49YPLF+q6EolYMrHFl7nb
6aqs6Xj/UoNcodZqHAKh0mre++pm9fV7m5sJvsydNjs8EOWUQThtzLBCAQet
rcb4M7fBt4kQmpkOCAocAQctL63ybm6ejwBlnJG3Q/rc+rAt3Bg2X1pc4d3c
7liCI2Dmwu3g+ujOEQHhzOH+LvdSFtwmro/u5C5J5382x+eSUaB53i2Cmq+s
UUeAA9xYbueIgKDmO8/3cyFPL2vJzR+WIUuYhTNPpekjYOYdfFvhzPeZwX2k
+zwNfCuhzYUYXPNF/swdVovQ5nhg82iUt3dFeObwlqg0eZHAQ2nywEELCxEe
zb9r7Pn4R5lq1iecti2wDEd839jr9wX5MnfZnQGPA+SFfj8X13YE/S6vx8uX
OTwEkIdfu91SHGaT8aWQMNwfvlw4iMdnfnI4NT81PzU/yZyaH6/5hYt1Pm9w
YFB3va6zJNj7a0+rc1z6pl588QaYAy6XvyTgmrucYeYFNn3y+Xs/zTW320J7
e2lqJwXsMLA1BfMuWVIUG4AmCZM6Q7H51O3Wnrazb3efeafrzLu5QB+uQgZv
TKV2KWqXmJvnA4kktR5LrMfizJzI1PHseoMbIPn4i8vC80mY5Wc/TDc0orsy
1N6eh7syuAoZvDG2QW8h5rOz3sXlWCiyFgqvhMKrNLiOYFZZwkwd5sBeWqHz
bKCoPL30VInQ8BDq7z2U4SHI4L3h6Fo4sk7MjdNub2DR5Qln4WaLyEHT/eKS
rkPZmSLyITjCLRYh+QB6eJ/9gwEFhizlA5BhtkTc3ojHt0jMdXqnxRaYt/iA
OSszWw5mbpEPf26mwDyOZZvD6OPUGXO8y2z1We0LxBwKo8lpmHHoZxyGaYd+
2qkzOvV0AUsonHhmOlA7DPiqkQ7oZ5xswYSLzNNNt7gcyftRbxdN1uj+DXW1
o8c9YK7H95xxmua8xFyjtU1qLWoas1pjpguNZUKLC+jQlyZwQJOZM0ywSzMp
isgz93d9cY52lt1BshbU0Xyg3S5BbY3ozi2Qd1Wey2wx6wxO5fg8Np/U2sZU
swTFOFOMm5glPStUJm6AjWWu4pgiUxSexx3avLMNNdej2/XZz7zhBrr1C2pr
BnNyn0mt9fdhHTZXa6wjo/o/nhkYjJmCZoTGyDZH6ZpejhqZS1CTvHEk0ykq
D7Wrshy1N6dv1hHf3V8P6p2fryFpk7uyfAT7jBpUE3MPesdY80nr4LB26Knu
PzD1r/L0TP/OpU3Ja7VYdfun2iQDXm7W1KCmRsiQvQqlqbV9MGNu6x+Ygpeu
Y8F3XoQkkvUrVzZrruYCfSSV+KrKcfiJXDf652x9Qy9rrrb3PZx8/Eh7LJiq
P0UtUiQFJHmQSFBL6/SXn+Pwoz7t02ETvDFic5XKIutQdHcqjwV4J5mt/Mxf
XeGtEuXiPy8yVYkgg8Nd98ae9OtOiHlRnJofu/mE2tIpU9zvVp58urvG5AMH
5uHIhs+/6vOvlATRaJyYlyJg/g/KIy6O
   "], {{0, 0}, {62, 53}}, {0, 255}],
  ImageSize->{62 0.75, 53 0.75},
  PlotRange->{{0, 62}, {0, 53}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->44585225]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->628031507],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->342662332]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CancelButton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 6.9284202}", "context" -> "System`", 
    "keywords" -> {
     "cancel dialog", "close dialog window", "close button", 
      "exit dialog window", "exit button"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CancelButton[] represents a Cancel button in a dialog that closes the \
dialog window when pressed. CancelButton[action] represents a button labeled \
Cancel that evaluates action when pressed. CancelButton[label, action] uses \
label as the label for the button.", "synonyms" -> {"cancel button"}, "title" -> 
    "CancelButton", "type" -> "Symbol", "uri" -> "ref/CancelButton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7117, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->250243919]},
 "Notebook Image"->{
  Cell[8229, 271, 2029, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->344541808],
  Cell[11464, 355, 3966, 68, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->29939086],
  Cell[16317, 457, 3361, 58, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->431498034],
  Cell[23156, 654, 2029, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->390064623],
  Cell[25786, 718, 2028, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->44585225]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31266, 870},
 {"Notebook Image", 31407, 874}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1592, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2215, 65, 1577, 37, 70, "ObjectNameGrid"],
Cell[3795, 104, 1469, 45, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5301, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5779, 171, 595, 21, 70, "Notes",
 CellID->6334],
Cell[6377, 194, 482, 17, 70, "Notes",
 CellID->26500],
Cell[6862, 213, 218, 7, 70, "Notes",
 CellID->19169]
}, Closed]],
Cell[CellGroupData[{
Cell[7117, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->250243919],
Cell[CellGroupData[{
Cell[7502, 239, 148, 5, 70, "ExampleSection",
 CellID->258046560],
Cell[7653, 246, 241, 8, 70, "ExampleText",
 CellID->514893692],
Cell[CellGroupData[{
Cell[7919, 258, 138, 4, 28, "Input",
 CellID->471235],
Cell[8060, 264, 166, 5, 36, "Output",
 CellID->678100393],
Cell[8229, 271, 2029, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->344541808]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10307, 313, 227, 7, 70, "ExampleSection",
 CellID->617418671],
Cell[10537, 322, 115, 3, 70, "ExampleText",
 CellID->241947900],
Cell[CellGroupData[{
Cell[10677, 329, 616, 17, 70, "Input",
 CellID->855253469],
Cell[11296, 348, 165, 5, 36, "Output",
 CellID->40456569],
Cell[11464, 355, 3966, 68, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->29939086]
}, Open  ]],
Cell[15445, 426, 125, 3, 70, "ExampleDelimiter",
 CellID->172005215],
Cell[15573, 431, 80, 1, 70, "ExampleText",
 CellID->237161552],
Cell[CellGroupData[{
Cell[15678, 436, 636, 19, 70, "Input",
 CellID->421586138],
Cell[16317, 457, 3361, 58, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->431498034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19727, 521, 237, 7, 70, "ExampleSection",
 CellID->387154010],
Cell[19967, 530, 329, 12, 70, "ExampleText",
 CellID->1385754336],
Cell[CellGroupData[{
Cell[20321, 546, 103, 3, 70, "Input",
 CellID->912973437],
Cell[20427, 551, 372, 12, 70, "Output",
 CellID->1318619378]
}, Open  ]],
Cell[CellGroupData[{
Cell[20836, 568, 186, 5, 70, "Input",
 CellID->692896157],
Cell[21025, 575, 363, 12, 70, "Output",
 CellID->838949736]
}, Open  ]],
Cell[21403, 590, 125, 3, 70, "ExampleDelimiter",
 CellID->161237286],
Cell[21531, 595, 184, 6, 70, "ExampleText",
 CellID->237458103],
Cell[CellGroupData[{
Cell[21740, 605, 143, 4, 70, "Input",
 CellID->1251346509],
Cell[21886, 611, 1267, 41, 70, "Output",
 CellID->507487844],
Cell[23156, 654, 2029, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->390064623]
}, Open  ]],
Cell[25200, 693, 124, 3, 70, "ExampleDelimiter",
 CellID->56950265],
Cell[25327, 698, 121, 3, 70, "ExampleText",
 CellID->2135742644],
Cell[CellGroupData[{
Cell[25473, 705, 141, 4, 70, "Input",
 CellID->848524908],
Cell[25617, 711, 166, 5, 36, "Output",
 CellID->217367832],
Cell[25786, 718, 2028, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->44585225]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27875, 761, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[28194, 772, 1218, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[29449, 821, 319, 9, 70, "MoreAboutSection",
 CellID->628031507],
Cell[29771, 832, 135, 3, 70, "MoreAbout",
 CellID->342662332]
}, Open  ]],
Cell[29921, 838, 27, 0, 70, "History"],
Cell[29951, 840, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

