(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32679,       1155]
NotebookOptionsPosition[     26715,        959]
NotebookOutlinePosition[     28364,       1000]
CellTagsIndexPosition[     28279,        995]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finding Expressions That Match a Pattern\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Select" :> Documentation`HelpLookup["paclet:ref/Select"], 
          "BinLists" :> Documentation`HelpLookup["paclet:ref/BinLists"], 
          "Position" :> Documentation`HelpLookup["paclet:ref/Position"], 
          "MemberQ" :> Documentation`HelpLookup["paclet:ref/MemberQ"], 
          "Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "Collect" :> 
          Documentation`HelpLookup["paclet:ref/Collect"], "DeleteCases" :> 
          Documentation`HelpLookup["paclet:ref/DeleteCases"], "Except" :> 
          Documentation`HelpLookup["paclet:ref/Except"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Select\"\>", 2->"\<\"BinLists\"\>", 
       3->"\<\"Position\"\>", 4->"\<\"MemberQ\"\>", 5->"\<\"Count\"\>", 
       6->"\<\"StringCases\"\>", 7->"\<\"ReplaceList\"\>", 
       8->"\<\"Collect\"\>", 9->"\<\"DeleteCases\"\>", 
       10->"\<\"Except\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 3->"\<\"Elements of Lists\"\>", 
       4->"\<\"Expressions\"\>", 5->"\<\"Handling Arrays of Data\"\>", 
       6->"\<\"Language Overview\"\>", 7->"\<\"List Manipulation\"\>", 
       8->"\<\"Parts of Expressions\"\>", 
       9->"\<\"Pattern Matching Functions\"\>", 
       10->"\<\"Rules & Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cases", "ObjectName",
 CellID->29802],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cases"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that match the pattern. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cases"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{
         StyleBox["pattern", "TI"], "->", 
         StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the values of ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " corresponding to the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that match the pattern. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     " which match the pattern. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["pattern", "TI"], "->", 
         StyleBox["rhs", "TI"]}], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the values of ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " which match the pattern. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     "gives the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " parts in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " which match the pattern. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21999],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["pattern", "TI"], ":>", 
     StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " only when the pattern is found. "
}], "Notes",
 CellID->2380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->12789],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->6509],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->410],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->25734],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17366],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->15962],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->13158],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " looks at heads of expressions, and their parts."
}], "Notes",
 CellID->23722],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " traverses the parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in a depth-first order, with leaves visited before roots."
}], "Notes",
 CellID->25878]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->399890492],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->142700339],

Cell["Find cases that explicitly match integers:", "ExampleText",
 CellID->10797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"f", "[", "a", "]"}], ",", "2", ",", "3", ",", "y", ",", 
     RowBox[{"f", "[", "8", "]"}], ",", "9", ",", 
     RowBox[{"f", "[", "10", "]"}]}], "}"}], ",", "_Integer"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53200324]
}, Open  ]],

Cell["Find cases that do not match integers:", "ExampleText",
 CellID->453223069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"f", "[", "a", "]"}], ",", "2", ",", "3", ",", "y", ",", 
     RowBox[{"f", "[", "8", "]"}], ",", "9", ",", 
     RowBox[{"f", "[", "10", "]"}]}], "}"}], ",", 
   RowBox[{"Except", "[", "_Integer", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->648587074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", "y", ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->444563054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242796],

Cell[TextData[{
 "Return the ",
 Cell[BoxData["x"], "InlineFormula"],
 " from inside each ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " matched:"
}], "ExampleText",
 CellID->300609140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"f", "[", "a", "]"}], ",", "2", ",", "3", ",", "y", ",", 
     RowBox[{"f", "[", "8", "]"}], ",", "9", ",", 
     RowBox[{"f", "[", "10", "]"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], "\[Rule]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35598688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "8", ",", "10"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207500830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24763],

Cell["Find all cases of lists of two elements:", "ExampleText",
 CellID->28683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26899]
}, Open  ]],

Cell["Find the sum of every pair of elements:", "ExampleText",
 CellID->2709955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[Rule]", 
    RowBox[{"a", "+", "b"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430360617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "9", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202667832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132188852],

Cell[TextData[{
 "Pick out elements that are not ",
 Cell[BoxData["0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1936973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "2", ",", "0", ",", "3", ",", "5", ",", "6", ",", "7",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"Except", "[", "0", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66138594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "7"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9619458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354120046],

Cell["Pick out cases of integers down to level 2:", "ExampleText",
 CellID->364299321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "a", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "3", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "c", ",", "5", ",", "5"}], "}"}]}], "}"}], ",", 
   "_Integer", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7534488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "0", ",", "3", ",", "2", ",", "2", ",", "5", ",", "5"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423681827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116758099],

Cell[TextData[{
 "Use ",
 Cell[BoxData[":>"], "InlineFormula"],
 " to evaluate only after explicit elements have been found:"
}], "ExampleText",
 CellID->413113842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"{", "a", "}"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"{", "a", "}"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Length", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32714369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658770389]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17318],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9951],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->22859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1374684],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->244760376],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->163018204],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->248282342],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->92031796],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->320593621],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->49305938],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->599422997],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->157666673],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->863471517],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->919851478]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 9.6941160}", "context" -> "System`", 
    "keywords" -> {"criteria", "patterns"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cases[{e_1, e_2, ...}, pattern] gives a list of the e_i that match the \
pattern. Cases[{e_1, ...}, pattern -> rhs] gives a list of the values of rhs \
corresponding to the e_i that match the pattern. Cases[expr, pattern, \
levelspec] gives a list of all parts of expr on levels specified by levelspec \
which match the pattern. Cases[expr, pattern -> rhs, levelspec] gives the \
values of rhs which match the pattern. Cases[expr, pattern, levelspec, n] \
gives the first n parts in expr which match the pattern. ", "synonyms" -> {}, 
    "title" -> "Cases", "type" -> "Symbol", "uri" -> "ref/Cases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13358, 439, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->399890492]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28135, 988}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3992, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4615, 110, 43, 1, 70, "ObjectName",
 CellID->29802],
Cell[4661, 113, 3465, 111, 70, "Usage",
 CellID->28069]
}, Open  ]],
Cell[CellGroupData[{
Cell[8163, 229, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8641, 246, 326, 13, 70, "Notes",
 CellID->21999],
Cell[8970, 261, 425, 16, 70, "Notes",
 CellID->2380],
Cell[9398, 279, 197, 7, 70, "Notes",
 CellID->12789],
Cell[9598, 288, 1663, 55, 70, "2ColumnTableMod",
 CellID->6509],
Cell[11264, 345, 332, 14, 70, "Notes",
 CellID->410],
Cell[11599, 361, 303, 12, 70, "Notes",
 CellID->25734],
Cell[11905, 375, 312, 13, 70, "Notes",
 CellID->17366],
Cell[12220, 390, 189, 6, 70, "Notes",
 CellID->15962],
Cell[12412, 398, 134, 5, 70, "Notes",
 CellID->13158],
Cell[12549, 405, 461, 17, 70, "Notes",
 CellID->23722],
Cell[13013, 424, 308, 10, 70, "Notes",
 CellID->25878]
}, Closed]],
Cell[CellGroupData[{
Cell[13358, 439, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->399890492],
Cell[CellGroupData[{
Cell[13743, 453, 148, 5, 70, "ExampleSection",
 CellID->142700339],
Cell[13894, 460, 81, 1, 70, "ExampleText",
 CellID->10797],
Cell[CellGroupData[{
Cell[14000, 465, 343, 10, 28, "Input",
 CellID->22106],
Cell[14346, 477, 232, 7, 36, "Output",
 CellID->53200324]
}, Open  ]],
Cell[14593, 487, 81, 1, 70, "ExampleText",
 CellID->453223069],
Cell[CellGroupData[{
Cell[14699, 492, 378, 10, 28, "Input",
 CellID->648587074],
Cell[15080, 504, 312, 10, 36, "Output",
 CellID->444563054]
}, Open  ]],
Cell[15407, 517, 122, 3, 70, "ExampleDelimiter",
 CellID->242796],
Cell[15532, 522, 211, 8, 70, "ExampleText",
 CellID->300609140],
Cell[CellGroupData[{
Cell[15768, 534, 397, 11, 70, "Input",
 CellID->35598688],
Cell[16168, 547, 214, 7, 36, "Output",
 CellID->207500830]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16431, 560, 216, 7, 70, "ExampleSection",
 CellID->24763],
Cell[16650, 569, 79, 1, 70, "ExampleText",
 CellID->28683],
Cell[CellGroupData[{
Cell[16754, 574, 496, 17, 70, "Input",
 CellID->10704],
Cell[17253, 593, 357, 13, 36, "Output",
 CellID->26899]
}, Open  ]],
Cell[17625, 609, 80, 1, 70, "ExampleText",
 CellID->2709955],
Cell[CellGroupData[{
Cell[17730, 614, 559, 19, 70, "Input",
 CellID->430360617],
Cell[18292, 635, 213, 7, 36, "Output",
 CellID->202667832]
}, Open  ]],
Cell[18520, 645, 125, 3, 70, "ExampleDelimiter",
 CellID->132188852],
Cell[18648, 650, 131, 5, 70, "ExampleText",
 CellID->1936973],
Cell[CellGroupData[{
Cell[18804, 659, 307, 9, 70, "Input",
 CellID->66138594],
Cell[19114, 670, 245, 8, 36, "Output",
 CellID->9619458]
}, Open  ]],
Cell[19374, 681, 125, 3, 70, "ExampleDelimiter",
 CellID->354120046],
Cell[19502, 686, 86, 1, 70, "ExampleText",
 CellID->364299321],
Cell[CellGroupData[{
Cell[19613, 691, 421, 13, 70, "Input",
 CellID->7534488],
Cell[20037, 706, 270, 9, 36, "Output",
 CellID->423681827]
}, Open  ]],
Cell[20322, 718, 125, 3, 70, "ExampleDelimiter",
 CellID->116758099],
Cell[20450, 723, 164, 5, 70, "ExampleText",
 CellID->413113842],
Cell[CellGroupData[{
Cell[20639, 732, 607, 20, 70, "Input",
 CellID->32714369],
Cell[21249, 754, 213, 7, 36, "Output",
 CellID->658770389]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21523, 768, 311, 9, 70, "SeeAlsoSection",
 CellID->17318],
Cell[21837, 779, 2410, 89, 70, "SeeAlso",
 CellID->6043]
}, Open  ]],
Cell[CellGroupData[{
Cell[24284, 873, 313, 9, 70, "TutorialsSection",
 CellID->9951],
Cell[24600, 884, 189, 4, 70, "Tutorials",
 CellID->22859]
}, Open  ]],
Cell[CellGroupData[{
Cell[24826, 893, 317, 9, 70, "MoreAboutSection",
 CellID->1374684],
Cell[25146, 904, 136, 3, 70, "MoreAbout",
 CellID->244760376],
Cell[25285, 909, 157, 3, 70, "MoreAbout",
 CellID->163018204],
Cell[25445, 914, 144, 3, 70, "MoreAbout",
 CellID->248282342],
Cell[25592, 919, 133, 3, 70, "MoreAbout",
 CellID->92031796],
Cell[25728, 924, 155, 3, 70, "MoreAbout",
 CellID->320593621],
Cell[25886, 929, 144, 3, 70, "MoreAbout",
 CellID->49305938],
Cell[26033, 934, 145, 3, 70, "MoreAbout",
 CellID->599422997],
Cell[26181, 939, 150, 3, 70, "MoreAbout",
 CellID->157666673],
Cell[26334, 944, 162, 3, 70, "MoreAbout",
 CellID->863471517],
Cell[26499, 949, 144, 3, 70, "MoreAbout",
 CellID->919851478]
}, Open  ]],
Cell[26658, 955, 27, 0, 70, "History"],
Cell[26688, 957, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

