(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24953,        914]
NotebookOptionsPosition[     19885,        734]
NotebookOutlinePosition[     21119,        770]
CellTagsIndexPosition[     21034,        765]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binomial" :> Documentation`HelpLookup["paclet:ref/Binomial"], 
          "ProductLog" :> 
          Documentation`HelpLookup["paclet:ref/ProductLog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binomial\"\>", 
       2->"\<\"ProductLog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Integer Functions\"\>", 
       3->"\<\"Recurrence and Sum Functions\"\>", 
       4->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CatalanNumber", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CatalanNumber",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CatalanNumber"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " Catalan number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["C", "n"], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CatalanNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CatalanNumber"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"n", "+", "1"}]], 
    TagBox[
     RowBox[{"(", GridBox[{
        {
         TagBox[
          RowBox[{"2", " ", "n"}],
          Identity,
          Editable->True,
          Selectable->True]},
        {
         TagBox["n",
          Identity,
          Editable->True,
          Selectable->True]}
       }], ")"}],
     InterpretTemplate[Binomial[#, #2]& ],
     Editable->False,
     Selectable->False]}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->16338],

Cell["\<\
Catalan numbers are integers, and appear in various tree enumeration \
problems.\
\>", "Notes",
 CellID->22424]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145346654],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169749721],

Cell["The first 10 Catalan numbers:", "ExampleText",
 CellID->31349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CatalanNumber", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "14", ",", "42", ",", "132", ",", "429", ",", 
   "1430", ",", "4862", ",", "16796"}], "}"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449950844]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15847],

Cell["Evaluate for large arguments:", "ExampleText",
 CellID->495060884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CatalanNumber", "[", "100000", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57322369],

Cell[BoxData[
 TagBox[
  RowBox[{"178054508182306190783757339065890201", 
   RowBox[{"\[LeftSkeleton]", "60126", "\[RightSkeleton]"}], 
   "4946049551384445058055232123705950784"}],
  Short]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->151914919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396017423],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->29313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CatalanNumber", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "5", ",", "14"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->753962993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->839],

Cell[TextData[{
 "Catalan studied the problem of numbering the different ways to parenthesize \
an expression. We can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s pattern matcher to check this result:"
}], "ExampleText",
 CellID->21157],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[TextData[{
 "Distribute over lists in ",
 Cell[BoxData[
  ButtonBox["AngleBracket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AngleBracket"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3856],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CirclePlus", "[", "x__", "]"}], "/;", 
   RowBox[{"!", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"Unevaluated", "[", 
       RowBox[{"CirclePlus", "[", "x", "]"}], "]"}], ",", "List"}], "]"}]}]}],
   ":=", 
  RowBox[{"Distribute", "[", 
   RowBox[{
    RowBox[{"Unevaluated", "[", 
     RowBox[{"CirclePlus", "[", "x", "]"}], "]"}], ",", "List"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4485],

Cell["\<\
Use the pattern matcher to repeatedly split the list into two parts in all \
possible ways:\
\>", "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parenthesizedlist", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x__", "]"}], ":>", 
      RowBox[{"ReplaceList", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"u_", ",", "v_"}], "]"}], ":>", 
         RowBox[{"CirclePlus", "[", 
          RowBox[{"u", ",", "v"}], "]"}]}]}], "]"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31022],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[CirclePlus]", 
    RowBox[{"(", 
     RowBox[{"b", "\[CirclePlus]", 
      RowBox[{"(", 
       RowBox[{"c", "\[CirclePlus]", "d"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"a", "\[CirclePlus]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "\[CirclePlus]", "c"}], ")"}], "\[CirclePlus]", "d"}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "\[CirclePlus]", "b"}], ")"}], "\[CirclePlus]", 
    RowBox[{"(", 
     RowBox[{"c", "\[CirclePlus]", "d"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "\[CirclePlus]", 
      RowBox[{"(", 
       RowBox[{"b", "\[CirclePlus]", "c"}], ")"}]}], ")"}], "\[CirclePlus]", 
    "d"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "\[CirclePlus]", "b"}], ")"}], "\[CirclePlus]", "c"}], 
     ")"}], "\[CirclePlus]", "d"}]}], "}"}]], "Output",
 ImageSize->{512, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67284846]
}, Open  ]],

Cell[TextData[{
 "The number of ways to parenthesize the expression ",
 Cell[BoxData[
  RowBox[{
  "a", "\[CirclePlus]", "b", "\[CirclePlus]", "c", "\[CirclePlus]", "d"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "parenthesizedlist", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11383],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->394217881]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->24499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CatalanNumber", "[", "3", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3061],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->9551971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17135],

Cell["The generating function for Catalan numbers:", "ExampleText",
 CellID->12100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"4", "x"}]}]]}], 
    RowBox[{"2", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21479],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"14", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"42", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"132", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"429", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"1430", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"4862", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"16796", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 2, 5, 14, 42, 132, 429, 1430, 4862, 
   16796}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{517, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661889152]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CatalanNumber", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35163439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "5", ",", "14", ",", "42", ",", "132", ",", 
   "429", ",", "1430", ",", "4862"}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39095626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9699],

Cell[TextData[{
 "The only odd Catalan numbers are those of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CatalanNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CatalanNumber"], "[", 
   RowBox[{
    SuperscriptBox["2", 
     StyleBox["k", "TI"]], "-", "1"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"CatalanNumber", "[", 
      RowBox[{
       SuperscriptBox["2", "n"], "-", "1"}], "]"}], ",", "10"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "5", ",", "9", ",", "5", ",", "9", ",", "5", ",", "9", ",", "7", 
   ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "5", ",", "5", ",", "5", ",", "5", ",", "5"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453832230]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26059],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->70],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->118]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->479551552],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->143803120],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->147450375],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->286086958],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->341817559]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CatalanNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 10.8503956}", "context" -> "System`", 
    "keywords" -> {"Catalan number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CatalanNumber[n] gives the n\\[Null]^th Catalan number C_n.", 
    "synonyms" -> {"catalan number"}, "title" -> "CatalanNumber", "type" -> 
    "Symbol", "uri" -> "ref/CatalanNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6819, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145346654]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20891, 758}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2414, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3037, 85, 1578, 37, 70, "ObjectNameGrid"],
Cell[4618, 124, 756, 25, 70, "Usage",
 CellID->18418]
}, Open  ]],
Cell[CellGroupData[{
Cell[5411, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5889, 171, 769, 32, 70, "Notes",
 CellID->16338],
Cell[6661, 205, 121, 4, 70, "Notes",
 CellID->22424]
}, Closed]],
Cell[CellGroupData[{
Cell[6819, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145346654],
Cell[CellGroupData[{
Cell[7204, 228, 148, 5, 70, "ExampleSection",
 CellID->169749721],
Cell[7355, 235, 68, 1, 70, "ExampleText",
 CellID->31349],
Cell[CellGroupData[{
Cell[7448, 240, 211, 7, 28, "Input",
 CellID->10923],
Cell[7662, 249, 307, 9, 36, "Output",
 CellID->449950844]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8018, 264, 216, 7, 70, "ExampleSection",
 CellID->15847],
Cell[8237, 273, 72, 1, 70, "ExampleText",
 CellID->495060884],
Cell[CellGroupData[{
Cell[8334, 278, 141, 4, 70, "Input",
 CellID->57322369],
Cell[8478, 284, 340, 10, 54, "Output",
 CellID->151914919]
}, Open  ]],
Cell[8833, 297, 125, 3, 70, "ExampleDelimiter",
 CellID->396017423],
Cell[8961, 302, 216, 7, 70, "ExampleText",
 CellID->29313],
Cell[CellGroupData[{
Cell[9202, 313, 171, 5, 70, "Input",
 CellID->2786],
Cell[9376, 320, 224, 7, 36, "Output",
 CellID->753962993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9649, 333, 221, 7, 70, "ExampleSection",
 CellID->839],
Cell[9873, 342, 269, 7, 70, "ExampleText",
 CellID->21157],
Cell[10145, 351, 189, 6, 70, "Input",
 CellID->5668],
Cell[10337, 359, 211, 8, 70, "ExampleText",
 CellID->3856],
Cell[10551, 369, 469, 16, 70, "Input",
 CellID->4485],
Cell[11023, 387, 138, 4, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[11186, 395, 607, 19, 70, "Input",
 CellID->31022],
Cell[11796, 416, 1076, 35, 36, "Output",
 CellID->67284846]
}, Open  ]],
Cell[12887, 454, 233, 8, 70, "ExampleText",
 CellID->32735],
Cell[CellGroupData[{
Cell[13145, 466, 114, 3, 70, "Input",
 CellID->11383],
Cell[13262, 471, 158, 5, 36, "Output",
 CellID->394217881]
}, Open  ]],
Cell[13435, 479, 45, 1, 70, "ExampleText",
 CellID->24499],
Cell[CellGroupData[{
Cell[13505, 484, 104, 3, 70, "Input",
 CellID->3061],
Cell[13612, 489, 156, 5, 36, "Output",
 CellID->9551971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13817, 500, 233, 7, 70, "ExampleSection",
 CellID->17135],
Cell[14053, 509, 83, 1, 70, "ExampleText",
 CellID->12100],
Cell[CellGroupData[{
Cell[14161, 514, 313, 12, 70, "Input",
 CellID->21479],
Cell[14477, 528, 1038, 33, 36, "Output",
 CellID->661889152]
}, Open  ]],
Cell[CellGroupData[{
Cell[15552, 566, 223, 7, 70, "Input",
 CellID->35163439],
Cell[15778, 575, 302, 9, 36, "Output",
 CellID->39095626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16129, 590, 223, 7, 70, "ExampleSection",
 CellID->9699],
Cell[16355, 599, 343, 12, 70, "ExampleText",
 CellID->30101],
Cell[CellGroupData[{
Cell[16723, 615, 325, 11, 70, "Input",
 CellID->9407],
Cell[17051, 628, 395, 10, 36, "Output",
 CellID->453832230]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17507, 645, 311, 9, 70, "SeeAlsoSection",
 CellID->26059],
Cell[17821, 656, 454, 17, 70, "SeeAlso",
 CellID->7483]
}, Open  ]],
Cell[CellGroupData[{
Cell[18312, 678, 311, 9, 70, "TutorialsSection",
 CellID->70],
Cell[18626, 689, 154, 3, 70, "Tutorials",
 CellID->118]
}, Open  ]],
Cell[CellGroupData[{
Cell[18817, 697, 319, 9, 70, "MoreAboutSection",
 CellID->479551552],
Cell[19139, 708, 157, 3, 70, "MoreAbout",
 CellID->143803120],
Cell[19299, 713, 145, 3, 70, "MoreAbout",
 CellID->147450375],
Cell[19447, 718, 165, 3, 70, "MoreAbout",
 CellID->286086958],
Cell[19615, 723, 198, 4, 70, "MoreAbout",
 CellID->341817559]
}, Open  ]],
Cell[19828, 730, 27, 0, 70, "History"],
Cell[19858, 732, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

