(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39638,       1550]
NotebookOptionsPosition[     30642,       1229]
NotebookOutlinePosition[     32344,       1277]
CellTagsIndexPosition[     32231,       1271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Throw" :> Documentation`HelpLookup["paclet:ref/Throw"], 
          "Check" :> Documentation`HelpLookup["paclet:ref/Check"], 
          "CheckAbort" :> Documentation`HelpLookup["paclet:ref/CheckAbort"], 
          "Reap" :> Documentation`HelpLookup["paclet:ref/Reap"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Throw\"\>", 2->"\<\"Check\"\>", 
       3->"\<\"CheckAbort\"\>", 4->"\<\"Reap\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>", 3->"\<\"Procedural Programming\"\>", 
       4->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Catch", "ObjectName",
 CellID->10823],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Catch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Catch"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the argument of the first ",
     Cell[BoxData[
      ButtonBox["Throw",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
     " generated in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Catch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Catch"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"],
     " from the first ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Throw",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Throw"], "[", 
       RowBox[{
        StyleBox["value", "TI"], ",", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Catch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Catch"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["value", "TI"], ",", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30857]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " always returns the value of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " if no ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " was generated during the evaluation. "
}], "Notes",
 CellID->12172],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be any expression, and is often a pattern. "
}], "Notes",
 CellID->3674],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"], "[", 
   RowBox[{
    StyleBox["value", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " is re\[Hyphen]evaluated every time it is compared to ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27358]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152613104],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->241263815],

Cell[TextData[{
 "Exit to the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " as soon as the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is evaluated:"
}], "ExampleText",
 CellID->27287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"a", ";", "b", ";", 
   RowBox[{"Throw", "[", "c", "]"}], ";", "d", ";", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13530],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20535],

Cell["Define a function that can \"throw an exception\":", "ExampleText",
 CellID->29134],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", ">", "10"}], ",", 
    RowBox[{"Throw", "[", "overflow", "]"}], ",", 
    RowBox[{"x", "!"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8378],

Cell[TextData[{
 "The result of the ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " is just what is thrown by ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], "+", 
   RowBox[{"f", "[", "11", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7718],

Cell[BoxData["overflow"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10181]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], "+", 
   RowBox[{"f", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22212],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1856],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit a loop when a criterion is satisfied:"
}], "ExampleText",
 CellID->10939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "!"}], ">", 
       RowBox[{"10", "^", "10"}]}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3666],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24553]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27985],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " can catch a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " from inside essentially any function:"
}], "ExampleText",
 CellID->9867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"#", "<", "0"}], ",", 
      RowBox[{"Throw", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31115],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2098]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Throw", "[", "b", "]"}], ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31284],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"b", "^", "2"}], "+", 
    RowBox[{"c", "^", "2"}]}], "/.", 
   RowBox[{"b", ":>", 
    RowBox[{"Throw", "[", "bbb", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7726],

Cell[BoxData["bbb"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6907],

Cell[TextData[{
 "The nearest enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Catch", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Throw", "[", "b", "]"}], ",", "c"}], "}"}], "]"}], ",", "d", 
    ",", "e"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " picks up the first ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " that is evaluated:"
}], "ExampleText",
 CellID->14951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Throw", "[", "a", "]"}], ",", 
    RowBox[{"Throw", "[", "b", "]"}], ",", 
    RowBox[{"Throw", "[", "c", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Throw", "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31065],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322756903],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " need not occur lexically inside ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13560365],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", "<", "0"}], ",", 
      RowBox[{"Throw", "[", "\"\<negative\>\"", "]"}]}], "]"}], ";", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65891506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"f", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5", ",", 
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->811342396],

Cell[BoxData["\<\"negative\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365166309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291242442],

Cell["A function that can throw a number of different exceptions:", \
"ExampleText",
 CellID->868786],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Which", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"Throw", "[", 
     RowBox[{"x", ",", 
      RowBox[{"error", "[", "negative", "]"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"x", "\[Equal]", "0"}], ",", 
    RowBox[{"Throw", "[", 
     RowBox[{"x", ",", 
      RowBox[{"error", "[", "zero", "]"}]}], "]"}], ",", 
    "\[IndentingNewLine]", "True", ",", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "x", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323154526],

Cell["A handler for the possible exceptions:", "ExampleText",
 CellID->31643783],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", "x_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Catch", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"error", "[", "_", "]"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"value", ",", "tag"}], "}"}], ",", 
      RowBox[{"tag", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"error", "[", "negative", "]"}], "\[RuleDelayed]", 
          "Indeterminate"}], ",", 
         RowBox[{
          RowBox[{"error", "[", "zero", "]"}], "\[RuleDelayed]", "Infinity"}],
          ",", 
         RowBox[{"_", "\[RuleDelayed]", 
          RowBox[{"Throw", "[", 
           RowBox[{"value", ",", "tag"}], "]"}]}]}], "}"}]}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->665790592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50025876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "\[Infinity]", ",", "1"}], "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->560913739]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26799],

Cell[TextData[{
 "Catch the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " with tag ",
 Cell[BoxData["u"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"Throw", "[", 
    RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24647],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9539],

Cell[TextData[{
 "The inner ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}], "]"}], ",", "v"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29267],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28540]
}, Open  ]],

Cell[TextData[{
 "The outer ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"a", ",", "u"}], "]"}], ",", "v"}], "]"}], "]"}], ",", "u"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10878],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24207],

Cell["Keep the tag local:", "ExampleText",
 CellID->30103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Throw", "[", 
      RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}]}], "]"}]], "Input",
 CellTags->"S2.6.10",
 CellLabel->"In[1]:=",
 CellID->26754],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.6.10",
 CellLabel->"Out[1]=",
 CellID->6567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413181373]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17258],

Cell[TextData[{
 "Find the next prime after ",
 Cell[BoxData[
  SuperscriptBox["10", "10"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"10", "^", "10"}], ",", 
      RowBox[{
       RowBox[{"10", "^", "10"}], "+", "1000"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27857],

Cell[BoxData["10000000019"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21922],

Cell["Find the first power of 17 equal to 1 mod 19:", "ExampleText",
 CellID->9704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"17", "^", "i"}], ",", "19"}], "]"}], "==", "1"}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "19"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1381],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30089],

Cell["Stop if an iteration gets too large:", "ExampleText",
 CellID->21517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "+", "1"}], "&"}], ",", "2", ",", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "26", ",", "677", ",", "458330", ",", "210066388901", 
   ",", "44127887745906175987802"}], "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18574]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", "1000"}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"#", "^", "2"}], "+", "1"}]}], "]"}], "&"}], ",", "2", ",", 
    "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11046],

Cell[BoxData["458330"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2944],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " to throw an exception if a message is generated:"
}], "ExampleText",
 CellID->15268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"2", "+", 
   RowBox[{"Check", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", "0"}]}], ")"}]}], ",", 
     RowBox[{"Throw", "[", "error", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7103],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->55038652],

Cell[BoxData["error"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101166320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"2", "+", 
   RowBox[{"Check", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], ",", 
     RowBox[{"Throw", "[", "error", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12613],

Cell[BoxData[
 FractionBox["8", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->854639145]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12823],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CheckAbort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CheckAbort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7483],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->22104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->214665280],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->604614470],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->210598849],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->40975041],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->490957338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Catch"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Catch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 14.5379900}", "context" -> "System`", 
    "keywords" -> {
     "computed goto", "control", "divert", "errors", "handling of errors", 
      "jump", "longjmp", "non-local returns", "scope", "stop"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Catch[expr] returns the argument of the first Throw generated in the \
evaluation of expr. Catch[expr, form] returns value from the first \
Throw[value, tag] for which form matches tag. Catch[expr, form, f] returns \
f[value, tag]. ", "synonyms" -> {"handle"}, "title" -> "Catch", "type" -> 
    "Symbol", "uri" -> "ref/Catch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6917, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->152613104]},
 "S2.6.10"->{
  Cell[21319, 849, 287, 10, 70, "Input",
   CellTags->"S2.6.10",
   CellID->26754],
  Cell[21609, 861, 175, 6, 36, "Output",
   CellTags->"S2.6.10",
   CellID->6567]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31906, 1257},
 {"S2.6.10", 32040, 1261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2438, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3061, 83, 43, 1, 70, "ObjectName",
 CellID->10823],
Cell[3107, 86, 2116, 71, 70, "Usage",
 CellID->30857]
}, Open  ]],
Cell[CellGroupData[{
Cell[5260, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5738, 179, 528, 19, 70, "Notes",
 CellID->12172],
Cell[6269, 200, 155, 5, 70, "Notes",
 CellID->3674],
Cell[6427, 207, 453, 17, 70, "Notes",
 CellID->27358]
}, Closed]],
Cell[CellGroupData[{
Cell[6917, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152613104],
Cell[CellGroupData[{
Cell[7302, 243, 148, 5, 70, "ExampleSection",
 CellID->241263815],
Cell[7453, 250, 342, 13, 70, "ExampleText",
 CellID->27287],
Cell[CellGroupData[{
Cell[7820, 267, 183, 5, 28, "Input",
 CellID->13530],
Cell[8006, 274, 154, 5, 36, "Output",
 CellID->27454]
}, Open  ]],
Cell[8175, 282, 121, 3, 70, "ExampleDelimiter",
 CellID->20535],
Cell[8299, 287, 89, 1, 70, "ExampleText",
 CellID->29134],
Cell[8391, 290, 267, 9, 70, "Input",
 CellID->8378],
Cell[8661, 301, 335, 13, 70, "ExampleText",
 CellID->2386],
Cell[CellGroupData[{
Cell[9021, 318, 178, 6, 70, "Input",
 CellID->7718],
Cell[9202, 326, 161, 5, 36, "Output",
 CellID->10181]
}, Open  ]],
Cell[CellGroupData[{
Cell[9400, 336, 178, 6, 70, "Input",
 CellID->22212],
Cell[9581, 344, 154, 5, 36, "Output",
 CellID->14750]
}, Open  ]],
Cell[9750, 352, 120, 3, 70, "ExampleDelimiter",
 CellID->1856],
Cell[9873, 357, 222, 8, 70, "ExampleText",
 CellID->10939],
Cell[CellGroupData[{
Cell[10120, 369, 375, 13, 70, "Input",
 CellID->3666],
Cell[10498, 384, 155, 5, 36, "Output",
 CellID->24553]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10702, 395, 216, 7, 70, "ExampleSection",
 CellID->27985],
Cell[10921, 404, 335, 12, 70, "ExampleText",
 CellID->9867],
Cell[CellGroupData[{
Cell[11281, 420, 370, 12, 70, "Input",
 CellID->31115],
Cell[11654, 434, 170, 6, 36, "Output",
 CellID->2098]
}, Open  ]],
Cell[CellGroupData[{
Cell[11861, 445, 188, 6, 70, "Input",
 CellID->31284],
Cell[12052, 453, 154, 5, 36, "Output",
 CellID->27516]
}, Open  ]],
Cell[CellGroupData[{
Cell[12243, 463, 290, 10, 70, "Input",
 CellID->7726],
Cell[12536, 475, 155, 5, 36, "Output",
 CellID->7464]
}, Open  ]],
Cell[12706, 483, 120, 3, 70, "ExampleDelimiter",
 CellID->6907],
Cell[12829, 488, 326, 13, 70, "ExampleText",
 CellID->12651],
Cell[CellGroupData[{
Cell[13180, 505, 293, 10, 70, "Input",
 CellID->32210],
Cell[13476, 517, 209, 7, 36, "Output",
 CellID->27438]
}, Open  ]],
Cell[13700, 527, 121, 3, 70, "ExampleDelimiter",
 CellID->26195],
Cell[13824, 532, 324, 12, 70, "ExampleText",
 CellID->14951],
Cell[CellGroupData[{
Cell[14173, 548, 253, 8, 70, "Input",
 CellID->20],
Cell[14429, 558, 154, 5, 36, "Output",
 CellID->29184]
}, Open  ]],
Cell[CellGroupData[{
Cell[14620, 568, 184, 6, 70, "Input",
 CellID->31065],
Cell[14807, 576, 153, 5, 36, "Output",
 CellID->6692]
}, Open  ]],
Cell[14975, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->322756903],
Cell[15103, 589, 322, 12, 70, "ExampleText",
 CellID->13560365],
Cell[15428, 603, 336, 11, 70, "Input",
 CellID->65891506],
Cell[CellGroupData[{
Cell[15789, 618, 300, 10, 70, "Input",
 CellID->811342396],
Cell[16092, 630, 173, 5, 36, "Output",
 CellID->365166309]
}, Open  ]],
Cell[16280, 638, 125, 3, 70, "ExampleDelimiter",
 CellID->291242442],
Cell[16408, 643, 101, 2, 70, "ExampleText",
 CellID->868786],
Cell[16512, 647, 618, 18, 70, "Input",
 CellID->323154526],
Cell[17133, 667, 80, 1, 70, "ExampleText",
 CellID->31643783],
Cell[17216, 670, 838, 25, 70, "Input",
 CellID->665790592],
Cell[CellGroupData[{
Cell[18079, 699, 170, 6, 70, "Input",
 CellID->50025876],
Cell[18252, 707, 236, 7, 36, "Output",
 CellID->560913739]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18537, 720, 239, 7, 70, "ExampleSection",
 CellID->26799],
Cell[18779, 729, 236, 10, 70, "ExampleText",
 CellID->10746],
Cell[CellGroupData[{
Cell[19040, 743, 178, 6, 70, "Input",
 CellID->24647],
Cell[19221, 751, 153, 5, 36, "Output",
 CellID->3078]
}, Open  ]],
Cell[19389, 759, 120, 3, 70, "ExampleDelimiter",
 CellID->9539],
Cell[19512, 764, 314, 13, 70, "ExampleText",
 CellID->10959],
Cell[CellGroupData[{
Cell[19851, 781, 276, 10, 70, "Input",
 CellID->29267],
Cell[20130, 793, 181, 6, 36, "Output",
 CellID->28540]
}, Open  ]],
Cell[20326, 802, 314, 13, 70, "ExampleText",
 CellID->10325],
Cell[CellGroupData[{
Cell[20665, 819, 276, 10, 70, "Input",
 CellID->10878],
Cell[20944, 831, 153, 5, 36, "Output",
 CellID->9428]
}, Open  ]],
Cell[21112, 839, 121, 3, 70, "ExampleDelimiter",
 CellID->24207],
Cell[21236, 844, 58, 1, 70, "ExampleText",
 CellID->30103],
Cell[CellGroupData[{
Cell[21319, 849, 287, 10, 70, "Input",
 CellTags->"S2.6.10",
 CellID->26754],
Cell[21609, 861, 175, 6, 36, "Output",
 CellTags->"S2.6.10",
 CellID->6567]
}, Open  ]],
Cell[21799, 870, 125, 3, 70, "ExampleDelimiter",
 CellID->413181373]
}, Closed]],
Cell[CellGroupData[{
Cell[21961, 878, 223, 7, 70, "ExampleSection",
 CellID->17258],
Cell[22187, 887, 150, 6, 70, "ExampleText",
 CellID->22857],
Cell[CellGroupData[{
Cell[22362, 897, 433, 15, 70, "Input",
 CellID->27857],
Cell[22798, 914, 163, 5, 36, "Output",
 CellID->3069]
}, Open  ]],
Cell[22976, 922, 121, 3, 70, "ExampleDelimiter",
 CellID->21922],
Cell[23100, 927, 83, 1, 70, "ExampleText",
 CellID->9704],
Cell[CellGroupData[{
Cell[23208, 932, 418, 14, 70, "Input",
 CellID->1381],
Cell[23629, 948, 154, 5, 36, "Output",
 CellID->11821]
}, Open  ]],
Cell[23798, 956, 121, 3, 70, "ExampleDelimiter",
 CellID->30089],
Cell[23922, 961, 75, 1, 70, "ExampleText",
 CellID->21517],
Cell[CellGroupData[{
Cell[24022, 966, 206, 8, 70, "Input",
 CellID->28073],
Cell[24231, 976, 298, 9, 36, "Output",
 CellID->18574]
}, Open  ]],
Cell[CellGroupData[{
Cell[24566, 990, 385, 13, 70, "Input",
 CellID->11046],
Cell[24954, 1005, 159, 5, 36, "Output",
 CellID->10805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25162, 1016, 232, 7, 70, "ExampleSection",
 CellID->2944],
Cell[25397, 1025, 225, 8, 70, "ExampleText",
 CellID->15268],
Cell[CellGroupData[{
Cell[25647, 1037, 326, 11, 70, "Input",
 CellID->7103],
Cell[25976, 1050, 366, 7, 70, "Message",
 CellID->55038652],
Cell[26345, 1059, 162, 5, 36, "Output",
 CellID->101166320]
}, Open  ]],
Cell[CellGroupData[{
Cell[26544, 1069, 327, 11, 70, "Input",
 CellID->12613],
Cell[26874, 1082, 178, 6, 51, "Output",
 CellID->854639145]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27113, 1095, 311, 9, 70, "SeeAlsoSection",
 CellID->12823],
Cell[27427, 1106, 924, 35, 70, "SeeAlso",
 CellID->9188]
}, Open  ]],
Cell[CellGroupData[{
Cell[28388, 1146, 313, 9, 70, "TutorialsSection",
 CellID->7483],
Cell[28704, 1157, 164, 3, 70, "Tutorials",
 CellID->22104]
}, Open  ]],
Cell[CellGroupData[{
Cell[28905, 1165, 319, 9, 70, "MoreAboutSection",
 CellID->214665280],
Cell[29227, 1176, 135, 3, 70, "MoreAbout",
 CellID->604614470],
Cell[29365, 1181, 147, 3, 70, "MoreAbout",
 CellID->210598849],
Cell[29515, 1186, 154, 3, 70, "MoreAbout",
 CellID->40975041],
Cell[29672, 1191, 147, 3, 70, "MoreAbout",
 CellID->490957338]
}, Open  ]],
Cell[CellGroupData[{
Cell[29856, 1199, 305, 8, 70, "RelatedLinksSection"],
Cell[30164, 1209, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[30562, 1225, 50, 0, 70, "History"],
Cell[30615, 1227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

