(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    120039,       2666]
NotebookOptionsPosition[    113340,       2430]
NotebookOutlinePosition[    114735,       2469]
CellTagsIndexPosition[    114648,       2464]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
          "BetaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BetaDistribution"], 
          "ParetoDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ParetoDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"StudentTDistribution\"\>", 
       2->"\<\"BetaDistribution\"\>", 
       3->"\<\"ParetoDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CauchyDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CauchyDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CauchyDistribution"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Cauchy distribution with location \
parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Cauchy distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "2"], 
       SuperscriptBox["b", "2"]]}], ")"}], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2883,
  ButtonNote->"2883"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CauchyDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " to be any real number and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->14522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CauchyDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->14615,
  ButtonNote->"14615"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->735593116],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->181737491],

Cell["\<\
The mean and variance of a Cauchy distribution are indeterminate:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->14615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22348],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80303981]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32179],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56966510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16857],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1662],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"b", " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "x"}], ")"}], "2"], 
      SuperscriptBox["b", "2"]]}], ")"}]}]]], "Output",
 ImageSize->{103, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137226986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"CauchyDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->486588460]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19022],

Cell["\<\
Generate a set of pseudorandom numbers that are Cauchy distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.15695389097808`"}], ",", "3.2106872065674006`", ",", 
   "0.692310206075775`", ",", "0.20260898244034609`", ",", 
   "0.9350998791601143`"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542283925]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28888],

Cell["Higher-order moments are also indeterminate:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31717],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348554633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13698],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581795075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6932],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Cauchy distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->25619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16081],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"b", " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "q"}], ")"}]}], "]"}]}]}]], "Output",
 ImageSize->{133, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475623771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18631],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->25428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"CauchyDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63293422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26610],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"CauchyDistribution", "[", 
      RowBox[{"0", ",", "b"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0.1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31071],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxtfQVUlU3XNhY2dnc9douJ7mMidoOJ3d3d3d2NGNgBqKBzkBJpEBCkG5RO
EfDjPTPXnJ+bn+VarmvtqT2zZ9fMPafF/DWTFpXW0dHxqayj87//+V919fVr
//v7QMFWq35araos8fv/wZ+6El9sbXS+tVFpicM05f8y4MsaerrE1zU4UuLO
Qxv/iuzd0Bb4OKcT8GleX+IA3r7EZ3n/KuB3fHwS/+Djl1jwp8Tqz5Edi/55
SH6BwS8w+AUGv8DgFxj8At+5Pu3OUrtGBsDgFxj8AoNfYPALDH6BwS8w+FVg
tclOR+OdjgGSX2DwCwx+gcEvMPgFBr/A9oJfYPALDH6BwS8w+AUGv8DgFxj8
KrD68YH+Rf/CJb/A4BcY/AKDX2DwCwx+gY/f4PxKLPgFBr/A4BcY/AKDX2Dw
Cwx+FVitaeZ8tOQXGPwCg19g8AsMfoHBL/CCW5xfYPALDH6BwS8w+AUGv8Dg
Fxj8KrD6rl5i0b94yS8w+AUGv8DgFxj8AoNf4AZVuL66LzD4BR38AoNfYPAL
DH6BwS8w+FVgdePvg5t8H5wk+QUGv8DgFxj8AoNfYPALbDRpfaVVq3sZNBQY
/IIOfoHBLzD4BQa/wOAXGPwqsNpN85cq+QUGv8DgFxj8AoNfYPALnDmZ8+sq
MPgFHfwCg19g8AsMfoHBLzD4VWD18Ze5Rf/SJb/A4BcY/AKDX2DwCwx+gSOn
cH6PCQx+QQe/wOAXGPwCg19g8AsMfhVYPfJ/27l1luQXGPwCg19g8AsMfoHB
L3D7aZxfQ4HBL+jgFxj8AoNfYPALDH6Bwa8Cq3U3TSi/aUKO5BcY/AKDX2Dw
Cwx+gcEv8BvBbzmBwS/o4BcY/AKDX2DwCwx+gcGvAqsdjP9nkP9IfoHBLzD4
BQa/wOAXGPwC7zfh/NoLDH5BB7/A4BcY/AKDX2DwCwx+FVi9/3/m+PFfyS8w
+AUGv8DgFxj8AoNf4BOC330Cg1/QwS8w+AUGv8DgFxj8AoNfBVarmvxPYRdI
foHBLzD4BQa/wOAXGPwC7xPyTAKDX9DBLzD4BQa/wOAXGPwCg18FVotASQV+
gcEvMPgFBr/A4BcY/AK7TOf8/uN/kl/QwS8w+AUGv8DgFxj8AoNf4Pua+j7M
SSPfjrSfYwIGnc+Dr6QDg64x502CJR149f+GY1VVjfYwv8BRmnZ+yf4xP8r+
Ec8BI95Bf6D78vZIyQ/Kg47yK/n4VIrxqZTjA78Yn5J/xCNoXzlfoKM9zA/a
A0Z7izV/kbI95Xxyf7FQ4R8XSn6UGOuN+uAf41HG5+Af9ZV0Jf/KeEg5XqX8
YXzoXzl/wL80+CcbpbGvduTKMSkxxmetgXpq0FEfdA71VKBjfTDf4EcjLp9j
ZXv/s3blN/2T9YFr3uTxEebrjab+FzZEo09caImgY75A5+Pxk/1j/iqKeEs5
HsRDqI/xr+eYlBj9o3xTzYJ4S7oSYzwjhvD4B+uH+nVN0+qYpgXK8kqs6d4o
VMojxlOcX+3+Va4PxguM8aE8MOZLuf6oDzow6KiP9VPKi1I+sb6go3zx+dLm
m5TjwXyAf0eNfETJ+VHKk1IfK/nB+LE/IB/Yb8DoX9P8hAhZH/KcJ/I1wBif
Rvwex8j2IY8vNM3FSn7QHuQR8wH+UB79g472QVfKD8pj/GgP/Snbh3yiPvh/
o6FnSzrsJ3CuxsymSH6AMR7Ul/tVYOij5hq+M2V56C/YF8wnMPhR2h9leWW+
DP2jPtYD5TH/n/l8SHn5yMfLlPWxv0FX7m/Mh8gRqzGfKA8MfoH/04yjrBry
hPrAKA8M/oFRf87/prPOL9kfMOoDY38AQz6AW/L2VMB8X1ZUB2naSZH9AaM/
YPQHjP6A0R8w+AGGvADD/mnYjUyT4wFG/8DoHxj9A6N/YPQPjP6B0X+CxuBm
yvUBRv/A6B8Y/QOjf2D0r2z/kUZes2V7wGgPGO0Boz3gfOEXA6P9RRr5y5Xj
B0Z/wOgPGP0Bo31gyEcrzf95sj9g9AeM9oHRPjDWAxjtR2gWKF+2B4zxA6N9
YLQPjPaBIf/A6A/+FvpT+l/AaB8Y6wGM/oDRH3Bxf8tPYuhLYOgb6CfQ4Q8r
/QH4V8DQn7AHKA97ADrKQx8CQ99iftE/7IHSP0J5zI+SH6U+hT2DfVb6I+AH
WKmv0Z6TBvqzepr+PtFDjgkYdPgjNpr6rmJ8kXI86A/8AP/l5dlBjX12lpiL
vZusj/GhvhIr7RPsA9rDeDE+JUZ/KM/Xz0vSgdG+0v4Doz73237I+sAVNP2E
S34xf+gfGP2lauQhjFAe84/ywCiP/pXrjfmAvGK+MH7Yc4x3o8ZB1GL4P/A/
sL+Aled1WB/sd9AxHmDQMR74E8r9qPR3lOutjP+U/hT4R34EGPoV/KN9YOgf
YOhr1AeGP4F8jNK/wPlKcX0XL/c/cHH9Fy/7V/oXaL+4/ouX/SnPX5T+jfI8
RunvgI7xAWN+lf4P6Jhv0DF+JR0Y44e/gvwWMPwVnF9g/MAYLzDGC4zxAWM8
wBgP8AjenxwPMPwZ5OOU/g3OGzA+YIwPGOMDxviAMT5gjA/+DfIh6B8YdMR3
wJB3pX+E8wKMDxjjA8b4gDE+YMg/2gdWnk8o+0f+Hv0Do39g9A+M/pX+E+ho
X5nPV/proKM/md8X/QFj/lEfGHT0D/8K+1/pbyGfjf6B0T8w+gdGf8DYL2gf
GHT0h3wy+lPmu5X+HuiYX6W/p6QDY3zAGA8wxoP8AsYDjP6B0R8w+gNGf8Do
D/jTYJ4/gv3z0bT3RtrXBsXuA/lJ+h/NhvOX9gf+IeyLxrx/j5P6D/oX9gx0
2O8KGnm0l/YYGPYUGPZbSVf6B7s0BthHtgeM8sBoD7h4flqb7wN/kD+lPwF/
rvh6uFFZzf+pMh+G+VLmk2Ef4Z/CfwCGf9pY2FUNLP9T9gc6+OPVIuT4gNGf
Mp8EjP6wPlhvzG/x/L5WHgZoHIrvcr4hH2gP+aTVIl+K/Bvqw78ExvpO4lj6
n8BKOuYbGONtIvK5mH+0D/8PGOuP+qADK+ngDxj8Y/5BDxD3j+BfoT/4t8BY
T7QHOjDo0wQ/kEfQNe6DaZjEPTV/IXI8oKM/yCvWXxmfYH2wnsCgYz5BB0Z/
KA/5AwZdGf8p4yWMHxjjh/xhf6B/pf+N8aA+MPx5ZX4S+w/lub8dLvUV5Bfj
xf4Axv7B+FAe+g/rhf0LfoDB71+xvhgf1hP8ASNe7CL2E/qDPgDGfHB9EyPr
99D0F0vJQv8r9Qf4R3noD/CD8SHewnhQX5nfRbyB+AfzAazM/2K/8PPTDFLu
D8gv1gfxBs5blfGGMj5R3v/C+qF/ZfygvC+l9HeV/rHyvo3S/1Te31Hm55T3
QZT+m/J+BPwbrA/8EcgX1gfrpdwvSv0FeYQ8Qz6gz5X2CuuL/rCeoGN+sV8h
j8CQR2CMB+ut7A/rifLgD/sX7YMftA/9B9xD6GelvePyqcXK8WN/YXzK/YX9
A/mFPh+mafgPKfNNGD/0K9orfl4fI+UB84H8F9qD/CjPk1Af/ACjPPabSjO+
BLnfoB+BIX9YX8gvMPjD/oZ9QX9oD/4DMPIbkB/MF/YT2kP7GC/Gg/wJMNpb
rtlvBaS0v8g3AqM82oc8t+P6Sfo763l70v7AnwMO0YyjjBryhPqfNP39luWB
S2n8lgoi/5BKbTTlq4h4Pl32d1XTf6Zsr7aGn1zZn4+mw7+yfa4XCqQ8Yf2w
P4CL5888FPk7D4U9CJDlYQ+wH4Axn8hXYj8Ag471Ah0Y/WH+/TXtOrFfGv2o
psscE3Dx/Rcs5RfjQXvQF6Bjfy7TzG+W1v4KfsB/8Xyhh6RjPkDHeEFHf2O4
PEn9ifUBHq2hl1JDnyBe4GKcIPUdMOwd8BrN+Mupd2gEMJkuaDqupNYMzzhN
nodrmj+QIccDjP54szlyPNw+5Mn+ub7Ml/0DIz+L/Qr7ovRfMX/F9WOAYj7D
Ffpbmx9W3teAf4/1VebLQa+uGZ8Xu6ex999ke0p5U8qjcj2hb8M1/HkS2kN/
kJ9emnX/zjTbs4471eaYgNE+5KMT/1/uT+gr6BN+L7aUCvKB9YD/Av0PeYA+
hX4J5PpBBX0Efwv0FVx+VJCfAk075VXQR2e4PKkgT9CPkB/uH1VRQV/x4emp
QAc/0F8YL+QN44E+A7+QP4wf+g38Qb9BnyCewPwq8xnQ38X9Rz8pz7Dv0C9R
GvxVygfKQz5hj0AHxv6GvEBfQr5RHvsf7QE30mwcG8btgJOUP2W8jXgK/ACj
Pu/Phm5o6tuQEqN9tIf4CO0p42XYT9CVGPyjfb7/tPtXGc/Av4K9R33QleWV
8Qww9iNXJ9ESd/rf8s3X+mOYX+gntA//DPxg/PJ7OSEPXD5C5HqiPfAHDH2D
8QBjPMDwh2CPUB/jl/6xBufIeBHypcwnQV9hf4E/yDf0BcpDXyAfpNQfSnuj
9F+gz01E/Ij8S02NYN2X+q/494N+cv6RH0G+Gfoe/g3kAeMDhr7EfFjG+S0x
sjQ0QLwG+4Dxon3Ea2gf+g3tgw7+QMf4Qcd8KOsjvkN96EPUBx31lXTEf6BD
X8LfBx3rCzrq474F6k/TCGC2pCN+BB36FvODeBHzA/1a/PurQknHfTjEJ1gf
5Kchn9gv8AdQHhj6DxjrC3uK+lhvYKV/CH2N9VeehyOehH6E/wg68omgP9G0
/0XqA5SHvUd5YPQHfQH/AO0rz8ORT0R/Hpr8gbfkh5+TeSnuR3jJ8YCO/pTl
0T4w9hsw5gPtJWr409oXzD/Gi/VBfWDU5/ZOez8Q64XxcXscKvlV3v9W3h+E
vwL9DfuM9pG/QPua/WgXpbj/EU4TuH6V8w/9pryfCYz9BX1V/HtnP0mHvwh9
hvnE/oA9gX1QxheYH8wv9C3Gr8TQZ2gf/hr0DTD8QyWGvpog7gsr9RnKoz+U
x3yBDgw65gftwZ8DHeOD/4jxKDH04Wbi41PqS5TH+FAe4wEdGHToL+hPxDvQ
n9DfoGM8oMcL+6bUz/BvMR6lfws62od+RvvQzy/n8O9JlPo7V7Nfs2T7KI/2
oM/RHvS55SA+XqW+h7+N9lB+tSnvH/lD0OFvQ94Q790U5WEvUB72AvIAOuQB
dLSXqpH/QsX3uoVy/WBfin+/WyjbAx32AvoX9eGfwF5gfwJj/wJjv8IeAYOu
tEfwV+C/Ks8D0R/mHxjzhXxfMf3dO0pizfifRkp7AH8KdGDQNepysKekA0O/
YPzwP7n9+iH1LfQ5/E/Qi3+/4yXjW7QPDPtT/PsdLxn/go7xwj4CI14rPv+R
ivuG2vnSmMsxWv2v9Ofl+ZvAyDdg/0OfA0MekM9APA6s1OfwP6D/UR7yDFz8
fERrH5X+OPxX7Gfo++L6W3u/CHTIO+qjfehrrIeyPNrDflLaC5xnoD2lfgUd
8wd9h/pK/aikK/UbMOhKfaXEyA8AQz+BH2CMF/oGdGDQcR8C8YvSf4M8wX/h
6x8g9Q/8X6wP/BfUx3pD3uFfAi/R6GsHKc+gA4OO8kp/URNfRvrI8qADg479
pfw+DvsH8g7/qrj84/u2KJG/+qlYnwjZn4bd5trzGOX90vMi/r8gzl+Qr8P8
Iz8BDP8e839Sc37mS49U3N7h/Bjlke8Ahv/+VfSn9PcxvyiP+a+pGed9mT8B
RnvAsr7AyvhBSYf+Boa8AUv+BVbyD/0LjPXdIfwVZbyA8mgP+riqOD9GvAA6
2gOGPKE90O+I82rsD5TH/gDm+Sl/WR/0n2L9lPEI1hf1EZ+AX9gnHxGvwB6X
F/wo4xOUR3uIV5qI/qGvQYd8A/P8chCphfzAnoKO/BDkn+/3MClPiHcwfsgr
9i/yd8CIR9Ae6MCwl+AP7UHfY3ywvxgf6Ig/QMd4gRGvoT+MB/kq6ANg7O9J
Il7j+jVe5uuUGPsfWH5/JOQJ57OYX414bdVijX+fFCPHp1FTe8Mlf0p/T3m+
qjxPBh36G/XhL0H+wB/0+1YhD8jXFds/87UY6w//F/4I/ANgnF/Cv0D+HPlB
nLcCQ/4xv8XzW0mKfJb2PrIyv6csD/sOuhIr3yNBvIb4B/EXMMqjPu67AuO+
A8aP+5Cwz8r7hMCYP/CP82LlfQ5gjAf1cX8D/hPudwDjfAT+E9YH/GI9gHE+
Av5xfxPxHe4XA+N8F/Edxg86xg+M8aM87qcg3sN9EGCcpyDeQ34O8R7iY2DM
P+I/5EeU90uAsX4oj/vEiP9wvxcY59WIB4vf5y9UvO9UKOUR8R7WC/Ti7zUV
yvVCefgf8C+gH4AR78DeAmO/A8MeYbzQr2gP+hf6E/7CZs14kmS+bzHHMj8H
/1H5/RD0H/pT3o+BPEM/QT/CvmD8sA/wR0CH/Qddad9hr2G/pD0UGOc7aA/2
FOODPYX/C4zysKfQ/6DDnwTGeFAe7UOfwl5ivtEfMNYP/hMw7Cf6V573oD7G
Awx9q/xeCxjjQTyP8vCnUR4Y5ZG/hLxivSFfwBg/1hvjffU/8awUQXM06xpS
Ip8Aewd7Df8Q+kmefwp9AIz4Tnk/AfoT+gh0fH8C/YnvU4BxXwH2B1h5Hg06
+FfmJ5X5RmDoH+hj6Ftg3H9APAsMfY3+lPlGpX4HHfOhzB8qv79VxsOgQ/8j
/sX8Q9+jfdCBof/Rn/L7XGV8rbQfoMN+gQ5/A3Rg9IfvE2BfoN+BcX/ESsTr
wLA/GK/y+16Ux3iV9gt02CfE/7AXsEdoX3l/BfYJ7SvtF8rD3oIO+QIdGO3B
niHfUHy/avOjynwoMPwJYNhvYNx/QHvAsJ/Yb7B/xd9XLJT7C/kOYNhH2FfQ
zcV5Kupj/KADoz78M2V+VmmPUR/9If9W/P1ZP5lvQDwJDH8cWHkeyOOJULne
oJtoCIEM8Qzoyvbgf/fl5UvYe9h35DthD4BhPzAe5fcSyvtIsEfwFxCfo3/k
f+FvKb//wPlW8fuT4Yr3fbXzC3sKOuwB9AnyP8CtRT/wF0GH/gAd/gzsGeoj
3wV5Q3wB+VHmH5V0xBvQz8r3E6GP0R/0N7Dye0LQsf6goz/l94TK9hCvoD4w
6gNDXwKjPuIb1AdGfWDoS9zvxviB0R70KbDyPAjl0T4w5hsY5fE9HMoDozww
9I+yvDJeA0Z9YMgD8q2oDwz/EP4n/CW+v+Ok/4d4D/Ef6PDnlP6e8vsw+H/Y
v8i/ASvPc1Ae+xXloe+BQUd9+F8a/+eS9v4Rn/YIxflchNz/KA+MfCr8RQ07
ZeKkPoU/hv0ODP2G+QLGfGE+oG+hr4Chr5CvA8b6oH/4f+gfGP0hPwIs8zsi
nlDmR5X5SuhjrAfGh/kHxnpjvMAYL+RLxjOifeQHEW+A7iP8d9iTjiK/Coz6
Mt8nMOwNMOIlrB/sCeRDGT8qy+O8C/tL+X0RMOQL8w2M+cb6IX8GjPqwL8rz
LcS76A8Y5wEYLzDyjbrivgHsA+YD/AAj/nkr5hfxFOiwh8DK+Ar7Z6TIHwKj
PPYPMPYX8i04n8N9cNhLYMTn0GfK+7qwp/CnET+BjvmFvwcMewN9DPsK/Q5/
FBh06HvsB8xvcX82Wq4f7DX2gzK/qZQP7DfsV9SHPGI90B7kCfOL+49YH/gn
FuJ+BzDKI38LjHiW858n/RvEX/J+uKb/HCmPWE9530bQ4R9CPyGfjfwL4mHE
j2gfGPsB8Rr8McSX8n6SoGN9UR/xL+IlYMQPiHfbmv6/74smyPnj/naC4j0g
bb4X5Yu/9xMv5RV0xAvwt/D9CeJryCfiacgzMOYf93uQj0N7uD+O9vC9G+rj
ezhg3C9He3gfQvkeF/xBfB+D+Bv8IJ7GexPAKI/4G+NBe7i/jvbQH+JhYPhz
WE/pP4r1RvuYP9Cx/4vfly+rQvuI94AR7yrjbegHyAviUbQHOvwz0DFexGPF
39svlO0hPoO/Cf8O9h3xJ/QV6LBHoIN/tF/8vf1CKT+IH6Ff4C/Bn8X40T5w
8e/t/aS9RL4T/gAwxo/zM2B8L4L9D/8Q+gHlMT7l+wOIF9E//AeMF/WB0R/s
K/qDPUV56Gv0h/7hH8BfB0Z5YOh/YPg7yvsMwMXPn8IV7w2FK753iFO8hxAn
5QH6FflF+EfgHxjrr7y/iP2B8Skx8lHAViIfhPFAPmAfIc/oDxj5APhr8PcR
L0CfQ/8j/gR/4Af2EPzC3hbfb/EynoM/jv0B/Y/9D4z9C30NfQZ9iO+7oC/R
H+gYPzDGj/LQf9A3wNBv0DegQ18Agx/op+K/n1Eox4/5Lv57HoVyPNj/iOeU
8QrORyDvwNgvsN+QX9Ahv8CQF/g3aB/2vvj7dF5SPnA+gvZBL/4+qJeMz1C+
+PfPMQp9GC/1u/L8EfYK9hEY9gn7Afl95f036Dv4Z/DHsB+gr4Zr+kuT9/3g
XwJjfSF/sM/Yr7CnuO8KfrA/i7+Xrr2PCf+o+Pc+cdJfwX6Cv6L0l2GvYU9h
r+EPQX4hX1JfiPZBR/ugw34i/wL5hX7B/oK9w/zA3iFeRn4D8gT5h33AfSFg
6GfMh/L9G+gfrCfiUfjnyD+ivPJ8CvEI9D/8dcgD6MjfFb/f9YuU39NjPTB+
yBfmF/IB/wHyivlRYsw/MOYb/gLy39DfmG/0p/RHMN+gA2N+EQ8Cw38H/8hv
8nJ6Ksg37JPy/FyZf4N9AB0Y+gP6CuuJ87vi3wcGSHuE/AX0C/IhkH/oD2Dl
/Qalv4T9hfagP2y4/Ej9AXnC+mL/wb9Hf1hv+N/wd2GfsN7YP9gf2D9YH7QP
OtoHHfoR/BU//4+X8Qb0FeiQH2C0j/LK/Yl4F/OD+cD8AcPeI74ExnpDH8Hf
Q74aGPKCfCKfnurSHkP+sD/w/Qr8J+gX6FfYK/hzkCdgyAPiA8g79D3owPAH
4I8AF39/sIpKuf4YP/wVYNgLpb4tbt/KSv8D+hflsT7IV2B/Yz5hv4DBD+YX
9gj7vfh5j/Y9Gux/tAcMe6nMp2D+i/sHHtI+Y79iPNDnaA/5I2Dle7bK9/Yx
3uLltec34A8Y+QrcP4H8YL0w39ivSnuJ8yzMjzIegj4FRv8or8TF82MZcvzQ
lyiP8YJfrEfx+28ZUp87TtC7cOvjQQOM91H/JoYG7K4cf3aTF4arR2l/D/Hn
o6jglgvCpT9kenOq8YtF2u9n4a8GTx+9t9/3CDLassLs7Jt/Mv81eL9ad0H/
MtK/nzl2SRuLJtrfm1vxX5U+3qPSJMb+/6+Mf6eEi4l0r+2WdfXbZ5Z4T/Rp
xwltNnRKoFZvdoS3mRpT4r7eZUHHfNQX7VmcXR9mfUz7+204/61sfG3HHcsk
OtLd0b2gbY70n3BfqrSgt+ll2M0wWvt+kfz9up6DJtf0TaPC6NistL7a9zrX
t/WxD++TV+J9o3qivNBn6naxndy/umrf01y0qe+/JskZZLnl2XEX/QLpr1Vc
Ujeryg7tfcCKmS9X90xLLvF7X7NF/ZAIF89as0Lledn+m+2PLNRNk/ipQ6Lt
nio60p/7cj/mkv4x7e9TmYekzrtyN1zqQ+MxG5rEXyylUv7elbWFbVqD83n0
fcT6ytY1y0j/r3yF25eHdsmU+ZHfAX6v9fMjSvx+0wtR//rXdR+jj2jfl8R6
Vz872D65TT4NruG0+ejqKOk/Yr1zz3B6xRfW89qGR8v3HmN1Zi4yHJEjz8ty
m/T7GaCn/f2gNKfp1hFF8ma548ujrw4BNK16xKWjnqXVelPfes1fHk9qw8+p
FWpFUrftLKRXSDwdV4Xu22eWSu9HWp93bhFPFnvLfT1ilcFM200tGHbxN720
i/g7uaj/Xpc6b5z04DdNjdU7Ybehirrbb5NhfXamU5RFysiMXX+oQUbn+mn7
0+lSz+w3x63y2ZNM9flt/kV6dW3ezYKQEHIeWN3kVGI26S2YrKv7KpUsXoWd
H5WSTWtKfa4ctzOdWbuYfa2y9g/5Hvb1ctwSTmsvJBysPfwPrc0d1e1K51Iq
j9LHvR5l5dKrpz7M9Wdp9ZSG/fedm/+3yG7bXJwWkMHG6T43eGz0l9TT8tIv
ZkVQWOi0IeNu/6VVWaMHnxpfNL/zzHUz3xWQ5VvrBc3uRLMbW6csL3j/j/78
MXM53/E7O1NnTtUXFj/pTqOnvk3zv7N6hx8MnW0XTOmcTscEHetnfu5MkvtX
Z/oTOdyyhnu4tO+32jW+1zPpu/w+PvbXUP8ycb5SHxUeqV2QEPWbtXq+rmOu
jQ/lckxNBa76MLpBN2NvqZ/sKg73N1kYJeMByMc50X8O71/aP0deXtqbW49K
rSjzIICt3Rk5NunlZ2r4WIOp3C6Odc6bdnx7+pkc/9KlM9zeVN8vfx8n/pyG
LtuP+fa5jYv1F7bA9EZH/w8utDe7xvYhv7+wnfrbvwTludB69wotJow6I38/
x+TYy//qGjux/A17xlfroiZDjilN4PO8Pp0V9fX2efTf99qWavhuf2pSw5+s
n+p1TvmqZpP6N2vD7APJv+6GK8tz1KzllSO52xoEkS2n0wxB9+Z0aiTo1hvc
jdr521N+1dpeRltDqfeNHeGjrexKvH+YUeFyk/xLHym47ccDIR7eJd4nPCfo
tf5Zb18a6C39t0vXKs7KDEkgk856rsaOkVSg71dhn/MPOpoet+bXv3AKtrSJ
Sa3lQT7jtx0Oax5HY048zp42J4YaTpiX164wlEZ1ctxb63YczUprt7F/ywha
3+DF0Uq9nKhO9Z1/4mtH0KWlt8MudQ+mJ19cjOosiqLrv1eFdmifTcOMDiVf
dwom/U/3vqX2zyTPV/NXTB8WRB3GvbHePtBJyl9Wpf5VS4+Ik/5JesjKmVfv
BMjzPY/Qh69M7L5J++ZXYZXBiMEhNLH92fRTHfwobInb3UvX7FnhjOzP3VqE
klmHTsODY+yZ4dgjXdtuDyX9I83ubF0fz55/r9W3xesI8t3YYO2bcB11o26B
5yzjY+hUt6jaWauTWUHo6Pht5WPpBMeUJ/DNgv9yzWzKqpOGR0Y+Sk6kh5U6
bXa5UE5dqH/j2blKv+lasFmvYde8WZmDsz/qlfpFVzim8gK7ZJZ9MO1RUVxl
5tyvXftfaE/1S7TXkPRd2lXPYu/mmlifuZBMlt7ZjyeP/s5io6ZaPOqWQnNe
37e5Y/OddZieGtHofQq94XSKEvQT1ys033ssjv4+yZncrnMqNeftkY1oz/Or
T/rs7Cz64532+WBQCsXVfvFmau9cVmPC9hEzzqaR95OnLwKdEljf2DmNjrxK
o3FLFxrFJPizjEleSYtuptH+yLEdg90C2IOVjsPP9k6nMZxO6YIu6lM/Uf9H
/X7PdxkkUlK3Ttn5uukUy/ujaqK/d1W6thu0QE8dn7LD+7NtBkVciHEtTPrN
aiza61gYnkHrqMLV0ZeS2GHnqnnNJ2RSneMjNw86FMjqWTTNe3w3g26kZTUu
YxfEIozqHTE5I+lUR9CDeXtUXbRnN+rJLNPfBezG+/vvVLZZ5H3N+sHsqyls
3PHDGwJtssiDYxorsBsvT3dE+Yc2uWmfsgtpx8BZJge2ZVPQIPe7u2/oqNPH
rVAdb5xLwRyrUgT+sW9anQldsyim1btJga0K6N31209z/pZRtTzkeul8uQL6
+Hz90v8al1Nv2Bo2+fzjQnp7dfgBx9vl1Mu/1993edk/GvyyaSeDRdmsoP/s
zfnuhUQcU6HAvTN1Zx0+nE21D+106ltYSDa8PdU60V7T4Z4/09NC2R+HV4FL
1vjTT75fmInYL437/ZngWDe6xO9hHDcauOmCvx3t/dvCJKVjDCXv7LO/wmpX
mjO92TWjT2/l/lz3U6Xf0yOoxO9fOLy8/zss2ZeuGrW41Dta+/sXOe0zHj5t
wKS9uMLpMp6o+/P4x5R+Tkxn5ofZZ4r0STM+vhK/b7FajG8N77/E71s8E/23
Lxvr8C7Pn+k26TX/se8nasExpTTmGPHnztQvBp8tP9Gh0km/jvt+pYKb2dG/
6xfFV3sN699f/pVqxrV9dNk+klrdnD/mx0NPVm/YPcdNj5zo2xXDRuYFzjJ/
Bf38Y/aJ5+pW2t+PWCVwxPX++XemRrBlbStNebnAiXQf/sp+XtqfLan1x90r
1ZPetr67LmqlP4s9W+ZSqxFeFMTL01xRvgEvT3tE+We8PIWL8peMFt8e5BhU
4ve6VOMi3c6ER5LX1fe2lWbHlvj9rddD+u98cCOcvFdU7bu55Td6d+/j7r8N
oyly5PSM/iYuMr50qHG4+YT2f2T8gfzB5H89D915HyL9Ddegh5FVLwTRqQ4X
snIjIuT6t6wZ3rBpZ8cSv+fwTpQ/yctLeWh1rNr6aSvyS/yeQ7x6kH5pt6L4
tnPE6eQFv0vc/0vYP/mPf3KUzLeFCmw2/HTZWREFNKGc/662S6PIj+t/VV2h
/+V5d93e/bo7xtHCrWUGjTxTqsTvPbQpv9u06qdEMvte+uv3YV4yfhrG4y2Z
70G+oKkoH2s8qObl19rfaziZlPq+6pcoiSMu5HTKruwr46mjnC7PX6zi1L0/
9K8gz09a8nhInjcjXk69tNWng3EqHeLxlPw+CusVb1HFte/NVGpzv3P0ht9+
kj7Ft9XY29vjS/x+QoQonxf8sMnwaxVUkSlpOVXSU6hH74YxlkdK/l7Cdata
lqfHZ1BW5sC/+hd+lbjfePNPy92Pw9Mp/mD49e/vfzDlfcbzgi7sgypO2Ied
+n8fd47Tk+flmdN1e+re1f7+QZVldVr9dEhmyt8naC/iu928vszniPhLrfx9
gWHXW9esq8qR+T4SGPHxkX5d9Z90+kPhh3K6lWFp8j5jh/erBo38//w+gPXF
iYmnogvIaO6S02/faN/nn9H21WGj11kyn3iTx18q5Xv7z0X9OB5PyfgK67l9
e9SLOVv+yfVaL/CGxi9crkS+0ubvVgzN9ow9aAC8gtOlfn13fXi1Mj3esGvO
lXxUBa70tMFY+4ZF8Sfkv9/lMX57Y4JY3/iqJ4cvsiO9syF/T47+xhaUW1Hn
RGV7epf6IGJYwDf24VPFBt022lNHTqdtgm7G6fRC0Lvy9qiLaC94xJatHxx+
sKnt2o8+G+VNAaZ7EhoeCGLOjRxvF+r7Up3lnt0iTn5jMzuNPFBzoA8Z6LUz
yHX5xpICNk7qs8KHmnE6LRT0bpxOcYIewNuncaL9KN4++Yj211a13Nbklqc8
r6+7YqbR9Kr+Jd7T/7v5atmHl77Rc4+q/g0n+Ja4fzlO2JM3nC7zb56pTW+b
nAlmlQuuX7S9HUWDVnY4tlM/mK2duvHN7aI46A/3x9lB4Y//uxcadPeAM5l8
eLUiqW4kPefrIe/vOP0N6vX68Qv2+vOd6JnjnOlRH8P75Xu9ZPN3du/l+8eZ
NnJ+5P3qhil17ljU+Mh8Yk6FTq/6nfa8n+SgHxfKkgbo/Lg2KIZqlo0cXnPD
I3mfwLh/q+P3612W79+X4XSZX0uZtuFQXccH7KC5f/1P3ow+6+6eaLnRklUo
czT+TrdPdHHgg9N1y1qwk99urY5NtaeTupts1jx+zKocCptoeuMLPePlKbk0
Lx/G26Mlor29vD7tFvVf8frUVNTvUv5IslvPN7R5g7nH0dJukF96LOTXl88P
2Yn5Oc/nh6aI+Xk83dWmfOA7Vur0uMFpZb3oavlddQpWvWeZD20+tbP0oXuc
TnmnOP0Op1O+oNfi80muYj4bVQy7uvL1Rfl+vluiRefyta7K9+8Lx9Sce8vR
Qd6HsDrQJfv2viA5318avNr/7pmzxLvsn99p9COgxPtkOQ8u+fnc9KJvV20K
otq4SPo3Xl+ujy1vX+LSYzX9y/O8wDm5R50iv5PRtr2jTWyCSc9ryPIFW/2o
PC00P3QkhJ4Z3Cr7xN2fnDbG6c2cH0axiUt6zfrqT/WCLl86PSOMvnN/gVkL
f0GMR54f7eXjL/G+fagYf/c7bz5d6faDgqd8yci9GU6buTxSopDH++bfgiKa
xdLJj+0DcquG08YBC8v1Co+iJpMLZt8MDaYLqistJvWNpkcD+yQnzw6hfTmu
VRZ1dJPnfy1ejNcPW+tKn9Z29qvRJIaWvPJM2LHOlYLCcprvKMKbzHQDH93X
3pesdq96B7tH2vfa6w52r285I1/6UyN5frXE70VVrFN5j5VrtMynmRT3H+R5
UAK3/9Ke23J7XuJ99l/Cfvfm9lW+x14mRpPflO+x47zjsrC3f7g9lN9rhXL7
JO9fduL2Sb6/LuyRPL/05/qJqgv9NDGONcqd60GLy7bNMw75XuTPa/zLEt+j
TxL+ZRs+38xOzLcpn2/mL+bb4kVusqGdGxs1faBLxaJ1XT7u8O5fe9zZQ1uT
vNfDvpMh74/NFv3tcVnc/llGiPTvjnF/nOkJf/wBb49GiPZc3t9b+HZsOmX7
ufl4uQRQ8L2RRs5DMmi9Xsy7PmUDSd0hL/do2TxafG1h1Vqx4ZRypdrdVnVy
aUHNJrE6o8Ok/Zzg/rVxX8sQOjEh6uDBCdr7mBN5/FPiPW69zklzQ9q4USGP
b2T+ft3D/m835edKfxvnw4fHZ76MnRYOf5RNEf5omWMnDoyzL2Re9o8Mfv6N
ovbfrm1LT01gPi3WVPJTR1Ldws4hZoHpbIf5EIOLM36RaRvbqPja0WyG3uoe
rQ78oj/cP1PHCv8s57/0tlO/VVb3VQ04a6uXTtYjd/9tYPmXZbR/NvhSs0z6
eLBZiHGRv6Lf5P2+eUXyMHO9XpeWHyNZwrWB7pdd8+niu3Fl0sv7smf1XMJf
Ng2iaxyTpcAifyPjwfknx+3+eyyQPZ9puj32WARd6m2dM8I8iLU7ktX42rhI
+nbm6XSLUs4sf8yM872vRtCh8e+b1TnqzPR6Xrd+UmTfPMN6DKyRwmR+z55j
mc8r2NfmWfyZDzLe1NmvwTL+a8XjCznfQ1jGgwuhjqxx6ZuV25ozms0xjRQ4
pfr71/2Ga3/f7+KbF+b3jeOp+/371+wsImjSnrFLy9jGk/5+vcAhmRHkyfNP
JX5PL7+f2RGrhjF0h+dT5XxU5/nREu9v728wOnn45jB5ft2pP69vu6Lp8rdV
8libiw/r9YgMp6b71F1nPY5jdzfodHdpFkEX9gxIC9ucxnql9u6fMjaBUhJq
/oxrGcnO2Pqub5URT785ppMC50wbVLqsha46KdhsquPaJLKfvDNk6uFK6q2b
7mx91z+Nvo7XPbt4cx7T/bG998qeGbR5vo7BrbZpzMa2lGnfSzk0r0ti1+dm
aawZ+VduSLl0K3tEZzObUurFeZv9TrM/ZLazYo9a/yLYxss7O+u+/kv3OKb1
An++d6P8obBw1vDdgw+D1/0gY7+sB0deRTAzt2UmEY8DyYbTqbagz+F0eiHo
0bkz53S5c9RA+R73oE58v508HHi+yTZHViOq2rrs5eGUsfHz76cHvsv1PJFQ
PuNHvDtT/h5ly1LVv/9Ms5fx+qp22+MfdXehOVP73/xkYifvV17k9aX8Yb3T
dXh9xPf1Rf1pvL68L9nLy8GqzW9vdjb3zQEjnW/Uf0Hiy9ET3aT8YjyLz5j0
jIks8mc5vcT78gMEvRNvjw6K9spk1c+tUdpenu/P8f5wa0+n72z37GlvRo1w
pw1uzwbqu/qyxJY3D86zdqOpnE4bBH0/p5NOK06/4utywbVpFBt/dPFbR+uf
1JLrI4oS+mg2Pz+U97kvcnmkbkIen/LzF+ouzl/mcP1Es4V+MubnO6pK4nzn
KT+/oZni/KYp12+0X+g3Ib+qBCG/dlx+VVuE/Dpz+aWyQn5N+HmPqrM476nV
VqP/VIZC/13h5z30SJz3fOH6kHKEPlzP5Z8+Cvk35fJPzYX8r+LnP2Qpzn9u
8/2gWij2wxt+3qOaKM57GNevqn5Cv67g5ztE4nxnFte39Evo22fj9318Pd1W
+usWHMt4JJSfZ9BUcZ4xyLFsxxxbe2mfHCt7Rp/alCDtc2/uX7Ew4V81dOlZ
e88VJ3k+Hbd3WstaAwIlVts9vmBaW8223c+y21baiW5t0b0VUNOOeV65YXB0
jjNdc9pi/LLUR+mf3uFY+pc6XfvPmxRgx+Lj3g608PxAxwb4rstlb9i/wqiJ
PpYfKKmLhk6+gm7P6dTxH6db8f5ppej/Ie+fwkX/J1/ZOM60tJL+7nmOpX/5
ON1hVFyCWuabzDmW+ST1xw4f5hTp+y5PYw69K9IPEx9W+/Rkrov29zHGLy1d
Mzi6xO8f6ftMntYhJoRO3ZnaxaCBG40akrKo8u0Y8s6N7hA9I1jmx/raGzs5
/9G+z43z/wGejpG7VYHUnZ/nSP/S6IPDpkmXi/TQlpq/L7QIpa79N/qm6tnT
POtpg1+NCqFEvj7yvkEDvn4Sn+XjYWPFeKbNrH2g7Trt79UsvO6yg4XEyfU1
5nR533Pun03V1xzOpS2zSg92Cw2jq3aRuzqWSmCRbX6de2vgJe+TqWu/bfi5
SH4MA/v16XI4im1yarzD/FsiXVxpV353ivY97iGcTusF/dUN4zYRuT40s/HV
91mdkiiZn+9I/wnth2Xqrlxq5U4bVwR+ON5T+3t+KziW8XNfHu+xgyLea1rm
b6hz7VC5PzrzfDeVdeT57nMLxj+csDGMJkR19bb28qeDKX/mrXHPkueTNl0T
jv3qls2SunrtHsiCaRw/72ItxHnXZR5/sEMi/khLGHNrvbm3zNclcSz9eXd+
vsMCxflOmZGz/Oeos+T9Zg9+/sIKxPmL05pSlpX/i5P0kOVxlbfe+i7xOX6e
wwrEec6EMoat+wXGsWfXH27NMU2lUF5efu/iyNuTeC4/L6Iu4ryonPGv5ZNv
+NE/B9uyk66nUuqhz0udmyfK75N77v6b8t+JAInD+PkNSxHnN/qcLt+XSOT1
JT7Ez4fooTgfqriq2nLrPj/Ir/Gsfodup9OAguDAUNMgGZ/c5ec3FCXOb95s
jNv81SeI3ufmnHK7n0m7K+1f031skiwvzoPoqDgPOuUxZuXKEclUPWLa4Yoe
mTTv4KT4Yf+FyPchjHXMFphtDCHTSZFvnj3MpkP9np43iA7Tfo8WfPfgj4rh
ZPN3xWpri1yadLVbnzM5mTI/95Of37BYcX5zZP7jzAUbstjCK/tSr+8uoAoN
tx5qv1P7e+f9+XkMqyPOY/LPVTD297aX9ysb8XxSifuX5ic/7Bz83ZvazjZJ
m22RKPVb7m8fE4dvPqxR4ILUSz6BMv80q5b6m3mnQPrzduHowFra98nTeHmq
I8pPOvLcplN8FGtqfOHdoshgGuTacH2VAdFsRVbHAWazQuhATpONae7+7N4O
nyCjovi+Quttewe5+LPvxzdOcSiK78X5q8zXI/9gIfzXiFF6gdWuO8j9Wn/j
l0tzsj/K9wre0aqQD7FWzDDdxfhfRUaHt7ucbtP0PUuYkpUzYoOavH1LuetV
/yS/VzlZ1SnIh32TeHiK9aO+zz+yhW/PrTOd+IUSclRnv6/7yE4v3jv/euMv
5MrbpxWi/VW8fQoR7e/n7cn7ym68P4mj+Pilfpmv79xiagMH6lxt0jC7c67U
4565oYmrs7xvf2zSlUYdB1lKHBX8Ya9xm/fa+//zqp6YbfNN4ri4Vv0PbLZm
jS5dCKlV0YdGzh/QrX+SFZuzbM2/OUe9qU2oyZj/mn5l9bPPWB4960UbbUoP
Xf/8a9FEzZzTI9mLLvD+5P39Lnw8EjsZJ1LXhZZ0TW/H3HozvSiwreHWye2s
KP5EzxZ5ut7UkLdPNUT7+3j7NFK0H8PHK78/iOf8SJyydMyCmx8/ye+V6/H1
lfcb3Yzz3B/PtqGXnYdEPKvqRwkPHpwaYWpDDh3C5+2s5kdDmw0PKrK37NnU
nH3/s7cT9h97bj5ALeV1IsfyPmecgcuFkRPU5LnccO28eoEUHLLXL2KTg/we
p7rF/JrNBjlQeFC7HldbhVHeXU2+Rt6PWBh4uvLr8ERpjx0nXbdu2MlT3j/u
edTyyOAa3+T9yC0phWdXpblQv2mlG9mmRlHz+Ii69Xe4kEHlmW7p16Io/0TL
zb8iHeX3RY2P93W8YhDP6rX2Hr1whydd4vaSgoW9xPnFLbGfW/H9LP2T61uD
R1ktTCXvjNorf/fTvtf+bks9i0L7ADp89XJY4bNUac+WT7oTklw1WcYDuG95
ql+HUQ5u3+nuht0Lssems9VHmm6t/i2ALk25eL41ZTK/VWtWzVQFUauDKQ+t
Ex3Yt/s6kw/VDKesb3+eLZ7hxZ4bmjh7tE6gNqd1Z6RceGBwX/jzGZxOTwS9
Yt1PN5d4Z7IODzb3/tYvmS6xp0ui02NY0yrTRpxonkwVF55vktQtluUntik/
bG8yecescm7R0pepCjtcujozicpze8NKOXJ748/pNEzQRXvUUrRXjrdHeaK9
8dze0Qth707lzfbaExfPsrccsD3WII2uLpyaHjbSn/X4uPfwpYppVJnbGxYg
7M11Tqdegn6M16csUf8ctx+shrAfr7n9YR+F/bnN+phZGwXSjCCnZ00XZFDE
rJ99v9z4RcHvQka1LUynF8P196YkBcv3jD7z+2PMUdwfE/aHzRX2J6WDT3mD
VsG0LY9C7B9k0akRL3f+MwqmRhWfjLxjm0UvLjfYvcopTJ4n+fD7ZWy1uF/2
iNsr9knYq397crzMHEJpNhn+sHicQ+2uHveruDyM6p1o9KB0/Vw6pt9td+i2
TDat0cunizvn04fqWXk392aynsdHvlrUJ58Oc3tGi4Q9s8mburVxcBabrb/9
lLp6Id12/K+hbpNo+T3kW34fja6J+2jvF33z7D0ymnKWeHdn//2jA/y+AMsT
9wVwvuwg/DvVjBO7D2UEsRrhRl1sj/tSy3ZpYWyvHzMeuM7o2KEQyuLxu/TP
Ns09sGPfuGCpb9r8uTJr18uv8j5us6d+m3S6utDIRFXrvjOiaLyDuf/njl/p
6vDID4lXIunA21cfy65xZP3qzd23a6U7Xau2eG9kZNF+2KJu1OS2G23hdOos
6GacTsGC/u7NjWT1aycWNmqMYXIfT6q69PrOM7ZObNfw19HtjDzJitMpWdAL
lmjotE7QS/P4XL6/17Xh/H8f13iz8l+GlG32J4C6vVs81VnXh5Xe0MPRwlX7
vrm+sO8Z3L5L/diB1ycdUb87r0+VRP2jzT8m3ZrsL+2T7e2BVyPG+bGodRNi
B8V7gC7tx2pu71h/Ye++0qxjV9y/yPPC3t0CphUc0b5n7v31pFHzN9/I68h+
9zZHiuKkL93NfhTpr3tjLA29HQLocZ3MDbNHpcv7HXe4vmPfhb5bzPWZzH/g
/vdloc9eTg3vcSUvgnU6/aTiy7pBZMExtRV4m1PAk413tO+VD3j/cFeSjZnU
X294vMFMRbwBf6nj1vHlfFr9pnM+kz8Fj9O+R475LtzC6ec5Xb4/3ozfb5bf
k1Tg+pD+E/owlOsDFij0wQ2uL5iJ0BeZfL+zHcX3O2sg9nsh37/MVOzfVnz/
sjrF9y+ZiP1rxfcv9RD790LH3lfv74+incEtVhr/KSCrXQGtDuREkdmp8osz
rArpA9/PNFPsZ/PgxjUPe0fL+7hfEudP3R77itlVfVJzQKELZXB7L99T8brT
9tLdQ5/ZiBl6tkeXBZDt5bTWg0t/Zn93DF0/ulYAfeDxconfO5og4uX45Wd8
W1XwlN9LivsSMn/0YOAg1wDzr8zyR9fqD9zt6BrH9Fhgv8XtEstudWH+jxuZ
L9nlTW4ck6fA/Wqf9dq1NFjG7/GzLy+sfj6EWf3cMb7jxGja/jY4oEb9KDqa
M/Rwzsef1H57xsnRDpH00ee1o+fgn3RyWos35UY7y/v5S9zWlK/1wLkoLl8W
5tspksL4fUjmL+5DHt4zsNWu6x6s9ouTnxdviyPDW226m7Z9KfOFgT+mxc26
eEG+D96H02U+UK16Ztv95jPW0D3oy4wsR6rieuFAquMr9m/ujhEtH7pQjR2H
fkyL/8C67nGrdC7Cl5rPS2gSlflAnhdaOMYX6E+6awBcg9PleV7uUfWWgmr3
2Y3NfWPffLaRuM7+SS7D3WyoTuK1sas3mLPbK51HfRqkpg171H+v5z+R/nYp
D7N357dele+NL+Z06S9P+bPYqorpZzZs8XXXn8yBrg6ZGlN9zSdm1lB3/9r2
DvR+6DnLpKWPWCU/mwN3f9vR5fVB1c6YHja4IfyzeD4eei/Gd/lD93aOTW8a
1BHjBz13Hx9vYetLL64dvmBgJPJLHTL2bRja4q5BA1F+KOeHXgl+5vVeOTtl
7155H3jcg6j+0ceuGlQU458UHmjc0vIpXeyebHEzy4E+RDru+Kx72WC0aN+C
j5/yv/Pxvxf08qL+Vs4/mQj+j3P+6bLgv0XZ3e/n0RGZrzZtnLn+UctD8r7F
e77f6K3Yb12Cz/Ro21V7f/kJlw+qIuTj1KFUl0W1zovfy3am5ku37Tm4/oBs
r19O8vO3Xy4YHBJ0PS5PVG0el6dzHpE9DL3esgYtBw2eOsODttsn1e/g8J5V
Mr7/Ub+yLx1Txd9tH3zMAPbgAS9PHUX5hbs9PmzrfVzS5+6oah9265R8f73n
7mXtf+ielven9QUG/c/Sb9d3Tjkp8RreP5UR/f/g+oXGCf3ykusXyhT6pQHf
D9RH7IesLZ7xHhMZu1j10OIJdX7QkFqWc+eXV7P1P84FeV/+gfMc6T/E8/J0
WpQ35OVpuyj/6NnY3B2Ntef1OR3+/u6TrcVT33dbb3Hgijy/r9HVxvxWjAPd
bT0i1KfInx7/4ti9e0XxY5OMeYVnzMPIin/PI+ORJX3MUjfVtCrxfvqyI3sX
RdzU/j5sP4Fduf2V93EW8/pyf6u3T6rgPspP5vvX+8btmxfkR2zn/pr1q4RS
LcdlM3Xc/GW8lHa8wfkWrYv0eLc+es83hlK3rYk9Vp5JpJjcJ2tPGkZRs+ND
YkKnJpR4b3VnH92r74ZFknuh3cWFbbT2NayTXf8HNbxoReNDly0exlOLT3PM
1y3wpFlOF1UxLePpBNePVF/ox8rdLujG3nCX94f23gmp/2mWI3VILtvEcFk4
5Twe6BFz0pFGnLsZGnwhnCbpRK24+DOIvRxuHqXeEkkDuP+hfe98b9SNHjoe
Mr9QWPddv2V+HkynskfZuj20v9d3wnbN6UxVAK3PHBDxKecvHVvzYKh/a+17
R763ZqsX+EbQ0xs6m2u9zJP5UbxPM6zb5ZReMUnIbxLym5H8fp70B8R9OXl/
Ttynk/fnfvP7bfL7o4nNjjbudOoXHZ1eqW9GZjpl8vtxJd4bz2tztXVowyya
xe+Hye9tzg7NbtB/XoSMZ2fWqbHacmsEPVl1r+rtcvEUOdzqio5NipzvRZsf
bK4/KZX0r4atafo8jn5f2FqtfUhZ+b2kBb+/rirXm99f9704xnzh63KqG+s7
XK7V/Tc59E19HctyZX7vqv/6CzMn/iHdJOfAWgvSqU/9K9Z7XhXK+OcBvx/N
dov70X8WJGa9HJIq83GH26rO6W5PpemBYV32Pc6m2gNNJ53z15Hvf1d/9WtG
3falVDYFMRn9UnIpu9Nu146mGfK91GVrv/4wPZnBTJom3q4alkfDz3WLuDQu
Qr5/GjA4YU5jkwiq9mz4wfgXeRQxccp8V+8y8j3vt/z+tbq1uH+tXvwo2Xh/
WXVC69svjrsVUKM49zGD2kXLfJ41j29YlohvnO3PW3YdX06+H2HF72urVon7
2v8W6+bttyin6vNj6ZHo7f/I5bzRhjdjvaT9T3tbcOmtsSc5f09/NfijE03o
vDZizgcPanXEqpbVMCdK5fJMeZW4PM/j9yPorrgf8bqiaRuLjW404bz+ydST
vmTH9YGML8bcClrwtLofHTcN8lgx1oZ0+f6T98XoRY12b/+5MUPb6fNqjC7a
j3OORNRY5s5aBTrXrnI3ltx5Poc9FvmcHJ7PYa4in9OR5+PIROTjUnk+jm6L
fNx7no9i50Q+Korno1iKyEeF8nwY1Rb5sCk8H0aLRT5s2T33WZ2ybOmexcrN
XgP8KYHng1iAyAdlPc2N+3jFTr4PerHO0ea5R+zY5gXv80xTgyid02V8cJnT
abeg9//d2X52Rwc2fu/E9xOqfKJPJ/o/7tPXXr5H4LbPNernBW9yNGjTstRu
F7J1O9SjupcXLe1jstB45lfqyutTb1HfmdeX72235vGp1FdH+H1ypnOL3ydv
xONVNkzEqyIfJd/XXsfzUUxf5KPa8nwUU4l81ILsnKcDo93k+3hD+HrSaLGe
O/l6UjOxnuEzTgx3bexEF/ssr/ToXziFj8tI8T5Z5Peuufi2elaRvndqN+FX
krPU/7N5fosWivxWMNcnUn76lt71JvTnb1bhl/kSSoimg/x7PPZafI+3mOsb
1k/oGxUvT3qi/C+uf+R7Yv5c36hvCn1j9Vz34mcnX/m9flv3SelVn2bJ84wv
XB/J84kDxg30MkfksENxE8dNi02lUP59H6srvu+7xvUVqyD0lbHlhLG5d/3l
exzHeX06Jur37+4fVaFXkrxP/MjZtf2xhkESh37wupm7LFC+j1WuqWHjJ94F
LMtw1aTOT7Ion+s7qQ/z9EZar12Xwkxiq7S7dTsL3xOyJ+J7wqNcH7IZQh/m
8/I0Q5QfwPWr1J+6vD/KEP3V5PpTvmdd0GPm0dAaOuoApx3JaSY5tIx/j6h2
Ed8jVuP6Vf1J6NdCXl4VKMofvRW3v+HFdFavi9+8Nqf/0OGXtj9vdsxgaQ8m
O+2ZlUeGXN9Kffz52ujqNV6Hs5+B743cn/0h99e+oZ59Iti41E2Rvuvy8H0j
CxHfNwZy/cyqC/0s6lOgqO/G69MEUT+d63+p34/x8VEDMb79fHyUKsZ3nH9f
SWPE95VLuL2g6cJetB5VbUTIojLqGScDzbd2zacedW2tny8roz5gmpnaRD+f
1h/a0OJZdGaJ9689S9cJtpyQT9Hcnsj3Gjry9lRzRXu9eHuqvaI9R25fVMnC
vjhw+yHfMxP2Qt1X2IuzPJ5n20U8b8njeWYu4vm5F2xqeGzNlvm4+vz8U94X
uMbPO9lUcd65hufPpL8UwL8nl/eR8D28ufCX0nbf0GdJQTQ5oPSIRkX2ZQa3
J+y6sCcDf+25k6P2lf4t3v9I3HrC89Snj7SF4h6u3Okl42Fbrk/ZS6FPv3B9
yjYJfWrF81PkL/JTS17eqxX0I4ier5rsXWtrJN0t5zno8I5Ychxy/N6oieFU
4URHv+j6cSXej/4i8udHeP5czscWni+S9iLi3YFYuza/Wd+hqRMvLI7GeYHM
H6Tx70nk/a4J+Xs9Upv8JrP4tRdXL42mCo51N9TqkSbzF1+fuJHFIV35PiHe
Cx4y6m9Xp76/yZx/P1/i/ejewr/canG0VlDrPPn9w1TuH7Jjwj98/Hro/JWe
ifI9aHOO5XvPZfj36CXee677H/cfV6i/nTVvVlDiveeBW60/RVzOont9dDfm
Zmvfew7k36tL/KXa4aW+J7XvO1dqUmlpbZ801i139drn+3Np3NBB00Iuh8vv
1T3mzmh3+HC6/F79vsOhW2/zIuT353GHvQ2/N9K+z7xvyo/s1pW17zNb1PLV
HbAkSn4P8XLjsvJ3yuuqka/C/JpNifty89Q/qsm/v2UNxPe3U7j/wK4J/yGY
xytsiYhX2vN4hZmKeKXmdYsvL93C6Xy/oLtHiuTKeXb5vfmtI6jq7uhWH0/H
yfdC90WPNotUOZPDmDJG06r5stROpS7/vOdKnzimaIGRT7QcOc8v7fw3at5E
/2bD49r3lgNm2ZSpXhTvXTAL9Ph1KYK2najaoFERvpoTNCK7CDfv0vlKpdJB
Mh+16uviXsF7Ail5+8nuDU9E0IXRQ99aPwqkvG5RvQ+aR9Dne//NLHMriPZm
zY68NTaSvszO3bKkcxAZnR3WekupSLrA4wWZf2P8e3rWSXxPP5fHD+ypiB/q
8vlgl8R8OPH5YBXEfBiXqbnr2yUvmR9cXfC+a8v63syP7J0q7wqgaL2a/sft
vViru/kvalYJoJgmQyq61/JipbZ+XhDazJ/sP4V2DWzsxU7UPDBsZUd/MjvV
/dyKN2Hy/dHJX8q9q7s9lL35NOpwZnI0Le175d/qDuEs32pve8OBsdStQKdy
2ybhLMy+68cRnWJpKM/nsIMin6N3r+fgV6na+4LTbJpasINHZf7i3NevfdZ9
0H7vPYXzI883N3F+KFTwE8b5ocaCnxDOD/3dwvlx5vzQRcFP6Z1v28UM+8IW
vXR6o24cTEd2ln+4/LYd+76/zrHLjX5SeU6n1YK+j9PJXdDflR928ORs7fcC
XuU/Dyr17Tt5+w/8Vng9mL7x/DtzE/n3e3z+5H33KXz+yErM3wo+f1TKms9f
Zz5/FCzm73fkkNbX+7mxZkZ/b0x9F0PpT87N6NnOTa7H0o2Vru9qFi3zDQcH
xma8fhRF05wHVH51Mpiuvdz7MN/1lgH83e972vadN1SLT3YdNXlZk9sSO6ce
32naI4vaGbS+3umQ9r3iBmUWVfbpq32v2LxDoOcr2yDa1dJ6XwePku8X6yxJ
vbFmfBRVf3qNJXr+ox2vz1Rs/iSaur+vN3voCx0Vxl+e6yvqKvQVzlvfj9Cb
dLDjHxqwVf0yprn2vWK7Lss3GrUPkefD2/j9c2kPru1IGX8i1F2eR91XuWb2
CHWT7/WZ8/iMGYr4bCo/j2I3xHlUJp/vIn+Gz/c/90kvFjfLocip3R+dqxBK
g+um77m2veR7wLEpIybP6B5Gm3k+g50Q+YxanH+2S/Bvc3Hq8AjHMmrdjwsa
DXqWQA03jQs0O5fOmq/IsNqXkUgNOKbGApdb1Tow/V559a/Zj52bvk6mMfqs
zuQaOVQY++T3P5ZKupyuihX0JXdORVU+W1E16+0jf3Ytlbq53f/SdWdl9cAj
T4xDf6ZRv46VzNmKqmqzhF2fZjXOAF01QNBb/SyfuO3cXxbrfflyS91Mas0x
RQt86XlD1/QKOqqO+f6xvcbk0JkmzVWDjEqrn5n+SzMo8v8EVlkIfKrfUqOG
x8uqn0RPmaDzo4D05rzf2uRRJBtyNq95mbf5VIVjUgm8NvDVdJceOVRmQtJ9
1a9/9PBDi8DowVFsy6zDhW5xX2laYoNz5m6h7FR6t64bIu3pNqfTGkEfzel0
QNDvvDFMSasRIPN7TziW+boeZlVPDb5nL9+36tkheLf7mh/Sf0ka43pi9yQP
+b6gU/iIGul3Y2T+zrfRzh8GOwNYweo11Va0Daf287xaxTfLZRsPM30nVRil
bh3c7EB+Ig3bMHdT/ytRZDcrbMf+H6XUv4L9hnVqH0cfuTyoygh5WMrXTz1H
rN9Yvt5MJ46v92U+/+rOYv5P8/lVPRTzu57PHysr5q9q249Gb+cFyvsuehzL
+yNf3r0cfPt0AHu87OX84fW8yZZjui/wZz5eVYIYb38uP6r7Qn66z326fsLR
EPJt3/vd5EnRlBy1qv/vTSFU5th+17rDo6nHlJGnBrTKkOejlfacePG2YaI8
r/y3IWHb01jt7wU/X7D8UfCi3/J9vxAez0ncI3nOovt1tO/xVbf9smzkjGqq
i0f6NjWZnUmum1ptszL3kO+rFRjW+zTpgJt8f06sr3wPyidjyaHHSXHyvub/
AUxGbkE=
   "], {{{}, 
     {RGBColor[
      0.33304651021866355`, 0.12631115445643015`, 0.5851174763344273], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVU1PU1EQva8f771S5bOE4kIpRKoJlLYh8SPBsmChsXZhQoEIkkLiAhJ1
gQnICqP/QZfuTdREE3HBv2CjGDBxIdVEElckFD3HOQ0upvfOfXPn48y508zC
g9v3I865t5Ao5DuEegekGzLvOZfC2obV8+x71jN9n7ZY61h9SBU/d6XPYD8N
OeXZWVXnPJuEBPQTOlfGpgcB2xWbcS8mnbsAeRp37h7uVXBWgvzyTB/H/g/u
beN+EftVnLXCxxr2u9gfRixvxpyLWB085xn3I5BzkD7IDfh5mbT7A9C7nNV7
7Nt92n9GnOuwW3aWO+tkLV8Tzk0krL4SbL4EVm+XsIxBFmBbg7TjfAsHO/iw
55kfYkccHmLdgD7rbH3iWyxiPCrc96UToynl8AP714g/BtmG316cLcKmgPMC
9kXfsHkVNRyqwmZPWHCteVb3oG95MIdN1NIbml6GbxeaHXEn/uzFEfwcqB8R
1UNMGONY+35IpzDdBManQ+vhtxbkB30kbnVMqpYG1iPfuMQ8iRdzHIbdUNx4
cDNhOdXU20sx6y1rzigm7xBn2lwFwC+SJ7keiE/s9/mocaZTnI8K/7x6QX5d
DoxjZ+HjJ/ZbuP8M60povSbedWFzBefPk6bzfhlyi1yLWt20WYXvtG+Yp0Pj
FnudFx8zujMGuSa9Qznye7v0KDCMtVj9FdmyL4zNeIyVRy6f4H+O2MbMlpjx
bCKwcx/7d6HVQTx69I5YRxCaP9ZaUr0fgP1mwvDlu8mEhiXrIyeIcU9oHCJ/
yEvyr6r6WWdB+eb0Fkta+Y29agutTzuBvTG+L3KDvOJ7HNX88TR3yBnQwz2C
7UrC4pEz5BdrJHeGtV+Hz9+B8Y0xcuJVTjkR95zsK8pp/L8cS7LjexmSz+Zb
Yk+J767mRlTcb/YuLx8ZYUB9X3OPfSXv+G6XnNXQUL/eBPZmWA9n4qFiEIOs
cPgIzJYCC0p+FfQWOBPOaC5wpV4UN8nRO87weCxMxsS/suqsSOccIS+YG+fT
huYFMZht8hy964Osx62WJflvDe39kyPvQ3sndeHFXPvVo0G9u4LmFu+zHvKL
etY3mznZ5DUnZ4XdHdWbVo1p1VtQv7LKeVFc5Pmab2+yprnAPP7Vol6RF5P6
LyM+Ne0J9bRmO99FWn6KslnQOW1mdJf/ATXd5dyb0v9lShzu1trQnjO0oXmY
F+bL4gv/EyKaJ2vNuJ7pxJU++f/Dd3Esn3WdpcRLxkrJplN8yejbgPSIvnHm
FMXPZekZdzKT+oTZvHcS/y/EacpB
         "],
         VertexColors->None], 
        PolygonBox[{{1967, 2787, 1325, 1326}, {2976, 2080, 376, 1586}, {1845, 
         2488, 988, 1214}, {1914, 2988, 1623, 235}, {1893, 1850, 496, 764}, {
         2489, 2379, 353, 988}, {1898, 1865, 526, 768}, {1918, 2563, 1079, 
         1277}, {1892, 1845, 1214, 761}, {1988, 2087, 535, 805}, {2856, 1892, 
         761, 1412}, {2562, 2857, 1412, 479}, {2865, 2864, 93, 1327}, {2013, 
         2989, 1625, 268}, {2073, 3003, 1666, 368}, {2988, 2012, 350, 1623}, {
         2848, 2846, 446, 1403}, {2228, 2229, 490, 355}, {2999, 2047, 50, 
         1657}, {2081, 1988, 805, 526}, {2989, 1915, 235, 1625}, {1864, 2976, 
         1586, 107}, {2371, 2479, 981, 342}, {2564, 2562, 479, 1079}, {2972, 
         2071, 368, 1575}, {2372, 2371, 342, 350}, {2787, 1968, 1327, 1325}, {
         2992, 1925, 268, 1634}, {2048, 2999, 1657, 353}, {2061, 1893, 764, 
         495}, {3003, 2072, 107, 1666}, {2028, 2026, 272, 446}, {2365, 2421, 
         940, 981}, {2420, 1918, 1277, 940}, {2055, 1964, 799, 490}, {2063, 
         1967, 1326, 496}, {2026, 2992, 1634, 272}, {2967, 2054, 355, 1562}, {
         2080, 2234, 768, 376}, {1964, 2062, 495, 799}, {1860, 2972, 1575, 
         93}, {1848, 2967, 1562, 50}},
         VertexColors->None]}]}, 
     {RGBColor[0.4191586933729544, 0.2760369850748167, 0.7061585670077483], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFuMlVcVx7/v3PZ3zhk0SgMiBQsMl6ltQJih0FoUevEytoPti4mxTSyg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEts1FUUxu/MdHr/8x/BkC54VaG0xlYwFhIKWgtoeKaFKa4w7IygqYZ3
IRkgoRoCNCFKXPDYGRMTKIQuKFAthBBXlIWKZQGItkAQJNFEEm0NKb8v3+Ik
57vnce895zun5oPN723KhhA6kArk1xjC4iSEEoenMyG0o48hb+dCuJgPYWkh
hGGkCuduzkpF+8h2ATlK/PUUO3o98duxXUMm4XuXs8HUZ9Llsw7/b8nxbmUI
J7n/Cvpy7L3EHuHsG3A9uAvcDF4dfSZ9L/5TsfUj47y3AlnN29Ygn3NfK/hF
bMfxn4F/Bzki+Bi4GvwRuAb8NXg+eB94B7GdyGfEPyV/wN4G/hI8gv0J97+M
f5m3D4D70ScmzrW30n+ZC/4q4z+VEtdItWnmLAN+DbyYfPfBN8E/g98g7wPw
C+inqNFx9PXEjGC/l9j3FZ5ThX0I343YPkTmYfsFvAF9Af/9B313dO9+QpYl
rqlqORvcha3Mf3q5f5we/s9dY6lr30qODuzfETOBXOXg2qyK1lWjueD7+P9L
rsPqMbgBaSJXXTB3diAHs+ZQC3edLZgrqql6+T2SybmnzxK/SW9RTarAF5Bn
xH6Sce/ewl4K7uEZ9LvcX8/dDcj74GLRtWokphp9etG12pJ371qRL3Lu4WFi
L4NHyf0Ddxa4azb+B/A9JH6T7xZntfjmyLcSfBtcl3NNpqMP4L+ft2wjRwv2
E+Ba8NrgXIn+n3dOce1NfN4J5tyignuuXoujC7ENgV9Cf5Sxb59mLuuYS8TP
AZ9A7ya+HN1j9bYHeT2xj2wHMn7bNM42Bb9xheZJnAnmzG1ip4A3o2/Nmzvi
lLgkDk1IzGlxWTXX3aPUrC3vN+wCX8V+DPsNzQ+2malnTZyqQ1+CTzv4UNa1
m5J4NlXDP9EfIyPBPuJSb/RsilN/odfo/rx9PgWvQaZmzRn1prFo7qlHmp0e
8T/jGdoWzQlxIZdzbcejZ1c1Vm3+4M6mvGvUg3469exo5h6jP0q9W+bn3Vtx
UlxUj1W7W9HcUg0H0B+m9lXO8/jOKZpLetPf2Aaje6M/nMNembjX6rFquTPx
bKqmbfi+mngXHQzmal8018RZ7d470b3XDu4HXyx49sRxce+31LMhDm5H70zc
C+3gMXyfRvcugiuw51LvOs3wKL57om3a+cPo04rminayZnt/9O7TjP+I/l/q
3SGODKP/nnoWNKO1xM4qeveppx/jvyh69jTj2t2TE8+advhM7WrkSfCO1S4d
SNxL7dTnlwTTtg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5052708765272452, 0.4257628156932033, 0.8271996576810691], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2sl2UZx5/f6/M8v6fNNsPomM4jjTjnkCTzBVd5Tmsc3BzaCLOQeDED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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1olmUUx+89L7tfnj70YZWbaT5bSJvVULQZ0fb4ofwQM5hbxdSlZmpR
Dhy50LKodJEvYKmRRE3QlExBIl1kafZiuBX1oQaaU6eRuWalJm6m9Pvz98OB
c+7/Oec617nOy52f29qwKBUEwUYoA51MgqAPWlgUBFXZIOiE7w6DoA6+D4UD
cRA0Qm3gp9JBcA38A2gDcgM6S8D60b8F3Z3gebBlfFsHP4NvC8H2RkFwGf3Z
nNeEfDWxbSWB/IXuWqgbvAL9AlgddAB5Lz6y8Cns7wWbDE2A354LgqnFxIrO
WfDfoaXwNfh8CV97wJeA78a+wHn7Y8f+DfZr0K0NHUs/33rAKvH5DraXkK+A
X4bW4K+eb3XgJeB12K4E/xtsGvarA+fofvhe8DFp37Ee+VfkscgjuF8D9p+E
PmsDdBT5WWgTujE+JxFrOfrr8fUWdArsBPo3g90EXQBbh07EfU5z5mTk/chr
kTfj421089jMw3cJ9lPBSqACZ+9CHkJ/GGpGHgxsW4PcG9iHcjkLH4cC53QR
vlqhySnHuBhsH/rVyF3oVKCfhw6CLcf/GvDD4B3go/i2D/kMOcqm/Caz0G2B
vkZ3Pt+awY/Evvt45JfhB6A88lfot8Dfg/4G9JchlyH/pDOx60b/Ls7ajP/j
6OdVP3w/y7fxacd0DL4PugPsXeLdBF6ec6y94F+CHYQOg8+BquFb0UmlbfMM
/GeR305vfFq1L8K+lDNHgk1H3pj2HRWLeka9oph2wH8IDcKfgwbQnwI9nnGM
/8W+s+56N9/aQudEuTiD/CP8UOK7qQaH0L3ItyqwSuhW7lIK7QZrJ6bHwI7r
vmm/kWrnQeTGlGtoJfavxe6lLqgock+pl1ZkfbcXY/eK7tgoX+ALwJ/KmJ/O
t4UZf+tA3or8KXxXxrX2c+heVM3NRX4C+g5fTyNfRP9C4rcoZB37EfS3FfkO
D+PrPDQp7Rq9jVg6YseqevoT7A30P0aeAC3G1yvqcfj3Ms7tiuv3U44vRu4Z
9UoT/mZy3gyoIXAN9oONzDl34zQT8D2Iz/uQH8J+LPzUyLarUo5NNaTaUYzK
dS32nVnnXLNwW+K300xULAV0WjKOqVLzEjkudg5LwXfgbzTYTKgOvhB7tijG
f0O/ud56XMaz71TkWDUDb8ffc8jvZ3yGZlMXdC3lGXUV21Wha6saqoGfxrc3
sZ+I/z2RY9DZV1Ke3V+oJtKe4Q/AL1HOU66hq/BVOdfKMPZnsd2CzYi0e/Y3
5OdD90aZaib0zNWsVUzK7behZ6tyfBS+TPM56xroQf4ncW1MgUbhb3Tst9YO
0GytRn911jP2GNgvoWefZpR6UTNWs1U9qVnRFLm3NTO2RK5Z1apm6A3guZxn
mXr0ZOiZq1mrmPRWT4J/n/WbvY5tc+RaVs0vAJuf8yzryXp3nE8cu3bII/h6
FCpOeWduhy+/Pp9/SHs3LY89y7SjtCuXxs6tdmaMvztzfpuBIte+3lRvqR44
BP956NmoM9pj72Dt3l3QTs2DxLba6d3wPYl3g2a0Zv1HiWeTZn5F5B2k3aOZ
+2rsHlTvqcdqY9eQakc1q902Ef11We841cK52LtbNdEeuiZUC6qpmejPyzlX
yukw2Auhd5Fmmnz9kXh3y6dmsf4R9G+gmbxebxu7F/WP0JZ45yg+9YBq40Ti
fxfViHbhxtC5Vs7rkcck/hdRD3QSz8rEs007QL08nHjXq6cvaN7GzuUlYpwD
PjtnXjNNu/rGxLNCO3tO5JmkWaTz2iP3sHpXPfQ/XWU6XQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.584085454192565, 0.5601249887139962, 0.9099607114833875], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVl32MVtURxu/73vvue++5amyVNt2gFjRakqY0USlQDbBJw9qaaEVrXYSw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsllUQhk///2+/TQ2KaCQVRQnEG2uCIkVMKTfW5UpApLQsrbIklFJc
ShRQqQKJCUJRNKkEBA0CrkSWFKkUWVotikXRaOCKxaiALBeGuD0vLxdvMnNm
5pzzzZl55xtY1/jo7FwIoQ0UwPQshCdAA4vfFIfQPwlhIdiSD6EWtEYhdKUh
XI1tUFEIe7CVxiFUEXwCe4otA6PQG7DPw/YGPruxrWVtBfIDrNUhd7B2J75l
oAa9L/5NyOXgafTVoBK5Hv853KcO/1nIr7HHLuRF2F/Bvoa1bchbwffI74D5
2EtBL/bDoAH5MHsMIXYl+AL9Vs6bjm0G6EavRp/Kt08Gs/Dt5htfwHc+KCly
DkbgOww05nzHBLkf51UW/M0v6W6sFYjdin8NtifZrzfnnDZhnwM2YtsEBqfO
kXKjnIxHnpY59wfxr0J+EEzAdhN3qEGuBjOw7cPnE/w/BuOxVeWcm072LCl2
jmoz76m99rM2HPsC1k4hL8DejT4I+yr0s+jP8L6TwQj8C+hPIW9gv1Oc3059
5InNgZ3IY4g5TewA9piC70xiOtGHoT+nWgATiT3A2l7u18Iex7HtYO0S8mbs
/2GbmPlbRqMv197Y8+hRCevYK9Cb8b8K+7/I/4DNwXf6KfYeih0IPsT2ETiH
bR1nHsU2kj1Xs98Q7Cf4nnu5w/PIZeCP2N+gu9+Ify/ylMxv3x97h943ce71
pkOx74qdmzbWKiLfQWcvAbPxbQAbkN8HddhmZL67anhP6hpU7emNFiMvSVzb
sh9FXoXPIe5/TcFv0Y/46cV+k4BclDn3HwTnelzs3lTOzxDbRcxfyCPxuTlx
DnW+3ugx9LHgTeS3wCTkGtCG/DZoJrYD/y3c7yT7N2ObB74t8lo58rrYtbMQ
HEBfrjO56+m8c/sl9izvHKsXFSNf9eR1+PbVGyIvC+7dPbFrRT18B7YxeoOc
e0ZnXwSDC76DuKYL/UzenKPe60Q/nncP5tF/jf22Iwru3QWJa+1yD5O7VyO/
9TTqqwf5PGf256ylRa7NeZG/XTX6I7FHEuc6V3DvzAcni91DLdgWJeYDvWEv
8ndgdfA3zkXexH7H8r5DBbF3cb/1xK4Dr2NfdoXPxJHrY/eAal9ntCf+Jn2L
9mhVvhNzpzjsomo99d1H4/8Ltp8T96pq8ELimlYtK4d14g/0qehf4T8WeTHx
2wvO+STuulGcU+IeP6f8sMdR/A9yRiu2DbG5tJy1h9EfAueLzOEvYmvOzL0r
8fk7cc6V68+UD+SmzHtphtwuvshce31y5rLq1NwuTiuLnTPlSj2/F/3PyGer
xsSFkzJzmzhRXHMP8XML5pyzqpXEeynH4vb6zN8ujp/JXjuIuSTuD+bCa4l/
pGBOHEfs9sizTT1zQ2aOEbeoJ/cjr4g8CzVDPkdvTz3LxGFHkH9InQvNoH34
fs0ePeSjRWdy3m2csTjnGlIvjU/cm+qpZ/GfCkbnzGmqnWOxuUw1tBT/99AP
5fyma2PPRM1CvWk5Zw3P3GuXOQH5QupaESdOwP9u9dwV/h6K/PgVPhRnTIw9
0zTLlNOq2DNc9VdfcC02xOZ2rY0i/uXEXCbO1qw7EpnLNPN+Q/89cS3oTcR1
jYm5UpzXg7w/cm7Uk7s1qxO/jfJ/MfYddPYw9J3YPo38r6EarEAflZiL9aa1
io8828RxGyP3pHpRNT089kzWLK7kvI7IMfIVx2yLXAM6WxwjrtwVmevkc73m
Q2puUM/fgjwg9b+EZnYp8v2xZ7NyrN7SDNHsUI9NQb4vNXfo/VUbfVL3gmrk
QGROF5erJt9V/jN/u978f+hNSDg=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6473978344716862, 0.661850366965352, 0.9114040387489551], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl12IlVUUhr9zznfmnLMPCf1okTklZlEXRT/WWHiRSaaJlGVZNlZ2oeXv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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1VEQxs+93tv/3vMHwUoLNKWihRAV9EAtoexhWdiDHpYoZgu1h/ZS
W0S1CFwURBotWrTQQGoR1iJB09Aib9FDK43aVIvCpbWoTVS/r3ExMHPmmznz
+M6ZX9u0qzHqnKtGYsigd24AOcLhnjTn2pPOdSB16K2cVSacW4k/Pc0wpfg2
IpewLwsfOJeP3YCeHnduc+hcZtJy9WDvRN+unNjXkEHwKeyAXGcjzr0j9ziS
BzYXWYzvLXYOegH+avCfqSGf2EJiatHX4G+h+Ndg3oAfRdaj/wGTxBciJfh/
E78MvYKY49hNMau9GLsiZj10oY9S8+QM8pE/S/Ujz5nNFJgx4rvBePzZ3HEh
YTWr1i+63xtGPtU8gp7yNovz5FuC3odEsRtjdtdZ5GPU7tyKvgD/FfT7cdOX
esPqLA99HlIG/gBnDegniJkA24H9gPkMJa3X08ht7B/Yi/DVYr8Am0FMBvEv
yfcUvQv/OewwbrM8RE9nYjbTGvRVnJ1Cb0Yeovd7m416SCPfX+zr5N6D/Z5c
40i5fKoP/2HkIvocZrgcbBs1ZUVsB/fIn+utl1/k7MbXGtosq8BMeOOAdi9O
FKB3EvMqajNT7fVg2mPWQzPxAwnjhnYmrpSQrztunNHstoTGRc3wK/hJMN/I
34t4bxwVN8WZmdgF4G+AL8eejV2MfRN7B/Zu7L3euKSexO175PyUZhwfxu4N
bBfieBF3rdDOwJdijwS2E+3iIpg+8HcC25Vq0lu6Gthu9KZa0O964+IH+msn
doqzkYhxUrOtD+0tqB7tJoK9O247esL9jxPWq2K0q0xvvWhn29DLp9/T/4+B
2LXIrbjlqMC3z1vt6nmhuBgaV6ti9vZmeZuV3qBiJ5LGBeXoT1qMsJrRUWo5
gP2TfC1IZ9I4LS6n8Nd544i4oR2fDO1N6S2J8/sT9qZVi2ZahF6IcPyfsz0J
+6P0N+mOQs0aOztqOz0ItgaZyyzawFeBX+2N6+r/XcI4KS6Kc98Dq1G16U0p
Vyqw3SlnKbGbvMXq/hxvO9e89MeUiX/edqMZi5vR0N6OOCpujSXt7xLHhsEO
eZuN/uAS9A3T71E9PgP7KLC/U2+6Et+xhP3V+qPXeetJ9ehN/wMMmrmb
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7107102147508074, 0.763575745216708, 0.9128473660145227], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGmMFWUWhuveqtv3Vt1RHDVGg3HJoDGjaARN2oCdOAoCo6KNgysKKArd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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF1olmUYxx/3Pi/Pcz9vMj8iCiL1wA42TWqKQdSBtQ48SZdMaH7MtUXb
O7e5NuiDdDONahLJXDVFsdgsdVOwkw4UBGfgB/MzmDZwITljZLhzrd+f/w4u
uP739XHf1339r2tRXWtVS0kURXVIjPQmUVQWoqgpF0WXkO/R+5H30T/EsQ17
NVKOfoSzCWx3kD+ILSXBWBZFt5CT6L/j01uIop9T6+349xH7E/6X0Z+fFUXH
0LvwH8Z/Pz738F0L3g5eik8l+svISuQN5D2kDZ9P8C3Fvpx8r3O2CqlA34pU
IVeIH8D+FPm/Aad53g0+B/4L3xfBj7l/FPwv+FXwPHI2gPvAo8Q/Cx4CH0eu
E3sD+QzbLuQm+m/E3yV3E7gP/xc424q+LfX/9XN2kdgp1UD+lHxPguerfv5r
pMRvr5ypTTVcIfYqMojtNvmL/N+exLVeI0eR2Obgv9+L/SIxF5Bu/OdiP49+
CPvHJa55C3gz8hH4C97zDraa4Ld0Er8FvS649k/B9cF/oNp3g7sz90i9OUF8
F+/pRh6S+8cS13Y2caxqvBX8Rr0tj39e/cfnO/B67EvRx5HF6M2xuRQXbBOn
asB/Un8Z9VWAdxZ8p+6axqdR3Azu7VfkXIP+i2LAvcib4mpq/vSAN3BXE/FX
8+bvfeyP8a/AvgC5jf0wePUs91R/2YH/WN5/uilzDsV+jv8k8f8kjn0OGcF2
buZ/NSM93L0smOvq4RJs1alrLcbm0iPiX4rNqQ+46zL2+Tnf2QluBxfB43n3
vjZz78QB+ZaLAznHDKAPBs9qF/c1FjxDmh3VPFu8CuZ6Zey//xu8MHYPiplz
KFYcvhn8x/pbLYSOxD1RL6Zi3z0NfiXnN2jWxoJ7rZkT1+qQL2P/yQ70Obzn
tdgzrtpaODsQu0b1ujbxLKjnK8i1PHg36A7N5oXEXNSMbgS3pO6Haky1K5Ch
2Hc0puaAer8DvBPbwcTc1U46jO2H4F2gHaJZbcbn29gz+zb/t67gXokTevsZ
/Cdyzi8uH838F+J0G3pr5l2gnabZawB/HXsGtUv3JZ5N5dfu+TXx7GkHiauT
M/0SZx8k5pi4pR69Bb4R3AvtpKeJfybzrtUOEZeHg3eTOH0q8UxoFvTm/4J3
inaJONeK/m5mLqk/9Zl3mHaX3nw6+E9Vq+I1W09k5o5m7H8ox8yl
         "],
         VertexColors->None], 
        PolygonBox[{{2616, 2149, 1146, 2631, 2615}, {2108, 2643, 1151, 2642, 
         2107}, {1929, 2645, 1152, 2644, 1928}, {2610, 2155, 1153, 2648, 
         2609}, {2151, 2622, 2621, 2638, 1148}, {2649, 2108, 2107, 2647, 
         1153}, {2635, 1929, 1928, 2633, 1147}, {2154, 2610, 2609, 2646, 
         1152}, {2622, 2150, 1147, 2634, 2621}, {2632, 2143, 2142, 2630, 
         1146}, {2143, 2637, 1148, 2636, 2142}},
         VertexColors->None]}]}, 
     {RGBColor[0.7728614254965899, 0.850409574303772, 0.9094477785453459], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWH1sX1UZvv3d+/vde87doA6ZOkNgSNX4EcFo0KDGiTOwDxhj6yiLoFtb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlntol2UUx9/fZXtvTiRLLZPQWvlHEYFhIUQWQmlqaG6apKZz1tRt5Shn
mlou0mVa5rVpmvfwAl66EOa8bNOFKWmoKSVBmJKhmWZC1OfLd38cON/nXN7z
Ps853+fpPrZqSGU2CILNSB45GQZB5zQIJhUEQQkLt8ZB0BAFQR+chuSC4P0k
CPqy9m8mCJqxJ/jGyDfEDifmQ+xjsa/CtxV7V/DP4A7opcjL5BrK2nPYp5Cz
E7Y1SAu4BzmnY38d+zp8z5Gvltx1rC3HdycyBVyDdMD2Hf5F+LZDKtHnkqMP
uebhPwV9FrKA/5nP2tfod+FTi++b2DeSfwPSB/tpcA/sdUg1eBL+69G36Z/Q
v2TtPHg5MgH8EtKNWt4hXwG15FP7XiRfN3J9i/0qvv3Bk7BVIieodzoxg7BP
o4ZN2EaAi7HdJP9D4Fn4TAM/hk8p8b+CJ2OrIN9a8Cd84wD6AuJb8q5pF/4r
8XmcWioKg6ALtn6sbSF2mL4Bnki+mqz3/F3i5yLj0F9h7RC2cfjMw7eJHDPR
ZyHHsF8FDyV3Ef6DwI34d8bWnvyjyN+OmM/Qx+Czh9oG8P1x+B4G31S9yCL0
9ay1oheTbzB4MTlWgxcS0wVbL6QWPBJZiX4Ae0j+g+CqyGvSVWN/8HWkN3g8
eDS2RnJeUWzOvaqaVIt69mlwQ1t8Gf4vqB/x304tdeBL2H6PjdUj/6m3sZ8B
3wZ+GHyDHIeyrvFH4rextgl8NzW2R1+BPVvoPVrEt+eC12FPC30WHWPPjs6k
CPy99jTvPbyC7+XIvakzCrFHqWdpO/tTH7mn1cs1yES+X4HsynhPl6IvQ46T
b1DWvX8scu2aAdX+Z+hZ0T/MjDwD6n314D5sY2LvnXpWs3Ec6ZrzjJxUr0b+
l+7UlMU3o/4JzAHX0a8hu9GPIdfwP0LO+oxnpDJ0D6l3fiFfDfrmxLOinplN
7vsSn81m5J/QM6FZmAzeq3o1f4G/MRXbG6lnQ5zQKXFPqhfFQU+hj4/c2+px
zcoTsblBM/MHuS6At2DfS74z2NewNiDjGdRe7Af/1dZPFeQahk9RzuczAL2c
tVezXnsS3Ev9T2wtcpTadrM2Atv5QvfGPNaCQvfICfIfj937mune2Irx6Zj1
NwcT2xw59wzytWBvTs19eeJPE3sqNheIoxaHniHNzhGkHv3ZxLGqsSz2TGoW
NXNHNYuhuUvfXKr+1cxh24c8H5vzxHUrkPLQHCluVI89In5J/K/a42X4Lokd
uz9n7p5B/evz5vAt2LYiZzOeqdWqBWnOmfOr1YvgOnI1iK/Qv+J7F9v4dlXk
PdVetuDzAP4lrJVlfYYT0AcmPmv9r+6uU8TfkvcdVgoehozH1gh+G9/DxHTA
fyc+w1P3nHptX4G5QhwjbhFn6N8qI3OF/vEt4k8jPQrMuQNTz6Bmbydr74Hr
U8+uzvxU4hnS7Chmh3olNrfqzqpOfUfobvhBd1rsO1R3pzj0J/Dtibl8Ivah
+HZlbRS2PQXmmgdjc4M456z4lLWtBeaYe8BlbfOwI+u9rwYvzPsMeuqsY59d
94xj70h89yuHvrU6NNfpmxvQ5+CzLGuOEJeej3yXi0N/w/9S6NnSmTeg38na
6JxjPo4985p19Vwr+AOdSd4cfgHba6nvfs38SvD81L2vGb03NmdqFsvxbyJ2
Yei3QxO4OfYdrLtXPfQF9s8T947ujE/R1ybmInHUwcR7oH/XnfNi7DtFs683
jN4GfUO/dfRGUG89ylq/rHtMtY+MPSv6h4HYqlKfpThAd8WcxL2mO6M88Z2r
u1ZnoN4ckbr31KOX9X9t86T9PBe7B3T2ekNNFjdSQ5zzm+JGbA4W9/bE3kr+
j0LftXojTU385tBbQzPZCN6beFY0M/frLZa6lzRTZeLPxHupO0ZnV5J6dnSG
B8FNbfygO0BvlWdS977eLJqtqsSzrBkTlxXHPitxmmr/O3at+ofZid8wervo
zSEu2Biby8QJ/wPv9W+w
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8297202400660699, 0.8693704739059274, 0.8839750805712576], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwVmUVxvd3vm9/+9t7p4VjWo0wU8NlpuCMEwxMUDQqiiggAsklZiIr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVmUQhk////w9myCQWJcE4lIgUSDEKkZADdRQW7aChC1cIEHAGEET
bcqeACpLAUGUAlqkCBFJ3BBki6WgmAgFAaMm4gUKBBRjvYBWaYzPm/dikplv
3plvznyznHumzRk7OxcEQSMUQl2SIJgSBcExDqvzQXALcgatR9fEWWf4TtB7
yM3IZfD3Qc+CrYV2we/PgmB+cRC8jb4lDoJT0Eb4iqIgqEK/IsUXl11AvhV5
Ffgi8KOxL4aPoUmFIKhH3w19V+hI4JiOYHs3cg90BTDNxHoCOUG3iLOB2A6C
nio45l7oekLN6B7Cf1/4BmwawM9BHgl2BDQS+Swx5dCXEG85/JPo+yNvA1+K
vxrk88hnZY+/x3P+9k3Idxacg5XI5dg/g/1B5J3oziGvAzsFm8+I/xR0G/i9
0DX4Y2AWo0vBrIF/mbNtob/xdvy1xo59InQZ+QMwU9F1B7MAXQ3x90f3Bvaf
YPspNAx+J5ib4NvB9wXbB2qLfCZ+MfdPVK6hJvif9B7w58BMQ54KdUe+Gvmu
WuSZ2M5QTrivEXoH3R4ws3i/J7BfTDzzuH9y3t8s7LdgOvK2uYHuNHIlvioK
tl0WOzfysQf9qMy5eRr7LvBdM8eiGvgTf3XyCf5eYhqSuYZUOzvB/Ir9R/h/
Dv01aDm6Gs62gz0A5kXwc6CJ+D4H/iv0nZUv9FfRb0HeDJ3EdkPOtZzG9qWa
PgNfmjl3rcTzCPzRyLVXz9mP8C2cfQ92R5FrfyH+d4fugeP4PgCmpsg1m2au
edX6ZOwrE/eIekNvvBbsK9g3Yn+Y+B7G35fg6/B/mvsnwI/PnHu94SHwPWLX
0jW9EbYtnA1DdwEfA+Avou+Tdw+uwfY41Ii/AjQC3RUwM9BNwMdYdNXQFPhD
+LiO/gY0HvkS93fLHJNiUc0sQl6ufMH/Dr3J/T1j5+akagj9q8gXkX8ruBb6
IffKuSaizG+qt9QMqETXO/Vb6M75qWeMZsuH+PtO9QStzbkH52b+Jn2L7ihG
F+JjMNhB0GlsNygnoWvyZ/j/ONudc49XE8+sxLW9jm96DdubnF0peGa8gO/Z
mWunHf0S9MNj5+ot6HpqH7JVzudpFmb+Vs2Yd2PPFM2S48i90HWAX4p+ieJH
dx3qTXwfg+mNfmvk2SnMKnRNqWef5ksb/sZkfpuBeccqn/KlmDvAnuFsfZFz
fERvk7h3YvAB/FD0+9GVI3foe2PXtt78ROyZpFmkHJ+K3MPqXc3YL1LXhGrh
H3zu5u5HY9f+KN7gEnwBeix0zak2+iWevaqRq8hz8Vmc9wxrUm0g3xH6bJlm
Iz7/UG3g8/XYNaba0pl67a7Us1g9txHff0OloXtYvTIg9ixUz3yDvDpz7lXz
M/E/GNqH/AM2pdiujr3LNM9j5DGRd19V3r2omaxZrJ6sRV4Ye/Zq5smXcqpc
yucM5PrUu2Ucqgb4rdD50DNfuVGNqjaVo8upe1i9W8b3vY+8A7oU+g21m4bg
f3neO+olsBOgozljNoHdnPpbNAM/Tz1TNUvLsFkDPyRyLPIxEn97OWsPPRPV
G+pZ9ap6ZAH8lsi9phn2PHwVdDjnb2hBX49cUvBOa8DfWs20YvsUvy91behM
WNWsalU2mr1FiXetZnABPoSmB65J9ea/kXeTerQT/jpD40LvYM0q7SjtJs0s
xaY301spxrnc1ZM7pobeqXVgV2b+d9E/x9DYO1u9JIx291+xc6UdPgnd14l3
g2a2cq1/JP0bKefTIte8av0XYn6Au+5PXauaOSXw5eh3FRzzwchvrLetQB6t
eZH6fv2jtOO7LfFs0Qx4ENuyzFjlRLt8aexZo52uXbg68W7QTlTvaIZodqiH
tPumx65l7UD9O61IvAvV062JZ4JmgXpmNvbbU+8K/eMp9iTzbtI3/A9NX1Nv

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.88657905463555, 0.8883313735080828, 0.8585023825971695], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMVdUVxs+dO3PuufcSBYLOoDxSigqlUIFAE8rDCIGitWEmaekf/UcS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW9olmUUxu/3ed/X536eRzCHWBIogWJsuMrQD6tR2GqKFr0j6Ytfsg9B
YRIIYiaWs5k5tT9azulGZViButm0tvJDWGCZM6lEERXMFCGMKBzktH6X14cD
57rP3/vc55z7rsVL215MQggroAo0kofwQBHCjmoIUxB0gjdAA/DnoP3wTyAf
Qfka9A38/BjCvaUQtowJYQhcB14KfhX8B/qPpiEsw3cTPjuQt0P78PUveAjZ
D+Cj6C7HJkW/gv1l+MXobIJfh/zhsnMYTp3jrdzQOQY/nDuXe8Dfovs2Nk8T
rwef3eA52CwETwOfQHYdasbfJKgTfi06t5ed003wZqg1OGYD/DDyU9hORL6S
WN+Dj4CPI7+UhXAF/0PEPgM+guwzbPrQ3Y1OHfhn5L3IH1L9kH0eXcs90IOZ
z8S/hv0F/M/A5k1q01A13whtqPpsFN026Ouq79CErMDH42W/WRu4VrgWQ+DD
qjf6J8Hd5HOOXC6gP4F63VnxXbo5ay75TjPBFeSP4W8z9t3Y7uasBdksclwQ
/ea33hqbo+CV0Hl067A5iO0X0Cn4keDc8+ha6Q7H4JuQrwZPgJ4j9nbu/GvF
b6S7PVk4d91xJ/zk6N6oJ+Yb4LfAN5HdqLp3xmFfStxDXfB7U9dOPq+i+ydU
Q/4b/n+HvwhND+6xF/Q22JxBt52zOcimgTsT21xDvgb6Et1foKfgP1Y/EutD
9L+D3xbdGx9wdhr57Oi3XkIOu/QeqX03I/8I/vXCvd+PzlpwPfGeJ/6Pie9y
f+Ha604Due+g3DVzM6hdI9SLrKXk2VKNVBvNWCs4RT6P2n6VmJ/P2aHEZ1Pw
tTVaNhe8H3l/5rc6Cf6JeF3oz8L3HeSwA7wTGkw80+9Ez5hm6yp4jHpF/Y+8
Ffvx0TtAs68ZfCS1jmTysSa6J9WL2hnqneO5Y6mHeuAPp94VepN1yFcXro3u
XMXXu5z9V3KPzgV/knr2NkK3qVc1g9g/A70f/UZ6m47gXl6Efn9wT6+CHyTm
qHqFs13wJzirYXuRsxXYL8vd2+qJl8EtmkH4jVB76h5RbwxCZ9Hty1xLzVgO
n2WOrTfYEv0Gqr1q1of+PuhvdP+BxqLbhXxy4pnWXcZzViv7TnuRvVd4V/yV
eFdpJjQL2lnypR5U78nnp9E7SbvobuQvqX9z3001eFa1yB37PLgu88xr1hVz
K7Z7omNpRyo39bR6WTmOU36Fa60dp903Ex/Ly96BHeADyJdoNkqu3eXUtVIN
XyH2qty7QDvoALYDmXPVDpmN7nrkm8qe2Uupd5h2l2ZSu7leNQne0Q25/xD9
HZop7Zpe9CeWvXNG4KcW3v3aieol/RH6G9RT92WeUc2m7tCR+s311oeQz8vc
c+o15aRd0Bj9F2knTAePpr6rYqq3atG26rHR3DtEu0M9ptr0pJ5l1Wg9eGz0
bGnH/Q9OzQs/
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1slVUQhk9vb+93f1pM/xZtqdaNsb1tsQaLlW6Mv7QmBMGktYBESKgb
XdKQuBEFjUTUiLrQlaua2ChYiS4oGE1cuS2QtAsXGltI05ZiiQnxfZnH6GJy
zjfnnJn3zLwz57v/5deefzWXUvpTUit5UTIiGWX097hk5/90V/IpzUuOar5a
SGlM4y7J+WJK5ySbMviUjF3QuFGT0puVlE5Lf7supS+ylAZKKb0g/X3SfSSp
aN+aZJ903SnGvcwXNS7UhG6/fK1KtyL5WDZndLZVus/LKX0muSpMD8v2l9Iv
yJ62pA5Ju+SC9N9JrglXvb63sjYE9mclXTrznNZPad4snE2SNs17JcPEoF/+
+iTHND+o8YBkRtiK2jtJrB4jTrbbIv14TWDuYc0+e4Tx10r4/Ea4zknm5ftT
6X+W/qL0v0m3mIX9XvmpFiJWXmvNBc4d0g0W4tvxfrw27nJJsbgseZT5Ui78
Op7b8xFT3/UidjL5eiaLexU0fyKL/DqOj+TjnO/RQkx8N+fWvs4WI5fGVq/x
nUrgGM3Crm3az2ht4CxJVy7F97caZyVXNb9VE7yx3fM1EQ/7fKgu1syzp7PA
Z2zWbaD3fWxjQuMf2vOkcDSw7rgYZ5UcOgedkj5yO6A9jZK8ZE6xfKkQXPOe
Ncm9KbjwYBac8tgtKcOTbrhSyoIHr0h/CDu1snmYeQMc9rxEbXn/ODW1Xoi6
ss91/PrslprYPwjOe1LUQVcWvLL/ZvC0MG8DWwt7PO9iz5FC2DWeNu7WDpYS
PM7jy1jM9xL3Mv/L2X+6Mvu7iY9tLeeCb+ae73oIX3PUSy2xtu0tKXg9Dbf7
mU9yP9/TmE8p8O8pp3/XRa4n6BHruegT7dR0L3n+qy56jPtGB7oe8tmJ3wbm
Pue7Or7rzAeIs/HPgfkAvFhBf5g8GuN+5jPsWwHTXmJs3UHsrBUi12P0CffQ
XeyZw4f3WG9u3OUE81XWxuDGEfjxgWLzUyW47thfovbPSH9HMivdnXzUlGvr
lmJ7Igs8E9SbcX6tSywo4A/URQw3ieMm37s13yN732vPRC546/o0nmvYtr03
svBx9765OOtcHNfZk1nwwTZez8KO63yGPume9zt97zYY7Nf9/QrvjvvLLHW9
jzfCsXav2k6/Mh7f2Ziq1JZ5tU4M5+mRjtUN+o3vPU6PdD+xXfu5Qa97X/jf
roTOZ38kzl4f4h1xvBbhnvnZAfeclx76v22cIS/mez/8b6LHtMPlrXC0i7p2
fJznD4uRa/fTqRQ93Hvr4bVr2f3FNWv/FdZG6YHD9PAh+qF5NcL7NYLO+37Q
wcZi9FrHy+uT9M5OetRO6quXXmGfU9joYa0KDmP0+/ZJMd6EXzSf5r32e1gt
xps4/K89/DRQs+7nxj1Gna5T0869Y+Ze0FQIzrkPvSuOnS5Hnpx388dnv5Kf
s/LXUgh+jMP/5kKcv56L/5jr9LFt5OgYvcX2d8O5Cc76fs63cbgv9tPHpnm7
J9GX6J/2Y3+2Yz/+NuZB/jGm6I1++4/SB6rM3Qcvw1uLOTwE/hZsrmHT82X+
sRyfVvzap/HeRH9C8ThZiXq7yZrzZzw7uPsG+5eIzTLx8V23wWGvb2DzrUr8
87km/F/mfDvXTcXglnnlt/o477Xz1FgIm0vYMgbrNvHl864v22wlXo6V/z2H
S7FvGQxLjMvg6eN/yXf5B9w4PR4=
         "],
         VertexColors->None], 
        PolygonBox[{{1972, 2066, 502, 1328}, {2091, 2086, 844, 544}, {1923, 
         2991, 1632, 259}, {2353, 2354, 733, 341}, {2190, 2698, 1217, 1531}, {
         2222, 2964, 1555, 1557}, {2194, 2060, 833, 695}, {2027, 2129, 603, 
         270}, {2950, 2949, 341, 1528}, {2715, 1972, 1328, 1240}, {2991, 2023,
          269, 1632}, {1919, 2481, 983, 1278}, {2483, 2487, 986, 347}, {2065, 
         2307, 837, 502}, {2022, 2990, 1630, 430}, {2482, 2480, 1318, 983}, {
         2781, 1957, 345, 1318}, {2560, 2484, 985, 1076}, {2307, 2193, 695, 
         837}, {2314, 2198, 533, 843}, {2086, 2200, 702, 844}, {2993, 2027, 
         270, 1636}, {2716, 2715, 1240, 1241}, {2364, 2220, 748, 760}, {1954, 
         2948, 1529, 335}, {2975, 2197, 523, 1583}, {1859, 2717, 1241, 103}, {
         1863, 2975, 1583, 119}, {2485, 2483, 347, 985}, {2486, 1919, 1278, 
         986}, {2965, 1954, 335, 1556}, {2198, 2978, 1591, 533}, {2964, 2221, 
         1556, 1555}, {2990, 1922, 259, 1630}, {1926, 2993, 1636, 269}, {2220,
          2966, 1557, 748}, {2196, 2974, 1580, 523}, {2219, 2227, 760, 
         1553}, {2953, 2192, 693, 833}, {2059, 2951, 1531, 493}, {2974, 1862, 
         103, 1580}, {2698, 2699, 1218, 1217}, {2302, 2059, 493, 693}, {1957, 
         2530, 430, 345}, {2188, 2947, 1528, 1529}, {2700, 2219, 1553, 
         1218}, {2199, 2313, 843, 702}, {2978, 1867, 119, 1591}, {2217, 2561, 
         1077, 733}, {2561, 2560, 1076, 1077}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1917, 2745, 2129, 2027, 2993, 1926, 2170, 2116, 2023, 2991, 
         1923, 2038, 1922, 2990, 2022, 2014, 2530, 1957, 2781, 2480, 2482, 
         2481, 1919, 2486, 2487, 2483, 2485, 2484, 2560, 2561, 2217, 3016, 
         2218, 2354, 2353, 1955, 2949, 2950, 2947, 2188, 2948, 1954, 2965, 
         2221, 2964, 2222, 2966, 2220, 2364, 2226, 2227, 2219, 2700, 2699, 
         2698, 2190, 2951, 2059, 2302, 2191, 2952, 2192, 2953, 2060, 2194, 
         3012, 2193, 2307, 2065, 3002, 2066, 1972, 2715, 2716, 2717, 1859, 
         2310, 1862, 2974, 2196, 2079, 2197, 2975, 1863, 2311, 1867, 2978, 
         2198, 2314, 2313, 2199, 3013, 2200, 2086, 2091, 3022, 2090}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1891, 2737, 2736, 2735, 2009, 2102, 3006, 2101, 2834, 2003, 
         2831, 2833, 2832, 2884, 2321, 2322, 2203, 2983, 1884, 2320, 1879, 
         1905, 2725, 2724, 2001, 2812, 1876, 2981, 2094, 1999, 2806, 1998, 
         2807, 2875, 2874, 2315, 2316, 2201, 2980, 1873, 2312, 1866, 1899, 
         2719, 2718, 1987, 2796, 1861, 2973, 2078, 1979, 2790, 1978, 3018, 
         2575, 2867, 2866, 2308, 2309, 2195, 2971, 1858, 2304, 1852, 1895, 
         2714, 2713, 1966, 2786, 2861, 2862, 2058, 3000, 2473, 2683, 3017, 
         1947, 2684, 2685, 2254, 2253, 2362, 1951, 2855, 2044, 2854, 2043, 
         2182, 2997, 1950, 2349, 2350, 2184, 2942, 2183, 2943, 1924, 2602, 
         2603, 2567, 2052, 2566, 2053, 2277, 2276, 1846, 2697, 2378, 2377, 
         2376, 1960, 2534, 2025, 2845, 2024, 2124, 3009, 2123, 2178, 3011, 
         2179, 2040, 2555, 2039, 2852, 2257, 2299, 2300, 2130, 2896, 2898, 
         2897, 2295, 1944, 2765, 2766, 2738, 2894, 2739, 2740, 2286, 2287, 
         2115, 2442, 2114, 2597, 2169, 2676, 1934, 2251, 2171, 2767, 2768, 
         1945, 2339, 2355}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1890, 2987, 2105, 2008, 2839, 2007, 3021, 2586, 2100, 2524, 
         2002, 2829, 2830, 2583, 2582, 2883, 2825, 2826, 2822, 2824, 2823, 
         2881, 2319, 2955, 2956, 2954, 2202, 2318, 2317, 1875, 1902, 2723, 
         2722, 1997, 2805, 1872, 2408, 2407, 2406, 1994, 2511, 2708, 2707, 
         2085, 2871, 1986, 2400, 1985, 2507, 2077, 2502, 1977, 2393, 2501, 
         2500, 2574, 2305, 2306, 2070, 2369, 2702, 1857, 2265, 1851, 1894, 
         2712, 2711, 2893, 2892, 2110, 2938, 2939, 2936, 2181, 2937, 2958, 
         3014, 3015, 2957, 2205, 2352, 1953, 2779, 2558, 2042, 2853, 2041, 
         2904, 2905, 2901, 2903, 2902, 2332, 1948, 2995, 2180, 1958, 2259, 
         2174, 2681, 2175, 2682, 2126, 2680, 2173, 2679, 2172, 2934, 2281, 
         1913, 2239, 2020, 2425, 2549, 2550, 2552, 2551, 1920, 2925, 2926, 
         2924, 2928, 2927, 2125, 2741, 3023, 2206, 2959, 2742, 2743, 2293, 
         2294, 2122, 2460, 2121, 2599, 2177, 2459, 2458, 2455, 2545, 2544, 
         2240, 2540, 2541, 2444, 2445, 1935, 2677, 2327, 2288, 2289, 2342, 
         2341, 2246, 2639, 2640, 2443, 2751, 2752, 2336, 2441, 2440, 2678, 
         2148, 2340, 2189}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2587, 2527, 2528, 2526, 2585, 2584, 2885, 2323, 2324, 2204, 
         2986, 1888, 2273, 1883, 1908, 2729, 2728, 2821, 2820, 1878, 1904, 
         2412, 2411, 2521, 2520, 1874, 1901, 2410, 2409, 2516, 2515, 1871, 
         2709, 2405, 2404, 2403, 1993, 2799, 2510, 2706, 2402, 2401, 2399, 
         1984, 2795, 2506, 2705, 2395, 2394, 2392, 1976, 2789, 2499, 2703, 
         2370, 2573, 2572, 1971, 2384, 1970, 2493, 2064, 2687, 2688, 2474, 
         2689, 2996, 1949, 2690, 2777, 2776, 2775, 2216, 2963, 2185, 2351, 
         2187, 2363, 2186, 2256, 2255, 2559, 2045, 2475, 2476, 2477, 2046, 
         2536, 2029, 2535, 2030, 2537, 2780, 2605, 2134, 2604, 2900, 2899, 
         2331, 1952, 2778, 2478, 2692, 2691, 2249, 2671, 2672, 2470, 2471, 
         1941, 2328, 2356, 2357, 2296, 2034, 2347, 2252, 2931, 2932, 2761, 
         2762, 1940, 2346, 1939, 2469, 2468, 2667, 2666, 2019, 2660, 2661, 
         2462, 2757, 1936, 2326, 2465, 2464, 2463, 2160, 2662, 2248, 2659, 
         2159, 2461, 2755, 2756, 2344, 2457, 2456, 2454, 2158, 2653, 2015, 
         2279, 2152, 2374, 2153, 2643, 2108, 2649, 2155, 2610, 2154, 2645, 
         1929, 2635, 2150, 2622, 2151, 2637, 2143, 2632, 2149, 2616, 2629, 
         2627, 1844}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1843, 2626, 2628, 2615, 2631, 2630, 2142, 2636, 2638, 2621, 
         2634, 2633, 1928, 2644, 2646, 2609, 2648, 2647, 2107, 2642, 907, 
         2641, 2278, 2921, 2922, 2652, 2654, 629, 2658, 2655, 2657, 2656, 
         1932, 2923, 1167, 585, 1163, 38, 1172, 2668, 2161, 2669, 1175, 291, 
         1178, 2670, 2162, 2933, 1498, 53, 1550, 679, 1524, 283, 2945, 2944, 
         2946, 672, 1517, 68, 1211, 675, 1200, 321, 727, 2686, 2568, 2492, 
         1568, 915, 98, 998, 113, 1008, 128, 1017, 143, 1023, 158, 1028, 173, 
         1031, 188, 1034, 203, 1384, 218}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1889, 1910, 2734, 2733, 2838, 2837, 1887, 1909, 2237, 2099, 
         2985, 1886, 2272, 2882, 2818, 2819, 2815, 2817, 2816, 2880, 2518, 
         2519, 2517, 2581, 2580, 2877, 2513, 2514, 2512, 2579, 2578, 2872, 
         2873, 2509, 1992, 2798, 1991, 3020, 2577, 2084, 2505, 1983, 2397, 
         1982, 2504, 2076, 2498, 1975, 2389, 1974, 2497, 2069, 2569, 2571, 
         2570, 2385, 2383, 1969, 2491, 2595, 2890, 2891, 2594, 2607, 2606, 
         2746, 2748, 2747, 2960, 2211, 3024, 2940, 2941, 2360, 2210, 2361, 
         2209, 2260, 1959, 2935, 2176, 2772, 2773, 2774, 2348, 2771, 2770, 
         2769, 2215, 2962, 2032, 2244, 2243, 2359, 2021, 2280, 2051, 2490, 
         1962, 2418, 1961, 2546, 2033, 2466, 2665, 2929, 2930, 2759, 2760, 
         1938, 2345, 1937, 2758, 2467, 2664, 2663, 2225, 2590, 2591, 2589, 
         2889, 2888, 2325, 2750, 2749, 2433, 2139, 2613, 2247, 2651, 2157, 
         2448, 2450, 2451, 2343, 2754, 2753, 2447, 2156, 2650, 2223, 2224, 
         2375, 2373, 2109, 2588, 2106, 2612, 2137, 2608, 2136, 2611, 1927, 
         2920, 2146, 2620, 2147, 2625, 2141, 2619, 2144, 2614, 2618, 2617, 
         2673}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2103, 3007, 2104, 2417, 2416, 2006, 2525, 2710, 2415, 2414, 
         2413, 2523, 2522, 1882, 1907, 2727, 2726, 2814, 2813, 1877, 1903, 
         2095, 2879, 2096, 2270, 2269, 2876, 2803, 2804, 2801, 1996, 2802, 
         2089, 2508, 1990, 2797, 1989, 3019, 2576, 2082, 2869, 2083, 2870, 
         2398, 2396, 1981, 2503, 2704, 2391, 2390, 2388, 2496, 2495, 1856, 
         1897, 2232, 2068, 2367, 2368, 1855, 2264, 2303, 2907, 2908, 2906, 
         2910, 2909, 2135, 2918, 2919, 2916, 2140, 2917, 2214, 2601, 2131, 
         2600, 2132, 2694, 2208, 2693, 2207, 2242, 2241, 2358, 2133, 3025, 
         2330, 2430, 2998, 2431, 2428, 2429, 2419, 2532, 2744, 1912, 2533, 
         1911, 2238, 2018, 2422, 2423, 2424, 2548, 2547, 2258, 2912, 2913, 
         2911, 2915, 2914, 2138, 2696, 2213, 2695, 2212, 2961, 2291, 2292, 
         2120, 2449, 2119, 2598, 2168, 2453, 2452, 2446, 2543, 2542, 1956, 
         2538, 2539, 2432, 2556, 2994, 1931, 2557, 1930, 2284, 2285, 2334, 
         2333, 2245, 2623, 2624, 2436, 2438, 2439, 2335, 2435, 2434, 2674, 
         2145, 2338, 2472}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1942, 2337, 1943, 2764, 2763, 2163, 2250, 1933, 2675, 2165, 
         2596, 2112, 2437, 2113, 2283, 2282, 2031, 2849, 2851, 2850, 1946, 
         2290, 2127, 2895, 2128, 2298, 2297, 1916, 2554, 2036, 2553, 2037, 
         2167, 3010, 2166, 2117, 3008, 2118, 2016, 2531, 2017, 2842, 2011, 
         2840, 2010, 2841, 2844, 2843, 2274, 2275, 2050, 2565, 2049, 2858, 
         2301, 1921, 2426, 2427, 2593, 2592, 2381, 2382, 1847, 2366, 2262, 
         3026, 1963, 2329, 2230, 2860, 2057, 2859, 2056, 2783, 1965, 2782, 
         2785, 2784, 2863, 2263, 1853, 2970, 2067, 2231, 1896, 1854, 2701, 
         2494, 1973, 2386, 2387, 2075, 3004, 2074, 2792, 1980, 2791, 2794, 
         2793, 2868, 2268, 1869, 2979, 2088, 2235, 1900, 1870, 2800, 1995, 
         2720, 2721, 2093, 3005, 2092, 2809, 2000, 2808, 2811, 2810, 2878, 
         2271, 1880, 2982, 2097, 2236, 1906, 1881, 2827, 2828, 2730, 2731, 
         2732, 1885, 2984, 2098, 2004, 2835, 2005, 2836, 2887, 2886}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1868, 2087, 1988, 2081, 2977, 1865, 1898, 2234, 2080, 2976, 
         1864, 2267, 2072, 3003, 2073, 2233, 2071, 2972, 1860, 2266, 2864, 
         2865, 2788, 1968, 2787, 1967, 2063, 2969, 1850, 1893, 2061, 3001, 
         2062, 1964, 2055, 2968, 1849, 2229, 2228, 2054, 2967, 1848, 2261, 
         2047, 2999, 2048, 2380, 2379, 2489, 2488, 1845, 1892, 2856, 2857, 
         2562, 2564, 2563, 1918, 2420, 2421, 2365, 2479, 2371, 2372, 2529, 
         2012, 2988, 1914, 2035, 1915, 2989, 2013, 2111, 2164, 1925, 2992, 
         2026, 2028, 2846, 2848, 2847}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{-4, 4}, {0.1, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216817258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6459],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"CauchyDistribution", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "a", "]"}], "==", "0"}], ",", 
      RowBox[{"b", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22630],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287071783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4807],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CauchyDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CauchyDistribution"], "[", 
   RowBox[{"0", ",", "1"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->32035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9142],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122561571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "1", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->783361147]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->399901224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CauchyDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is nonreal:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22659],

Cell[BoxData[
 RowBox[{
  RowBox[{"CauchyDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->5376466],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20132819]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CauchyDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CauchyDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is non-positive:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->32651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"0", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32765],

Cell[BoxData[
 RowBox[{
  RowBox[{"CauchyDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->161829894],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"CauchyDistribution", "[", 
   RowBox[{"0", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195443233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4042],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"CauchyDistribution", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "I"}], ",", 
    RowBox[{"b", "->", "3"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23941],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"3", " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "9"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], "2"]}]}], 
    ")"}]}]]], "Output",
 ImageSize->{131, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312306785]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17022],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BetaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParetoDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParetoDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31088],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->19583125]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CauchyDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 14.9598758}", "context" -> "System`", 
    "keywords" -> {
     "Cauchy distribution", "CDF Cauchy", "mean Cauchy", "PDF Cauchy", 
      "standard deviation Cauchy"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CauchyDistribution[a, b] represents a Cauchy distribution with location \
parameter a and scale parameter b.", "synonyms" -> {"cauchy distribution"}, 
    "title" -> "CauchyDistribution", "type" -> "Symbol", "uri" -> 
    "ref/CauchyDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7466, 240, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->735593116]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 114505, 2457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2133, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2756, 81, 1583, 37, 70, "ObjectNameGrid"],
Cell[4342, 120, 746, 24, 70, "Usage",
 CellID->28053]
}, Open  ]],
Cell[CellGroupData[{
Cell[5125, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5603, 166, 605, 22, 70, "Notes",
 CellID->429991538],
Cell[6211, 190, 517, 17, 70, "Notes",
 CellID->14522],
Cell[6731, 209, 698, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7466, 240, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->735593116],
Cell[CellGroupData[{
Cell[7851, 254, 148, 5, 70, "ExampleSection",
 CellID->181737491],
Cell[8002, 261, 297, 8, 70, "ExampleText",
 CellID->14615],
Cell[CellGroupData[{
Cell[8324, 273, 165, 5, 28, "Input",
 CellID->22348],
Cell[8492, 280, 169, 5, 36, "Output",
 CellID->80303981]
}, Open  ]],
Cell[CellGroupData[{
Cell[8698, 290, 169, 5, 28, "Input",
 CellID->32179],
Cell[8870, 297, 169, 5, 36, "Output",
 CellID->56966510]
}, Open  ]],
Cell[9054, 305, 121, 3, 70, "ExampleDelimiter",
 CellID->16857],
Cell[9178, 310, 252, 6, 70, "ExampleText",
 CellID->2883],
Cell[CellGroupData[{
Cell[9455, 320, 188, 6, 70, "Input",
 CellID->1662],
Cell[9646, 328, 427, 15, 66, "Output",
 CellID->137226986]
}, Open  ]],
Cell[CellGroupData[{
Cell[10110, 348, 330, 11, 28, "Input",
 CellID->28262],
Cell[10443, 361, 3446, 61, 173, "Output",
 Evaluatable->False,
 CellID->486588460]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13938, 428, 216, 7, 70, "ExampleSection",
 CellID->19022],
Cell[14157, 437, 250, 7, 70, "ExampleText",
 CellID->9273],
Cell[CellGroupData[{
Cell[14432, 448, 196, 6, 70, "Input",
 CellID->25841],
Cell[14631, 456, 349, 10, 36, "Output",
 CellID->542283925]
}, Open  ]],
Cell[14995, 469, 121, 3, 70, "ExampleDelimiter",
 CellID->28888],
Cell[15119, 474, 219, 5, 70, "ExampleText",
 CellID->3917],
Cell[CellGroupData[{
Cell[15363, 483, 169, 5, 70, "Input",
 CellID->31717],
Cell[15535, 490, 170, 5, 36, "Output",
 CellID->348554633]
}, Open  ]],
Cell[CellGroupData[{
Cell[15742, 500, 169, 5, 70, "Input",
 CellID->13698],
Cell[15914, 507, 170, 5, 36, "Output",
 CellID->581795075]
}, Open  ]],
Cell[16099, 515, 120, 3, 70, "ExampleDelimiter",
 CellID->6932],
Cell[16222, 520, 374, 13, 70, "ExampleText",
 CellID->25619],
Cell[CellGroupData[{
Cell[16621, 537, 194, 6, 70, "Input",
 CellID->16081],
Cell[16818, 545, 367, 13, 51, "Output",
 CellID->475623771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17234, 564, 223, 7, 70, "ExampleSection",
 CellID->18631],
Cell[17460, 573, 249, 7, 70, "ExampleText",
 CellID->25428],
Cell[CellGroupData[{
Cell[17734, 584, 330, 11, 70, "Input",
 CellID->29681],
Cell[18067, 597, 2664, 48, 70, "Output",
 Evaluatable->False,
 CellID->63293422]
}, Open  ]],
Cell[20746, 648, 121, 3, 70, "ExampleDelimiter",
 CellID->26610],
Cell[20870, 653, 355, 13, 70, "ExampleText",
 CellID->26177],
Cell[CellGroupData[{
Cell[21250, 670, 408, 13, 70, "Input",
 CellID->31071],
Cell[21661, 685, 82785, 1386, 70, "Output",
 CellID->216817258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104495, 2077, 232, 7, 70, "ExampleSection",
 CellID->6459],
Cell[104730, 2086, 229, 5, 70, "ExampleText",
 CellID->23893],
Cell[CellGroupData[{
Cell[104984, 2095, 540, 17, 70, "Input",
 CellID->22630],
Cell[105527, 2114, 158, 5, 36, "Output",
 CellID->287071783]
}, Open  ]],
Cell[105700, 2122, 120, 3, 70, "ExampleDelimiter",
 CellID->4807],
Cell[105823, 2127, 518, 18, 70, "ExampleText",
 CellID->32035],
Cell[CellGroupData[{
Cell[106366, 2149, 188, 6, 70, "Input",
 CellID->9142],
Cell[106557, 2157, 281, 10, 57, "Output",
 CellID->122561571]
}, Open  ]],
Cell[CellGroupData[{
Cell[106875, 2172, 167, 6, 70, "Input",
 CellID->220],
Cell[107045, 2180, 281, 10, 57, "Output",
 CellID->783361147]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107375, 2196, 230, 7, 70, "ExampleSection",
 CellID->399901224],
Cell[107608, 2205, 425, 14, 70, "ExampleText",
 CellID->23661],
Cell[CellGroupData[{
Cell[108058, 2223, 190, 6, 70, "Input",
 CellID->22659],
Cell[108251, 2231, 209, 5, 70, "Message",
 CellID->5376466],
Cell[108463, 2238, 294, 9, 36, "Output",
 CellID->20132819]
}, Open  ]],
Cell[108772, 2250, 430, 14, 70, "ExampleText",
 CellID->32651],
Cell[CellGroupData[{
Cell[109227, 2268, 185, 6, 70, "Input",
 CellID->32765],
Cell[109415, 2276, 199, 5, 70, "Message",
 CellID->161829894],
Cell[109617, 2283, 278, 9, 36, "Output",
 CellID->195443233]
}, Open  ]],
Cell[109910, 2295, 120, 3, 70, "ExampleDelimiter",
 CellID->4042],
Cell[110033, 2300, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[110339, 2312, 320, 11, 70, "Input",
 CellID->23941],
Cell[110662, 2325, 443, 16, 60, "Output",
 CellID->312306785]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111166, 2348, 311, 9, 70, "SeeAlsoSection",
 CellID->17022],
Cell[111480, 2359, 755, 26, 70, "SeeAlso",
 CellID->7240]
}, Open  ]],
Cell[CellGroupData[{
Cell[112272, 2390, 314, 9, 70, "TutorialsSection",
 CellID->31088],
Cell[112589, 2401, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[112783, 2409, 299, 8, 70, "MoreAboutSection"],
Cell[113085, 2419, 183, 4, 70, "MoreAbout",
 CellID->19583125]
}, Open  ]],
Cell[113283, 2426, 27, 0, 70, "History"],
Cell[113313, 2428, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

