(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74540,       2272]
NotebookOptionsPosition[     64127,       1911]
NotebookOutlinePosition[     65489,       1949]
CellTagsIndexPosition[     65403,       1944]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Floor" :> Documentation`HelpLookup["paclet:ref/Floor"], 
          "IntegerPart" :> Documentation`HelpLookup["paclet:ref/IntegerPart"],
           "FractionalPart" :> 
          Documentation`HelpLookup["paclet:ref/FractionalPart"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "BinCounts" :> 
          Documentation`HelpLookup["paclet:ref/BinCounts"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Floor\"\>", 
       2->"\<\"IntegerPart\"\>", 3->"\<\"FractionalPart\"\>", 
       4->"\<\"Round\"\>", 5->"\<\"Chop\"\>", 6->"\<\"BinCounts\"\>", 
       7->"\<\"Quantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematics and Algorithms: New in 6.0" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematics and Algorithms: New in 6.0\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Ceiling ",
     StyleBox["(\[LeftCeiling]...\[RightCeiling])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ceiling",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ceiling"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the smallest integer greater than or equal to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ceiling",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ceiling"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the smallest multiple of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " greater than or equal to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"\[LeftCeiling]", 
   StyleBox["x", "TI"], "\[RightCeiling]"}]], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]lc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["x", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]rc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or \[LineSeparator]\[Backslash]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"[", "LeftCeiling", "]"}], 
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "RightCeiling", "]"}]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21434],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns an integer when ",
 Cell[BoxData[
  FormBox[
   StyleBox[Cell[TextData[Cell[BoxData[
     StyleBox["x", "TI"]], "InlineFormula"]], "InlineFormula"], "TI"], 
   TraditionalForm]], "InlineMath"],
 " is any numeric quantity, whether or not it is an explicit number. "
}], "Notes",
 CellID->6935],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " applies separately to real and imaginary parts of complex numbers."
}], "Notes",
 CellID->124085891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->360068154],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->444121970],

Cell["Round up to the nearest integer:", "ExampleText",
 CellID->9699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", "2.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19164],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100540755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", "2.6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14190],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198032732]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19879],

Cell["Round up to the nearest multiple of 10:", "ExampleText",
 CellID->12951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"226", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3613],

Cell[BoxData["230"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3701465]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25408],

Cell["Use exact numeric quantities:", "ExampleText",
 CellID->32646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"Pi", "^", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32147],

Cell[BoxData["8769956797"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58429340]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"Exp", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22894],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210101721]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11043],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.5", ",", "2.6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65668690]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839],

Cell[TextData[{
 "Round up to the nearest multiple of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->20520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{
   RowBox[{"99", 
    RowBox[{"Pi", "/", "5"}]}], ",", 
   RowBox[{"Pi", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->811],

Cell[BoxData[
 RowBox[{"20", " ", "\[Pi]"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178586996]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30346],

Cell[TextData[{
 "Manipulate ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->13294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", "x", "]"}], "+", 
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "+", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8298],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Ceiling", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54728399]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Ceiling", "[", "x", "]"}], "+", 
     RowBox[{"Ceiling", "[", 
      RowBox[{
       RowBox[{"2", "x"}], "+", "1"}], "]"}]}], "==", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14789],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
  RowBox[{"-", 
   FractionBox["1", "2"]}]}]], "Output",
 ImageSize->{73, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->481531341]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11955],

Cell["Evaluate an integral:", "ExampleText",
 CellID->2986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12788],

Cell[BoxData[
 RowBox[{"24", "-", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}], "-", 
  SqrtBox["3"], "-", 
  SqrtBox["5"], "-", 
  SqrtBox["6"], "-", 
  SqrtBox["7"]}]], "Output",
 ImageSize->{211, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->743654672]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42398020],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->649376612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ceiling", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->719165011],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftCeiling]", "n", "\[RightCeiling]"}], 
  TraditionalForm]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->64192081]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16874],

Cell["Evaluate for complex numbers:", "ExampleText",
 CellID->8702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"4", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21058],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415883179]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", 
     RowBox[{"3", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299348736]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474128397]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", " ", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVMEKwjAMjevm1Dm9iAheBP0D9eAP6MmPGEPQgyjq/9esS2dJoxuz0KUv
SZP0pd0xe51P1+x1ybPF4ZHdz5f8udjfHqhSHQDY4ZzPANcaV2butEbpfhV+
FZq6KCOUKWFFuJAB0ALKEeAyJEmGYos2w0SCqMK0bcS8+C6OAxvf0YVivpjh
cZNMXn3NcvUYbnQqMVf0lb8+w6kQs2An/H4OWetlGjA85D2gTEQGlBbbmQA+
t0eJ8eWbkBh6P14+9xMxWky5iipjlFPRa220tr5thVyfzQ+tHO8frX1ZCeMu
Ir21yz3iN27osce72BW6WB83par6jmwfJSaZtIrin7FXW5UiL9fKGee7Zab4
m16KXvakK+28RvqnQucN3ATVCA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820376164]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10188],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]lc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]rc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter a short notation for ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[LeftCeiling]", "x", "\[RightCeiling]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8294],

Cell[BoxData[
 RowBox[{"Ceiling", "[", "x", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1550036]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "+", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWV1oFFcUHnd2N6ltE39Ks0lLSVIFf/CnTQ0l0qRgN9ZaE0w0PgSRNQjJ
Q6vY9KV9sH1p3+uLgWIe+gP9eWipWAQLpQWpIAqlgrSCRBB9UATFh4Awfuee
M3tn7t6dmR13TaDL7p2593znu+eee+85d2Z3laYnD71Xmp6aKHVuP1o6Mjk1
8UHn4OGjaHKXOI5zCr9jBQf3Hu7U75Tn4VpZ5lG6ALTjmpUr1XvkWpD2gtRz
SuspKqnqqY/TFqijdDoMeY9RLxj4Fwx5httdEeOTwS9roJaLba7RvqJKu2lF
u1E3rWYrmlBS7y9GjMHGbrK1CQ97sDkGXSu7iXet8/Q8FVldj5+ptgoN+1z5
66hDRulfXzPq/vpiLwRX4rjBOxbRSqP7Wa2LvG3cpnUR8lrxqfk+/+z3Sxdv
OK4qUMfVVs8kkv/w/d+yeeL6X7T+SInXqy1qJ5frsycv6Dq5jr1m7ouWpHwh
K/pRZtBDh8G+L6WUPml1k0o3qNZ9e78deGMGX6eVCvfPP67JyDiOzM3dFXtY
vnPH7P378yQqBlggEq31Vn+il5s37/3/tLo9zj+5VNovB7ScxCzdqhVNEiea
VZzQrKsMFjOXlll/O3tV62MdiLwv0Mvh93+ZOPgjSqeZCvf4F+cEtdpgpd1M
Ub9VVb75+hLwWq+47Us7O/qm280WtspdqcdoZ1H+DWUw06PJeDbKWOyxJ067
19N5MBk6XR+N0uJWBAFEFnydPBW0XuJYQvj//r0t8lcCrKAAkUYhuwnKzopo
Jaw5hcdYJM6/GmaFgG4HDJYujyNkz4KgaRV015HzdQNt7ux6aq/wtSV75FR2
wNFG0Fs8HfmIpEvhfz19JYT/+KMzgl9XZqU++gN92852azyJcVgtdLs+pO37
9klovRnjtWjt7QuOfka1IrqHTpmYR9lHg9VYdg9/RdCswl/+55bIVwVYEdUl
ymdVlOcAQaKi+HqtJ7Hkw+nTGgdqPoaE2HQcetewaZOqw2Ysr8WjRePb3MA+
3vLs6zWZ9jYqInOhnYd703HXVUUqXmx+zaAj/UuBftB1qB82pXo/2udYayFN
nZ+Yf8TjuGR6b4uq65zI6FEDZY7JrrXHCzznx6LHBd1bVZqMo54obQ82qJz0
XFXo82AhgvPOnQehp9WZE+c5RXD2qdDq82e9oSga1dbH4Bj17DvPjh6xrtS0
eqTGeJ17XVXos/fKSCsHfG3J+88ltLK+erVZZ87LAqKwC3SenJ9/KPKWshaN
ik8FWP2S1zJqzyAG4cGHRK3WPlRER7RaVhcp2VGsQWfI49WVqTIzYfRwxbzH
vc+ph76TBQEf8pGCWmpg8r3h5HB24cyA6cAMOc+mtIfPV9h1nLo4w6bmQTzd
P/6d5hkSm33bzdl4W9WxvM7/dZ1unw7N+w4lhYv4gB2QBjkYhdMW3EC3S6ui
aN6iOEAAb2I3BDjIjp3K459+cnZq8ic+CtL7pCYr0zsKCw7OGBgaImIV7C5V
12eTfENQNIIhq9TfK+b/Embss3OrNdJURjGFENXAYL6FjHgKScZiewNLVaWd
xzLnfIMvTvaYSDcxS7A+prVq2idjZc8H98UB1Vr5b5az5BFSjjse\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199560297]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "  ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34838438]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Self\[Hyphen]counting sequence:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"8", "k"}], "+", "1"}], "]"}], "-", "1"}], ")"}], "/", "2"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "21"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", 
   ",", "4", ",", "4", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6"}], "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85269531]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Minimal number of elements in a box according to the pigeonhole principle:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"n", "/", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "False"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<boxes\>\"", ",", "\"\<elements\>\"", ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228241939]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21298],

Cell["Negative numbers round up to the nearest integer above:", "ExampleText",
 CellID->12232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.4"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "2.6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381546454]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32152],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiYgkGIPs/kAXG
W/7/B9LIZDCIZAbJgQFDHFZRZjR+BFgVRPTnzz9Ll5yfP+8MAz+IYD586D5U
lTGQYAFqYoLSLGSZYomkC0gysAJpEBeiOwhIMkFFMc3GL0ucLyNJFAXZF0mW
TmJFRcGi1VU78/M2AxEDH4hg7u05DFVlgOIKiOrbt96cP/cUiBj4QATzw4fv
kVTTwpX0CaHA//jSVhCSKANOVWqw8LS3nQlEDHwggjnQfzEwUYKkBHHYAUov
iJQYgibLhNUu4lSBfMXAghDF5z/c6Rt3OCJcTat4NgeLvn37FSXVXb3yAqqK
D6sucTRRWWjIQ1I40DSoOC/UDzB5BTR9IlhNk0NLDXIE5LGbyv8ftVSThNLo
pYcsGl8eh9/A+ROaSxF2K6GplkHjo7tNBk2/GJgGkUxkmCYL1YdqCtgHKKkS
PQRlMVTIo5iELUZgJjNDzQPxFbGGPK3Sqsd/bGkVqOrz558IVaDqFDMfouc8
NhLlSVU/2Oyj1Dxw+YeS+v9jySvofPT0ii4v/J966YX29TlcFNjyQbSAgIkQ
qsoNxS0CYFlgfY4hO1Lqa2ztNhAXUqcA8zG0XcQPrjWAzUqoOlOwbkI1MD+Y
D6ypUEoDRN1DnCn0qcfpmDYxRJnhNWR46DKUlhMw2KGqVQbQbaTrJK4/QJwq
XOncEMwHtr5xtIuE4bqR8wGszwPRDWzpo7T8S0u2QWsqiO7B1yeifXsTXdQJ
zAcGLrRM5QOXmsCyANqmZ4LrAoWFM1g1sM+JUgJDAhUkxYjHZkg/moERAOKQ
hqs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119705477]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21632],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->251461377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"x", "\[LessEqual]", "1"}]},
    {"2", 
     RowBox[{"1", "<", "x", "\[LessEqual]", 
      SqrtBox["2"]}]},
    {"3", 
     RowBox[{
      SqrtBox["2"], "<", "x", "\[LessEqual]", 
      SqrtBox["3"]}]},
    {"4", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{116, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->817024462]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "De\[Hyphen]nest ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->280823093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{"x", "+", 
     RowBox[{"1", "/", "3"}], "+", 
     RowBox[{
      RowBox[{"Ceiling", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "/", "2"}]}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV8tuEzEUdTIzmSYhrSgI8ShSJQSlEm1gU9iHh3h0U4kPiCqkdoGIShfZ
5ROyzCdkmU/oJ+QzsswnDH5cM+6d48HDqAhLM7avr+/xfY7neHh59u378PL8
dLj74WI4Ojs//bn7/seFJEUNIcSJfL7eF3KcyZF+TrJM9u47Uu94PB5f6bZa
rT7n9GgymWS6iZZ8RVLEFvVqPaG+KWggTGvKYSz7R1BSW8/Vacy8x+bRH+ZN
QnBpjyFSh3HdCkFKfs9JoTCslHTe/GuMxGuxFtyDkJRtYr8WBWodvCbhGUDd
iGJXlFy1YacCSlf1cY5StP+B1/6KSfk4lX0fcn35D6hHZJ27cPUN0/Y25HrN
uLZryDpyuJQH7tRAxBq7vnHjI8lM1D+Du3B86By+Fh84y5fL5UQ3LVLPaX2r
AlqPTtqmPs3yqiei9Xp9DUPOa2Ck1O+X2rBX0H+D9u1VwOwyT6CarDZhL2OZ
L5gMvNfqcRDEHRZ1YVzleXezNcDUsNlsNp/P1fDYoea8fTrhjrM6Go2m06ka
vmJaPoB4fcb1EHK9DJJ16HD5vxZhiNUrgyvzOdwdWiFsZpko91eGexCF1xeb
O50sz9uyWlBNqs1mrLFdLVaBVpDFOKqta9bu2+SPKveCJ0wm3ms9/ZRx42gJ
i6mbj89/Sx1kTkQVVt8xPWLI9ZZxJTVkDZh9WzUQscZKYkLxHBFCQvmPbgr4
BlNSBwpU/qXTmpfeJ0wt8leNBjxTyqT04GlsZbJ53XbmZTUFY24wTGwBa1u3
fvm/i9xe3VI90oI1rWb4m8xt3Qnymf3T8d1e7L8qjtcq0bIHJPtr2yb1+2yX
kxHxYrEwPpUBNIB8Hx1qnnWfIK/5hxeNX83D10I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{82, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374399179]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Reduce equations containing ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Ceiling", "[", 
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}]}], "]"}], " ", "==", " ", 
     RowBox[{"2", " ", 
      RowBox[{"Ceiling", "[", "x", "]"}]}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], " ", "<", " ", "x", " ", "<", " ", 
     RowBox[{"1", " ", 
      RowBox[{"{", "x", "}"}]}]}]}], ",", " ", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "&&", 
    RowBox[{
     RowBox[{"{", "0", "}"}], "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "<", "x", "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"{", "0", "}"}], "<", "0"}]}], ")"}]}]], "Output",
 ImageSize->{297, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520019892]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " function in the complex plane:"
}], "ExampleText",
 CellID->194005584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Ceiling", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295494130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160378217]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12615],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->30834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{
   RowBox[{"\[Pi]", "^", "2"}], "+", 
   RowBox[{"2", "\[Pi]"}], "+", "1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", "1"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15754],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ceiling", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Ceiling[\\(\\(1 + \\(\\(2\\\\ \[Pi]\\)\\) + \
\[Pi]\\^2 - \\((1 + \[Pi])\\)\\^2\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"Ceiling::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->25552210],

Cell[BoxData[
 RowBox[{"Ceiling", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[Pi]"}], "+", 
   SuperscriptBox["\[Pi]", "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Pi]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111864125]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28078],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168513985]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4140],

Cell[TextData[{
 "Convergence of the Fourier series of ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}], "+", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"2", "Pi", " ", "k", " ", "x"}], "]"}], "/", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", "o"}], "}"}]}], "]"}], "/", "Pi"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"o", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100833256]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24620],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26286],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->16405],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25231],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#4227"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/CeilingFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Ceiling/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->476829009],

Cell[TextData[ButtonBox["Mathematics and Algorithms: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->260824084],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->448500172]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ceiling (\[LeftCeiling]...\[RightCeiling]) - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 18.0849558}", "context" -> "System`", 
    "keywords" -> {"ceil", "least integer function", "round up", "roundup"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ceiling[x] gives the smallest integer greater than or equal to x. \
Ceiling[x, a] gives the smallest multiple of a greater than or equal to x. ", 
    "synonyms" -> {}, "title" -> "Ceiling", "type" -> "Symbol", "uri" -> 
    "ref/Ceiling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11994, 337, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->360068154]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65259, 1937}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2656, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3279, 87, 4289, 86, 70, "ObjectNameGrid"],
Cell[7571, 175, 1085, 35, 70, "Usage",
 CellID->32610]
}, Open  ]],
Cell[CellGroupData[{
Cell[8693, 215, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9171, 232, 124, 4, 70, "Notes",
 CellID->126685801],
Cell[9298, 238, 1239, 43, 70, "Notes",
 CellID->21434],
Cell[10540, 283, 487, 15, 70, "Notes",
 CellID->6935],
Cell[11030, 300, 482, 14, 70, "Notes",
 CellID->29570],
Cell[11515, 316, 236, 7, 70, "Notes",
 CellID->124085891],
Cell[11754, 325, 203, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[11994, 337, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->360068154],
Cell[CellGroupData[{
Cell[12379, 351, 148, 5, 70, "ExampleSection",
 CellID->444121970],
Cell[12530, 358, 70, 1, 70, "ExampleText",
 CellID->9699],
Cell[CellGroupData[{
Cell[12625, 363, 101, 3, 28, "Input",
 CellID->19164],
Cell[12729, 368, 158, 5, 36, "Output",
 CellID->100540755]
}, Open  ]],
Cell[CellGroupData[{
Cell[12924, 378, 101, 3, 28, "Input",
 CellID->14190],
Cell[13028, 383, 158, 5, 36, "Output",
 CellID->198032732]
}, Open  ]],
Cell[13201, 391, 121, 3, 70, "ExampleDelimiter",
 CellID->19879],
Cell[13325, 396, 78, 1, 70, "ExampleText",
 CellID->12951],
Cell[CellGroupData[{
Cell[13428, 401, 124, 4, 70, "Input",
 CellID->3613],
Cell[13555, 407, 158, 5, 36, "Output",
 CellID->3701465]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13762, 418, 216, 7, 70, "ExampleSection",
 CellID->25408],
Cell[13981, 427, 68, 1, 70, "ExampleText",
 CellID->32646],
Cell[CellGroupData[{
Cell[14074, 432, 124, 4, 70, "Input",
 CellID->32147],
Cell[14201, 438, 166, 5, 35, "Output",
 CellID->58429340]
}, Closed]],
Cell[CellGroupData[{
Cell[14404, 448, 130, 4, 70, "Input",
 CellID->22894],
Cell[14537, 454, 159, 5, 35, "Output",
 CellID->210101721]
}, Closed]],
Cell[14711, 462, 121, 3, 70, "ExampleDelimiter",
 CellID->11043],
Cell[14835, 467, 202, 7, 70, "ExampleText",
 CellID->764],
Cell[CellGroupData[{
Cell[15062, 478, 161, 5, 70, "Input",
 CellID->3635],
Cell[15226, 485, 212, 7, 35, "Output",
 CellID->65668690]
}, Closed]],
Cell[15453, 495, 119, 3, 70, "ExampleDelimiter",
 CellID->839],
Cell[15575, 500, 188, 7, 70, "ExampleText",
 CellID->20520],
Cell[CellGroupData[{
Cell[15788, 511, 191, 7, 70, "Input",
 CellID->811],
Cell[15982, 520, 185, 6, 35, "Output",
 CellID->178586996]
}, Closed]],
Cell[16182, 529, 121, 3, 70, "ExampleDelimiter",
 CellID->30346],
Cell[16306, 534, 201, 8, 70, "ExampleText",
 CellID->13294],
Cell[CellGroupData[{
Cell[16532, 546, 217, 7, 70, "Input",
 CellID->8298],
Cell[16752, 555, 238, 8, 35, "Output",
 CellID->54728399]
}, Closed]],
Cell[CellGroupData[{
Cell[17027, 568, 313, 11, 70, "Input",
 CellID->14789],
Cell[17343, 581, 259, 9, 50, "Output",
 CellID->481531341]
}, Closed]],
Cell[17617, 593, 121, 3, 70, "ExampleDelimiter",
 CellID->11955],
Cell[17741, 598, 59, 1, 70, "ExampleText",
 CellID->2986],
Cell[CellGroupData[{
Cell[17825, 603, 243, 8, 70, "Input",
 CellID->12788],
Cell[18071, 613, 306, 12, 37, "Output",
 CellID->743654672]
}, Closed]],
Cell[18392, 628, 124, 3, 70, "ExampleDelimiter",
 CellID->42398020],
Cell[18519, 633, 203, 7, 70, "ExampleText",
 CellID->649376612],
Cell[CellGroupData[{
Cell[18747, 644, 141, 4, 70, "Input",
 CellID->719165011],
Cell[18891, 650, 255, 8, 49, "Output",
 CellID->64192081]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19195, 664, 239, 7, 70, "ExampleSection",
 CellID->16874],
Cell[19437, 673, 67, 1, 70, "ExampleText",
 CellID->8702],
Cell[CellGroupData[{
Cell[19529, 678, 171, 6, 70, "Input",
 CellID->21058],
Cell[19703, 686, 215, 7, 35, "Output",
 CellID->415883179]
}, Closed]],
Cell[19933, 696, 105, 2, 70, "ExampleDelimiter"],
Cell[20041, 700, 200, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20266, 710, 219, 7, 70, "Input"],
Cell[20488, 719, 260, 9, 35, "Output",
 CellID->299348736]
}, Closed]],
Cell[20763, 731, 105, 2, 70, "ExampleDelimiter"],
Cell[20871, 735, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20960, 739, 90, 2, 70, "Input"],
Cell[21053, 743, 168, 5, 35, "Output",
 CellID->474128397]
}, Closed]],
Cell[21236, 751, 105, 2, 70, "ExampleDelimiter"],
Cell[21344, 755, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21409, 759, 345, 10, 70, "Input"],
Cell[21757, 771, 605, 14, 70, "Output",
 Evaluatable->False,
 CellID->820376164]
}, Closed]],
Cell[22377, 788, 121, 3, 70, "ExampleDelimiter",
 CellID->10188],
Cell[22501, 793, 456, 16, 70, "ExampleText",
 CellID->8198],
Cell[CellGroupData[{
Cell[22982, 813, 114, 3, 70, "Input",
 CellID->8294],
Cell[23099, 818, 189, 6, 35, "Output",
 CellID->1550036]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23337, 830, 223, 7, 70, "ExampleSection",
 CellID->20862],
Cell[CellGroupData[{
Cell[23585, 841, 269, 9, 70, "Input"],
Cell[23857, 852, 1851, 34, 70, "Output",
 Evaluatable->False,
 CellID->199560297]
}, Closed]],
Cell[25723, 889, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[25853, 895, 336, 11, 70, "Input"],
Cell[26192, 908, 5811, 99, 70, "Output",
 Evaluatable->False,
 CellID->34838438]
}, Closed]],
Cell[32018, 1010, 105, 2, 70, "ExampleDelimiter"],
Cell[32126, 1014, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[32205, 1018, 362, 13, 70, "Input"],
Cell[32570, 1033, 404, 10, 35, "Output",
 CellID->85269531]
}, Closed]],
Cell[32989, 1046, 105, 2, 70, "ExampleDelimiter"],
Cell[33097, 1050, 105, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[33227, 1056, 477, 14, 70, "Input"],
Cell[33707, 1072, 3486, 61, 70, "Output",
 Evaluatable->False,
 CellID->228241939]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37242, 1139, 233, 7, 70, "ExampleSection",
 CellID->21298],
Cell[37478, 1148, 94, 1, 70, "ExampleText",
 CellID->12232],
Cell[CellGroupData[{
Cell[37597, 1153, 222, 8, 70, "Input",
 CellID->22947],
Cell[37822, 1163, 270, 10, 35, "Output",
 CellID->381546454]
}, Closed]],
Cell[38107, 1176, 121, 3, 70, "ExampleDelimiter",
 CellID->16233],
Cell[CellGroupData[{
Cell[38253, 1183, 234, 8, 70, "Input",
 CellID->32152],
Cell[38490, 1193, 1071, 22, 70, "Output",
 Evaluatable->False,
 CellID->119705477]
}, Closed]],
Cell[39576, 1218, 121, 3, 70, "ExampleDelimiter",
 CellID->21632],
Cell[39700, 1223, 319, 13, 70, "ExampleText",
 CellID->251461377],
Cell[CellGroupData[{
Cell[40044, 1240, 223, 7, 70, "Input",
 CellID->1746],
Cell[40270, 1249, 1049, 34, 87, "Output",
 CellID->817024462]
}, Closed]],
Cell[41334, 1286, 105, 2, 70, "ExampleDelimiter"],
Cell[41442, 1290, 207, 8, 70, "ExampleText",
 CellID->280823093],
Cell[CellGroupData[{
Cell[41674, 1302, 450, 14, 70, "Input"],
Cell[42127, 1318, 1105, 22, 70, "Output",
 Evaluatable->False,
 CellID->374399179]
}, Closed]],
Cell[43247, 1343, 105, 2, 70, "ExampleDelimiter"],
Cell[43355, 1347, 189, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43569, 1358, 470, 14, 70, "Input"],
Cell[44042, 1374, 563, 20, 50, "Output",
 CellID->520019892]
}, Closed]],
Cell[44620, 1397, 105, 2, 70, "ExampleDelimiter"],
Cell[44728, 1401, 206, 7, 70, "ExampleText",
 CellID->194005584],
Cell[CellGroupData[{
Cell[44959, 1412, 420, 14, 70, "Input",
 CellID->295494130],
Cell[45382, 1428, 3486, 61, 70, "Output",
 Evaluatable->False,
 CellID->160378217]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[48917, 1495, 226, 7, 70, "ExampleSection",
 CellID->12615],
Cell[49146, 1504, 213, 7, 70, "ExampleText",
 CellID->30834],
Cell[CellGroupData[{
Cell[49384, 1515, 272, 9, 70, "Input",
 CellID->15754],
Cell[49659, 1526, 512, 9, 70, "Message",
 CellID->25552210],
Cell[50174, 1537, 372, 12, 39, "Output",
 CellID->111864125]
}, Closed]],
Cell[CellGroupData[{
Cell[50583, 1554, 100, 3, 70, "Input",
 CellID->28078],
Cell[50686, 1559, 158, 5, 35, "Output",
 CellID->168513985]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[50893, 1570, 223, 7, 70, "ExampleSection",
 CellID->4140],
Cell[51119, 1579, 199, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[51343, 1590, 700, 22, 70, "Input"],
Cell[52046, 1614, 7606, 129, 70, "Output",
 Evaluatable->False,
 CellID->100833256]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59713, 1750, 311, 9, 70, "SeeAlsoSection",
 CellID->24620],
Cell[60027, 1761, 1676, 62, 70, "SeeAlso",
 CellID->17173]
}, Open  ]],
Cell[CellGroupData[{
Cell[61740, 1828, 314, 9, 70, "TutorialsSection",
 CellID->26286],
Cell[62057, 1839, 148, 3, 70, "Tutorials",
 CellID->16405],
Cell[62208, 1844, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[62378, 1852, 321, 9, 70, "RelatedLinksSection",
 CellID->25231],
Cell[62702, 1863, 250, 5, 70, "RelatedLinks"],
Cell[62955, 1870, 186, 4, 70, "RelatedLinks"],
Cell[63144, 1876, 196, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63377, 1885, 319, 9, 70, "MoreAboutSection",
 CellID->476829009],
Cell[63699, 1896, 181, 3, 70, "MoreAbout",
 CellID->260824084],
Cell[63883, 1901, 149, 3, 70, "MoreAbout",
 CellID->448500172]
}, Open  ]],
Cell[64047, 1907, 50, 0, 70, "History"],
Cell[64100, 1909, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

