(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55079,       1775]
NotebookOptionsPosition[     45813,       1459]
NotebookOutlinePosition[     47402,       1505]
CellTagsIndexPosition[     47294,       1499]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cells as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CellsAsMathematicaExpressions"], 
          "The Structure of Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/TheStructureOfCells"], 
          "Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Cells as Mathematica Expressions\"\>", 
       2->"\<\"The Structure of Cells\"\>", 
       3->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpressionCell" :> 
          Documentation`HelpLookup["paclet:ref/ExpressionCell"], "TextCell" :> 
          Documentation`HelpLookup["paclet:ref/TextCell"], "CellGroup" :> 
          Documentation`HelpLookup["paclet:ref/CellGroup"], "Notebook" :> 
          Documentation`HelpLookup["paclet:ref/Notebook"], "CellPrint" :> 
          Documentation`HelpLookup["paclet:ref/CellPrint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpressionCell\"\>", 
       2->"\<\"TextCell\"\>", 3->"\<\"CellGroup\"\>", 4->"\<\"Notebook\"\>", 
       5->"\<\"CellPrint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Cell", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cell"], "[", 
       StyleBox["contents", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low-level representation of a cell inside a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cell"], "[", 
       RowBox[{
        StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a cell in the specified style."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks consist of lists of ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->28736],

Cell[TextData[{
 "You can see the form of a cell as an expression by using the ",
 StyleBox[ButtonBox["Show Expression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
 " menu command in the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Notes",
 CellID->27894],

Cell[TextData[{
 "You can access cells in a notebook directly using the front end. You can \
also access the cells from the kernel using ",
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ", or using ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSelection"], "[", 
   StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12310],

Cell["The contents of cells can be the following: ", "Notes",
 CellID->8419],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell["plain text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"TextData", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["text", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["text", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "general text objects ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"BoxData", "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "formatted ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expressions "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"OutputFormData", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"itext\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"otext\", \"TI\"]\)\>\""}], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "text as generated by ",
     Cell[BoxData[
      ButtonBox["OutputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"RawData", "[", "\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\"", "]"}], Cell[
    "unformatted expressions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"GraphicsData", "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
      StyleBox["data", "TI"]}], "]"}], Cell[
    "non-expression graphics or sound data", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox[
     RowBox[{"CellGroupData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], "2"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["status", "TI"]}], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[
    "group of cells ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"StyleData", "[", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[
    "sample cell for a particular style ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, False, True, True, True, False, True, True}}}},
 CellID->11810],

Cell[TextData[{
 "In any given notebook, a collection of possible cell styles are defined, \
typically with names such as ",
 Cell[BoxData["\"\<Title\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Input\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31969],

Cell["Cells can have many options, including: ", "Notes",
 CellID->11489],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], Cell[
    "the color of the background for the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellFrame"], Cell[
    "whether to draw a frame around the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], Cell[
    "tags for the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], Cell[
    "whether to allow the contents of the cell to be edited ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FontSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSize"], Cell[
    "the default size of text in the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TextAlignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TextAlignment"], Cell[
    "how to align text in the cell ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->2334]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->150904418],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->594765920],

Cell["Create a text cell from a low-level description:", "ExampleText",
 CellID->109525024],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279846818],

Cell["abc", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->635061750],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11651763],

Cell["Create an expression cell from a low-level description:", "ExampleText",
 CellID->178159775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}], ",", 
    "\"\<Output\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350432620],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35504161]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->801683908],

Cell["Cells can contain complex typeset forms:", "ExampleText",
 CellID->277184668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ToBoxes", "[", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"1", "+", 
          RowBox[{"Abs", "[", "x", "]"}]}], "]"}], ",", "x", ",", 
        RowBox[{"Assumptions", "\[Rule]", 
         RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}], "]"}], "]"}], ",", 
    "\"\<Output\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136427182],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwhAKxqQQDkP0fyALj
0P//gTSEVAGSzEBBPTCPGUSyVFRU7AeD58+fy4JEQAr+gwGyOub6+nqoqDya
Kl0KVMkhqWJAdRnJZvljFWUFEkxArUxQmh3NLHlomID0sUJpkDqIQRAA0ssC
pTFtYAOHI8JEBgYONDsU0PjMBPgw9yKLsWC1mx3JVyDXs4LlgbEJdTk72CcO
Dg5Q9XzEuIQVzocGAWlu4STH91jtZKVymINcx4Lbh9hFCaYoAQy3iKHZDVMJ
DTgGiAyyGSA7YKkQ00YZqCoRDJvQY0aEoH52mPswVEljmG6AVZ0C1K06OGWR
XYRdlSKaKm0KVCHbyIDTXcSZBSlDIKE6ffr05cuXg5gBSKIItciiBQUF/f39
CFHiyibsonL/MUppHCUmiDkcy2h1ND5InhVayuHOJZhlgiaGCBeaK/GUBhSX
tbz/EeUhvOYh0S5tJL3wspVIM4gJDw4y3Ea4/BNGU4FeI5AS6rCyS4sMPaDQ
w51eBkl5x7J+/fp6MDh//jy6aRB1akiiiBJOHataSEuPgREA7mlviA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191209239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->475331649],

Cell["Cells can contain graphics:", "ExampleText",
 CellID->271439621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ToBoxes", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
    "\"\<Output\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36208140],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378420282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178925889],

Cell["Cells can contain interactive controls:", "ExampleText",
 CellID->456364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ToBoxes", "[", 
      RowBox[{"Slider", "[", "]"}], "]"}], "]"}], ",", "\"\<Output\>\""}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17802370],

Cell[BoxData[
 SliderBox[0.616]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123759978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62951997],

Cell["Cells can contain other cells:", "ExampleText",
 CellID->148150785],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<the \>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{"BoxData", "[", "\"\<x\>\"", "]"}], "]"}], ",", " ", 
       "\"\< factor\>\""}], "}"}], "]"}], ",", "\"\<Text\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16555377],

Cell[TextData[{
 "the ",
 Cell[BoxData["x"]],
 " factor"
}], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->166526826]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->591556768],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellFrame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12901568],

Cell["Put a frame around a cell:", "ExampleText",
 CellID->137778585],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98682842],

Cell["abc", "Text",
 CellFrame->True,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->53545442],

Cell["Specify a width for the frame:", "ExampleText",
 CellID->126028335],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellFrame", "\[Rule]", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->725124154],

Cell["abc", "Text",
 CellFrame->5,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->896883011]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellFrameColor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->352023373],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"CellFrame", "\[Rule]", "5"}], ",", 
      RowBox[{"CellFrameColor", "\[Rule]", "c"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713895446],

Cell["abc", "Text",
 CellFrame->5,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellFrameColor->RGBColor[1, 0, 0],
 CellID->25559189],

Cell["abc", "Text",
 CellFrame->5,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellFrameColor->RGBColor[0, 1, 0],
 CellID->44914659],

Cell["abc", "Text",
 CellFrame->5,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellFrameColor->RGBColor[0, 0, 1],
 CellID->889547392]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellFrameLabels",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->123726699],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"CellFrameLabels", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<L\>\"", ",", "\"\<R\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<B\>\"", ",", "\"\<T\>\""}], "}"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->636577874],

Cell["abc", "Text",
 CellFrame->True,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellFrameLabels->{{"L", "R"}, {"B", "T"}},
 CellID->358713708],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->881773041],

Cell["Cell frame labels can be displayed without a frame:", "ExampleText",
 CellID->338310593],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellFrame", "\[Rule]", "False"}], ",", 
    RowBox[{"CellFrameLabels", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<L\>\"", ",", "\"\<R\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<B\>\"", ",", "\"\<T\>\""}], "}"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98328574],

Cell["abc", "Text",
 CellFrame->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellFrameLabels->{{"L", "R"}, {"B", "T"}},
 CellID->74786556]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellTags",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->172165790],

Cell["\<\
Use a cell tag to locate a particular cell by referring to the tag:\
\>", "ExampleText",
 CellID->860057424],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<text\>\"", ",", 
    RowBox[{"CellTags", "\[Rule]", 
     RowBox[{"{", "\"\<C1\>\"", "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92144052],

Cell["text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellTags->"C1",
 CellID->72909651],

Cell[BoxData[
 RowBox[{"NotebookLocate", "[", "\"\<C1\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156789187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookFind",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookFind"]], "InlineFormula"],
 " can also be used:"
}], "ExampleText",
 CellID->105572418],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{
    RowBox[{"InputNotebook", "[", "]"}], ",", "\"\<C1\>\"", ",", "Next", ",", 
    "CellTags"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->97469946]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->42912256],

Cell[TextData[{
 "By default cells are editable; set ",
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to disable this behavior:"
}], "ExampleText",
 CellID->371801945],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<not editable\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520061112],

Cell["not editable", "Text",
 Editable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->31839987]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontColor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->236821542],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<text text\>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"FontColor", "\[Rule]", "c"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174514373],

Cell["text text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[1, 0, 0],
 CellID->68334708],

Cell["text text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 1, 0],
 CellID->60438096],

Cell["text text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 0, 1],
 CellID->886650576]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->66223469],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<text\>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "s"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "24", ",", "36"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->89416534],

Cell["text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontSize->12,
 CellID->504473388],

Cell["text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontSize->24,
 CellID->91783],

Cell["text", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontSize->36,
 CellID->452565122]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Hyphenation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->645721],

Cell["Define some text: ", "ExampleText",
 CellID->469712985],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "text", "=", 
   "\"\<Advanced experimentation with counterintuitively organized automatic \
aeronautically optimized mechanical anisotropic intermediaries\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14525340],

Cell["The same text with and without hyphenation: ", "ExampleText",
 CellID->461424675],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"text", ",", "\"\<Text\>\"", ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"200", ",", "250"}], "}"}], ",", "Inherited"}], "}"}]}], 
      ",", 
      RowBox[{"Hyphenation", "\[Rule]", "h"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->471889460],

Cell["\<\
Advanced experimentation with counterintuitively organized automatic \
aeronautically optimized mechanical anisotropic intermediaries\
\>", "Text",
 CellMargins->{{200, 250}, Inherited},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Hyphenation->True,
 CellID->68943171],

Cell["\<\
Advanced experimentation with counterintuitively organized automatic \
aeronautically optimized mechanical anisotropic intermediaries\
\>", "Text",
 CellMargins->{{200, 250}, Inherited},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Hyphenation->False,
 CellID->16642037]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ShowCellBracket",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->593088018],

Cell["Cells with and without a cell bracket:", "ExampleText",
 CellID->269377467],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<text text text\>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"ShowCellBracket", "\[Rule]", "cb"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"cb", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14695124],

Cell["text text text", "Text",
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->224666858],

Cell["text text text", "Text",
 ShowCellBracket->True,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->881177119]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->429391941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " creates notebook windows from low-level ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->136655216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", "\"\<first\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<last\>\"", "]"}]}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486382510],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndtPlEcYxml63/gv9F/p4VZT05u2SRVTUdsY06Z3TXphqrZSm+IBPKJS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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->61984204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80670894],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TVFUcx2l63/Qv9K/08K7RqXxTzSQ4iVbTODW9a6YXTWZFNZoK4gMm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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->913006234]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression for the selected cell:"
}], "ExampleText",
 CellID->166298379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->276118209],

Cell[BoxData[
 RowBox[{"Cell", "[", "\<\"first\"\>", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16647163]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13067],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpressionCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11485],

Cell[TextData[{
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"]
}], "Tutorials",
 CellID->24747],

Cell[TextData[ButtonBox["The Structure of Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfCells"]], "Tutorials",
 CellID->20178],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->416006050]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->653127140],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->378237474]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 41.6168082}", "context" -> "System`", 
    "keywords" -> {
     "notebook content", "notebook cell structure", 
      "fundamental notebook element", "notebook cell", 
      "low-level notebook representation", "BoxData", "TextData", 
      "StyleData"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Cell[contents] is the low-level representation of a cell inside a \
Mathematica notebook. Cell[contents, \" style\"] represents a cell in the \
specified style.", "synonyms" -> {}, "title" -> "Cell", "type" -> "Symbol", 
    "uri" -> "ref/Cell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15735, 430, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->150904418]},
 "C1"->{
  Cell[28526, 881, 96, 4, 70, InheritFromParent,
   CellTags->"C1",
   CellID->72909651]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47050, 1488},
 {"C1", 47180, 1492}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2726, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3349, 89, 4188, 83, 70, "ObjectNameGrid"],
Cell[7540, 174, 940, 29, 70, "Usage",
 CellID->20734]
}, Open  ]],
Cell[CellGroupData[{
Cell[8517, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8995, 225, 254, 10, 70, "Notes",
 CellID->28736],
Cell[9252, 237, 336, 10, 70, "Notes",
 CellID->27894],
Cell[9591, 249, 905, 31, 70, "Notes",
 CellID->12310],
Cell[10499, 282, 76, 1, 70, "Notes",
 CellID->8419],
Cell[10578, 285, 3039, 81, 70, "2ColumnTableMod",
 CellID->11810],
Cell[13620, 368, 386, 12, 70, "Notes",
 CellID->31969],
Cell[14009, 382, 73, 1, 70, "Notes",
 CellID->11489],
Cell[14085, 385, 1613, 40, 70, "2ColumnTableMod",
 CellID->2334]
}, Closed]],
Cell[CellGroupData[{
Cell[15735, 430, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->150904418],
Cell[CellGroupData[{
Cell[16120, 444, 148, 5, 70, "ExampleSection",
 CellID->594765920],
Cell[16271, 451, 91, 1, 70, "ExampleText",
 CellID->109525024],
Cell[16365, 454, 181, 5, 70, "Input",
 CellID->279846818],
Cell[16549, 461, 87, 3, 70, "Text",
 CellID->635061750],
Cell[16639, 466, 124, 3, 70, "ExampleDelimiter",
 CellID->11651763],
Cell[16766, 471, 98, 1, 70, "ExampleText",
 CellID->178159775],
Cell[CellGroupData[{
Cell[16889, 476, 301, 9, 70, "Input",
 CellID->350432620],
Cell[17193, 487, 180, 6, 36, "Output",
 CellID->35504161]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17422, 499, 220, 7, 70, "ExampleSection",
 CellID->801683908],
Cell[17645, 508, 83, 1, 70, "ExampleText",
 CellID->277184668],
Cell[CellGroupData[{
Cell[17753, 513, 521, 15, 70, "Input",
 CellID->136427182],
Cell[18277, 530, 816, 17, 70, "Output",
 Evaluatable->False,
 CellID->191209239]
}, Open  ]],
Cell[19108, 550, 125, 3, 70, "ExampleDelimiter",
 CellID->475331649],
Cell[19236, 555, 70, 1, 70, "ExampleText",
 CellID->271439621],
Cell[CellGroupData[{
Cell[19331, 560, 444, 14, 70, "Input",
 CellID->36208140],
Cell[19778, 576, 2356, 43, 70, "Output",
 Evaluatable->False,
 CellID->378420282]
}, Open  ]],
Cell[22149, 622, 125, 3, 70, "ExampleDelimiter",
 CellID->178925889],
Cell[22277, 627, 79, 1, 70, "ExampleText",
 CellID->456364],
Cell[CellGroupData[{
Cell[22381, 632, 281, 9, 70, "Input",
 CellID->17802370],
Cell[22665, 643, 174, 6, 70, "Output",
 CellID->123759978]
}, Open  ]],
Cell[22854, 652, 124, 3, 70, "ExampleDelimiter",
 CellID->62951997],
Cell[22981, 657, 73, 1, 70, "ExampleText",
 CellID->148150785],
Cell[23057, 660, 400, 12, 70, "Input",
 CellID->16555377],
Cell[23460, 674, 136, 7, 70, "Text",
 CellID->166526826]
}, Closed]],
Cell[CellGroupData[{
Cell[23633, 686, 222, 7, 70, "ExampleSection",
 CellID->591556768],
Cell[CellGroupData[{
Cell[23880, 697, 229, 7, 70, "ExampleSubsection",
 CellID->12901568],
Cell[24112, 706, 69, 1, 70, "ExampleText",
 CellID->137778585],
Cell[24184, 709, 232, 6, 70, "Input",
 CellID->98682842],
Cell[24419, 717, 104, 4, 70, "Text",
 CellID->53545442],
Cell[24526, 723, 73, 1, 70, "ExampleText",
 CellID->126028335],
Cell[24602, 726, 230, 6, 70, "Input",
 CellID->725124154],
Cell[24835, 734, 102, 4, 70, "Text",
 CellID->896883011]
}, Closed]],
Cell[CellGroupData[{
Cell[24974, 743, 235, 7, 70, "ExampleSubsection",
 CellID->352023373],
Cell[25212, 752, 469, 14, 70, "Input",
 CellID->713895446],
Cell[25684, 768, 137, 5, 70, "Text",
 CellID->25559189],
Cell[25824, 775, 137, 5, 70, "Text",
 CellID->44914659],
Cell[25964, 782, 138, 5, 70, "Text",
 CellID->889547392]
}, Closed]],
Cell[CellGroupData[{
Cell[26139, 792, 236, 7, 70, "ExampleSubsection",
 CellID->123726699],
Cell[26378, 801, 490, 14, 70, "Input",
 CellID->636577874],
Cell[26871, 817, 149, 5, 70, "Text",
 CellID->358713708],
Cell[27023, 824, 125, 3, 70, "ExampleDelimiter",
 CellID->881773041],
Cell[27151, 829, 94, 1, 70, "ExampleText",
 CellID->338310593],
Cell[27248, 832, 490, 14, 70, "Input",
 CellID->98328574],
Cell[27741, 848, 149, 5, 70, "Text",
 CellID->74786556]
}, Closed]],
Cell[CellGroupData[{
Cell[27927, 858, 229, 7, 70, "ExampleSubsection",
 CellID->172165790],
Cell[28159, 867, 118, 3, 70, "ExampleText",
 CellID->860057424],
Cell[28280, 872, 243, 7, 70, "Input",
 CellID->92144052],
Cell[28526, 881, 96, 4, 70, InheritFromParent,
 CellTags->"C1",
 CellID->72909651],
Cell[28625, 887, 119, 3, 70, "Input",
 CellID->156789187],
Cell[28747, 892, 203, 7, 70, "ExampleText",
 CellID->105572418],
Cell[28953, 901, 230, 7, 70, "Input",
 CellID->97469946]
}, Closed]],
Cell[CellGroupData[{
Cell[29220, 913, 228, 7, 70, "ExampleSubsection",
 CellID->42912256],
Cell[29451, 922, 365, 13, 70, "ExampleText",
 CellID->371801945],
Cell[29819, 937, 242, 6, 70, "Input",
 CellID->520061112],
Cell[30064, 945, 113, 4, 70, "Text",
 CellID->31839987]
}, Closed]],
Cell[CellGroupData[{
Cell[30214, 954, 230, 7, 70, "ExampleSubsection",
 CellID->236821542],
Cell[30447, 963, 419, 13, 70, "Input",
 CellID->174514373],
Cell[30869, 978, 123, 4, 70, "Text",
 CellID->68334708],
Cell[30995, 984, 123, 4, 70, "Text",
 CellID->60438096],
Cell[31121, 990, 124, 4, 70, "Text",
 CellID->886650576]
}, Closed]],
Cell[CellGroupData[{
Cell[31282, 999, 228, 7, 70, "ExampleSubsection",
 CellID->66223469],
Cell[31513, 1008, 405, 13, 70, "Input",
 CellID->89416534],
Cell[31921, 1023, 103, 4, 70, "Text",
 CellID->504473388],
Cell[32027, 1029, 99, 4, 70, "Text",
 CellID->91783],
Cell[32129, 1035, 103, 4, 70, "Text",
 CellID->452565122]
}, Closed]],
Cell[CellGroupData[{
Cell[32269, 1044, 229, 7, 70, "ExampleSubsection",
 CellID->645721],
Cell[32501, 1053, 61, 1, 70, "ExampleText",
 CellID->469712985],
Cell[32565, 1056, 262, 8, 70, "Input",
 CellID->14525340],
Cell[32830, 1066, 87, 1, 70, "ExampleText",
 CellID->461424675],
Cell[32920, 1069, 583, 18, 70, "Input",
 CellID->471889460],
Cell[33506, 1089, 283, 8, 70, "Text",
 CellID->68943171],
Cell[33792, 1099, 284, 8, 70, "Text",
 CellID->16642037]
}, Closed]],
Cell[CellGroupData[{
Cell[34113, 1112, 236, 7, 70, "ExampleSubsection",
 CellID->593088018],
Cell[34352, 1121, 81, 1, 70, "ExampleText",
 CellID->269377467],
Cell[34436, 1124, 416, 12, 70, "Input",
 CellID->14695124],
Cell[34855, 1138, 123, 4, 70, "Text",
 CellID->224666858],
Cell[34981, 1144, 122, 4, 70, "Text",
 CellID->881177119]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35152, 1154, 237, 7, 70, "ExampleSection",
 CellID->429391941],
Cell[35392, 1163, 482, 17, 70, "ExampleText",
 CellID->136655216],
Cell[CellGroupData[{
Cell[35899, 1184, 338, 11, 70, "Input",
 CellID->486382510],
Cell[36240, 1197, 2588, 45, 70, "NotebookImage",
 CellID->61984204]
}, Open  ]],
Cell[CellGroupData[{
Cell[38865, 1247, 148, 4, 70, "Input",
 CellID->80670894],
Cell[39016, 1253, 2682, 46, 70, "NotebookImage",
 CellID->913006234]
}, Open  ]],
Cell[41713, 1302, 346, 12, 70, "ExampleText",
 CellID->166298379],
Cell[CellGroupData[{
Cell[42084, 1318, 109, 3, 70, "Input",
 CellID->276118209],
Cell[42196, 1323, 199, 6, 36, "Output",
 CellID->16647163]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42456, 1336, 311, 9, 70, "SeeAlsoSection",
 CellID->13067],
Cell[42770, 1347, 1201, 44, 70, "SeeAlso",
 CellID->4952]
}, Open  ]],
Cell[CellGroupData[{
Cell[44008, 1396, 314, 9, 70, "TutorialsSection",
 CellID->11485],
Cell[44325, 1407, 412, 12, 70, "Tutorials",
 CellID->24747],
Cell[44740, 1421, 152, 3, 70, "Tutorials",
 CellID->20178],
Cell[44895, 1426, 147, 3, 70, "Tutorials",
 CellID->416006050]
}, Open  ]],
Cell[CellGroupData[{
Cell[45079, 1434, 299, 8, 70, "MoreAboutSection"],
Cell[45381, 1444, 169, 3, 70, "MoreAbout",
 CellID->653127140],
Cell[45553, 1449, 165, 3, 70, "MoreAbout",
 CellID->378237474]
}, Open  ]],
Cell[45733, 1455, 50, 0, 70, "History"],
Cell[45786, 1457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

