(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12297,        425]
NotebookOptionsPosition[      9572,        339]
NotebookOutlinePosition[     11017,        378]
CellTagsIndexPosition[     10932,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellMargins" :> 
          Documentation`HelpLookup["paclet:ref/CellMargins"], 
          "BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"], 
          "AlignmentPoint" :> 
          Documentation`HelpLookup["paclet:ref/AlignmentPoint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellMargins\"\>", 
       2->"\<\"BaselinePosition\"\>", 
       3->"\<\"AlignmentPoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellBaseline", "ObjectName",
 CellID->2081],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellBaseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellBaseline"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies where the baseline of the cell should be assumed to be \
when it appears inside another cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellBaseline",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellBaseline"]], "InlineFormula"],
 " is used to determine the vertical alignment of cells that are embedded in \
text, typically in ",
 Cell[BoxData["TextData"], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11002],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CellBaseline", "->", 
   StyleBox["pos", "TI"]}]], "InlineFormula"],
 " specifies that position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " in the ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " should be assumed to be the baseline of the ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " and should therefore be aligned with baselines of other boxes. "
}], "Notes",
 CellID->13927],

Cell["Possible settings are: ", "Notes",
 CellID->8287],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the expression in the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the expression in the cell (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of the expression in the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "center of the expression in the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "top of the expression in the cell ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->15786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194708594],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->458242846],

Cell[TextData[{
 "Put some expressions into a line of text with various choices of ",
 Cell[BoxData[
  ButtonBox["CellBaseline",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellBaseline"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->289916098],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"Riffle", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"ExpressionCell", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "2"}], "/", 
            RowBox[{"(", 
             RowBox[{"y", "-", "1"}], ")"}]}], ",", 
           RowBox[{"CellBaseline", "\[Rule]", "b"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"b", ",", 
           RowBox[{"{", 
            RowBox[{"Baseline", ",", "Bottom", ",", "Center", ",", "Top"}], 
            "}"}]}], "}"}]}], "]"}], ",", "\"\< text \>\""}], "]"}], "]"}], 
    ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320477587],

Cell[TextData[{
 Cell[BoxData[
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}]]],
  CellBaseline->Baseline],
 " text ",
 Cell[BoxData[
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}]]],
  CellBaseline->Bottom],
 " text ",
 Cell[BoxData[
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}]]],
  CellBaseline->Center],
 " text ",
 Cell[BoxData[
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}]]],
  CellBaseline->Top]
}], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->120740224]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlignmentPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlignmentPoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30584]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5218],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->992]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellBaseline - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 20.8662770}", "context" -> "System`", 
    "keywords" -> {
     "inline cells", "baseline", "baseline position", "typestting alignment", 
      "text alignment", "vertical position", "baseline alignment"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CellBaseline is an option for Cell which specifies where the baseline of \
the cell should be assumed to be when it appears inside another cell. ", 
    "synonyms" -> {"cell baseline"}, "title" -> "CellBaseline", "type" -> 
    "Symbol", "uri" -> "ref/CellBaseline"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5658, 183, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194708594]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10789, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1426, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2049, 63, 49, 1, 70, "ObjectName",
 CellID->2081],
Cell[2101, 66, 655, 19, 70, "Usage",
 CellID->31136]
}, Open  ]],
Cell[CellGroupData[{
Cell[2793, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3271, 107, 331, 10, 70, "Notes",
 CellID->11002],
Cell[3605, 119, 581, 19, 70, "Notes",
 CellID->13927],
Cell[4189, 140, 55, 1, 70, "Notes",
 CellID->8287],
Cell[4247, 143, 1374, 35, 70, "2ColumnTableMod",
 CellID->15786]
}, Closed]],
Cell[CellGroupData[{
Cell[5658, 183, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194708594],
Cell[CellGroupData[{
Cell[6043, 197, 148, 5, 70, "ExampleSection",
 CellID->458242846],
Cell[6194, 204, 256, 8, 70, "ExampleText",
 CellID->289916098],
Cell[6453, 214, 792, 23, 70, "Input",
 CellID->320477587],
Cell[7248, 239, 666, 31, 70, "Text",
 CellID->120740224]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7963, 276, 310, 9, 70, "SeeAlsoSection",
 CellID->7085],
Cell[8276, 287, 730, 26, 70, "SeeAlso",
 CellID->30584]
}, Open  ]],
Cell[CellGroupData[{
Cell[9043, 318, 313, 9, 70, "TutorialsSection",
 CellID->5218],
Cell[9359, 329, 141, 3, 70, "Tutorials",
 CellID->992]
}, Open  ]],
Cell[9515, 335, 27, 0, 70, "History"],
Cell[9545, 337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

