(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38020,       1061]
NotebookOptionsPosition[     33409,        913]
NotebookOutlinePosition[     35043,        955]
CellTagsIndexPosition[     34958,        950]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpressionCell" :> 
          Documentation`HelpLookup["paclet:ref/ExpressionCell"], "TextCell" :> 
          Documentation`HelpLookup["paclet:ref/TextCell"], "CellPrint" :> 
          Documentation`HelpLookup["paclet:ref/CellPrint"], "ShowGroupOpener" :> 
          Documentation`HelpLookup["paclet:ref/ShowGroupOpener"], 
          "OpenerView" :> Documentation`HelpLookup["paclet:ref/OpenerView"], 
          "CellGrouping" :> 
          Documentation`HelpLookup["paclet:ref/CellGrouping"], 
          "CellGroupData" :> 
          Documentation`HelpLookup["paclet:ref/CellGroupData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpressionCell\"\>", 
       2->"\<\"TextCell\"\>", 3->"\<\"CellPrint\"\>", 
       4->"\<\"ShowGroupOpener\"\>", 5->"\<\"OpenerView\"\>", 
       6->"\<\"CellGrouping\"\>", 
       7->"\<\"CellGroupData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controlling Cell Grouping" :> 
          Documentation`HelpLookup["paclet:guide/ControllingCellGrouping"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Controlling Cell Grouping\"\>", 
       2->"\<\"Document Generation\"\>", 
       3->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CellGroup", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroup"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an open group of cells that can appear in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroup"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "1"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives a cell group in which only the first cell is \
open."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroup"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a cell group in which only the last cell is \
open."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroup"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a cell group in which cells ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]  are open. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cell", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have heads ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27127],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 " object can be inserted in its entirety into a notebook using ",
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9259],

Cell[TextData[{
 "Cell grouping specified by ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 " will be overridden by automatic grouping in a notebook unless ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"], "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 " is set. "
}], "Notes",
 CellID->17419],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"], "[", 
   RowBox[{
    StyleBox["cells", "TI"], ",", 
    StyleBox["status", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["status", "TI"]], "InlineFormula"],
 " can contain ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17509],

Cell[TextData[{
 "If any ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["cell", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a string or ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " object, it will be wrapped with ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 ". If it is any other type of expression, it will be wrapped with ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->276]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334606197],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->151659454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"CellGroup", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77254257],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+ld6uNVoetOaVDAFtI0xNr1o0qQXpmortSkeQBRQ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   "], {{0, 0}, {458, 81}}, {0, 255}],
  ImageSize->{458 0.75, 81 0.75},
  PlotRange->{{0, 458}, {0, 81}}]], "NotebookImage",
 CellID->425384467]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->821577873],

Cell["You can nest one cell group within another:", "ExampleText",
 CellID->18368235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"CellGroup", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{"b", ",", "c"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524496204],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PFFccxnGa3jf+C/1X+nKrqelNa1LBVNQ2xtj0okmTXpiqrdamvoEv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   "], {{0, 0}, {458, 102}}, {0, 255}],
  ImageSize->{458 0.75, 102 0.75},
  PlotRange->{{0, 458}, {0, 102}}]], "NotebookImage",
 CellID->260216187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126966745],

Cell["Show only the first cell in the group:", "ExampleText",
 CellID->251424280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"CellGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2445961],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1PU1ccx1n2fvFf2H+y7OGtxsU3bskEM9BtMcZlL5Ys2QszdZO5DB/A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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->209847031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240227933],

Cell["Show only the second cell in the group:", "ExampleText",
 CellID->33201068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"CellGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "2"}], "]"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157934998],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnOtPU2ccx1n2fvFf2D+yF7u81WzxzbZkghkXtxjjshdLluyFmbrJXIYX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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellID->77996850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612200391],

Cell["Show only the first and last cells:", "ExampleText",
 CellID->66054110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"CellGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15535087],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPFFccxnGavm/8F/qv9JL0lcbGN22TCqagtjHGpi+aNGkTU7WV2tQb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   "], {{0, 0}, {458, 84}}, {0, 255}],
  ImageSize->{458 0.75, 84 0.75},
  PlotRange->{{0, 458}, {0, 84}}]], "NotebookImage",
 CellID->25920744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->367846992],

Cell[TextData[{
 "By default, notebooks use automatic grouping that ignores ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 " structures:"
}], "ExampleText",
 CellID->141730922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"CellGroup", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125648099],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+ld6uNW28aZtUsEUsG2MselFkya9MFVbqU3xAKKA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   "], {{0, 0}, {458, 80}}, {0, 255}],
  ImageSize->{458 0.75, 80 0.75},
  PlotRange->{{0, 458}, {0, 80}}]], "NotebookImage",
 CellID->44675722]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20344],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpressionCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGroupOpener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowGroupOpener"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroupData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroupData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->671737646],

Cell[TextData[ButtonBox["Controlling Cell Grouping",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControllingCellGrouping"]], "MoreAbout",
 CellID->172675518],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->643570200],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->77332506]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 38.5073536}", "context" -> "System`", 
    "keywords" -> {
     "bracket", "document generation", "notebook content", 
      "report generation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellGroup[{cell_1, cell_2, ...}] gives an open group of cells that can \
appear in a Mathematica notebook. CellGroup[{cell_1, cell_2, ...}, 1] gives a \
cell group in which only the first cell is open. CellGroup[{cell_1, cell_2, \
...}, -1] gives a cell group in which only the last cell is open. \
CellGroup[{cell_1, cell_2, ...}, {i_1, i_2, ...}] gives a cell group in which \
cells i_1, i_2, ... are open. ", "synonyms" -> {"cell group"}, "title" -> 
    "CellGroup", "type" -> "Symbol", "uri" -> "ref/CellGroup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10780, 349, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->334606197]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34814, 943}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2226, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2849, 76, 1574, 37, 70, "ObjectNameGrid"],
Cell[4426, 115, 3203, 103, 70, "Usage",
 CellID->1666]
}, Open  ]],
Cell[CellGroupData[{
Cell[7666, 223, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8144, 240, 570, 23, 70, "Notes",
 CellID->27127],
Cell[8717, 265, 364, 13, 70, "Notes",
 CellID->9259],
Cell[9084, 280, 512, 17, 70, "Notes",
 CellID->17419],
Cell[9599, 299, 488, 20, 70, "Notes",
 CellID->17509],
Cell[10090, 321, 653, 23, 70, "Notes",
 CellID->276]
}, Closed]],
Cell[CellGroupData[{
Cell[10780, 349, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334606197],
Cell[CellGroupData[{
Cell[11165, 363, 148, 5, 70, "ExampleSection",
 CellID->151659454],
Cell[CellGroupData[{
Cell[11338, 372, 289, 9, 70, "Input",
 CellID->77254257],
Cell[11630, 383, 2581, 45, 70, "NotebookImage",
 CellID->425384467]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14260, 434, 220, 7, 70, "ExampleSection",
 CellID->821577873],
Cell[14483, 443, 85, 1, 70, "ExampleText",
 CellID->18368235],
Cell[CellGroupData[{
Cell[14593, 448, 390, 12, 70, "Input",
 CellID->524496204],
Cell[14986, 462, 2779, 48, 70, "NotebookImage",
 CellID->260216187]
}, Open  ]],
Cell[17780, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->126966745],
Cell[17908, 518, 81, 1, 70, "ExampleText",
 CellID->251424280],
Cell[CellGroupData[{
Cell[18014, 523, 316, 10, 70, "Input",
 CellID->2445961],
Cell[18333, 535, 2454, 42, 70, "NotebookImage",
 CellID->209847031]
}, Open  ]],
Cell[20802, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->240227933],
Cell[20930, 585, 81, 1, 70, "ExampleText",
 CellID->33201068],
Cell[CellGroupData[{
Cell[21036, 590, 318, 10, 70, "Input",
 CellID->157934998],
Cell[21357, 602, 2433, 42, 70, "NotebookImage",
 CellID->77996850]
}, Open  ]],
Cell[23805, 647, 125, 3, 70, "ExampleDelimiter",
 CellID->612200391],
Cell[23933, 652, 77, 1, 70, "ExampleText",
 CellID->66054110],
Cell[CellGroupData[{
Cell[24035, 657, 406, 13, 70, "Input",
 CellID->15535087],
Cell[24444, 672, 2624, 45, 70, "NotebookImage",
 CellID->25920744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27117, 723, 230, 7, 70, "ExampleSection",
 CellID->367846992],
Cell[27350, 732, 254, 8, 70, "ExampleText",
 CellID->141730922],
Cell[CellGroupData[{
Cell[27629, 744, 216, 7, 70, "Input",
 CellID->125648099],
Cell[27848, 753, 2543, 44, 70, "NotebookImage",
 CellID->44675722]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30452, 804, 311, 9, 70, "SeeAlsoSection",
 CellID->20344],
Cell[30766, 815, 1725, 62, 70, "SeeAlso",
 CellID->3868]
}, Open  ]],
Cell[CellGroupData[{
Cell[32528, 882, 319, 9, 70, "MoreAboutSection",
 CellID->671737646],
Cell[32850, 893, 160, 3, 70, "MoreAbout",
 CellID->172675518],
Cell[33013, 898, 149, 3, 70, "MoreAbout",
 CellID->643570200],
Cell[33165, 903, 172, 3, 70, "MoreAbout",
 CellID->77332506]
}, Open  ]],
Cell[33352, 909, 27, 0, 70, "History"],
Cell[33382, 911, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

