(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35312,        961]
NotebookOptionsPosition[     30558,        811]
NotebookOutlinePosition[     32669,        867]
CellTagsIndexPosition[     32551,        861]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/TheStructureOfCells"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellGroup" :> Documentation`HelpLookup["paclet:ref/CellGroup"],
           "Cell" :> Documentation`HelpLookup["paclet:ref/Cell"], 
          "CellGrouping" :> 
          Documentation`HelpLookup["paclet:ref/CellGrouping"], "CellOpen" :> 
          Documentation`HelpLookup["paclet:ref/CellOpen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellGroup\"\>", 2->"\<\"Cell\"\>", 
       3->"\<\"CellGrouping\"\>", 4->"\<\"CellOpen\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks and Documents: New in 6.0" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Notebooks and Documents: New in 6.0\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CellGroupData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroupData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroupData"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level construct that represents an open group \
of cells in a notebook. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroupData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroupData"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "1"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents a cell group in which only the first cell \
is open."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellGroupData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellGroupData"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["cell", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a cell group with cells at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "  open. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Cell groups are typically opened and closed by double\[Hyphen]clicking their \
cell brackets or opener icons. \
\>", "Notes",
 CellID->19882],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGroupData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroupData"], "[", 
   RowBox[{
    StyleBox["cells", "TI"], ",", 
    StyleBox["status", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["status", "TI"]], "InlineFormula"],
 " can contain ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25442],

Cell[TextData[{
 "When cells are entered into a notebook, they are automatically placed in \
groups unless ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"], "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 " is set. "
}], "Notes",
 CellID->20657]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20875010],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->49734504],

Cell["Create a notebook that has automatic cell grouping:", "ExampleText",
 CellID->781939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<heading\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<text\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], "]"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467175296],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1T01cex3F29n6n/8L+J84+XKrTTm+6ndmKsyLtTsfZnd7V2YtObXcr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   "], {{0, 0}, {458, 132}}, {0, 255}],
  ImageSize->{458 0.75, 132 0.75},
  PlotRange->{{0, 458}, {0, 132}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->441477420]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 " shows the ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " structure:"
}], "ExampleText",
 CellID->35391298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"NotebookRead", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122064672],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"CellGroupData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"\<\"heading\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"\<\"text\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", 
    "Open"}], "]"}], "]"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31292714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43403690],

Cell["Create a document with manually grouped cells:", "ExampleText",
 CellID->219643475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 2\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
         ",", "Open"}], "]"}], "}"}], ",", 
      RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328041606],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtTU1cfxnE6ve/4L/Rf6eFWR6c31pkqTkVtx3Ha6V1neuFUbbV26glE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   "], {{0, 0}, {458, 89}}, {0, 255}],
  ImageSize->{458 0.75, 89 0.75},
  PlotRange->{{0, 458}, {0, 89}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->380381466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512452107],

Cell["Create a group with only the second cell open:", "ExampleText",
 CellID->22973081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 2\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 3\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "}"}], ",", 
      RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8428123],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+ld6utTYeGObVDDlYBtj2vSuSS9M1VZqUzyAWECl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   "], {{0, 0}, {458, 70}}, {0, 255}],
  ImageSize->{458 0.75, 70 0.75},
  PlotRange->{{0, 458}, {0, 70}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1792109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112036186],

Cell["Create a group with its first and third cells open:", "ExampleText",
 CellID->187812185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 2\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<text 3\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "}"}], ",", 
      RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33740012],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3ftPU2ccx3GW/b74L+xf2SXZTxoXf3HLppiJusWYLfttyZaYqZvOZd7A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   "], {{0, 0}, {458, 93}}, {0, 255}],
  ImageSize->{458 0.75, 93 0.75},
  PlotRange->{{0, 458}, {0, 93}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->507415912]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1729],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGrouping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGrouping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellOpen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9168],

Cell[TextData[ButtonBox["The Structure of Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfCells"]], "Tutorials",
 CellID->20178]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->269565249],

Cell[TextData[ButtonBox["Notebooks and Documents: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->17756525]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellGroupData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 31.8509332}", "context" -> "System`", 
    "keywords" -> {
     "grouping of cells", "hierarchical grouping of cells", 
      "flat grouping of cells", "open cell groups", "closed cell groups"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CellGroupData[{cell_1, cell_2, ...}] is a low-level construct that \
represents an open group of cells in a notebook. CellGroupData[{cell_1, \
cell_2, ...}, 1] represents a cell group in which only the first cell is \
open. CellGroupData[{cell_1, cell_2, ...}, {i_1, i_2, ...}] represents a cell \
group with cells at positions i_1, i_2, ... open. ", 
    "synonyms" -> {"cell group data"}, "title" -> "CellGroupData", "type" -> 
    "Symbol", "uri" -> "ref/CellGroupData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11277, 319, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20875010]},
 "Notebook Image"->{
  Cell[12321, 359, 3556, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->441477420],
  Cell[17856, 496, 2752, 48, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->380381466],
  Cell[21633, 581, 2591, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->1792109],
  Cell[25287, 664, 2821, 49, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->507415912]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31972, 841},
 {"Notebook Image", 32113, 845}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2094, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2717, 79, 4197, 83, 70, "ObjectNameGrid"],
Cell[6917, 164, 2639, 84, 70, "Usage",
 CellID->32524]
}, Open  ]],
Cell[CellGroupData[{
Cell[9593, 253, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10071, 270, 151, 4, 70, "Notes",
 CellID->19882],
Cell[10225, 276, 627, 23, 70, "Notes",
 CellID->25442],
Cell[10855, 301, 385, 13, 70, "Notes",
 CellID->20657]
}, Closed]],
Cell[CellGroupData[{
Cell[11277, 319, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20875010],
Cell[CellGroupData[{
Cell[11661, 333, 147, 5, 70, "ExampleSection",
 CellID->49734504],
Cell[11811, 340, 91, 1, 70, "ExampleText",
 CellID->781939],
Cell[CellGroupData[{
Cell[11927, 345, 391, 12, 70, "Input",
 CellID->467175296],
Cell[12321, 359, 3556, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->441477420]
}, Open  ]],
Cell[15892, 423, 340, 12, 70, "ExampleText",
 CellID->35391298],
Cell[CellGroupData[{
Cell[16257, 439, 216, 6, 70, "Input",
 CellID->122064672],
Cell[16476, 447, 487, 15, 36, "Output",
 CellID->31292714]
}, Open  ]],
Cell[16978, 465, 124, 3, 70, "ExampleDelimiter",
 CellID->43403690],
Cell[17105, 470, 89, 1, 70, "ExampleText",
 CellID->219643475],
Cell[CellGroupData[{
Cell[17219, 475, 634, 19, 70, "Input",
 CellID->328041606],
Cell[17856, 496, 2752, 48, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->380381466]
}, Open  ]],
Cell[20623, 547, 125, 3, 70, "ExampleDelimiter",
 CellID->512452107],
Cell[20751, 552, 88, 1, 70, "ExampleText",
 CellID->22973081],
Cell[CellGroupData[{
Cell[20864, 557, 766, 22, 70, "Input",
 CellID->8428123],
Cell[21633, 581, 2591, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1792109]
}, Open  ]],
Cell[24239, 629, 125, 3, 70, "ExampleDelimiter",
 CellID->112036186],
Cell[24367, 634, 94, 1, 70, "ExampleText",
 CellID->187812185],
Cell[CellGroupData[{
Cell[24486, 639, 798, 23, 70, "Input",
 CellID->33740012],
Cell[25287, 664, 2821, 49, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->507415912]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28169, 720, 310, 9, 70, "SeeAlsoSection",
 CellID->1729],
Cell[28482, 731, 943, 35, 70, "SeeAlso",
 CellID->15303]
}, Open  ]],
Cell[CellGroupData[{
Cell[29462, 771, 313, 9, 70, "TutorialsSection",
 CellID->9168],
Cell[29778, 782, 152, 3, 70, "Tutorials",
 CellID->20178]
}, Open  ]],
Cell[CellGroupData[{
Cell[29967, 790, 319, 9, 70, "MoreAboutSection",
 CellID->269565249],
Cell[30289, 801, 174, 3, 70, "MoreAbout",
 CellID->17756525]
}, Open  ]],
Cell[30478, 807, 50, 0, 70, "History"],
Cell[30531, 809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

