(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11194,        401]
NotebookOptionsPosition[      8260,        304]
NotebookOutlinePosition[      9585,        342]
CellTagsIndexPosition[      9501,        337]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
          "Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>", 
       2->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellTags" :> Documentation`HelpLookup["paclet:ref/CellTags"], 
          "CellLabelAutoDelete" :> 
          Documentation`HelpLookup["paclet:ref/CellLabelAutoDelete"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CellTags\"\>", 
       2->"\<\"CellLabelAutoDelete\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellLabel", "ObjectName",
 CellID->16577],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellLabel"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which gives the label to use for a particular cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CellLabel", "->", "\"\<\>\""}]], "InlineFormula"],
 " specifies that no label should be used for a cell. "
}], "Notes",
 CellID->9085],

Cell[TextData[{
 "Cell labels are displayed when the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowCellLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellLabel"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is made. "
}], "Notes",
 CellID->1551],

Cell[TextData[{
 "Cell labels are typically generated automatically when cells appear as \
input or output to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Notes",
 CellID->25883],

Cell[TextData[{
 "Cell labels are automatically deleted when a cell is modified if ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellLabelAutoDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabelAutoDelete"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13978]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->221842474],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->417017824],

Cell[TextData[{
 "Select the cell being evaluated and get its ",
 Cell[BoxData[
  ButtonBox["CellLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellLabel"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->203497379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{
    RowBox[{"EvaluationNotebook", "[", "]"}], ",", "All", ",", 
    "EvaluationCell"}], "]"}], ";", 
  RowBox[{"Options", "[", 
   RowBox[{
    RowBox[{"NotebookSelection", "[", 
     RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ",", "CellLabel"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228588671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CellLabel", "\[Rule]", "\<\"In[1]:=\"\>"}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90083543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->700720948],

Cell["Attach a label to a text cell:", "ExampleText",
 CellID->315350200],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<abcde\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellLabel", "\[Rule]", "\"\<Example\>\""}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"120", ",", "24"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226953823],

Cell["abcde", "Text",
 CellMargins->{{120, 24}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"Example",
 CellID->285783417]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24552],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellTags"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellLabelAutoDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabelAutoDelete"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11618],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->8625],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->11142]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 40.8511636}", "context" -> "System`", 
    "keywords" -> {
     "labels", "line numbers", "cell label", "cell caption", "cell heading", 
      "paragraph label"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellLabel is an option for Cell which gives the label to use for a \
particular cell. ", "synonyms" -> {"cell label"}, "title" -> "CellLabel", 
    "type" -> "Symbol", "uri" -> "ref/CellLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4409, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->221842474]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9358, 330}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1501, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2124, 63, 47, 1, 70, "ObjectName",
 CellID->16577],
Cell[2174, 66, 590, 18, 70, "Usage",
 CellID->7401]
}, Open  ]],
Cell[CellGroupData[{
Cell[2801, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3279, 106, 176, 5, 70, "Notes",
 CellID->9085],
Cell[3458, 113, 337, 12, 70, "Notes",
 CellID->1551],
Cell[3798, 127, 207, 7, 70, "Notes",
 CellID->25883],
Cell[4008, 136, 364, 12, 70, "Notes",
 CellID->13978]
}, Closed]],
Cell[CellGroupData[{
Cell[4409, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->221842474],
Cell[CellGroupData[{
Cell[4794, 167, 148, 5, 70, "ExampleSection",
 CellID->417017824],
Cell[4945, 174, 237, 8, 70, "ExampleText",
 CellID->203497379],
Cell[CellGroupData[{
Cell[5207, 186, 387, 12, 47, "Input",
 CellID->228588671],
Cell[5597, 200, 231, 7, 36, "Output",
 CellID->90083543]
}, Open  ]],
Cell[5843, 210, 125, 3, 70, "ExampleDelimiter",
 CellID->700720948],
Cell[5971, 215, 73, 1, 70, "ExampleText",
 CellID->315350200],
Cell[6047, 218, 471, 13, 70, "Input",
 CellID->226953823],
Cell[6521, 233, 147, 5, 70, "Text",
 CellID->285783417]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6717, 244, 311, 9, 70, "SeeAlsoSection",
 CellID->24552],
Cell[7031, 255, 472, 17, 70, "SeeAlso",
 CellID->6116]
}, Open  ]],
Cell[CellGroupData[{
Cell[7540, 277, 314, 9, 70, "TutorialsSection",
 CellID->11618],
Cell[7857, 288, 185, 4, 70, "Tutorials",
 CellID->8625],
Cell[8045, 294, 143, 3, 70, "Tutorials",
 CellID->11142]
}, Open  ]],
Cell[8203, 300, 27, 0, 70, "History"],
Cell[8233, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

