(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15873,        502]
NotebookOptionsPosition[     12360,        385]
NotebookOutlinePosition[     13986,        433]
CellTagsIndexPosition[     13846,        426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cells as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CellsAsMathematicaExpressions"], 
          "Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
          "Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Cells as Mathematica Expressions\"\>", 
       2->"\<\"Manipulating Notebooks from the Kernel\"\>", 
       3->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellLabel" :> Documentation`HelpLookup["paclet:ref/CellLabel"],
           "ConversionRules" :> 
          Documentation`HelpLookup["paclet:ref/ConversionRules"], 
          "NotebookLocate" :> 
          Documentation`HelpLookup["paclet:ref/NotebookLocate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellLabel\"\>", 
       2->"\<\"ConversionRules\"\>", 
       3->"\<\"NotebookLocate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellTags", "ObjectName",
 CellID->9696],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellTags",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellTags"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which gives a list of tags to associate with a cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4423]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Cell tags are typically used to allow searching for cells. ", "Notes",
 CellID->24575],

Cell["The tags are usually strings. ", "Notes",
 CellID->13627],

Cell[TextData[{
 "Cell tags are displayed when ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowCellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellTags"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is set. "
}], "Notes",
 CellID->21712]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->287329062],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->132595786],

Cell["Create a cell with a cell tag:", "ExampleText",
 CellID->29755717],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<abcd\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellTags", "\[Rule]", "\"\<tag\>\""}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249578217],

Cell["abcd", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellTags->"tag",
 CellID->211551979],

Cell["Find the tagged cell and read its cell expression:", "ExampleText",
 CellID->110543561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookLocate", "[", "\"\<tag\>\"", "]"}], ";", 
  RowBox[{"NotebookRead", "[", 
   RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96654362],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"Text\"\>", ",", 
   RowBox[{"GeneratedCell", "\[Rule]", "True"}], ",", 
   RowBox[{"CellAutoOverwrite", "\[Rule]", "True"}], ",", 
   RowBox[{"CellTags", "\[Rule]", "\<\"tag\"\>"}]}], "]"}]], "Output",
 GeneratedCell->True,
 ImageSize->{538, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260487888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232479921],

Cell[TextData[{
 "Make cell tags visible with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowCellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellTags"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->169345041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"CellTags", "\[Rule]", "\"\<tag1\>\""}]}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<def\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"CellTags", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<tag1\>\"", ",", "\"\<tag2\>\""}], "}"}]}]}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"ShowCellTags", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78213493],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1TFFcexnG2cp/Kv7D/SpK91cpWbpKtSsSKaJKyrE15Z9VepNZkNyap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   "], {{0, 0}, {458, 116}}, {0, 255}],
  ImageSize->{458 0.75, 116 0.75},
  PlotRange->{{0, 458}, {0, 116}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->4433118]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22385],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConversionRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConversionRules"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookLocate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookLocate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11747],

Cell[TextData[{
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"]
}], "Tutorials",
 CellID->31266],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->21039],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->2586]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellTags - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 47.6794634}", "context" -> "System`", 
    "keywords" -> {
     "tags", "cell anchors", "cell tags", "cell hyperlinks", 
      "cell anchor marks", "cell annotation", "named cell", "tagged cell"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CellTags is an option for Cell which gives a list of tags to associate \
with a cell. ", "synonyms" -> {"cell tags"}, "title" -> "CellTags", "type" -> 
    "Symbol", "uri" -> "ref/CellTags"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4121, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->287329062]},
 "tag"->{
  Cell[4979, 168, 106, 4, 70, "Text",
   CellTags->"tag",
   CellID->211551979]},
 "Notebook Image"->{
  Cell[6978, 241, 3111, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->4433118]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13488, 411},
 {"tag", 13618, 415},
 {"Notebook Image", 13721, 419}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1827, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2450, 70, 45, 1, 70, "ObjectName",
 CellID->9696],
Cell[2498, 73, 589, 18, 70, "Usage",
 CellID->4423]
}, Open  ]],
Cell[CellGroupData[{
Cell[3124, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3602, 113, 92, 1, 70, "Notes",
 CellID->24575],
Cell[3697, 116, 63, 1, 70, "Notes",
 CellID->13627],
Cell[3763, 119, 321, 12, 70, "Notes",
 CellID->21712]
}, Closed]],
Cell[CellGroupData[{
Cell[4121, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->287329062],
Cell[CellGroupData[{
Cell[4506, 150, 148, 5, 70, "ExampleSection",
 CellID->132595786],
Cell[4657, 157, 72, 1, 70, "ExampleText",
 CellID->29755717],
Cell[4732, 160, 244, 6, 70, "Input",
 CellID->249578217],
Cell[4979, 168, 106, 4, 70, "Text",
 CellTags->"tag",
 CellID->211551979],
Cell[5088, 174, 93, 1, 70, "ExampleText",
 CellID->110543561],
Cell[CellGroupData[{
Cell[5206, 179, 222, 6, 70, "Input",
 CellID->96654362],
Cell[5431, 187, 427, 11, 36, "Output",
 CellID->260487888]
}, Open  ]],
Cell[5873, 201, 125, 3, 70, "ExampleDelimiter",
 CellID->232479921],
Cell[6001, 206, 322, 12, 70, "ExampleText",
 CellID->169345041],
Cell[CellGroupData[{
Cell[6348, 222, 627, 17, 70, "Input",
 CellID->78213493],
Cell[6978, 241, 3111, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->4433118]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10150, 302, 311, 9, 70, "SeeAlsoSection",
 CellID->22385],
Cell[10464, 313, 724, 26, 70, "SeeAlso",
 CellID->23247]
}, Open  ]],
Cell[CellGroupData[{
Cell[11225, 344, 314, 9, 70, "TutorialsSection",
 CellID->11747],
Cell[11542, 355, 412, 12, 70, "Tutorials",
 CellID->31266],
Cell[11957, 369, 186, 4, 70, "Tutorials",
 CellID->21039],
Cell[12146, 375, 142, 3, 70, "Tutorials",
 CellID->2586]
}, Open  ]],
Cell[12303, 381, 27, 0, 70, "History"],
Cell[12333, 383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

