(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13109,        470]
NotebookOptionsPosition[      9903,        362]
NotebookOutlinePosition[     11207,        400]
CellTagsIndexPosition[     11122,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Left" :> Documentation`HelpLookup["paclet:ref/Left"], "Right" :> 
         Documentation`HelpLookup["paclet:ref/Right"], "Top" :> 
         Documentation`HelpLookup["paclet:ref/Top"], "Bottom" :> 
         Documentation`HelpLookup["paclet:ref/Bottom"], "Axis" :> 
         Documentation`HelpLookup["paclet:ref/Axis"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Left\"\>", 2->"\<\"Right\"\>", 3->"\<\"Top\"\>", 
      4->"\<\"Bottom\"\>", 5->"\<\"Axis\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Center", "ObjectName",
 CellID->6900],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the center for purposes of \
alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " applies to both the horizontal and vertical center positions."
}], "Notes",
 CellID->654]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7889295],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5523037],

Cell["Align the contents of a grid to the center:", "ExampleText",
 CellID->94306447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      SqrtBox["x"], ",", "b", ",", 
      FractionBox["x", "y"], ",", "c"}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Center"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176068346],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     SqrtBox["x"], "b", 
     FractionBox["x", "y"], "c"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Automatic}}, "Rows" -> {{Center}}},
   GridBoxFrame->{"Columns" -> True, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{102, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85084336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleText",
 CellID->467567170],

Cell["Align the center of a grid with the baseline of the text:", \
"ExampleText",
 CellID->458844947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94197876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Center,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->607619633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188606542],

Cell["Align text to the center:", "ExampleText",
 CellID->90237254],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcd \>\"", ",", 
      RowBox[{"{", "60", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367642920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Center"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->449003041],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnctOwkAUQKcv6EL3XbLEqMT4AS515Uc0xAQWRoP8f53pzJS2DCampUzL
aVLozL3nYMxwKe1NeM/3m4/PfL9d54u3Xf692a5/Fq9fOzkVBUKET0KIl0zI
40IelbvdnuUux1GapkJvNmUl90BPRxVRgSu5BxqYdPROPsRqLtb/KJMgB6F5
TkyQLLLGkPXgXOdL9TA7jMsDQ9k8hYStcT2uDkM8ePDgwVNy90WXalsW8qTK
q89CQ0ND90w/Fqe+BUXCSrSiXfncvgQSEhKyRrprzLKZa43i+BzLNQ6PXw0D
BgwYvDKcPr+qLPGB0sU1qvH1ahtDQUFNgnJflVfVoj6+aY3nxIl3iLuvTrLq
iA+/6lQFVFXx1jynjP8cu88kC7P51UVxvij9GWRNK4v+DDx48OAZwkN/BjQ0
9Fho+jMgISHPSdKfgQEDhms00J8BBQXVpujPIO7LnXJWHfHhVx39GfRn/D+q
PkJ9vMtOFlljyZo731m+3UnFgwcPHjx+emZFl08R/+6EQ0NDQ/tHqysB7m/C
kbASrWjXbH96ACAhISH7Id0VMWzmWqMYV8cABgwYMEzbcPqc1u++DSgoqGum
3HfPLt1jQZx4l7j7av6l/yrixPtf1WrWp86uKY796RjrO5plmT5q/rJVOW3z
za9gBb9iJj8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->638520622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338216689],

Cell["Place text at the center of the enclosing graphic:", "ExampleText",
 CellID->125552549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", "Center", ",", "Center"}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186093363],

Cell[BoxData[
 GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}], Center], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->105932635]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13626],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Left",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Left"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Right",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Right"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Top",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Top"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bottom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Bottom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axis"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4696]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Center - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 7.0080832}", "context" -> "System`", 
    "keywords" -> {
     "view point", "view position", "camera position", "grid alignment", 
      "control placement"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Center is a symbol that represents the center for purposes of alignment \
and positioning. ", "synonyms" -> {}, "title" -> "Center", "type" -> "Symbol",
     "uri" -> "ref/Center"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2799, 97, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7889295]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10982, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 885, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1508, 45, 43, 1, 70, "ObjectName",
 CellID->6900],
Cell[1554, 48, 464, 14, 70, "Usage",
 CellID->27841]
}, Open  ]],
Cell[CellGroupData[{
Cell[2055, 67, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2533, 84, 229, 8, 70, "Notes",
 CellID->654]
}, Closed]],
Cell[CellGroupData[{
Cell[2799, 97, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7889295],
Cell[CellGroupData[{
Cell[3182, 111, 146, 5, 70, "ExampleSection",
 CellID->5523037],
Cell[3331, 118, 85, 1, 70, "ExampleText",
 CellID->94306447],
Cell[CellGroupData[{
Cell[3441, 123, 471, 15, 42, "Input",
 CellID->176068346],
Cell[3915, 140, 510, 16, 48, "Output",
 CellID->85084336]
}, Open  ]],
Cell[4440, 159, 120, 3, 70, "ExampleText",
 CellID->467567170],
Cell[4563, 164, 102, 2, 70, "ExampleText",
 CellID->458844947],
Cell[CellGroupData[{
Cell[4690, 170, 451, 15, 70, "Input",
 CellID->94197876],
Cell[5144, 187, 559, 18, 55, "Output",
 CellID->607619633]
}, Open  ]],
Cell[5718, 208, 125, 3, 70, "ExampleDelimiter",
 CellID->188606542],
Cell[5846, 213, 67, 1, 70, "ExampleText",
 CellID->90237254],
Cell[5916, 216, 244, 8, 70, "Input",
 CellID->367642920],
Cell[CellGroupData[{
Cell[6185, 228, 239, 8, 28, "Input",
 CellID->449003041],
Cell[6427, 238, 895, 19, 83, "Output",
 Evaluatable->False,
 CellID->638520622]
}, Open  ]],
Cell[7337, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->338216689],
Cell[7465, 265, 93, 1, 70, "ExampleText",
 CellID->125552549],
Cell[CellGroupData[{
Cell[7583, 270, 384, 11, 70, "Input",
 CellID->186093363],
Cell[7970, 283, 337, 10, 121, "Output",
 CellID->105932635]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8368, 300, 311, 9, 70, "SeeAlsoSection",
 CellID->13626],
Cell[8682, 311, 1149, 44, 70, "SeeAlso",
 CellID->4696]
}, Open  ]],
Cell[9846, 358, 27, 0, 70, "History"],
Cell[9876, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

