(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44819,       1669]
NotebookOptionsPosition[     37174,       1399]
NotebookOutlinePosition[     38479,       1436]
CellTagsIndexPosition[     38393,       1431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "Skewness" :> Documentation`HelpLookup["paclet:ref/Skewness"], 
          "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"], 
          "ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"], "Covariance" :> 
          Documentation`HelpLookup["paclet:ref/Covariance"], "Correlation" :> 
          Documentation`HelpLookup["paclet:ref/Correlation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Variance\"\>", 
       2->"\<\"Skewness\"\>", 3->"\<\"Kurtosis\"\>", 
       4->"\<\"ExpectedValue\"\>", 5->"\<\"Covariance\"\>", 
       6->"\<\"Correlation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       3->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CentralMoment", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CentralMoment",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CentralMoment"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " central moment of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with respect to their mean."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1890]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " central moment is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "n"], 
    RowBox[{
     UnderscriptBox["\[Sum]", "i"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "i"], "-", 
        OverscriptBox["x", "_"]}], ")"}], "r"]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]], "InlineMath"],
 " is the mean of the list."
}], "Notes",
 CellID->13367],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CentralMoment", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["r", "TI"]}], "]"}], ",", 
    RowBox[{"CentralMoment", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["r", "TI"]}], "]"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], 
     StyleBox["}", "TR"]}]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CentralMoment", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], ",", 
    RowBox[{"CentralMoment", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->366538317],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->691995022],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->253437075],

Cell[TextData[{
 "The r",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " central moment of symbolic data:"
}], "ExampleText",
 CellID->45724638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "r"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200942796],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b"}], ")"}]}]}], ")"}], "r"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b"}], ")"}]}], "+", "b"}], ")"}], "r"]}], 
   ")"}]}]], "Output",
 ImageSize->{248, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187563790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10551889],

Cell[TextData[{
 "The 2",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "nd"], TraditionalForm]]],
 " central moment of a matrix, computed columnwise:"
}], "ExampleText",
 CellID->5626557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201828696],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["26", "9"], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 ImageSize->{59, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75423063]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32705],

Cell["Exact numeric input:", "ExampleText",
 CellID->18799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29442],

Cell[BoxData[
 FractionBox["72", "125"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576193068]
}, Open  ]],

Cell["Numerical approximation:", "ExampleText",
 CellID->10736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CentralMoment", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", "3"}],
    "]"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30301],

Cell[BoxData["0.576`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26254511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158140014],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 " threads over columns and powers:"
}], "ExampleText",
 CellID->126348940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "z"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->810597421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], "r1"],
       "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], "r1"],
       "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
        ")"}], "r1"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}], "r2"],
       "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "+", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}], "r2"],
       "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
        ")"}], "r2"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{450, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->500725846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "r1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139801040],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], "r1"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], "r1"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
      ")"}], "r1"]}], ")"}]}]], "Output",
 ImageSize->{436, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47916232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "r2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->218049521],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}], "r2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}], "r2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
      ")"}], "r2"]}], ")"}]}]], "Output",
 ImageSize->{436, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27325373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359275129],

Cell["Arbitrary-precision data:", "ExampleText",
 CellID->188291280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "3", ",", "10", ",", "1"}], "}"}], ",", 
     "20"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24927221],

Cell[BoxData["1234.86528000000000000000000000291`18.866863320967717"], \
"Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->718583796]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26162],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69903739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{"sp", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["4851", "500000"], ",", 
   FractionBox["4851", "62500"], ",", 
   FractionBox["8379", "31250"], ",", 
   FractionBox["42777", "62500"], ",", 
   FractionBox["22491", "15625"], ",", 
   FractionBox["1323", "500"], ",", 
   FractionBox["138033", "31250"], ",", 
   FractionBox["429093", "62500"], ",", 
   FractionBox["157878", "15625"], ",", 
   FractionBox["890379", "62500"]}], "}"}]], "Output",
 ImageSize->{558, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240918784]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9282],

Cell["The first central moment is 0:", "ExampleText",
 CellID->180528295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163004883],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->831338253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137012746],

Cell[TextData[{
 "The second central moment is a scaled ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula",
  ShowStringCharacters->False],
 ":"
}], "ExampleText",
 CellID->7602946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86545193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.185769199682669`", ",", "1.9350634255602883`", ",", "9.897744855390824`",
    ",", "6.659648970018579`", ",", "5.590832385301832`", ",", 
   "7.324559341519697`", ",", "7.293853522898532`", ",", "8.122463905752692`",
    ",", "3.0870436062327222`", ",", "6.910443702166724`", ",", 
   "8.338857929273995`", ",", "2.287535711853239`", ",", "5.142206975071655`",
    ",", "0.8948276249651022`", ",", "8.858861418814115`", ",", 
   "6.487219007121006`", ",", "6.799246913324131`", ",", "9.748851392484074`",
    ",", "2.619633579846057`", ",", "7.5190035959390755`"}], "}"}]], "Output",\

 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172147605]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", "data", "]"}], " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}], "/", 
   RowBox[{"Length", "[", "data", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309913758],

Cell[BoxData["6.787097791729418`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15239612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{"data", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154126311],

Cell[BoxData["6.787097791729418`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->466921064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522029420],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " of the second central moment is ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->372037111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"CentralMoment", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157573493],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}], "+", 
        "d"}], ")"}], "2"]}], ")"}]}]}]], "Output",
 ImageSize->{487, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318732447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "-", 
   RowBox[{"Mean", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677980062],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
       ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}], "+", 
        "d"}], ")"}], "2"]}], ")"}]}]}]], "Output",
 ImageSize->{487, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->363549258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97257252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Skewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skewness"]], "InlineFormula"],
 " is a ratio of powers of third and second central moments:"
}], "ExampleText",
 CellID->22987128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451046271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.950446871738285`", ",", "6.767594989710391`", ",", "9.266550195988096`", 
   ",", "9.27189894785986`", ",", "3.3414306094020008`", ",", 
   "3.3241376844108217`", ",", "3.921561000835405`", ",", 
   "2.4658228033366303`", ",", "7.103724702588792`", ",", 
   "7.341702756923949`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40382564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81589366],

Cell[BoxData["0.02960900636830637`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472978859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CentralMoment", "[", 
   RowBox[{"data", ",", "3"}], "]"}], "/", 
  RowBox[{
   RowBox[{"CentralMoment", "[", 
    RowBox[{"data", ",", "2"}], "]"}], "^", 
   RowBox[{"(", 
    RowBox[{"3", "/", "2"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->454115601],

Cell[BoxData["0.02960900636830637`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137126684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59005910],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 " is a ratio of powers of fourth and second central moments:"
}], "ExampleText",
 CellID->143550462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713000587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.457587676664257`", ",", "7.148872177176509`", ",", 
   "0.31543241522201004`", ",", "1.2250727724360289`", ",", 
   "1.5752097185016645`", ",", "3.0140341623620204`", ",", 
   "1.2312134839456679`", ",", "9.435661942995804`", ",", 
   "7.488294379487241`", ",", "9.400879987533628`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503872705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114573746],

Cell[BoxData["1.2754206532906922`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443387064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CentralMoment", "[", 
   RowBox[{"data", ",", "4"}], "]"}], "/", 
  RowBox[{
   RowBox[{"CentralMoment", "[", 
    RowBox[{"data", ",", "2"}], "]"}], "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83693251],

Cell[BoxData["1.2754206532906922`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->430769667]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2792],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skewness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skewness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Covariance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Covariance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Correlation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Correlation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19606],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->2980856],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->5581263],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->596308363]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CentralMoment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 7.2893404}", "context" -> "System`", 
    "keywords" -> {"expectation", "sample moments"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CentralMoment[list, r] gives the r\\[Null]^th central moment of the \
elements in list with respect to their mean.", 
    "synonyms" -> {"central moment"}, "title" -> "CentralMoment", "type" -> 
    "Symbol", "uri" -> "ref/CentralMoment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11408, 372, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->691995022]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38249, 1424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2646, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3269, 87, 1578, 37, 70, "ObjectNameGrid"],
Cell[4850, 126, 826, 26, 70, "Usage",
 CellID->1890]
}, Open  ]],
Cell[CellGroupData[{
Cell[5713, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6191, 174, 893, 34, 70, "Notes",
 CellID->13367],
Cell[7087, 210, 220, 7, 70, "Notes",
 CellID->28487],
Cell[7310, 219, 1668, 59, 70, "Notes",
 CellID->26555],
Cell[8981, 280, 2058, 73, 70, "Notes",
 CellID->366538317],
Cell[11042, 355, 329, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[11408, 372, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->691995022],
Cell[CellGroupData[{
Cell[11793, 386, 148, 5, 70, "ExampleSection",
 CellID->253437075],
Cell[11944, 393, 182, 7, 70, "ExampleText",
 CellID->45724638],
Cell[CellGroupData[{
Cell[12151, 404, 181, 6, 28, "Input",
 CellID->200942796],
Cell[12335, 412, 691, 26, 51, "Output",
 CellID->187563790]
}, Open  ]],
Cell[13041, 441, 124, 3, 70, "ExampleDelimiter",
 CellID->10551889],
Cell[13168, 446, 197, 7, 70, "ExampleText",
 CellID->5626557],
Cell[CellGroupData[{
Cell[13390, 457, 350, 12, 70, "Input",
 CellID->201828696],
Cell[13743, 471, 247, 9, 51, "Output",
 CellID->75423063]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14039, 486, 216, 7, 70, "ExampleSection",
 CellID->32705],
Cell[14258, 495, 59, 1, 70, "ExampleText",
 CellID->18799],
Cell[CellGroupData[{
Cell[14342, 500, 210, 7, 70, "Input",
 CellID->29442],
Cell[14555, 509, 181, 6, 51, "Output",
 CellID->576193068]
}, Open  ]],
Cell[14751, 518, 63, 1, 70, "ExampleText",
 CellID->10736],
Cell[CellGroupData[{
Cell[14839, 523, 238, 8, 70, "Input",
 CellID->30301],
Cell[15080, 533, 162, 5, 36, "Output",
 CellID->26254511]
}, Open  ]],
Cell[15257, 541, 125, 3, 70, "ExampleDelimiter",
 CellID->158140014],
Cell[15385, 546, 220, 7, 70, "ExampleText",
 CellID->126348940],
Cell[CellGroupData[{
Cell[15630, 557, 401, 14, 70, "Input",
 CellID->810597421],
Cell[16034, 573, 1942, 69, 83, "Output",
 CellID->500725846]
}, Open  ]],
Cell[CellGroupData[{
Cell[18013, 647, 192, 6, 70, "Input",
 CellID->139801040],
Cell[18208, 655, 965, 36, 52, "Output",
 CellID->47916232]
}, Open  ]],
Cell[CellGroupData[{
Cell[19210, 696, 192, 6, 70, "Input",
 CellID->218049521],
Cell[19405, 704, 965, 36, 52, "Output",
 CellID->27325373]
}, Open  ]],
Cell[20385, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->359275129],
Cell[20513, 748, 68, 1, 70, "ExampleText",
 CellID->188291280],
Cell[CellGroupData[{
Cell[20606, 753, 276, 9, 70, "Input",
 CellID->24927221],
Cell[20885, 764, 213, 6, 36, "Output",
 CellID->718583796]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21147, 776, 239, 7, 70, "ExampleSection",
 CellID->26162],
Cell[21389, 785, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[21625, 797, 570, 19, 70, "Input",
 CellID->19878761],
Cell[22198, 818, 483, 17, 36, "Output",
 CellID->69903739]
}, Open  ]],
Cell[CellGroupData[{
Cell[22718, 840, 133, 4, 70, "Input",
 CellID->235263230],
Cell[22854, 846, 583, 17, 51, "Output",
 CellID->240918784]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23486, 869, 232, 7, 70, "ExampleSection",
 CellID->9282],
Cell[23721, 878, 73, 1, 70, "ExampleText",
 CellID->180528295],
Cell[CellGroupData[{
Cell[23819, 883, 204, 7, 70, "Input",
 CellID->163004883],
Cell[24026, 892, 158, 5, 36, "Output",
 CellID->831338253]
}, Open  ]],
Cell[24199, 900, 125, 3, 70, "ExampleDelimiter",
 CellID->137012746],
Cell[24327, 905, 250, 9, 70, "ExampleText",
 CellID->7602946],
Cell[CellGroupData[{
Cell[24602, 918, 157, 5, 70, "Input",
 CellID->86545193],
Cell[24762, 925, 761, 16, 71, "Output",
 CellID->172147605]
}, Open  ]],
Cell[CellGroupData[{
Cell[25560, 946, 278, 9, 70, "Input",
 CellID->309913758],
Cell[25841, 957, 174, 5, 36, "Output",
 CellID->15239612]
}, Open  ]],
Cell[CellGroupData[{
Cell[26052, 967, 135, 4, 70, "Input",
 CellID->154126311],
Cell[26190, 973, 175, 5, 36, "Output",
 CellID->466921064]
}, Open  ]],
Cell[26380, 981, 125, 3, 70, "ExampleDelimiter",
 CellID->522029420],
Cell[26508, 986, 479, 17, 70, "ExampleText",
 CellID->372037111],
Cell[CellGroupData[{
Cell[27012, 1007, 238, 8, 70, "Input",
 CellID->157573493],
Cell[27253, 1017, 1316, 46, 83, "Output",
 CellID->318732447]
}, Open  ]],
Cell[CellGroupData[{
Cell[28606, 1068, 308, 10, 70, "Input",
 CellID->677980062],
Cell[28917, 1080, 1316, 46, 83, "Output",
 CellID->363549258]
}, Open  ]],
Cell[30248, 1129, 124, 3, 70, "ExampleDelimiter",
 CellID->97257252],
Cell[30375, 1134, 234, 7, 70, "ExampleText",
 CellID->22987128],
Cell[CellGroupData[{
Cell[30634, 1145, 158, 5, 70, "Input",
 CellID->451046271],
Cell[30795, 1152, 474, 12, 54, "Output",
 CellID->40382564]
}, Open  ]],
Cell[CellGroupData[{
Cell[31306, 1169, 106, 3, 70, "Input",
 CellID->81589366],
Cell[31415, 1174, 177, 5, 36, "Output",
 CellID->472978859]
}, Open  ]],
Cell[CellGroupData[{
Cell[31629, 1184, 300, 10, 70, "Input",
 CellID->454115601],
Cell[31932, 1196, 177, 5, 36, "Output",
 CellID->137126684]
}, Open  ]],
Cell[32124, 1204, 124, 3, 70, "ExampleDelimiter",
 CellID->59005910],
Cell[32251, 1209, 236, 7, 70, "ExampleText",
 CellID->143550462],
Cell[CellGroupData[{
Cell[32512, 1220, 158, 5, 70, "Input",
 CellID->713000587],
Cell[32673, 1227, 479, 12, 54, "Output",
 CellID->503872705]
}, Open  ]],
Cell[CellGroupData[{
Cell[33189, 1244, 107, 3, 70, "Input",
 CellID->114573746],
Cell[33299, 1249, 176, 5, 36, "Output",
 CellID->443387064]
}, Open  ]],
Cell[CellGroupData[{
Cell[33512, 1259, 250, 8, 70, "Input",
 CellID->83693251],
Cell[33765, 1269, 176, 5, 36, "Output",
 CellID->430769667]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34002, 1281, 310, 9, 70, "SeeAlsoSection",
 CellID->2792],
Cell[34315, 1292, 1451, 53, 70, "SeeAlso",
 CellID->24565]
}, Open  ]],
Cell[CellGroupData[{
Cell[35803, 1350, 314, 9, 70, "TutorialsSection",
 CellID->19606],
Cell[36120, 1361, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[36313, 1369, 299, 8, 70, "MoreAboutSection"],
Cell[36615, 1379, 153, 3, 70, "MoreAbout",
 CellID->2980856],
Cell[36771, 1384, 177, 3, 70, "MoreAbout",
 CellID->5581263],
Cell[36951, 1389, 151, 3, 70, "MoreAbout",
 CellID->596308363]
}, Open  ]],
Cell[37117, 1395, 27, 0, 70, "History"],
Cell[37147, 1397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

