(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17458,        598]
NotebookOptionsPosition[     13600,        470]
NotebookOutlinePosition[     14953,        507]
CellTagsIndexPosition[     14868,        502]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Raw Character Encodings" :> 
          Documentation`HelpLookup["paclet:tutorial/RawCharacterEncodings"], 
          "Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Raw Character Encodings\"\>", 
       2->"\<\"Files and Streams\"\>", 
       3->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CharacterEncodings" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncodings"], 
          "$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], 
          "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], 
          "$SystemCharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$SystemCharacterEncoding"], 
          "ShowSpecialCharacters" :> 
          Documentation`HelpLookup["paclet:ref/ShowSpecialCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$CharacterEncodings\"\>", 
       2->"\<\"$CharacterEncoding\"\>", 3->"\<\"ToCharacterCode\"\>", 
       4->"\<\"FromCharacterCode\"\>", 5->"\<\"StringReplace\"\>", 
       6->"\<\"$SystemCharacterEncoding\"\>", 
       7->"\<\"ShowSpecialCharacters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "International Character Sets" :> 
          Documentation`HelpLookup["paclet:guide/InternationalCharacterSets"],
           "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Font Options\"\>", 3->"\<\"International Character Sets\"\>", 
       4->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CharacterEncoding", "ObjectName",
 CellID->29911],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CharacterEncoding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
     "\[LineSeparator]is an option for input and output functions which \
specifies what raw character encoding should be used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"CharacterEncoding", ":>", 
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26956],

Cell[TextData[{
 "The possible settings for ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 " gives a list of all installed character encodings."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->42326806]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391502291],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->836757547],

Cell[TextData[{
 "Specify the character encoding used by ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1418059169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"\"\<\[CirclePlus]\>\"", ",", 
   RowBox[{"CharacterEncoding", "\[Rule]", " ", "\"\<ASCII\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2092612388],

Cell[BoxData["\<\"(+)\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820458281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"\"\<\[CirclePlus]\>\"", ",", 
   RowBox[{"CharacterEncoding", "\[Rule]", " ", "\"\<Symbol\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1544940322],

Cell[BoxData["\<\"\[CapitalARing]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->394105920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384433614],

Cell["Write a string to a file:", "ExampleText",
 CellID->1210516679],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<test\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46778304],

Cell[BoxData[
 RowBox[{"Put", "[", 
  RowBox[{"\"\<a b c\>\"", ",", "file"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1057947772],

Cell[TextData[{
 "Specify the character encoding to use by ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1749768543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"file", ",", " ", 
   RowBox[{
   "CharacterEncoding", " ", "\[Rule]", " ", "\"\<MacintoshRoman\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->273970707],

Cell[BoxData["\<\"a b c\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->453147548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"file", ",", " ", 
   RowBox[{"CharacterEncoding", " ", "\[Rule]", " ", "\"\<Symbol\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1643583075],

Cell[BoxData[
 RowBox[{"\[Beta]", " ", 
  RowBox[{"\[Chi]", "\[ForAll]"}], " ", 
  RowBox[{"\[ForAll]", "\[Alpha]"}]}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->337201334]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2873],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncodings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncodings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemCharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemCharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowSpecialCharacters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowSpecialCharacters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6872]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28446],

Cell[TextData[ButtonBox["Raw Character Encodings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RawCharacterEncodings"]], "Tutorials",
 CellID->30710],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->13834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->67739724],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->210558976],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->10100422],

Cell[TextData[ButtonBox["International Character Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InternationalCharacterSets"]], "MoreAbout",
 CellID->149255222],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->14694026]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CharacterEncoding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 8.1487374}", "context" -> "System`", 
    "keywords" -> {"file encoding", "font encodings", "character encoding"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CharacterEncoding is an option for input and output functions which \
specifies what raw character encoding should be used. ", 
    "synonyms" -> {"character encoding"}, "title" -> "CharacterEncoding", 
    "type" -> "Symbol", "uri" -> "ref/CharacterEncoding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6211, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->391502291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14725, 495}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3457, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4080, 102, 55, 1, 70, "ObjectName",
 CellID->29911],
Cell[4138, 105, 507, 14, 70, "Usage",
 CellID->18132]
}, Open  ]],
Cell[CellGroupData[{
Cell[4682, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5160, 141, 252, 9, 70, "Notes",
 CellID->26956],
Cell[5415, 152, 383, 13, 70, "Notes",
 CellID->10119],
Cell[5801, 167, 373, 10, 70, "Notes",
 CellID->42326806]
}, Closed]],
Cell[CellGroupData[{
Cell[6211, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391502291],
Cell[CellGroupData[{
Cell[6596, 196, 148, 5, 70, "ExampleSection",
 CellID->836757547],
Cell[6747, 203, 223, 8, 70, "ExampleText",
 CellID->1418059169],
Cell[CellGroupData[{
Cell[6995, 215, 214, 6, 28, "Input",
 CellID->2092612388],
Cell[7212, 223, 168, 5, 36, "Output",
 CellID->820458281]
}, Open  ]],
Cell[CellGroupData[{
Cell[7417, 233, 215, 6, 28, "Input",
 CellID->1544940322],
Cell[7635, 241, 180, 5, 36, "Output",
 CellID->394105920]
}, Open  ]],
Cell[7830, 249, 125, 3, 70, "ExampleDelimiter",
 CellID->384433614],
Cell[7958, 254, 69, 1, 70, "ExampleText",
 CellID->1210516679],
Cell[8030, 257, 204, 7, 70, "Input",
 CellID->46778304],
Cell[8237, 266, 138, 4, 70, "Input",
 CellID->1057947772],
Cell[8378, 272, 215, 8, 70, "ExampleText",
 CellID->1749768543],
Cell[CellGroupData[{
Cell[8618, 284, 214, 7, 70, "Input",
 CellID->273970707],
Cell[8835, 293, 170, 5, 36, "Output",
 CellID->453147548]
}, Open  ]],
Cell[CellGroupData[{
Cell[9042, 303, 203, 6, 70, "Input",
 CellID->1643583075],
Cell[9248, 311, 260, 8, 36, "Output",
 CellID->337201334]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9569, 326, 310, 9, 70, "SeeAlsoSection",
 CellID->2873],
Cell[9882, 337, 1817, 62, 70, "SeeAlso",
 CellID->6872]
}, Open  ]],
Cell[CellGroupData[{
Cell[11736, 404, 314, 9, 70, "TutorialsSection",
 CellID->28446],
Cell[12053, 415, 155, 3, 70, "Tutorials",
 CellID->30710],
Cell[12211, 420, 147, 3, 70, "Tutorials",
 CellID->478647659],
Cell[12361, 425, 191, 4, 70, "Tutorials",
 CellID->13834]
}, Open  ]],
Cell[CellGroupData[{
Cell[12589, 434, 318, 9, 70, "MoreAboutSection",
 CellID->67739724],
Cell[12910, 445, 151, 3, 70, "MoreAbout",
 CellID->210558976],
Cell[13064, 450, 134, 3, 70, "MoreAbout",
 CellID->10100422],
Cell[13201, 455, 166, 3, 70, "MoreAbout",
 CellID->149255222],
Cell[13370, 460, 158, 3, 70, "MoreAbout",
 CellID->14694026]
}, Open  ]],
Cell[13543, 466, 27, 0, 70, "History"],
Cell[13573, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

