(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33121,       1210]
NotebookOptionsPosition[     26124,        967]
NotebookOutlinePosition[     27492,       1005]
CellTagsIndexPosition[     27407,       1000]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Distributions\"\>", 
       2->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpectedValue\"\>", 
       2->"\<\"FourierTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CharacteristicFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CharacteristicFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the characteristic function for the symbolic \
distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     " as a function of the variable ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacteristicFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 " gives the expected value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
    "\[ImaginaryI]", "\[InvisibleSpace]", "t", "\[InvisibleSpace]", "x"}]], 
   TraditionalForm]], "InlineMath"],
 " for the distribution ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " assuming ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is real."
}], "Notes",
 CellID->8281]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139105692],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->211513],

Cell["Characteristic function for the normal distribution:", "ExampleText",
 CellID->370193392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617514039],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Mu]"}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["t", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "2"]}]]], "Output",
 ImageSize->{62, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8967917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225056149],

Cell["Characteristic function for the binomial distribution:", "ExampleText",
 CellID->19089492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53095017],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "-", "p", "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]], " ", "p"}]}], ")"}], 
  "n"]], "Output",
 ImageSize->{93, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47597162]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Characteristic function for a specific continuous distribution:\
\>", "ExampleText",
 CellID->437976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "5", "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65360855],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "3"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["5"]}], " ", 
    RowBox[{"Abs", "[", "t", "]"}]}]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox["3", 
     RowBox[{"5", " ", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "t", "]"}], "2"]}]], "+", 
    FractionBox["3", 
     RowBox[{
      SqrtBox["5"], " ", 
      RowBox[{"Abs", "[", "t", "]"}]}]]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Abs", "[", "t", "]"}], "2"]}]], "Output",
 ImageSize->{318, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423964259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47566687],

Cell["\<\
Characteristic function for a specific discrete distribution:\
\>", "ExampleText",
 CellID->639590443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459035472],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", "t"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"11", " ", "\[ImaginaryI]", " ", "t"}]]}], 
  RowBox[{"7", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}], ")"}]}]]], "Output",
 ImageSize->{87, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179211452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478896433],

Cell["Characteristic function at a particular value:", "ExampleText",
 CellID->7115789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "5", "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->726488762],

Cell[BoxData[
 FractionBox[
  RowBox[{"40", " ", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{
     FractionBox["5", "2"], ",", 
     RowBox[{"2", " ", 
      SqrtBox["5"]}]}], "]"}]}], 
  RowBox[{"3", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 ImageSize->{169, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53035434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->746580821],

Cell["Characteristic function evaluated numerically:", "ExampleText",
 CellID->256228408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "5", "]"}], ",", "2."}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->666123426],

Cell[BoxData["0.13866021913850426`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118984546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87245215],

Cell["Obtain a result at any precision:", "ExampleText",
 CellID->24585419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "5", "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"2", ",", "25"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4975145],

Cell[BoxData["0.13866021913850427728148494190305477042`24.070309678276892"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365422285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Compute the raw moments for a normal distribution:", "ExampleText",
 CellID->11341340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cfun", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "t"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->506989573],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Mu]"}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["t", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "2"]}]]], "Output",
 ImageSize->{62, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183637788]
}, Open  ]],

Cell["Here are the first 5 raw moments:", "ExampleText",
 CellID->64917987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"cfun", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "n"}], "}"}]}], "]"}], ",", 
      RowBox[{"t", "\[Rule]", "0"}]}], "]"}], "/", 
    RowBox[{"I", "^", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541493885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Mu]", ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], "+", 
    SuperscriptBox["\[Sigma]", "2"]}], ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "3"], "+", 
    RowBox[{"3", " ", "\[Mu]", " ", 
     SuperscriptBox["\[Sigma]", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "4"], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["\[Mu]", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["\[Sigma]", "4"]}]}], ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "5"], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["\[Mu]", "3"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{"15", " ", "\[Mu]", " ", 
     SuperscriptBox["\[Sigma]", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{386, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122601449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->746624680],

Cell["Compute the raw moments for a Poisson distribution:", "ExampleText",
 CellID->7394261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cfun", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40026066],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}], ")"}], " ", 
   "\[Mu]"}]]], "Output",
 ImageSize->{61, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106039649]
}, Open  ]],

Cell["Here are the first 5 raw moments:", "ExampleText",
 CellID->94938486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"cfun", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "n"}], "}"}]}], "]"}], ",", 
      RowBox[{"t", "\[Rule]", "0"}]}], "]"}], "/", 
    RowBox[{"I", "^", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154061081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Mu]", ",", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}], ",", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", " ", "\[Mu]"}], "+", 
      SuperscriptBox["\[Mu]", "2"]}], ")"}]}], ",", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"7", " ", "\[Mu]"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["\[Mu]", "2"]}], "+", 
      SuperscriptBox["\[Mu]", "3"]}], ")"}]}], ",", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"15", " ", "\[Mu]"}], "+", 
      RowBox[{"25", " ", 
       SuperscriptBox["\[Mu]", "2"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["\[Mu]", "3"]}], "+", 
      SuperscriptBox["\[Mu]", "4"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172771952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]tx"]], "InlineFormula"],
 " for real ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132165859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "t", " ", "x"}], "]"}], ",", 
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"t", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->707810790],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"max", "-", "min"}], ")"}], " ", "t"}]]}]], "Output",
 ImageSize->{129, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266511931]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10323416],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"max", "-", "min"}], ")"}], " ", "t"}]]}]], "Output",
 ImageSize->{129, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84454560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177923447],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " can be obtained from the first derivative:"
}], "ExampleText",
 CellID->80029151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cfun", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"BetaDistribution", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->997985090],

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"\[Alpha]", ",", 
   RowBox[{"\[Alpha]", "+", "\[Beta]"}], ",", 
   RowBox[{"\[ImaginaryI]", " ", "t"}]}], "]"}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350236887]
}, Open  ]],

Cell[TextData[{
 "The limit of the first derivative as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[ShortRightArrow]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " is \[ImaginaryI] times the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->861014448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"cfun", ",", "t"}], "]"}], ",", 
    RowBox[{"t", "\[Rule]", "0"}]}], "]"}], "/", "I"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226496591],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298151112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BetaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12636983],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->591337135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Symbolic closed forms do not exist for some distributions:", \
"ExampleText",
 CellID->414643541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20085134],

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "t"}], "]"}]], "Output",
 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70487785]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->31635605],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->109342228]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CharacteristicFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 8.6174994}", "context" -> "System`", 
    "keywords" -> {"cf", "moment generating function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CharacteristicFunction[dist, t] gives the characteristic function for \
the symbolic distribution dist as a function of the variable t.", 
    "synonyms" -> {"characteristic function"}, "title" -> 
    "CharacteristicFunction", "type" -> "Symbol", "uri" -> 
    "ref/CharacteristicFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6445, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->139105692]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27264, 993}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2213, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2836, 80, 1587, 37, 70, "ObjectNameGrid"],
Cell[4426, 119, 780, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5243, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5721, 165, 687, 24, 70, "Notes",
 CellID->8281]
}, Closed]],
Cell[CellGroupData[{
Cell[6445, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139105692],
Cell[CellGroupData[{
Cell[6830, 208, 145, 5, 70, "ExampleSection",
 CellID->211513],
Cell[6978, 215, 95, 1, 70, "ExampleText",
 CellID->370193392],
Cell[CellGroupData[{
Cell[7098, 220, 223, 6, 28, "Input",
 CellID->617514039],
Cell[7324, 228, 374, 12, 46, "Output",
 CellID->8967917]
}, Open  ]],
Cell[7713, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->225056149],
Cell[7841, 248, 96, 1, 70, "ExampleText",
 CellID->19089492],
Cell[CellGroupData[{
Cell[7962, 253, 213, 6, 70, "Input",
 CellID->53095017],
Cell[8178, 261, 345, 12, 41, "Output",
 CellID->47597162]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8572, 279, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8796, 288, 111, 3, 70, "ExampleText",
 CellID->437976],
Cell[CellGroupData[{
Cell[8932, 295, 191, 6, 70, "Input",
 CellID->65360855],
Cell[9126, 303, 674, 24, 59, "Output",
 CellID->423964259]
}, Open  ]],
Cell[9815, 330, 124, 3, 70, "ExampleDelimiter",
 CellID->47566687],
Cell[9942, 335, 112, 3, 70, "ExampleText",
 CellID->639590443],
Cell[CellGroupData[{
Cell[10079, 342, 248, 7, 70, "Input",
 CellID->459035472],
Cell[10330, 351, 568, 18, 62, "Output",
 CellID->179211452]
}, Open  ]],
Cell[10913, 372, 125, 3, 70, "ExampleDelimiter",
 CellID->478896433],
Cell[11041, 377, 87, 1, 70, "ExampleText",
 CellID->7115789],
Cell[CellGroupData[{
Cell[11153, 382, 192, 6, 70, "Input",
 CellID->726488762],
Cell[11348, 390, 428, 16, 65, "Output",
 CellID->53035434]
}, Open  ]],
Cell[11791, 409, 125, 3, 70, "ExampleDelimiter",
 CellID->746580821],
Cell[11919, 414, 89, 1, 70, "ExampleText",
 CellID->256228408],
Cell[CellGroupData[{
Cell[12033, 419, 193, 6, 70, "Input",
 CellID->666123426],
Cell[12229, 427, 177, 5, 36, "Output",
 CellID->118984546]
}, Open  ]],
Cell[12421, 435, 124, 3, 70, "ExampleDelimiter",
 CellID->87245215],
Cell[12548, 440, 75, 1, 70, "ExampleText",
 CellID->24585419],
Cell[CellGroupData[{
Cell[12648, 445, 242, 7, 70, "Input",
 CellID->4975145],
Cell[12893, 454, 219, 6, 36, "Output",
 CellID->365422285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13161, 466, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[13391, 475, 92, 1, 70, "ExampleText",
 CellID->11341340],
Cell[CellGroupData[{
Cell[13508, 480, 254, 8, 70, "Input",
 CellID->506989573],
Cell[13765, 490, 376, 12, 46, "Output",
 CellID->183637788]
}, Open  ]],
Cell[14156, 505, 75, 1, 70, "ExampleText",
 CellID->64917987],
Cell[CellGroupData[{
Cell[14256, 510, 437, 15, 70, "Input",
 CellID->541493885],
Cell[14696, 527, 914, 28, 39, "Output",
 CellID->122601449]
}, Open  ]],
Cell[15625, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->746624680],
Cell[15753, 563, 92, 1, 70, "ExampleText",
 CellID->7394261],
Cell[CellGroupData[{
Cell[15870, 568, 223, 7, 70, "Input",
 CellID->40026066],
Cell[16096, 577, 376, 13, 42, "Output",
 CellID->106039649]
}, Open  ]],
Cell[16487, 593, 75, 1, 70, "ExampleText",
 CellID->94938486],
Cell[CellGroupData[{
Cell[16587, 598, 437, 15, 70, "Input",
 CellID->154061081],
Cell[17027, 615, 990, 31, 39, "Output",
 CellID->172771952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18066, 652, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[18307, 661, 519, 18, 70, "ExampleText",
 CellID->132165859],
Cell[CellGroupData[{
Cell[18851, 683, 426, 12, 70, "Input",
 CellID->707810790],
Cell[19280, 697, 551, 17, 59, "Output",
 CellID->266511931]
}, Open  ]],
Cell[CellGroupData[{
Cell[19868, 719, 242, 7, 70, "Input",
 CellID->10323416],
Cell[20113, 728, 550, 17, 59, "Output",
 CellID->84454560]
}, Open  ]],
Cell[20678, 748, 125, 3, 70, "ExampleDelimiter",
 CellID->177923447],
Cell[20806, 753, 220, 8, 70, "ExampleText",
 CellID->80029151],
Cell[CellGroupData[{
Cell[21051, 765, 256, 8, 70, "Input",
 CellID->997985090],
Cell[21310, 775, 315, 9, 36, "Output",
 CellID->350236887]
}, Open  ]],
Cell[21640, 787, 353, 13, 70, "ExampleText",
 CellID->861014448],
Cell[CellGroupData[{
Cell[22018, 804, 238, 8, 70, "Input",
 CellID->226496591],
Cell[22259, 814, 221, 7, 51, "Output",
 CellID->298151112]
}, Open  ]],
Cell[CellGroupData[{
Cell[22517, 826, 179, 5, 70, "Input",
 CellID->12636983],
Cell[22699, 833, 221, 7, 51, "Output",
 CellID->591337135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22969, 846, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[23203, 855, 103, 2, 70, "ExampleText",
 CellID->414643541],
Cell[CellGroupData[{
Cell[23331, 861, 225, 6, 70, "Input",
 CellID->20085134],
Cell[23559, 869, 314, 9, 36, "Output",
 CellID->70487785]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23934, 885, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24253, 896, 481, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24771, 918, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[25092, 929, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[25248, 934, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[25442, 942, 299, 8, 70, "MoreAboutSection"],
Cell[25744, 952, 154, 3, 70, "MoreAbout",
 CellID->31635605],
Cell[25901, 957, 151, 3, 70, "MoreAbout",
 CellID->109342228]
}, Open  ]],
Cell[26067, 963, 27, 0, 70, "History"],
Cell[26097, 965, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

