(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51076,       1810]
NotebookOptionsPosition[     42542,       1509]
NotebookOutlinePosition[     44012,       1549]
CellTagsIndexPosition[     43926,       1544]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Matrix Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicMatrixOperations"], 
          "Eigenvalues and Eigenvectors" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EigenvaluesAndEigenvectors"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Matrix Operations\"\>", 
       2->"\<\"Eigenvalues and Eigenvectors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"], "Det" :> 
          Documentation`HelpLookup["paclet:ref/Det"], "Eigensystem" :> 
          Documentation`HelpLookup["paclet:ref/Eigensystem"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Eigenvalues\"\>", 2->"\<\"Det\"\>", 
       3->"\<\"Eigensystem\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CharacteristicPolynomial", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CharacteristicPolynomial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the characteristic polynomial for the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CharacteristicPolynomial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized characteristic polynomial with \
respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " must be a square matrix. "
}], "Notes",
 CellID->17753],

Cell["It can contain numeric or symbolic entries. ", "Notes",
 CellID->27158],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CharacteristicPolyonomial", "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is essentially equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "-", 
    RowBox[{
     StyleBox["id", "TI"], " ", 
     StyleBox["x", "TI"]}]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["id", "TI"]], "InlineFormula"],
 " is the identity matrix of appropriate size. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->82454211,
  ButtonNote->"82454211"]
}], "Notes",
 CellID->25550],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacteristicPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["a", "TI"]}], "}"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is essentially ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "-", 
    RowBox[{
     StyleBox["a", "TI"], " ", 
     StyleBox["x", "TI"]}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->7120196,
  ButtonNote->"7120196"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9037]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119748996],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->381753410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27921],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}], "-", 
  RowBox[{"a", " ", "x"}], "-", 
  RowBox[{"d", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6442],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}], "-", 
  RowBox[{"a", " ", "x"}], "-", 
  RowBox[{"d", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27758]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->84075132],

Cell["Use exact arithmetic to find the characteristic polynomial:", \
"ExampleText",
 CellID->2577646],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->513305758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{"m", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272725820],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "3"]}], "-", 
  FractionBox[
   RowBox[{"7", " ", "x"}], "3"], "+", 
  FractionBox[
   RowBox[{"9", " ", 
    SuperscriptBox["x", "2"]}], "2"], "-", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{121, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121466979]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->52662934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->65724262],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.33333333333333304`"}], "-", 
  RowBox[{"2.333333333333333`", " ", "x"}], "+", 
  RowBox[{"4.499999999999999`", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->575683316]
}, Open  ]],

Cell["\<\
Use 20\[Hyphen]digit precision arithmetic:\
\>", "ExampleText",
 CellID->258888944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"m", ",", "20"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14889764],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.33333333333333333333333333333416741463`19.522878745280337"}], "-", 
  RowBox[{"2.33333333333333333333333333334`19.545838230304785", " ", "x"}], 
  "+", 
  RowBox[{"4.50000000000000000000000000001`19.97813804399612", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{529, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99811401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403738886],

Cell["The characteristic polynomial of a complex matrix:", "ExampleText",
 CellID->31189420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "+", 
        RowBox[{"4", "I"}]}], ",", "5"}], "}"}]}], "}"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702989122],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"13", "-", 
    RowBox[{"6", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
  RowBox[{"6", " ", "z"}], "+", 
  SuperscriptBox["z", "2"]}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896093935]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5016],

Cell[TextData[{
 "The generalized characteristic polynomial ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{
      SubscriptBox["m", "1"], "-", 
      RowBox[{"x", " ", 
       SubscriptBox["m", "2"]}]}], "\[RightBracketingBar]"}],
    {Det}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1064173],

Cell[BoxData[
 RowBox[{
  RowBox[{"m1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"m2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m1", ",", "m2"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23083],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6"}], "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"m1", "-", 
   RowBox[{"x", " ", "m2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15204],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6"}], "+", 
  RowBox[{"7", " ", "x"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->70458129],

Cell["\<\
Find the eigenvalues of a matrix as the roots of the characteristic \
polynomial:\
\>", "ExampleText",
 CellID->357618187],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571822443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CharacteristicPolynomial", "[", 
     RowBox[{"m", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425820542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["33"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SqrtBox["33"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{316, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9376155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285208097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SqrtBox["33"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      SqrtBox["33"]}], ")"}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{205, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->385621306]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28673255],

Cell[TextData[{
 "The characteristic polynomial is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], " ", "-", " ", 
    RowBox[{
     StyleBox["id", "TI"], " ", 
     StyleBox["x", "TI"]}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82454211],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170037297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cp", "=", 
  RowBox[{"CharacteristicPolynomial", "[", 
   RowBox[{"m", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->400314263],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "282086184"}], "-", 
  RowBox[{"43342334", " ", "x"}], "-", 
  RowBox[{"8013292", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"788496", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"46497", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"82318", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"1247", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"1589", " ", 
   SuperscriptBox["x", "7"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"41", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53503886]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"m", "-", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", 
     RowBox[{"Length", "[", "m", "]"}], "]"}], " ", "x"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->34496482],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "282086184"}], "-", 
  RowBox[{"43342334", " ", "x"}], "-", 
  RowBox[{"8013292", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"788496", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"46497", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"82318", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"1247", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"1589", " ", 
   SuperscriptBox["x", "7"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"41", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->334980023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496534397],

Cell[TextData[{
 "The generalized characteristic polynomial is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], " ", "-", " ", 
    RowBox[{
     StyleBox["a", "TI"], " ", 
     StyleBox["x", "TI"]}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->345309268],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428898738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126459028],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "783"}], "+", 
  RowBox[{"79", " ", "x"}], "-", 
  RowBox[{"2671", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"16020", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"26327", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"9390", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3735115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"m", " ", "-", " ", 
   RowBox[{"a", " ", "x"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11419675],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "783"}], "+", 
  RowBox[{"79", " ", "x"}], "-", 
  RowBox[{"2671", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"16020", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"26327", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"9390", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105833979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->647695383],

Cell[TextData[{
 "A matrix is a root of its characteristic polynomial (Cayley\[Dash]Hamilton \
theorem [",
 ButtonBox["more...",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Cayley-HamiltonTheorem.html"], None}],
 "]):"
}], "ExampleText",
 CellID->96319633],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379405453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cp", "=", 
  RowBox[{"CharacteristicPolynomial", "[", 
   RowBox[{"m", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121730048],

Cell[BoxData[
 RowBox[{"3", "-", 
  RowBox[{"19", " ", "x"}], "+", 
  RowBox[{"31", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"42", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"59", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"40", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"13", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"17", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"19", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{408, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38747497]
}, Open  ]],

Cell[TextData[{
 "Evaluate the polynomial at ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with matrix arithmetic:"
}], "ExampleText",
 CellID->2602073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cl", "=", 
   RowBox[{"CoefficientList", "[", 
    RowBox[{"cp", ",", "x"}], "]"}]}], ";", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{"m", ",", 
       RowBox[{"j", "-", "1"}]}], "]"}], " ", 
     RowBox[{"cl", "[", 
      RowBox[{"[", "j", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", 
      RowBox[{"Length", "[", "cl", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->499495064],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm0tuwjAURZ0EBG1FobMOWU076qwbiFAlGFStKLto9+zGjgDpYWLzCQ7m
IAH+BPt9bqy8I/FWruYfn+VqMSunr8vye76Y/UxfvpbVUJEplf0qpd6fVdXW
Vcu+zeuvetfNuvVgPov1rFZ3oj8+c39y4u97on/vsf/U/dq2v7BZkF6Yfl51
J4HfTw3jcjczvm+/fescu5/0Nnd6a6wy3b4YH0QaH7a8vozKMDAebdvVlXi4
VWJH+5u+vUbZ3xrlDTo5O4ywr4ysuVqeis2xjGH1dcRyV6UysoVzrdFFRx9b
Wlfet6Mg39uyJq7vUg2ZDj+z0lCDjIB80nH7noYaws4G1IAaNr6jBtSw9R01
oIat7zsUxoya7jjwe+KZl7vKOj0PXOfY/dzUwzQljzq8BcGKa3/aBGu9X8/p
JeQqLB6Qq+7xlO7TFsjVeWNZn9QQK5/vaTx5us5C6o5brTvsXU/2yT7Zb/Cd
7JP91Hyvs586YbLqth2IEkQJonStBAWitHtuQpQgSvGtgigpx/0KUaKu8Pme
RvapKsk+2Sf7muyTfQ1ROqQFUYprP0QJouSLB0Spe5zjOigIROl8sYQoQZSo
K3y+p5F9qkqyT/bJvib7ZF9DlA5p+f5hB2G6rP113VIEeJkecfJ5DYEKi8dt
ESifaiBSYbMQqXZjWZ/suWMWQtXkexpPqm5CddzZlYYaqFu2vtZ1C2pADRo1
oAbU0BgR1OCjNrdNvFT2D0ZiP9Q=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{395, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->920922132]
}, Open  ]],

Cell["\<\
Use the more efficient Horner's method to evaluate the polynomial:\
\>", "ExampleText",
 CellID->410826963],

Cell[BoxData[
 RowBox[{
  RowBox[{"matrixhorner", "[", 
   RowBox[{"cl_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "cl", "]"}]}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "[", "m", "]"}]}], ",", "id", ",", "pm"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"id", "=", 
      RowBox[{"IdentityMatrix", "[", "k", "]"}]}], ";", "\[IndentingNewLine]",
      
     RowBox[{"pm", "=", 
      RowBox[{
       RowBox[{"cl", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], "id"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pm", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"cl", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "id"}], "+", 
         RowBox[{"m", ".", "pm"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"n", "-", "1"}], ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     "pm"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->308853425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matrixhorner", "[", 
  RowBox[{"cl", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->86478861],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm0tuwjAURZ0EBG1FobMOWU076qwbiFAlGFStKLto9+zGjgDpYWLzCQ7m
IAH+BPt9bqy8I/FWruYfn+VqMSunr8vye76Y/UxfvpbVUJEplf0qpd6fVdXW
Vcu+zeuvetfNuvVgPov1rFZ3oj8+c39y4u97on/vsf/U/dq2v7BZkF6Yfl51
J4HfTw3jcjczvm+/fescu5/0Nnd6a6wy3b4YH0QaH7a8vozKMDAebdvVlXi4
VWJH+5u+vUbZ3xrlDTo5O4ywr4ysuVqeis2xjGH1dcRyV6UysoVzrdFFRx9b
Wlfet6Mg39uyJq7vUg2ZDj+z0lCDjIB80nH7noYaws4G1IAaNr6jBtSw9R01
oIat7zsUxoya7jjwe+KZl7vKOj0PXOfY/dzUwzQljzq8BcGKa3/aBGu9X8/p
JeQqLB6Qq+7xlO7TFsjVeWNZn9QQK5/vaTx5us5C6o5brTvsXU/2yT7Zb/Cd
7JP91Hyvs586YbLqth2IEkQJonStBAWitHtuQpQgSvGtgigpx/0KUaKu8Pme
RvapKsk+2Sf7muyTfQ1ROqQFUYprP0QJouSLB0Spe5zjOigIROl8sYQoQZSo
K3y+p5F9qkqyT/bJvib7ZF9DlA5p+f5hB2G6rP113VIEeJkecfJ5DYEKi8dt
ESifaiBSYbMQqXZjWZ/suWMWQtXkexpPqm5CddzZlYYaqFu2vtZ1C2pADRo1
oAbU0BgR1OCjNrdNvFT2D0ZiP9Q=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{395, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->192711492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651712974],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Product]", 
     RowBox[{"i", "=", "1"}], "n"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["v", "i"], "-", "x"}], ")"}]}], TraditionalForm]]],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"],
 " are the eigenvalues is equivalent to the characteristic polynomial:"
}], "ExampleText",
 CellID->438501127],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->711269829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Eigenvalues", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->189693011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.1743171049369305`", ",", 
   RowBox[{"-", "0.9462794843677781`"}], ",", 
   RowBox[{
    RowBox[{"-", "0.09745565990258184`"}], "+", 
    RowBox[{"0.8570776339662095`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.09745565990258184`"}], "-", 
    RowBox[{"0.8570776339662095`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "0.5192046477108457`"}], ",", 
   RowBox[{"0.40592102044108846`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.22306664733649048`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.40592102044108846`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.22306664733649048`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.07028942295275709`"}], "+", 
    RowBox[{"0.45652652031696883`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.07028942295275709`"}], "-", 
    RowBox[{"0.45652652031696883`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "0.17378420211325835`"}]}], "}"}]], "Output",
 ImageSize->{465, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15577501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"v", "-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->435540497],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "0.9462794843677781`"}], "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "0.5192046477108457`"}], "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "0.17378420211325835`"}], "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.09745565990258184`"}], "-", 
      RowBox[{"0.8570776339662095`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.09745565990258184`"}], "+", 
      RowBox[{"0.8570776339662095`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.07028942295275709`"}], "-", 
      RowBox[{"0.45652652031696883`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.07028942295275709`"}], "+", 
      RowBox[{"0.45652652031696883`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.40592102044108846`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.22306664733649048`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.40592102044108846`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.22306664733649048`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5.1743171049369305`", "\[InvisibleSpace]", "-", "x"}], 
   ")"}]}]], "Output",
 ImageSize->{467, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25930030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{"%", "-", 
    RowBox[{"CharacteristicPolynomial", "[", 
     RowBox[{"m", ",", "x"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->628575415],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->211394743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396641652],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is a monic polynomial, then the characteristic polynomial of its companion \
matrix is",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"p", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->48958252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"9", ",", "10"}], "]"}], ".", 
    RowBox[{"x", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "9"}], "]"}]}]}], "+", 
   RowBox[{"x", "^", "10"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34231568],

Cell[BoxData[
 RowBox[{"6", "+", "x", "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"], "+", 
  SuperscriptBox["x", "7"], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83242507]
}, Open  ]],

Cell["Form the companion matrix:", "ExampleText",
 CellID->275923145],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cl", "=", 
   RowBox[{"CoefficientList", "[", 
    RowBox[{"p", ",", "x"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{
    RowBox[{"Length", "[", "cl", "]"}], "-", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cm", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "n"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"-", 
         RowBox[{"cl", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->641364277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "cm", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->835894994],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnD1z2jAYgIUNIU3SpZBex/yaduqP4HK9S4Zec2kGNkZGhg4e6ZyF0SMj
IyMjIyMjoypZFhYvxvW3X1nKHcjWKZjn1cdjKY6+j96efvwcvT0/jh6+vY5e
np4ffz98/fXKstwOIeSdvf58IeyYsqPg9U4pS9X3Hn935/M5DX6Iy95cVvQu
Z3rL0h5Lh8GH8WuKz70KzieTiXIdQrrB4Waz8X3/mNs7/lZQhpAbtLl3gDKe
mkV3vV5Das/z1Fig5EtHzUvxQlcgX7Stw+EwHo8jelfmigCIaKDkTEd/D85F
FKbTKUPkh86R2lmtVj0EBOXTsu7LOvEpbdDCd7sdbUEdfwbnomVH45ZKHY1x
ulN/ii3Vp2H/FdK4wM4jVMQjPHWI8Aj/Ctf0dMzsxF71Lzg3t1Te+Et/34bn
wzD9kOqqeFt8nLPOS8W3+Gsj2KXF+6A0vHNrJz0c4c2gHlCTevcAlLLUl6mL
+Jt7+yON/NElacdQrDbF72/obZk/oOr9kw5tPb2tznPh/NsMamnunpH0Zta5
pbbUydR5DK6aW+YPw/ybVFfF6lO8Br9kbh0MXtRaevbw8ql1Mritc0ttqeug
zmLwOHNbg1dr8P+ZW41/86ts1VjrPBfjGnpd7NLj8X/RNyMGJtc/jvV0W9O4
2dN4Pcnn+byC1bJ4vJ7W503NzOu0GLbe3iy79HoXfIu6xvlm6ZuaszVLDZ90
6xtB3dRzEPqObUk2T2Nxa/NybZ7V4tXP0pt3V3M2x8gubV79k24Y6asf4TFS
Vzczx0pb7X1qe6jj/J3F26o/7JNu+f2d19tl+htjq67L3/qwS3+Xv8quTwxM
rn/O3jWrp8Nv2nrq4i7P43CZ3oepdXm2UrzVFXF4vpV1+H/HGNpv9eurulNL
i+d75k13ejPr3FJb6mRqPhoUMbe5z7zNZrMUpaKdXtRSnuft93sZ/yJxh7Nx
Uevb7XaxWPBDdbcA3/fDfVEw/IdGVXMyscq8XC5jdshgQQ/j0o4IJM/MRSRY
Oz3ZGUX33XCyt4WoT0YRcFhPaEcbkLNzzuqw1h1QhXd5US07CL5p+XNzuEuJ
q7CLrXDaww5n6H1AKdiLzgThjDxYwQj3LiOdf46g9EQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{170, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->4094926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CharacteristicPolynomial", "[", 
   RowBox[{"cm", ",", "x"}], "]"}], "\[Equal]", "p"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69497985],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->46810229]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19289],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29072],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->26739],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "Tutorials",
 CellID->1781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->56971425],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->329767107]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CharacteristicPolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 10.5394236}", "context" -> "System`", 
    "keywords" -> {
     "Cayley-Hamilton", "characteristic roots", "matrix polynomial"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CharacteristicPolynomial[m, x] gives the characteristic polynomial for \
the matrix m. CharacteristicPolynomial[{m, a}, x] gives the generalized \
characteristic polynomial with respect to a. ", 
    "synonyms" -> {"characteristic polynomial"}, "title" -> 
    "CharacteristicPolynomial", "type" -> "Symbol", "uri" -> 
    "ref/CharacteristicPolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10554, 298, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->119748996]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43782, 1537}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 78, 4208, 83, 70, "ObjectNameGrid"],
Cell[6947, 163, 1229, 38, 70, "Usage",
 CellID->21763]
}, Open  ]],
Cell[CellGroupData[{
Cell[8213, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8691, 223, 131, 5, 70, "Notes",
 CellID->17753],
Cell[8825, 230, 77, 1, 70, "Notes",
 CellID->27158],
Cell[8905, 233, 721, 26, 70, "Notes",
 CellID->25550],
Cell[9629, 261, 888, 32, 70, "Notes",
 CellID->9037]
}, Closed]],
Cell[CellGroupData[{
Cell[10554, 298, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119748996],
Cell[CellGroupData[{
Cell[10939, 312, 148, 5, 70, "ExampleSection",
 CellID->381753410],
Cell[CellGroupData[{
Cell[11112, 321, 294, 10, 28, "Input",
 CellID->27921],
Cell[11409, 333, 342, 12, 36, "Output",
 CellID->26307]
}, Open  ]],
Cell[CellGroupData[{
Cell[11788, 350, 339, 12, 28, "Input",
 CellID->6442],
Cell[12130, 364, 342, 12, 36, "Output",
 CellID->27758]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12521, 382, 219, 7, 70, "ExampleSection",
 CellID->84075132],
Cell[12743, 391, 102, 2, 70, "ExampleText",
 CellID->2577646],
Cell[12848, 395, 414, 14, 70, "Input",
 CellID->513305758],
Cell[CellGroupData[{
Cell[13287, 413, 143, 4, 70, "Input",
 CellID->272725820],
Cell[13433, 419, 381, 14, 54, "Output",
 CellID->121466979]
}, Open  ]],
Cell[13829, 436, 65, 1, 70, "ExampleText",
 CellID->52662934],
Cell[CellGroupData[{
Cell[13919, 441, 171, 5, 70, "Input",
 CellID->65724262],
Cell[14093, 448, 367, 11, 36, "Output",
 CellID->575683316]
}, Open  ]],
Cell[14475, 462, 93, 3, 70, "ExampleText",
 CellID->258888944],
Cell[CellGroupData[{
Cell[14593, 469, 197, 6, 70, "Input",
 CellID->14889764],
Cell[14793, 477, 474, 13, 36, "Output",
 CellID->99811401]
}, Open  ]],
Cell[15282, 493, 125, 3, 70, "ExampleDelimiter",
 CellID->403738886],
Cell[15410, 498, 92, 1, 70, "ExampleText",
 CellID->31189420],
Cell[CellGroupData[{
Cell[15527, 503, 376, 14, 70, "Input",
 CellID->702989122],
Cell[15906, 519, 323, 11, 36, "Output",
 CellID->896093935]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16278, 536, 238, 7, 70, "ExampleSection",
 CellID->5016],
Cell[16519, 545, 361, 13, 70, "ExampleText",
 CellID->1064173],
Cell[16883, 560, 451, 17, 70, "Input",
 CellID->29449],
Cell[CellGroupData[{
Cell[17359, 581, 190, 6, 70, "Input",
 CellID->23083],
Cell[17552, 589, 275, 10, 36, "Output",
 CellID->18386]
}, Open  ]],
Cell[CellGroupData[{
Cell[17864, 604, 144, 5, 70, "Input",
 CellID->15204],
Cell[18011, 611, 275, 10, 36, "Output",
 CellID->31242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18335, 627, 226, 7, 70, "ExampleSection",
 CellID->70458129],
Cell[18564, 636, 132, 4, 70, "ExampleText",
 CellID->357618187],
Cell[18699, 642, 358, 12, 70, "Input",
 CellID->571822443],
Cell[CellGroupData[{
Cell[19082, 658, 237, 8, 70, "Input",
 CellID->425820542],
Cell[19322, 668, 627, 23, 51, "Output",
 CellID->9376155]
}, Open  ]],
Cell[CellGroupData[{
Cell[19986, 696, 107, 3, 70, "Input",
 CellID->285208097],
Cell[20096, 701, 444, 17, 51, "Output",
 CellID->385621306]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20589, 724, 236, 7, 70, "ExampleSection",
 CellID->28673255],
Cell[20828, 733, 375, 14, 70, "ExampleText",
 CellID->82454211],
Cell[21206, 749, 231, 8, 70, "Input",
 CellID->170037297],
Cell[CellGroupData[{
Cell[21462, 761, 168, 5, 70, "Input",
 CellID->400314263],
Cell[21633, 768, 761, 25, 54, "Output",
 CellID->53503886]
}, Open  ]],
Cell[CellGroupData[{
Cell[22431, 798, 224, 7, 70, "Input",
 CellID->34496482],
Cell[22658, 807, 762, 25, 54, "Output",
 CellID->334980023]
}, Open  ]],
Cell[23435, 835, 125, 3, 70, "ExampleDelimiter",
 CellID->496534397],
Cell[23563, 840, 387, 14, 70, "ExampleText",
 CellID->345309268],
Cell[23953, 856, 298, 10, 70, "Input",
 CellID->428898738],
Cell[CellGroupData[{
Cell[24276, 870, 192, 6, 70, "Input",
 CellID->126459028],
Cell[24471, 878, 469, 16, 36, "Output",
 CellID->3735115]
}, Open  ]],
Cell[CellGroupData[{
Cell[24977, 899, 155, 5, 70, "Input",
 CellID->11419675],
Cell[25135, 906, 471, 16, 36, "Output",
 CellID->105833979]
}, Open  ]],
Cell[25621, 925, 125, 3, 70, "ExampleDelimiter",
 CellID->647695383],
Cell[25749, 930, 292, 9, 70, "ExampleText",
 CellID->96319633],
Cell[26044, 941, 231, 8, 70, "Input",
 CellID->379405453],
Cell[CellGroupData[{
Cell[26300, 953, 168, 5, 70, "Input",
 CellID->121730048],
Cell[26471, 960, 710, 24, 36, "Output",
 CellID->38747497]
}, Open  ]],
Cell[27196, 987, 169, 6, 70, "ExampleText",
 CellID->2602073],
Cell[CellGroupData[{
Cell[27390, 997, 518, 17, 70, "Input",
 CellID->499495064],
Cell[27911, 1016, 972, 20, 70, "Output",
 Evaluatable->False,
 CellID->920922132]
}, Open  ]],
Cell[28898, 1039, 117, 3, 70, "ExampleText",
 CellID->410826963],
Cell[29018, 1044, 1212, 37, 70, "Input",
 CellID->308853425],
Cell[CellGroupData[{
Cell[30255, 1085, 131, 4, 70, "Input",
 CellID->86478861],
Cell[30389, 1091, 972, 20, 70, "Output",
 Evaluatable->False,
 CellID->192711492]
}, Open  ]],
Cell[31376, 1114, 125, 3, 70, "ExampleDelimiter",
 CellID->651712974],
Cell[31504, 1119, 441, 15, 70, "ExampleText",
 CellID->438501127],
Cell[31948, 1136, 233, 8, 70, "Input",
 CellID->711269829],
Cell[CellGroupData[{
Cell[32206, 1148, 130, 4, 70, "Input",
 CellID->189693011],
Cell[32339, 1154, 1127, 26, 71, "Output",
 CellID->15577501]
}, Open  ]],
Cell[CellGroupData[{
Cell[33503, 1185, 152, 5, 70, "Input",
 CellID->435540497],
Cell[33658, 1192, 1814, 58, 88, "Output",
 CellID->25930030]
}, Open  ]],
Cell[CellGroupData[{
Cell[35509, 1255, 236, 7, 70, "Input",
 CellID->628575415],
Cell[35748, 1264, 158, 5, 36, "Output",
 CellID->211394743]
}, Open  ]],
Cell[35921, 1272, 125, 3, 70, "ExampleDelimiter",
 CellID->396641652],
Cell[36049, 1277, 364, 13, 70, "ExampleText",
 CellID->48958252],
Cell[CellGroupData[{
Cell[36438, 1294, 319, 11, 70, "Input",
 CellID->34231568],
Cell[36760, 1307, 631, 21, 36, "Output",
 CellID->83242507]
}, Open  ]],
Cell[37406, 1331, 69, 1, 70, "ExampleText",
 CellID->275923145],
Cell[37478, 1334, 844, 29, 70, "Input",
 CellID->641364277],
Cell[CellGroupData[{
Cell[38347, 1367, 107, 3, 70, "Input",
 CellID->835894994],
Cell[38457, 1372, 1365, 26, 70, "Output",
 Evaluatable->False,
 CellID->4094926]
}, Open  ]],
Cell[CellGroupData[{
Cell[39859, 1403, 174, 5, 70, "Input",
 CellID->69497985],
Cell[40036, 1410, 160, 5, 36, "Output",
 CellID->46810229]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40257, 1422, 311, 9, 70, "SeeAlsoSection",
 CellID->19289],
Cell[40571, 1433, 697, 26, 70, "SeeAlso",
 CellID->7358]
}, Open  ]],
Cell[CellGroupData[{
Cell[41305, 1464, 314, 9, 70, "TutorialsSection",
 CellID->29072],
Cell[41622, 1475, 155, 3, 70, "Tutorials",
 CellID->26739],
Cell[41780, 1480, 164, 3, 70, "Tutorials",
 CellID->1781]
}, Open  ]],
Cell[CellGroupData[{
Cell[41981, 1488, 318, 9, 70, "MoreAboutSection",
 CellID->56971425],
Cell[42302, 1499, 145, 3, 70, "MoreAbout",
 CellID->329767107]
}, Open  ]],
Cell[42462, 1505, 50, 0, 70, "History"],
Cell[42515, 1507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

