(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30147,       1117]
NotebookOptionsPosition[     23862,        898]
NotebookOutlinePosition[     25179,        935]
CellTagsIndexPosition[     25094,        930]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ManhattanDistance" :> 
          Documentation`HelpLookup["paclet:ref/ManhattanDistance"], 
          "EuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/EuclideanDistance"], 
          "SquaredEuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/SquaredEuclideanDistance"], 
          "BrayCurtisDistance" :> 
          Documentation`HelpLookup["paclet:ref/BrayCurtisDistance"], 
          "CanberraDistance" :> 
          Documentation`HelpLookup["paclet:ref/CanberraDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ManhattanDistance\"\>", 
       2->"\<\"EuclideanDistance\"\>", 3->"\<\"SquaredEuclideanDistance\"\>", 
       4->"\<\"BrayCurtisDistance\"\>", 
       5->"\<\"CanberraDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ChebyshevDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChebyshevDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChebyshevDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Chebyshev or sup norm distance between \
vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChebyshevDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    RowBox[{
     StyleBox["u", "TI"], "-", 
     StyleBox["v", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->709349618,
  ButtonNote->"709349618"]
}], "Notes",
 CellID->24221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55028006],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->546227501],

Cell["The Chebyshev distance between two vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196650888],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109459983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125461358],

Cell["Chebyshev distance between numeric vectors:", "ExampleText",
 CellID->319587507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190454384],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703092355]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4954],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["4.782886634862714`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89577656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any precision:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10"}], "}"}], ",", 
     "50"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "15", ",", "20", ",", "5", ",", "5"}], "}"}], ",", 
     "50"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["18.`49.39794000867204"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147270926]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20615],

Cell["Cluster data using Chebyshev distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "ChebyshevDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->842724580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124651963],

Cell["Demonstrate the triangle inequality:", "ExampleText",
 CellID->162085005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"ChebyshevDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395493032],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"0", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "c"}], "]"}]}], "]"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48131924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", "=", 
  RowBox[{"ChebyshevDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13424126],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"0", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->756073102]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3", "=", 
  RowBox[{"ChebyshevDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "c"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51893016],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "c"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->196760969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"d3", "<=", 
   RowBox[{"d1", "+", "d2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->175054461],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->903679578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10904],

Cell["Chebyshev distance is the maximum of absolute differences:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->709349618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418619957],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13513885]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->290219153],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73256189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533993557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFormula"],
 " is equivalent to a ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 " of a difference:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->214729278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218507111],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72791558]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21346996],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159558952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263875481],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->581795014],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->625730726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ChebyshevDistance", "[", 
    RowBox[{"u", ",", "v"}], "]"}], "\[LessEqual]", 
   RowBox[{"ManhattanDistance", "[", 
    RowBox[{"u", ",", "v"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196694015],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531244965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127771885],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->113594664],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->184437764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ChebyshevDistance", "[", 
    RowBox[{"u", ",", "v"}], "]"}], "\[LessEqual]", 
   RowBox[{"EuclideanDistance", "[", 
    RowBox[{"u", ",", "v"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134208343],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519059947]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31163],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ManhattanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ManhattanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SquaredEuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquaredEuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BrayCurtisDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BrayCurtisDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CanberraDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CanberraDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19019],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ChebyshevDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ChebyshevDistance"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->10214366]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChebyshevDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 12.4925986}", "context" -> "System`", 
    "keywords" -> {"Chebyshev distance", "max distance", "sup distance"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ChebyshevDistance[u, v] gives the Chebyshev or sup norm distance between \
vectors u and v.", "synonyms" -> {"chebyshev distance"}, "title" -> 
    "ChebyshevDistance", "type" -> "Symbol", "uri" -> 
    "ref/ChebyshevDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6661, 204, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55028006]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24952, 923}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2438, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3061, 86, 1582, 37, 70, "ObjectNameGrid"],
Cell[4646, 125, 727, 24, 70, "Usage",
 CellID->13722]
}, Open  ]],
Cell[CellGroupData[{
Cell[5410, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5888, 171, 736, 28, 70, "Notes",
 CellID->24221]
}, Closed]],
Cell[CellGroupData[{
Cell[6661, 204, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55028006],
Cell[CellGroupData[{
Cell[7045, 218, 148, 5, 70, "ExampleSection",
 CellID->546227501],
Cell[7196, 225, 86, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[7307, 230, 254, 8, 28, "Input",
 CellID->196650888],
Cell[7564, 240, 389, 13, 36, "Output",
 CellID->109459983]
}, Open  ]],
Cell[7968, 256, 125, 3, 70, "ExampleDelimiter",
 CellID->125461358],
Cell[8096, 261, 86, 1, 70, "ExampleText",
 CellID->319587507],
Cell[CellGroupData[{
Cell[8207, 266, 254, 8, 70, "Input",
 CellID->190454384],
Cell[8464, 276, 158, 5, 36, "Output",
 CellID->703092355]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8671, 287, 215, 7, 70, "ExampleSection",
 CellID->4954],
Cell[8889, 296, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9009, 301, 266, 8, 70, "Input",
 CellID->488208944],
Cell[9278, 311, 174, 5, 36, "Output",
 CellID->89577656]
}, Open  ]],
Cell[9467, 319, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[9595, 324, 92, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[9712, 329, 427, 14, 70, "Input",
 CellID->323525768],
Cell[10142, 345, 179, 5, 36, "Output",
 CellID->147270926]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10370, 356, 223, 7, 70, "ExampleSection",
 CellID->20615],
Cell[10596, 365, 81, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[10702, 370, 477, 16, 70, "Input",
 CellID->108189764],
Cell[11182, 388, 498, 18, 36, "Output",
 CellID->842724580]
}, Open  ]],
Cell[11695, 409, 125, 3, 70, "ExampleDelimiter",
 CellID->124651963],
Cell[11823, 414, 79, 1, 70, "ExampleText",
 CellID->162085005],
Cell[CellGroupData[{
Cell[11927, 419, 263, 9, 70, "Input",
 CellID->395493032],
Cell[12193, 430, 266, 9, 36, "Output",
 CellID->48131924]
}, Open  ]],
Cell[CellGroupData[{
Cell[12496, 444, 262, 9, 70, "Input",
 CellID->13424126],
Cell[12761, 455, 267, 9, 36, "Output",
 CellID->756073102]
}, Open  ]],
Cell[CellGroupData[{
Cell[13065, 469, 262, 9, 70, "Input",
 CellID->51893016],
Cell[13330, 480, 323, 11, 36, "Output",
 CellID->196760969]
}, Open  ]],
Cell[CellGroupData[{
Cell[13690, 496, 155, 5, 70, "Input",
 CellID->175054461],
Cell[13848, 503, 161, 5, 36, "Output",
 CellID->903679578]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14058, 514, 233, 7, 70, "ExampleSection",
 CellID->10904],
Cell[14294, 523, 151, 3, 70, "ExampleText",
 CellID->709349618],
Cell[CellGroupData[{
Cell[14470, 530, 254, 8, 70, "Input",
 CellID->418619957],
Cell[14727, 540, 388, 13, 36, "Output",
 CellID->13513885]
}, Open  ]],
Cell[CellGroupData[{
Cell[15152, 558, 275, 9, 70, "Input",
 CellID->290219153],
Cell[15430, 569, 388, 13, 36, "Output",
 CellID->73256189]
}, Open  ]],
Cell[15833, 585, 125, 3, 70, "ExampleDelimiter",
 CellID->533993557],
Cell[15961, 590, 396, 13, 70, "ExampleText",
 CellID->214729278],
Cell[CellGroupData[{
Cell[16382, 607, 254, 8, 70, "Input",
 CellID->218507111],
Cell[16639, 617, 388, 13, 36, "Output",
 CellID->72791558]
}, Open  ]],
Cell[CellGroupData[{
Cell[17064, 635, 278, 10, 70, "Input",
 CellID->21346996],
Cell[17345, 647, 389, 13, 36, "Output",
 CellID->159558952]
}, Open  ]],
Cell[17749, 663, 125, 3, 70, "ExampleDelimiter",
 CellID->263875481],
Cell[17877, 668, 412, 13, 70, "ExampleText",
 CellID->581795014],
Cell[18292, 683, 281, 10, 70, "Input",
 CellID->625730726],
Cell[CellGroupData[{
Cell[18598, 697, 278, 8, 70, "Input",
 CellID->196694015],
Cell[18879, 707, 161, 5, 36, "Output",
 CellID->531244965]
}, Open  ]],
Cell[19055, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->127771885],
Cell[19183, 720, 412, 13, 70, "ExampleText",
 CellID->113594664],
Cell[19598, 735, 281, 10, 70, "Input",
 CellID->184437764],
Cell[CellGroupData[{
Cell[19904, 749, 278, 8, 70, "Input",
 CellID->134208343],
Cell[20185, 759, 161, 5, 36, "Output",
 CellID->519059947]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20407, 771, 311, 9, 70, "SeeAlsoSection",
 CellID->31163],
Cell[20721, 782, 1290, 44, 70, "SeeAlso",
 CellID->32525]
}, Open  ]],
Cell[CellGroupData[{
Cell[22048, 831, 314, 9, 70, "TutorialsSection",
 CellID->19019],
Cell[22365, 842, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[22572, 850, 305, 8, 70, "RelatedLinksSection"],
Cell[22880, 860, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23293, 877, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[23612, 888, 178, 3, 70, "MoreAbout",
 CellID->10214366]
}, Open  ]],
Cell[23805, 894, 27, 0, 70, "History"],
Cell[23835, 896, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

