(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58452,       1741]
NotebookOptionsPosition[     50584,       1463]
NotebookOutlinePosition[     51932,       1501]
CellTagsIndexPosition[     51846,       1496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChebyshevU" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevU"], "GegenbauerC" :> 
          Documentation`HelpLookup["paclet:ref/GegenbauerC"], "JacobiP" :> 
          Documentation`HelpLookup["paclet:ref/JacobiP"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChebyshevU\"\>", 2->"\<\"GegenbauerC\"\>", 
       3->"\<\"JacobiP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChebyshevT", "ObjectName",
 CellID->16689],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChebyshevT",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChebyshevT"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Chebyshev polynomial of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit polynomials are given for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15578],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["T", "n"], "(", 
     RowBox[{"cos", "\[Theta]"}], ")"}], "=", 
    RowBox[{"cos", "(", 
     RowBox[{"n", "\[Theta]"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29626],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->520040650],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChebyshevT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevT"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->340]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18009979],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->106190177],

Cell[TextData[{
 "Compute the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "th"], TraditionalForm]]],
 " Chebyshev polynomial:"
}], "ExampleText",
 CellID->3572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"10", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15820],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"50", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"400", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"1120", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"1280", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"512", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180050029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11107],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{228, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{228., Automatic}},
 CellLabel->"Out[1]=",
 CellID->101900090]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30121],

Cell["Evaluate for complex arguments and orders:", "ExampleText",
 CellID->4834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{
   RowBox[{"3.", "+", "I"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13992],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.5829646840408247`"}], "+", 
  RowBox[{"0.8203751305281329`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37563401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559642203],

Cell["Evaluate for large orders:", "ExampleText",
 CellID->466028784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevT", "[", 
   RowBox[{
    RowBox[{"10", "^", "5"}], ",", "2"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210837820],

Cell[BoxData[
 TagBox[
  RowBox[{"2842649670148219244483410083080808", 
   RowBox[{"\[LeftSkeleton]", "57126", "\[RightSkeleton]"}], 
   "57445799950917036827057803943335937"}],
  Short]], "Output",
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->495398940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13131],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->16499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"10", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25812],

Cell[BoxData["0.\
9672136700028789649274331487408762214432081830344290335145387728835`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104922831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25420],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->18595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{157, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401875547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5623],

Cell["\<\
Simple cases give exact symbolic results even for arbitrary order:\
\>", "ExampleText",
 CellID->22065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"n", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15219],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  FractionBox[
   RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555873473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196312657],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->104874190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307199659],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->374199318]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10912],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->17271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27167],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SqrtBox["3"], "2"], "+", 
   FractionBox["x", "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"12", " ", 
     SqrtBox["3"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {Rational[1, 2] 3^Rational[1, 2], 
    Rational[1, 6], Rational[-1, 12] 3^Rational[-1, 2]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{160, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160325845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21049],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " can be applied to ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"10", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8001],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1681"}], ",", "1681"}], "}"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194986570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12390],

Cell["Plot the first 10 Chebyshev polynomials:", "ExampleText",
 CellID->2208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ChebyshevT", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15846],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->117126792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21361],

Cell[TextData[{
 "Find a minimax approximation to the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"], "[", 
   RowBox[{"4", " ", "x"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     FractionBox["2", "\[Pi]"], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "1"}], "1"], 
      RowBox[{
       RowBox[{"Clip", "[", 
        RowBox[{"4", " ", "x"}], "]"}], 
       FractionBox[
        RowBox[{"ChebyshevT", "[", 
         RowBox[{"n", ",", "x"}], "]"}], 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10732],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{
     SqrtBox["15"], "+", 
     RowBox[{"16", " ", 
      RowBox[{"ArcSin", "[", 
       FractionBox["1", "4"], "]"}]}]}], 
    RowBox[{"2", " ", "\[Pi]"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", 
      SqrtBox["15"]}], 
     RowBox[{"16", " ", "\[Pi]"}]]}], ",", "0", ",", 
   FractionBox[
    RowBox[{"5", " ", 
     SqrtBox["15"]}], 
    RowBox[{"32", " ", "\[Pi]"}]]}], "}"}]], "Output",
 ImageSize->{324, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391107234]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Clip", "[", 
      RowBox[{"4", " ", "x"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"First", "[", "c", "]"}]}], "/", "2"}], "+", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"c", " ", ".", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ChebyshevT", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"Length", "[", "c", "]"}]}], "}"}]}], "]"}]}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->621242625]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15947],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"10", ",", 
    RowBox[{"Cos", "[", "x", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1112],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"10", " ", "x"}], "]"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463588151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29077151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", 
   RowBox[{"Cos", "[", 
    RowBox[{"10", 
     RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}], "]"}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30001],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"50", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"400", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"1120", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"1280", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"512", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113786942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"10", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108094584],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"50", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"400", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"1120", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"1280", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"512", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227073703]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5944],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->377633235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"60", ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300499535],

Cell[BoxData["0``-1.5110040628672672"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641296166]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->370676016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"60", ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60075057],

Cell[BoxData["0.98033630042969088019983466266`13.46572580536008"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64740304]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12436],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31434],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->15564]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27653],

Cell[TextData[{
 ButtonBox["Demonstrations with ChebyshevT",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ChebyshevT"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ChebyshevPolynomialoftheFirstKind.html"],
    None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/ChebyshevT/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ChebyshevT"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->599416703],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->524527449],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->127296346]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChebyshevT - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 12.9301098}", "context" -> "System`", 
    "keywords" -> {
     "Chebyshev functions", "Tschebyscheff polynomials", "Chebychev", 
      "Chebyshov", "Tchebycheff ", "Chebyshev polynomial"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ChebyshevT[n, x] gives the Chebyshev polynomial of the first kind T_n \
(x). ", "synonyms" -> {"Chebyshev T"}, "title" -> "ChebyshevT", "type" -> 
    "Symbol", "uri" -> "ref/ChebyshevT"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5837, 207, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18009979]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51704, 1489}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2100, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2723, 78, 48, 1, 70, "ObjectName",
 CellID->16689],
Cell[2774, 81, 700, 23, 70, "Usage",
 CellID->10074]
}, Open  ]],
Cell[CellGroupData[{
Cell[3511, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3989, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4112, 132, 155, 6, 70, "Notes",
 CellID->15578],
Cell[4270, 140, 283, 11, 70, "Notes",
 CellID->29626],
Cell[4556, 153, 252, 8, 70, "Notes",
 CellID->520040650],
Cell[4811, 163, 222, 7, 70, "Notes",
 CellID->31226],
Cell[5036, 172, 205, 7, 70, "Notes",
 CellID->28162],
Cell[5244, 181, 556, 21, 70, "Notes",
 CellID->340]
}, Closed]],
Cell[CellGroupData[{
Cell[5837, 207, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18009979],
Cell[CellGroupData[{
Cell[6221, 221, 148, 5, 70, "ExampleSection",
 CellID->106190177],
Cell[6372, 228, 169, 7, 70, "ExampleText",
 CellID->3572],
Cell[CellGroupData[{
Cell[6566, 239, 126, 4, 28, "Input",
 CellID->15820],
Cell[6695, 245, 491, 17, 36, "Output",
 CellID->180050029]
}, Open  ]],
Cell[7201, 265, 121, 3, 70, "ExampleDelimiter",
 CellID->29841],
Cell[CellGroupData[{
Cell[7347, 272, 263, 9, 28, "Input",
 CellID->11107],
Cell[7613, 283, 6366, 109, 164, "Output",
 Evaluatable->False,
 CellID->101900090]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14028, 398, 216, 7, 70, "ExampleSection",
 CellID->30121],
Cell[14247, 407, 80, 1, 70, "ExampleText",
 CellID->4834],
Cell[CellGroupData[{
Cell[14352, 412, 174, 6, 70, "Input",
 CellID->13992],
Cell[14529, 420, 269, 8, 36, "Output",
 CellID->37563401]
}, Open  ]],
Cell[14813, 431, 125, 3, 70, "ExampleDelimiter",
 CellID->559642203],
Cell[14941, 436, 69, 1, 70, "ExampleText",
 CellID->466028784],
Cell[CellGroupData[{
Cell[15035, 441, 184, 6, 70, "Input",
 CellID->210837820],
Cell[15222, 449, 336, 10, 54, "Output",
 CellID->495398940]
}, Open  ]],
Cell[15573, 462, 121, 3, 70, "ExampleDelimiter",
 CellID->13131],
Cell[15697, 467, 66, 1, 70, "ExampleText",
 CellID->16499],
Cell[CellGroupData[{
Cell[15788, 472, 207, 7, 70, "Input",
 CellID->25812],
Cell[15998, 481, 235, 7, 36, "Output",
 CellID->104922831]
}, Open  ]],
Cell[16248, 491, 121, 3, 70, "ExampleDelimiter",
 CellID->25420],
Cell[16372, 496, 210, 7, 70, "ExampleText",
 CellID->18595],
Cell[CellGroupData[{
Cell[16607, 507, 183, 6, 70, "Input",
 CellID->8684],
Cell[16793, 515, 432, 16, 39, "Output",
 CellID->401875547]
}, Open  ]],
Cell[17240, 534, 120, 3, 70, "ExampleDelimiter",
 CellID->5623],
Cell[17363, 539, 113, 3, 70, "ExampleText",
 CellID->22065],
Cell[CellGroupData[{
Cell[17501, 546, 125, 4, 70, "Input",
 CellID->15219],
Cell[17629, 552, 236, 8, 49, "Output",
 CellID->555873473]
}, Open  ]],
Cell[17880, 563, 125, 3, 70, "ExampleDelimiter",
 CellID->196312657],
Cell[18008, 568, 203, 7, 70, "ExampleText",
 CellID->104874190],
Cell[CellGroupData[{
Cell[18236, 579, 168, 5, 70, "Input",
 CellID->307199659],
Cell[18407, 586, 254, 8, 50, "Output",
 CellID->374199318]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18710, 600, 239, 7, 70, "ExampleSection",
 CellID->10912],
Cell[18952, 609, 209, 7, 70, "ExampleText",
 CellID->17271],
Cell[CellGroupData[{
Cell[19186, 620, 266, 9, 70, "Input",
 CellID->27167],
Cell[19455, 631, 672, 22, 60, "Output",
 CellID->160325845]
}, Open  ]],
Cell[20142, 656, 121, 3, 70, "ExampleDelimiter",
 CellID->21049],
Cell[20266, 661, 321, 12, 70, "ExampleText",
 CellID->16704],
Cell[CellGroupData[{
Cell[20612, 677, 234, 8, 70, "Input",
 CellID->8001],
Cell[20849, 687, 266, 9, 36, "Output",
 CellID->194986570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21164, 702, 223, 7, 70, "ExampleSection",
 CellID->12390],
Cell[21390, 711, 78, 1, 70, "ExampleText",
 CellID->2208],
Cell[CellGroupData[{
Cell[21493, 716, 429, 14, 70, "Input",
 CellID->15846],
Cell[21925, 732, 13546, 226, 70, "Output",
 Evaluatable->False,
 CellID->117126792]
}, Open  ]],
Cell[35486, 961, 121, 3, 70, "ExampleDelimiter",
 CellID->21361],
Cell[35610, 966, 271, 10, 70, "ExampleText",
 CellID->18414],
Cell[CellGroupData[{
Cell[35906, 980, 652, 22, 70, "Input",
 CellID->10732],
Cell[36561, 1004, 635, 23, 62, "Output",
 CellID->391107234]
}, Open  ]],
Cell[CellGroupData[{
Cell[37233, 1032, 794, 26, 70, "Input",
 CellID->19026],
Cell[38030, 1060, 4705, 81, 70, "Output",
 Evaluatable->False,
 CellID->621242625]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42784, 1147, 233, 7, 70, "ExampleSection",
 CellID->15947],
Cell[43020, 1156, 323, 13, 70, "ExampleText",
 CellID->835],
Cell[CellGroupData[{
Cell[43368, 1173, 197, 6, 70, "Input",
 CellID->1112],
Cell[43568, 1181, 211, 7, 36, "Output",
 CellID->463588151]
}, Open  ]],
Cell[43794, 1191, 124, 3, 70, "ExampleDelimiter",
 CellID->29077151],
Cell[CellGroupData[{
Cell[43943, 1198, 226, 8, 70, "Input",
 CellID->30001],
Cell[44172, 1208, 491, 17, 36, "Output",
 CellID->113786942]
}, Open  ]],
Cell[CellGroupData[{
Cell[44700, 1230, 130, 4, 70, "Input",
 CellID->108094584],
Cell[44833, 1236, 491, 17, 36, "Output",
 CellID->227073703]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45373, 1259, 225, 7, 70, "ExampleSection",
 CellID->5944],
Cell[45601, 1268, 131, 4, 70, "ExampleText",
 CellID->377633235],
Cell[CellGroupData[{
Cell[45757, 1276, 265, 9, 70, "Input",
 CellID->300499535],
Cell[46025, 1287, 179, 5, 36, "Output",
 CellID->641296166]
}, Open  ]],
Cell[46219, 1295, 74, 1, 70, "ExampleText",
 CellID->370676016],
Cell[CellGroupData[{
Cell[46318, 1300, 215, 7, 70, "Input",
 CellID->60075057],
Cell[46536, 1309, 206, 5, 36, "Output",
 CellID->64740304]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46803, 1321, 311, 9, 70, "SeeAlsoSection",
 CellID->12436],
Cell[47117, 1332, 704, 26, 70, "SeeAlso",
 CellID->21903]
}, Open  ]],
Cell[CellGroupData[{
Cell[47858, 1363, 314, 9, 70, "TutorialsSection",
 CellID->31434],
Cell[48175, 1374, 154, 3, 70, "Tutorials",
 CellID->15564]
}, Open  ]],
Cell[CellGroupData[{
Cell[48366, 1382, 321, 9, 70, "RelatedLinksSection",
 CellID->27653],
Cell[48690, 1393, 365, 12, 70, "RelatedLinks"],
Cell[49058, 1407, 204, 4, 70, "RelatedLinks"],
Cell[49265, 1413, 194, 4, 70, "RelatedLinks"],
Cell[49462, 1419, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49887, 1437, 319, 9, 70, "MoreAboutSection",
 CellID->599416703],
Cell[50209, 1448, 155, 3, 70, "MoreAbout",
 CellID->524527449],
Cell[50367, 1453, 145, 3, 70, "MoreAbout",
 CellID->127296346]
}, Open  ]],
Cell[50527, 1459, 27, 0, 70, "History"],
Cell[50557, 1461, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

