(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14401,        519]
NotebookOptionsPosition[     10881,        400]
NotebookOutlinePosition[     12216,        438]
CellTagsIndexPosition[     12131,        433]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupts and Aborts" :> 
          Documentation`HelpLookup["paclet:tutorial/InterruptsAndAborts"], 
          "Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupts and Aborts\"\>", 
       2->"\<\"Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Catch" :> Documentation`HelpLookup["paclet:ref/Catch"], 
          "Check" :> Documentation`HelpLookup["paclet:ref/Check"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Catch\"\>", 
       2->"\<\"Check\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Package Bulletproofing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CheckAbort", "ObjectName",
 CellID->28529],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CheckAbort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CheckAbort"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["failexpr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", returning ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"],
     " if an abort occurs. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " absorbs any aborts it handles, and does not propagate them further. "
}], "Notes",
 CellID->25489],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " works inside ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28591],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->822]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->769723137],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224121064],

Cell["\<\
Catch an abort in a part of a computation allowing the rest of it to \
continue:\
\>", "ExampleText",
 CellID->105653167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckAbort", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abort", "[", "]"}], ";", "1"}], ",", "2"}], "]"}], " ", "+", 
  " ", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8544771],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315246623]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11371],

Cell["\<\
A function that cleans up global settings that it makes in case of an abort:\
\>", "ExampleText",
 CellID->69883349],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "n_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"backon", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"CheckAbort", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"backon", " ", "=", " ", 
        RowBox[{
         RowBox[{"Head", "[", 
          RowBox[{"General", "::", "ovfl"}], "]"}], "=!=", "$Off"}]}], ";", 
       RowBox[{"Off", "[", 
        RowBox[{"General", "::", "ovfl"}], "]"}], ";", 
       RowBox[{"y", "=", 
        RowBox[{"Apply", "[", 
         RowBox[{"Power", ",", 
          RowBox[{"ConstantArray", "[", 
           RowBox[{"x", ",", "n"}], "]"}]}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{"backon", ",", 
         RowBox[{"On", "[", 
          RowBox[{"General", "::", "ovfl"}], "]"}]}], "]"}], ";", "y"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"backon", ",", 
         RowBox[{"On", "[", 
          RowBox[{"General", "::", "ovfl"}], "]"}]}], "]"}], ";", 
       "$Aborted"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124519556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"9", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286476137],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457415176]
}, Open  ]],

Cell["\<\
The message has been turned back on even when the computation is interrupted:\
\
\>", "ExampleText",
 CellID->624694236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MaxNumber", "*", "2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->293561807],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->179441195],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151283223]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13565],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->431],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "Tutorials",
 CellID->30983],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->68925359],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->156952833],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->287058948]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CheckAbort - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 14.5239006}", "context" -> "System`", 
    "keywords" -> {
     "block aborts", "catching of aborts", "intercept aborts", 
      "restore system parameters"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CheckAbort[expr, failexpr] evaluates expr, returning failexpr if an \
abort occurs. ", "synonyms" -> {"check abort", "finally"}, "title" -> 
    "CheckAbort", "type" -> "Symbol", "uri" -> "ref/CheckAbort"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4861, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->769723137]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11988, 426}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2051, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2674, 77, 48, 1, 70, "ObjectName",
 CellID->28529],
Cell[2725, 80, 711, 23, 70, "Usage",
 CellID->15072]
}, Open  ]],
Cell[CellGroupData[{
Cell[3473, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3951, 125, 240, 7, 70, "Notes",
 CellID->25489],
Cell[4194, 134, 319, 12, 70, "Notes",
 CellID->28591],
Cell[4516, 148, 308, 12, 70, "Notes",
 CellID->822]
}, Closed]],
Cell[CellGroupData[{
Cell[4861, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->769723137],
Cell[CellGroupData[{
Cell[5246, 179, 148, 5, 70, "ExampleSection",
 CellID->224121064],
Cell[5397, 186, 131, 4, 70, "ExampleText",
 CellID->105653167],
Cell[CellGroupData[{
Cell[5553, 194, 219, 8, 28, "Input",
 CellID->8544771],
Cell[5775, 204, 180, 6, 36, "Output",
 CellID->315246623]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6004, 216, 223, 7, 70, "ExampleSection",
 CellID->11371],
Cell[6230, 225, 126, 3, 70, "ExampleText",
 CellID->69883349],
Cell[6359, 230, 1210, 34, 70, "Input",
 CellID->124519556],
Cell[CellGroupData[{
Cell[7594, 268, 120, 4, 70, "Input",
 CellID->286476137],
Cell[7717, 274, 165, 5, 36, "Output",
 CellID->457415176]
}, Open  ]],
Cell[7897, 282, 130, 4, 70, "ExampleText",
 CellID->624694236],
Cell[CellGroupData[{
Cell[8052, 290, 101, 3, 70, "Input",
 CellID->293561807],
Cell[8156, 295, 357, 7, 70, "Message",
 CellID->179441195],
Cell[8516, 304, 187, 6, 36, "Output",
 CellID->151283223]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8764, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->13565],
Cell[9078, 328, 439, 17, 70, "SeeAlso",
 CellID->28898]
}, Open  ]],
Cell[CellGroupData[{
Cell[9554, 350, 312, 9, 70, "TutorialsSection",
 CellID->431],
Cell[9869, 361, 151, 3, 70, "Tutorials",
 CellID->30983],
Cell[10023, 366, 135, 3, 70, "Tutorials",
 CellID->959752411]
}, Open  ]],
Cell[CellGroupData[{
Cell[10195, 374, 318, 9, 70, "MoreAboutSection",
 CellID->68925359],
Cell[10516, 385, 135, 3, 70, "MoreAbout",
 CellID->156952833],
Cell[10654, 390, 155, 3, 70, "MoreAbout",
 CellID->287058948]
}, Open  ]],
Cell[10824, 396, 27, 0, 70, "History"],
Cell[10854, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

