(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    150348,       4146]
NotebookOptionsPosition[    141978,       3867]
NotebookOutlinePosition[    143679,       3909]
CellTagsIndexPosition[    143592,       3904]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TogglerBar" :> 
          Documentation`HelpLookup["paclet:ref/TogglerBar"], "RadioButtonBar" :> 
          Documentation`HelpLookup["paclet:ref/RadioButtonBar"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TogglerBar\"\>", 
       2->"\<\"RadioButtonBar\"\>", 3->"\<\"Checkbox\"\>", 
       4->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CheckboxBar", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CheckboxBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CheckboxBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a checkbox bar with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and with checkboxes for values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to include in the list ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CheckboxBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CheckboxBar"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the values in the list ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset every time a checkbox is clicked."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CheckboxBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CheckboxBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a checkbox bar in which the checkbox \
associated with value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " has label ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Multiple checkboxes in a ",
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 " can be checked at the same time. The values associated with all checked \
checkboxes are given in a list.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->415069573]
}], "Notes",
 CellID->334953226],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be strings, boxes, graphics or any other expressions, including \
dynamic expressions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->794506894]
}], "Notes",
 CellID->8400],

Cell["The following options can be given: ", "Notes",
 CellID->19514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the checkbox bar ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for each checkbox bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the checkbox bar is enabled, or grayed out ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->15505],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->570291772],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Horizontal\>\"", Cell[
    "equally spaced horizontally", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Vertical\>\"", Cell[
    "equally spaced vertically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Row\>\"", Cell[
    "laid out like text, allowing linewrapping", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->39473540],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<CheckboxBar\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<CheckboxBarLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220266140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->719055944],

Cell["Create checkboxes with a specified state:", "ExampleText",
 CellID->1809338285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211951305],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {1, 3}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ]], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ]], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ]], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}]],
    CheckboxBar[BoxForm`var$$, {1, 2, 3}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{91, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->688870642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225627972],

Cell["Include labels:", "ExampleText",
 CellID->582108407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\<One\>\""}], ",", 
     RowBox[{"2", "\[Rule]", "\"\<Two\>\""}], ",", 
     RowBox[{"3", "\[Rule]", "\"\<Three\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35241330],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {1, 3}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ]], "\<\"One\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ]], "\<\"Two\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ]], "\<\"Three\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1 -> "One", 2 -> "Two", 3 -> "Three"}]],
    CheckboxBar[BoxForm`var$$, {1 -> "One", 2 -> "Two", 3 -> "Three"}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{147, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232584090]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13122743],

Cell["Use dynamically updated setting: ", "ExampleText",
 CellID->415069573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258976704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 1], 
            BoxForm`TogglerBarFunction[$CellContext`x, 1]& ]], "1"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 2], 
            BoxForm`TogglerBarFunction[$CellContext`x, 2]& ]], "2"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 3], 
            BoxForm`TogglerBarFunction[$CellContext`x, 3]& ]], "3"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`x], {1, 2, 3}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{123, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->893448901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592864393],

Cell["Use any type of expression as values:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->794506894],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SqrtBox["y"], 
    RowBox[{"Tan", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "y"}], "-", "\[Beta]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", "\"\<\[Alpha]\[Beta]\[Gamma]\>\""}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->505851930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "f", ",", "s"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111895333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 
             Graphics[{{{}, {}, {
                 Hue[0.67, 0.6, 0.6], 
                 Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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                  "]]}}}, {
              AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, 
               ImageSize -> 40, 
               PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
                 0.9999998782112116}}, PlotRangeClipping -> True, 
               PlotRangePadding -> {
                 Scaled[0.02], 
                 Scaled[0.02]}}]], 
            BoxForm`TogglerBarFunction[$CellContext`x, 
             Graphics[{{{}, {}, {
                 Hue[0.67, 0.6, 0.6], 
                 Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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                  "]]}}}, {
              AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, 
               ImageSize -> 40, 
               PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
                 0.9999998782112116}}, PlotRangeClipping -> True, 
               PlotRangePadding -> {
                 Scaled[0.02], 
                 Scaled[0.02]}}]]& ]], 
          GraphicsBox[{{}, {}, 
            {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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              "]]}},
           AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
           AxesOrigin->{0, 0},
           ImageSize->40,
           
           PlotRange->
            NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
              0, 6.283185307179586}, {-0.9999998592131705, 
              0.9999998782112116}}],
           PlotRangeClipping->True,
           PlotRangePadding->{
             Scaled[0.02], 
             Scaled[0.02]}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            
            MemberQ[$CellContext`x, $CellContext`y^Rational[1, 2] 
             Tan[$CellContext`y $CellContext`\[Alpha] - \
$CellContext`\[Beta]]], 
            BoxForm`TogglerBarFunction[$CellContext`x, $CellContext`y^
              Rational[1, 2] 
             Tan[$CellContext`y $CellContext`\[Alpha] - \
$CellContext`\[Beta]]]& ]], 
          RowBox[{
           SqrtBox["y"], " ", 
           RowBox[{"Tan", "[", 
            RowBox[{
             RowBox[{"y", " ", "\[Alpha]"}], "-", "\[Beta]"}], "]"}]}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, "\[Alpha]\[Beta]\[Gamma]"], 
            BoxForm`TogglerBarFunction[$CellContext`x, 
             "\[Alpha]\[Beta]\[Gamma]"]& ]], \
"\<\"\[Alpha]\[Beta]\[Gamma]\"\>"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`x], {
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, ImageSize -> 40,
         PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], $CellContext`y^Rational[1, 2] 
      Tan[$CellContext`y $CellContext`\[Alpha] - $CellContext`\[Beta]], 
      "\[Alpha]\[Beta]\[Gamma]"}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{263, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472384569]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3527988],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->212586104],

Cell["Alter the size: ", "ExampleText",
 CellID->68960653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478423256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Appearance->Tiny], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              Appearance->Tiny], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Appearance->Tiny], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Tiny]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Tiny]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Appearance->Small], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              Appearance->Small], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Appearance->Small], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Small]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Small]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Appearance->Medium], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              Appearance->Medium], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Appearance->Medium], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Medium]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Medium]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Appearance->Large], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              Appearance->Large], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Appearance->Large], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Large]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Large]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{372, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103672906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->333279091],

Cell["Alter the orientation: ", "ExampleText",
 CellID->158801865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Horizontal\>\"", ",", "\"\<Vertical\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->802995337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 1]& ]], "1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"], 
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 2]& ]], "2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"], 
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 3]& ]], "3"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[1.4]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> "Horizontal"]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Horizontal"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 1]& ]], "1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]},
          {
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 2]& ]], "2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]},
          {
           TagBox[GridBox[{
              {
               CheckboxBox[Dynamic[
                 MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
                 BoxForm`var$$, 3]& ]], "3"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> "Vertical"]],
      CheckboxBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Vertical"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{152, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51175006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61100364],

Cell["\<\
Using the \"Row\" appearance will allow the row of checkboxes to line break:\
\>", "ExampleText",
 CellID->338810384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Range", "[", "15", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Row\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232465877],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ]], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ]], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ]], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ]], "4"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ]], "5"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 6], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 6]& ]], "6"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 7]& ]], "7"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 8], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 8]& ]], "8"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 9], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 9]& ]], "9"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 10], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 10]& ]], "10"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 11], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 11]& ]], "11"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 12], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 12]& ]], "12"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 13], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 13]& ]], "13"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 14], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 14]& ]], "14"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 15], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 15]& ]], "15"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}]],
    CheckboxBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 
     Appearance -> "Row"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{512, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188543930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Range", "[", "15", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Horizontal\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->92213691],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ]], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ]], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ]], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 4]& ]], "4"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 5]& ]], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 6], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 6]& ]], "6"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 7]& ]], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 8], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 8]& ]], "8"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 9], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 9]& ]], "9"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 10], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 10]& ]], "10"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 11], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 11]& ]], "11"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 12], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 12]& ]], "12"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 13], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 13]& ]], "13"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 14], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 14]& ]], "14"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 15], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 15]& ]], "15"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[1.4]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}, Appearance -> "Horizontal"]],
    CheckboxBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 
     Appearance -> "Horizontal"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{584, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->397058380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->237152097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5", ",", "7"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319047190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Background->RGBColor[1, 0.5, 0.5]], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Background->RGBColor[1, 0.5, 0.5]], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 5]& ],
              Background->RGBColor[1, 0.5, 0.5]], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 7]& ],
              Background->RGBColor[1, 0.5, 0.5]], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 3, 5, 7}, Background -> 
        RGBColor[1, 0.5, 0.5]]],
      CheckboxBar[
      BoxForm`var$$, {1, 3, 5, 7}, Background -> RGBColor[1, 0.5, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Background->RGBColor[0, 1, 0]], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Background->RGBColor[0, 1, 0]], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 5]& ],
              Background->RGBColor[0, 1, 0]], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 7]& ],
              Background->RGBColor[0, 1, 0]], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 3, 5, 7}, Background -> 
        RGBColor[0, 1, 0]]],
      CheckboxBar[
      BoxForm`var$$, {1, 3, 5, 7}, Background -> RGBColor[0, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Background->GrayLevel[0.5]], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Background->GrayLevel[0.5]], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 5]& ],
              Background->GrayLevel[0.5]], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 7]& ],
              Background->GrayLevel[0.5]], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 3, 5, 7}, Background -> GrayLevel[0.5]]],
      CheckboxBar[BoxForm`var$$, {1, 3, 5, 7}, Background -> GrayLevel[0.5]]],
     
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              Background->RGBColor[1, 1, 0]], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 3]& ],
              Background->RGBColor[1, 1, 0]], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 5]& ],
              Background->RGBColor[1, 1, 0]], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 7]& ],
              Background->RGBColor[1, 1, 0]], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 3, 5, 7}, Background -> 
        RGBColor[1, 1, 0]]],
      CheckboxBar[
      BoxForm`var$$, {1, 3, 5, 7}, Background -> RGBColor[1, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{523, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194239438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156975],

Cell["Change the background dynamically:", "ExampleText",
 CellID->116421652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.25", ",", "0.3", ",", "0.8"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Hue", "[", 
        RowBox[{"Total", "[", "x", "]"}], "]"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91955891],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = {}}, 
  InterpretationBox[
   StyleBox[
    RowBox[{
     TagBox[GridBox[{
        {
         CheckboxBox[Dynamic[
           MemberQ[$CellContext`x$$, 0.1], 
           BoxForm`TogglerBarFunction[$CellContext`x$$, 0.1]& ],
          Background->Dynamic[
            Hue[
             Total[$CellContext`x$$]]]], "0.1`"}
       },
       ColumnsEqual->False,
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}},
       RowsEqual->False],
      "Grid"], "  ", 
     TagBox[GridBox[{
        {
         CheckboxBox[Dynamic[
           MemberQ[$CellContext`x$$, 0.25], 
           BoxForm`TogglerBarFunction[$CellContext`x$$, 0.25]& ],
          Background->Dynamic[
            Hue[
             Total[$CellContext`x$$]]]], "0.25`"}
       },
       ColumnsEqual->False,
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}},
       RowsEqual->False],
      "Grid"], "  ", 
     TagBox[GridBox[{
        {
         CheckboxBox[Dynamic[
           MemberQ[$CellContext`x$$, 0.3], 
           BoxForm`TogglerBarFunction[$CellContext`x$$, 0.3]& ],
          Background->Dynamic[
            Hue[
             Total[$CellContext`x$$]]]], "0.3`"}
       },
       ColumnsEqual->False,
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}},
       RowsEqual->False],
      "Grid"], "  ", 
     TagBox[GridBox[{
        {
         CheckboxBox[Dynamic[
           MemberQ[$CellContext`x$$, 0.8], 
           BoxForm`TogglerBarFunction[$CellContext`x$$, 0.8]& ],
          Background->Dynamic[
            Hue[
             Total[$CellContext`x$$]]]], "0.8`"}
       },
       ColumnsEqual->False,
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}},
       RowsEqual->False],
      "Grid"]}],
    Deployed->True],
   CheckboxBar[
    Dynamic[$CellContext`x$$], {0.1, 0.25, 0.3, 0.8}, Background -> Dynamic[
      Hue[
       Total[$CellContext`x$$]]]]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{185, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510702763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->139136648],

Cell["Align the labels with surrounding text:", "ExampleText",
 CellID->57049601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"CheckboxBar", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Bottom", ",", "Center", ",", "Top"}], 
        "}"}]}], "}"}]}], "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314723235],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              BaselinePosition->Automatic], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              BaselinePosition->Automatic], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Automatic]],
      CheckboxBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Automatic]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              BaselinePosition->Bottom], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              BaselinePosition->Bottom], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Bottom]],
      CheckboxBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              BaselinePosition->Center], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              BaselinePosition->Center], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Center]],
      CheckboxBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 1]& ],
              BaselinePosition->Top], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             CheckboxBox[Dynamic[
               MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
               BoxForm`var$$, 2]& ],
              BaselinePosition->Top], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       CheckboxBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Top]],
      CheckboxBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    CheckboxBar[{}, {1, 2}, BaselinePosition -> Automatic], 
    CheckboxBar[{}, {1, 2}, BaselinePosition -> Bottom], 
    CheckboxBar[{}, {1, 2}, BaselinePosition -> Center], 
    CheckboxBar[{}, {1, 2}, BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{303, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286689953]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->404621356],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->108488091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738615],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {1, 3}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ]], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ]], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ]], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}]],
    CheckboxBar[BoxForm`var$$, {1, 2, 3}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{91, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227450643]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the checkbox bar is disabled but visible in its current state:"
}], "ExampleText",
 CellID->402493459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckboxBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->266219517],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {1, 3}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ],
            Enabled->False], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ],
            Enabled->False], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           CheckboxBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ],
            Enabled->False], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     CheckboxBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}, Enabled -> False]],
    CheckboxBar[BoxForm`var$$, {1, 2, 3}, Enabled -> False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{91, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86595246]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->814512658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9502163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 1], 
            BoxForm`TogglerBarFunction[$CellContext`x, 1]& ]], "1"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 2], 
            BoxForm`TogglerBarFunction[$CellContext`x, 2]& ]], "2"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 3], 
            BoxForm`TogglerBarFunction[$CellContext`x, 3]& ]], "3"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 4], 
            BoxForm`TogglerBarFunction[$CellContext`x, 4]& ]], "4"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 5], 
            BoxForm`TogglerBarFunction[$CellContext`x, 5]& ]], "5"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`x], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{186, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365312766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32818520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 1], 
          BoxForm`TogglerBarFunction[$CellContext`y, 1]& ], {True}, "1"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 2], 
          BoxForm`TogglerBarFunction[$CellContext`y, 2]& ], {True}, "2"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 3], 
          BoxForm`TogglerBarFunction[$CellContext`y, 3]& ], {True}, "3"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 4], 
          BoxForm`TogglerBarFunction[$CellContext`y, 4]& ], {True}, "4"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 5], 
          BoxForm`TogglerBarFunction[$CellContext`y, 5]& ], {True}, "5"]}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Deployed->True],
    TogglerBar[
     Dynamic[$CellContext`y], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{107, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60995835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->896763913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 " is built using ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " and can be used to track a list of values:"
}], "ExampleText",
 CellID->74996582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1743008046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`y, 1], 
            BoxForm`TogglerBarFunction[$CellContext`y, 1]& ]], "1"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`y, 2], 
            BoxForm`TogglerBarFunction[$CellContext`y, 2]& ]], "2"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`y, 3], 
            BoxForm`TogglerBarFunction[$CellContext`y, 3]& ]], "3"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`y, 4], 
            BoxForm`TogglerBarFunction[$CellContext`y, 4]& ]], "4"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`y, 5], 
            BoxForm`TogglerBarFunction[$CellContext`y, 5]& ]], "5"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`y], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{186, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474653884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1551643958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1586076585]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->592797344],

Cell["\<\
Values are added in the order clicked rather than the order given by the list \
of possible values:\
\>", "ExampleText",
 CellID->185269913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35914650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 1], 
            BoxForm`TogglerBarFunction[$CellContext`x, 1]& ]], "1"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 2], 
            BoxForm`TogglerBarFunction[$CellContext`x, 2]& ]], "2"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 3], 
            BoxForm`TogglerBarFunction[$CellContext`x, 3]& ]], "3"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`x], {1, 2, 3}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{123, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214101299]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TogglerBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TogglerBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButtonBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButtonBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->222799676],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->2875121]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CheckboxBar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 18.6646316}", "context" -> "System`", 
    "keywords" -> {
     "checkbox", "dynamic control", "multiple selection control"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CheckboxBar[x, {val_1, val_2, ...}] represents a checkbox bar with \
setting x and with checkboxes for values val_i to include in the list x. \
CheckboxBar[Dynamic[x], {val_1, val_2, ...}] takes the setting to be the \
dynamically updated current value of x, with the values in the list x being \
reset every time a checkbox is clicked. CheckboxBar[x, {val_1 -> lbl_1, val_2 \
-> lbl_2, ...}] represents a checkbox bar in which the checkbox associated \
with value val_i has label lbl_i.", "synonyms" -> {"checkbox bar"}, "title" -> 
    "CheckboxBar", "type" -> "Symbol", "uri" -> "ref/CheckboxBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12334, 373, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->220266140]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 143448, 3897}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2399, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3022, 83, 1576, 37, 70, "ObjectNameGrid"],
Cell[4601, 122, 3301, 104, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7939, 231, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8417, 248, 400, 12, 70, "Notes",
 CellID->334953226],
Cell[8820, 262, 449, 17, 70, "Notes",
 CellID->8400],
Cell[9272, 281, 69, 1, 70, "Notes",
 CellID->19514],
Cell[9344, 284, 1551, 40, 70, "3ColumnTableMod",
 CellID->15505],
Cell[10898, 326, 222, 8, 70, "Notes",
 CellID->570291772],
Cell[11123, 336, 618, 13, 70, "2ColumnTableMod",
 CellID->39473540],
Cell[11744, 351, 553, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[12334, 373, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220266140],
Cell[CellGroupData[{
Cell[12719, 387, 148, 5, 70, "ExampleSection",
 CellID->719055944],
Cell[12870, 394, 85, 1, 70, "ExampleText",
 CellID->1809338285],
Cell[CellGroupData[{
Cell[12980, 399, 238, 8, 28, "Input",
 CellID->211951305],
Cell[13221, 409, 2039, 62, 38, "Output",
 CellID->688870642]
}, Open  ]],
Cell[15275, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->225627972],
Cell[15403, 479, 58, 1, 70, "ExampleText",
 CellID->582108407],
Cell[CellGroupData[{
Cell[15486, 484, 365, 11, 70, "Input",
 CellID->35241330],
Cell[15854, 497, 2130, 62, 70, "Output",
 CellID->232584090]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18033, 565, 219, 7, 70, "ExampleSection",
 CellID->13122743],
Cell[18255, 574, 76, 1, 70, "ExampleText",
 CellID->415069573],
Cell[CellGroupData[{
Cell[18356, 579, 314, 10, 70, "Input",
 CellID->258976704],
Cell[18673, 591, 1955, 60, 70, "Output",
 CellID->893448901]
}, Open  ]],
Cell[20643, 654, 125, 3, 70, "ExampleDelimiter",
 CellID->592864393],
Cell[20771, 659, 128, 2, 70, "ExampleText",
 CellID->794506894],
Cell[20902, 663, 695, 23, 70, "Input",
 CellID->505851930],
Cell[CellGroupData[{
Cell[21622, 690, 314, 10, 70, "Input",
 CellID->111895333],
Cell[21939, 702, 39979, 705, 70, "Output",
 CellID->472384569]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61967, 1413, 220, 7, 70, "ExampleSection",
 CellID->3527988],
Cell[CellGroupData[{
Cell[62212, 1424, 231, 7, 70, "ExampleSubsection",
 CellID->212586104],
Cell[62446, 1433, 58, 1, 70, "ExampleText",
 CellID->68960653],
Cell[CellGroupData[{
Cell[62529, 1438, 466, 15, 70, "Input",
 CellID->478423256],
Cell[62998, 1455, 8752, 247, 70, "Output",
 CellID->103672906]
}, Open  ]],
Cell[71765, 1705, 125, 3, 70, "ExampleDelimiter",
 CellID->333279091],
Cell[71893, 1710, 66, 1, 70, "ExampleText",
 CellID->158801865],
Cell[CellGroupData[{
Cell[71984, 1715, 462, 15, 70, "Input",
 CellID->802995337],
Cell[72449, 1732, 4961, 136, 70, "Output",
 CellID->51175006]
}, Open  ]],
Cell[77425, 1871, 124, 3, 70, "ExampleDelimiter",
 CellID->61100364],
Cell[77552, 1876, 127, 3, 70, "ExampleText",
 CellID->338810384],
Cell[CellGroupData[{
Cell[77704, 1883, 242, 7, 70, "Input",
 CellID->232465877],
Cell[77949, 1892, 8501, 245, 70, "Output",
 CellID->188543930]
}, Open  ]],
Cell[CellGroupData[{
Cell[86487, 2142, 250, 8, 70, "Input",
 CellID->92213691],
Cell[86740, 2152, 9203, 253, 70, "Output",
 CellID->397058380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95992, 2411, 231, 7, 70, "ExampleSubsection",
 CellID->237152097],
Cell[CellGroupData[{
Cell[96248, 2422, 475, 15, 70, "Input",
 CellID->319047190],
Cell[96726, 2439, 11484, 318, 70, "Output",
 CellID->194239438]
}, Open  ]],
Cell[108225, 2760, 122, 3, 70, "ExampleDelimiter",
 CellID->156975],
Cell[108350, 2765, 77, 1, 70, "ExampleText",
 CellID->116421652],
Cell[CellGroupData[{
Cell[108452, 2770, 549, 17, 70, "Input",
 CellID->91955891],
Cell[109004, 2789, 3345, 99, 70, "Output",
 CellID->510702763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112398, 2894, 237, 7, 70, "ExampleSubsection",
 CellID->139136648],
Cell[112638, 2903, 81, 1, 70, "ExampleText",
 CellID->57049601],
Cell[CellGroupData[{
Cell[112744, 2908, 556, 17, 70, "Input",
 CellID->314723235],
Cell[113303, 2927, 6733, 188, 70, "Output",
 CellID->286689953]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[120085, 3121, 228, 7, 70, "ExampleSubsection",
 CellID->404621356],
Cell[120316, 3130, 211, 8, 70, "ExampleText",
 CellID->108488091],
Cell[CellGroupData[{
Cell[120552, 3142, 237, 8, 70, "Input",
 CellID->37738615],
Cell[120792, 3152, 2039, 62, 70, "Output",
 CellID->227450643]
}, Open  ]],
Cell[122846, 3217, 375, 12, 70, "ExampleText",
 CellID->402493459],
Cell[CellGroupData[{
Cell[123246, 3233, 288, 9, 70, "Input",
 CellID->266219517],
Cell[123537, 3244, 2158, 65, 70, "Output",
 CellID->86595246]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[125756, 3316, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[125997, 3325, 334, 12, 70, "ExampleText",
 CellID->814512658],
Cell[CellGroupData[{
Cell[126356, 3341, 284, 9, 70, "Input",
 CellID->9502163],
Cell[126643, 3352, 2989, 90, 70, "Output",
 CellID->365312766]
}, Open  ]],
Cell[CellGroupData[{
Cell[129669, 3447, 284, 9, 70, "Input",
 CellID->32818520],
Cell[129956, 3458, 1420, 38, 70, "Output",
 CellID->60995835]
}, Open  ]],
Cell[131391, 3499, 125, 3, 70, "ExampleDelimiter",
 CellID->896763913],
Cell[131519, 3504, 365, 12, 70, "ExampleText",
 CellID->74996582],
Cell[CellGroupData[{
Cell[131909, 3520, 287, 9, 70, "Input",
 CellID->1743008046],
Cell[132199, 3531, 3714, 110, 70, "Output",
 CellID->474653884]
}, Open  ]],
Cell[CellGroupData[{
Cell[135950, 3646, 223, 7, 70, "Input",
 CellID->1551643958],
Cell[136176, 3655, 328, 10, 70, "Output",
 CellID->1586076585]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136553, 3671, 230, 7, 70, "ExampleSection",
 CellID->592797344],
Cell[136786, 3680, 150, 4, 70, "ExampleText",
 CellID->185269913],
Cell[CellGroupData[{
Cell[136961, 3688, 313, 10, 70, "Input",
 CellID->35914650],
Cell[137277, 3700, 1955, 60, 70, "Output",
 CellID->214101299]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[139293, 3767, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[139612, 3778, 965, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[140614, 3818, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[140935, 3829, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[141097, 3834, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[141282, 3842, 299, 8, 70, "MoreAboutSection"],
Cell[141584, 3852, 141, 3, 70, "MoreAbout",
 CellID->222799676],
Cell[141728, 3857, 178, 3, 70, "MoreAbout",
 CellID->2875121]
}, Open  ]],
Cell[141921, 3863, 27, 0, 70, "History"],
Cell[141951, 3865, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

