(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25145,        737]
NotebookOptionsPosition[     21271,        618]
NotebookOutlinePosition[     23163,        668]
CellTagsIndexPosition[     23045,        662]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MessageDialog" :> 
          Documentation`HelpLookup["paclet:ref/MessageDialog"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MessageDialog\"\>", 
       2->"\<\"DialogInput\"\>", 3->"\<\"Input\"\>", 
       4->"\<\"CreateDialog\"\>", 5->"\<\"PopupMenu\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ChoiceDialog", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChoiceDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChoiceDialog"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts up a standard choice dialog that displays ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " together with ",
     StyleBox["OK", "DialogElementName"],
     " and ",
     StyleBox["Cancel", "DialogElementName"],
     " buttons, and returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     StyleBox["OK", "DialogElementName"],
     " is pressed, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if ",
     StyleBox["Cancel", "DialogElementName"],
     " is pressed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChoiceDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChoiceDialog"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes buttons with labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", and returns the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for the button pressed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->118982839]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChoiceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFormula"],
 " places buttons automatically, outside the area used to display ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27137285],

Cell[TextData[{
 "Any expressions, including both text and graphics, can be used for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->688347816],

Cell[TextData[{
 "In the window generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", pressing ",
 StyleBox["Return", "KeyEvent"],
 " is taken to be equivalent to pressing the ",
 StyleBox["OK", "DialogElementName"],
 " button, while pressing ",
 StyleBox["Esc", "KeyEvent"],
 " or closing the window is taken to be equivalent to pressing the ",
 StyleBox["Cancel", "DialogElementName"],
 " button."
}], "Notes",
 CellID->291811578],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["lbl", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 ", pressing ",
 StyleBox["Return", "KeyEvent"],
 " returns ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", while pressing ",
 StyleBox["Esc", "KeyEvent"],
 " or closing the window returns ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->489092830],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChoiceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFormula"],
 " by default puts up a notebook with a typical choice dialog appearance. The \
option settings include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->558],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChoiceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFormula"],
 " by default puts up a dialog in the middle of the main display screen. \
Explicit settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 CellID->6914]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->733873421],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->220155515],

Cell["Create a choice dialog:", "ExampleText",
 CellID->552928181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChoiceDialog", "[", "\"\<Make a choice...\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673598751],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108862466],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3NtTG+cZx3F1+j/0vheZ/BO9anvR6YybmU6ai3amMZ6C42TSTjq9aKeT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   "], {{0, 0}, {358, 105}}, {0, 255}],
  ImageSize->{358 0.75, 105 0.75},
  PlotRange->{{0, 358}, {0, 105}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->77032503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22848750],

Cell["Create a multiple choice dialog: ", "ExampleText",
 CellID->406271763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChoiceDialog", "[", 
  RowBox[{"\"\<Pick one\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}], ",", 
     RowBox[{"4", "\[Rule]", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207885838],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403921484],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1PHNcZx/Gt+j/0vhdR/oletb2oKrmRqjQXrdQYq8Zxo7RK1YtWVXJh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   "], {{0, 0}, {358, 105}}, {0, 255}],
  ImageSize->{358 0.75, 105 0.75},
  PlotRange->{{0, 358}, {0, 105}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->812951403]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->222506884],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->170387632]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChoiceDialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 28.2273764}", "context" -> "System`", 
    "keywords" -> {
     "yes no dialog", "two options dialog", "ok cancel dialog", "dialog box", 
      "multiple choice dialog", "multiple choice question"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ChoiceDialog[expr] puts up a standard choice dialog that displays expr \
together with OK and Cancel buttons, and returns True if OK is pressed, and \
False if Cancel is pressed. ChoiceDialog[expr, {lbl_1 -> val_1, lbl_2 -> \
val_2, ...}] includes buttons with labels lbl_i, and returns the \
corresponding val_i for the button pressed.", "synonyms" -> {"choice dialog"},
     "title" -> "ChoiceDialog", "type" -> "Symbol", "uri" -> 
    "ref/ChoiceDialog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10313, 337, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->733873421]},
 "Notebook Image"->{
  Cell[11238, 375, 3392, 58, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->77032503],
  Cell[15380, 465, 3584, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->812951403]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22672, 648},
 {"Notebook Image", 22814, 652}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1741, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2364, 66, 1577, 37, 70, "ObjectNameGrid"],
Cell[3944, 105, 2318, 73, 70, "Usage",
 CellID->118982839]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 183, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6777, 200, 308, 10, 70, "Notes",
 CellID->27137285],
Cell[7088, 212, 301, 11, 70, "Notes",
 CellID->688347816],
Cell[7392, 225, 579, 18, 70, "Notes",
 CellID->291811578],
Cell[7974, 245, 892, 35, 70, "Notes",
 CellID->489092830],
Cell[8869, 282, 986, 35, 70, "Notes",
 CellID->558],
Cell[9858, 319, 418, 13, 70, "Notes",
 CellID->6914]
}, Closed]],
Cell[CellGroupData[{
Cell[10313, 337, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->733873421],
Cell[CellGroupData[{
Cell[10698, 351, 148, 5, 70, "ExampleSection",
 CellID->220155515],
Cell[10849, 358, 66, 1, 70, "ExampleText",
 CellID->552928181],
Cell[CellGroupData[{
Cell[10940, 363, 131, 3, 28, "Input",
 CellID->673598751],
Cell[11074, 368, 161, 5, 36, "Output",
 CellID->108862466],
Cell[11238, 375, 3392, 58, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->77032503]
}, Open  ]],
Cell[14645, 436, 124, 3, 70, "ExampleDelimiter",
 CellID->22848750],
Cell[14772, 441, 76, 1, 70, "ExampleText",
 CellID->406271763],
Cell[CellGroupData[{
Cell[14873, 446, 343, 10, 70, "Input",
 CellID->207885838],
Cell[15219, 458, 158, 5, 36, "Output",
 CellID->403921484],
Cell[15380, 465, 3584, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->812951403]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19025, 533, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19344, 544, 1210, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20591, 593, 299, 8, 70, "MoreAboutSection"],
Cell[20893, 603, 168, 3, 70, "MoreAbout",
 CellID->222506884],
Cell[21064, 608, 135, 3, 70, "MoreAbout",
 CellID->170387632]
}, Open  ]],
Cell[21214, 614, 27, 0, 70, "History"],
Cell[21244, 616, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

