(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    123333,       3799]
NotebookOptionsPosition[    109178,       3311]
NotebookOutlinePosition[    110761,       3353]
CellTagsIndexPosition[    110674,       3348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Disk" :> Documentation`HelpLookup["paclet:ref/Disk"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"], "Cylinder" :> 
          Documentation`HelpLookup["paclet:ref/Cylinder"], "Sphere" :> 
          Documentation`HelpLookup["paclet:ref/Sphere"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Disk\"\>", 2->"\<\"Rotate\"\>", 
       3->"\<\"Cylinder\"\>", 4->"\<\"Sphere\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Precollege Education\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Circle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Circle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Circle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a two\[Hyphen]dimensional graphics primitive that \
represents a circle of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at the point ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Circle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Circle"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a circle of radius 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Circle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Circle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["r", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Theta]", 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox["\[Theta]", 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a circular arc. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Circle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Circle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["y", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an ellipse with semi\[Hyphen]axes of lengths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     ", oriented parallel to the coordinate axes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Angles are measured in radians counterclockwise from the positive ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction. "
}], "Notes",
 CellID->7745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox["\[Theta]", 
       StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " yields a segment of an ellipse obtained by transforming a circular arc \
with the specified starting and ending angles. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21280],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["dr", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["dr", "TI"], 
      StyleBox["y", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["dr", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["dr", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be used in the radius specification. The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are in scaled coordinates, and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are in ordinary coordinates. "
}], "Notes",
 CellID->1116],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " gives a disk of scaled radius ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18889],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["y", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " can be used to specify radii in printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21521],

Cell[TextData[{
 "The thickness of the circle can be specified using the ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " primitive. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->13249],

Cell[TextData[{
 "Individual coordinates, lists of coordinates, and parameters in circles can \
be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11916],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28744]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->385951803],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->241970772],

Cell["A unit circle:", "ExampleText",
 CellID->77469350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278347667],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->120115758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110273157],

Cell["A circular arc:", "ExampleText",
 CellID->77089960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Pi", "/", "6"}], ",", 
      RowBox[{"3", 
       RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69305470],

Cell[BoxData[
 GraphicsBox[
  CircleBox[{0, 0}, 1, 
   NCache[{Rational[1, 6] Pi, Rational[3, 4] Pi}, {0.5235987755982988, 
    2.356194490192345}]]]], "Output",
 ImageSize->{104, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->61971911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596191197],

Cell["An ellipse:", "ExampleText",
 CellID->144681104],

Cell[CellGroupData[{

Cell["Graphics[Circle[{0,0},{3,4}]]", "Input",
 CellLabel->"In[1]:=",
 CellID->474423382],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, {3., 4.}]]], "Output",
 ImageSize->{104, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->586622014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599660581],

Cell["Differently styled circles:", "ExampleText",
 CellID->345044910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick", ",", "Dashed", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312736669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[Large], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Dashing[{Small, Small}], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
     CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->251592980]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16790],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Circle Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32802836],

Cell["Specify radii:", "ExampleText",
 CellID->304149056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70247180],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], CircleBox[{0, 0}, 3], 
   CircleBox[{0, 0}, 5]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->28989858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128386129],

Cell["Specify centers:", "ExampleText",
 CellID->8232083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5294749],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], CircleBox[{1, 1}], 
   CircleBox[{2, 2}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->103836346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51413470],

Cell["A circular arc:", "ExampleText",
 CellID->628243246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40833855],

Cell[BoxData[
 GraphicsBox[
  CircleBox[{0, 0}, 1, 
   NCache[{0, Rational[4, 3] Pi}, {0, 4.1887902047863905`}]]]], "Output",
 ImageSize->{104, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->128189321]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}], ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133890409],

Cell[BoxData[
 GraphicsBox[
  CircleBox[{0, 0}, 1, 
   NCache[{Rational[4, 3] Pi, 2 Pi}, {4.1887902047863905`, 
    6.283185307179586}]]]], "Output",
 ImageSize->{104, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->199332788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65223652],

Cell["An ellipse:", "ExampleText",
 CellID->73292735],

Cell[CellGroupData[{

Cell["Graphics[Circle[{0,0},{3,2}]]", "Input",
 CellLabel->"In[1]:=",
 CellID->509432554],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, {3., 2.}]]], "Output",
 ImageSize->{104, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->36498140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182452125],

Cell[TextData[{
 "An elliptical arc: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21280,
  ButtonNote->"21280"]
}], "ExampleText",
 CellID->286759351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47897404],

Cell[BoxData[
 GraphicsBox[
  CircleBox[{0, 0}, {3., 2.}, 
   NCache[{0, Rational[4, 3] Pi}, {0, 4.1887902047863905`}]]]], "Output",
 ImageSize->{104, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->754413579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->321911792],

Cell[TextData[{
 "Short form for a unit circle at the origin: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28744,
  ButtonNote->"28744"]
}], "ExampleText",
 CellID->628760335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"In[1]:=",
 CellID->287232931],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->44921650]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Circle Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1873092],

Cell[TextData[{
 "Circles with different thicknesses: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13249,
  ButtonNote->"13249"]
}], "ExampleText",
 CellID->112891434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "i", "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14466464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[Small], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[Medium], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[Large], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->347397690]
}, Open  ]],

Cell["Thickness in scaled size:", "ExampleText",
 CellID->220038262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "i", "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{".05", ",", ".1", ",", ".2"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->388303278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.05], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[0.1], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[0.2], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->586862717]
}, Open  ]],

Cell["Thickness in printer's point:", "ExampleText",
 CellID->27522066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "i", "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->165797838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[1], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[5], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[10], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->84705645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129908792],

Cell["Dashed circles:", "ExampleText",
 CellID->568010029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dotted", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"DotDashed", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458399147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], CircleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->359946853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410953990],

Cell["Colored circles:", "ExampleText",
 CellID->470570762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78751695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->61420134]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate and Radii Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->762801493],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates and radii: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->18889,
  ButtonNote->"18889"]
}], "ExampleText",
 CellID->374620981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73519992],

Cell[BoxData[
 GraphicsBox[CircleBox[Scaled[{0.2, 0.2}], 0.2],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->641832794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61585090],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, Scaled[0.25]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->139911056]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->518233082],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, Scaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->182355327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70916749],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates and radii:"
}], "ExampleText",
 CellID->347843897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769181745],

Cell[BoxData[
 GraphicsBox[CircleBox[ImageScaled[{0.2, 0.2}], 0.2],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2128174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43653936],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, ImageScaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->465230810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191738588],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->11628004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", ".5"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->690732740],

Cell[BoxData[
 GraphicsBox[CircleBox[Offset[{10, 10}, {0, 0}], 0.5],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->148288687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->476765889],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " to specify the radii in printer's points: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21521]
}], "ExampleText",
 CellID->236972502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->722703368],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, Offset[{10., 40.}, {0., 0.}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->149393936]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17210],

Cell["The square packing of circles:", "ExampleText",
 CellID->260968007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394677528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD1P3EAQ3bs93xHQXcinoEFXQoEEDaJAgiqhiURJCYoiJUUUlKSgo0hB
gQQ/gZKSgkg0SBEVJSUldJSUlJe3O3tex/hYO/ZFKR4SxjPzZjye/fTTineb
3z9++Lz5/dP7ze7br5tbHz+9/9Z98+UrVLqmlPqJ3x8TCvc93Nnfn70e/iav
HXPVFxcXv+yPquPyIkP3Mqcur28Wzuaixsy1AXFjY2N8fHxxcbGxsrKi9MjI
yNra2uHhoWoHEZ0KEFU8JRzDvq16Yq7R1dXV6uoqADDc3d2pyGrv7++Pj48R
YG5uzlSqCHZ0SNhh5VC4DmrE9qPT01PUFlepp768vIT7wcGBagXsIf9hx8/l
71AoB+piKiKjdmtra2dnx3axgD0qaS8bP+TftG9prxptCxRaW433USiEua0H
7LqkvWz8kL+tkqvV7e3t9PS0qcVzWwA0NxxxGxusvhXrkyYVtP1NvEE+OtZL
O7o3WF9fPzo6MrcWFaHPYmTiVgzKzvDNWBsbHtUXi5KN1rHW5dtIaWU9wgS8
v78PlXploZAxvwhqgCbsk0ZoQcS9x+Wyvb29u7vrc0HuMzMzULm4kPFGghqg
CfukEVoQ6VzQ0phwfS5odq01VC4uZCxdghqgCfukEVoQ6VzMHsX+OBTk6+tr
L3e7XYGo15lyCJ9hd7Idu26EQwWDR0FutVrYq7go8/Pzk5OTPqqXQ/hsO6Z+
COksUCsU0HtBHh0dNSufeC0sLExNTfksvBzCZ9v9KE9m4dsp2Y7o8c5rdna2
3W77LLwcwmfbMXIg+CykX2C/hAnVe9VqtZubGy9PTEygombOfZ0ph/AZdsyB
6Sx8hV722xGJmQpKr5d+I6gBmrBPGpHojcmRgiUFC4vPBfLy8jJULq7Y5TpA
E/ZJIxJPTeaCUiFDU02bSwNteHZ2JiqriaRVU7hsbV7vh7hE35HsolTOsk5h
F4JNJG7F4FaYWBsbHtUXi5KN1rH2j3UVr4PuYGaHZ0Zuof0xQUh3TNl0bHN7
j4L2MrFz+sqep9nvJ9DCpp72xz5kM/Z1wN4oaS8bP+Qv+1fZpctuwNSi3a8F
amP29lHA3ixpLxs/5G/fT75IGvLu6Mu4sV9iDfQBbDVkDLZyYPLE+ZfPyh3H
fdFiKGPywQDG/s7MSrYPRagTnLFwYyNmdtZFsGNDwg4rhyJx5Wt9rF9jTH3Y
GTebzQa2ZErjgwlhzMhqBxGdChBVPCUcYyzxzuSzyGeRzyKfRT6LfBb5LPJZ
5LPIZ3kv8lnks8hnkc8in0U+63/gs87Pz+1nfh7OZzD2IZdUDXZYORSJm+Sz
Tk5OlpaWoiiq1+vCAeEGG4O9vT3HmDyG6FSAqOIp4RjkdsjtkNsht0Nuh9wO
uR1yOz1yO+R2yO2Q2yG3Q26noJ3cDs8q/csceFaJZ5V4Vol8Fvks8lnks8hn
+VzIZ5HPSmdBPqtHPqtHPot8Fvks8lnks/5nPotnlXhWiWeVyO38hT+5HXI7
PXI7OdHkdsjtkNsht0Nuh9xOj9wOuR1yO+R2KozDs0pVnVXCOhc4AZSB6FSA
qOIp4RjC7Tz8X+ZyVbXfSKBInw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24134530]
}, Open  ]],

Cell["The hexagonal packing of circles:", "ExampleText",
 CellID->52340893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", "j"}], "+", "1"}], ")"}], "/", 
          "4"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}], "j"}]}], "}"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54037755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369295914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130086699],

Cell["Define the circumcenter of a triangle:", "ExampleText",
 CellID->12452454],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CircumCenter", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3_", ",", "y3_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "bx", ",", "by"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
      
      RowBox[{"bx", "=", 
       RowBox[{"-", 
        RowBox[{"Det", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x1", "^", "2"}], "+", 
              RowBox[{"y1", "^", "2"}]}], ",", "y1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x2", "^", "2"}], "+", 
              RowBox[{"y2", "^", "2"}]}], ",", "y2", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x3", "^", "2"}], "+", 
              RowBox[{"y3", "^", "2"}]}], ",", "y3", ",", "1"}], "}"}]}], 
          "}"}], "]"}]}]}], ";", 
      RowBox[{"by", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"x1", "^", "2"}], "+", 
             RowBox[{"y1", "^", "2"}]}], ",", "x1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"x2", "^", "2"}], "+", 
             RowBox[{"y2", "^", "2"}]}], ",", "x2", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"x3", "^", "2"}], "+", 
             RowBox[{"y3", "^", "2"}]}], ",", "x3", ",", "1"}], "}"}]}], 
         "}"}], "]"}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "bx"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "a"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", "by"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "a"}], ")"}]}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240838594],

Cell["Draw the circumcircle of an arbitrary triangle:", "ExampleText",
 CellID->504349181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", "c"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"c", "=", 
     RowBox[{"CircumCenter", "[", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "]"}]}], ";", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2", ",", "p3", ",", "p1"}], "}"}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Circle", "[", 
        RowBox[{"c", ",", 
         RowBox[{"Norm", "[", 
          RowBox[{"p1", "-", "c"}], "]"}]}], "]"}], ",", "Dashed", ",", 
       "Blue", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p1", ",", "c"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"p2", ",", "c"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"p3", ",", "c"}], "}"}]}], "}"}], "]"}]}], "}"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40644336],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{0.8582160842413675, 0.20240799241278284`}, {0.6008119073758629, 
    0.3483832786506722}, {0.8215830657665899, 0.5680415224637543}, {
    0.8582160842413675, 0.20240799241278284`}}], 
   {RGBColor[1, 0, 0], 
    CircleBox[{0.7889010122969466, 0.38011518422824764`}, 
     0.1907470189061906]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], 
    LineBox[{{{0.8582160842413675, 0.20240799241278284`}, {0.7889010122969466,
      0.38011518422824764`}}, {{0.6008119073758629, 0.3483832786506722}, {
     0.7889010122969466, 0.38011518422824764`}}, {{0.8215830657665899, 
     0.5680415224637543}, {0.7889010122969466, 
     0.38011518422824764`}}}]}}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->352463015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->795142],

Cell["Simulation of elliptical gears:", "ExampleText",
 CellID->22599527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "=", "4"}], ",", 
       RowBox[{"b", "=", "3"}], ",", "f", ",", "r"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], "]"}]}], ";", 
      RowBox[{"r", "=", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}], ";", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "a"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "f"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", "\[Theta]", ",", 
            
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          RowBox[{"Translate", "[", 
           RowBox[{
            RowBox[{"Rotate", "[", 
             RowBox[{
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "f"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"ArcTan", "[", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"2", " ", "f"}], "+", 
                  RowBox[{"r", " ", 
                   RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
                 RowBox[{"r", " ", 
                  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "a"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "a"}], ",", 
             RowBox[{"4", "a"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "a"}], ",", 
             RowBox[{"2", "a"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541567839],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], 0, 2 Pi}}, Typeset`size$$ = {
    250., {81., 86.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Theta]$155$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$155$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`a$ = 4, $CellContext`b$ = 
         3, $CellContext`f$, $CellContext`r$}, $CellContext`f$ = 
         Sqrt[$CellContext`a$^2 - $CellContext`b$^2]; $CellContext`r$ = \
$CellContext`b$^2/($CellContext`a$ + $CellContext`f$ 
           Cos[$CellContext`\[Theta]$$]); Graphics[{
           Point[{{0, 0}, {2 $CellContext`a$, 0}}], 
           Rotate[
            
            Circle[{-$CellContext`f$, 
              0}, {$CellContext`a$, $CellContext`b$}], \
$CellContext`\[Theta]$$, {0, 0}], 
           Translate[
            Rotate[
             
             Circle[{-$CellContext`f$, 
               0}, {$CellContext`a$, $CellContext`b$}], -
             ArcTan[2 $CellContext`f$ + $CellContext`r$ 
                Cos[$CellContext`\[Theta]$$], $CellContext`r$ 
               Sin[$CellContext`\[Theta]$$]], {0, 0}], {
            2 $CellContext`a$, 0}]}, 
          PlotRange -> {{(-2) $CellContext`a$, 
             4 $CellContext`a$}, {(-2) $CellContext`a$, 2 $CellContext`a$}}, 
          ImageSize -> 250]], 
      "Specifications" :> {{$CellContext`\[Theta]$$, 0, 2 Pi, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {118., 123.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 243},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692884552]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7584],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " to get all possible ellipses: "
}], "ExampleText",
 CellID->19774549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Pi", "/", "6"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41587213],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[{0, 0}, {4., 2.}], {{{0.8660254037844386, -0.5}, {0.5, 
    0.8660254037844386}}, Center}],
  Axes->True]], "Output",
 ImageSize->{154, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->185501869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->458436459],

Cell[TextData[{
 "To create a filled circle use ",
 Cell[BoxData[
  ButtonBox["Disk",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Disk"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->181128799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332855667],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->307130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55359977],

Cell[TextData[{
 "The 3D generalization is ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->784171270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->776698211],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1029903139,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448823372],

Cell[TextData[{
 "An implicit specification of circle can be generated by ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->384663837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75687518],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAlsVFUUhoeCoolFVGICBspSAYmIAsUagYPBmKAYKIuiCUogLBI2IawV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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1Gl8CAQYBvDNNrPLsHs228zYfR92JXSJrhEpJZOKakN3SclRuuhQObov
R+VIpwihVKKD7nJ3UBRdCP/9+vB/3s/Ph+fNaGxuaAoMCAg4QbTcVgQRTAit
CaUNYYQTQSRRtCWadrSnAzHEEkc8CSSSRDIdSSGVTqSRTgadyaQLWXSlG9nk
kEse+RRQSBHFlFBKGeVUUEkV3ammhlrqqG/pTQ9OpCe96M1JnMwpnMpp9OF0
+tKPMziTszibc2igPwM4l4EM4jwGcz4XMIQLuYihXMwwGhnOJYzgUi7jckYy
iiu4kqtoopnRjGEsV3MN13Id13MDN3ITNzOOWxjPrdzGBG5nIpOYzBTu4E6m
chd3cw/3ch/TmM79PMCDPMQMHuYRHmUms5jNHB7jcZ7gSZ7iaZ7hWZ7jeV5g
LvOYzwJe5CVeZiGLWMwSXmEpr/Iar/MGb/IWy3ib5azgHVayitW8yxrWso73
eJ/1fMCHfMQGPmYjm/iET/mMz9nMFr7gS77ia77hW77je35gK9vYzg52sovd
/MhP/Mwv7GEvv/Ib+9jP7/zBAQ7yJ3/xN//wL4c4zBH+4yjHaBl/IK0IIpgQ
WhNKG8IIJ4JIomhLNO1oTwdiiCWOeBJIJIlkOpJCKp1II50MOpNJF7LoSjey
ySGXPPIpoJAiiimhlDLKqaCSKrpTTQ211FEf+P/fOw6q4YlT
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6431290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637186864],

Cell[TextData[{
 "A parametric specification of circle can be generated by ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->164430465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537925578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->200846003]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22412],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " radii, will depend on the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->353119521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207375245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    PlotRange->{{-1, 1}, {-1, 1}}], ",", 
   GraphicsBox[CircleBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-2, 
         FormBox[
          RowBox[{"-", "2"}], TraditionalForm]}, {2, 
         FormBox["2", TraditionalForm]}}, None}},
    PlotRange->{{-2, 2}, {-1, 1}}], ",", 
   GraphicsBox[CircleBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-3, 
         FormBox[
          RowBox[{"-", "3"}], TraditionalForm]}, {3, 
         FormBox["3", TraditionalForm]}}, None}},
    PlotRange->{{-3, 3}, {-1, 1}}]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->579848841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309175476],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " sizes, will depend on the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14956960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->42263118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->50], ",", 
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->70], ",", 
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->670247392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->284727558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->1,
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 2], 0.5],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[CircleBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 3], 0.3333333333333333],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->428995877]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21593],

Cell["Random circles:", "ExampleText",
 CellID->337773766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], ",", 
        RowBox[{"RandomReal", "[", "1", "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "40", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400388102],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.8489968076807732], 
    CircleBox[{3.7496179975853616`, 2.4281990778004605`}, 
     0.8035774995699558]}, 
   {Hue[0.2674719647075108], 
    CircleBox[{3.136016210084808, 1.9762928192010207`}, 
     0.6071747297254271]}, 
   {Hue[0.49708665868853763`], 
    CircleBox[{1.5778640073101053`, 1.0856973966087216`}, 
     0.17512189720217153`]}, 
   {Hue[0.4974162601823753], 
    CircleBox[{3.0094069182066345`, 0.5823132244722737}, 
     0.3676524081439245]}, 
   {Hue[0.583203168766846], 
    CircleBox[{0.500742310557662, 3.5139702937582484`}, 
     0.0672240610236503]}, 
   {Hue[0.8200054431133412], 
    CircleBox[{1.5150495325512496`, 2.664036447176329}, 
     0.1265576351753499]}, 
   {Hue[0.0334833771484504], 
    CircleBox[{0.5715035156248902, 0.9275099929635138}, 
     0.5915597072996543]}, 
   {Hue[0.8507662167742374], 
    CircleBox[{0.6750119409401805, 0.9704334624120508}, 
     0.7858747507947901]}, 
   {Hue[0.3338098939287246], 
    CircleBox[{0.018192850483736756`, 1.8409207935625487`}, 
     0.6511597114372623]}, 
   {Hue[0.5157817059656649], 
    CircleBox[{3.843496329537545, 2.6999039648172225`}, 
     0.07087430981206144]}, 
   {Hue[0.05365852182537534], 
    CircleBox[{2.2880470198963563`, 3.8341623919974017`}, 
     0.5489633422703064]}, 
   {Hue[0.448438356384383], 
    CircleBox[{2.2076610433086064`, 3.911438632494944}, 
     0.8223593376748368]}, 
   {Hue[0.8816058939574587], 
    CircleBox[{0.2711007195722628, 0.6143113139478622}, 
     0.7298637019712044]}, 
   {Hue[0.3098016106630599], 
    CircleBox[{1.5058813620070888`, 3.393754068980156}, 
     0.5905073343706315]}, 
   {Hue[0.5367080213210447], 
    CircleBox[{1.3726774063737661`, 2.486428857047901}, 0.821279121980766]}, 
   {Hue[0.7721461132885559], 
    CircleBox[{2.173853175294739, 0.49956833340440454`}, 
     0.9991555652336161]}, 
   {Hue[0.7204491215429685], 
    CircleBox[{1.9292563307439643`, 3.7923716331057085`}, 
     0.5107194467471308]}, 
   {Hue[0.08218002971715577], 
    CircleBox[{0.07669718915984891, 1.9441978631128984`}, 
     0.4553026156480888]}, 
   {Hue[0.7039519480962175], 
    CircleBox[{3.0411699899319604`, 0.8698225647380866}, 
     0.10526072093861116`]}, 
   {Hue[0.9566082411632757], 
    CircleBox[{0.2422640398081084, 0.41022813080378473`}, 
     0.7666960691570146]}, 
   {Hue[0.9338414590694875], 
    CircleBox[{0.3150140490912534, 1.8855966604527818`}, 
     0.3223187546334394]}, 
   {Hue[0.025332596526494555`], 
    CircleBox[{1.430259811735394, 3.9564050878091024`}, 
     0.6659757858091182]}, 
   {Hue[0.3250122921106091], 
    CircleBox[{1.7723830916159962`, 2.6096137959603345`}, 
     0.9736350104059741]}, 
   {Hue[0.7843167490933247], 
    CircleBox[{1.7997368196697279`, 3.0386137854497406`}, 
     0.6722532365952556]}, 
   {Hue[0.8336732236305247], 
    CircleBox[{2.959628972768158, 3.8051681152354186`}, 
     0.7244469795107409]}, 
   {Hue[0.4800756409201776], 
    CircleBox[{3.8727721856871744`, 1.9502506528641605`}, 
     0.16387655326601713`]}, 
   {Hue[0.5046147334596998], 
    CircleBox[{3.4366997822538456`, 1.7595575917323005`}, 
     0.9119301696169717]}, 
   {Hue[0.13028480679883225`], 
    CircleBox[{3.140183907640468, 0.039614933518573814`}, 
     0.1084148394364659]}, 
   {Hue[0.12494631553588409`], 
    CircleBox[{0.5412328762314935, 0.36981894334419785`}, 
     0.306409605833754]}, 
   {Hue[0.10571546914673435`], 
    CircleBox[{2.183947977784708, 3.9088625259112133`}, 
     0.8830075704933771]}, 
   {Hue[0.9131435513204778], 
    CircleBox[{2.137908884628046, 0.1140538457567084}, 0.1299692090947997]}, 
   {Hue[0.047479425956952426`], 
    CircleBox[{1.0957345433710568`, 0.4955533330571491}, 
     0.701436499660981]}, 
   {Hue[0.08685402916465979], 
    CircleBox[{1.7259267478555795`, 0.981880566924942}, 
     0.8290822394976776]}, 
   {Hue[0.14839207386070474`], 
    CircleBox[{0.1843499810363829, 1.7575604538770282`}, 
     0.7125139368354969]}, 
   {Hue[0.9305287566049232], 
    CircleBox[{3.793332674233577, 2.014885618833647}, 0.5768371427845056]}, 
   {Hue[0.32836869889842046`], 
    CircleBox[{2.5501924520333423`, 0.013972433631649572`}, 
     0.155413680260013]}, 
   {Hue[0.05640846637878805], 
    CircleBox[{0.21920652455885037`, 3.0819680066581725`}, 
     0.6540218321471118]}, 
   {Hue[0.2953026110581296], 
    CircleBox[{1.8119377379609727`, 0.7151440816565184}, 
     0.5295561263802901]}, 
   {Hue[0.528011415391731], 
    CircleBox[{0.7168543587311804, 0.7255856029975041}, 0.541607416475796]}, 
   {Hue[0.3708743542048756], 
    CircleBox[{0.016705818432408037`, 3.8147135686509017`}, 
     0.8678647825120807]}}]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83786383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392096790],

Cell["The seed of life:", "ExampleText",
 CellID->274589147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Thick", ",", "Orange", ",", 
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "Pi", " ", 
            RowBox[{"i", "/", "6"}]}], "]"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"i", "/", "6"}]}], "]"}]}], "}"}], ",", "1"}], "]"}], ",",
       
      RowBox[{"{", 
       RowBox[{"i", ",", "6"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329009926],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0], Thickness[Large], 
   CircleBox[{0, 0}], {
    CircleBox[
     NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {0.5, 
      0.8660254037844386}]], 
    CircleBox[
     NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
      0.8660254037844386}]], CircleBox[{-1, 0}], 
    CircleBox[
     NCache[{Rational[-1, 2], Rational[-1, 2] 
       3^Rational[1, 2]}, {-0.5, -0.8660254037844386}]], 
    CircleBox[
     NCache[{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
      0.5, -0.8660254037844386}]], CircleBox[{1, 0}]}}]], "Output",
 ImageSize->{184, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85725816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235941495],

Cell["A family of circles:", "ExampleText",
 CellID->295179799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"t", "/", "20"}], "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"t", "/", "20"}]}], "]"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"t", "/", "20"}]}], "]"}]}], "}"}], ",", "1"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54842079],

Cell[BoxData[
 GraphicsBox[{
   {Hue[
     NCache[
      Rational[1, 20], 0.05]], 
    CircleBox[
     NCache[{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
      0.9510565162951535, 0.30901699437494745`}]]}, 
   {Hue[
     NCache[
      Rational[1, 10], 0.1]], 
    CircleBox[
     NCache[{Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.8090169943749475, 0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[3, 20], 0.15]], 
    CircleBox[
     NCache[{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}, {
      0.5877852522924731, 0.8090169943749475}]]}, 
   {Hue[
     NCache[
      Rational[1, 5], 0.2]], 
    CircleBox[
     NCache[{Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.30901699437494745`, 0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[1, 4], 0.25]], CircleBox[{0, 1}]}, 
   {Hue[
     NCache[
      Rational[3, 10], 0.3]], 
    CircleBox[
     NCache[{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {-0.30901699437494745`, 0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[7, 20], 0.35]], 
    CircleBox[
     NCache[{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2])}, {-0.5877852522924731, 
      0.8090169943749475}]]}, 
   {Hue[
     NCache[
      Rational[2, 5], 0.4]], 
    CircleBox[
     NCache[{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {-0.8090169943749475, 0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[9, 20], 0.45]], 
    CircleBox[
     NCache[{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {-0.9510565162951535, 
      0.30901699437494745`}]]}, 
   {Hue[
     NCache[
      Rational[1, 2], 0.5]], CircleBox[{-1, 0}]}, 
   {Hue[
     NCache[
      Rational[11, 20], 0.55]], 
    CircleBox[
     NCache[{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (1 - 5^
        Rational[1, 2])}, {-0.9510565162951535, -0.30901699437494745`}]]}, 
   {Hue[
     NCache[
      Rational[3, 5], 0.6]], 
    CircleBox[
     NCache[{Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {-0.8090169943749475, -0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[13, 20], 0.65]], 
    CircleBox[
     NCache[{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[1, 4] (-1 - 5^
        Rational[1, 2])}, {-0.5877852522924731, -0.8090169943749475}]]}, 
   {Hue[
     NCache[
      Rational[7, 10], 0.7]], 
    CircleBox[
     NCache[{Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {-0.30901699437494745`, -0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[3, 4], 0.75]], CircleBox[{0, -1}]}, 
   {Hue[
     NCache[
      Rational[4, 5], 0.8]], 
    CircleBox[
     NCache[{Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.30901699437494745`, -0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[17, 20], 0.85]], 
    CircleBox[
     NCache[{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
      0.5877852522924731, -0.8090169943749475}]]}, 
   {Hue[
     NCache[
      Rational[9, 10], 0.9]], 
    CircleBox[
     NCache[{Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.8090169943749475, -0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[19, 20], 0.95]], 
    CircleBox[
     NCache[{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2])}, {
      0.9510565162951535, -0.30901699437494745`}]]}, 
   {Hue[1], CircleBox[{1, 0}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226959996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399486017],

Cell["Ying and Yang:", "ExampleText",
 CellID->99903589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "Pi"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
          RowBox[{"{", 
           RowBox[{"Pi", ",", 
            RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{"Pi", ",", 
            RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "Pi"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "2.1"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"Circle", "[", "x__", "]"}], "\[RuleDelayed]", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "x", "]"}], ",", 
       RowBox[{"d", " ", "Degree"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0", ",", "360"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352282185],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`d$$], 0, 360}}, Typeset`size$$ = {150., {73., 77.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`d$283176$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`d$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`d$$, $CellContext`d$283176$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ReplaceAll[
        Graphics[{Thick, 
          Circle[{0, 0}, 2, {0, Pi}], 
          Circle[{0, 0}, 2, {Pi, 2 Pi}], 
          Circle[{-1, 0}, 1, {Pi, 2 Pi}], 
          Circle[{1, 0}, 1, {0, Pi}]}, PlotRange -> 2.1, ImageSize -> 150], 
        Circle[
          Pattern[$CellContext`x$, 
           BlankSequence[]]] :> Rotate[
          Circle[$CellContext`x$], $CellContext`d$$ Degree, {0, 0}]], 
      "Specifications" :> {{$CellContext`d$$, 0, 360, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {110., 115.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491976137]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cylinder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cylinder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sphere",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sphere"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25920]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Circle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Circle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->124754510],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->522941699],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->21349092],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->48762001],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->68245333]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Circle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 31.1649516}", "context" -> "System`", 
    "keywords" -> {
     "arc of circle", "circular arc", "ellipse", "oval", "elliptical arc", 
      "circle"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Circle[{x, y}, r] is a two-dimensional graphics primitive that \
represents a circle of radius r centered at the point x, y. Circle[{x, y}] \
gives a circle of radius 1. Circle[{x, y}, r, {\\[Theta]_1, \\[Theta]_2}] \
gives a circular arc. Circle[{x, y}, {r_x, r_y}] gives an ellipse with \
semi-axes of lengths r_x and r_y, oriented parallel to the coordinate axes. ",
     "synonyms" -> {}, "title" -> "Circle", "type" -> "Symbol", "uri" -> 
    "ref/Circle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15040, 457, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->385951803]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 110530, 3341}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1952, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2575, 70, 4190, 83, 70, "ObjectNameGrid"],
Cell[6768, 155, 2850, 93, 70, "Usage",
 CellID->15824]
}, Open  ]],
Cell[CellGroupData[{
Cell[9655, 253, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10133, 270, 187, 6, 70, "Notes",
 CellID->7745],
Cell[10323, 278, 882, 30, 70, "Notes",
 CellID->21280],
Cell[11208, 310, 1288, 49, 70, "Notes",
 CellID->1116],
Cell[12499, 361, 725, 25, 70, "Notes",
 CellID->18889],
Cell[13227, 388, 501, 17, 70, "Notes",
 CellID->21521],
Cell[13731, 407, 289, 9, 70, "Notes",
 CellID->13249],
Cell[14023, 418, 391, 12, 70, "Notes",
 CellID->11916],
Cell[14417, 432, 586, 20, 70, "Notes",
 CellID->28744]
}, Closed]],
Cell[CellGroupData[{
Cell[15040, 457, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->385951803],
Cell[CellGroupData[{
Cell[15425, 471, 148, 5, 70, "ExampleSection",
 CellID->241970772],
Cell[15576, 478, 56, 1, 70, "ExampleText",
 CellID->77469350],
Cell[CellGroupData[{
Cell[15657, 483, 132, 4, 28, "Input",
 CellID->278347667],
Cell[15792, 489, 241, 7, 121, "Output",
 CellID->120115758]
}, Open  ]],
Cell[16048, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->110273157],
Cell[16176, 504, 57, 1, 70, "ExampleText",
 CellID->77089960],
Cell[CellGroupData[{
Cell[16258, 509, 351, 12, 70, "Input",
 CellID->69305470],
Cell[16612, 523, 343, 10, 56, "Output",
 CellID->61971911]
}, Open  ]],
Cell[16970, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->596191197],
Cell[17098, 541, 54, 1, 70, "ExampleText",
 CellID->144681104],
Cell[CellGroupData[{
Cell[17177, 546, 89, 2, 70, "Input",
 CellID->474423382],
Cell[17269, 550, 251, 7, 153, "Output",
 CellID->586622014]
}, Open  ]],
Cell[17535, 560, 125, 3, 70, "ExampleDelimiter",
 CellID->599660581],
Cell[17663, 565, 70, 1, 70, "ExampleText",
 CellID->345044910],
Cell[CellGroupData[{
Cell[17758, 570, 653, 20, 70, "Input",
 CellID->312736669],
Cell[18414, 592, 559, 17, 123, "Output",
 CellID->251592980]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19022, 615, 217, 7, 70, "ExampleSection",
 CellID->16790],
Cell[CellGroupData[{
Cell[19264, 626, 240, 7, 70, "ExampleSubsection",
 CellID->32802836],
Cell[19507, 635, 57, 1, 70, "ExampleText",
 CellID->304149056],
Cell[CellGroupData[{
Cell[19589, 640, 511, 18, 70, "Input",
 CellID->70247180],
Cell[20103, 660, 290, 8, 121, "Output",
 CellID->28989858]
}, Open  ]],
Cell[20408, 671, 125, 3, 70, "ExampleDelimiter",
 CellID->128386129],
Cell[20536, 676, 57, 1, 70, "ExampleText",
 CellID->8232083],
Cell[CellGroupData[{
Cell[20618, 681, 510, 18, 70, "Input",
 CellID->5294749],
Cell[21131, 701, 285, 8, 121, "Output",
 CellID->103836346]
}, Open  ]],
Cell[21431, 712, 124, 3, 70, "ExampleDelimiter",
 CellID->51413470],
Cell[21558, 717, 58, 1, 70, "ExampleText",
 CellID->628243246],
Cell[CellGroupData[{
Cell[21641, 722, 323, 11, 70, "Input",
 CellID->40833855],
Cell[21967, 735, 308, 9, 115, "Output",
 CellID->128189321]
}, Open  ]],
Cell[CellGroupData[{
Cell[22312, 749, 347, 12, 70, "Input",
 CellID->133890409],
Cell[22662, 763, 332, 10, 89, "Output",
 CellID->199332788]
}, Open  ]],
Cell[23009, 776, 124, 3, 70, "ExampleDelimiter",
 CellID->65223652],
Cell[23136, 781, 53, 1, 70, "ExampleText",
 CellID->73292735],
Cell[CellGroupData[{
Cell[23214, 786, 89, 2, 70, "Input",
 CellID->509432554],
Cell[23306, 790, 249, 7, 89, "Output",
 CellID->36498140]
}, Open  ]],
Cell[23570, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->182452125],
Cell[23698, 805, 183, 7, 70, "ExampleText",
 CellID->286759351],
Cell[CellGroupData[{
Cell[23906, 816, 374, 13, 70, "Input",
 CellID->47897404],
Cell[24283, 831, 315, 9, 85, "Output",
 CellID->754413579]
}, Open  ]],
Cell[24613, 843, 125, 3, 70, "ExampleDelimiter",
 CellID->321911792],
Cell[24741, 848, 208, 7, 70, "ExampleText",
 CellID->628760335],
Cell[CellGroupData[{
Cell[24974, 859, 244, 7, 70, "Input",
 CellID->287232931],
Cell[25221, 868, 254, 8, 167, "Output",
 CellID->44921650]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25524, 882, 233, 7, 70, "ExampleSubsection",
 CellID->1873092],
Cell[25760, 891, 200, 7, 70, "ExampleText",
 CellID->112891434],
Cell[CellGroupData[{
Cell[25985, 902, 425, 14, 70, "Input",
 CellID->14466464],
Cell[26413, 918, 501, 16, 123, "Output",
 CellID->347397690]
}, Open  ]],
Cell[26929, 937, 68, 1, 70, "ExampleText",
 CellID->220038262],
Cell[CellGroupData[{
Cell[27022, 942, 401, 14, 70, "Input",
 CellID->388303278],
Cell[27426, 958, 430, 14, 123, "Output",
 CellID->586862717]
}, Open  ]],
Cell[27871, 975, 71, 1, 70, "ExampleText",
 CellID->27522066],
Cell[CellGroupData[{
Cell[27967, 980, 404, 13, 70, "Input",
 CellID->165797838],
Cell[28374, 995, 447, 14, 123, "Output",
 CellID->84705645]
}, Open  ]],
Cell[28836, 1012, 125, 3, 70, "ExampleDelimiter",
 CellID->129908792],
Cell[28964, 1017, 58, 1, 70, "ExampleText",
 CellID->568010029],
Cell[CellGroupData[{
Cell[29047, 1022, 500, 16, 70, "Input",
 CellID->458399147],
Cell[29550, 1040, 465, 15, 123, "Output",
 CellID->359946853]
}, Open  ]],
Cell[30030, 1058, 125, 3, 70, "ExampleDelimiter",
 CellID->410953990],
Cell[30158, 1063, 59, 1, 70, "ExampleText",
 CellID->470570762],
Cell[CellGroupData[{
Cell[30242, 1068, 383, 13, 70, "Input",
 CellID->78751695],
Cell[30628, 1083, 504, 16, 123, "Output",
 CellID->61420134]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31181, 1105, 255, 7, 70, "ExampleSubsection",
 CellID->762801493],
Cell[31439, 1114, 314, 12, 70, "ExampleText",
 CellID->374620981],
Cell[CellGroupData[{
Cell[31778, 1130, 316, 10, 70, "Input",
 CellID->73519992],
Cell[32097, 1142, 273, 8, 162, "Output",
 CellID->641832794]
}, Open  ]],
Cell[CellGroupData[{
Cell[32407, 1155, 313, 10, 70, "Input",
 CellID->61585090],
Cell[32723, 1167, 270, 8, 163, "Output",
 CellID->139911056]
}, Open  ]],
Cell[CellGroupData[{
Cell[33030, 1180, 370, 12, 70, "Input",
 CellID->518233082],
Cell[33403, 1194, 277, 8, 163, "Output",
 CellID->182355327]
}, Open  ]],
Cell[33695, 1205, 124, 3, 70, "ExampleDelimiter",
 CellID->70916749],
Cell[33822, 1210, 215, 8, 70, "ExampleText",
 CellID->347843897],
Cell[CellGroupData[{
Cell[34062, 1222, 322, 10, 70, "Input",
 CellID->769181745],
Cell[34387, 1234, 276, 8, 162, "Output",
 CellID->2128174]
}, Open  ]],
Cell[CellGroupData[{
Cell[34700, 1247, 374, 12, 70, "Input",
 CellID->43653936],
Cell[35077, 1261, 282, 8, 163, "Output",
 CellID->465230810]
}, Open  ]],
Cell[35374, 1272, 125, 3, 70, "ExampleDelimiter",
 CellID->191738588],
Cell[35502, 1277, 194, 8, 70, "ExampleText",
 CellID->11628004],
Cell[CellGroupData[{
Cell[35721, 1289, 403, 13, 70, "Input",
 CellID->690732740],
Cell[36127, 1304, 279, 8, 163, "Output",
 CellID->148288687]
}, Open  ]],
Cell[36421, 1315, 125, 3, 70, "ExampleDelimiter",
 CellID->476765889],
Cell[36549, 1320, 308, 11, 70, "ExampleText",
 CellID->236972502],
Cell[CellGroupData[{
Cell[36882, 1335, 369, 12, 70, "Input",
 CellID->722703368],
Cell[37254, 1349, 286, 8, 163, "Output",
 CellID->149393936]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37601, 1364, 223, 7, 70, "ExampleSection",
 CellID->17210],
Cell[37827, 1373, 73, 1, 70, "ExampleText",
 CellID->260968007],
Cell[CellGroupData[{
Cell[37925, 1378, 415, 14, 70, "Input",
 CellID->394677528],
Cell[38343, 1394, 1826, 34, 70, "Output",
 Evaluatable->False,
 CellID->24134530]
}, Open  ]],
Cell[40184, 1431, 75, 1, 70, "ExampleText",
 CellID->52340893],
Cell[CellGroupData[{
Cell[40284, 1436, 737, 25, 70, "Input",
 CellID->54037755],
Cell[41024, 1463, 2425, 44, 70, "Output",
 Evaluatable->False,
 CellID->369295914]
}, Open  ]],
Cell[43464, 1510, 125, 3, 70, "ExampleDelimiter",
 CellID->130086699],
Cell[43592, 1515, 80, 1, 70, "ExampleText",
 CellID->12452454],
Cell[43675, 1518, 2555, 79, 70, "Input",
 CellID->240838594],
Cell[46233, 1599, 90, 1, 70, "ExampleText",
 CellID->504349181],
Cell[CellGroupData[{
Cell[46348, 1604, 1267, 39, 70, "Input",
 CellID->40644336],
Cell[47618, 1645, 888, 19, 171, "Output",
 CellID->352463015]
}, Open  ]],
Cell[48521, 1667, 122, 3, 70, "ExampleDelimiter",
 CellID->795142],
Cell[48646, 1672, 73, 1, 70, "ExampleText",
 CellID->22599527],
Cell[CellGroupData[{
Cell[48744, 1677, 3140, 90, 70, "Input",
 CellID->541567839],
Cell[51887, 1769, 2940, 65, 70, "Output",
 CellID->692884552]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54876, 1840, 232, 7, 70, "ExampleSection",
 CellID->7584],
Cell[55111, 1849, 212, 8, 70, "ExampleText",
 CellID->19774549],
Cell[CellGroupData[{
Cell[55348, 1861, 425, 14, 70, "Input",
 CellID->41587213],
Cell[55776, 1877, 372, 11, 133, "Output",
 CellID->185501869]
}, Open  ]],
Cell[56163, 1891, 125, 3, 70, "ExampleDelimiter",
 CellID->458436459],
Cell[56291, 1896, 205, 8, 70, "ExampleText",
 CellID->181128799],
Cell[CellGroupData[{
Cell[56521, 1908, 182, 6, 70, "Input",
 CellID->332855667],
Cell[56706, 1916, 264, 8, 121, "Output",
 CellID->307130]
}, Open  ]],
Cell[56985, 1927, 124, 3, 70, "ExampleDelimiter",
 CellID->55359977],
Cell[57112, 1932, 205, 8, 70, "ExampleText",
 CellID->784171270],
Cell[CellGroupData[{
Cell[57342, 1944, 134, 4, 70, "Input",
 CellID->776698211],
Cell[57479, 1950, 13179, 221, 129, 62, 1, "CachedBoxData", "BoxData", \
"Output",
 CellID->1029903139]
}, Open  ]],
Cell[70673, 2174, 125, 3, 70, "ExampleDelimiter",
 CellID->448823372],
Cell[70801, 2179, 245, 8, 70, "ExampleText",
 CellID->384663837],
Cell[CellGroupData[{
Cell[71071, 2191, 407, 14, 70, "Input",
 CellID->75687518],
Cell[71481, 2207, 4088, 80, 70, "Output",
 CellID->6431290]
}, Open  ]],
Cell[75584, 2290, 125, 3, 70, "ExampleDelimiter",
 CellID->637186864],
Cell[75712, 2295, 252, 8, 70, "ExampleText",
 CellID->164430465],
Cell[CellGroupData[{
Cell[75989, 2307, 353, 11, 70, "Input",
 CellID->537925578],
Cell[76345, 2320, 3575, 63, 70, "Output",
 Evaluatable->False,
 CellID->200846003]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79969, 2389, 226, 7, 70, "ExampleSection",
 CellID->22412],
Cell[80198, 2398, 338, 13, 70, "ExampleText",
 CellID->353119521],
Cell[CellGroupData[{
Cell[80561, 2415, 1200, 40, 70, "Input",
 CellID->207375245],
Cell[81764, 2457, 1386, 38, 127, "Output",
 CellID->579848841]
}, Open  ]],
Cell[83165, 2498, 125, 3, 70, "ExampleDelimiter",
 CellID->309175476],
Cell[83293, 2503, 482, 18, 70, "ExampleText",
 CellID->14956960],
Cell[CellGroupData[{
Cell[83800, 2525, 1093, 36, 70, "Input",
 CellID->42263118],
Cell[84896, 2563, 1429, 38, 126, "Output",
 CellID->670247392]
}, Open  ]],
Cell[CellGroupData[{
Cell[86362, 2606, 1198, 38, 70, "Input",
 CellID->284727558],
Cell[87563, 2646, 1520, 42, 127, "Output",
 CellID->428995877]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89132, 2694, 224, 7, 70, "ExampleSection",
 CellID->21593],
Cell[89359, 2703, 58, 1, 70, "ExampleText",
 CellID->337773766],
Cell[CellGroupData[{
Cell[89442, 2708, 520, 16, 70, "Input",
 CellID->400388102],
Cell[89965, 2726, 4811, 122, 197, "Output",
 CellID->83786383]
}, Open  ]],
Cell[94791, 2851, 125, 3, 70, "ExampleDelimiter",
 CellID->392096790],
Cell[94919, 2856, 60, 1, 70, "ExampleText",
 CellID->274589147],
Cell[CellGroupData[{
Cell[95004, 2861, 679, 21, 70, "Input",
 CellID->329009926],
Cell[95686, 2884, 746, 20, 189, "Output",
 CellID->85725816]
}, Open  ]],
Cell[96447, 2907, 125, 3, 70, "ExampleDelimiter",
 CellID->235941495],
Cell[96575, 2912, 63, 1, 70, "ExampleText",
 CellID->295179799],
Cell[CellGroupData[{
Cell[96663, 2917, 675, 22, 70, "Input",
 CellID->54842079],
Cell[97341, 2941, 4547, 134, 201, "Output",
 CellID->226959996]
}, Open  ]],
Cell[101903, 3078, 125, 3, 70, "ExampleDelimiter",
 CellID->399486017],
Cell[102031, 3083, 56, 1, 70, "ExampleText",
 CellID->99903589],
Cell[CellGroupData[{
Cell[102112, 3088, 1706, 49, 70, "Input",
 CellID->352282185],
Cell[103821, 3139, 2242, 50, 70, "Output",
 CellID->491976137]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106124, 3196, 311, 9, 70, "SeeAlsoSection",
 CellID->17192],
Cell[106438, 3207, 925, 35, 70, "SeeAlso",
 CellID->25920]
}, Open  ]],
Cell[CellGroupData[{
Cell[107400, 3247, 305, 8, 70, "RelatedLinksSection"],
Cell[107708, 3257, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108102, 3274, 319, 9, 70, "MoreAboutSection",
 CellID->124754510],
Cell[108424, 3285, 143, 3, 70, "MoreAbout",
 CellID->522941699],
Cell[108570, 3290, 150, 3, 70, "MoreAbout",
 CellID->21349092],
Cell[108723, 3295, 161, 3, 70, "MoreAbout",
 CellID->48762001],
Cell[108887, 3300, 196, 4, 70, "MoreAbout",
 CellID->68245333]
}, Open  ]],
Cell[109098, 3307, 50, 0, 70, "History"],
Cell[109151, 3309, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

