(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31822,       1200]
NotebookOptionsPosition[     23467,        914]
NotebookOutlinePosition[     25030,        956]
CellTagsIndexPosition[     24945,        951]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Clear\"\>", 2->"\<\"ClearAttributes\"\>", 
       3->"\<\"Remove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClearAll", "ObjectName",
 CellID->3947],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClearAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClearAll"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["symb", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["symb", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]clears all values, definitions, attributes, messages \
and defaults associated with symbols. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClearAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClearAll"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]clears all symbols whose names textually match any of \
the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->150348494],

Cell["Define values and attributes for a symbol: ", "ExampleText",
 CellID->429818932],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->110091192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61020240],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{585, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22164451]
}, Open  ]],

Cell["Clear values and attributes: ", "ExampleText",
 CellID->175583191],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->679611613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->426063475],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->392930122]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->358891435],

Cell["Clear values of variables:", "ExampleText",
 CellID->301706367],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126604733],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168486254],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->53040972],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156350399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347374944],

Cell["Clear functions (downvalues):", "ExampleText",
 CellID->37454990],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->179882384],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "fact", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371484883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->312638351],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`fact],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8964168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106859970],

Cell["Clear upvalues:", "ExampleText",
 CellID->627855],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"hf", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380574387],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "h", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202963165],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34461440],

Cell["Clear several symbols:", "ExampleText",
 CellID->180368890],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2420569],

Cell[BoxData[
 RowBox[{"ClearAll", "[", 
  RowBox[{"a", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->776255491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->133977497],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104975150]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->123103514],

Cell["Clear all symbols in a given context:", "ExampleText",
 CellID->362475358],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38138293],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167873059],

Cell["Specify symbols to clear as string patterns:", "ExampleText",
 CellID->437475939],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", "1"}], ";", 
  RowBox[{"x2", "=", "3"}], ";", 
  RowBox[{"y", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168901340],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237737555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29696549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "5"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->555928198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->364403238],

Cell["Clear any old definitions before making new ones:", "ExampleText",
 CellID->59344518],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "fib", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665750006],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "2", "]"}], "=", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->891805863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->962876173],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->815809105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405700832],

Cell["\<\
Unprotect and clear all symbols in a package, to allow it to be read twice:\
\>", "ExampleText",
 CellID->409801524],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418054590],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "\"\<`*\>\"", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<`*\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->367669465],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->561199423],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->196473886],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->101762440]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20023858],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " does not remove defaults, options or attributes: "
}], "ExampleText",
 CellID->477239184],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Default", "[", "f", "]"}], "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"opt1", "\[Rule]", "def1"}], ",", 
     RowBox[{"opt2", "\[Rule]", "def2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->128049439],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542553653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->364794754],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1u2zAMVi07XhdkXRYsW4Ee2kMPHdDb7tulDbZhDxEUA9LDsKLtY2/P
4Eou6Sqfqb846XaYgVohRZOfSIqU+n15v/rxc3l/fbU8Xtwub1bXV3fHl79u
DUvvKVVcKKXO3yvzuzG/2j9+FuZPqdq8tWF/MGNhxjGNb+2s7uQ7uc/An3j4
9vWttfACZs6AHgP9Buh9oD8RwgPgSwi+tggKwqjNWJqxItryK+IzbcdWQPFj
f/NXrn7+uozg1xHrL0F+RPyC5AuHluzVO9b/5MfWBHmkYLeQFE1WboYpL7cU
uUUGF1FqoDFaFa0OszHHZmCFgXwOrDWCF7XYrK9z8dbA9aDGXbYZ6kC0t5ZR
NWjLieBI+jYji6ZJ6w1EIxLhfa4zg/NlMgAZxqsahAy1YQzs60vzN7KBK7OY
xc9RSwI20qtIlaBtSDbsFllGbXA97UWfng+djn6WDagQ2P0T7EfXgB28dxLZ
OJb+vPDrxKzHzrE5OqwMOG9fntwg3ap92KoV4pMN73PtrI+12MfmYan6vSr3
lCfp1h4dM5BlezrwzasEO+jHaYKdWGcM+N6Rwtw4iUQ0tnuw36L8PGIf5Y8k
PL28jGnNPeWwr2cgcUhx4bzUjXz3ekd8Hscgf0r0XJjXHmSPdzPGv/hPrVEf
m/XbMM+W3WyoI7J0uzu6u6N713IrU9ElDxcv3vdS7Hz1aErylvjzqIxusSQg
1Nu007vUe8XbV7S+p56rRqI2O/5uxAq01sGxe+ac0XNvlbH517krcXUJHuQu
9TzotxMP2f+Bu8S/F5XSlXW7JnZ9HlN3rY8fRdjb21iDsNfs2mfWRfy/QD5v
TBq5v80arFWsM7dOq70HnwdhmQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->515442607]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " to clear everything:"
}], "ExampleText",
 CellID->384645278],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->306970198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->326232527],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1028136037]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56279087],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->335865947],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->751248781],

Cell[BoxData[
 RowBox[{
  RowBox[{"fact", "[", "1", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37722120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43396380],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcFOwzAM9dIk02B0bJfCZUxIfAfiAD3xEdWEtB0QaOyzEL8YnNYurUnV
dt0gUuLafY7t19R5zvabl9dsv11nq3SXvW+264/V09sOTdEIQD0CwOwK8Nnh
Uz55pDgBbnBVaF6QfCC5JOmRXyUSonIHmOBiUY2E/V7oS6H75TPfsXAtRkSq
QalQet2Q1B6mq7l7a2HmcSaiWMo/DqI1RRoS8YJ8dWN9SrzJyzXVXYFi/7aG
sZLrsO95AxdctQ162X/K9lKgjsJnBWVa9G4cJkM5G5wRf73xwXx5pD4ZQ1PX
53QdN5eTnKHW8xzKTQVqmgid/8dZA15m/xc5xp0ZDHVt7pn8Rcu+WOuhCure
0wZe4gDWup+OfVi0eecKJTeLFk7l+9ue/knnzLj6a1e/te+EPSFpnLzFmZ20
pwajb6rYZrk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->617746547]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->454356181],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "fact", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->216930195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->317841575],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`fact],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->286167566]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->386580789],

Cell["Protected symbols cannot be cleared:", "ExampleText",
 CellID->86724539],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "x", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->354007221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearAll", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->812009204],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "::", "\<\"wrsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(x\\) is Protected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", ButtonNote -> \
\\\"ClearAll::wrsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->34575782]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 " to clear definitions of protected symbols:"
}], "ExampleText",
 CellID->163671064],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "x", "]"}], ";"}], "\n", 
 RowBox[{"ClearAll", "[", "x", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->152175712]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->926711805],

Cell["Clear the definitions of all symbols in the current context:", \
"ExampleText",
 CellID->54699474],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";", 
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"z", "^", "3"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732450189],

Cell[BoxData[
 RowBox[{"ClearAll", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{
    RowBox[{"Context", "[", "]"}], "<>", "\"\<*\>\""}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->501611447],

Cell[BoxData[
 RowBox[{"?", "`*"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->125890298]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14776],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3878],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->2173],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41647312],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->147893738],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->256805262]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClearAll - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 39.2120326}", "context" -> "System`", 
    "keywords" -> {
     "deleting functions", "deleting symbols", "functions", "kill definition",
       "removing functions", "removing symbols", "symbols", 
      "undefining functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ClearAll[symb_1, symb_2, ...] clears all values, definitions, \
attributes, messages and defaults associated with symbols. \
ClearAll[\"SubscriptBox[ form, 1]\", \"SubscriptBox[ form, 2]\", ...] clears \
all symbols whose names textually match any of the form_i. ", 
    "synonyms" -> {"clear all"}, "title" -> "ClearAll", "type" -> "Symbol", 
    "uri" -> "ref/ClearAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4342, 132, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24810, 944}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2223, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2846, 81, 45, 1, 70, "ObjectName",
 CellID->3947],
Cell[2894, 84, 1411, 43, 70, "Usage",
 CellID->14461]
}, Open  ]],
Cell[CellGroupData[{
Cell[4342, 132, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4719, 146, 148, 5, 70, "ExampleSection",
 CellID->150348494],
Cell[4870, 153, 86, 1, 70, "ExampleText",
 CellID->429818932],
Cell[4959, 156, 263, 8, 70, "Input",
 CellID->110091192],
Cell[CellGroupData[{
Cell[5247, 168, 105, 3, 28, "Input",
 CellID->61020240],
Cell[5355, 173, 985, 31, 70, "Output",
 CellID->22164451]
}, Open  ]],
Cell[6355, 207, 72, 1, 70, "ExampleText",
 CellID->175583191],
Cell[6430, 210, 104, 3, 70, "Input",
 CellID->679611613],
Cell[CellGroupData[{
Cell[6559, 217, 106, 3, 70, "Input",
 CellID->426063475],
Cell[6668, 222, 231, 8, 36, "Output",
 CellID->392930122]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6948, 236, 220, 7, 70, "ExampleSection",
 CellID->358891435],
Cell[7171, 245, 69, 1, 70, "ExampleText",
 CellID->301706367],
Cell[7243, 248, 110, 4, 70, "Input",
 CellID->126604733],
Cell[7356, 254, 104, 3, 70, "Input",
 CellID->168486254],
Cell[CellGroupData[{
Cell[7485, 261, 69, 2, 70, "Input",
 CellID->53040972],
Cell[7557, 265, 158, 5, 36, "Output",
 CellID->156350399]
}, Open  ]],
Cell[7730, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->347374944],
Cell[7858, 278, 71, 1, 70, "ExampleText",
 CellID->37454990],
Cell[7932, 281, 290, 10, 70, "Input",
 CellID->179882384],
Cell[8225, 293, 107, 3, 70, "Input",
 CellID->371484883],
Cell[CellGroupData[{
Cell[8357, 300, 109, 3, 70, "Input",
 CellID->312638351],
Cell[8469, 305, 232, 8, 36, "Output",
 CellID->8964168]
}, Open  ]],
Cell[8716, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->106859970],
Cell[8844, 321, 55, 1, 70, "ExampleText",
 CellID->627855],
Cell[8902, 324, 191, 6, 70, "Input",
 CellID->380574387],
Cell[9096, 332, 104, 3, 70, "Input",
 CellID->202963165],
Cell[9203, 337, 124, 3, 70, "ExampleDelimiter",
 CellID->34461440],
Cell[9330, 342, 65, 1, 70, "ExampleText",
 CellID->180368890],
Cell[9398, 345, 196, 7, 70, "Input",
 CellID->2420569],
Cell[9597, 354, 127, 4, 70, "Input",
 CellID->776255491],
Cell[CellGroupData[{
Cell[9749, 362, 97, 3, 70, "Input",
 CellID->133977497],
Cell[9849, 367, 185, 6, 36, "Output",
 CellID->104975150]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10083, 379, 243, 7, 70, "ExampleSection",
 CellID->123103514],
Cell[10329, 388, 80, 1, 70, "ExampleText",
 CellID->362475358],
Cell[10412, 391, 118, 3, 70, "Input",
 CellID->38138293],
Cell[10533, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->167873059],
Cell[10661, 401, 87, 1, 70, "ExampleText",
 CellID->437475939],
Cell[10751, 404, 178, 6, 70, "Input",
 CellID->168901340],
Cell[10932, 412, 113, 3, 70, "Input",
 CellID->237737555],
Cell[CellGroupData[{
Cell[11070, 419, 126, 4, 70, "Input",
 CellID->29696549],
Cell[11199, 425, 215, 7, 36, "Output",
 CellID->555928198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11463, 438, 227, 7, 70, "ExampleSection",
 CellID->364403238],
Cell[11693, 447, 91, 1, 70, "ExampleText",
 CellID->59344518],
Cell[11787, 450, 106, 3, 70, "Input",
 CellID->665750006],
Cell[11896, 455, 458, 16, 70, "Input",
 CellID->891805863],
Cell[CellGroupData[{
Cell[12379, 475, 99, 3, 70, "Input",
 CellID->962876173],
Cell[12481, 480, 158, 5, 36, "Output",
 CellID->815809105]
}, Open  ]],
Cell[12654, 488, 125, 3, 70, "ExampleDelimiter",
 CellID->405700832],
Cell[12782, 493, 126, 3, 70, "ExampleText",
 CellID->409801524],
Cell[12911, 498, 135, 4, 70, "Input",
 CellID->418054590],
Cell[13049, 504, 245, 8, 70, "Input",
 CellID->367669465],
Cell[13297, 514, 145, 5, 70, "Input",
 CellID->561199423],
Cell[13445, 521, 121, 4, 70, "Input",
 CellID->196473886],
Cell[13569, 527, 112, 4, 70, "Input",
 CellID->101762440]
}, Closed]],
Cell[CellGroupData[{
Cell[13718, 536, 236, 7, 70, "ExampleSection",
 CellID->20023858],
Cell[13957, 545, 221, 7, 70, "ExampleText",
 CellID->477239184],
Cell[14181, 554, 444, 15, 70, "Input",
 CellID->128049439],
Cell[14628, 571, 101, 3, 70, "Input",
 CellID->542553653],
Cell[CellGroupData[{
Cell[14754, 578, 106, 3, 70, "Input",
 CellID->364794754],
Cell[14863, 583, 1094, 22, 70, "Output",
 Evaluatable->False,
 CellID->515442607]
}, Open  ]],
Cell[15972, 608, 207, 8, 70, "ExampleText",
 CellID->384645278],
Cell[16182, 618, 104, 3, 70, "Input",
 CellID->306970198],
Cell[CellGroupData[{
Cell[16311, 625, 106, 3, 70, "Input",
 CellID->326232527],
Cell[16420, 630, 232, 8, 36, "Output",
 CellID->1028136037]
}, Open  ]],
Cell[16667, 641, 124, 3, 70, "ExampleDelimiter",
 CellID->56279087],
Cell[16794, 646, 161, 5, 70, "ExampleText",
 CellID->335865947],
Cell[16958, 653, 290, 10, 70, "Input",
 CellID->751248781],
Cell[17251, 665, 118, 4, 70, "Input",
 CellID->37722120],
Cell[CellGroupData[{
Cell[17394, 673, 108, 3, 70, "Input",
 CellID->43396380],
Cell[17505, 678, 651, 15, 70, "Output",
 Evaluatable->False,
 CellID->617746547]
}, Open  ]],
Cell[18171, 696, 65, 1, 70, "ExampleText",
 CellID->454356181],
Cell[18239, 699, 107, 3, 70, "Input",
 CellID->216930195],
Cell[CellGroupData[{
Cell[18371, 706, 109, 3, 70, "Input",
 CellID->317841575],
Cell[18483, 711, 234, 8, 36, "Output",
 CellID->286167566]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18766, 725, 230, 7, 70, "ExampleSection",
 CellID->386580789],
Cell[18999, 734, 78, 1, 70, "ExampleText",
 CellID->86724539],
Cell[19080, 737, 174, 6, 70, "Input",
 CellID->354007221],
Cell[CellGroupData[{
Cell[19279, 747, 104, 3, 70, "Input",
 CellID->812009204],
Cell[19386, 752, 359, 7, 70, "Message",
 CellID->34575782]
}, Open  ]],
Cell[19760, 762, 231, 8, 70, "ExampleText",
 CellID->163671064],
Cell[19994, 772, 170, 5, 70, "Input",
 CellID->152175712]
}, Closed]],
Cell[CellGroupData[{
Cell[20201, 782, 228, 7, 70, "ExampleSection",
 CellID->926711805],
Cell[20432, 791, 104, 2, 70, "ExampleText",
 CellID->54699474],
Cell[20539, 795, 193, 7, 70, "Input",
 CellID->732450189],
Cell[20735, 804, 205, 7, 70, "Input",
 CellID->501611447],
Cell[20943, 813, 88, 3, 70, "Input",
 CellID->125890298]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21080, 822, 311, 9, 70, "SeeAlsoSection",
 CellID->14776],
Cell[21394, 833, 699, 26, 70, "SeeAlso",
 CellID->2397]
}, Open  ]],
Cell[CellGroupData[{
Cell[22130, 864, 313, 9, 70, "TutorialsSection",
 CellID->3878],
Cell[22446, 875, 130, 3, 70, "Tutorials",
 CellID->2173],
Cell[22579, 880, 144, 3, 70, "Tutorials",
 CellID->20907]
}, Open  ]],
Cell[CellGroupData[{
Cell[22760, 888, 318, 9, 70, "MoreAboutSection",
 CellID->41647312],
Cell[23081, 899, 134, 3, 70, "MoreAbout",
 CellID->147893738],
Cell[23218, 904, 177, 3, 70, "MoreAbout",
 CellID->256805262]
}, Open  ]],
Cell[23410, 910, 27, 0, 70, "History"],
Cell[23440, 912, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

