(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14812,        504]
NotebookOptionsPosition[     11540,        394]
NotebookOutlinePosition[     12779,        430]
CellTagsIndexPosition[     12694,        425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetSystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetSystemOptions"], 
          "SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"], "Update" :> 
          Documentation`HelpLookup["paclet:ref/Update"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetSystemOptions\"\>", 
       2->"\<\"SystemOptions\"\>", 3->"\<\"Update\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level System Optimization\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"Time Measurement & Optimization\"\>", 
       4->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ClearSystemCache", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClearSystemCache",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClearSystemCache"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]clears internal system caches of stored results."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearSystemCache",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearSystemCache"]], "InlineFormula"],
 " can be useful in generating worst\[Hyphen]case timing results independent \
of previous computations. "
}], "Notes",
 CellID->13232],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearSystemCache",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearSystemCache"], "[", "\"\<Numeric\>\"", 
   "]"}]], "InlineFormula"],
 " clears only caches of numeric results. "
}], "Notes",
 CellID->4747],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearSystemCache",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearSystemCache"], "[", "\"\<Symbolic\>\"", 
   "]"}]], "InlineFormula"],
 " clears only caches of symbolic results. "
}], "Notes",
 CellID->28680]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785949108],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1493196],

Cell["The second evaluation uses a cached value:", "ExampleText",
 CellID->152437004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->988728541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2809999999999902`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127509581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118579094],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.828670879282072`*^-16", ",", "Null"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21858440]
}, Open  ]],

Cell["Clearing the cache will force recomputation:", "ExampleText",
 CellID->194639357],

Cell[BoxData[
 RowBox[{"ClearSystemCache", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->990473981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->59106484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2819999999999861`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->172448525]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Update",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Update"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->405126056],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->54152985],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->86655005],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->220581421],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->144475572]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClearSystemCache - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 40.5401916}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ClearSystemCache[] clears internal system caches of stored results.", 
    "synonyms" -> {"clear system cache"}, "title" -> "ClearSystemCache", 
    "type" -> "Symbol", "uri" -> "ref/ClearSystemCache"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6625, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->785949108]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12551, 418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2540, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3163, 87, 1581, 37, 70, "ObjectNameGrid"],
Cell[4747, 126, 489, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5273, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5751, 163, 286, 8, 70, "Notes",
 CellID->13232],
Cell[6040, 173, 271, 9, 70, "Notes",
 CellID->4747],
Cell[6314, 184, 274, 9, 70, "Notes",
 CellID->28680]
}, Closed]],
Cell[CellGroupData[{
Cell[6625, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785949108],
Cell[CellGroupData[{
Cell[7010, 212, 146, 5, 70, "ExampleSection",
 CellID->1493196],
Cell[7159, 219, 85, 1, 70, "ExampleText",
 CellID->152437004],
Cell[CellGroupData[{
Cell[7269, 224, 202, 7, 28, "Input",
 CellID->988728541],
Cell[7474, 233, 224, 7, 36, "Output",
 CellID->127509581]
}, Open  ]],
Cell[CellGroupData[{
Cell[7735, 245, 202, 7, 28, "Input",
 CellID->118579094],
Cell[7940, 254, 228, 7, 39, "Output",
 CellID->21858440]
}, Open  ]],
Cell[8183, 264, 87, 1, 70, "ExampleText",
 CellID->194639357],
Cell[8273, 267, 107, 3, 70, "Input",
 CellID->990473981],
Cell[CellGroupData[{
Cell[8405, 274, 201, 7, 70, "Input",
 CellID->59106484],
Cell[8609, 283, 224, 7, 36, "Output",
 CellID->172448525]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8894, 297, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9213, 308, 722, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9972, 339, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10293, 350, 144, 3, 70, "Tutorials",
 CellID->20907]
}, Open  ]],
Cell[CellGroupData[{
Cell[10474, 358, 319, 9, 70, "MoreAboutSection",
 CellID->405126056],
Cell[10796, 369, 166, 3, 70, "MoreAbout",
 CellID->54152985],
Cell[10965, 374, 176, 3, 70, "MoreAbout",
 CellID->86655005],
Cell[11144, 379, 173, 3, 70, "MoreAbout",
 CellID->220581421],
Cell[11320, 384, 148, 3, 70, "MoreAbout",
 CellID->144475572]
}, Open  ]],
Cell[11483, 390, 27, 0, 70, "History"],
Cell[11513, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

