(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79830,       2099]
NotebookOptionsPosition[     73357,       1883]
NotebookOutlinePosition[     74827,       1922]
CellTagsIndexPosition[     74741,       1917]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ThreeJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/ThreeJSymbol"], "SixJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/SixJSymbol"], 
          "SphericalHarmonicY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHarmonicY"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ThreeJSymbol\"\>", 
       2->"\<\"SixJSymbol\"\>", 
       3->"\<\"SphericalHarmonicY\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions Used in Quantum Mechanics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClebschGordan", "ObjectName",
 CellID->31746],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClebschGordan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClebschGordan"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["j", "TI"], ",", 
          StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Clebsch\[Hyphen]Gordan coefficient for the \
decomposition of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{"\[VerticalSeparator]", "j"}], ",", "m"}], 
        "\[RightAngleBracket]"}], TraditionalForm]], "InlineMath"],
     " in terms of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[VerticalSeparator]", 
             SubscriptBox["j", "1"]}], ",", 
            SubscriptBox["m", "1"]}], "\[RightAngleBracket]"}], 
          "\[VerticalSeparator]", 
          SubscriptBox["j", "2"]}], ",", 
         SubscriptBox["m", "2"]}], "\[RightAngleBracket]"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Clebsch\[Hyphen]Gordan coefficients vanish except when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{
     SubscriptBox["m", "1"], "+", 
     SubscriptBox["m", "2"]}]}], TraditionalForm]], "InlineMath"],
 " and the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", "i"], TraditionalForm]], "InlineMath"],
 " satisfy a triangle inequality. "
}], "Notes",
 CellID->22004],

Cell[TextData[{
 "The parameters of ",
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 " can be integers, half\[Hyphen]integers or symbolic expressions. "
}], "Notes",
 CellID->4220],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the standard conventions of Edmonds for the phase of the Clebsch\
\[Hyphen]Gordan coefficients. "
}], "Notes",
 CellID->17708]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->419222091],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->247520810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452093830],

Cell[BoxData[
 SqrtBox[
  FractionBox["5", "33"]]], "Output",
 ImageSize->{42, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112418086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366733848],

Cell["Use symbolic arguments to obtain exact symbolic answers:", "ExampleText",
 CellID->28221401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "m"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209321188],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "m"], " ", 
  SqrtBox[
   FractionBox["5", "33"]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{"24", "+", 
     RowBox[{"26", " ", "m"}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox["m", "2"]}], "+", 
     SuperscriptBox["m", "3"]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "-", "m"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "m"}], ")"}], "!"}]}]]]}]], "Output",
 ImageSize->{218, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208527875]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6084],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 " works with integer and half\[Hyphen]integer arguments:"
}], "ExampleText",
 CellID->311606384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414354203],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507448065]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541129657],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   SqrtBox["3"]]}]], "Output",
 ImageSize->{40, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289400684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233552278],

Cell[TextData[{
 "For symbolic input ",
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11426561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j", ",", "m"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j1", ",", "m1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j2", ",", "m2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156917803],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"j", "-", "j1", "+", "m2"}]], " ", 
  SqrtBox[
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "j2"}]}]], " ", 
  RowBox[{"ThreeJSymbol", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j", ",", "m"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j1", ",", "m1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j2", ",", 
      RowBox[{"-", "m2"}]}], "}"}]}], "]"}]}]], "Output",
 ImageSize->{410, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18371529]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13215],

Cell[TextData[{
 "Plot Clebsch\[Dash]Gordan coefficients as a function of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ClebschGordan", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "m1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "m2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", 
        RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m1", ",", " ", 
      RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m2", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374320377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Decompose a spherical harmonic into a sum of products of two spherical \
harmonics:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j", "=", "5"}], ",", 
     RowBox[{"m", "=", "3"}], ",", 
     RowBox[{"j1", "=", "2"}], ",", 
     RowBox[{"j2", "=", "3"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox[
      FractionBox[
       RowBox[{"4", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j"}], "+", "1"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j1"}], "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j2"}], "+", "1"}], ")"}]}]]], " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"m1", "=", 
        RowBox[{"-", "j1"}]}], "j1"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"m2", "=", 
         RowBox[{"-", "j2"}]}], "j2"], 
       RowBox[{
        RowBox[{"KroneckerDelta", "[", 
         RowBox[{"m1", "+", "m2", "-", "m"}], "]"}], " ", 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}], " ", 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"j1", ",", "m1", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
        " ", 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"j2", ",", "m2", ",", "\[Theta]", ",", "\[Phi]"}], 
         "]"}]}]}]}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"ClebschGordan", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"j1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0"}], "}"}]}], "]"}], " ", 
     RowBox[{"SphericalHarmonicY", "[", 
      RowBox[{"j", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264629275],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox[
     RowBox[{"11", " ", "\[Pi]"}], "35"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SqrtBox[
         FractionBox["105", "2"]], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Phi]"}]], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"]}], 
       RowBox[{"4", " ", "\[Pi]"}]]}], "-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox["35", "6"]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Phi]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"]}], 
      RowBox[{"16", " ", "\[Pi]"}]], "-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox["105", "2"]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Phi]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"]}], 
      RowBox[{"32", " ", "\[Pi]"}]]}], ")"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["5", "16"]}], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Phi]"}]], " ", 
   SqrtBox[
    FractionBox["11", 
     RowBox[{"6", " ", "\[Pi]"}]]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"]}]}]], "Output",
 ImageSize->{534, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->621851333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->781783224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Apply angular momentum operators to spherical harmonics:", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{"-", "1"}], "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Phi]"}], "]"}], 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "\[Theta]"], "#1"}], "-", 
      RowBox[{"I", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Phi]"], "#1"}]}]}], ")"}]}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", "0", "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "I"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Phi]"], "#1"}]}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{"+", "1"}], "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"+", "I"}], " ", "\[Phi]"}], "]"}], 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "\[Theta]"], "#1"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Phi]"], "#1"}]}]}], ")"}]}], 
   "&"}]}]}], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "5"}], ",", 
      RowBox[{"m", "=", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[ScriptCapitalL]", "[", "\[Mu]", "]"}], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "@", " ", 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"j", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], "==",
        
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"j", 
          RowBox[{"(", 
           RowBox[{"j", "+", "1"}], ")"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j", ",", "m"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "\[Mu]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"m", "+", "\[Mu]"}]}], "}"}]}], "]"}], 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"j", ",", 
          RowBox[{"m", "+", "\[Mu]"}], ",", "\[Theta]", ",", "\[Phi]"}], 
         "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Mu]", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}], " ", "//", 
  " ", "Simplify"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46995176]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2619],

Cell[TextData[{
 "Evaluate the completely symbolic case of ",
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->392837679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j1", ",", "m1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j2", ",", "m2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "+", "j2"}], ",", 
     RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576159659],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"2", " ", "j1"}], "-", 
    RowBox[{"2", " ", "j2"}], "+", 
    RowBox[{"2", " ", "m1"}], "+", 
    RowBox[{"2", " ", "m2"}]}]], " ", 
  SqrtBox[
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"j1", "+", "j2"}], ")"}]}]}]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "j1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "j2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "j2", "-", "m1", "-", "m2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "j2", "+", "m1", "+", "m2"}], ")"}], "!"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "j1"}], "+", 
        RowBox[{"2", " ", "j2"}]}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "-", "m1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "m1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j2", "-", "m2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j2", "+", "m2"}], ")"}], "!"}]}]]]}]], "Output",
 ImageSize->{402, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479015099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435816639],

Cell[TextData[{
 "Demonstrate ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "\[Hyphen]sum orthogonality:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j1", "=", "3"}], ",", 
      RowBox[{"j2", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{"m1", "+", "m2"}], "]"}], ">", "j"}], "||", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{"m1", "+", "m2"}], "]"}], ">", "ji"}]}], ",", "0", ",", 
          RowBox[{
           RowBox[{"ClebschGordan", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"j1", ",", "m1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j2", ",", "m2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}], 
           RowBox[{"ClebschGordan", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"j1", ",", "m1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j2", ",", "m2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"ji", ",", 
               RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m1", ",", 
          RowBox[{"-", "j1"}], ",", "j1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m2", ",", 
          RowBox[{"-", "j2"}], ",", "j2"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Abs", "[", 
         RowBox[{"j1", "-", "j2"}], "]"}], ",", 
        RowBox[{"j1", "+", "j2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ji", ",", 
        RowBox[{"Abs", "[", 
         RowBox[{"j1", "-", "j2"}], "]"}], ",", 
        RowBox[{"j1", "+", "j2"}]}], "}"}]}], "]"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3", "0", "0", "0", "0"},
     {"0", "5", "0", "0", "0"},
     {"0", "0", "7", "0", "0"},
     {"0", "0", "0", "9", "0"},
     {"0", "0", "0", "0", "11"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{98, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->177264857]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28847],

Cell[TextData[{
 "A message is issued and the result of 0 is returned when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["m", "1"], "+", 
     SubscriptBox["m", "2"]}], "\[NotEqual]", "m"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"phy\"\>"}], ":", 
  " ", "\<\"\\!\\(ThreeJSymbol[\\(\\(\\(\\({2, 1}\\)\\), \\(\\({2, 4}\\)\\), \
\\(\\({4, \\(\\(-2\\)\\)}\\)\\)\\)\\)]\\) is not physical. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/ClebschGordan/phy\\\", \
ButtonNote -> \\\"ClebschGordan::phy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->275503782],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307455920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 " always returns exact results, even for inexact arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20.", ",", "1."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30.", ",", "4."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.", ",", "5."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"555", " ", 
  SqrtBox[
   FractionBox["1162474599", "2398185466806202"]]}]], "Output",
 ImageSize->{175, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228691438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "=", "3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ListContourPlot3D", "[", 
    RowBox[{"N", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "m1", "]"}], "\[GreaterEqual]", "\[Lambda]"}], 
          "||", 
          RowBox[{
           RowBox[{"Abs", "[", "m2", "]"}], "\[GreaterEqual]", "\[Lambda]"}], 
          "||", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"m1", "+", "m2"}], "]"}], "\[GreaterEqual]", "j"}]}], ",",
          "0", ",", 
         RowBox[{"ClebschGordan", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Lambda]", ",", "m1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Lambda]", ",", "m2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"2", "\[Lambda]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", " ", 
         RowBox[{"-", "\[Lambda]"}], ",", "\[Lambda]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m2", ",", 
         RowBox[{"-", "\[Lambda]"}], ",", "\[Lambda]"}], "}"}]}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17313324]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5185],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ThreeJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ThreeJSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SixJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SixJSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalHarmonicY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHarmonicY"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10741],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->9219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27083],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#8162"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Clebsch-GordanCoefficient.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/ClebschGordan/"],
    None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->139810901],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->31204392]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClebschGordan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 41.2433346}", "context" -> "System`", 
    "keywords" -> {"Clebsch-Gordan", "Clebsch Gordan"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ClebschGordan[{j_1, m_1}, {j_2, m_2}, {j, m}] gives the Clebsch-Gordan \
coefficient for the decomposition of \\[VerticalSeparator] j, \
m\\[RightAngleBracket] in terms of \\[VerticalSeparator] j_1, \
m_1\\[RightAngleBracket] \\[VerticalSeparator] j_2, m_2\\[RightAngleBracket]. \
", "synonyms" -> {"clebsch gordan"}, "title" -> "ClebschGordan", "type" -> 
    "Symbol", "uri" -> "ref/ClebschGordan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5979, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->419222091]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 74598, 1910}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2072, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2695, 80, 51, 1, 70, "ObjectName",
 CellID->31746],
Cell[2749, 83, 1801, 58, 70, "Usage",
 CellID->18774]
}, Open  ]],
Cell[CellGroupData[{
Cell[4587, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5065, 163, 408, 14, 70, "Notes",
 CellID->22004],
Cell[5476, 179, 264, 8, 70, "Notes",
 CellID->4220],
Cell[5743, 189, 199, 6, 70, "Notes",
 CellID->17708]
}, Closed]],
Cell[CellGroupData[{
Cell[5979, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->419222091],
Cell[CellGroupData[{
Cell[6364, 214, 148, 5, 70, "ExampleSection",
 CellID->247520810],
Cell[CellGroupData[{
Cell[6537, 223, 289, 10, 28, "Input",
 CellID->452093830],
Cell[6829, 235, 191, 7, 60, "Output",
 CellID->112418086]
}, Open  ]],
Cell[7035, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->366733848],
Cell[7163, 250, 98, 1, 70, "ExampleText",
 CellID->28221401],
Cell[CellGroupData[{
Cell[7286, 255, 289, 10, 28, "Input",
 CellID->209321188],
Cell[7578, 267, 659, 25, 72, "Output",
 CellID->208527875]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8286, 298, 215, 7, 70, "ExampleSection",
 CellID->6084],
Cell[8504, 307, 242, 7, 70, "ExampleText",
 CellID->311606384],
Cell[CellGroupData[{
Cell[8771, 318, 458, 17, 70, "Input",
 CellID->414354203],
Cell[9232, 337, 158, 5, 36, "Output",
 CellID->507448065]
}, Open  ]],
Cell[CellGroupData[{
Cell[9427, 347, 437, 16, 70, "Input",
 CellID->541129657],
Cell[9867, 365, 209, 8, 55, "Output",
 CellID->289400684]
}, Open  ]],
Cell[10091, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->233552278],
Cell[10219, 381, 357, 13, 70, "ExampleText",
 CellID->11426561],
Cell[CellGroupData[{
Cell[10601, 398, 293, 10, 70, "Input",
 CellID->156917803],
Cell[10897, 410, 608, 22, 38, "Output",
 CellID->18371529]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11554, 438, 223, 7, 70, "ExampleSection",
 CellID->13215],
Cell[11780, 447, 284, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12089, 461, 613, 19, 70, "Input"],
Cell[12705, 482, 17516, 291, 70, "Output",
 Evaluatable->False,
 CellID->374320377]
}, Open  ]],
Cell[30236, 776, 105, 2, 70, "ExampleDelimiter"],
Cell[30344, 780, 114, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30483, 787, 2064, 63, 70, "Input",
 CellID->264629275],
Cell[32550, 852, 2275, 70, 184, "Output",
 CellID->621851333]
}, Open  ]],
Cell[CellGroupData[{
Cell[34862, 927, 84, 2, 70, "Input"],
Cell[34949, 931, 161, 5, 36, "Output",
 CellID->781783224]
}, Open  ]],
Cell[35125, 939, 105, 2, 70, "ExampleDelimiter"],
Cell[35233, 943, 79, 0, 70, "ExampleText"],
Cell[35315, 945, 1627, 55, 70, "Input"],
Cell[CellGroupData[{
Cell[36967, 1004, 1397, 40, 70, "Input"],
Cell[38367, 1046, 222, 7, 36, "Output",
 CellID->46995176]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38638, 1059, 232, 7, 70, "ExampleSection",
 CellID->2619],
Cell[38873, 1068, 234, 8, 70, "ExampleText",
 CellID->392837679],
Cell[CellGroupData[{
Cell[39132, 1080, 349, 12, 70, "Input",
 CellID->576159659],
Cell[39484, 1094, 1469, 52, 78, "Output",
 CellID->479015099]
}, Open  ]],
Cell[40968, 1149, 125, 3, 70, "ExampleDelimiter",
 CellID->435816639],
Cell[41096, 1154, 146, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[41267, 1163, 1970, 57, 70, "Input"],
Cell[43240, 1222, 852, 25, 108, "Output",
 CellID->177264857]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44141, 1253, 226, 7, 70, "ExampleSection",
 CellID->28847],
Cell[44370, 1262, 277, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[44672, 1276, 269, 9, 70, "Input"],
Cell[44944, 1287, 464, 8, 70, "Message",
 CellID->275503782],
Cell[45411, 1297, 158, 5, 36, "Output",
 CellID->307455920]
}, Open  ]],
Cell[45584, 1305, 105, 2, 70, "ExampleDelimiter"],
Cell[45692, 1309, 225, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[45942, 1319, 278, 9, 70, "Input"],
Cell[46223, 1330, 241, 8, 60, "Output",
 CellID->228691438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46513, 1344, 224, 7, 70, "ExampleSection",
 CellID->29715],
Cell[CellGroupData[{
Cell[46762, 1355, 1452, 41, 70, "Input"],
Cell[48217, 1398, 21899, 363, 70, "Output",
 Evaluatable->False,
 CellID->17313324]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70177, 1768, 310, 9, 70, "SeeAlsoSection",
 CellID->5185],
Cell[70490, 1779, 728, 26, 70, "SeeAlso",
 CellID->12220]
}, Open  ]],
Cell[CellGroupData[{
Cell[71255, 1810, 314, 9, 70, "TutorialsSection",
 CellID->10741],
Cell[71572, 1821, 155, 3, 70, "Tutorials",
 CellID->9219]
}, Open  ]],
Cell[CellGroupData[{
Cell[71764, 1829, 321, 9, 70, "RelatedLinksSection",
 CellID->27083],
Cell[72088, 1840, 250, 5, 70, "RelatedLinks"],
Cell[72341, 1847, 196, 4, 70, "RelatedLinks"],
Cell[72540, 1853, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72786, 1862, 319, 9, 70, "MoreAboutSection",
 CellID->139810901],
Cell[73108, 1873, 177, 3, 70, "MoreAbout",
 CellID->31204392]
}, Open  ]],
Cell[73300, 1879, 27, 0, 70, "History"],
Cell[73330, 1881, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

