(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33229,       1021]
NotebookOptionsPosition[     28382,        856]
NotebookOutlinePosition[     29829,        896]
CellTagsIndexPosition[     29744,        891]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "Min" :> Documentation`HelpLookup["paclet:ref/Min"], "Rescale" :> 
          Documentation`HelpLookup["paclet:ref/Rescale"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "Tanh" :> 
          Documentation`HelpLookup["paclet:ref/Tanh"], "Unitize" :> 
          Documentation`HelpLookup["paclet:ref/Unitize"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sign\"\>", 2->"\<\"Piecewise\"\>", 
       3->"\<\"Min\"\>", 4->"\<\"Rescale\"\>", 5->"\<\"Round\"\>", 
       6->"\<\"Chop\"\>", 7->"\<\"Tanh\"\>", 
       8->"\<\"Unitize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Data Transforms and Smoothing\"\>",
        2->"\<\"Mathematical Functions\"\>", 3->"\<\"Numerical Functions\"\>",
        4->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Clip", "ObjectName",
 CellID->21372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clip"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " clipped to be between ",
     Cell[BoxData[
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clip"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["min", "TI"], "\[LessEqual]", 
       StyleBox["x", "TI"], "\[LessEqual]", 
       StyleBox["max", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "<", 
       StyleBox["min", "TI"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ">", 
       StyleBox["max", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clip"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "<", 
       StyleBox["min", "TI"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ">", 
       StyleBox["max", "TI"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{
         StyleBox["x", "TI"], "<", 
         RowBox[{"-", "1"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"+", "1"}], ",", 
        RowBox[{
         StyleBox["x", "TI"], ">", 
         RowBox[{"+", "1"}]}]}], "}"}]}], "}"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32326],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", as well as other arguments of ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 ", need not be numbers. "
}], "Notes",
 CellID->32301],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120966134],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->111534592],

Cell["The unit clip function: ", "ExampleText",
 CellID->170070142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Clip", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149631638],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1Y9TEwQUwPHxY/xmR+K6hkSxOTnmZcjR5EIFjE4OFjmnZpc/JjLB2m6w
A0nOtHHoBnmIC4E2bk5HCAwF4gRMGNwYSC1CfkiKxI+CBMfYJGQ4BmidvPfu
3n3u+w+8F5go3MtzJBAIaa/2P4/XFJhXV13bCP+PpfUsfajthARbrqDJuknY
V0elQra7C/Sb9zmfBpOJ0F17ODEGujN0bDA9nUZ1gv7w1qHynvcdoW15J3xD
gx2gn1vLrhwJIkDrqbIwrWClda0jiOfqNyfZoQujtm2L/sYGfbz04OTTq4vQ
PTcC3B3kC9ABXrVbWxvmoT3e/adnumoOmr/vfElFhQV6fXmo6DYfu8U6Gq8L
wQ5ixWd3BGJfVjU0da3D7oyb4cR5Yi/NB5oNTtjcnTXrFYtm0CDzi1dOo8wn
58XXhlBVxLPGMgOaPnFvo+Ym6s/MWGlMQy/kjYXdTUQtI/FfaTmoXkJ9qP8A
FTzqqet9MQtqzzB4RjHKbR81BMhM4O4di7w/xeiWRh9CaRpqr4oOo7DREpm6
1NcHvX8sWeCWPwNGE8ykuVwjSN2xwu4QT4OVKfXjdxsmwS//rTv0nXwc3HKW
+LkL7THoe3rAs0jRD/6RxGfU/N0JZmYx8n+5cgusuhQeVRZyM3LN/JPiQW72
PdB7nhVRze4Hx9I7w07lPAZn73yiy+waB8sl17hJuZMgfUHj+7ViGnyrg03V
VKEehdaQkTuoZetHCTEP0WbBkNSH/BTcN+m2UpGPZg/wph6JjWCG2tPqdRlN
EdURo1Rogs8ytVyLUliFh0VLaG27rs8jYwYc+emdlogUE9gdLmJQM9Fmrb7Y
7QKq+PWk6IEaPfhXfZBwFO19I1Z2/cAs2FYsX5Xy0Nq3TXxhOpofLNu9XYbG
RQ/bH3Sj+tTUZPePzWD9gm7AzEGvnyHvGkxExdKf/dXfoqkk77zcSyi38KhV
qER3qpz7tjej7236LJJmQP2rK6vdh1CvUDvFMoUuNSZIBq3oc+WerCNOlsjX
9yDSNP6ittcDe2Kj+knMOuzhZFZAEwW75FxRP3s/9v7iMamxADtLyaSVfv8M
WvnjxRZW0Ry08xcCE/H0PPTv3Mobe3MWoG97+x228hehN8kDp1xZNmjbqZxl
DccObbRtIFWEr0CrkiUDG2iEqLUuiP7tIoXuAE0Sana1kx2htTFNLQ1+TtDL
gqPMAyRnaAfXvh82L2MzY0W6OIILtG24eoo8h22mkAcYi67QlRN9x8h27Nf/
D/olkVpDng==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409384975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37374389],

Cell["Use different clip levels: ", "ExampleText",
 CellID->224514937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Clip", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "a"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138797077],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128481821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297668965],

Cell["Use symbolic operations: ", "ExampleText",
 CellID->210037210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Clip", "[", 
    FractionBox["1", 
     RowBox[{"x", "-", "1"}]], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193851120],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1uEzEQdvanSZqkLQJEcuuFFlQQAk4gIYSE4EArngChqKrUIiGi0kq5
5RFyzBuQS6U8Ao+Qx8hjmPXuOPF+O7t2stuKlbKOveOZb2Y847FP+lfnZz/7
Vxen/f3Pl/3B+cXp7/1Pvy6jIb8mhLiJfm+6Ivovo3/x70bKqH0bvf2oG0at
F7WH1L6Pv75Tb/VZxo/woH8I/Zhe+OodDIfDv/GzWCwU97qgLwY99kPoB9Er
pHlqWPUDak26baKrM/OVNh61OK9DfH1DjqJLgCWPRzIfrXTzR6MRcWgYHBX1
VqzGUgKNNiSjZ7DqJ1Ky8/hR1KINfbRCVhraecfiF+xrm5pjPSf71DNYtsj2
1drEM7mCLUKS6ml/rWsJHtPatijqL/3mJrv0GqneHqFzzFRoB1ijdxMpS0mO
vuGtouNAtSpXoiQlQedAzFHoFdRzRxbnQZSl6RLC+AEOOiN3WV0OgN99C74u
9FsZP6B3n7Jym0DVI5QPCHWb2h61HbL1Ecvtz387qnBz+12Zfdb07gvij/b0
gc7MpqH2Eos2GwWI3ewLsflO+orh6wlu59lmrJATw7nRipbV46hN/r6nM+9r
RjOPUHrkC4+xgM/i2y2wLmdtWw7OQ6mt2zCsrNoW0PFW3GOklEFpXw24ooPM
DK0Jro4aq8E9oNKRqbN4R6Yj5iXQ78J3xKfQqAJeSecR8NF1Bnwes1S8V9Ru
oKZi1v5KGJ/IVdWcl7GSfD2ZTKbTqfo7NUZXtOboYDAYj8er0eqzpvaJLTu2
wCfHpC+uiM2yoduJIY7f1Lo8ZuncsxvGlhu64npdST5hceVlL1zfbiiwv1co
u1xOssl29Yx7pnGzCdaHupbRq+8Li8KWX9xWxTXLG0///FyU+EMm0aRvGgJ2
1t3WUw9l+hbkgNrvLDVWq1ibYvX7jeViVhBFdxtNudndxpHks1NdFlXu2Xgv
cwrHiFv/vPUsQ+FWtfFnrGq106dcHLfdMTyX6ZxYX1eDiu4EbN6x4dd5tXk7
+C1n+dtYW+aOUahRMJvNRvEzn8/RPuuc1FEL20kdo5rdZXKQd4AW6zvEgnnu
QwHvtkyftHUNpU/aH6WZdZK7Z1H7B36H1ZM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{172, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519865636]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Clip", "[", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202922516],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tuE0EQbbtn7IRPEF8lQUgRJ4AcICYRDrBgC2wQsiKUZIGwQhbeeR8W
lmDhhJV3XvoIHMHH8DGa/nrab6rH42EG0pJnpqurq15X189vO+cnn790zk+P
Ojuvzjrdk9OjbzuHX88kidcYYyP5a20y+S3kl/6NhJDvXfmsy+lN+/40pzKu
uPTQq/78o+bi6hn1er3fesxms1hSYskWWWl1+27CfsWnprGWMKfDrgh2PbC7
uNXCLZ8BYobaqwQ+SxDyfr9vJTS0cl8fS6OQH2ugOSL3Ib56Sk4MHA9hzpfM
nTV82i55MrRw07O8u5HlJ3AWbRTBnZKeDznaumExrBe6g/JPEAe9iUT43/xo
HjH0PaSo9JluEFj8mNwInyB3HDv63QDdbNADJCm0asNzEjsd3Zu5bI4Zjlxf
uBP07gMSU9Mi3hZJxvPzLd7sLfloyulLUto+cL8juVoelzrrB5LrBch6T3L9
ugbUC2u728FV/xw013fCzkW5fI0siOtYLN40xiwt+xi40C+fkruU5ysXb4vE
S00AuVppHM0NJ5R7/GZkxS366jaJBXNe25OaynI4LyE3uvqRD92bUlCFqs6a
8Psf2SNZ+3P9kHMfldU9HA7H47H6xPpSLdZFu9XBbojlUHgdXKBeLMWaeY+0
txk53W53MBhQuNowj0TSM2KvuFr3qaqVMi4dt5TXYyd3D2gY2/dhTmtynd1r
OJG7W9Sweg4qO1fO+4ZrWV1+CM+TydWUV6a4fgJX9BdcvkYWxIXV5Uku2cWq
i6pvyvP3hKiwumAkPyKx3AGuPfFvq4uLvi0SnavDKPegFHShzO16ynWR/C/O
qja1XJatFnO2HRFLS1RdbYp7XzXVZkt4nrQyjjzV5jGBPa1pw+LbF6tXm4yc
FE0mk74e0+kUc6zhuyKpl8LzJzYyYGp/AMsMMS0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{160, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96843584]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2462],

Cell["A clipped or saturated sinusoid: ", "ExampleText",
 CellID->192094269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Clip", "[", 
    RowBox[{
     RowBox[{"3", "/", "2"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46285603],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250659976]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9637],

Cell["Clip is not defined for complex values: ", "ExampleText",
 CellID->3905453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Clip", "[", 
  RowBox[{"2", "-", 
   RowBox[{"3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348874228],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clip", "::", "\<\"ncompl\"\>"}], ":", 
  " ", "\<\"Symbolic or noncomplex numerical arguments are expected.\"\>"}]], \
"Message", "MSG",
 CellID->341026653],

Cell[BoxData[
 RowBox[{"Clip", "[", 
  RowBox[{"2", "-", 
   RowBox[{"3", " ", "\[ImaginaryI]"}]}], "]"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358112976]
}, Open  ]],

Cell["Clip the real and imaginary parts separately: ", "ExampleText",
 CellID->266104218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clip", "[", 
   RowBox[{"Re", "[", 
    RowBox[{"2", "-", 
     RowBox[{"3", "I"}]}], "]"}], "]"}], "+", 
  RowBox[{
   RowBox[{"Clip", "[", 
    RowBox[{"Im", "[", 
     RowBox[{"2", "-", 
      RowBox[{"3", "I"}]}], "]"}], "]"}], "I"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->834479732],

Cell[BoxData[
 RowBox[{"1", "-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242679728]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8207],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rescale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rescale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unitize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unitize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24065]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11364],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->31441],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->687151382],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->154217745],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->289140820],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->505351564],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->135453249]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Clip - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 43.3840144}", "context" -> "System`", 
    "keywords" -> {
     "crop", "limiting function", "ramp", "trim", "limiter", "saturation", 
      "saturation function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Clip[x] gives x clipped to be between -1 and +1. Clip[x, {min, max}] \
gives x for min <= x <= max, min for x < min and max for x > max. Clip[x, \
{min, max}, {v_min, v_max}] gives v_min for x < min and v_max for x > max. ", 
    "synonyms" -> {"sat"}, "title" -> "Clip", "type" -> "Symbol", "uri" -> 
    "ref/Clip"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8833, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->120966134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29601, 884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2970, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3593, 91, 42, 1, 70, "ObjectName",
 CellID->21372],
Cell[3638, 94, 3020, 107, 70, "Usage",
 CellID->27094]
}, Open  ]],
Cell[CellGroupData[{
Cell[6695, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7173, 223, 813, 31, 70, "Notes",
 CellID->32326],
Cell[7989, 256, 328, 13, 70, "Notes",
 CellID->32301],
Cell[8320, 271, 476, 14, 70, "Notes",
 CellID->15296]
}, Closed]],
Cell[CellGroupData[{
Cell[8833, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120966134],
Cell[CellGroupData[{
Cell[9218, 304, 148, 5, 70, "ExampleSection",
 CellID->111534592],
Cell[9369, 311, 67, 1, 70, "ExampleText",
 CellID->170070142],
Cell[CellGroupData[{
Cell[9461, 316, 235, 8, 28, "Input",
 CellID->149631638],
Cell[9699, 326, 1757, 38, 139, "Output",
 CellID->409384975]
}, Open  ]],
Cell[11471, 367, 124, 3, 70, "ExampleDelimiter",
 CellID->37374389],
Cell[11598, 372, 70, 1, 70, "ExampleText",
 CellID->224514937],
Cell[CellGroupData[{
Cell[11693, 377, 497, 17, 28, "Input",
 CellID->138797077],
Cell[12193, 396, 2213, 40, 140, "Output",
 Evaluatable->False,
 CellID->128481821]
}, Open  ]],
Cell[14421, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->297668965],
Cell[14549, 444, 68, 1, 70, "ExampleText",
 CellID->210037210],
Cell[CellGroupData[{
Cell[14642, 449, 209, 7, 42, "Input",
 CellID->193851120],
Cell[14854, 458, 1346, 26, 78, "Output",
 Evaluatable->False,
 CellID->519865636]
}, Open  ]],
Cell[CellGroupData[{
Cell[16237, 489, 269, 9, 28, "Input",
 CellID->202922516],
Cell[16509, 500, 1166, 23, 84, "Output",
 Evaluatable->False,
 CellID->96843584]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17724, 529, 222, 7, 70, "ExampleSection",
 CellID->2462],
Cell[17949, 538, 76, 1, 70, "ExampleText",
 CellID->192094269],
Cell[CellGroupData[{
Cell[18050, 543, 298, 10, 70, "Input",
 CellID->46285603],
Cell[18351, 555, 4442, 77, 70, "Output",
 Evaluatable->False,
 CellID->250659976]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22842, 638, 225, 7, 70, "ExampleSection",
 CellID->9637],
Cell[23070, 647, 81, 1, 70, "ExampleText",
 CellID->3905453],
Cell[CellGroupData[{
Cell[23176, 652, 142, 5, 70, "Input",
 CellID->348874228],
Cell[23321, 659, 191, 5, 70, "Message",
 CellID->341026653],
Cell[23515, 666, 247, 8, 36, "Output",
 CellID->358112976]
}, Open  ]],
Cell[23777, 677, 89, 1, 70, "ExampleText",
 CellID->266104218],
Cell[CellGroupData[{
Cell[23891, 682, 328, 12, 70, "Input",
 CellID->834479732],
Cell[24222, 696, 192, 6, 36, "Output",
 CellID->242679728]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24475, 709, 310, 9, 70, "SeeAlsoSection",
 CellID->8207],
Cell[24788, 720, 1879, 71, 70, "SeeAlso",
 CellID->24065]
}, Open  ]],
Cell[CellGroupData[{
Cell[26704, 796, 314, 9, 70, "TutorialsSection",
 CellID->11364],
Cell[27021, 807, 148, 3, 70, "Tutorials",
 CellID->31441],
Cell[27172, 812, 152, 3, 70, "Tutorials",
 CellID->869807265]
}, Open  ]],
Cell[CellGroupData[{
Cell[27361, 820, 319, 9, 70, "MoreAboutSection",
 CellID->687151382],
Cell[27683, 831, 167, 3, 70, "MoreAbout",
 CellID->154217745],
Cell[27853, 836, 155, 3, 70, "MoreAbout",
 CellID->289140820],
Cell[28011, 841, 149, 3, 70, "MoreAbout",
 CellID->505351564],
Cell[28163, 846, 145, 3, 70, "MoreAbout",
 CellID->135453249]
}, Open  ]],
Cell[28323, 852, 29, 0, 70, "History"],
Cell[28355, 854, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

