(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11808,        433]
NotebookOptionsPosition[      8848,        331]
NotebookOutlinePosition[     10021,        366]
CellTagsIndexPosition[      9937,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenAppend" :> 
          Documentation`HelpLookup["paclet:ref/OpenAppend"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"], "Streams" :> 
          Documentation`HelpLookup["paclet:ref/Streams"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenAppend\"\>", 2->"\<\"OpenRead\"\>", 
       3->"\<\"SetOptions\"\>", 4->"\<\"Streams\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Close", "ObjectName",
 CellID->7058],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Close",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Close"], "[", 
       StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]closes a stream. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The argument to ",
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 " can be an ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->14988],

Cell[TextData[{
 "If there is only one stream with a particular name, the argument to close \
can be ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3736]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->113110464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->166045350],

Cell["Open a stream: ", "ExampleText",
 CellID->114746021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<234 32412 4234\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1710760725],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "86"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153380781]
}, Open  ]],

Cell["Read from the stream object:", "ExampleText",
 CellID->1736668918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1744258449],

Cell[BoxData["234"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294907567]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 " the stream:"
}], "ExampleText",
 CellID->711868795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->747440128],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36247744]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9964],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5595],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->10952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->367713123],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->343189709]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Close - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 50.5560730}", "context" -> "System`", 
    "keywords" -> {"close streams", "close file"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Close[stream] closes a stream. ", "synonyms" -> {}, "title" -> "Close", 
    "type" -> "Symbol", "uri" -> "ref/Close"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4492, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->113110464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9794, 354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2127, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2750, 78, 42, 1, 70, "ObjectName",
 CellID->7058],
Cell[2795, 81, 457, 15, 70, "Usage",
 CellID->3948]
}, Open  ]],
Cell[CellGroupData[{
Cell[3289, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3767, 118, 468, 18, 70, "Notes",
 CellID->14988],
Cell[4238, 138, 217, 7, 70, "Notes",
 CellID->3736]
}, Closed]],
Cell[CellGroupData[{
Cell[4492, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->113110464],
Cell[CellGroupData[{
Cell[4877, 164, 148, 5, 70, "ExampleSection",
 CellID->166045350],
Cell[5028, 171, 58, 1, 70, "ExampleText",
 CellID->114746021],
Cell[CellGroupData[{
Cell[5111, 176, 157, 4, 28, "Input",
 CellID->1710760725],
Cell[5271, 182, 225, 7, 36, "Output",
 CellID->153380781]
}, Open  ]],
Cell[5511, 192, 72, 1, 70, "ExampleText",
 CellID->1736668918],
Cell[CellGroupData[{
Cell[5608, 197, 131, 4, 28, "Input",
 CellID->1744258449],
Cell[5742, 203, 160, 5, 36, "Output",
 CellID->294907567]
}, Open  ]],
Cell[5917, 211, 183, 7, 70, "ExampleText",
 CellID->711868795],
Cell[CellGroupData[{
Cell[6125, 222, 103, 3, 70, "Input",
 CellID->747440128],
Cell[6231, 227, 162, 5, 36, "Output",
 CellID->36247744]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6454, 239, 310, 9, 70, "SeeAlsoSection",
 CellID->9964],
Cell[6767, 250, 947, 35, 70, "SeeAlso",
 CellID->21566]
}, Open  ]],
Cell[CellGroupData[{
Cell[7751, 290, 313, 9, 70, "TutorialsSection",
 CellID->5595],
Cell[8067, 301, 191, 4, 70, "Tutorials",
 CellID->10952]
}, Open  ]],
Cell[CellGroupData[{
Cell[8295, 310, 319, 9, 70, "MoreAboutSection",
 CellID->367713123],
Cell[8617, 321, 159, 3, 70, "MoreAbout",
 CellID->343189709]
}, Open  ]],
Cell[8791, 327, 27, 0, 70, "History"],
Cell[8821, 329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

