(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55903,       2040]
NotebookOptionsPosition[     46435,       1702]
NotebookOutlinePosition[     47823,       1741]
CellTagsIndexPosition[     47737,       1736]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sparse Arrays: Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-LinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Sparse Arrays: Linear Algebra\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"], 
          "Coefficient" :> Documentation`HelpLookup["paclet:ref/Coefficient"],
           "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CoefficientList\"\>", 2->"\<\"Coefficient\"\>", 
       3->"\<\"SparseArray\"\>", 4->"\<\"Solve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 
       3->"\<\"Manipulating Equations\"\>", 
       4->"\<\"Matrices and Linear Algebra\"\>", 
       5->"\<\"Polynomial Systems\"\>", 
       6->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoefficientArrays", "ObjectName",
 CellID->2318],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoefficientArrays",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoefficientArrays"], "[", 
       RowBox[{
        StyleBox["polys", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arrays of coefficients of the variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " in the polynomials ",
     Cell[BoxData[
      StyleBox["polys", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " gives a list containing ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, which can be converted to ordinary arrays using ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17756],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " can be reconstructed as ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["m", "TI"], 
    StyleBox["0", "TR"]], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["1", "TR"]], ".", 
    StyleBox["vars", "TI"]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["2", "TR"]], ".", 
    StyleBox["vars", "TI"], ".", 
    StyleBox["vars", "TI"]}], "+", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19793],

Cell[TextData[{
 "Any element of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is taken to correspond to the polynomial ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "-", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " takes all expressions in ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " that match any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be variables. "
}], "Notes",
 CellID->30973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   StyleBox["polys", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], ",", 
    RowBox[{
     ButtonBox["Variables",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variables"], "[", 
     StyleBox["polys", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24249],

Cell[TextData[{
 "The length of the list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " is one more than the total degree of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28650],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are sparse arrays with ranks ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->14042],

Cell[TextData[{
 "The first element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " has the same length as the list ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28018],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " is a single polynomial rather than a list, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " is also not a list. "
}], "Notes",
 CellID->30365],

Cell[TextData[{
 "For linear equations, the solution to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], "==", "0"}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["1", "TR"]], ",", 
    RowBox[{"-", 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["0", "TR"]]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9910],

Cell[TextData[{
 "For nonlinear equations, the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are not unique. ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " by default assigns non\[Hyphen]zero coefficients only to monomials where \
the variables appear in the same order as ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31822],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"], "[", 
   RowBox[{
    StyleBox["polys", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    RowBox[{"Symmetric", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " makes all the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " symmetric in all their indices. The resulting arrays will generally be \
less sparse. "
}], "Notes",
 CellID->12243]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->598797105],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->457475245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "+", "x", "-", "y", "-", "z"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "x", "+", 
       RowBox[{"2", "y"}], "+", "z"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63997976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 2, ">"],
       Editable->False], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 6, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14159290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->591662879],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289302785]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17496],

Cell["Linear polynomial:", "ExampleText",
 CellID->333319288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "x"}], "+", 
    RowBox[{"3", "y"}], "+", 
    RowBox[{"4", "z"}], "+", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264673761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 3, ">"],
       Editable->False], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623938855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191753348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->191564197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1284979],

Cell["List of linear polynomials:", "ExampleText",
 CellID->12163530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"4", "z"}], "+", "5"}], ",", 
     RowBox[{
      RowBox[{"6", "x"}], "+", 
      RowBox[{"7", "y"}], "+", 
      RowBox[{"8", "z"}], "+", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102422752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 2, ">"],
       Editable->False], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 6, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296965837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->738743851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160422914],

Cell["Nonlinear polynomials:", "ExampleText",
 CellID->271397521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y", "+", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "y", "-", "2"}], ")"}], "^", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23764807],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1O4zAQdpOmP7AtrVgt5VZWWu1T7B7hwHJZ8QIVQoIDAgGvsvu6wY49
ZRhPMnaaQlMaKXVmnPGMP49/8vVi8Xxzfbd4vr1azM8eFw83t1dP89P7R61K
O0p1/imlTmZKP+f6qbjN9V/f9tE+jfVvqit/6bKry0yXiS6PTW0KVrnaI/KQ
yAeC3HXtZkQ/asj/pKF40gIV+vZvxhrLM9cajXLP6SeunArtpO69pv1PI+Og
clKgMiiqrFYVV+pGzbyfgUK5On0nqN6UFm64wAlnlTk1lFXR9VBc9koZqx6R
B0wfMxcrtYvRSzKOduNQJLmI2zW//ZoY9t8J29c8TRwCKC+gK74mw7mzBNjT
Jpx37y0JZ95j2XoEet4K1oueK+mqmFT66teslUYErLdtDPpvI18J+8GHjIw/
V77woxEwPkPvPZi19dDHVsvxJ/EuR4fNFlM7FnxL5wJuFcTytJV49VD2SAjF
nqQkxGhcnTwo73K713HYwO5OsQudBV3fW4mlvPJKJ6mQc2iVLObbluBU5/we
v9oNESpBu5N7j99l+BWeQxrmYWxb0hmNG3mKNJ1/ErLSagRfjK3GkLd904tD
AcfYjJVwrfjmYr4Q8Wkfz3VaB98WcJrHXlSJTVLSDnxVpEtYFarFUdKz0Iwb
gwjs2FMfkketRGmfePkmoBSbcRJqYRln+viT6OZEprzDEdeyN+dGEVopdpoB
IVFL+PNRj9fel/K9C+eb+f3hdN9daU5VxpDD34gHpCzbyycBvkauLPM1ifTJ
M3HmkXKW8U8cH2HEVVnHdbOaoazln6KX0ipcl0XcF+zWyVqG+L1ge4939Nf1
d/N4tkz5rEZdrnLHPTbHJZ6XZtW28VpNc4sSyjt+sBq/1dlXux9QLEh8EVh/
FHdF1wXAUuKwdixeLEv3N+dWO/LPmo9TvinsE3d6rPNP52fl32L5NT5fYN9u
NTckzlmJGdoxaFYl4RTLkPE5R3e5dnA/lK/4ymFc0cvPyYDFMlxhGRPCFRX7
vpfzYYzR5nBX9fgoiyLHSkkckYnSmFD+F7JjnfyTxDddFk0bVQiDpDovKPvK
xQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177005685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->632759221],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWlFv00AMTpN264rWdhOD8oLK3wAeGA/wxI+opknbAwKN/f+Qa3ulfPhq
++zQVEqlRvUlZ3/2+XyX+/pt9fxw/331/Hi3Wn59Wv18eLz7tfzy46lpqgZF
UY6Loni3KJrfdfNr/Y2fSfP9I26kF+Fa7Z4qhkr5AuQZ8/zE2J/TZ8WH8bDi
0+Ll8L/ueHznRnycf1q5Chd11CnUZSNeEdpDO+pPPU+ho/pr7WPWSu3n4knh
e3Pk+Fwr7SNea7aVtUe2BdRBHEH7eaId+4+d9XH6vfFjTfDGr/WHGuVRI2L7
7MTHZ+yMf5qIUzdm2VrLaCevdW6whspwnryLOsPTmLFeuiW22vQLY9yWXzl+
SvXMVB6fzkiOW/RLu2/Im8HWEa5IHy7JVqxNl466EBfq9sQ9bRG31g+UqRiP
4ixBzOqxoPa+/qMwFUVOnj0jord1v4LyYG2vnfWQziRq5+Oli9PtiRvfVj1x
a/3gZHxXKbPGAGcRavGJPj2L8rLG+0Tgf+4m+9nTldkTsqgkarEs9rNE7362
GLT0s6Wzs6Vfa/Li1s+efvbUxY0IRfdG4vRmkpW9DFqCGE9u8T5VwQ49z/XX
2kc+Q2tfi4fCF/Y9iyPHZ660n9rtWbNuwybW2w/Fp/tIHA48OXvFPM/NEyuL
j9X5rTKuVlbc+q8DjrXW4kV9VtbeWk0/hAt7YhZZ0QW0p1jmVH8pS361bV8y
eq2stJa1x6qbiyf6p2XFtax01Pexloxyir0Mq38lqJkS1oLSf5ZoRxnZxajv
EO5D97X2JGuip3+H2N82/Jkw9qRxlPohZcU5+X0tyW5KDnNDtreNT3Mzu03u
WGeLfMdujZGU6mmTPc95e5b4dqGyKo+z3kM5Yy3xe7P2c2cvKe6ORsqxktr3
0zPC+iF0WAXiGsA9h3YQl5XxxDhwftG8Ie4ePfjm9FiiNS5mOu6TvqtdCz6t
+2lr/0vSNrdXt56taE+PrHt762mV1h9ZFlmt0tXYaoXGLjuv4+TbOidHg21q
d8R5yvFYiIOLN+rDEwWusnpnJVeVjpeVw+LfXRcXHXkeDjOqY17m+VRHXB1I
TxURRn03zH0rp8TJHId1xOq4J+OJBRclRV1U7J66lJeeHJlMN67jeW9i1nz1
ZAG9s5Y6/9NHTIadW79kuSs5Cyq3Y18RWLmTxBz+KfIaVfE3z0H15/RJ/dPy
L/M9XBY88axq//83GhyRt9LWoM/hsksoLXtTDH4DrJeU+Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{520, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41064725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55022064],

Cell[TextData[{
 "Polynomial equations:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26995,
  ButtonNote->"26995"]
}], "ExampleText",
 CellID->327408680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "+", 
       RowBox[{"x", "^", "2"}], "-", "z"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"z", "^", "2"}]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242022401],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmd1OgzAUxzs+NjcdbH7Ou8XE+BR6qVc+xGJMtgujmXv/2bIe1vw5pYWx
GFASKOfQ9pz+2p4WeF1slu8fi83qbTF/WS++lqu37/nz51qqwp4QwZkQIp0J
eb+Vd9lJRyJPISJ1DXO9GMiLEh9lGsk0lmkg01vINwJ5CHKky8WgHzdUf9qw
vdOK9nzthxnl0FH7E1ObKc907UgFvcZyoS6H3ta1N9L66ZHtYrvI7sTTPsoB
2wuZNtrJIjtUDqVQ5WNSCP1MnoHxXKW77qaDqudKxVpNaZm3fZBjXUdZnhOm
bbEozm+X3P+DTCjm4dxtNasol3XrsBTSwphUlVZdiva5GVAf79tC7ShqYrO9
OdqCFsdMxOZyEeYt2taAsrVB6fs65XqAt+Liq2obdJAgX6o+R+L0T7k6Zdwb
1KV8WB8UIwmSG9TumWEhn2q7TwS2E6Rcec8zMW8AetqzJg6rGNHRy2nrSGCL
aOy5SJw7SLSfDMY4247bRQbzu0ihP73MT3ZvUcZzu9v/cIxor4IMfSNCVLRm
KVm2Jld9w0DZOaJaTwCfsytWK4nAiqG1OHNcPHBmufj47YtDg4bXvkPn4/cP
/JrNEaaRUrUu1xqFVFBGquz3lRKKScd48avGhYNSsrXv+LpMi1ZLHCU4l228
6HtTc++0XKQ13/fNaIfP6OsCxQDTqrCUCSz1hPpZmGMUxlPTS/wWd+3BvIzN
uJUU0OtLB4Wq0b8bVK4qUjnOGllYU+TtA+jmILtGeb1vMcjHx5Mha8nPn/Ev
e3lzgJf1fOdHBKc1R7q63mvd3Xb/z4H7M0QzwbZbnHjWrYrOLHWnDdqw+Z96
2uL/YFGfJBUl0fsBZ+VbvQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160120303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29035651],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOg0AQXaBovfViTNS3+jP65EeQxqR9MJran9QPUh/UykAx5mQ2M8NS
2iaYFHeWndthFobDfbacPTxmy/k0m9wtsufZfPoyuX1a5FNJ5Fz06py7uXL5
eJWPih/9veW/cliOTuiYVGdXrifIRyAPBRn1jxu2h/GH2pPiteIxahkPyR7G
Y8UD5YQOIkpclHEujtb/x4xVmke7Wj2sCkmPy4rzL+Vx3nAePr2xMg9Jjmtd
PdJKcxHnD/MDialyHvX7DAoWe1o/uCc25UfKLxTX/o7hqvXji/vAk387Vc3J
tMcoe5f+zRe2neIsZwsrL65p2+4Z0WjHswaDZq5Df0+ug82zP6u6SMr7xmoV
d/EZGzM/y+pid6G0pfMw2LgHxAdzqoffYEfw03ngo8Ve0/r8RDkq7Ibe5y1o
oC5mxO/mEA/YrzfvQcqpHn58BbSPn86Drl53oy/p6rWr165em8K7q9euXrt6
7ep1e/VqZeBJq+IOk3VUCZMpcoMxrPfpIYep1ZP8S3mMPHbr5uHT+48b+Q99
CykZcBritxX7SPIlfR3A9aFfLy6N9kO/hqD8UaCSKKKwsOg+/YqNv1bakdh/
rlJo3acqKytLK7GxofbpnqhhZ7UssI/t1bLaKL+rUK3L9KFNDf8Wwipqvuw0
zWTqOVQuknKvxsJqvD5D1qfEOrFWDX1CyvgIYLrM+WD8Xyt17Yq+rP2bpceS
nge67gpX6XpDlL/1mDXUK24fOXx+1uvodcjR+d4eY4V30NMNYnWxpxiFvKvx
SEmrCClNt85hU3XtyTp/rnuX3hZ8bxko/xTZ0FDTt7voF3UDbSA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{457, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11253334]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15452],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"Symmetric\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9332],

Cell[TextData[{
 "The default the coefficient of a quadratic form corresponding to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], " ", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is zero:"
}], "ExampleText",
 CellID->196190202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x", " ", "y"}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"d", " ", "x"}], "+", 
     RowBox[{"e", " ", "y"}], "+", "f"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Normal"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85328130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "c"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141969257]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Symmetric\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " gives symmetric arrays:"
}], "ExampleText",
 CellID->320258765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x", " ", "y"}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"d", " ", "x"}], "+", 
     RowBox[{"e", " ", "y"}], "+", "f"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"\"\<Symmetric\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177238047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       FractionBox["b", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["b", "2"], ",", "c"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{199, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306499087]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4897],

Cell[TextData[{
 "Convert linear equations to arrays suitable for ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->869461888],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}], "+", 
       RowBox[{"4", "z"}]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"9", "x"}], "+", 
       RowBox[{"8", "y"}], "+", 
       RowBox[{"7", "z"}]}], "\[Equal]", "6"}], ",", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"9", "y"}], "+", 
       RowBox[{"2", "z"}]}], "\[Equal]", "8"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11971201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"b", ",", "m"}], "}"}], "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"eqns", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30284299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 3, ">"],
       Editable->False], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 9, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90577455]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188730599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["13", "15"]}], ",", 
   FractionBox["11", "15"], ",", 
   FractionBox["17", "15"]}], "}"}]], "Output",
 ImageSize->{103, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->528534594]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{"eqns", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->393494],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["13", "15"]}], ",", 
    FractionBox["11", "15"], ",", 
    FractionBox["17", "15"]}], "}"}], "}"}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129355690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17453],

Cell[TextData[{
 "The polynomial can be reconstructed by using ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " (.): ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19793,
  ButtonNote->"19793"]
}], "ExampleText",
 CellID->3995400],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282968700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}]}], ")"}], "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366291344],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105993818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"f", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->198155044],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmV9PwjAQwEu7DZDAQI3BF7OYGD+FPuqTH4IQE3gwGuT7Y7v1luZ227UD
DEOXbOX65+726/XPyttiu3r/WGzXy0X2ull8rdbL7+zlc6OzVE8IeSeESOdC
/97pX/kNV6ZvISLzVGW+GCJ5rB9GfNJppNNYp1Knt6jeBaMnsu3iI+lPPe1N
jmTP177KqSvCmqmNtTwTWl15btthb0dMO3Vge+D/zNPu9MB2p572sSzJ3jCy
IvouyVUUssgvU9NkGL0xZAhbpm/plJu0UAkXqKdaxTYb0qa3cP0qLkW0SpA8
IFjEojojcPLfpJK0pNU/ZVqOHFsdx2TVliE9aiW4Xfa3sLrNzNC3qXT4F1UU
nVPRFJO5mFFE1uLo0xbr1hDIp1vBHJvYFK9c9Zy4PvjnGBZv7SkPzpAytRM6
Bt/96FfnGcyMfvsZ3S8ePTWs1IN5sV0/uK3KSEBvVfYHGTemdMLYxmsB9rV7
PHD8QXxyJPAemiNz2TkyfZTvGyPcNxJHCvvTy/30W/fZ+NsVuymKHOwTMVnf
OSSqWqtpya8+oV80WO4Oh/4O++Xz/tR3d5PMjr6T4VG3XoYSCSW0z24bTlfA
V3b/YuvR+xDaBkUeeIXqYr4Zyf66Qm3IE54GnmfBiFglyB1AAycclxy39Ay5
Ncmh/EJ57jPOx4QtWQIsLnfGxGVw5gEnba4voqaNrNGjbJkqoQun1PVySL7L
TWA/YW7dZIG9vmYo4OjiqOC9YTeo4HNzLja4MchROuQYNG/+iPIyJPuNgHYn
RL/tz7iVlzgufbzkoiLEv3Ze03FC5RrRRKE7Dszzwebd23Rk685rdNTtSqcH
0J0yNmaeNqj/7bANzhb9/xz0TRYoid4PverdXA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{542, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->876419939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"c", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ".", "v"}], "+", 
   RowBox[{
    RowBox[{"c", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ".", "v", ".", "v"}], "+", 
   RowBox[{
    RowBox[{"c", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ".", "v", ".", "v", ".", "v"}]}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->564373700],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->79229413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178927422],

Cell["\<\
The symmetric coefficient arrays correspond to vector derivatives at the \
origin:\
\>", "ExampleText",
 CellID->162143103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}]}], ")"}], "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35946570],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104375865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"\"\<Symmetric\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3899935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{434, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7855460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "n"}], "}"}]}], "]"}], "/", 
     RowBox[{"n", "!"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151790483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{434, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->591162701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->904816869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " gives a list of arrays of polynomial coefficients ordered by total \
degrees:"
}], "ExampleText",
 CellID->112975120],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"5", "y"}]}], ")"}], "^", "4"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241863659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28571790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtO4zAQdeOmF6A3IUF56yIhvgEQCO3D7hMfUSEkeEAg4Fd2fzdrJ55i
TSYZO3EWkjZS63h8mfGZ8dg5d+uPx4fn9cfT/Xr1+239+vh0/7769fKmRLIn
RO+PEOLHUqj3RL2lP/38Vb/sNXubqn+pGq9V2VdlrMpIlSe6VcKoROyh+hjV
Z0y9b+aNkXwSSP88kD0yRQX3viFG2/WlmQ1buWfkc1MumHmk6Rda/8LTDlyP
UlRGaVMmFekjjdd0/xgEwrSpX2S16zKDGx5QQo2KjRjKMusGll3ZI4lRA1Qf
EWuMja14nI+cq9vWbg+Kw/+E7mekRgYDa02wnrwktte9gTgnjSjtuV4c0rTG
oowEcnoUZIyBKXFejEp1DSu2ch6B0Tsf8D4YfYmH8nvmgPaKg5/GuX6we6t5
wR61iQNk78ZLZNTo1imjm7sh4EyH17JoHV44LiFuOaR871Yccti+XuIUf0l2
+lEYwUmFMXTdDf28toKRfBbg7lYuN9OyOht33wanYc4uF3yq3OT9s93YQsPp
lDL96NOGzvAUwpC3fOdibmukXw7RGLzvOGS5bATfjh3BMKFvvDheMYq+8cqh
WvLtReRu+9Zv73DcBt8Y0vSxtYiCMVHBPPB1ITegCqvVtnJM+uGI8oMHguQN
0KpPWokV/nY/ZlDyjTsONbe402s8R7JVJa/Te3TiIeVWgOPAxXbOC7TV08bX
UnyK2VGn/8+M7NSU+0kWfUtiBl2dobLoNJ876tI7h0JNmjl8dNLsnH7FPKb/
G9aJb8ehmMmmmU9XZvMyXTWVdUIyjvvMuCYZThe9VyQKkKkxZtvJ1e0YzJCM
5EVCRRzPy+24s3KcOB/scPSLt+ooZycLxoS2s32sWT2WsXssYljWlcPnNp3f
LXu2hxmrxyB2hyEMy6Ry9vnEUse4LdIrHD+4ZfxfJYx82T2fGGwnj1WN8+sm
pxeG/+SwqRNTTfN5TXB04flFt5OD4uB0VfurLgtXl3Urm5tj2X6mU2uRC28m
ev8AkkxmOA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2353795]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives tensors of coefficients:"
}], "ExampleText",
 CellID->104769514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63611906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "625"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1500", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1350", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "540", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->626505324]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " to find the coefficient at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[InvisibleSpace]", 
    SuperscriptBox["y", "3"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->9322727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->519298020],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->465838444]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["ca", "TI"]], "InlineFormula"],
 " it is at position 1+degree of monomial, first variable, three times second \
variable:"
}], "ExampleText",
 CellID->111634366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "[", 
  RowBox[{"[", 
   RowBox[{"5", ",", "1", ",", "2", ",", "2", ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->365051057],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->256069087]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["cl", "TI"]], "InlineFormula"],
 " it is the element at position {1+exponent of x, 1+exponent of y}:"
}], "ExampleText",
 CellID->264421385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"1", "+", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->37654526],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->622687461]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->182],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1674],

Cell[TextData[ButtonBox["Sparse Arrays: Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-LinearAlgebra"]], "Tutorials",
 CellID->17408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->131667017],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->386166648],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->62944901],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->676446885],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->276824723],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->340824619],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout",
 CellID->522063813]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefficientArrays - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 53.1342640}", "context" -> "System`", 
    "keywords" -> {
     "homogeneous forms", "linear equations", "matrices", "nary forms", 
      "quadratic forms"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CoefficientArrays[polys, vars] gives the arrays of coefficients of the \
variables vars in the polynomials polys. ", 
    "synonyms" -> {"coefficient arrays"}, "title" -> "CoefficientArrays", 
    "type" -> "Symbol", "uri" -> "ref/CoefficientArrays"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11548, 410, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->598797105]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47593, 1729}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2855, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3478, 92, 54, 1, 70, "ObjectName",
 CellID->2318],
Cell[3535, 95, 747, 23, 70, "Usage",
 CellID->5957]
}, Open  ]],
Cell[CellGroupData[{
Cell[4319, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4797, 140, 520, 17, 70, "Notes",
 CellID->17756],
Cell[5320, 159, 1244, 48, 70, "Notes",
 CellID->19793],
Cell[6567, 209, 455, 17, 70, "Notes",
 CellID->26995],
Cell[7025, 228, 754, 27, 70, "Notes",
 CellID->30973],
Cell[7782, 257, 651, 22, 70, "Notes",
 CellID->24249],
Cell[8436, 281, 423, 15, 70, "Notes",
 CellID->28650],
Cell[8862, 298, 282, 12, 70, "Notes",
 CellID->14042],
Cell[9147, 312, 272, 11, 70, "Notes",
 CellID->28018],
Cell[9422, 325, 287, 11, 70, "Notes",
 CellID->30365],
Cell[9712, 338, 645, 25, 70, "Notes",
 CellID->9910],
Cell[10360, 365, 526, 17, 70, "Notes",
 CellID->31822],
Cell[10889, 384, 622, 21, 70, "Notes",
 CellID->12243]
}, Closed]],
Cell[CellGroupData[{
Cell[11548, 410, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->598797105],
Cell[CellGroupData[{
Cell[11933, 424, 148, 5, 70, "ExampleSection",
 CellID->457475245],
Cell[CellGroupData[{
Cell[12106, 433, 426, 13, 28, "Input",
 CellID->63997976],
Cell[12535, 448, 863, 30, 36, "Output",
 CellID->14159290]
}, Open  ]],
Cell[CellGroupData[{
Cell[13435, 483, 102, 3, 28, "Input",
 CellID->591662879],
Cell[13540, 488, 474, 17, 36, "Output",
 CellID->289302785]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14063, 511, 216, 7, 70, "ExampleSection",
 CellID->17496],
Cell[14282, 520, 61, 1, 70, "ExampleText",
 CellID->333319288],
Cell[CellGroupData[{
Cell[14368, 525, 299, 10, 70, "Input",
 CellID->264673761],
Cell[14670, 537, 520, 18, 36, "Output",
 CellID->623938855]
}, Open  ]],
Cell[CellGroupData[{
Cell[15227, 560, 102, 3, 70, "Input",
 CellID->191753348],
Cell[15332, 565, 262, 9, 36, "Output",
 CellID->191564197]
}, Open  ]],
Cell[15609, 577, 123, 3, 70, "ExampleDelimiter",
 CellID->1284979],
Cell[15735, 582, 69, 1, 70, "ExampleText",
 CellID->12163530],
Cell[CellGroupData[{
Cell[15829, 587, 468, 16, 70, "Input",
 CellID->102422752],
Cell[16300, 605, 864, 30, 36, "Output",
 CellID->296965837]
}, Open  ]],
Cell[CellGroupData[{
Cell[17201, 640, 99, 3, 70, "Input",
 CellID->252628],
Cell[17303, 645, 428, 15, 36, "Output",
 CellID->738743851]
}, Open  ]],
Cell[17746, 663, 125, 3, 70, "ExampleDelimiter",
 CellID->160422914],
Cell[17874, 668, 65, 1, 70, "ExampleText",
 CellID->271397521],
Cell[CellGroupData[{
Cell[17964, 673, 415, 14, 70, "Input",
 CellID->23764807],
Cell[18382, 689, 1314, 26, 70, "Output",
 Evaluatable->False,
 CellID->177005685]
}, Open  ]],
Cell[CellGroupData[{
Cell[19733, 720, 102, 3, 70, "Input",
 CellID->632759221],
Cell[19838, 725, 1479, 28, 70, "Output",
 Evaluatable->False,
 CellID->41064725]
}, Open  ]],
Cell[21332, 756, 124, 3, 70, "ExampleDelimiter",
 CellID->55022064],
Cell[21459, 761, 185, 7, 70, "ExampleText",
 CellID->327408680],
Cell[CellGroupData[{
Cell[21669, 772, 479, 16, 70, "Input",
 CellID->242022401],
Cell[22151, 790, 1090, 22, 70, "Output",
 Evaluatable->False,
 CellID->160120303]
}, Open  ]],
Cell[CellGroupData[{
Cell[23278, 817, 101, 3, 70, "Input",
 CellID->29035651],
Cell[23382, 822, 1056, 21, 70, "Output",
 Evaluatable->False,
 CellID->11253334]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24487, 849, 218, 7, 70, "ExampleSection",
 CellID->15452],
Cell[CellGroupData[{
Cell[24730, 860, 229, 7, 70, "ExampleSubsection",
 CellID->9332],
Cell[24962, 869, 238, 8, 70, "ExampleText",
 CellID->196190202],
Cell[CellGroupData[{
Cell[25225, 881, 475, 15, 70, "Input",
 CellID->85328130],
Cell[25703, 898, 418, 15, 36, "Output",
 CellID->141969257]
}, Open  ]],
Cell[26136, 916, 390, 14, 70, "ExampleText",
 CellID->320258765],
Cell[CellGroupData[{
Cell[26551, 934, 539, 17, 70, "Input",
 CellID->177238047],
Cell[27093, 953, 470, 17, 51, "Output",
 CellID->306499087]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27624, 977, 222, 7, 70, "ExampleSection",
 CellID->4897],
Cell[27849, 986, 237, 8, 70, "ExampleText",
 CellID->869461888],
Cell[28089, 996, 565, 20, 70, "Input",
 CellID->11971201],
Cell[CellGroupData[{
Cell[28679, 1020, 270, 9, 70, "Input",
 CellID->30284299],
Cell[28952, 1031, 863, 30, 36, "Output",
 CellID->90577455]
}, Open  ]],
Cell[CellGroupData[{
Cell[29852, 1066, 149, 5, 70, "Input",
 CellID->188730599],
Cell[30004, 1073, 306, 11, 51, "Output",
 CellID->528534594]
}, Open  ]],
Cell[CellGroupData[{
Cell[30347, 1089, 267, 9, 70, "Input",
 CellID->393494],
Cell[30617, 1100, 334, 12, 51, "Output",
 CellID->129355690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31000, 1118, 233, 7, 70, "ExampleSection",
 CellID->17453],
Cell[31236, 1127, 327, 12, 70, "ExampleText",
 CellID->3995400],
Cell[31566, 1141, 159, 6, 70, "Input",
 CellID->282968700],
Cell[CellGroupData[{
Cell[31750, 1151, 298, 11, 70, "Input",
 CellID->366291344],
Cell[32051, 1164, 355, 12, 36, "Output",
 CellID->105993818]
}, Open  ]],
Cell[CellGroupData[{
Cell[32443, 1181, 160, 5, 70, "Input",
 CellID->198155044],
Cell[32606, 1188, 1106, 22, 70, "Output",
 Evaluatable->False,
 CellID->876419939]
}, Open  ]],
Cell[CellGroupData[{
Cell[33749, 1215, 468, 16, 70, "Input",
 CellID->564373700],
Cell[34220, 1233, 354, 12, 36, "Output",
 CellID->79229413]
}, Open  ]],
Cell[34589, 1248, 125, 3, 70, "ExampleDelimiter",
 CellID->178927422],
Cell[34717, 1253, 133, 4, 70, "ExampleText",
 CellID->162143103],
Cell[CellGroupData[{
Cell[34875, 1261, 297, 11, 70, "Input",
 CellID->35946570],
Cell[35175, 1274, 355, 12, 36, "Output",
 CellID->104375865]
}, Open  ]],
Cell[CellGroupData[{
Cell[35567, 1291, 278, 9, 70, "Input",
 CellID->3899935],
Cell[35848, 1302, 809, 29, 36, "Output",
 CellID->7855460]
}, Open  ]],
Cell[CellGroupData[{
Cell[36694, 1336, 541, 19, 70, "Input",
 CellID->151790483],
Cell[37238, 1357, 811, 29, 36, "Output",
 CellID->591162701]
}, Open  ]],
Cell[38064, 1389, 125, 3, 70, "ExampleDelimiter",
 CellID->904816869],
Cell[38192, 1394, 273, 8, 70, "ExampleText",
 CellID->112975120],
Cell[38468, 1404, 229, 9, 70, "Input",
 CellID->241863659],
Cell[CellGroupData[{
Cell[38722, 1417, 211, 7, 70, "Input",
 CellID->28571790],
Cell[38936, 1426, 1259, 25, 70, "Output",
 Evaluatable->False,
 CellID->2353795]
}, Open  ]],
Cell[40210, 1454, 222, 7, 70, "ExampleText",
 CellID->104769514],
Cell[CellGroupData[{
Cell[40457, 1465, 214, 7, 70, "Input",
 CellID->63611906],
Cell[40674, 1474, 643, 18, 54, "Output",
 CellID->626505324]
}, Open  ]],
Cell[41332, 1495, 354, 13, 70, "ExampleText",
 CellID->9322727],
Cell[CellGroupData[{
Cell[41711, 1512, 179, 6, 70, "Input",
 CellID->519298020],
Cell[41893, 1520, 161, 5, 36, "Output",
 CellID->465838444]
}, Open  ]],
Cell[42069, 1528, 211, 7, 70, "ExampleText",
 CellID->111634366],
Cell[CellGroupData[{
Cell[42305, 1539, 178, 6, 70, "Input",
 CellID->365051057],
Cell[42486, 1547, 161, 5, 36, "Output",
 CellID->256069087]
}, Open  ]],
Cell[42662, 1555, 190, 6, 70, "ExampleText",
 CellID->264421385],
Cell[CellGroupData[{
Cell[42877, 1565, 194, 7, 70, "Input",
 CellID->37654526],
Cell[43074, 1574, 161, 5, 36, "Output",
 CellID->622687461]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43296, 1586, 309, 9, 70, "SeeAlsoSection",
 CellID->182],
Cell[43608, 1597, 961, 35, 70, "SeeAlso",
 CellID->20728]
}, Open  ]],
Cell[CellGroupData[{
Cell[44606, 1637, 313, 9, 70, "TutorialsSection",
 CellID->1674],
Cell[44922, 1648, 166, 3, 70, "Tutorials",
 CellID->17408]
}, Open  ]],
Cell[CellGroupData[{
Cell[45125, 1656, 319, 9, 70, "MoreAboutSection",
 CellID->131667017],
Cell[45447, 1667, 147, 3, 70, "MoreAbout",
 CellID->386166648],
Cell[45597, 1672, 152, 3, 70, "MoreAbout",
 CellID->62944901],
Cell[45752, 1677, 155, 3, 70, "MoreAbout",
 CellID->676446885],
Cell[45910, 1682, 163, 3, 70, "MoreAbout",
 CellID->276824723],
Cell[46076, 1687, 147, 3, 70, "MoreAbout",
 CellID->340824619],
Cell[46226, 1692, 137, 3, 70, "MoreAbout",
 CellID->522063813]
}, Open  ]],
Cell[46378, 1698, 27, 0, 70, "History"],
Cell[46408, 1700, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

