(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    258625,       5011]
NotebookOptionsPosition[    252715,       4816]
NotebookOutlinePosition[    254207,       4856]
CellTagsIndexPosition[    254120,       4851]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorFunctionScaling" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunctionScaling"], 
          "MeshShading" :> Documentation`HelpLookup["paclet:ref/MeshShading"],
           "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"], 
          "NormalsFunction" :> 
          Documentation`HelpLookup["paclet:ref/NormalsFunction"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ColorFunctionScaling\"\>", 
       2->"\<\"MeshShading\"\>", 3->"\<\"PlotStyle\"\>", 
       4->"\<\"NormalsFunction\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"ColorData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Options & Styling\"\>", 3->"\<\"Image Processing\"\>",
        4->"\<\"Plotting Options\"\>", 
       5->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ColorFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions which specifies a \
function to apply to determine colors of elements. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15563]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ColorFunction", "->", 
   StyleBox["func", "TI"]}]], "InlineFormula"],
 ", the arguments supplied to ",
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 " are as follows: "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26249],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Raster",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Raster"], Cell[TextData[Cell[BoxData[
     StyleBox["a", "TI"]], "InlineFormula"]], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], Cell[", ", "TableText"], 
     ButtonBox["ListLinePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLinePlot"], Cell[", ", "TableText"], 
     ButtonBox["ListLogPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLogPlot"], Cell[", etc.", "TableText"]}], 
    Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ParametricPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParametricPlot"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionPlot"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["ArrayPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayPlot"], Cell[", ", "TableText"], 
     ButtonBox["ReliefPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReliefPlot"]}], Cell[TextData[Cell[BoxData[
     StyleBox["a", "TI"]], "InlineFormula"]], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["ContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContourPlot"], Cell[" and ", "TableText"], 
     ButtonBox["ListContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListContourPlot"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " contour levels "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["DensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DensityPlot"], Cell[" and ", "TableText"], 
     ButtonBox["ListDensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListDensityPlot"]}], Cell[TextData[Cell[BoxData[
    
     StyleBox["f", "TI"]], "InlineFormula"]], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["ContourPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContourPlot3D"], Cell[", ", "TableText"], 
     ButtonBox["ListContourPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListContourPlot3D"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Plot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot3D"], Cell[", ", "TableText"], 
     ButtonBox["ListPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPlot3D"], Cell[", ", "TableText"], 
     ButtonBox["ListSurfacePlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListSurfacePlot3D"], Cell[
     ", and ", "TableText"], 
     ButtonBox["ListPointPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPointPlot3D"]}], "\[SpanFromLeft]"},
   {"", "", Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ParametricPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParametricPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, False, True, True, 
      True}}}},
 CellID->330594934],

Cell[TextData[{
 "With the usual default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the arguments supplied to ",
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 " are scaled using ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " so as to lie in the range 0 to 1."
}], "Notes",
 CellID->2806],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " original unscaled values are used. "
}], "Notes",
 CellID->3789],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ColorFunction", "->", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"ColorFunction", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], "[", 
      RowBox[{"#", 
       StyleBox["i", "TI"]}], "]"}], "&"}], ")"}]}]], "InlineFormula"],
 " where the slot used is as follows: ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", etc.: ",
 Cell[BoxData["#2"], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 "); ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReliefPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReliefPlot"]], "InlineFormula"],
 ": ",
 Cell[BoxData["#1"], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 "); ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 ", etc.: ",
 Cell[BoxData["#1"], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 "); ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 ", etc.: ",
 Cell[BoxData["#4"], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 "); ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", etc.: ",
 Cell[BoxData["#3"], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ")."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->258055413],

Cell[TextData[{
 "The list of possible color function names is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", "\"\<Gradients\>\"", "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->578154793],

Cell[TextData[{
 "The function specified by ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " must return color directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " or named colors such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21697],

Cell[TextData[{
 "It can also return ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29670],

Cell[TextData[{
 "Combinations of directives can be specified using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21289],

Cell[TextData[{
 "In 3D graphics, ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " by default specifies diffuse colors for surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4160],

Cell[TextData[{
 "If an explicit setting is given for ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ContourShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourShading"]], "InlineFormula"],
 ", it is used in preference to the setting for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21893]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73372314],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->37871401],

Cell["Color the surface by height:", "ExampleText",
 CellID->46597692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", "z", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200755922],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylfQV4FVfX7ht3IQ4JBHd3iru7BCgUt+JSXKNA8ZYCpdBSoEAp2lKc4oEE
iZEQgRB395wzz717rZkJ6SF89//+ex4458w+M3v2XvqutdeeDJ+xav6cxTNW
LZg1o/bAFTOWzV8wa2XtAUtXiCYDPQB/if/7XCC+/x/xjf//JUmS+KHS+1rx
biB+6sJHG+idDiV+oeN/aF0n3vUrrlyvc06n/3Clek9TpYdW3OpJ74YfzwVa
/q/at3zSrq8ziubcvFEZBQznzJkj//jZc9crI6VfqWsYyGejYvRrlN4MK91d
7rct//6N0oMZ9y9+UTpow59jlX5d1TEp/dO7KfcoXyG3tuaPcZVGSpe4KNda
f+b88Tozc1RGVI0OjCrOV3qTZzVB55pqyj3s6cC48j0qc0D3KhvlTk6V5k5f
q6b12E/4Z63c1UXnegOd65tV0IXuZqV8uupcZahzVVO+arpyj5r/o7O/Us52
/w8jIirKI/pSObuuztlGOn034bMnKeNuoHO2sc7ZjStorSsx9XWuNNG5slEF
nSskttKv9f5HV7dVrnZTRtuiiquoXR5lO50+VFltpXOVmc55Daq82knpu53O
1ab/o6tJdkm82v8/7m0oVZKIT3qppoyhfWX6K2ptUUVPlY/dquxRlfJ2ao9G
uPMMfz3DH/7igGyJhXJPXUlwq+CIvqIt+joS0UZtM8X9QNwMwOXnOPsMvzzD
YaVzK50+dXVLvkfPSmNkO2iGvwLxRyBOB+DYcxx8ht3P4KOO11qnD119l/vs
pjtvKzx4jVuvjG6+pKNfAnEkEPsDsOM5tj3DOn8s/+/6/6ISp5gGtngSjLtB
uBaEC68N/3hlcf6V2Qm+l08gNgVgdQAWP8Mcf0z1x4Sn4kYqRfWVz1rcbyfd
cdvhQQh9XgnGuWCcCDL4+bXZ8de2x17ZH35F7csD8XUAZgZg8nOMfoYh/ujj
r1L+X/auDn90qIKPrdV7OeLpG9wNM7obiouh1HA8BD8E6x8INt0fZLP3teOe
12676aZmC15gQgBGBGDAc/R4hk7+aEU3ha0OrdiSsW7oKzJflW1opvLdGQ/D
cSscV9/gjzDTC2HGJ0NxgAfiE2LiFWzlGeSwLch16+s6W17TaGe+MB0eiK4B
aPcczZ6h3jO48Siq6fQvU9buE4rUkD5qPNPEDUGR8I/EP2/p6GIEfgvH8TeG
P72xPBZmczjU2I/GYrQ6xPKbEPtVwdVXBtVeEdRw+etGC4goDgNeGLcOgPtz
OD+D7TOYP5M9te5oan5mNM4KdVQbiFoIjMajaIMHUfgrEud5TD9G4EA4doWb
7npjuzvMeXeY9UYak8X80GrzQlzmBrvPCW4wK6j5zKA204lEtXu+sG8SaGQf
YGz13NLieTWz5/KYbJUZu39mLKoXrxhLHQS9p8/7Mbgeg0vRRpeijM5E4lAk
9vC4NkcYbAy32PjGftMbt81hzsvDRJv9lFDnSaE1J4bUnxDcdHxwm3FBnccG
ifbmnV+6131RzTLAxSKglnlAPZMAeVDyOD7RtE9HZ1eJUsy3BoiIw8sPeBKL
OzzMP97hZAyORpsci7L8MdLo20hs4GEujDBZFG6zKNx58Rv3JWG154Y5jyfy
uQ8PrT8kpMmgkNYDgzsOCO7eP6hbVyJfM9cXdcwCG5sGtjIN7GAcKIbZSz+w
qpG6fmakNro8bYSQBATE41Ecbn/A5VicjcUvPOS9MdgRbfZtlN3uKMvNkUZL
Isk0fBlhPiXCfkq469Q39aa+afxlmPsQomyjPqHNe4S27hrSoUtI187BfToG
92tDlO3k8LKt8Ysuxi96Gb0YaPhCjHeM3ovPj1fVS9VHtFFH2RQRyXidRF/v
JeBaPC7FGf7xAT9/wPex2MXD3RCjtybaYl20w4You+WRljMjjcYQha2HRTgN
C681PLzR8DetRoQ17knDbdUxtF270M6tQrs1D+ndJGRg4+ARjYJFez+rV30M
Xw42eDlK/6WH/ksx3Nl4qYyWxiXzv7bu6FogJg1hqQhMwaNk3E7C1URqPhGP
n+JMj30w3BcLz1is5WHOe2cwJ8ZqXrTTgqjqsyPtxkda9qdhOvSIqNEtom73
8Kbd37Tt8aZ1+7A2LWikXRuF9qof2r926OCaIcNrhIytTsMcZfx6rN6ryXg1
A6/m45XiJqgXHapW5/HWqqQ7LJ2NEZ+JyAz6+iwND1NxPQWXknEmCcd54Lvj
sT3ObOcH022xhitjMfc9vqSxG42NsRkf7eIRVdsjsvqgSLsuJBFubd/WaRXR
sEV4yxbhHVu+6dIkrEsdGnhf19CBLqHDHENHVwsZbx0y0SJkqkmwEfVu6InX
Yrz7QQJtX+WIXXUp3Aix2QjPwqtMPOVxX0vTu5yK31JwNBnfJWEnj3tdPFbF
ma3+YLUi1mx2rKHHewyhcZv0jrHtG12jf1S9gVG1u0bWaEHjrt/obZP6ES3r
RLStGf5FrTe9xT9HGvcQm7CRlqHjzEInGYey6sB0NYI2I8gXQXsQdBBBYuyn
EVQFtRm38wz0lbHz9fURk4fQXARm41EWbmXiKs/gRBqOpup9n4IdydiShNWJ
WJIgmvWmx5nP/FBtVqzV+FizQe+NutIMzFrF2LWJcWsX3aBDVMOWkXXrRDaq
RVLTxiWio1NEV/vwnjbhA2zeDDJ7wxQ2XoTQVQjZAPLTOxF8AMEc/Blcgr88
3IpYRRdLyHNQLX9rVWIaIr0I8YWILKCj57m4n4Pr2biUhd8ycTwDB9Op3S9F
3zNZb20yFidhViIm83yGx5mP/GA/OrbagFirLu/NmtN87OrHONWJqVUnulG9
qBZ1I5s6Rbayp/l0sYroYR7R1yRikGE4085kPsKWIWwtQrcg1A+hexFyCKHQ
p9mYXETYnwj+CwHX8Eg03MR1usRKqkCqplBmS3OQJctU+VV33nSGoTrbSnFr
c7W3ekgpRWwJIorwqhBPmQ7XcnEhB6eycTQLBzKxMwPbmA4rUgyXJevPTdb7
MgmjEzGA6dAlzrzrB/vusU6dYu2avrdxf+/g9o4svVNMffvoJtWi2tpHtjWP
7GTyFsxD06kIn403i/CGbBvCvBD2LcK+QxgNTuBR4AbCbuHlbfjfwf17uCma
H+APutRSnYeRVBNCBsUE5Dl8MmuOVD+JCAw+8RoGUiWMphCnyUfKZJXT57sy
hJXiRTEeFeF2Ia7m4/c8av8xB/uzsT0LWzKxOgNLmERTUwymJBuOSzIYkqTX
MxEdEtA0XjSbN4pzaPKhRuNYJ9f3zg7v3KoRiRpZxDQ3jW5jFKVQZiIipiNi
PsKXIXwt3mxhEu1FOFPG8gxe/YYn53BfNN5HwEM8eoQ7j3HtKS7646xsKC3U
GXbw4HmaCcowvYxQedocudIJNnysZkV0Y4aq6cWDldQX3behSrG6yNMiXYN4
DaLKEVJGbQ9KcKMYl4twpgA/5+MQk843G5uysCoTCzMxMwOT0zE6lbofmGzc
J8mwc6JBi0S9egn6rkQ6S8c4B8cPNZ1ja1i+dzd7V9/4HWuQeX9EDUPkOERO
AanYIkSsRMQGRHghwg8hTDOb83j7JyL/RNAVPL2Ce3/hpjjzGe4F4EYgrrzE
+Vc4FUTY+zALnyoNZk08jGmSQr70IBlDKJzGEkWOVcqabs7A5r+UPfn6j3Fs
HXUUdVGgpc8ULWI1iNDgdTn8y/BPKTVeLMHpYvxUiO8L8G0+vPKwIYfav87C
jExMzMDIdAxIQ3ciq37bZJM2ScYNEw3dEgztEsxsiKwO5nHVTT7UNIxlzll0
Roz4GIToUYjyQNQ0RM5D5FKQR9mCSD/xhSlq/xNeXWB6/4PofxByF89u495d
XP8HV5/hT9EegguhOPMGv4TjyFt8F4U977CdzVqF9tb0MLHyqEa0EP+MIEu/
oUI+qPKpG1v/NzQ11KFpTVVCayNPQpoWcUzZMC1eaPC4HHfK8Fcp/ijFqRJq
P1CEHYXYWoC1+Viai3lMWY9MjMhE/wx0S0e7NDQlyurVSjZxSzJxTDQ2T7Aw
SahmGM+yadEW77/Au754N5TJ+iWiZyF6IaKX4e16RHkhWqam00lEn0LoKQSe
gf91xg2BCHuOAH/cf4Jrz3A5EL+/xGnRHokT0Tj6DgffY28cdiTAKwmbRR/G
FRbMzsNUz8Oev9KbcZkNCpyQUhvRTRDUrirJ1Y0Orf4LKn/az0dqV1ep7Y58
CVkSUiR80OKtFq+1eKahX26W40oZzpXhRCmOlGBfMTVuLcSaAizJx5w8TMnF
OCZ730x0zUDbdDRJQ+00OKfCNoWmZ5IkoxjLBogTHx0R2wOxA/B+BN5NwLuv
QAZ2CWJWI2YzYpjaNX5mZlxEzDVEX8arP/Hsbzx6AP8QEPgMxYNgXA+iePxs
OE5G4rho/IAf4rEvETuT4ZWCjWlk6JeCcWmFV7Uy8jCBhxs82osDLWXuUWKD
XGek1kFMUwS1x5MeLNVV2tdP6K9m1VXO6nLJSIfaajZNRLFFTO001qP3EsK1
eKXFUy3uafA3k/1MOY6X4WApdpfApxibiqhxcSFmF+DLfIzJw+Bc9MpB5yxq
b5wB93Q4pcE6lSlt5YxEdyQIkN0acZ2Z6oPwYRRiPfB+Ot4vwPvleL8O72XZ
rrUf4Xvx4meEXmayP8T7h3hzD88f4PET3H9Bof9j0a6EufjtPU7E4adEHErC
PtGeCs80bBCeNQtLsjEvF9PzMUmmPMux7eBBcJigZ+xhB4/G8OiFQYPEr8Wm
yLejwSYJ2jdDSAei/Z1B0KFjVdogU99Rp9VEh9pqRAxXsiSZEpIlvJPwlrt8
qcUTLe5q8ZcGf2hwSoNjTPZdZfAqxfoSrCjG10WYWUiNo/MxKA89c9ExBy2y
UT9LtoM2ZkiphmS2/4lNkdAWCV8gvg/ihyJuLBN9Fj4IWi9B9AbEyojRTbT+
hNhTeP8r3vyMwLN4cRNhgawDrxD0Ek+D8CAUdyJwPVbAKyAe5xNwKhHHkvBD
CvamYnsGvER7JlZlYVE+5hdhlqFKNHGHLh6wnWDMUmaNcYPQa6j4pjFBri2S
a1Dr22YI6gD/nrg9GH+PwaUpKoUr5904Z1XhB3T9pirr6spSZaqrcbOYaYGE
bD4/UUKshAgJryT4S3jEjX9qcV6Dkxoc1eBAOXYygFtfhuWlmF+CacXwKMRI
xrg98tEhD81zUS+be7Y1MEk3MUizRKo9UlyRUg/JzUGBeTck9kPicCSMR8JU
xM8Bec9vECfblIOI/Zm5cgkfruH9VYRdRsBVPH6El2GM36IREI2H73E3HjcS
KID+PQknRXsKxRZ70+CbQfhxbS6+yccSpnmNMgwrRd9SdC8TZo0l3mKChcXo
hvTjsGHoPAL1RpKRsUaOC+LrIKIZ/fKIif/nGFycgt/nooKwunLOWTI5B/0v
q86S/i9sR31Y6HDC/KP8C2sjVCBdQpIw73yyYEYQM+MfCdclXOHGX7U4osV+
DXaUY1s51jFL5pdiWgkmFGN4EfoVomsB2ufL9twW5lkGxpmm+hRMOiCtJtIa
ILUFUjsipQfI9I9AsgeSpiFxPhKXIYH5UH0X3u9F1CFEnkLMZXy4zVx6iphH
CLmPZ/dw7yWevOecRwLuJ+FmMq6m4HwqTqXiWCq+F+0ZhEo9c7Be1kPrYowo
waBy9CtHt3J00KCVBo3JLk+wVbIS/Uah9WjUGM16YZHBvAhvhted6fjWYFwR
ijAN5+bj5DK2/7qoxraSO5Vf+hWnVUbrJv/mlaI/upypwFc1UMyXZTNzZPsk
OBPKmiJeDyTckHBZwlkJv0g4yo07tNiqwRoNlpZjXhmmMXYfXoJ+xUYyV2xz
YJZtYJRlbpBpq5fpDGKPiJ5bIb0T0nohbRBSR4Ew0QykLEAyc8X5WyR8B4oS
j+H9L4g6jfCriLqHd4HCsQLhiA5DcDD8X+FuOO4mcZIJZPrPp+N0Bo5n4lCW
CIB4BFYFZDe/LMb4MowSx+XoXY4vNGinRQstGhFuhpvwhqiIdNF4PKqN45AS
xuen4tzXOLMaJ7bgJz/VtH3Kjc/oxSfUt9ShvoGqFy4olJAjIYNhj3gJIxUp
IVjCcwlPJNznRqEa5ySckHBYwj4J33LjWi2WajFXg6nlGF/O2mCHpkWoU4Dq
+bClyMnULMfaJMfRKNvNMKuufmYTZLZmTvRC+mCkj0H6ZKTNRJqMLr2QsgvJ
3yPpGBJPgzJJF8lCRV3Dm/uIeIGoSLxnhQhPRFAcnsbizgdcS8f1dFwAOYNj
PAb3PKzNY9QjXFcJppRgbCmGlWFAOXpq0YUog+aSiAJVFhAtYUGXdvTguMqD
egG9J9VGTHO8aI8HPXB3CP6eAFnrDX7ejYP7oPKlYl27Cn4YSVXjosoc4S7p
zZH8RS5zQ1ipOAkx/FuYhJfMjTsS/pZwVcJ5bj8iYb+EHRK2SVgvYblsEGGP
rmVox6FB3SJUL4RtgZ5Fvql5no1ZrmirbZrTyDi7pWF2e/2srsjsIygn3Dvx
Il0WRIdNSBNNe5B6EKnHkfIbki8h+Qa7l0eIe4RIf7x5hbAoRCQhMokDgVQ8
SMedTFznETjnwi+fIpJ1RVhehAVFmC5ayzCmHEM16K9FDyrZQBsJLZgftSXU
kOAswYGAjaCiIJfQDNmDiyG1krlRi44D2+FBd9wYiKtjcGEqtfy8BEfX4uh2
pqHuaqX1f+CL7mrev9YznVEikXLkqR48VUK8hGi2TiHMkcrWSejHKQnHuFHo
h6eEdRKWybcQjmGkFgO06F6O9mVoXmrQmLljW6RnWWhmUWBrlu9imuduQtxp
ZZzT2Tinl1H2AIPs4XpZ45ApR7KrkLEZGX7I2Msa9AvSzyLtMtJuIPUBUp4j
KYhVJhLvIhEeg+A0vElFYJoAsrKXzsUvuTicg9258BXHBVhThGXF5NlmlGFS
OUZrMYR50V1CZ2ZNM1raZyXhdmuSWeFQBeWgx3kaezlf1xMesoeJbsQU6Ybb
A/HnaPz+JU6zY/9pHQ5uwYFvsfcwPA+x1lTNJdUnqJ+6WKDCmzuIFnIbMqZN
Y7cRz6SPUnnzTMJjCfe48Q/mjfAcP0jYKyeXHDBJwmgJgziy7qhBi3LULzOs
W2JZt9iqBgUa1cwLXcwKapvmNzLJa2mc29GIuDPQMGeUYQ5zpNoiVpyNyPBl
phxGxglk/s7cuYX0h0gPQFooUiORGCOQL0GoSFk/XbM4QZiDn3LxfR5255Oy
bCrAatFYjLkl5M4mCo5oMESDfkJqmP6tVbNVi9LDAvnDjtuNiURK3gwczlFr
NQkNZP0h9x/UGo++oINro3DxS/w2h3Tm8DfU8v0e7DqALQew4gDmHKiKN3Kk
4aDwRM3cGhALKCtCOiKYILQjQaIwLopJLpgQwChXcOAWmywSWgmHFI1wxhpu
miNhioSxEoZIekJBOjM7GmjgVmbkVmrtVuLkWlzLldjhblrY2LSglUlBR+P8
HoZ5/Q2IHXI8YT1fP3u5fvZaZG1GFhuujEPI+AWZ55B5FZl3mE8vkBGGDMqT
oXYmHmfhbhb+zsL5bJzMwVHRmodd+fAuwMZCfFOExTIj2GqNLidG9BWM0NAA
2zCB69MiNlypwINUw5wZoc8/yXR35p8cWYNIs1Kr4109QsdPOuNGXzrj4iSc
m40TS3FoJXYxM3bsx6b9WL4PM/dg/C5mpZFUqc7qX2sd9KsagehDSxlmwSxo
+Ie0Sux4wzhXNlY3Jfwl4ZJsDAUXvCRskLBCi/kSpvFJwyX0E1ZAa/SFxqR9
uV5dCglNnMpsnEqdHUvcHYsbORY1NKeQsINxQQ+jggGG+bLXIA+6RC97jV72
VmTvQPY+ZB1idpxF5hVk3hJcYOmvl4S4NMRk4E0GXmRyUJ2Fv7LxRw5OC07k
4rs8fMsWSuFECeYWY3oJJpdiLPOjf7kYHjpq0VqLZlo00KIW092e1lNgxhaK
FcJAJpGQWfrNXYsxMjr070x8uDKcDs7OxknhP9Zg3zr4bKCWDXuxdC9m7cX4
3RhII/mkJsmywqfoRobsSfARFVRkTaH4H5RL9E8jEccE2Ctjfw/GXRWsEtDr
gXK6C35kJ7+dT1otYbGEOVp8qcUobhGOtINk0FZr2kpj3bzcohYB4Wq2ZdVt
SuvYlDSxKWpjXdjFmiJIeb1iqn7ebL3cRchhy5Xtg+y9yD6M7BPIlrlTPwyZ
75AZxyF9AiJSEJKJl5l4koU72VzjmYNTquUSCuNTgE2FbLlKFCA+sRRjGHAN
FI0adNGgjRZNqNALtbSorpotwRMjOfNHaVVBYnL8tvxTL5lv+Y6IY4//opOs
UTZKICPw+Vp8vxE7tmDTNqzdSS0zdivs6rITrbfrV8U1jkBkv/8vJGD4SUtV
HDUCt2mZ6qXUJlhnTLyU7Z94xRD/jGSuycGKsHa7JXizjonXAgnTJXhoMZLt
Ohs7vSZa40Yay/rldnXKHFxLbS0pX17PvKSZWXFb0yLmmvFIvfyJenkzkbcQ
eauQuwE5bMca3mL9CkBmCDKikZGEjGQkpIgYHgLKvchgK5eNazm0PHY6V0Q1
QD72FMC3AJsLGQAUYT6r1CQNuZuh5aRbPQXTtKAUrJasXE0GZnbMHwsDmbCk
VOR3mG/W7JL6yDyykPRQaopMOyS5IpwBwcOe+HswLozFuem8QM59mHvvwBo/
LNxBB2N3YQBzrtl2NNlOy4W6tXXm/2Pe6UsfVxYrNM+U+KZhzRMvARwEtCsi
XCdjIwIL9zkHIAzjb3zOQQm7JLKOa1nlZnPjGGHJtegjOKehKE4MqJbG3LXc
tnqZo1Opq32Ji3GJqmkG/fULh+kVjBUEZ141/o517hSyLyL7OrLuIysAWaHM
wARkpCMtA3GZiMxCcDaesZpdz8WlXJzJ43WoAhFYUkSztRhri7G8GAtKKLr5
shTjmFHCZBOmZmVrRr6fFEnABHs5+8GMMpLjduabMbNU6CRlgYXQClrJ0KrI
GmnOeFsXL1viYVdquTAK56bg1Hxi3o9bqGXXXsXHmQq1E6/+O9FZMG8H3P1Q
188GHxGc5X/Ft0+y9CY8Xon+VTCwTLGMrpTFecuhKgkZ43AB9E4y0DvAjdsY
hC+VMEvCRG4RoUc3Ldpr0VyDOho4k3OztC23tyqrblHKnONbNlmJ3E3I9UXO
PuQcQc5JYR6pwj3rHrL8kRWErChkxTOuyEJSNmKyEZaDwBw8yhXYj7DE7/k4
UYAjhdhfhB1F2FaM9axoC8swqwxTyjCuHMPLMYD5IYdCTWVQoUSY7MgMCNHp
k7ERHNRT8l30nbRTqgPJkhkHyCFLqiPeuSOoKZ52xO0+1HJuEk7NwS/LcHSj
UpyyZQ9WHsDc/Yp3NGq6HTW3w8XP2NWPFwx111PM/isO/qteFJUiWzcyk2Bc
EicpKD1ATYNekXCG2bZPgh+3fCM7OgmTJYyU0JcbW2nRSAt3DZzKYVWuaBpT
q+lgCFUrmIr8uchbhry1IHT4LXIOIuc4ss8i+wqybzMTnyH1NZIjkPge8Un4
kMk5hVwE5eJpHu7m4Vo+/sgXeipwLb4vwrfF8CrBxlKsKsMikEObqsEEDUZo
MFBLCQURK7Vlm2/EoNtcFloijYFMJvpnzyayMTPJRWoOyY4LAkALtmUmyGIc
HdIQz9riXg/8NRi/j6eWE4spdjrkg107iXsr92DOHkzei6G78cUOJftm64dq
fpYOfq5OfpxX1bWcaqbH4L/mI/tPTpdrWOvkcDif00XgFRuBVl5wmHWHUSWN
mGOsnRK2SFjJLTOZhyLSGiChq9ZQtY8tWYNLGqC4NYq6oLAPCoaBcMp05C1A
nqx/fmwzfyT9y7mAnGvIuoOMx5yceIF3IZQRehuH8FSEZfOaWD4eF+BWAS4X
4EwhjhfiB1BE5VuCTaX4pgxLyild9RUbTCFVgyT0FoNiCXLkXJAj54KsmI0G
cjQlKQbThBvFCQ25cRO9c0glmbHlZLvheL0//hiN3yhuwLHVOOyJfTuxZTtx
b95ueHyLYbvQe7d+652cMuLEnomvjZVvXRvfNlVpH/GLRqFHn/9CnZ9Dn8w1
XlMqYx9XoGYwkpgdoax2srO7wC0/str5UAaJ59AajcgqzuGXqUmphV5JNRS7
oYh/K/wCBf1QMBL5kwS5gcXIW4O8rcjdidzvkXucOXYJWdeRcQ9pT5HyCkkh
nD6NQHAMAhPwPB3+uXicj7sgh3axCKeK8GMRLapuL8FWUK50mQbzNJiu5SBd
rp/gAFjAyLrMKBdmgiXDSKFfeqxrXARBcETgFTkimKRUy4yB1JSUDgowZIyS
Zod3NfGKkuS41VvJ7Fkd2YLvd8LnW6zajtk7iAxDdqLHDrTbqd9oJ51i5At9
XzMlb2vq20kmfZX1/P/mnG6NHWuq2UdOycmMeM6/ipc/wRae1QItvuK4eJAG
PTRoXy6ni2ksxiUW+sV2KBLsaQQKyrqhYAAKRiF/MvLnkC0kJnkjbw/yDiP3
BHLPs2m8hYz7SHmGpNdIiEBcNGPGD3iRgMfJFBnfzsf1QlwGwfqTpThSij2l
8C7FhnKsZDwjSN8TSlqiiRoNKzhRtn/Ca+l/tIDG/M+GqSa+UCAnv6SFpEf6
Sp/0EkYi2xpJzgipC/9W1PLnIJwbj5Mz8PNS+cxqu/Zgw7dYsAOTGEAKenTc
bthou0GN7UaWvmyOfe3g446tRCUD3+FV6ZZ+ZQ36hDt0NtPfgqzbVfZQP3Eo
Jl7rtVimpThssvAE5bJFq6/XoNS4VomJA2FAK6MiB70iVxQ2REFbFHZn0zYG
+VMUDyUwPOXH9yPvKPJOI+8Scm8g9yHz5hVSgvEhEu/j8C6JC25Byz3/5OBG
Pq4U4FwRTpooNmsG01pY18EibJLQRSADNafqTpUNlFC1ZihRkZ3QZ4umR35K
8UfEwO4iTBEHyfnME09Io/iLI2NDdlXilW2HqJp40QQPOuJvTmGcnoJfFuDo
avzgLft5q2k7MWI7feuwk8ji7mdq62uq58sDFgzZ1ggbW2OtzHHzKjhS+Viv
wmd9bgWW2gzVngh4EkLM43xgDEPDp3zqJS1OaXFEg90aePIa90KFa3XQjQuU
GhSjZrFp9SJ7pyJHKzJ1NVHYAAWtkN8V+QNZi75C/nzkrUDeRkKGufuZWWeR
dxV5d5D7FLmvuSUWGXFITERMOt5mIzRHxGcsRy4aWrL6RoOvNZgpIniJkTv7
xe4UxKOlpKwL1eB2WpRQsxl6zDOFf4pNIwYL4DhSsUQyDJZOKzbOXnKHZK6g
Qw2btqTqCK6HJ21wqzsuU0YKJ2bjp+U4tJlys+L1zW4s2mUkX2/VTlUsFz9r
M18r+FBszuxrhTWdsaIXVtGqLlNezXj82959iixMPmnhrBavvRSUI6UcMeUI
LsPTMtzmFT1her4vxQ4ZmQu8MKUYI4vRqxjtuQKnViEcC41sC2ytCmqYF9Q1
IiUTHOuCvL7IHYXcKaxkq5C3mbCE4FjOT+yf/kTuP8h7Ln41p25qFOJCIU4W
4Ugx9pViexl7IS2WazBfQ6Z3ghYjJAwUKsYcaCMp+Qw5NLbnRplRwtIZkIKp
cXJN2jiHnhIWiOOuUldCSUYy/6pzqR6UY6t/OuOv/jg3mg6OL8SRtfjOhwKt
9XuoZdYuk7E7zXrsMFCibFc/Sobo+wgj5wYfBn5rOmFFTywehPmjKqydYYW2
/AsFfoYzOhkPrgxkY/+hCMHFeFqE26QZcvablnaWcGXIxAIMz0fPArQuQF0u
VrDKNzLLszTMddbLrcMs6IJcwRH2DKj3FmkfkJzKyxX5iMpHUAH8C3G3CH8V
4XcQKPihGLuEvyljf6PBQmbHl1qM0XIALkCbErgqy3iubOhsGBGYQbFviiYY
MmPMGYTXYzNkJKWwrnwDaRABAyUS0hig1AIJTnTwpK3SavELL2Ec3Ip9u7Ft
L5ZwwDt6p/6ondW67rBs4KdYUQszHxeii08T+BAkwLoBWDqYeDFrImZy2ooQ
m1z/LVVU7xr9jzVF3QFI1Heg7pp7IHsGshYhax1nEfYj+xiHOleRdZdbwpDz
DlmxSIxDdDLCRYzKFH9UgJuFVOL6WzGnhIpJwbaW8Wq6FnO1DJAlVeLZqbTl
1aB6UJIK8ipdRQbPTPUoMpFdWOZlVflZRlXV5BU06TCkOZC68HdWPTJORkiz
RVQNBDISu9oPZ0fh12kK98wP+MF3D1btFipAx712iH9Wnbc71vWztfQ1k8+B
TyOmfT86WjkCSyZg3hR8NR2TFigyT1TTrUQz/AztK/sbVQ9Y5nshMh3PM3Az
A+co9Mf+DHhmYEUmZmViHLd8kYmWGXDPhH2mvim1OOln1kRGU2R04oWh0cj8
CplfI3MVMrYhYzenEE5Tgpx45o9MOSOUiLRkxKYiPB0vs/CE2XatAH8U4NdC
slJ7S3gRj4OaRRrM1mKKFuO0GAZlBa9TJbjsyo02avbOVOWWoWq35Oi0E9NS
QIb7UF+7JNfnEkJfQroDaSekccwyB8YEfEKOBZLs8aY2nhLmwPnBOOWB43Nw
ZCW+26Zw0GHBLkzchQGcpm3lZ9pqu4u7r4uZL8connUh75rxYaO1aBzmTMaM
WZiyEOOXK9KuW131n/j2n9CEhcJHtoHd6HZhSXichGtJOE3ZbvgmY00K5qdg
UgqGsolokYo6qQZOqcaWVCriiNS6SG2F1G5IG8xR6CykLUXaRqRtR9pBUEX9
BaTfRMYTZARTSpZaMpCYiWgRoObiWR7u5XESvRAninC4GHtK4CNQdZlwUpQd
mlVOiJKsnERW7gt8LFYgOGeoaJuBiuLk0NRUdqECPig6I1FQFyzz0Cp00EyJ
CjofxjL3LsvnNJAaQbInTjIcQq4l3jnjdQPcb4crpLs4MRVHF+HgeuxjOLeU
IcKwnejGjKzrZ1LL197Nt46xD8kXNjXBypYqLylRgilfYeI8jF2KkWvpULf+
x/Bf2K6iGuhfddWMLSgnR41UW0Z7+W7G4fc4/EhFbNgYj/kJmJSIobzxqEUi
3BPNXZOsbZOrGRFLGyC5LZJ7I2UkUqZwuc9qpHoidS9SjyH9HPPnITJeISMK
mTGUECIi5eJNHgLzcD8ffxfgPMgjHSqmIlQRAVF1Xjl7JA2+FLzS0BJyT1nj
lMpw9kKycOpTEsFIUnC3Cauhu5wrsDD13ypP8xq7US3vZ5XmQeoNAm8WSk7B
7A9KEuLnuTi0Avu3woezBgt3Go3ZofioatV9ze19Hax8ahn41KeGNa2wpAMW
9MTaqcqSyaT5GLkQQ1ai/0b09lJp+yk/dPekmig6Q2fzaBrhq1gMjUM3pr97
nJ59nG21hOrmiW7szzsisS8SxyJpJi8gbUTKDqQcRMpJpF5hjQlARjgyYpEa
j9hkRIBypS/z8bAANwpwkVHYYVDU6VWKdWVYVk4QbIZMCRHI1GU5d2Q6mqtJ
bT01rw0+FK7JUcXIgzn9e17BXC0F6JJfSk6hs3IoLtUaQGOKNPb+/7TElW4y
bWt8vw47PbHeB1+zGozebtLZT6+ZH3Vo6Wtu7uNk4FMb3k3hzcmg+d0wrTdm
T1DIPnUdBixF7zXotlW/s/d/pDqvMSnUZlTMUw4Ix9UIHH0L30juPkrGUFar
uBhnL5J/QvJZJP+NFDktFkurQEkpiE6jdYQXsOSztVyCxtkuIaYtKhU/OXO7
uVJvYyAvfimBhrVa30cIYIyElSCPE6/sxrOXBsq0eyUhhbdUSgchTVYtEG93
0uohzxzvmaY32uJib/w2GsemKxGKlw+WemMaOTKM2l6tk595fV8zZ19rOvap
Du+G8O6IbRxmLhqKSYMwagSmLyLKypYCnTegnZdRq/9MVx0MLE7hSN8O/sG4
GoIfQ+FFsAhfvcGQCHR8i7pRpLemUVYG0W5415zzw0PwwQMf5iKOqe+Sw1XJ
hQSgfirB/hL4lQpRp8TVPA2maDBOg2FaLnNiQrakZ0N8jMdtoORH5KyVuVK1
pQhiQ/bfHhKvFxQjT9kH8jZEPmGtREO4L4fpNyBt5C+tyZbLclxmgBQbhNXA
Q158OzcAv07AjyyN3ry8PdcX45jmvfwsOvo51PK1dvJxVp5U4N0G3n2wjQO7
FdMweTyGjMOw2Zi8jcjemyit19TbtIGPbW3fKqguRxdqxvk/7e0jq067G8FY
+exrfBeEzbSZE+NC0DsELcJQncqRzfQjnPG2MaK6cIZqMt7Nw7s1iPXjlOJv
SPgLCfeR8IpqbMjgpCAiFYHpeJBJ+yIvgsoIjhYxi8qwqQwry3nBk8HSUC3V
dHTl5SA5ZSLHc9UqEouoiCSUnYxkgsRJzWXltLFZKOFmlsyYacJsCygn49wo
SD/zlwGQGkKyoSSxHErZnBmKY5Nx8Gt8yxUfi7fS+xA/dGGz3tLX2c3H2dbb
jfnVXKmAg/dXWDeTvs6Yj8HT0HU6BpJ4EFMakTW3dPOxd/48R3RrDz+3R+bf
e2JYKlti0Gu0C0ZtghNGBqH2CKuPNx3Yck9E1NeIXouY7Xh3iD3n34h7grgQ
xH1AfByfk4rH6QSYL2RRnc2PrDZ+xZSPF6xYoOEKG5UVX2jRllcv6zPhq6tB
nVJzplYL6LN3tWVOCFvWU7VS1yQO7sWryVBJicrwclQT7QTQ45fouLgc0mNm
zGJ2s7XVGhFh+uPs8NwdN1vJVxofmYY9C+FNlQ1Y6IcJvvKZdu4+1Vx96ph7
19HzakoNG3rBexJ/Wc4M+gYjl6PTfLRbKTPIsI53tTpeBv8fvKlqv5JshM88
h3cgFr1gTjWwRnAdhLRHWH+u5J+Ht2sRuRPRRxBzlvdW+CM2HLHxeJ+IUGbN
3TRcyaCtwz9m8yaWAtpis7IEC8owTYPxleKJ9gxDlWoAbrRR8Q2UVUkLDiTc
KP2oZnk3S4ye4lF2AlKfZjLCc8A9siODpNHjJPgw9JHS+P0opNmQ2OCL6FAr
BIPVLNoBAfVwox3OKjUGtr4LsGk1VjKOGeWL3n6GLf3oVGdvB2vvWoZeDeHF
qymLu2PFWGxcrMjCjG0YsQnd1qHRSjTxltnjXMOnXk3P+rZ0+L/mkJGCU2tU
+O2zT+Drj9nPSbW6BZo3fiE3u65FxA68PYro88yRAMRGIvYDIhLxKoVLodJx
IRO/ZuGHHOzMA622F2NRKWaWY6IWIyo5lVZyLaASX8v+RI0J9PlQToQIhrTk
L19JpAS/ghCX5g6UJVpzXCJf1laidN8YdQMnXfAM0n61pqMOhNsRXZcaIJ9X
LB41wLWOOM3I9Pt56k6AhZ70MchHr4OvXnMfS7nV0dirNoSueHHItaA/pg/D
13OxfDMdenhjsDe+8EYTT7huo5k4egtCNnP2auvg2c7Eh84x+19yRXcvlIvi
e8ScvR5jLkXVBu2fWdQJsLemZ2E0xsvueD0GwezjjbJwPBsHcuGbj/WFWCZn
CuU1Xis524cK+ZfX5hmOVqNyWdUiTWIVIJJrVHobNvtZws8pCLlko/2DSWko
UCjhfc6zy3nDu41xsTNODsZPvJC4YwNWe6rZrF7b9Zv76Nf2MXfydlD0yasD
NvaGF1uh8cPhMR0z1mMSURPdvNHSG+7eqEYC7mzjU9/aR1Ckh8O23hae/x+0
1Y3JXdQr8Os/TBd6szNp+dTa1d/JjNSgAwKH4uU0XszwQ+hhhJ1D+B1EPkO4
aHmHVx/wMIGegHFBxvpl5KIHa9FLi05akvZGUJyCHbthOTdurPLATI2E5Y26
jUWEL2EGi/wRJb93iZMWA7ayJzj3SG41HUrLgngjRBzIDELRWRb+KUoVRiXK
cB+HKDcGn81YthVTfZV5WtX3NnT0NrPw4pTGJt74tHUkNvCusslT0X8SRq7E
8G0KNkYdb9h7m1gRR+zg08yUONLfynOU9dbPckTNRamrvrqWqro8xN9uY8U/
GPdAvlMjZ5enNU3oURN9ETARLxbzhqJDCDmD0JsIf8LPpYjBs/e4E4fLSfgt
lfOBOVSOvLGAisNml/AmRtU7t+N6y3pqSqmi7NWgUgymZKituaK/EccOYyUs
4d9ulILA9WNIW82kmTP4kq3hcp61nobc6S8CygIfUpH1lLvzg8RiTUiHZY7Y
tG8dNa3YjjFb0JtNhKu3gbmXCby4jmJ1UyzlZMHK6fQ+eyV6TUO3RejNGlGf
vIaeube1mberKV3cHL499H3FDSaab51mRCz4hAeMZD95HqDih3+7gdW0DQgt
/2GZqTUGz+ciYD3ogUCnEXQdIY/x+iUXdb3DjVicj8fPyfghnatcc7G6EF8X
46sSjC3HICZ2B94j1FBLFauys7WQ1+9I0uXaJwaq9TkxK7DOXD7pqsRu/SGt
8Uqb+khuHSRMpvyiwQdKZtWKGyzel0t9D0sURScmMIE5sccMUK2jwextGOuL
dpsV6TaGlzE8XeDJKb75XbB0nLyKjtmbMfQbNJ+H9lvRmJ2xmZdSF1bfiEjb
GdsHwG80SMAXmWz+LGWrV/KfMtJGo7tObg/qGD+SUbPTn3j9CC8D8TQMZF/e
42wcfkzEnhRetczG0nzMLqLS0+Hl6MNEbC0XC6kWw9JIkUo5R2ChLtu0ltCX
v3hzwSYpy1vkPFGK4ayqX5WM72fhBm2BbC7QiZBXiZZoImScn0kE5BNpHnSL
mTsw1AftvOHqVUG/bXXgyXHOjO74ajjmzpdphMFb0GYt6qyDGxHPyMjbztDL
Xd9HvqofdozBjinwmottcjahatrpPm9SfdYhTPRq33ZxvNfa4qE4GI8ni+Hv
KwAH09P6Hc5+wJF4fJuMzemcfMzFV4UYy1sIu2s42cZRq5v8rI8KHecv5gy/
BbJoJltFrre7yaYjO0b1dFat5W1iv5LFd8iigpkFEqngSUn/Gf+i5QdJVTwD
B47NvODkxVsYNvBqo2cvVuChGDMMUxdgHEFq9NyGVtvgsh62RDVbA29Xw21N
9AWBfRW/Ow07v4bvEmxSkjBV083tsx5sDiVoFVvdzpjEbSYeb4D/94J69CAJ
IYb+QgyjcI1TFcbs9C3Y+xvIVlBfyaPIxbHqHj/a40AlbTtk6GB7gG3mIC4t
NfiWlo5tXxxsw4FjP2kMuDKHGJMFiZ9Cwjv+KKHT1MvQxYsyvoarXbCWF/88
GSgMG4nhszF0Fd/PDPW3wcEThkSmGvreTfS9Wxis74Vto4T/lSm1Bts3YIsn
1imU0vXqMqVqVkUpNkNLLhGNnG4w2Wotw6MdeHoC5O0f4sEr3HqDK9EiSKcI
4NtEbEzB4gxQGFuAIcXoWUrbbpSoAh/9ienH+n0lT2KhruO14qVUAWS3yPXg
EqJLOYf7lF37tO707rw4H2sfsLJfZ60lnDNFBOA0ZH7eGalATS9nM0+Ospc2
w4KuSkZp3Ex0/wq9v0EX5Q7CohnreTmwlWmv5/uF/qZ+eusmgMR4NSghuAPb
dmPNd1hW4aE+oV8txbpVPGfCwNr272aGtyukzOUHPLnE/uEprgXjYjh+jeHS
tURsSMGidEzL5oKZYnQrof1jTTWUvasOxTPI5dgGsn/QkzGhugrXSaL9HAv4
1N8lvCznLG00pDOQttSW+g1jMo+gJ6QYf2BFla7IyCdatnCS/ARTLriy8SQX
rbewLeb3xRyKqjF9HTrOROfVaLWV6cUqqeftDjL/PeA7CNuG6a3+EuuWMwk9
sUHWhUOYp6yA6qJ0mWa1dVo5V8TAcCZFlNXM/+pmRoW2y4Q+yjvCnuJ2AM6G
4HgEvhPHcVifjIVpmJKFUXmghcEytC5D43LU1pLvlJNwxrJR4x7smZjy5gRZ
0Cbzd6GFdyXOAmagLJoFbX471tmOVDmi90+KrAxGLSVawDxENZHyZk7VrlkY
zO+KeUPhMQrTaV8q+q5Ds1VoyHjE2MtaaKi8jjoQvhPgMxnrp2HZCtCyyW6s
349lB4WHl+n2kSK6q5ky3epUpaum+PoMaxN6GlCwtxn3DuDWH7jLvsAsHgtS
8GUGhueiTzEoJa5FfS2Zdwe2VGoVl4laW9dQiQqxhEs9T0sgsJaOtFSmzu7q
rIYuGpkuJtA8Eh/V84f3y67HBGKz6VyBNzBtGCZMxNCZSnUeGqyFmyc4Pqlu
6NVYz7u9ECe5Qmwm/OZj8yKsXA3apL4Py77H3B8x5TjGnALhG3W1qBIN5GoU
3achE2XYDpvsxJ3juHEV10BlpcJd7X0jFJzjPXNOBZqohdf6LC6yAxQ2v6Zq
1yfI1FWuwVHJ8K2Ed1GIIbK3iadxeUhO2yUq7GGOkOHR+3Icxs9Af64v6MSy
YOdpxrOuZbi5jb5Xb/iOAGUFF2P7MmxYh9WbeN3pO8w7jKnHMPY0Bp+Tq/C4
nkAnSlNb+AnLqv2R/WxzgyvygH/Ard/x911cFd9f4rtgeEYwGIjHxBQMy0av
Qgghl5OjLqqfM1YkAh+XXCosdBsJ/SVMlbBejgB5F5qGpUO6wNLRBpJLU8lh
qWR3kWs2/6anMNWKWNIui8KlsRLtXOA8Cofh4xagH8UOaLFNzg/Ym5OJaabv
2c5g3RB4TVZ9maUnvLZg+XYsOoB54vg4xp3E4LPoeRkdbgmMz5LxOQrpPvv6
o2y217s8jQVD1lCbFzjyCt6h+CaSQXcyhmWiVz6VIzUt59hELSDm9HFFJVAN
Jl9DzqONUKOhXyXatZDE34simDhTIHWh9Xm03sPmd/8z3LgvPptGrGHRaTlN
opSLq+rF0Hc12tMSgKnrNktLT9mrd9Lz6a63fpje+pnwWgV5VzQs92LuD5xt
PYEh59DrEjreQPPnck2HWo7Cmfkqtafh5yhk2JWz7N/h5mmcl3Hfa6x+g3kx
mMJs75OHDiVooqE93nIwYya7LBkFVWccKRcgjuefd3Cp5XP+nilRGlC4Dmka
02fQLKm9NwvfAUrZ1Ln/nXsubSiuK3E9m1uFl+izWa/tVhLAGttq2Hq6ih5k
2zIEm0fqrZiN9atAiyFeWLxfqJdsz34FlYleRKdraPEY9cJQI0XOJqiP1v8k
Sy7TplEVtJF96K+4eRFnrouQ2xofc0VynkJ2NM2UHBlvFRc8v8Ct8RIKE3nC
Iv6dD2l6Z6n3ZDq0WPQWeyiId4oklYW0uJPEaWfGaDRYk1akJW61ttS38WwA
r45cJ+IBzylYPRfL1rJ278PS7zDrCCaeEDOWseI1tHyI+qFwTYBdIdcr8tSg
lit9OuvGilVhe0axlD1OjuLxX8T16/j1PmeUX2FJGKa+w+gk3upSgBZlLAgV
hcI6GTQzzvm7V1BFzuAcYKpEsjzQvo/LkPYxeeb15NKoAYn6SwnXWD16ZVnA
C2USLY/ITzEmPbF1I7Pa0n5rR0NhVuUIy2wB1i/Bks1Y5scA6RAmH8PIU+h3
AV3ksmyjijkrIiBbi6Y69Kh4opXDNNYFUJBAiZRArArCjLcYE4f+oAireRHq
lDH6UAypYkGpGEddYeoocdZdySzx5ukgiXeuBEO6KTvYutKIBpz0GkxRg+GF
dNal2hU62dFhcy+TbcPgMxXyVkj79Vi+FfN2g8T4KEafxIBz6HoFbe7wdob3
sM8mnyYXlZgo24s+zllPfPlY19nsc/M3WKLOX9Gol1gQggnRGJjIpSz5qF+M
GhpyI2aMWdVnv7HFdOJipXZcdTaNK2YNzkGtBZHX75GngUSrSrI3p3Xl9qbb
hlptGiNiZIacG0G5oZ2Y9x3bul8x+Ax6XEa7G2gcwHsCsmCpUeYpxM1driKq
mMsc5Wld8t+G0Jkj86sdfgHZ0N/u4OgjbJdzxazTFiy6IpjpoO4yoM1nxyRO
WPDumfJyNTY262sntWzPk1suKYuG6cWQOCCup1qxEaabpupvnssrwVuxcofw
/nJUepxF5CI6/I2mT1E7Ak6ZStU9YRN1nbWqeen+3QSeF2Hh/mJOwO/45S72
PmYihmBMFHolon0Op17LYK+BhVaMn4NcOfqQd8TIy3WDWVvXU76VDt/xngbS
1khI55mR452kmo481/n8/qIM8byQzf6XWD7PZP0yrF/PpQZ7MPcgJv+IkXLe
XFjkULgkwroQxqquzFZmUXmFjOsDeK4tK1uoaqN5guJ1F15P8LX48gYDY9Ep
Fc3zhcEh0GtRqdZaj9gtRxacZRvEqGYDT+0+b6wnlSxAaQrPcROk/jxHmy6S
43qe3R9UK8u+gWDhOqz34mkJwTyEMScw8Ay68mgaEKtNlbHKI2+twyWKJNit
mUShewJaZqJuseJMTdWnPxgqY23F2/en8o8/8X5/Cu4KEZ+FnHge4nJIw/lL
Zw8e6KYyHKJluMaqLOzCCvF+EB7HMfQkel5k9QGliu2zSHMrMHArzkP/2zq0
qWLsMr9uwOsB76GTratzpZJROf6XE3GrJXwnMSItwot8JBSANlT8BGktD3py
W2nkTPqiP58L95uq/Zv/gr7n0OlPNHvCSCwVllql6IqSJhafjLTt50Zqcwtr
H7H9eIuuiWiWjZqFcChnPqpBgGw/bGgFjq+x5UKjXRI/2aMUb0t4Ldof0k88
6o3W0qpebPA6a43GUvF6c1UyTqHrRbS6j/ovUD1BiUuVYn+SCsMKlNpOkZEK
nV3FkS4obUCVmdFolUYPX3Iqp6DFqKKjip0eBpwS6E4bD2RMKGCWlh7cQZJ6
H9ItHuoPbtLytgzN6xFwb6miGUMZF8gvI2VkHGvx346oTMmKp1R8i0N/iqBf
zhJ+QOMc1CiBbRnM2Y6wRLPhdOJy+s6SsuDsKUuzWQKkZB7TbUi/utKXRmZS
g6a8NaCteg/lnvrKiORd/h2rGJFMg7/wzX1MDkQfGSiaMzct2Y4JYNKa7z+d
TfdRgc9lP9SSB0H9tFPuIj81t9Pn7mL5NxY8wuhXHE1nwlVDkbOJ4vMUH2ut
evieXO6zUhIaRz8F8FY9KmZJh8af77xUkYfWyt05IyPIJcuDo8ohoxAefz5p
lJlqF/QV6azB8UdXruSS80EnOf4IZXkty+Qo7SikbXxH4rqBWqPDf9Ok8jzt
K6h5m0E7M1K5jx27cYFiBvJNNnEC5RZ/zy5CWT53fw/SD/ylqTIjjvjE6D5z
H+O7GPYS7WO4/q+MbRDjRltJlUmC0vQ+mR+DdUBiJCJuqWXznAYpjO/XSLmf
/Jc/uuncj7ODlnPUp0w8xEBB0Xhe7SqFmbbS0rq+oj+dOZ77WmLwwduZBVhL
5O8lseBHOSh3ZMQilE/mmV2lOzPreJYKOlAmRNUUMlJV7flhfjrBA/6emsYy
wqiP+ucIjf9iTuUZ2egcyzjVH+2j2UZCybBWpPVdeBu6/JC0hfz8g2P8PbIA
oe+4ZKGmIhnyX6bqpdM/Vy5aV8bNoCekDwlEiw+oUaSglAr7aSevhEiculHH
c02L++m8VFlDmRujFvTWuZeV7txU+22YDKdSdR+Implw4pl9IYyf7I1Kef+p
pGAguov8t9H6KBzS7b1i99k9VmqoOx+M1GeX1JSUJwN9xVJ/mGltr/TNFlI4
5n/3WWXVog1LXptIuOWQhLGJU8JmeclKWVGlhQTIqwJ0B/nv4vXX6VF37UOt
t4ZBJGpkkelVd7+whWjG4GGKbJjkfrtzvwN0+tHNdNO6tLHSjznHd3XkHToV
VffMPYHt/32dbq6Oj4lzL+D+AXa5MNUqUmEmpw8qfCLTUsCyShXiOuOT55nH
oJV6USts6epBfPWQquhfxdNDDZSrhvFVQ6uUjI/HlsrZo/jsYVVIqS6H6JD/
vh6GS5VwoA7fqE8PPmtkpV/VGI1+/ZJ/pftS6DqNj6D3fwEyuJlJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180962066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16574320],

Cell["Use predefined gradients:", "ExampleText",
 CellID->488835021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139506661],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65542976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233034064],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNm01uHMcZhjnkUJxrBPY9epbxNkcIkF1inyW5htbRRkfwKoAWShogQGJA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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxVnHf812P3x9/D3lt2VkhW3faIxG03RUbjSyo0rIRki8hN4rZLRki4SfYo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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztfHlQjf//dipEZGkjIlGUspQlioske0JCkuxbUkmLKIokIams7SREad/L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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1740825167,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->793522862],

Cell["Color a curve:", "ExampleText",
 CellID->865293764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<NeonColors\>\"", "]"}], "[", "y", 
       "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->731375041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242431953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1074194162],

Cell["Color a matrix:", "ExampleText",
 CellID->86260405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->227165110],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2m9PU1ccB/ASffD9voMlo5kyt2nM4sTqCkpvWwEFyp9C2JSBUgobjNQi
YJwRh/+CSkwQIkMqglO3VVF0FrHU9uKGGwZm222PnI4BavsytnNvlr2BrU/G
Ocm5Offk3vN5dH6/c869xa72xgaPq73J7Vq1o9XV0tjkbluV720VXSvSDAbD
uKh7XjOI9p+ipVetS5QVWlsvhjvikvZf9a78p1cUnA030VIVhyf9HMfUMpYO
hFD1lZ+WD6K4oZZTyX3MuaAdiaObOB3KR+2NYeZ2PMF1tYL7Amf4IFwAS02c
VvM0El2mldKRznJyEsc3UamLo6jnO/rUahZ0P4L7po/P12ag7EKITqOfNm8U
rfdOcrfxS7iNg3yWkYGl4SxadsWY6N6M+vQBKvYZJLzvSUc60kmB87VaSduW
77HXOMQa/1VWjtxBSX+EfRE3nq1ezYqhAI+F2nBTdTL/2Kw+5otLWRgV90eC
B+nonYKtOcbCs9NYuJotHeksK8faEONEpAiLpeu0vMkXF83wpvew2n9Nn7vJ
9o20mx7qdvJwJgbVGiq1cTxf/ybtmx9y/vo2JNs20uaJwbHmtnSkI50UOPa2
KE+E9qP+1iD12NAShciRIg6MYzJcyDMPmlllvAxtTEffFBZL1jGvcw7WrEfs
CX+sxQvUjQ7x5aAZrwbel450pJMCR3vWkTGGUrHGrRz+lufCDRhWd/PXuwoS
vVtobYxR3OOXgJWf3D6PhWvZ/DS9DyVvjDJxysTfbuXAE+imUjQn9rqN0pHO
snLKL95jb7geX0RqOb/1bZ4MtWBcdTDh2YDi8ypf+szMPfITEqdNtOyJw34g
qp/piHnJz14/xYWCtQiFCzgbtMM7flo60pFOCpyKSwEWi3hg2xflwYnPuXgl
W48D201TOHS/g3lHZ6nsnMVHxssi77bgh1AexdoXv49u4x/b3xFWF+6qxVRy
ftTObaUjnWXlzH+zVd8jamvPpQ/Xc978FnZ2zXCX8QqCkUJtbNYZfag2jrDc
N6HvG52++yi7MKnn06cin2pzvCN4CE6jXzrSkU4KnOThTHZOHtDOUHk8tJ/J
jkz0i/f6Iy5o3xPzTzwWcaITWu581bwBO94NUsQOPB3LoaLMUHE+wc9iTbw0
kgWbJyYd6fzPnX/9J8vf/8mk/QXG7bir\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171004087]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8589],

Cell["Define a one-dimensional color function:", "ExampleText",
 CellID->589771134],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoolColor", "[", " ", "z_", " ", "]"}], " ", ":=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"z", ",", 
     RowBox[{"1", "-", "z"}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846535819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "CoolColor"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91096208],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXeYVdW5xieIIE1pIffKvdFYQTFyxyDiGV2KimAhiQVLAhcBQemKAiIt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   "], {{
     {RGBColor[0., 1., 1], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1585, 1339, 231}, {247, 239, 15}, {1606, 1631, 696}, {
         239, 243, 15}, {1513, 1580, 239}, {1344, 1592, 235}, {248, 240, 
         211}, {549, 244, 240}, {547, 243, 239}, {244, 549, 236}, {1494, 1516,
          549}, {243, 547, 235}, {1336, 1582, 229}, {699, 248, 231}, {1588, 
         1576, 236}, {240, 244, 211}, {1609, 1608, 699}, {247, 696, 239}, {
         248, 699, 240}, {1581, 1493, 547}, {1493, 1515, 547}, {1592, 1590, 
         235}, {1582, 1337, 229}, {1630, 1513, 239}, {1632, 1514, 240}, {1338,
          1585, 231}, {1514, 1583, 240}, {1345, 1588, 236}, {696, 247, 229}, {
         1607, 1606, 696}, {1608, 1633, 699}, {1584, 1494, 549}},
         VertexColors->None], 
        PolygonBox[{{1631, 1630, 239, 696}, {1339, 1609, 699, 231}, {1515, 
         1344, 235, 547}, {1337, 1607, 696, 229}, {1516, 1345, 236, 549}, {
         1633, 1632, 240, 699}, {1583, 1584, 549, 240}, {1580, 1581, 547, 
         239}},
         VertexColors->None]}]}, 
     {RGBColor[0.0735532297076077, 0.926446770292392, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VT1Pk1EYvX3l3qa0MFhKCwlNSLpIbDUtHYyLTsZBa/wB9WMRTMTVbx3U
6CB+IgNtFYghcUDRKIKOMjg4mOAiK5Sh/AjPyXM6nNz7Pu+953nO8/G+oxev
np2KnHNPgX3AyeDcUe/cDxgHe5y7jLUTc+4KbPNx53h4HpgD9gN7fId1EqvH
3Wbcnt9HdrYIzhbWdWAIeIH3l8A1gf0M1hU8P8I+BjwGvoPnHdYloAwEYBr4
BXse/LeDnXtOLuAv+D3WJ8AG9ovgLAR7vxwZ9xdn/l4Dfdi3wVUH+rFvwLYK
HAAO494hapBf+iRnEbaDwTSfx3oB2ML+NDAMtHHmG3SsARXk7BnWD4hjG/ff
YN+KWy43nXEy5lewzQB9sKekh3bmkfkewf43OK4Fyw3r0ZK/mPJEXawPOXbw
nJWdMVMf/VNvJjKdA8Ad8N0Npi9inhDDZGRnJ5Sf9bjlkTGxVrFg7walmXrf
4swnb/U/hrUD1CKrHes2FllM5GYss1gXgII0UEsOGAcq6h/eq6mv6GdLZ3nn
jPzX1H88c5z+vb0jFnUmzb6jJmeaWdu8Mz/j2tNfRf2Zlr2be+aU+X8JjR+9
6WAdrqsW9NOUL/ZSUefpqyr/Y8rDbsxiPaV4ktLTK59VxbMgDQXdKYl7SZrL
0lQST0O66HMUcT0MNicD8s8zOc3cT2d9kdW+txu77LSxl4ZVE9rLPTZTXnWs
qyfX1EsZzatXz1Wlh77vI5Y/3vo6rbzyblHP3NNHVjPL3PwTZ796l3247G2W
2JvdPFIXdaY0nw+C+es+pzRHjMmLn3oTkc3frHKclI1xbChXWT2fAN8Rb1oT
qlVbs5sQZ1L2TenIKbe3cPdmMN+cDWpnjzGX/DYE9cauvj9c29onpIGc3Zlk
LubUP9Q/JV5y3gtW+2nN05DiqIuTeS7rHv0UVHfGvYq8fo1bnT97m+c99f6O
7jY1h7xTh59zwerU/V6zZ6rqubzqmFGNMrJzvwL+Rtxmq6RYtpWToHyOBPsf
kDsE+99QK/8lHeWxpBmgthvB/gfswf+qp7rq
         "],
         VertexColors->None], 
        PolygonBox[{{1670, 1669, 524, 654}, {1337, 1582, 668, 697}, {1633, 
         1608, 538, 731}, {1661, 1660, 517, 649}, {1339, 1585, 670, 700}, {
         1582, 1336, 695, 668}, {1953, 1459, 492, 622}, {1592, 1344, 591, 
         679}, {1659, 1975, 1074, 517}, {1436, 1976, 1075, 653}, {1513, 1630, 
         730, 589}, {1514, 1632, 731, 590}, {1590, 1592, 679, 677}, {1594, 
         1542, 622, 682}, {1597, 1565, 648, 686}, {1494, 1584, 669, 675}, {
         1515, 1493, 673, 591}, {1583, 1514, 590, 669}, {1516, 1494, 675, 
         592}, {1585, 1338, 698, 670}, {1580, 1513, 589, 667}, {1493, 1581, 
         667, 673}, {1576, 1588, 674, 663}, {1631, 1606, 533, 730}, {1384, 
         1940, 1037, 618}, {1941, 1939, 485, 1037}, {1974, 1436, 653, 1074}, {
         1537, 1453, 662, 616}, {1608, 1609, 700, 538}, {1456, 1538, 617, 
         485}, {1969, 1485, 513, 648}, {1657, 1658, 649, 513}, {1937, 1454, 
         484, 617}, {1663, 1664, 654, 518}, {1572, 1444, 658, 657}, {1950, 
         1384, 618, 1046}, {1489, 1978, 657, 524}, {1948, 1951, 1046, 491}, {
         1455, 1938, 616, 484}, {1977, 1662, 518, 1075}, {1606, 1607, 697, 
         533}, {1949, 1457, 491, 621}, {1458, 1541, 621, 492}, {1588, 1345, 
         592, 674}},
         VertexColors->None]}]}, 
     {RGBColor[0.195395164076863, 0.804604835923137, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVt1v1EUUnd/sb34DlAelhbaAJlI/ki76hEgE/wITIb4SQuIDNKRq0oKJ
H1UeKCQ8UMAPhIBGA2Vt6yKYtNK0vPnBSlkUoy2P1CC7sbUJhdWqlXNyT1If
bmZ+d+/cuXPOmTv7yEuvvviKd879CsvBFqXORdi2xLmHMueeg41gPg+7ADuL
mE4seBgxM/jO8PuzsD2Y17zFDCGmLTj3UXRuO77PY34K8+VY8yXmn2DejPk0
bAo2DmuCNcLWYu0h5GtHXBvWdibm3wh/WXG7WAdyjCLmDuZX4GvQ2hU4RA51
jMK/FL462Gr412N8GvZ9YvsNY+yFP495K+wY5k8h36fIuxLfJcxL0c7dgXyr
4PsD8zPw9UY7P78Zyzq7UfN+mMf+Sc7Gb4intz2/xXxJavgSWxpxXgX/f9jL
Ye0OxN5MbNyKscfbeq5dg5gy9o34vpTYSH8F853e8hB77w3/JchXQPxr+H4v
Gh/kgniRP+JJjHKK34Hfe6LlKqGuPulgnzcMyDu5+lfzFcj/dTDcupR3o7Qx
o3kVYzu+d2IcCcbZHXFK7PLOsKLwruN7N37fA5vEdxPiL0fbj2eij/WSh5XC
fkbcMF9LamdlLdyPvOel58XSwBbk2wy7iFxzwpEcDeD3fmmFvBDLpc5qryjf
UZx3XTB9zXrTD3Fgnu+k+U7EdMCmvdU8Kn+3vsnPrMZB+A/6BT73ejtrITEs
yO3PsAdT44R1fIbadwfD+BrmLcH0QZwuB1vfp3Ow5iH430Q9fyKmqPtFrKjr
5mC81mWmFWK3F+M7sH+84dsmjqhF4kFcStIw8fwAOY5kdk6uJ7fEn1jWC39i
y3tI7R3Dvh/CHtD9G9Ed5P0tak1OeBA36uKSsChyr2hckhfmICbXgmFBHHjO
mvh4G3VdhP9vfJ/GOBRML+R+WWranJEWqdWPEXMyWh95A2tfh93D2t+lqU3O
etIL0XC5gbgJ9Q72pavCtwnrGjPj8wRij0fjcBjjD1i/Tj2I3PJcHcKadRxC
TH+wHuCR44tgOLPnNavvfQ5fgt8mMb/rTU/U0rh6KTVJHXBeUG+4KU1PqecW
dD/6xGMltf7NM5J7YsZ7US+9kMfD8G1Q7dXU1oyl1lefgf3iDIOq/MTurmq7
hfE3WB0pTW1OTU0J3+elMcZRZ2PKz3r4+5Q4mFD9POus8g8nC/fqrM5SFVbT
Wsv8R4HtuWA9mBqoSt9V3W+ekVqbUz9kDV3SRoO0SQ0Tmznhw3inPk/t/aXz
EpMDem8m1et5LvKwVVwMBOObPuJxS5hE3V3GEGvmoFY2CGv6DmhOzH9EnpFo
HMyJO+r/Xfjej3b3rqtO6o36S9Rvid+TuotO7xbPchI5B6Pl4fu4VpoZg/98
tDXt0ODLsNvetNSv+x6lK56BuC3Xu9yoO0I8yUmL8GUP6lZPpG73iceq4nep
p4xJD8TqtrQ0IS306o6U04V9ylp7VXrkvtR4RX72mYPqNay1IsyXqb/8Xx88
10/qy+TiNHB4NDMf32pqmtx1RuuJ7IfsR4f19s/D90RmNRPrcd3Tx+B7PDMe
+Q706E0P8F0IhltDsLeW7yx5YF8hF19F44kczbPHZqbzNRhbMtub+NwQd/zv
UA62D/kp6e6/hdiuzLRLvq5I6/XidLt6XV556BuQv1F9m3W2qh+Si6Ly0M/6
arpTedXTqjdhQG9VTb17UD2nqL4zrZwF3fGaYhapfmrtPkAwcO0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtvTlEUxc+93z3nfLQDxOOr0qYtI2XU4H8giLlIDFqhJfoQbx20BgZ9
UfWqVxGv0JK0SmumQdJ4VGKuAwyIRAhB+e2swUrW2nuffc9+nFuxbffmXalz
bj3IQFVwbso7txbRlYo/js6tzmSbQBeIacVXjV4EL2D7m8j2Gt6GLck5V4N/
mLMj4Ce+Z8Tk8Q2gS/E1YrsMb+DMDnwl2PrRnphq7rIAPYp+GHX2N/Gd8DvE
v0fXoV/C+0EnPIKDnD0EfqX6Zhn8APgBHyZnA3yG+CL4R2wd8Bdghnxt6Cp4
ZVDteVCOLkcfh+dS1dYO0pxq7OY+KXoJ+WZx3zLim7FN40uJb0ZfQ5fha0Lf
gI9h+8b39qbq7Rv0mkw9vo6+Cr4mOlMalNNytYNudA9YSP5xYi4R+8CrdwVw
Bd2Bfzu+xegM3odtDrye83vQT4ivQn9GJ+g69BbipxPNImBrSTQT8/Vwfnam
mAH0o6jZTqFHvGZqs7Q7D+HrtRj4SmKO4asAE049s1m98uqtzcx6W+k1O+vx
sqBvWO63iXZllVcttjPnomqyWuahi+FN4At6Hd84g7/WazfmZqq1KKjXVnMv
/pNgK7mL0Rvgm8BoTj0bjNpx2+0VYBx+M2p2NrNb6J3k+2D7kKm2VvAnVY0l
XjOzWdlO3feakc3GdnoMvhz/O6eZ74NPevXqO2da7FtRs7Udagyamc3KaryA
7yKYn6mGw0E7brttO78/KKflsp13QXe2u9aij6KPBL0lu/MgvhNRvbAdPgU/
G9W7T+R/6tUT60WfU+31QW/HerAxaiY2C+vhPeK70PlMO2P8rtfbMNtt+D+v
u9gbrvF6Y/a2bKefe71Je4v2T7FdWsr3xhLt1OmoO9rdbKfPw4e8/hXWk/8V
Y5SW
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.317237098446118, 0.682762901553882, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1lsV1UQxm/v/y5GpfDgAlgsQrRUscbEB/QJAg9VEyVqUsQ1KmDcACny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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllFmIj2EUxt//f+b93mzDhW1EMbJvKW7cWEsoZF+HbEmWmJlcUNaUJfte
iKzZwmAMisYyxjKScEuuibgxtt/Tc3H6nue855z3fGd5O81bMWF5PoQwFylE
ymMIF1IIJZDyXAgLwFPQ1WP0tiCEXvDeyAFwNfZtshDaIr+wPQy/je1pzjvg
Pwher1joqsCL0FXAy5Hz8E/EeAZuG+07jfP58IXJd50g5lTOdhG/BXwNco+z
N+iakc8+ZCl4J+dFygeZAp6E7iVnL5DW4GJ0G8G/iTcC/yXwaeDL2K/l/C7y
HV6BzR1wGbIS/A3dMmyXIh/BC9E1BjdBfsBHk/NjbFvD1+Vdg1XgMmR13jaP
wY90H7ZDua8RuCo6djk2f/jnGnIaVWib88l3KHYndJXYPkQ3ArwSn6fwrcgG
fBvgCdtV0Wdfcs79VjTWP+zCdxF8FjwjRh28Dn4NPgM+NrmGql0V8iC6JqrF
T2wmgmsy5z4c2QM+iO4zuBVSiv9c5CV4B/bjwOOTY/XkH86CzyTPkmaiG/5/
o2t5QPmBXyABvAWZHN1D9e4VcgXfR+h64NsdGQDem/luzdQpzvtGz5pmoDd4
O+cJ3B1ddXTNVWv1eAh4MHINfh25iv8WbE7mfEd99MxqVutyrn1DoWOpBzPx
3YzNa+K/w38qvAA+PXjmOusMn8XY1qL7yXdo5ruKVY/MOuEexNgGHxONlfNx
8Gx0H7D/qv2I3hHthnqmWXmIblPOM1Mc3VP1Ujt1DnwvenY6Ijvhl6J7Hwud
2+vof1OOqsVIeG3eNemTnIPuPlTgXpcl76p63hM8K/pMb0DA/x+8XfCO6K0Y
hu5G3m/GK/h1fPpxV39kTnKP1VvNjHanJfxy3juk2jZL3nXVuBJ8I/mtUYyL
0f+kf9Gdu+E3k2NXcn9TzZfs8t5B7Upt9O5rZ5TbjMy9U47Po2dQs/cPm/vR
NVTt9AZeUmx024LfoMPwQ8mz3ZzzI+CjyVg7ploOT35bVNPZ8IHwYwXu6Xp4
UebdUg87g0syz4reNM3Sk8y7ppmSbym6N3nHqIneCe2CctLZGeR9zjZd8e2S
+W3cj7TPXCPVRjumt7Bd9L/qTdTst8r8lmgH/gNgdsZW
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.439079032815373, 0.560920967184627, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWHtwV0cZvb/c+9stbaEQp0gpFCi1OBbpwxF8ja1W7IydgUIbMm0gaEkI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmdsV1UYxs/t/d9zLYoMpSoWbAHRSBXExDoSxRGbaBxpDY2sCmJilChB
xGrENAQ0oXGPgBic+AGoCKUISgSkWqC1anHQ4tYqDowDqYoEf0+eD0/yrjPu
O55zy2fcUX17UQjhIVAAnTGEDjA8CeHKNIR3kLeDk9EvRW9Bfh2ci1yC7RPk
HlCDXob+C/JPYBTydGzrsxDmgNkcsh/bpug9tLYS/w/IvWAk+jT0b5C/AiPQ
J2k98mtgMPo56FPZqzsP4XkuW4XtcuTLQEDu5Yw1xK4C/dHHEv8W8lZwEfJQ
bJ8j7wXlyBOxfcraDbojekPBa5vAWan3qMH3Lnpj4hwMJn4QeIQj5xOzB/lN
Yu7Dt5D1XegrMt9tFvpJ6CeC5cQvSJ3bD8BVqXM8HN8w0IT/AWwXIJ8PetCf
Q/+Q2I/BtcinqAb4lqGXoa8Gbcg7wRXIw/DX4m+OzlUrGIM+D/QiPw3WILdy
v3+IvZ98PUvsEnAkeM8m/GfjP5W7jwbV6K9G53IzOIDt1uhcF7NmBfILILLf
6fjHaz1ox7c0da2mqqcS10y1XAfGp65pEWe1RvfWYvQO4juwNSPXEX8m+hT0
CYn3WIm+i/gq4kfhH4k+AmzmvMXKiWqDvyLxN6xGvlo1Tl3Tt6N7Qr1wMfpY
fONy31V7tHNWu84s+A5vZK6xaluF/wzkity51J0Osde/YC6+WdgmI08CY/At
V88QW5q7tuqBWnzXs2dp4p7aEz1Dmp1qzRCx5bm/RT2xO7oHVPtrsB0fXSPV
Zj41WI+8DhSQx2FrYO9t4CDx92ArI745t68RvQRfG3oN+jL2T/EfKng2b8N/
nGYNNOB7CtuA6BqpNvfi34J8bPTetcRcqHnLXYs+YkrFFcSswvcgMW2aH/zX
4V+ZePa+BLWpZzDBVwRmo89jzdHIx4B69Hr0PmL/BrekznEJvhNyz5JmUFzz
K5iRmnP+QP4TzES/E/9/yIeja3NXMLd8Byan5hhxz4+gLjUHfYt8FHd+InFM
JWedl3sW1dO/4/8NzAk+I+A7Er23vqElM6eISyqx7cNXjO3JxGcMwDcwN3co
x5lql/vb52I7SPxf0XfXN/fDVwzuDs7Jfnz9MtdG3xzx5bnXKqY9mhPEBZoR
9fLQzLVWTx8uuKaqpXokx/d1NNc+jj4B+RJwQ2JOncL6jdFcvVMzKi5UjpDz
xL20I3Nt1VM3oS9C342/KzW3PKP+Tc0xyu330VyvHCs3P0e/FcrRhmgOE3fp
jYn4P4vm6sfwF9C7omfhYfSt6HvFeQVzsLjoJXBaak4S92kG1PviwGnqHdbU
E9+h9wR9WzQX7AKb8PVgW1vwmzAd+b3ot7ATZKpv9Kw+Kr5F75971sU5uotm
RLOhO62N5lBxpzhvJvLNuXMjjtgRfQedLQ7fEp1z5VpvVh3yjbnvKs7oZO+W
3LOlmX8/OifKhd6UL6JrqlpqxvoKnnHN9j5s2zNziLhDb4Bmcwi2xuAZHZ35
DdPb1Y3to+hv1rfqDVLskOi3Q2sqMp+hvdUTmn1xuLhbHKBcbszMncppd3RN
VUv9M+TRM6NZ0T/CK3obM/eWenCp5pl1ExP30ED0QdFcoxl8MfpN1Fuomovr
X45+i8T5/wNR8Bg1
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.560920967184627, 0.439079032815373, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuUllUVxt/ve9/vvGiulWCKrNSVFZouuclMFy5LZoYZATPuBDLDbVUr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsV0UUxd/r65tRQKCtWFREcMElQWyxqICBElFxiQFS0ooG0yhKkUKN
SwApGoyt2A9qXbAtCorGBSXue8RqImoAoxRtAxqXoMatgopgQX8nxw8n/3Pe
vTP/mXnn3nkjaxfOqC9IkqQFFIJjY5KMBHdlSTI+TZJJ8KvyJHkK/SQ4E90I
euFrwGnw00EbvJL8QeQWom9Et6Ob4WeDtej9mceWgfbMcwwm/1D0YngH+fPh
dZoT3svCHiReAabCO3n2ZUiSr0AV+fWstx+5h4BTU8+xgdhzoILYaHQDYzcS
n8LmishZQ2w1yOEnEH+a2DNgPfM3MOZO+BOMOUCsD4xDnxW91wsY8y1jvwM1
6IXkLyZ3m/bL/JXoPehS0Aq/nDkHwv8lv4H8NsaPQI8lvwP9HrpLZ82zteQv
YY7t6HvRG9DL0J3ovv/nPp/fy9DV4DbGfqAz5VkP+RP5r7HkTCZWGf2uDqKv
gZcTn0x8O8+Ww2fzbFKB5xgDvxnsyvwOL4Y/Enw2L2fe25LcZ6c9am+beDar
0HucCy8Cy8ntAtfBh4Lb4T1gpfYXfZbTmKMWXsz8t/D/W3k2D30tGEPs8dRr
OQ60ZF7TTv5vGbg08Zp/YOyP4Apii3T+5K7K7Y05xPexrl70LHh96rPcmzum
M/2NsXvAXMafmNobOkOdnTxyGLn7iS8g/pDWBF8HRhEfxbMF5B8DmuE7wARi
nYzpLrCHJqL75faSdArfrTOHNzNff3gvOVcz9gH0APSf6HnoVegS9A3B3m9i
jr3Ba9Ja6jJ7fYDeSWbPb4bfQ3yczpb115A/J/dZbwGtuT0lLynnPuL3B8em
pF57EXppgffQCX8X1PLf52SuPXlWXlUNrsi9R+2tC/wM/yn4XVxJ/lvBe9Ze
J+gM0W1guNZOzj74AVCPPomcj+EfBZ/XVJ69CZ/B+KHE7gAz0efl9nIVugPd
DkoTz/k6/DUwE12Bfgn+IjgXXYbuhveA6Xp3PBvCWZSCFeiy1LVRDNalrpH+
8jN6deozfpSxjwW/e/3nEdGel9c1R19wjau2tafdwe9U71IeC9E9Tr3tJvRR
6GGgSWfLszS6Z6pXXq9+GOwReUPv5G704eTcmrlGnke/ELw39bhuchfl9rp6
wKDoGlNtNYKS6B6g2tccqg3VuGpbNbKVuT4B09DzmW8bvAtcolpO7N2a6F4j
D58Bbw32jnrYFvhmUJd4ju/hu4J7o2q0mPyBYHTqHvEXsT90nqk9XxLsKXlJ
PeH34BpVbapGcsZm4JTUd0oCP0j85NQ99Z9gT8lLqtkmrTd379U7vRD+cLB3
1PPfgW8M9rY8o162kpzy1D1tOrwq2Hul4A3428Felid/gf8a7HV5dkR0T1Av
0J15dHQPVO/TO35fvTr3XBcVeu9/B9eyzmB89B2ju0V35CvEXg32sjxczdjq
4N6oO3ET/MPgWlGN7oTvCPa27sSW3HeK7hLtSb2zEQxJ3UN1ljHaizpTnWVB
tPd0pp+hPw32gjyQ5N6D1j4beXz0N4K+DdSjj4yuKdWSev4XjP082DuqueHR
npfX1TPlhcHR3pQnyqO/IfTtoG+Cbxj7dfDdrjt2WO4ep96mO3Jp7jtRd6H2
tJ7cZ4PvevXo/wA5YA46
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.682762901553882, 0.317237098446118, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2mIllUUx593ed4HGyFTQwOD1KxEInMhc5lxgUCbCdxixohABTdcya0o
lT5I6rjkFqhpzjhuuOQyQuVC5EwZRpDlLkEftC/RaJmGRf+f5y9+uHPPc99z
zz3L/yzTefzMUTPySZIMyCVJQfu3+mgnukp0eTFJOuvwadFntTqI/l77sjRJ
vsmSZJ/4ntBZx0L8PqcY9AnR5ySnk+gm7S+Jb7vOPtN6PAmZ7b13sfw1knlW
MhvFe0lrRC7eGqf7i0UPFl0l+ZVavfXd1XeRt7cQ39Cz9fsB/d5Ha7PoTVqP
6bePJP9nyT+m8/Zap3VWIf6r2mu16kSv1r6qEHoeLyXJ51ovF2L1L4RPRkrG
bp33FN3Pv933lfRcKLlttI4X4rdynX+sdxfqzm/6Xqt7fbLwUU7nX+r7NfGc
lo4Dde+g6JZC+Pmk6FHi+aIUb+/RXqvVWvRzkvGO1inxNOjujmK8WSX+mVqP
5kIvdEA+vHfT4J8p+o7oQ6IXaL+sNd/+aDJ/mb57ae+qtUVvbiuFr4lncz5i
elh0vd49hG+ME/gHin7Evi3T3krrRdHL9c5Pent/LvCFb/DbaesJPzE7qFUv
+qje+DEfuGqve6ulQ9tCYOy6fXQerGrfYGxet9/eFm87vdcgWcPygSl8WyM5
N9OwkbM3jU3iBs4GO6b344nfxHtOdxbo9yWivxa9NBd+Qm9wNFxnr2bhj7/T
wBkYu1GImBPXKdLnd52P0hsj9f1vEvhvLgYfPBuKgR10WKS9xnnYonuvZ/G9
yL6rFE9TMe4PdKy4i5/P5EPHStty3L4lJsSmp++COXz1n84bdediLvK9ohjx
v6d3d6UPc/Gy1hXxn7DMcmOPb/BG/LkPBm6KvuVasU0yFmfx3SD6wyzeuiB6
fBr+GJsFFsEh+NrrXEYXZFIfjuQDH+ttC/7CV8Qz55i2sR/xA3jvZsxj9yDb
PkX7sFzYXlcM7KIz2GmyT55PI8/hxwbsB4fk3kbjmxiO1nnJPjlpP8zT3TFZ
fE8UXSF6jM77it6YRm3E903Fh3HfaJ2pPfwGVsmTIfmom9hNHVvv3JzpmJP3
2FbhWoot4KqX3pmkd9clkaNgs5iLOkj95LxGPEvTqKUszqmB5Osh5/JkyZii
db4Q60IhdDhsni5J1JLOridtzQcPb6EzuTxVMqYRd+cse4PfrLI+f0jGXcf6
H+2nsrCT2kyNRn5H5z+5PjQftQLfbFUQKrO4O0/03FL8hu+wrc51/prl9Bbv
U44FvLVp8BPfGY7Fdb8FT79c3K8zDukxvIu9m91f6DmcU4v+LEQOgLMW0+AI
f2x2HAc5dmDmLb1fU4p6t8A9hPju1NntYviZc3oMv/0l/ifT8G21bBmXRU2i
noEbalpH10hwi619bS+6tFi3asmv1vkPujdc+4Q0cHKnGDkA/mdpv5gG7sBS
nWv+Sq017pU99Pu0NPQEC89k4Wf4plv/93X+Xhq9vIN1wCcL8g9r2zHXa/D/
i3hnZ+H7B34kN5fo7NM0fEwuT3U+k2PMHOTjev1ZV4rZZKt4f02DZ5+xvt05
uMoyu0lm9yz6/ybHFt/W2j74qYPD81ELGu1j9LxmfKInOdfOebfK+iGfGPaw
f8rsE/JsQjHugSvoif7Gb3WuS+RAdT7wMNA+4t1K4467HST7Vhr2oeNl12zq
Iz2K+kB+kGPkCHi/bczj+/nuK5fSyD3eRJcJzl9qNL2LmjciC6yAk/7GQ9G9
A4x0td9W2nefKA4j0pjPptjnp+yf1aZnSOasLHy5xufcbRF/9zRqWj/3XOo8
NWRLMXIRXxAL+Hmz1jnOHfSlj6DnANfGN/TOIuZX8e0pBGbG+D46Ia/ONhB3
7B7tnk1+b3GOg+WrxjMYxDZs6U0fK0V9oobNTsOfK3S2qxTxH+C+g9+Yozs4
dsy/ndLA11ei301jNmH26uyeyAySpNHjiRnzeqV7Wb1ltvFMQ/zRF3+hM32m
tecxZjh6LTJfkbzRpfgGm2Wu7fTnSaWIP7PzWs82rdwfwOR3+dChyn12h2va
cvEvy2K+WKF9p2cJegj1hhq42LM4et4rhs0LncdNzmVmjR3ucei/wf2XWXJF
GvVuLDqmD3U5Y580GbPIoe62dW/Cpsm2i/luYRr1lT7e4Fl6hv2Ar9D3iHVm
VmI2vWLc7Xc9Id+Oel4dIpmDs8AX/p9trD6Yw7D3Bb05N4056oZnV+ozMSUf
y91DJ7gv01+GegZal0Z9pFbMT2N+mu95YZ/1aZvGHEAtOuq6hc7MdMTjkjHd
ZAwwkzXarg/y8dYB5/1u5wD+Qydkzskib69ZR87rPZM0GAPUogOuR8/Sn7PI
0Wr3uV62vdkzfbPnImhwiq/oQeQq/Q2stPMMwfww3b3owf8Y7Mj8H4nRyc4=

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsjXEUxb/3vf7ftyiR0AVSC9S0IqmIea4EMbUlHQgxJFVJi6AtiSEW
pYYQFTaURFBiiDExb8whhKRa08KGjYTWFILfyVmcvHO+8x/uu/97b+/F1YVV
cRRFi0AWWBKi6GYSRaMQWako6od+jq5E38EvQ/8AV/FGgwPwWvyP6Si6hX8b
vpJv2Xjj2DMOPQGcwi/mW0UmipaDQi6dg+7F2qf4S1l7jP0H8Kbw7T5+Lnve
wMvxH8BzUo7tC2tzIsd4F92VNY3oGegT8GFgKvvbWL8J/wi6nf1fQS68AyzA
v4Kfh1+O3ou3G+yEvwMT8M/ilxJPHvoJ57/g2yT0fNACvwT24b0Hk2Ln5Bbn
/SSOIawfw+94dAH+y9g5WAY/zP6+8NPgO/pb8H8/z/4CvMngsuID7XilIB/v
DCjK+AztVY7q4EPAWHgt/nX8f9w7g/NGsmY6909L/JYX0XvwK9At8K5pv22T
4k/5jd8G51y53gxewwfrfM6rSfm/7g3Onf6zcj0AnIud81nwjcF7y2LH9odz
61KOUbltCP4vyvFM+Prg2Eti19JB9Ke0a+oz/Cv7m2PXzKrgPVpbnXKuFga/
jXJWxP516NuqR9Uc/mz0I7yH4JpqLzg3I8CG4JgVq2Jczv5t6Fdp52gX61/w
rYoYOqH7wwckrpUL5GSQ1gbXsmqyDK8UzITfS/usEs54FvvMG/CbGd+tNdPw
D6H7pF0TR+BNqrnI307CT8hHZ6Mb4ftAd3gP0Mr+tuBcqOdU2zuCa1c1rtrd
n/Fa1XBPeD7fJuJtBSvUK4lrQ3esgq8G79DDOWMFfA17jsNb+bYdvQP81d18
qw6uedV6F/RvvXdw7z3lvLXBb6K3UA3VB/eselU1/SvLM0OzQv/5A/4WdEfa
NbkSXp0414qpM7F8UU+oVsDmxHfqLvV4M/6pjN9KPTgUPz/xbFLOBsEHJp5l
e9Dd4DmJe0EzRLOgX2JPM0FvvzPj3KsGNuk9E7+tZtI8eE1wbyimusQzUrNR
NdyQuKfVy8qZenMu+nHsHtUsqUycW82UGvS6jGeB3kizQzNRs1AzpCR4Bmn2
qKY0OxuD30oz9GjwzNOsUw7nBPeAal93qhe2gPqUe6JYbxH8duqZ/7USx7Y=

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.804604835923137, 0.195395164076863, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVktsVVUUPe+ee99FEhnozMTEl4j8EjswMaK+10kVtJiYSnRgQqBVI1Io
mviYaBTwm8ikdaIOtPWDONAYGbQ1r+0TMHVia5yYkLZQhFoKNYVYSaDiWqz1
UgYnZ9999tnn7LXX3ueW2rva9iQhhBmMiFFIQ+iAorUQQj/kq9BhCr/nIRwq
hrAS+iZ8r8J8L+aOgnQlyKth82wWQhnf38LZLZjvgv4ryA/A5zXI7dA9CDli
/hX2d8K+375W2HcfDuxN5aMTuocS+eqL2ndbkA+eHb2+uyCbaLvbYXMWPs6l
OretoG/KA9YzvpZE5/8A/RC+/8KoYWxmHLhfYhy4lz7rmEdSnfF51Mz7DKby
ezqRDdeIHePm2TyXui+sb/dd6XMtzlmH0YO1EwXNZcczmwhD3mvGd6PuvPWc
5yx/H/VNHLuQq71FrW3HGICugnEG8jQGwrvhnxiXjD39Ev/XcZdPYDCPtSr0
5UT5HoK+KxPWv0FeDXkM8gbY/ehcfQbdG1gbh/wR5GmMnyE/Dl0rxtEoQv2C
cR3yDqw/nAsX3otcIVbkH32MQW4pCJc6443LOG1KdD5tuPe049qa6BxizLxM
m3tHsHiIOYVuCrrJRPmdcd63QJ7wN+VrsL+aqR7eB5bvYWTwe9xY8j7M/4i5
cT9sD2NMQL4A/RxGc0HYk2fkGG3rrqs61n9iroNivRFPEDcH0mXO1M23gzj/
AMb1RP4vcj9sjkX5WmWujtg/eb3xJm4PO64Y9T1mfc0yMRiyzQHg9CdieQTy
mkyxMS7mbBQ2k0FzzXIahSv38h4jUTXNddq1Wld3vOTQM+bbfpx1JlP85Nox
x/Iu9G9h/GvO8OwJY9hvzC9hns+Ud3Iq+KwF+LmE8SVUj+aqZ+aafGkxZ2qu
qUn3B/KGPjfD/qVM9fQx5tdyYT1q3rYaV55xNOjMgvUno85t4M6ZNqeiOEAu
sEfenavGn4C8NRcW5HTZvNoH/dO5+EH+Drq3DDj21H1s0Dypghf7MC477suO
vbGH9sRxMSqn30XVPvsG+xBrgX2s6vwxLxVzl3HQ54Lj2oO7/Y2xyzms3mQ/
Z042W+ZeYsy6Is7bEmFEP+xLU1FnrIe/nZnu82mm/sJc7UdMByH/B9suzHtz
7WEcLcaK51zwufOWeX4T/JzMxKkFzLcWxb1zkCtF3ekbzEeK6mGPwfeuTH2D
sa3wu3QY619jrI966zr93l2E7Ubon3Sv3m0c2Av5JtHuw0zvHGvxSqoeSju+
XQ1/HxT1vlJeg/kejG6s3Ye9dxSVx273HfKDsXenyuMO84ZYHDemFee3z28o
31LK5D97B7EkVlX4fypX/v6BvJgpP+x5b+bqe/S1lAhn7lvy3p5U37wDa3rE
NTvmO/E+w+4n7De05Z4lz92Wo7EouX5HXed8M5pdO8xvxTxkjbb73dzgN2el
+dvrGKO5MR50Bs/i/Tn3GDfmY1uyXJ/N9v8K4n45V702sOPd1gKT7ZlqhPGd
9xvUB93bsL/CusK8KRf2rDXqeIdFf1NeYM/M1W+IL/s++0YFuueKepdq7iWN
t+Bs41/FuR93LJQZF9/b3ky+Jo1pyf8/bcaK+ee9EttMud55l45MdoyVa9xb
Np/qxpD4M+/cd8p7+a8x6/+Nnbj7i0X9X/wBf+sy/fs8D90LRe3pdJ3QP98n
1k3qt2PYPOH7mjrGWf/3NdkmWk9bfm8x76knVuTyq5n4zLfrnVy5/h+Nbn5d

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllE1IlFEUhu/9vrnzRcv2QUKWJtGiTWRTG82sCUqsdqEz/Zk0Y4Fj9AOp
lQXOplrVov/UNhG0KFpl0baWgYiTkgtLwyKz/57Du3jhPfc937nnnp+vKlds
KUTOuSxIgXxwrhm0ctjinSvDu9POfcEei507nTh3nbNZ+CcwgDaCHfFxCns3
+lrsevyfY+/AbgY5Yj3Broe3o9+D3wXHsSvYDfhXsE/C93D2Av4SbII3cPbL
6Zvl8G9gP/5PidmEvhVE8Eexci2Br5FyPgI/DCbhU+ACvn/4/i3xFvEvoBXB
R7QZcB79TpD2HVQZB21or7ijA96Y6K4VxDgFrwFXsWfAT/R+4v3DfxR9IaiG
VjvLuRNeBzZGqsnRoBzs7sf4DBJrmDOfUkMs18voIVbOGfTNYCLSm6vRf4B2
7DfYtWjVIOOVUxe8AJ5hT8Sq5SzY5VXTBe4YIv4atDxn5/C9ZfWB54l5G97L
WVOkswP4HgSVSDmU0T7gk/WagaGgN1ju405v+R0Uy95kvchhP4jVk0tpzZDN
jr1xJK0ZstmpA8PYg2CpV45jQTNis5Hh+yJ8J9gHP4bPqkQ9s15diTVLPdij
sWaqj1i94G+kHq1EX53I12rWCi/hX/KK2WW1Ceq1zUgZ+2FauVlOtWjzKe3K
BvT32GeJMYe+xavXVmOrrfX8EN/WcLbMqYZZ+LZEvV/iVZt3QbGsRnvR5rEz
Tm+4EbSDtnt2h+3OtaBdsB3qR+sDjV5v7OG+9ej3nXZiMihHy+01mILfDJod
6/FFvh1INPsWw3Z5MaXa2k7bv2F7ol22f8SZRDNvs27/BJu1E4l22Wbuc9Ab
7W2dXrNqO2O7YjM7h92R1m4Gp10rJppV27lu7HVBvbae2KxNg3GvmWsL+qfY
v8Rq+h+AHqZM
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.926446770292392, 0.0735532297076077, 1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVT1MVEEQ3rfHe6/jsPUhf8VBgASukRBFE6Mn8cATDP0dookWYK8WgspB
tDUIBcSg0Y4GqAxGMdR3NQKSaGiMlYUkJn4f811MbvJmd2dmZ775Zq91fGp0
0jvnliApyPXAuWPpXTjohhxC3wtsfQr6XJ1z7dCPoDd726fNOvYboSeQXdgP
Q/ax/wrrPKQB8iN07jvkGvRc7NxVyBoum4fvtre4jMkceNdZ6GlIFXoZNr1a
7wcWj/du4bsMaYJMRs7dQ/wSzm96i10MLK8zkAPYr+KbhXSoPubP+hi7B1Kv
+N3a/4l4lyEjWL9JWdxCYHa0rwifgDk52+sVPsSkR3q/t7xolxUevIdYTXjD
i7nSjjbLypm5r0BaIS3eekN82Lc+5cJ1J3K8H5l/B/Q7kZ2nlU+9as7q3hJs
zsXW8xnYHmM9rrubndVCP+J+JPznpGe0z9jEg3mzX/Qtyf8v4j2NrbYc9j47
6yPXVfEjJxyJIdeJerRRZ/1k7cPI7SJifYJ+A3ohMq7k8R0Irf8t4g35wDPy
KaP+JIqfKN6BODwvHicA9Iu4lxZOzHMqMj6xngVv8dLiZkH13sb5RGRr8oNY
sj9j0Ke84TAXGRas+wLwGIiNR/uqmfm8x/lsZFxIxAXmnIP+3Bt23eoba+yo
zQD0RW8zRj5tqx7WMuTtrMazPdkH0mvztaC6iElZuL2VP7nCXqyr75zjr5A2
zdwHcXQaNc1AfuPuWXyfQf6kbM539Q6Mo75bkfkXNQfMoRIY78gF4tcnjC8B
k5ewP52yHDbFiTVvcRmTc3k+NuzfefsS/z7sH4VWA3u7q/eBWOTFk6xqbNDd
O+LoIvwexLbm3f3ChD2pqi9tmkny7gps74ZWE/2WQvN9je+T2HwGvWHDWh9h
71toveV+RTELerOISZPwbVTuW8qfd37UW/AY2ExH5t+v95N5kkdlcald9dN3
VX1l3YPIYSg0no7AdjT6PwOb6jXfhmJoPeGb/SI23NmrHc0u34yHse2x34Oa
bXKK2GUUr105dGlOWWO9cK/qndzQ/wdnlutEPKA9fifzvyLuMfdfyp/zOaZZ
21Qc5j+v9yqjPrUqTl4xDsW9nPA/qUmzVutZRfe3yLdNOn27gFlnZLPHfh6q
p/8AcxbPgA==
         "],
         VertexColors->None], 
        PolygonBox[{{1492, 1579, 665, 666}, {1853, 1352, 595, 933}, {1852, 
         1377, 334, 593}, {1593, 1517, 593, 680}, {1686, 1614, 1081, 794}, {
         1589, 1591, 678, 676}, {1598, 1510, 586, 688}, {1586, 1340, 701, 
         671}, {1591, 1335, 588, 678}, {1916, 1434, 455, 610}, {1615, 1347, 
         795, 708}, {1508, 1922, 1013, 584}, {1343, 1587, 672, 706}, {1666, 
         1667, 610, 465}, {1341, 1586, 671, 703}, {1587, 1342, 704, 672}, {
         1924, 1927, 1017, 466}, {1495, 1577, 664, 566}, {1672, 1673, 612, 
         476}, {1635, 1612, 546, 733}, {1577, 1346, 794, 664}, {1638, 1637, 
         335, 567}, {1925, 1442, 466, 612}, {1926, 1508, 584, 1017}, {1435, 
         1917, 582, 455}, {1614, 1616, 708, 1081}, {1519, 1390, 623, 597}, {
         1610, 1611, 703, 732}, {1636, 1854, 933, 335}, {1512, 1492, 666, 
         588}, {1506, 1433, 652, 582}, {1578, 1511, 587, 665}, {1385, 1322, 
         569, 352}, {1386, 1864, 597, 353}, {1511, 1634, 733, 587}, {1648, 
         1647, 353, 569}, {1618, 1610, 732, 709}, {1612, 1613, 706, 546}, {
         1347, 1617, 709, 795}, {1352, 1862, 944, 595}, {1933, 1449, 476, 
         586}, {1863, 1861, 352, 944}, {1376, 1320, 567, 334}, {1923, 1665, 
         465, 1013}},
         VertexColors->None]}]}, 
     {RGBColor[1., 0., 1], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1492, 1512, 529}, {1616, 1614, 707}, {246, 238, 1}, {249,
          702, 241}, {1614, 1686, 707}, {705, 246, 234}, {1586, 1341, 233}, {
         1612, 1635, 705}, {249, 241, 225}, {1613, 1612, 705}, {242, 529, 
         227}, {238, 242, 1}, {707, 245, 241}, {529, 242, 238}, {1634, 1511, 
         238}, {702, 249, 233}, {1579, 1492, 529}, {1591, 1589, 227}, {246, 
         705, 238}, {1587, 1343, 234}, {245, 707, 237}, {1346, 1577, 237}, {
         1611, 1610, 702}, {1347, 1615, 241}, {1610, 1618, 702}, {1617, 1347, 
         241}, {1335, 1591, 227}, {1340, 1586, 233}, {241, 245, 225}, {1511, 
         1578, 238}, {1577, 1495, 237}, {1342, 1587, 234}},
         VertexColors->None], 
        PolygonBox[{{1635, 1634, 238, 705}, {1578, 1579, 529, 238}, {1615, 
         1616, 707, 241}, {1512, 1335, 227, 529}, {1686, 1346, 237, 707}, {
         1618, 1617, 241, 702}, {1341, 1611, 702, 233}, {1343, 1613, 705, 
         234}},
         VertexColors->None]}]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1340, 1586, 1341, 1611, 1610, 1618, 1617, 1347, 1615, 1616, 
        1614, 1686, 1346, 1577, 1495}],
       "0.8`"], 
      TooltipBox[
       LineBox[{1342, 1587, 1343, 1613, 1612, 1635, 1634, 1511, 1578, 1579, 
        1492, 1512, 1335, 1591, 1589}],
       "0.8`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1390, 1519, 1356, 1864, 1386, 1646, 1647, 1648, 1322, 1385, 
        1861, 1863, 1862, 1352, 1853, 1854, 1636, 1637, 1638, 1320, 1376, 
        1851, 1377, 1852, 1348, 1517, 1593}],
       "0.6`"], 
      TooltipBox[
       LineBox[{1433, 1506, 1505, 1917, 1435, 1915, 1434, 1916, 1530, 1667, 
        1666, 1665, 1923, 1922, 1508, 1926, 1927, 1924, 1442, 1925, 1533, 
        1673, 1672, 1671, 1449, 1933, 1509, 1510, 1598}],
       "0.6`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1266, 1518, 1641, 1640, 1639, 1378, 1496, 1321, 1265, 1981, 
        1379, 1353, 1866, 1867, 1865, 1387, 1323, 1270, 1703, 1704, 1676, 
        2003, 1677, 1706, 1705, 1873, 1325, 1272, 1982, 1391, 1357, 1876, 
        1398, 1875, 1397, 1327, 1499, 1400, 1877, 1399, 1878, 1521, 1549}],
       "0.4`"], 
      TooltipBox[
       LineBox[{1319, 1334, 1447, 1932, 1448, 1532, 1531, 1920, 1440, 1919, 
        1441, 1921, 1507, 1439, 2001, 1317, 1529, 1914, 1832, 1833, 1829, 
        1371, 1828, 1831, 1830, 1313, 1528, 1903, 1904, 1902, 1906, 1905, 
        1504, 1428, 1998, 1309, 1525, 1526, 1421, 1653, 1654, 1655, 1331, 
        1562}],
       "0.4`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1280, 1988, 1409, 1360, 1620, 1361, 1621, 1279, 1723, 1362, 
        1722, 1725, 1724, 1281, 1522, 1881, 1882, 1880, 1407, 1883, 1500, 
        1501, 1405, 1406, 1359, 1403, 1986, 1276, 1328, 1401, 2004, 1402, 
        1358, 1393, 1984, 1274, 1498, 1497, 1392, 1983, 1273, 1520, 1868, 
        1695, 1696, 1693, 1354, 1694, 1381, 1619, 1350, 1687, 1349, 1856, 
        1857, 1855, 1380}],
       "0.2`"], 
      TooltipBox[
       LineBox[{1299, 1652, 1899, 1898, 1628, 1603, 1368, 1624, 1416, 1897, 
        1896, 1680, 1812, 1811, 1895, 1330, 1298, 1989, 1415, 1369, 1523, 
        1303, 1992, 1418, 1502, 1420, 2005, 1419, 1524, 1308, 1997, 1425, 
        1503, 1427, 2006, 1426, 1527, 1370, 1913, 1432, 1912, 1431, 1333, 
        1312, 1843, 1844, 1683, 1684, 1685, 1316, 1625, 1375, 1604, 1605, 
        1930, 1931, 1929, 1446}],
       "0.2`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1267, 1689, 1690, 1688, 1692, 1691, 1858, 1698, 1699, 1697, 
        1701, 1700, 1869, 1708, 1709, 1707, 1711, 1710, 1874, 1713, 1714, 
        1712, 1716, 1715, 1879, 1718, 1719, 1717, 1721, 1720, 1884, 1727, 
        1728, 1726, 1730, 1729, 1885, 1736, 1737, 1735, 1739, 1738, 1962, 
        1963, 1595, 1474, 1553, 1552, 1291, 1776, 1777, 1775, 1779, 1778, 
        1292, 1781, 1782, 1780, 1784, 1783, 1293, 1786, 1787, 1785, 1789, 
        1788, 1294, 1791, 1792, 1790, 1794, 1793, 1295, 1796, 1797, 1795, 
        1799, 1798, 1296, 1801, 1802, 1800, 1804, 1803, 1297}],
       "0"], 
      TooltipBox[
       LineBox[{1889, 1741, 1742, 1740, 1744, 1743, 1284, 1746, 1747, 1745, 
        1749, 1748, 1285, 1751, 1752, 1750, 1754, 1753, 1286, 1756, 1757, 
        1755, 1759, 1758, 1287, 1761, 1762, 1760, 1764, 1763, 1288, 1766, 
        1767, 1765, 1769, 1768, 1289, 1771, 1772, 1770, 1774, 1773, 1290, 
        1596, 1411, 1555, 1554, 1890, 1807, 1808, 1806, 1810, 1809, 1894, 
        1814, 1815, 1813, 1817, 1816, 1900, 1819, 1820, 1818, 1822, 1821, 
        1901, 1824, 1825, 1823, 1827, 1826, 1911, 1839, 1840, 1838, 1842, 
        1841, 1918, 1847, 1848, 1846, 1850, 1849, 1928}],
       "0"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1268, 1642, 1860, 1859, 1351, 1599, 1600, 1601, 1269, 1702, 
        1355, 1674, 1675, 1324, 1271, 1539, 1275, 1985, 1460, 1394, 1543, 
        1461, 2007, 1462, 1395, 1465, 2010, 1464, 1545, 1466, 2008, 1467, 
        1404, 1472, 2011, 1471, 1550, 1408, 1473, 1987, 1277, 1551, 1282, 
        1732, 1733, 1731, 1363, 1734, 1283, 1623, 1364, 1622, 1365, 1887, 
        1888, 1886, 1410}],
       RowBox[{"-", "0.2`"}]], 
      TooltipBox[
       LineBox[{1318, 2002, 1445, 1374, 1845, 1373, 2009, 1629, 1438, 1837, 
        1372, 1834, 1836, 1835, 1910, 1568, 1971, 1972, 1970, 1486, 1973, 
        1424, 1564, 1307, 1996, 1484, 1423, 1483, 1995, 1306, 1561, 1302, 
        1991, 1480, 1417, 1479, 1990, 1301, 1557, 1414, 1967, 1476, 1966, 
        1475, 1556, 1965, 1329, 1964, 1679, 1367, 1805, 1412, 1627, 1626, 
        1602, 1366, 1892, 1893, 1891, 1413}],
       RowBox[{"-", "0.2`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1278, 1548, 1651, 1650, 1649, 1470, 1547, 1546, 1960, 1468, 
        1959, 1469, 1961, 1396, 1957, 1958, 1956, 1463, 1544, 1955, 1326, 
        1954, 1678, 1388, 1870, 1872, 1871, 1947, 1540, 1943, 1944, 1942, 
        1946, 1945, 1382, 1935, 1452, 1934, 1451, 1535, 1536, 1450, 1643, 
        1644, 1645, 1534, 1575}],
       RowBox[{"-", "0.4`"}]], 
      TooltipBox[
       LineBox[{1300, 1558, 1477, 1968, 1478, 1560, 1559, 1304, 1993, 1481, 
        1422, 1482, 1994, 1305, 1563, 1310, 1908, 1909, 1907, 1430, 1681, 
        1682, 1332, 1311, 1567, 1314, 1999, 1487, 1437, 1488, 2000, 1315, 
        1570, 1571, 1491, 1979, 1490, 1980, 1573, 1574}],
       RowBox[{"-", "0.4`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1444, 1572, 1443, 1978, 1489, 1668, 1669, 1670, 1569, 1664, 
        1663, 1662, 1977, 1976, 1436, 1974, 1975, 1659, 1660, 1661, 1566, 
        1658, 1657, 1656, 1485, 1969, 1429, 1565, 1597}],
       RowBox[{"-", "0.6`"}]], 
      TooltipBox[
       LineBox[{1453, 1537, 1383, 1938, 1455, 1936, 1454, 1937, 1538, 1456, 
        1939, 1941, 1940, 1384, 1950, 1951, 1948, 1457, 1949, 1541, 1458, 
        1952, 1459, 1953, 1389, 1542, 1594}],
       RowBox[{"-", "0.6`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1336, 1582, 1337, 1607, 1606, 1631, 1630, 1513, 1580, 1581, 
        1493, 1515, 1344, 1592, 1590}],
       RowBox[{"-", "0.8`"}]], 
      TooltipBox[
       LineBox[{1338, 1585, 1339, 1609, 1608, 1633, 1632, 1514, 1583, 1584, 
        1494, 1516, 1345, 1588, 1576}],
       RowBox[{"-", "0.8`"}]]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55310132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "CoolColor"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->65487683],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx11zGKFFEQgOHFmwh7j4lNPYJg5uo9DEREDDxFB7IaNAx4BBOFFQQDE3HZ
1Ex3mq/h/Y9ZWIp/pnte//PqVdU8fPLi8dMHFxcXf///38ft7+4ofr++urm+
+r3zp3u8+bXz28tHby4f/dz5x+n6m53fnd7/svP7E38+jussK365vX/Ar7b7
d/66ff7Or7f1d/6wPd/O37bnP4zr3ZV3z0a+mC/mi/livuP3uKyYL+aL+WK+
mC/mm30rT164kS/mi/livmOeLCvmi/livpgv5ov5Ji/L077VCzfyxXwx3/Ec
LCvmi/livpgv5ov55tyVp7zsvtULN/LFfMdzvqyYL+aL+WK+mC/mm7pSns5d
87L7Vi/cyHesY8uK+WK+mC/mi/livqmb5amu9Nw1L7tv9cKNfDFfzBfzxXwx
X8w3faE81c3WlZ675mX3rV64cexHyzr2o2Ud+9Gyjv1oWcd+tKxjP9r7Xnnq
C62brSs9d83L7lu9cCNfzBfzxXwx3/T18tT32hdaN1tXeu6al923euFGvpgv
5ov5Zm4pT329fa99oXWzdaXnrnnZfasXbuSL+WK+mcvK09zSvt6+177Qutm6
0nPXvOy+1Qs38sV8M3eWp7msc0v7evte+0LrZutKz13zsvtWL9zIN3N1eZo7
O5d1bmlfb99rX2jdbF3puWtedt/qhRv5nvsd0Tm7c2jntM4x7fPtg+0TraOt
Mz2HzdPuYz0bn99ffv3nKPLHz7Z4yPvTfa5zPz4X+zm9r8/R53bdx5Pv7VHc
vp7bs683WqfX9fWu33WaN339zLqHf60vYeA=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJy1mH9M1HUYx09rqBk1WoVMUFExoIgjGcvMfaygDkJqLKfgnQJFOcTR1FVq
c2S1nJ0tNRs4VtCiOeYfDYO4mwE1hMNhHCLOBOTg+NVlcEWp5IJ+7Hk+jKe9
+7bK73a73fs+n8/3eV7f5/N5nucbnlOQnjvTZDKN//65ycSXX5mmXX7V9Yj5
l45NI2p133Vr6cwKxfqcw0G2Ezsuq5oXtgfnZp7Uetn7B53FFp96tdxxV3F3
o9bz5tt3dg8Oqfuah25NesCtdWvK1lrfhgFl2RLxerSlQ+stttbSm6v61ObE
7NorRy5qfcaf3x41MfnH1aP1rTTuNM1jfQ2tm0n3YT2O7NhMdrG+l+wuJT9Y
d5Gfs8hv1tOISydxQhyNeCYFJjbdXXdZXTjScyp5llPrZvuJmF3f+9Tq1rjk
4JQGrb9kyl82/sOwipx46vn5D7Zo/cu84sdizg2qPdFnXilfd1brNvu8d5aX
9KvHh772FjWd1/rCwJG8A+l96quBJdEDmZ2GnJtoXCjNY/1JWjeT7qN5kh11
ZJfmT3bvID80B/IzlvxmvZ+4JBIn1lcSxy7BH8Un4pl19fayZcnfqsLF9btz
O09rPbL7k4h59iH1aVLlZ61DU3E7XtUc4HcOqNvey/9x4f5zWm9f2hv85kWv
yqxe5f455YLWZ1vD286P9ir/E1/Y0hd1GXIeo3EBNE8/R1r3LN2H9TvIjqtk
F+uVZPc95Afrb5GfG8lvI/5O4jhHxD/a7yg+Ec8419zh9SGD6oOC4di0M+2G
cfvweMJYXLBX7Qs8FFLS9o3W3W2OjO/svSrLak+NGjTmnEPjWmke62/Tug/R
fVhPJjusIs5LyW4z+WHE/34Q/7uJY5k4f9D5ifY7ik/Ec6nlZd8tO72qpiDo
Xl/gFM8FtM8bxPlQ3l/xbkdUr6pOqLj0zPFuQ841NO5jmsf6KVp3gThPnGTH
ErLLiH8Q+XlNxP9rxKVenD/MMU+c/ygfIW5ov6P4RDxR3MaHbgkobfSooqao
sbptl0R+8YhvvzpK45bTPNazaV23iHPEfz/ZvVLE/wZw/ljAc2GOVpF/UX5H
+Qidn4gbik/EM8zRnrb2WY9qPLA+Z+2KHkPOPI7nsV5M68YL/p+D+M8Cz4X9
nC3O/wbwvJhji6h/0H680Tri9n/pk9Pu9+91tnvGf9RR/YnqJZTfUT5C5yfa
7yg+Ec9QGucS8c/rHhX7he2oEfuL7c4R+5H9/EnsX+biEvudOeaL8wHV86j+
RPUSyu/oPETnJ9rvKN4QT8QtjOxoFHzYbrvIL23k50aRj5hLqshfGcQxTeQ7
2B+Beh7Vnyhfo/yO+KPzE3FG8Yl4LiY7Tor6B3G7Qn7eKeqrWuLyhqjHmKNZ
1G+o30T9EaonUf2J+KP8jvIR4oziFsUn4hlLdn8k6v8I8rNa9AvbiUu86C+Y
Y6HoR1D/jvod1B8h/qj+RPUSyu8ov6DzE+13FJ+Ip438tIv+N4a4pIp+mTm6
RH+N3oeg/h3xR/0RqudR/YnqJcQZ5SMUt2i/o/hEPB8lLn7x/oc5Pi3eF5mm
XVPvl9D7ENS/o34T9Ueonkf1J+KM8jvKR+j8RPsdxeff8/wr14nsvD1zXxxR
izwZIZbJY3qcwxm1rXPFqPIcczkPNhRpPZLG8TzW3TTOSfOMxntpvEOM/5XG
mf+hPUhH6yM70Tph168dP7RqVGWVeLIq1kzpz9Fv/t9ID6XfhWKdqr0JZbs+
HFX16Zsq14Xv03oz/eb/jXS0zo1e/zeDb+J/
    "]],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->611940933,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26350],

Cell[TextData[{
 "Use predefined color gradients from ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->475324135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", 
        RowBox[{"#", ",", "\"\<Image\>\""}], "]"}], "&"}], "/@", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}]}], ",", "3"}], 
    "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->598928926],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36799714]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26098],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshShading"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalsFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalsFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10373],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "Tutorials",
 CellID->5646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ColorFunction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ColorFunction"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->13045476],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->31944447],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->161035622],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->712932369],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->944776340],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->110393700]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 22.6506446}", "context" -> "System`", 
    "keywords" -> {
     "color lookup table", "color map", "color palette", "color spectrum", 
      "colormap", "color gradient", "texture", "surface texture", 
      "curve texture", "color field", "color space", "color model"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ColorFunction is an option for graphics functions which specifies a \
function to apply to determine colors of elements. ", 
    "synonyms" -> {"color function"}, "title" -> "ColorFunction", "type" -> 
    "Symbol", "uri" -> "ref/ColorFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24052, 727, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->73372314]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 253977, 4844}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2953, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3576, 93, 4197, 83, 70, "ObjectNameGrid"],
Cell[7776, 178, 500, 14, 70, "Usage",
 CellID->15563]
}, Open  ]],
Cell[CellGroupData[{
Cell[8313, 197, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8791, 214, 395, 13, 70, "Notes",
 CellID->26249],
Cell[9189, 229, 8079, 240, 70, "2ColumnTableMod",
 CellID->330594934],
Cell[17271, 471, 600, 20, 70, "Notes",
 CellID->2806],
Cell[17874, 493, 341, 12, 70, "Notes",
 CellID->3789],
Cell[18218, 507, 2271, 84, 70, "Notes",
 CellID->258055413],
Cell[20492, 593, 413, 13, 70, "Notes",
 CellID->578154793],
Cell[20908, 608, 750, 28, 70, "Notes",
 CellID->21697],
Cell[21661, 638, 584, 21, 70, "Notes",
 CellID->29670],
Cell[22248, 661, 587, 20, 70, "Notes",
 CellID->21289],
Cell[22838, 683, 378, 11, 70, "Notes",
 CellID->4160],
Cell[23219, 696, 796, 26, 70, "Notes",
 CellID->21893]
}, Closed]],
Cell[CellGroupData[{
Cell[24052, 727, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73372314],
Cell[CellGroupData[{
Cell[24436, 741, 147, 5, 70, "ExampleSection",
 CellID->37871401],
Cell[24586, 748, 70, 1, 70, "ExampleText",
 CellID->46597692],
Cell[CellGroupData[{
Cell[24681, 753, 523, 16, 28, "Input",
 CellID->200755922],
Cell[25207, 771, 22225, 368, 165, "Output",
 Evaluatable->False,
 CellID->180962066]
}, Open  ]],
Cell[47447, 1142, 124, 3, 70, "ExampleDelimiter",
 CellID->16574320],
Cell[47574, 1147, 68, 1, 70, "ExampleText",
 CellID->488835021],
Cell[CellGroupData[{
Cell[47667, 1152, 386, 12, 28, "Input",
 CellID->139506661],
Cell[48056, 1166, 24880, 412, 165, "Output",
 Evaluatable->False,
 CellID->65542976]
}, Open  ]],
Cell[CellGroupData[{
Cell[72973, 1583, 391, 12, 70, "Input",
 CellID->233034064],
Cell[73367, 1597, 75459, 1250, 200, 31189, 520, "CachedBoxData", "BoxData", \
"Output",
 CellID->1740825167]
}, Open  ]],
Cell[148841, 2850, 125, 3, 70, "ExampleDelimiter",
 CellID->793522862],
Cell[148969, 2855, 57, 1, 70, "ExampleText",
 CellID->865293764],
Cell[CellGroupData[{
Cell[149051, 2860, 535, 16, 47, "Input",
 CellID->731375041],
Cell[149589, 2878, 2254, 41, 126, "Output",
 Evaluatable->False,
 CellID->242431953]
}, Open  ]],
Cell[151858, 2922, 126, 3, 70, "ExampleDelimiter",
 CellID->1074194162],
Cell[151987, 2927, 57, 1, 70, "ExampleText",
 CellID->86260405],
Cell[CellGroupData[{
Cell[152069, 2932, 304, 10, 28, "Input",
 CellID->227165110],
Cell[152376, 2944, 1403, 27, 115, "Output",
 Evaluatable->False,
 CellID->171004087]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153828, 2977, 222, 7, 70, "ExampleSection",
 CellID->8589],
Cell[154053, 2986, 83, 1, 70, "ExampleText",
 CellID->589771134],
Cell[154139, 2989, 261, 8, 70, "Input",
 CellID->846535819],
Cell[CellGroupData[{
Cell[154425, 3001, 433, 14, 70, "Input",
 CellID->91096208],
Cell[154861, 3017, 49214, 850, 70, "Output",
 CellID->55310132]
}, Open  ]],
Cell[CellGroupData[{
Cell[204112, 3872, 433, 14, 70, "Input",
 CellID->65487683],
Cell[204548, 3888, 21330, 364, 193, 4844, 89, "CachedBoxData", "BoxData", \
"Output",
 CellID->611940933]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[225927, 4258, 233, 7, 70, "ExampleSection",
 CellID->26350],
Cell[226163, 4267, 221, 8, 70, "ExampleText",
 CellID->475324135],
Cell[CellGroupData[{
Cell[226409, 4279, 425, 13, 70, "Input",
 CellID->598928926],
Cell[226837, 4294, 21570, 358, 70, "Output",
 Evaluatable->False,
 CellID->36799714]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[248468, 4659, 311, 9, 70, "SeeAlsoSection",
 CellID->26098],
Cell[248782, 4670, 1472, 53, 70, "SeeAlso",
 CellID->7566]
}, Open  ]],
Cell[CellGroupData[{
Cell[250291, 4728, 314, 9, 70, "TutorialsSection",
 CellID->10373],
Cell[250608, 4739, 157, 3, 70, "Tutorials",
 CellID->5646]
}, Open  ]],
Cell[CellGroupData[{
Cell[250802, 4747, 305, 8, 70, "RelatedLinksSection"],
Cell[251110, 4757, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[251518, 4774, 318, 9, 70, "MoreAboutSection",
 CellID->13045476],
Cell[251839, 4785, 123, 3, 70, "MoreAbout",
 CellID->31944447],
Cell[251965, 4790, 163, 3, 70, "MoreAbout",
 CellID->161035622],
Cell[252131, 4795, 143, 3, 70, "MoreAbout",
 CellID->712932369],
Cell[252277, 4800, 143, 3, 70, "MoreAbout",
 CellID->944776340],
Cell[252423, 4805, 197, 4, 70, "MoreAbout",
 CellID->110393700]
}, Open  ]],
Cell[252635, 4812, 50, 0, 70, "History"],
Cell[252688, 4814, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

