(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51977,       1773]
NotebookOptionsPosition[     42819,       1459]
NotebookOutlinePosition[     44518,       1502]
CellTagsIndexPosition[     44432,       1497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorSetter" :> 
          Documentation`HelpLookup["paclet:ref/ColorSetter"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"], "Slider2D" :> 
          Documentation`HelpLookup["paclet:ref/Slider2D"], "LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ColorSetter\"\>", 2->"\<\"Slider\"\>", 
       3->"\<\"Slider2D\"\>", 4->"\<\"LocatorPane\"\>", 
       5->"\<\"Manipulate\"\>", 6->"\<\"Blend\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Control Objects\"\>", 3->"\<\"Creating Inspectors\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 
       5->"\<\"Palettes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ColorSlider", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSlider"], "[", 
       StyleBox["color", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a color slider currently set to the color \
corresponding to ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSlider"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["color", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the dynamically updated current value of ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"],
     " being reset if the color is modified."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSlider"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a color slider with an initial gray color."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a color slider that can be manipulated \
interactively."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will reset the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " when the slider is moved; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " will not. "
}], "Notes",
 CellID->12597],

Cell["The following options can be given:", "Notes",
 CellID->7213],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "elements to include in the color slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the color slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the color slider is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed color slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed color slider ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->18074],

Cell[TextData[{
 "A default color slider includes ",
 Cell[BoxData["\"\<Swatch\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Spectrum\>\""], "InlineFormula"],
 " elements. Elements to use can be specified in any order in a list given as \
the setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10639],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " can be used to find the color specified by ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26118],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<ColorSlider\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->631068756]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252442962],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->147669067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->668753501],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum"]], "Output",
 ImageSize->{164, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444900869]
}, Open  ]],

Cell["Dynamically set the variable to the selected color:", "ExampleText",
 CellID->104291952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19067990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8523924]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->628548144],

Cell[TextData[{
 "Copy and use ",
 StyleBox["Evaluate in Place", "MenuName"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ") to display as an actual color slider: "
}], "ExampleText",
 CellID->60505019],

Cell[BoxData[
 RowBox[{"Setting", "[", 
  RowBox[{"ColorSlider", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21974678],

Cell[TextData[{
 "Then use ",
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " to retrieve the RGB value of the color slider:"
}], "ExampleText",
 CellID->50895791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  ColorSetterBox[RGBColor[0.40320439459830626`, 0., 1.], "SwatchSpectrum"], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->700417950],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.40320439459830626`", ",", "0.`", ",", "1.`"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5334213]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36640604],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44048345],

Cell["Select which appearance element to include:", "ExampleText",
 CellID->477300927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Pink", ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Spectrum\>\"", ",", "\"\<Swatch\>\"", ",", 
       "\"\<SwatchSpectrum\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107600769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Spectrum"], ",", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"], ",", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum"]}], "}"}]], "Output",\

 ImageSize->{349, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->811926067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->357226893],

Cell["\<\
By default no colors change until you click in the slider area:\
\>", "ExampleText",
 CellID->136293569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119939086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88435671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->648940932],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the colors change as the mouse moves over the slider area:"
}], "ExampleText",
 CellID->772651214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469113643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum",
    AutoAction->True], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705341970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->475956363],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Pink", ",", 
     RowBox[{"ImageMargins", "\[Rule]", "10"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Gray", ",", "Black"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155850066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[RGBColor[0.31067368581673915`, 0., 0.833325703822385], 
    "SwatchSpectrum",
    Background->GrayLevel[0.5],
    ImageMargins->10], ",", 
   ColorSetterBox[RGBColor[0., 0.8749980926222629, 0.741496910048066], 
    "SwatchSpectrum",
    Background->GrayLevel[0],
    ImageMargins->10]}], "}"}]], "Output",
 ImageSize->{390, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600256170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311688381],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->375560463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"ImageMargins", "\[Rule]", "10"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Lighter", "[", 
      RowBox[{"x", ",", "0.7"}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179308],

Cell[BoxData[
 ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum",
  Background->Dynamic[
    Lighter[$CellContext`x, 0.7]],
  ImageMargins->10]], "Output",
 ImageSize->{184, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309647367]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->80198449],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->616992961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ColorSlider", "[", 
      RowBox[{"Pink", ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"100", ",", "30"}], "}"}]}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4709562],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
    BaselinePosition->Bottom,
    ImageSize->{100, 30}], "xxx", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
    BaselinePosition->Center,
    ImageSize->{100, 30}], "xxx", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
    BaselinePosition->Top,
    ImageSize->{100, 30}]}],
  Row[{
    ColorSlider[
     RGBColor[1, 0.5, 0.5], ImageSize -> {100, 30}, BaselinePosition -> 
     Bottom], 
    ColorSlider[
     RGBColor[1, 0.5, 0.5], ImageSize -> {100, 30}, BaselinePosition -> 
     Center], 
    ColorSlider[
     RGBColor[1, 0.5, 0.5], ImageSize -> {100, 30}, BaselinePosition -> Top]},
    "xxx"]]], "Output",
 ImageSize->{358, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300540186]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->46113474],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->466623908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357598064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305295291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42340894],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ContinuousAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuousAction"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " makes variable updates only when the color slider is released:"
}], "ExampleText",
 CellID->491290957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470641416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`y], "SwatchSpectrum",
    ContinuousAction->False], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414751443]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->54876488],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->301625236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum"]], "Output",
 ImageSize->{164, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->837898511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202367467],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the color slider is disabled but visible in its current state:"
}], "ExampleText",
 CellID->102141691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", 
  RowBox[{"Yellow", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 1, 0], "SwatchSpectrum",
  Enabled->False]], "Output",
 ImageSize->{164, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455734763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->337286027],

Cell["Add margins:", "ExampleText",
 CellID->117831909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"ColorSlider", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1626991498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    ColorSetterBox[RGBColor[0.7, 0.7, 0.7], "SwatchSpectrum",
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    ColorSetterBox[RGBColor[0.7, 0.7, 0.7], "SwatchSpectrum",
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    ColorSetterBox[RGBColor[0.7, 0.7, 0.7], "SwatchSpectrum",
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    ColorSetterBox[RGBColor[0.7, 0.7, 0.7], "SwatchSpectrum",
     ImageMargins->20],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{430, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->936829635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->484951554],

Cell["Change the overall size:", "ExampleText",
 CellID->407374556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ColorSlider", "[", 
     RowBox[{"Pink", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "Automatic", ",", "50"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "Automatic", ",", "250"}], "}"}]}], "}"}]}], "]"}], 
  "//", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128810829],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{50, 10}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{Automatic, 10}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{250, 10}]},
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{50, Automatic}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{Automatic, Automatic}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{250, Automatic}]},
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{50, 50}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{Automatic, 50}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "SwatchSpectrum",
      ImageSize->{250, 50}]}
   }],
  "Grid"]], "Output",
 ImageSize->{480, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194377536]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Create a colorful drawing:", "ExampleText",
 CellID->313387730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"list", "=", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"pt", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", 
        RowBox[{"-", "20"}]}], "}"}]}], ",", "color"}], "}"}], ",", "\n", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ColorSlider", "[", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"color", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"color", "=", "#"}], ";", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"list", ",", "#"}], "]"}]}], ")"}], "&"}]}], "]"}], 
       "]"}], ",", 
      RowBox[{"LocatorPane", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", 
         RowBox[{"pt", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"list", ",", 
              RowBox[{"Disk", "[", 
               RowBox[{"#", ",", "0.3"}], "]"}]}], "]"}], ")"}], "&"}]}], 
         "]"}], ",", 
        RowBox[{"Framed", "[", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", "list", "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "10"}]}], "]"}], "]"}]}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1465758185],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`list$$ = {
   RGBColor[0., 0., 0.], 
   Disk[{-2., 1.9000000000000004`}, 0.3], 
   Disk[{-2., 1.8000000000000007`}, 0.3], 
   Disk[{-2., 1.700000000000001}, 0.3], 
   Disk[{-1.9000000000000004`, 1.6000000000000014`}, 0.3], 
   Disk[{-1.799999999999999, 1.3000000000000007`}, 0.3], 
   Disk[{-1.4499999999999993`, 1.1000000000000014`}, 0.3], 
   Disk[{-1.25, 0.9000000000000004}, 0.3], 
   Disk[{-0.7999999999999989, 0.8000000000000007}, 0.3], 
   Disk[{-0.4499999999999993, 0.6000000000000014}, 0.3], 
   Disk[{0.10000000000000142`, 0.20000000000000107`}, 0.3], 
   Disk[{0.8500000000000014, -0.1999999999999993}, 0.3], 
   Disk[{1.1000000000000014`, -0.29999999999999893`}, 0.3], 
   Disk[{1.200000000000001, -0.29999999999999893`}, 0.3], 
   Disk[{1.3000000000000007`, -0.29999999999999893`}, 0.3], 
   RGBColor[0.13765163653009843`, 0.5333333333333333, 0.], 
   RGBColor[0.11186388952468147`, 0.5333333333333333, 0.], 
   RGBColor[0., 0.6, 0.048340581368734266`], 
   RGBColor[0., 0.6, 0.2805981536583505], 
   RGBColor[0., 0.6666666666666666, 0.5698329137102311], 
   RGBColor[0., 0.5376668955519951, 0.6666666666666666], 
   RGBColor[0., 0.40863660639353017`, 0.6666666666666666], 
   RGBColor[0., 0.37634851606012054`, 0.6666666666666666], 
   RGBColor[0., 0.3118333714808881, 0.6666666666666666], 
   RGBColor[0., 0.15057602807660028`, 0.6666666666666666], 
   RGBColor[0., 0.053772793163958194`, 0.6666666666666666], 
   RGBColor[0.2042877851529717, 0., 0.6666666666666666], 
   RGBColor[0.430060273136492, 0., 0.6666666666666666], 
   RGBColor[0.4623483634699016, 0., 0.6666666666666666], 
   RGBColor[0.49457541771572444`, 0., 0.6666666666666666], 
   RGBColor[0.5590905622949569, 0., 0.6666666666666666], 
   RGBColor[0.7333333333333333, 0., 0.6742198825055314], 
   RGBColor[0.7333333333333333, 0., 0.46131074998092625`], 
   RGBColor[0.7333333333333333, 0., 0.4258640421149004], 
   Disk[{3.4000000000000004`, 3.200000000000001}, 0.3], 
   Disk[{3.4000000000000004`, 3.1000000000000014`}, 0.3], 
   Disk[{3.8500000000000014`, 2.700000000000001}, 0.3], 
   Disk[{4.550000000000001, 1.8000000000000007`}, 0.3], 
   Disk[{5.65, -0.1999999999999993}, 0.3], 
   Disk[{5.850000000000001, -1.299999999999999}, 0.3], 
   Disk[{6.100000000000001, -2.6999999999999993`}, 0.3], 
   Disk[{6.100000000000001, -3.6999999999999993`}, 0.3], 
   Disk[{6.100000000000001, -4.3}, 0.3], 
   Disk[{5.75, -4.8999999999999995`}, 0.3], 
   Disk[{4.300000000000001, -6.1}, 
    0.3]}, $CellContext`pt$$ = {-20, -20}, $CellContext`color$$ = RGBColor[
  0.7333333333333333, 0., 0.4258640421149004]}, 
  TagBox[GridBox[{
     {
      ColorSetterBox[
       Dynamic[$CellContext`color$$, ($CellContext`color$$ = #; 
        AppendTo[$CellContext`list$$, #])& ], "SwatchSpectrum"]},
     {
      LocatorPaneBox[
       Dynamic[$CellContext`pt$$, AppendTo[$CellContext`list$$, 
         Disk[#, 0.3]]& ], 
       FrameBox[
        GraphicsBox[
         DynamicBox[
          Typeset`ToBoxes[$CellContext`list$$, StandardForm, Graphics],
          ImageSizeCache->{{69.3125, 147.5625}, {-33.5, 55.5625}}],
         PlotRange->10],
        StripOnInput->False]]}
    },
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209435201]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->607262938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->334029976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", 
  RowBox[{"Pink", ",", 
   RowBox[{"AppearanceElements", "\[Rule]", "\"\<Swatch\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63399751],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692933170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->414020636],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73768158]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->242544936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Pink", ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"150", "+", 
         RowBox[{"50", 
          RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
        RowBox[{"40", "+", 
         RowBox[{"10", 
          RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"2", "\[Pi]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"AnimationRate", "\[Rule]", "1"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265246128],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 4.253392087929606, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 2 Pi, 0}}, Typeset`size$$ = {
    127.875, {13.0625, 18.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$13885$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 2 Pi}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$13885$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ColorSlider[
       Pink, ImageSize -> {
         150 + 50 Cos[$CellContext`t$$], 40 + 10 Sin[$CellContext`t$$]}], 
      "Specifications" :> {{$CellContext`t$$, 2 Pi, 0, AnimationRate -> 1, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {52., 57.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305338321]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->440315682],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->509509632],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->817871689],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->79319724],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->351011506]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorSlider - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 30.5883478}", "context" -> "System`", 
    "keywords" -> {
     "choose color", "color chooser", "color control", "color dialog", 
      "color palette", "color picker", "color picking tool", 
      "color selection dialog", "color selector", "color setter", 
      "color swatch", "color wheel"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ColorSlider[color] represents a color slider currently set to the color \
corresponding to color. ColorSlider[Dynamic[color]] uses the dynamically \
updated current value of color, with the value of color being reset if the \
color is modified. ColorSlider[] represents a color slider with an initial \
gray color.", "synonyms" -> {"color slider"}, "title" -> "ColorSlider", 
    "type" -> "Symbol", "uri" -> "ref/ColorSlider"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11471, 335, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->252442962]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44288, 1490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2868, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3491, 89, 1576, 37, 70, "ObjectNameGrid"],
Cell[5070, 128, 1555, 46, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6662, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7140, 196, 321, 10, 70, "Notes",
 CellID->1067943069],
Cell[7464, 208, 645, 23, 70, "Notes",
 CellID->12597],
Cell[8112, 233, 67, 1, 70, "Notes",
 CellID->7213],
Cell[8182, 236, 2117, 53, 70, "3ColumnTableMod",
 CellID->18074],
Cell[10302, 291, 438, 13, 70, "Notes",
 CellID->10639],
Cell[10743, 306, 340, 12, 70, "Notes",
 CellID->26118],
Cell[11086, 320, 348, 10, 70, "Notes",
 CellID->631068756]
}, Closed]],
Cell[CellGroupData[{
Cell[11471, 335, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252442962],
Cell[CellGroupData[{
Cell[11856, 349, 148, 5, 70, "ExampleSection",
 CellID->147669067],
Cell[CellGroupData[{
Cell[12029, 358, 110, 3, 28, "Input",
 CellID->668753501],
Cell[12142, 363, 213, 6, 58, "Output",
 CellID->444900869]
}, Open  ]],
Cell[12370, 372, 94, 1, 70, "ExampleText",
 CellID->104291952],
Cell[CellGroupData[{
Cell[12489, 377, 224, 7, 28, "Input",
 CellID->19067990],
Cell[12716, 386, 351, 10, 58, "Output",
 CellID->8523924]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13116, 402, 220, 7, 70, "ExampleSection",
 CellID->628548144],
Cell[13339, 411, 335, 11, 70, "ExampleText",
 CellID->60505019],
Cell[13677, 424, 135, 4, 70, "Input",
 CellID->21974678],
Cell[13815, 430, 235, 8, 70, "ExampleText",
 CellID->50895791],
Cell[CellGroupData[{
Cell[14075, 442, 178, 5, 70, "Input",
 CellID->700417950],
Cell[14256, 449, 247, 7, 36, "Output",
 CellID->5334213]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14552, 462, 221, 7, 70, "ExampleSection",
 CellID->36640604],
Cell[CellGroupData[{
Cell[14798, 473, 238, 7, 70, "ExampleSubsection",
 CellID->44048345],
Cell[15039, 482, 86, 1, 70, "ExampleText",
 CellID->477300927],
Cell[CellGroupData[{
Cell[15150, 487, 416, 13, 70, "Input",
 CellID->107600769],
Cell[15569, 502, 370, 11, 70, "Output",
 CellID->811926067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15988, 519, 231, 7, 70, "ExampleSubsection",
 CellID->357226893],
Cell[16222, 528, 114, 3, 70, "ExampleText",
 CellID->136293569],
Cell[CellGroupData[{
Cell[16361, 535, 225, 7, 70, "Input",
 CellID->119939086],
Cell[16589, 544, 352, 10, 70, "Output",
 CellID->88435671]
}, Open  ]],
Cell[16956, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->648940932],
Cell[17084, 562, 257, 8, 70, "ExampleText",
 CellID->772651214],
Cell[CellGroupData[{
Cell[17366, 574, 295, 9, 70, "Input",
 CellID->469113643],
Cell[17664, 585, 375, 11, 70, "Output",
 CellID->705341970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18088, 602, 231, 7, 70, "ExampleSubsection",
 CellID->475956363],
Cell[18322, 611, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[18419, 616, 395, 12, 70, "Input",
 CellID->155850066],
Cell[18817, 630, 494, 15, 70, "Output",
 CellID->600256170]
}, Open  ]],
Cell[19326, 648, 125, 3, 70, "ExampleDelimiter",
 CellID->311688381],
Cell[19454, 653, 83, 1, 70, "ExampleText",
 CellID->375560463],
Cell[CellGroupData[{
Cell[19562, 658, 355, 10, 70, "Input",
 CellID->179308],
Cell[19920, 670, 293, 9, 70, "Output",
 CellID->309647367]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20262, 685, 236, 7, 70, "ExampleSubsection",
 CellID->80198449],
Cell[20501, 694, 75, 1, 70, "ExampleText",
 CellID->616992961],
Cell[CellGroupData[{
Cell[20601, 699, 559, 17, 70, "Input",
 CellID->4709562],
Cell[21163, 718, 876, 26, 70, "Output",
 CellID->300540186]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22088, 750, 236, 7, 70, "ExampleSubsection",
 CellID->46113474],
Cell[22327, 759, 90, 1, 70, "ExampleText",
 CellID->466623908],
Cell[CellGroupData[{
Cell[22442, 764, 225, 7, 70, "Input",
 CellID->357598064],
Cell[22670, 773, 353, 10, 70, "Output",
 CellID->305295291]
}, Open  ]],
Cell[23038, 786, 124, 3, 70, "ExampleDelimiter",
 CellID->42340894],
Cell[23165, 791, 391, 13, 70, "ExampleText",
 CellID->491290957],
Cell[CellGroupData[{
Cell[23581, 808, 302, 9, 70, "Input",
 CellID->470641416],
Cell[23886, 819, 382, 11, 70, "Output",
 CellID->414751443]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24317, 836, 227, 7, 70, "ExampleSubsection",
 CellID->54876488],
Cell[24547, 845, 212, 8, 70, "ExampleText",
 CellID->301625236],
Cell[CellGroupData[{
Cell[24784, 857, 109, 3, 70, "Input",
 CellID->94729581],
Cell[24896, 862, 213, 6, 70, "Output",
 CellID->837898511]
}, Open  ]],
Cell[25124, 871, 125, 3, 70, "ExampleDelimiter",
 CellID->202367467],
Cell[25252, 876, 375, 12, 70, "ExampleText",
 CellID->102141691],
Cell[CellGroupData[{
Cell[25652, 892, 175, 5, 70, "Input",
 CellID->227336428],
Cell[25830, 899, 227, 7, 70, "Output",
 CellID->455734763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26106, 912, 233, 7, 70, "ExampleSubsection",
 CellID->337286027],
Cell[26342, 921, 55, 1, 70, "ExampleText",
 CellID->117831909],
Cell[CellGroupData[{
Cell[26422, 926, 364, 12, 70, "Input",
 CellID->1626991498],
Cell[26789, 940, 707, 23, 70, "Output",
 CellID->936829635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27545, 969, 230, 7, 70, "ExampleSubsection",
 CellID->484951554],
Cell[27778, 978, 67, 1, 70, "ExampleText",
 CellID->407374556],
Cell[CellGroupData[{
Cell[27870, 983, 585, 19, 70, "Input",
 CellID->128810829],
Cell[28458, 1004, 1064, 29, 70, "Output",
 CellID->194377536]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29583, 1040, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[29813, 1049, 69, 1, 70, "ExampleText",
 CellID->313387730],
Cell[CellGroupData[{
Cell[29907, 1054, 1382, 43, 70, "Input",
 CellID->1465758185],
Cell[31292, 1099, 3551, 76, 70, "Output",
 CellID->209435201]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34892, 1181, 237, 7, 70, "ExampleSection",
 CellID->607262938],
Cell[35132, 1190, 336, 12, 70, "ExampleText",
 CellID->334029976],
Cell[CellGroupData[{
Cell[35493, 1206, 195, 6, 70, "Input",
 CellID->63399751],
Cell[35691, 1214, 204, 6, 70, "Output",
 CellID->692933170]
}, Open  ]],
Cell[CellGroupData[{
Cell[35932, 1225, 110, 3, 70, "Input",
 CellID->414020636],
Cell[36045, 1230, 203, 6, 70, "Output",
 CellID->73768158]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36297, 1242, 228, 7, 70, "ExampleSection",
 CellID->242544936],
Cell[CellGroupData[{
Cell[36550, 1253, 672, 20, 70, "Input",
 CellID->265246128],
Cell[37225, 1275, 1988, 44, 70, "Output",
 CellID->305338321]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39274, 1326, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[39593, 1337, 1441, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[41071, 1395, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[41392, 1406, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[41554, 1411, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[41739, 1419, 299, 8, 70, "MoreAboutSection"],
Cell[42041, 1429, 124, 3, 70, "MoreAbout",
 CellID->440315682],
Cell[42168, 1434, 141, 3, 70, "MoreAbout",
 CellID->509509632],
Cell[42312, 1439, 149, 3, 70, "MoreAbout",
 CellID->817871689],
Cell[42464, 1444, 152, 3, 70, "MoreAbout",
 CellID->79319724],
Cell[42619, 1449, 128, 3, 70, "MoreAbout",
 CellID->351011506]
}, Open  ]],
Cell[42762, 1455, 27, 0, 70, "History"],
Cell[42792, 1457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

