(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     92991,       3304]
NotebookOptionsPosition[     78478,       2802]
NotebookOutlinePosition[     80041,       2843]
CellTagsIndexPosition[     79955,       2838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       3->"\<\"String\[Hyphen]Oriented Output Formats\"\>", 
       4->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsColumn" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsColumn"], "Row" :> 
          Documentation`HelpLookup["paclet:ref/Row"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "Labeled" :> 
          Documentation`HelpLookup["paclet:ref/Labeled"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsColumn\"\>", 2->"\<\"Row\"\>", 
       3->"\<\"Grid\"\>", 4->"\<\"Labeled\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Grids & Tables\"\>", 3->"\<\"Layout & Tables\"\>", 
       4->"\<\"Mathematical Typesetting\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>", 6->"\<\"Palettes\"\>", 
       7->"\<\"User Interface Structuring & Layout\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Column", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Column",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Column"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " arranged in a column, with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " above ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Column",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Column"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["alignment", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]aligns each element horizontally in the specified way. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Column",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Column"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["alignment", "TI"], ",", 
        StyleBox["spacing", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]leaves the specified number of x-heights of spacing \
between successive elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible alignments are: ", "Notes",
 CellID->31511],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell["centered ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "left justified (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell["right justified ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<\!\(\*
StyleBox[\"c\", \"TI\"]\)\>\"", " "}], Cell[TextData[{
     "align on the character ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"c\", \"TI\"]\)\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["h", "TI"], ",", 
      StyleBox["v", "TI"]}], "}"}], Cell[
    "separate horizontal and vertical alignment", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->5521],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats as a column in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21280],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12889],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   StyleBox["col", "TI"], "]"}]], "InlineFormula"],
 " extracts the list that makes up a column. "
}], "Notes",
 CellID->2858],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be expressions of any kind, including graphics and controls."
}], "Notes",
 CellID->17552],

Cell[TextData[{
 "You can enter text as an element of a ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " by giving it as a string. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " to specify a particular style. "
}], "Notes",
 CellID->129],

Cell["The following options can be given: ", "Notes",
 CellID->19154],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Left",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Left"], ",", 
      ButtonBox["Baseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Baseline"]}], "}"}], Cell[
    "horizontal and vertical alignment of items", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultElement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultElement"], 
    "\"\<\[Backslash][Placeholder]\>\"", Cell[
    "what element to insert in an empty item", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw divider lines in the column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames in the column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "width and height of each item ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "individual styles for items ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "horizontal and vertical spacings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->242669774],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->82840319],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "frame around the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "frame around every item in the column", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->412715870],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["alignment", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"Alignment", "->", 
     StyleBox["alignment", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8938],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["alignment", "TI"], ",", 
    StyleBox["spacing", "TI"]}], "]"}]], "InlineFormula"],
 " corresponds to the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"], "->", 
   StyleBox["spacing", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->762899072],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be lists giving settings for each item in the column."
}], "Notes",
 CellID->181332697],

Cell[TextData[{
 "Settings for the options ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be given as follows to apply separately to successive items in the \
column: "
}], "Notes",
 CellID->169430293],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     StyleBox["c", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], "1"]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], "2"], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "1"], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "1"]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "2"], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "2"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, False, True, True, True, 
      True}}}},
 CellID->144545615],

Cell[TextData[{
 "With settings of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["m", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", if there are more ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specified than items in the column, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " from the beginning are used for the first items, and ones from the end are \
used for the last items. "
}], "Notes",
 CellID->26373273],

Cell[TextData[{
 "Settings such as ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " can effectively be specified for individual items in the column using ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4827],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " will break elements across multiple lines if necessary. "
}], "Notes",
 CellID->8202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " will not change the size of graphics or other objects that have explicit \
",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " settings. "
}], "Notes",
 CellID->11176],

Cell[TextData[{
 "For a column of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "+", "1"}]], "InlineFormula"],
 " gaps between elements, starting before the first element, and ending after \
the last element."
}], "Notes",
 CellID->49335815],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->103124118],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all gaps between items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to successive horizontal and vertical gaps"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->934654743],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have the same forms as for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and other item-oriented options."
}], "Notes",
 CellID->405888177],

Cell[TextData[{
 "The following settings can be used for ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->3429],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the middle row in the column (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the middle row in the column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "halfway from top to bottom ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "top of the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15885],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Column\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41012926],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->209248335],

Cell["Display as a column: ", "ExampleText",
 CellID->148684426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "12", ",", "123", ",", "1234"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201902370],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"12"},
    {"123"},
    {"1234"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{32, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435878520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52286483],

Cell["Center each element:", "ExampleText",
 CellID->5107924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "12", ",", "123", ",", "1234"}], "}"}], ",", "Center"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40678614],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"12"},
    {"123"},
    {"1234"}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}}],
  "Column"]], "Output",
 ImageSize->{32, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331485714]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->878],

Cell["Add a frame around the column:", "ExampleText",
 CellID->238422870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333", ",", "4444"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671275496],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"},
    {"4444"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Column"]], "Output",
 ImageSize->{42, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283892341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39139857],

Cell["Set the background: ", "ExampleText",
 CellID->111522077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333", ",", "4444"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197626081],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"},
    {"4444"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.5, 0.5]}}}],
  "Column"]], "Output",
 ImageSize->{32, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436385862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88870591],

Cell["Use alternating background colors:", "ExampleText",
 CellID->726907550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "!"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"LightRed", ",", "Pink"}], "}"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59960806],

Cell[BoxData[
 TagBox[GridBox[{
    {"2432902008176640000"},
    {"51090942171709440000"},
    {"1124000727777607680000"},
    {"25852016738884976640000"},
    {"620448401733239439360000"},
    {"15511210043330985984000000"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{Automatic}}, "Rows" -> {{
        RGBColor[1, 0.85, 0.85], 
        RGBColor[1, 0.5, 0.5]}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Column"]], "Output",
 ImageSize->{213, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55465996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362147986],

Cell["Set the item size for line breaking:", "ExampleText",
 CellID->511916139],

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "10"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"TrigExpand", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"9", " ", "x"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->145728468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"20", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190654125],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox["x", "10"], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["x", "9"], " ", "y"}], "+", 
      RowBox[{"45", " ", 
       SuperscriptBox["x", "8"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"120", " ", 
       SuperscriptBox["x", "7"], " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"210", " ", 
       SuperscriptBox["x", "6"], " ", 
       SuperscriptBox["y", "4"]}], "+", 
      RowBox[{"252", " ", 
       SuperscriptBox["x", "5"], " ", 
       SuperscriptBox["y", "5"]}], "+", 
      RowBox[{"210", " ", 
       SuperscriptBox["x", "4"], " ", 
       SuperscriptBox["y", "6"]}], "+", 
      RowBox[{"120", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "7"]}], "+", 
      RowBox[{"45", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "8"]}], "+", 
      RowBox[{"10", " ", "x", " ", 
       SuperscriptBox["y", "9"]}], "+", 
      SuperscriptBox["y", "10"]}]},
    {
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "8"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "-", 
      RowBox[{"84", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "6"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
      RowBox[{"126", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
      RowBox[{"36", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "7"]}], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "9"]}]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{20}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{266, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33851731]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1661826],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->369477281],

Cell["Align within the column:", "ExampleText",
 CellID->406792626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78496925],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Right}}}],
    "Column"]}], "}"}]], "Output",
 ImageSize->{118, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49651265]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->270607819],

Cell["Change the overall background color:", "ExampleText",
 CellID->797781199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"LightRed", ",", "LightGreen", ",", "Pink"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164364646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxBackground->{"Columns" -> {{
          RGBColor[1, 0.85, 0.85]}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxBackground->{"Columns" -> {{
          RGBColor[0.88, 1, 0.88]}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"22"},
      {"333"}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxBackground->{"Columns" -> {{
          RGBColor[1, 0.5, 0.5]}}}],
    "Column"]}], "}"}]], "Output",
 ImageSize->{118, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356358133]
}, Open  ]],

Cell["Change the background color of an individual row:", "ExampleText",
 CellID->352627368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"LightRed", ",", "LightGreen", ",", "Pink"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452920358],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{Automatic}}, "Rows" -> {
       RGBColor[1, 0.85, 0.85], 
       RGBColor[0.88, 1, 0.88], 
       RGBColor[1, 0.5, 0.5]}}],
  "Column"]], "Output",
 ImageSize->{25, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3701952]
}, Open  ]],

Cell["Alternate the background color:", "ExampleText",
 CellID->173789501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333", ",", "4444"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"LightRed", ",", "Pink"}], "}"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25204610],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"},
    {"4444"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{Automatic}}, "Rows" -> {{
        RGBColor[1, 0.85, 0.85], 
        RGBColor[1, 0.5, 0.5]}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Column"]], "Output",
 ImageSize->{42, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144413060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->235560419],

Cell["Align the column with surrounding text:", "ExampleText",
 CellID->122358241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197043977],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWclOwzAQdZqGHS4sQqpEywn4CgQHOPELSFGF1B4QqPSMEJ/CjwZPlqY8
nM7EdkODGilxxhm/GXvWqg/xdPT0HE/Hw3hwP4lfR+Ph2+DuZaKnwkAp9aXv
x1Ol3xP9lt5fSaLHUD/7mvyYUSqkr+mlekC/rwgX0UR2YdwUre7QI5rRKY+q
NbshkoNc3Zp0k6jE1dFkBKPsRJejU1N2cvOmVY2R5rnIBlFuCxr3xauk9pQh
mnx7nj4QoXA+i7qcJVkmvTGiRQzangFtkQWujVK4ONz1IsXFYnYSMULRgnao
yIUomA+KEU/ZDj2scYrmWfQpOz0wy3F+j/htkorVrRj9WPRv9tSUHxVZ/YjR
xy1q8Iw4abJIX6O2CZVoisoTL2iS+JnvWrAS26NK469aIvUTA+bMub4kQ7vI
z7STj5mC2bVoDnNa3T6m6yCXdh+kny5TqBI1X8LMbIEudbujyItU8pRgtpOr
xFyBtmEVV0t2DHuT4Npp4+LNdpr5sTjWIIyNZVjYV6RhhnGJJGl9Lndxy2jT
d/CQ6i7EXr5N79UWaYu61rbsYdn+UVTxQ0YPO+/HqsdJ6a3RVh6tyKfHTigS
v8fuspko+i2J+qlzwylw3WSJ8slYxNQNVq+W9GPVqyUdUvVq+5NEJFOPUc3d
+3df5zOv3FPW3D8zkD/blL+asn/4VPAN5QHcBQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4384101]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Dividers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7634498],

Cell["Draw all dividers:", "ExampleText",
 CellID->919869753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->433326002],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Column"]], "Output",
 ImageSize->{35, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479612503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37300839],

Cell["Only draw exterior dividers:", "ExampleText",
 CellID->324991857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->812636396],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{
    "Columns" -> {True, {}, True}, "Rows" -> {True, {}, True}}],
  "Column"]], "Output",
 ImageSize->{35, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78957427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171343166],

Cell["Draw only interior dividers:", "ExampleText",
 CellID->380983591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364896678],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "Rows" -> {False, {True}, False}}],
  "Column"]], "Output",
 ImageSize->{25, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37021479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57050221],

Cell["Draw custom dividers:", "ExampleText",
 CellID->581914383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"2", "\[Rule]", "Green"}], ",", 
        RowBox[{"3", "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640902880],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw8AGxsgQDkP0fyAJj
vv//gTSUBIuhiCCRDMwQCgSYgZgJyGUF0owosiASJMPAAuEgJBnhasHyzAh5
FjQ+WB5iIB5VELPQRVmQbIKoYMWjgnR3gwxigdJMmCEFDlRcIYg9HDmw+nYg
REH+YQIKcmFxOQPcXwyMAETjHHM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{14, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->742401241]
}, Open  ]],

Cell["Use negative position indices:", "ExampleText",
 CellID->310485987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Green"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257009949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw8AGxsgQDkP0fyAJj
vv//gTSUBIuhiCCRDMwQCgSYgZgJyGUF0owosiASJMPAAuEgJBnhasHyzAh5
FjQ+WB5iIB5VELPQRVmQbIKoYMWjgnR3gwxigdJMmCEFDlRcIYg9HDmw+nYg
REH+YQIKcmFxOQPcXwyMAETjHHM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{14, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48957262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22715418],

Cell["Draw outer column dividers:", "ExampleText",
 CellID->26498130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"2", "\[Rule]", "Blue"}]}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->479584675],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{
    "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 2 -> RGBColor[0, 0, 1]}, 
     "Rows" -> {{None}}}],
  "Column"]], "Output",
 ImageSize->{28, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35942580]
}, Open  ]],

Cell["Use negative position indices:", "ExampleText",
 CellID->182973728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22"}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "\[Rule]", "Blue"}]}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313076742],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{
    "ColumnsIndexed" -> {-2 -> RGBColor[1, 0, 0], -1 -> RGBColor[0, 0, 1]}, 
     "Rows" -> {{None}}}],
  "Column"]], "Output",
 ImageSize->{28, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144349682]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1500183],

Cell["Frame all elements:", "ExampleText",
 CellID->268136149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12726030],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Column"]], "Output",
 ImageSize->{35, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18233012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258284299],

Cell["Frame only the exterior:", "ExampleText",
 CellID->142621636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285941331],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Column"]], "Output",
 ImageSize->{35, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105600948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646844547],

Cell["Frame specific elements:", "ExampleText",
 CellID->184050838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "True", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580201242],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> Automatic, "Rows" -> {None, True, True}}],
  "Column"]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49667361]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16583284],

Cell["Set the style for the frame: ", "ExampleText",
 CellID->683501218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Orange", ",", "Thick", ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Orange", ",", "Thick", ",", "Dashed"}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274978049],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1S2zAQVmI7QPhJgBIonZRwYDgBBy4MJ0701IcI0Bly6JShPEAfLu9l
tLYE4kMrWYoDSSeZsdaS9k+7m921/XP4dP/r9/BpdDsc/HgcPtyPbv8Orv88
yqWkIYQYy+t8T8j7XN4V1zjPJSzHSzkeysUrCZP8n0glTBnYlHC5oGrL8UDO
NhV1l6glLLAtcCeYuyD0vPiJbzDvELbk2ldw9IFU3WKfrGjiv84vpsK1o+zT
d9opMbxgwiVGeubAt2mFeBq2GG1bDnz+FE0ashduBY4IWm0x501r4WyzTDIx
54yxYVYLZ97a6Lu00vy9bZcj+BDdfiDdjjrNSiBd8l9ZYRCIv249tZaeAeTy
RcuBT3CP2T9k1rsLXyyy3huOvYk5dqzWnc/KqCMSI7zubqJ0ZPkrPFIuOP5j
dWuA8pq1aHH1IVLuZphrE/DbIAVz04lnHq8FSVu1SCfYBn4YLYnCO43ShrAy
lS8IrsM+0q8Y2iGdzg0mPtaZBOjWrPq9pdedHtLxUYuezWyer5gzbRbRfgmt
IKaVCGKfFlIzbJbTPEN7Y21NtH6j3FcZkEasCfb4ep1vAL5ZQ3x0XC3x9g9M
TfHRaavRiwE6eXl6XyxV08jeL3o1EmXf6ML7rjRf8uC5fezLEz5/rTGnrKSV
nH714B179jFOqmU/nw9WmVP5umedy33dsu9UnahTTZLdYvpiHakh/elRAO5m
lBWwq3VlIsSr0sViptmF/a0oreejd1xoEdpHxz6t3ORGvfzUd7+68/rCUKfG
Pvc8TPvbsN5T632rVMyInHTM5JwWWMdQGx0zWLe2c9cbsoWWs6Ml9ktHM6EF
Pp1NJ9rjpOonmh4jLTP2Ce4qeKbggZXrvH0rmt4Xu7iviONiFI1nCvaWGA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{196, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56766939]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ItemSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->560838426],

Cell["Control the size of an item and possibly force linewrapping:", \
"ExampleText",
 CellID->891277895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
      RowBox[{"ItemSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154924968],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr1OwzAQgJ2WAo/AWAQDPxNiYmCFiQnBABQpqiq1Qqio9BUQDPxMiImB
Z+QBil0aGkUO55CWOukXqf7L3edzIttx747Cfrt1HfY7zbB+2Atv2p3mbf2g
29NN1UCpoKGU+lxRujzQpeHPXJf69138Lu3rG8u61B3lH2p4VSP5gdozSay+
mKhfCfffdRJAhfpP1AWdmGoyXxdoaXqnf9R7sFpXNUntp25q+qpkaF0T7Mnf
w8nUe7i3Ppsly5P9rb4q2JmVdzxh3t0cj7Kmk4quJnNpFqbpSbMwTc8+C+fj
HbDWpK81fu8SRdpvoUKFChUqVKhQp0M134Hm064yyrcESlL+IqP8c6oVrt+d
Lha6slysd2XZRyadMLYFCyT9Rk79F6vVNUFLegeSvvTcJX37s5bGvin0Kumf
59R/slotnUk3hF4k/bOc+o9Wq8s9Y001yl1maFzeZUbG5e0zsEh7CFSoUKFC
hQoV6nRPqjuCdiTXdJR7tfaWPIFIvSblpd6T8liBFUWzwpxgjC94V6BFci1H
uTdrb0Vaq6BChQoV6uSo9ohaI5SMvXUtEaMLVab6HdFELJppJe617KMk7nX2
74C1Jn2t8XuXKNJ+CxUqVKhQic2bFIvYPHd9YvPGrcTm+TdjTZXYPKhQoUKF
mvVrmvghrMAKH6wgfggq1KJSiccoD9Vv7xV+R9NKjEPZR0mMw+zfAWtN+lrj
9y5RpP0WapGo+GEnxcIP666PH3bcih/Wvxkb35Hxw0ItExVfEVZghU9W4CvK
8t+7Cr4AXeLAcg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{349, 243},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146124242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245301561],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " the content will have a linebreak:"
}], "ExampleText",
 CellID->106483894],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@", 
    RowBox[{"Riffle", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"\"\<text\>\"", ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], ",", "\"\< \>\""}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264970144],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->337985614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", ",", "t"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"20", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->377892158],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox["x", "10"], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["x", "9"], " ", "y"}], "+", 
      RowBox[{"45", " ", 
       SuperscriptBox["x", "8"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"120", " ", 
       SuperscriptBox["x", "7"], " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"210", " ", 
       SuperscriptBox["x", "6"], " ", 
       SuperscriptBox["y", "4"]}], "+", 
      RowBox[{"252", " ", 
       SuperscriptBox["x", "5"], " ", 
       SuperscriptBox["y", "5"]}], "+", 
      RowBox[{"210", " ", 
       SuperscriptBox["x", "4"], " ", 
       SuperscriptBox["y", "6"]}], "+", 
      RowBox[{"120", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "7"]}], "+", 
      RowBox[{"45", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "8"]}], "+", 
      RowBox[{"10", " ", "x", " ", 
       SuperscriptBox["y", "9"]}], "+", 
      SuperscriptBox["y", "10"]}]},
    {"\<\"text text text text text text text text text text\"\>"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{20}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{266, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->671250593]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ItemStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->297684926],

Cell["Change the overall style:", "ExampleText",
 CellID->88430612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
     RowBox[{"ItemStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Gray", ",", "Purple"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735213429],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVttOwzAMddNWY+20FzRuAmlc3vgPeOIjqmlie0Cgsg/onwfb8dLKS0eQ
qFQhJjWnviR24hN3L9Vus36rdttVtXyuq4/NdvW5fHqvUZUmAFDj83gB+G7x
jZ/aWsTDscQxRXumcEHYNE2m0OlB5BYLXo3HHKf7H4U3P9CeshYDeS2+i2+c
VlaAjha8b5R2yrnMaUx9fpB9Iy9Y9tmIvV8Wf1D2Xnky4qxmOBoMmis8I8TF
c4VODyK3WIx4j3+J279760nCasNaMGdtKlWSQ4BXJZuReN0o+V7Jt9Gr0N4f
BO+iZtHJEU2M4FzZqVpEAiMYtoPYoSmDUY3Scn0iOTuX/Tj2x7FUzYni5Uzl
mHB8d2CshBN7vAtc2+O3Xuy9t5yypo8nRU6C5zYZOIPwGWjODJ1FoeKFmTt0
NaZRWfCsSCZf2XgGi28Uc8N3TmdKd67baWn/3Q7r5Lazai6MpVuGvcJfgO7/
TGIVlYS6KR23Q2jO2brf7b5crge3bBHZs+N/1uGs0p295S8QOjuE5rJTBUi+
AI56PPI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{114, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109518459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217762323],

Cell["Change the style for a specific element:", "ExampleText",
 CellID->75292622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "Purple"}], ",", 
      RowBox[{"2", "\[Rule]", "Red"}], ",", 
      RowBox[{"3", "\[Rule]", "Bold"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69445964],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"22"},
    {"333"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemStyle->{
    "Columns" -> {{Automatic}}, 
     "RowsIndexed" -> {
      1 -> RGBColor[0.5, 0, 0.5], 2 -> RGBColor[1, 0, 0], 3 -> Bold}}],
  "Column"]], "Output",
 ImageSize->{25, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24645889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112039256],

Cell["Dynamically change the element being styled:", "ExampleText",
 CellID->134956969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71525084],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x], {1, 3, 1}]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143563067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], "\[Rule]", "Large"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98171700],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiAKxoQQDkP0fyAJj
0f//gTQyyQQkmYFSLGg0E1iWgRlCgUiwCAuEgySJIQKymhHMZQWRzAh5Fix8
clWDbGJigOhCppnIMIsyX+IPQcwQx0XCXAECMP2sQJqDWDci+Y8N7jJ8ocAJ
D0l8qiD2YwtBZD47UeHORpFfkEOXk8TQBZnKCdfHjmYH9wgVZYaGJnKM8ICZ
oFAH5SdepDBkYAQAgjcxng==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{21, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->754369903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21356183],

Cell["Dynamically change the style of a specific element:", "ExampleText",
 CellID->222901851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64387548],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341325974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", "\[Rule]", 
      RowBox[{"Hue", "[", 
       RowBox[{"Dynamic", "[", "x", "]"}], "]"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->192572683],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFUDsOwjAMdeK00AkxVGLszj1g4hBRhdQOCFR6/9T5KAnpZ2gGIsUvfrZj
Pz/k2D1fcuxb2dwH+en69tvc3gNRyACgpnu9AL0VvcytlSKcW04WCUWC3EQB
lUFtDCOsY1lcZBghM16hLfq4+Tv192brTtxVxch3/JWncnuDa3ufW9vIHgRb
XxAef6JhRvBqXBADU/rJYlYkfhX0bWTZ/imb+odo7+tZZZYWTQqHVeZ2T4va
/8FqZZzIczwtmwBW/P4+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{21, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33419276]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spacings",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->189976506],

Cell["Change the spacing between elements:", "ExampleText",
 CellID->105712385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "22", ",", "333"}], "}"}], ",", 
     RowBox[{"Spacings", "\[Rule]", "s"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25500092],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXV1u2zAMluNkXfc/bC0G7GE5xw6wPe0QQVGgeRg2dL3MjrQT7Cx7Uq04
bgdGtihZlCiZBRJZCUV+nySSsuU633Z3N9ffd3f7q9326+3u583+6tf2y4/b
7qO2Uar5pJT6+0F1x7o7OrzM37Z79Yf90b/u3YiePdRUO8hq9RHUNyIlUuRS
f3Q/J9+ipaekXosW0SJaqtbSdm+mugblWRTtq0PTh/pBh/L69EkUHFDL2rPe
W/2tcdGVzvqc+QG/N1ZWXXUDSvvIx7bOs0+o5mtsnH5eG9u6PfKIFWorcLSH
Es45GuutnusbmyQ4oQ+4Ikm7YFQw9g9lmhnFs09Kmed5o0FYxNvrsBVUuDVK
KzWjiDW7aNCl91EaHtQRUFDHz3XSp/X5Ie9oxyMjCIrUKFLNyjB0/Hw/jEfu
yItD/Vn3K+c3xaKfknplaZUiV9Ogr3NMSvV3X568oq4v+jyZS1AuHSV2R4In
+vj7Pjx5zt11E1bpWGH3Z3mir3NMlhInyo7mPDPmM43b++CDdo4WYUHHAuud
ZbKLH2PL7Ie5GbQM1sMqB6Kvkb2p9qzhFR8bG8zajyNLtX6sH8fVybfG0Q7p
h4XEvoCeKTrnBfCFeleg7lrZQPlzhzzEE1sehT9SP5lI+Rwp5+rHNrLcJL7A
iLE5RgNTvvQcJ9/2Ty3f/9/+hQNv6vZB/C3jAOcv3MvwidG2PrbNnRg6IV+f
XRzbWJSgM1p/nnza9uWxMO8w/7j8FeYf6x01Hu1tu1dTdThPbHfC5Gzvy9+M
XtNVG1NqjKemZmjb255qD2cztJ+7PYr/iOe4Rjc1Nzg2rvMQmLWh/dztUfwJ
zs9i8/K9owJGemg/d3sUf+LzRVdcm6Nrzr0iLp/mqsu7vyKc9WJWD1Pyrntd
MLmPUt6KP8JZYa1XBWrhNZx9va+UH6yXynPsan2J/EzVvvNSIpuTVaCwElbM
WA3XZS6LZVPO/Rtl3BMjKOlQjq2peKJ1RTxBLagFtaCeQj22vuCJtowsIigF
5amXmXXFuyLQwh2RfKht/73LAx38j2hBJagoUA1XDy9YoMkTbQVF6Sio8l/4
U40oPV1QCSpBNa2FKq/leGYizyff1mQlNH+EWZvrMWJVrOa2GhpfOUcBsULx
7H7bfheNNdcV8kerIbkbp933VzBEK43WsX2HMG12bxEtokW0YGJpL831F9pE
amlSZs72vxFpvtgejlRzDyRO6uE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{287, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20517446]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->79257281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->323861966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "12", ",", "123"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33296890],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"12"},
    {"123"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{25, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49458262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "12", ",", "123"}], "}"}], "}"}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14327316],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"12"},
    {"123"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Grid"]], "Output",
 ImageSize->{25, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256452656]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1323]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9669],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->140352686],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->15392082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->239729266],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->38525722],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->101605744],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->2813571],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->264164884],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->11690081],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->31302049],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->319733136],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->82941742]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Column - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 32.1821386}", "context" -> "System`", 
    "keywords" -> {
     "column of objects", "column alignment", "stacking of objects", 
      "vertical stacking", "vertical collection"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Column[{expr_1, expr_2, ...}] is an object that formats with the expr_i \
arranged in a column, with expr_1 above expr_2, etc. Column[list, alignment] \
aligns each element horizontally in the specified way. Column[list, \
alignment, spacing] leaves the specified number of x-heights of spacing \
between successive elements.", "synonyms" -> {}, "title" -> "Column", "type" -> 
    "Symbol", "uri" -> "ref/Column"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[33330, 1085, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41012926]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 79811, 2831}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3708, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4331, 105, 1571, 37, 70, "ObjectNameGrid"],
Cell[5905, 144, 1968, 63, 70, "Usage",
 CellID->5364]
}, Open  ]],
Cell[CellGroupData[{
Cell[7910, 212, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8388, 229, 58, 1, 70, "Notes",
 CellID->31511],
Cell[8449, 232, 1385, 37, 70, "2ColumnTableMod",
 CellID->5521],
Cell[9837, 271, 655, 24, 70, "Notes",
 CellID->21280],
Cell[10495, 297, 565, 22, 70, "Notes",
 CellID->12889],
Cell[11063, 321, 256, 9, 70, "Notes",
 CellID->2858],
Cell[11322, 332, 225, 8, 70, "Notes",
 CellID->17552],
Cell[11550, 342, 730, 24, 70, "Notes",
 CellID->129],
Cell[12283, 368, 69, 1, 70, "Notes",
 CellID->19154],
Cell[12355, 371, 3694, 104, 70, "3ColumnTableMod",
 CellID->242669774],
Cell[16052, 477, 199, 8, 70, "Notes",
 CellID->82840319],
Cell[16254, 487, 919, 24, 70, "2ColumnTableMod",
 CellID->412715870],
Cell[17176, 513, 553, 21, 70, "Notes",
 CellID->8938],
Cell[17732, 536, 518, 19, 70, "Notes",
 CellID->762899072],
Cell[18253, 557, 364, 12, 70, "Notes",
 CellID->181332697],
Cell[18620, 571, 792, 29, 70, "Notes",
 CellID->169430293],
Cell[19415, 602, 6572, 219, 70, "2ColumnTableMod",
 CellID->144545615],
Cell[25990, 823, 978, 34, 70, "Notes",
 CellID->26373273],
Cell[26971, 859, 632, 23, 70, "Notes",
 CellID->4827],
Cell[27606, 884, 488, 17, 70, "Notes",
 CellID->8202],
Cell[28097, 903, 376, 13, 70, "Notes",
 CellID->11176],
Cell[28476, 918, 604, 21, 70, "Notes",
 CellID->49335815],
Cell[29083, 941, 348, 13, 70, "Notes",
 CellID->103124118],
Cell[29434, 956, 1083, 33, 70, "2ColumnTableMod",
 CellID->934654743],
Cell[30520, 991, 485, 18, 70, "Notes",
 CellID->405888177],
Cell[31008, 1011, 227, 8, 70, "Notes",
 CellID->3429],
Cell[31238, 1021, 1709, 47, 70, "2ColumnTableMod",
 CellID->15885],
Cell[32950, 1070, 343, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[33330, 1085, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41012926],
Cell[CellGroupData[{
Cell[33714, 1099, 148, 5, 70, "ExampleSection",
 CellID->209248335],
Cell[33865, 1106, 64, 1, 70, "ExampleText",
 CellID->148684426],
Cell[CellGroupData[{
Cell[33954, 1111, 175, 5, 28, "Input",
 CellID->201902370],
Cell[34132, 1118, 287, 13, 78, "Output",
 CellID->435878520]
}, Open  ]],
Cell[34434, 1134, 124, 3, 70, "ExampleDelimiter",
 CellID->52286483],
Cell[34561, 1139, 61, 1, 70, "ExampleText",
 CellID->5107924],
Cell[CellGroupData[{
Cell[34647, 1144, 207, 7, 70, "Input",
 CellID->40678614],
Cell[34857, 1153, 289, 13, 78, "Output",
 CellID->331485714]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35195, 1172, 214, 7, 70, "ExampleSection",
 CellID->878],
Cell[35412, 1181, 73, 1, 70, "ExampleText",
 CellID->238422870],
Cell[CellGroupData[{
Cell[35510, 1186, 237, 7, 70, "Input",
 CellID->671275496],
Cell[35750, 1195, 356, 14, 84, "Output",
 CellID->283892341]
}, Open  ]],
Cell[36121, 1212, 124, 3, 70, "ExampleDelimiter",
 CellID->39139857],
Cell[36248, 1217, 63, 1, 70, "ExampleText",
 CellID->111522077],
Cell[CellGroupData[{
Cell[36336, 1222, 242, 7, 70, "Input",
 CellID->197626081],
Cell[36581, 1231, 360, 15, 78, "Output",
 CellID->436385862]
}, Open  ]],
Cell[36956, 1249, 124, 3, 70, "ExampleDelimiter",
 CellID->88870591],
Cell[37083, 1254, 77, 1, 70, "ExampleText",
 CellID->726907550],
Cell[CellGroupData[{
Cell[37185, 1259, 442, 14, 70, "Input",
 CellID->59960806],
Cell[37630, 1275, 632, 19, 114, "Output",
 CellID->55465996]
}, Open  ]],
Cell[38277, 1297, 125, 3, 70, "ExampleDelimiter",
 CellID->362147986],
Cell[38405, 1302, 79, 1, 70, "ExampleText",
 CellID->511916139],
Cell[38487, 1305, 392, 14, 70, "Input",
 CellID->145728468],
Cell[CellGroupData[{
Cell[38904, 1323, 317, 10, 70, "Input",
 CellID->190654125],
Cell[39224, 1335, 2181, 65, 134, "Output",
 CellID->33851731]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41454, 1406, 221, 7, 70, "ExampleSection",
 CellID->1661826],
Cell[CellGroupData[{
Cell[41700, 1417, 230, 7, 70, "ExampleSubsection",
 CellID->369477281],
Cell[41933, 1426, 67, 1, 70, "ExampleText",
 CellID->406792626],
Cell[CellGroupData[{
Cell[42025, 1431, 415, 14, 70, "Input",
 CellID->78496925],
Cell[42443, 1447, 603, 28, 64, "Output",
 CellID->49651265]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43095, 1481, 231, 7, 70, "ExampleSubsection",
 CellID->270607819],
Cell[43329, 1490, 79, 1, 70, "ExampleText",
 CellID->797781199],
Cell[CellGroupData[{
Cell[43433, 1495, 424, 14, 70, "Input",
 CellID->164364646],
Cell[43860, 1511, 836, 34, 64, "Output",
 CellID->356358133]
}, Open  ]],
Cell[44711, 1548, 92, 1, 70, "ExampleText",
 CellID->352627368],
Cell[CellGroupData[{
Cell[44828, 1553, 309, 10, 70, "Input",
 CellID->452920358],
Cell[45140, 1565, 432, 16, 64, "Output",
 CellID->3701952]
}, Open  ]],
Cell[45587, 1584, 74, 1, 70, "ExampleText",
 CellID->173789501],
Cell[CellGroupData[{
Cell[45686, 1589, 373, 11, 70, "Input",
 CellID->25204610],
Cell[46062, 1602, 488, 17, 84, "Output",
 CellID->144413060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46599, 1625, 237, 7, 70, "ExampleSubsection",
 CellID->235560419],
Cell[46839, 1634, 82, 1, 70, "ExampleText",
 CellID->122358241],
Cell[CellGroupData[{
Cell[46946, 1639, 560, 17, 70, "Input",
 CellID->197043977],
Cell[47509, 1658, 921, 19, 70, "Output",
 Evaluatable->False,
 CellID->4384101]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48479, 1683, 227, 7, 70, "ExampleSubsection",
 CellID->7634498],
Cell[48709, 1692, 61, 1, 70, "ExampleText",
 CellID->919869753],
Cell[CellGroupData[{
Cell[48795, 1697, 226, 7, 70, "Input",
 CellID->433326002],
Cell[49024, 1706, 338, 13, 72, "Output",
 CellID->479612503]
}, Open  ]],
Cell[49377, 1722, 124, 3, 70, "ExampleDelimiter",
 CellID->37300839],
Cell[49504, 1727, 71, 1, 70, "ExampleText",
 CellID->324991857],
Cell[CellGroupData[{
Cell[49600, 1732, 227, 7, 70, "Input",
 CellID->812636396],
Cell[49830, 1741, 358, 14, 70, "Output",
 CellID->78957427]
}, Open  ]],
Cell[50203, 1758, 125, 3, 70, "ExampleDelimiter",
 CellID->171343166],
Cell[50331, 1763, 71, 1, 70, "ExampleText",
 CellID->380983591],
Cell[CellGroupData[{
Cell[50427, 1768, 229, 7, 70, "Input",
 CellID->364896678],
Cell[50659, 1777, 370, 14, 66, "Output",
 CellID->37021479]
}, Open  ]],
Cell[51044, 1794, 124, 3, 70, "ExampleDelimiter",
 CellID->57050221],
Cell[51171, 1799, 64, 1, 70, "ExampleText",
 CellID->581914383],
Cell[CellGroupData[{
Cell[51260, 1804, 448, 15, 70, "Input",
 CellID->640902880],
Cell[51711, 1821, 422, 11, 70, "Output",
 Evaluatable->False,
 CellID->742401241]
}, Open  ]],
Cell[52148, 1835, 73, 1, 70, "ExampleText",
 CellID->310485987],
Cell[CellGroupData[{
Cell[52246, 1840, 523, 18, 70, "Input",
 CellID->257009949],
Cell[52772, 1860, 421, 11, 70, "Output",
 Evaluatable->False,
 CellID->48957262]
}, Open  ]],
Cell[53208, 1874, 124, 3, 70, "ExampleDelimiter",
 CellID->22715418],
Cell[53335, 1879, 69, 1, 70, "ExampleText",
 CellID->26498130],
Cell[CellGroupData[{
Cell[53429, 1884, 399, 14, 70, "Input",
 CellID->479584675],
Cell[53831, 1900, 382, 14, 48, "Output",
 CellID->35942580]
}, Open  ]],
Cell[54228, 1917, 73, 1, 70, "ExampleText",
 CellID->182973728],
Cell[CellGroupData[{
Cell[54326, 1922, 452, 16, 70, "Input",
 CellID->313076742],
Cell[54781, 1940, 385, 14, 48, "Output",
 CellID->144349682]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55215, 1960, 224, 7, 70, "ExampleSubsection",
 CellID->1500183],
Cell[55442, 1969, 62, 1, 70, "ExampleText",
 CellID->268136149],
Cell[CellGroupData[{
Cell[55529, 1974, 222, 7, 70, "Input",
 CellID->12726030],
Cell[55754, 1983, 334, 13, 72, "Output",
 CellID->18233012]
}, Open  ]],
Cell[56103, 1999, 125, 3, 70, "ExampleDelimiter",
 CellID->258284299],
Cell[56231, 2004, 67, 1, 70, "ExampleText",
 CellID->142621636],
Cell[CellGroupData[{
Cell[56323, 2009, 224, 7, 70, "Input",
 CellID->285941331],
Cell[56550, 2018, 342, 13, 70, "Output",
 CellID->105600948]
}, Open  ]],
Cell[56907, 2034, 125, 3, 70, "ExampleDelimiter",
 CellID->646844547],
Cell[57035, 2039, 67, 1, 70, "ExampleText",
 CellID->184050838],
Cell[CellGroupData[{
Cell[57127, 2044, 291, 9, 70, "Input",
 CellID->580201242],
Cell[57421, 2055, 345, 13, 68, "Output",
 CellID->49667361]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57815, 2074, 230, 7, 70, "ExampleSubsection",
 CellID->16583284],
Cell[58048, 2083, 72, 1, 70, "ExampleText",
 CellID->683501218],
Cell[CellGroupData[{
Cell[58145, 2088, 574, 17, 70, "Input",
 CellID->274978049],
Cell[58722, 2107, 1126, 23, 70, "Output",
 Evaluatable->False,
 CellID->56766939]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59897, 2136, 229, 7, 70, "ExampleSubsection",
 CellID->560838426],
Cell[60129, 2145, 105, 2, 70, "ExampleText",
 CellID->891277895],
Cell[CellGroupData[{
Cell[60259, 2151, 674, 22, 70, "Input",
 CellID->154924968],
Cell[60936, 2175, 1022, 21, 70, "Output",
 Evaluatable->False,
 CellID->146124242]
}, Open  ]],
Cell[61973, 2199, 125, 3, 70, "ExampleDelimiter",
 CellID->245301561],
Cell[62101, 2204, 228, 8, 70, "ExampleText",
 CellID->106483894],
Cell[62332, 2214, 320, 11, 70, "Input",
 CellID->264970144],
Cell[62655, 2227, 223, 8, 70, "Input",
 CellID->337985614],
Cell[CellGroupData[{
Cell[62903, 2239, 317, 10, 70, "Input",
 CellID->377892158],
Cell[63223, 2251, 1476, 43, 116, "Output",
 CellID->671250593]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64748, 2300, 230, 7, 70, "ExampleSubsection",
 CellID->297684926],
Cell[64981, 2309, 67, 1, 70, "ExampleText",
 CellID->88430612],
Cell[CellGroupData[{
Cell[65073, 2314, 415, 14, 70, "Input",
 CellID->735213429],
Cell[65491, 2330, 769, 17, 70, "Output",
 Evaluatable->False,
 CellID->109518459]
}, Open  ]],
Cell[66275, 2350, 125, 3, 70, "ExampleDelimiter",
 CellID->217762323],
Cell[66403, 2355, 82, 1, 70, "ExampleText",
 CellID->75292622],
Cell[CellGroupData[{
Cell[66510, 2360, 394, 12, 70, "Input",
 CellID->69445964],
Cell[66907, 2374, 423, 16, 64, "Output",
 CellID->24645889]
}, Open  ]],
Cell[67345, 2393, 125, 3, 70, "ExampleDelimiter",
 CellID->112039256],
Cell[67473, 2398, 87, 1, 70, "ExampleText",
 CellID->134956969],
Cell[CellGroupData[{
Cell[67585, 2403, 218, 7, 70, "Input",
 CellID->71525084],
Cell[67806, 2412, 203, 6, 70, "Output",
 CellID->143563067]
}, Open  ]],
Cell[CellGroupData[{
Cell[68046, 2423, 326, 11, 70, "Input",
 CellID->98171700],
Cell[68375, 2436, 479, 12, 70, "Output",
 Evaluatable->False,
 CellID->754369903]
}, Open  ]],
Cell[68869, 2451, 124, 3, 70, "ExampleDelimiter",
 CellID->21356183],
Cell[68996, 2456, 94, 1, 70, "ExampleText",
 CellID->222901851],
Cell[CellGroupData[{
Cell[69115, 2461, 135, 4, 70, "Input",
 CellID->64387548],
Cell[69253, 2467, 192, 6, 70, "Output",
 CellID->341325974]
}, Open  ]],
Cell[CellGroupData[{
Cell[69482, 2478, 357, 12, 70, "Input",
 CellID->192572683],
Cell[69842, 2492, 474, 12, 70, "Output",
 Evaluatable->False,
 CellID->33419276]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70365, 2510, 229, 7, 70, "ExampleSubsection",
 CellID->189976506],
Cell[70597, 2519, 79, 1, 70, "ExampleText",
 CellID->105712385],
Cell[CellGroupData[{
Cell[70701, 2524, 485, 15, 70, "Input",
 CellID->25500092],
Cell[71189, 2541, 1460, 28, 70, "Output",
 Evaluatable->False,
 CellID->20517446]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[72710, 2576, 236, 7, 70, "ExampleSection",
 CellID->79257281],
Cell[72949, 2585, 312, 12, 70, "ExampleText",
 CellID->323861966],
Cell[CellGroupData[{
Cell[73286, 2601, 161, 5, 70, "Input",
 CellID->33296890],
Cell[73450, 2608, 272, 12, 64, "Output",
 CellID->49458262]
}, Open  ]],
Cell[CellGroupData[{
Cell[73759, 2625, 291, 9, 70, "Input",
 CellID->14327316],
Cell[74053, 2636, 271, 12, 64, "Output",
 CellID->256452656]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74385, 2655, 311, 9, 70, "SeeAlsoSection",
 CellID->25694],
Cell[74699, 2666, 932, 35, 70, "SeeAlso",
 CellID->1323]
}, Open  ]],
Cell[CellGroupData[{
Cell[75668, 2706, 313, 9, 70, "TutorialsSection",
 CellID->9669],
Cell[75984, 2717, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[76134, 2722, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[76440, 2733, 180, 3, 70, "Tutorials",
 CellID->140352686],
Cell[76623, 2738, 145, 3, 70, "Tutorials",
 CellID->15392082]
}, Open  ]],
Cell[CellGroupData[{
Cell[76805, 2746, 319, 9, 70, "MoreAboutSection",
 CellID->239729266],
Cell[77127, 2757, 172, 3, 70, "MoreAbout",
 CellID->38525722],
Cell[77302, 2762, 140, 3, 70, "MoreAbout",
 CellID->101605744],
Cell[77445, 2767, 140, 3, 70, "MoreAbout",
 CellID->2813571],
Cell[77588, 2772, 159, 3, 70, "MoreAbout",
 CellID->264164884],
Cell[77750, 2777, 168, 3, 70, "MoreAbout",
 CellID->11690081],
Cell[77921, 2782, 127, 3, 70, "MoreAbout",
 CellID->31302049],
Cell[78051, 2787, 180, 3, 70, "MoreAbout",
 CellID->319733136],
Cell[78234, 2792, 172, 3, 70, "MoreAbout",
 CellID->82941742]
}, Open  ]],
Cell[78421, 2798, 27, 0, 70, "History"],
Cell[78451, 2800, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

