(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33562,       1086]
NotebookOptionsPosition[     28661,        927]
NotebookOutlinePosition[     30401,        971]
CellTagsIndexPosition[     30316,        966]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generating C and Fortran Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingCAndFortranExpressions"], 
          "Compiling Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CompilingMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Generating C and Fortran Expressions\"\>", 
       2->"\<\"Compiling Mathematica Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"], "Dispatch" :> 
          Documentation`HelpLookup["paclet:ref/Dispatch"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "CForm" :> Documentation`HelpLookup["paclet:ref/CForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CompiledFunction\"\>", 
       2->"\<\"Dispatch\"\>", 3->"\<\"Function\"\>", 
       4->"\<\"InterpolatingFunction\"\>", 
       5->"\<\"CForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Time Measurement & Optimization\"\>", 
       2->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Compile", "ObjectName",
 CellID->31694],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Compile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Compile"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a compiled function which evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming numerical values of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Compile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Compile"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assumes that ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is of a type which matches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Compile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Compile"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assumes that ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is a rank ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " array of objects each of a type which matches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Compile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Compile"], "[", 
       RowBox[{
        StyleBox["vars", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["p", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["pt", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assumes that subexpressions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " which match ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are of types which match ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The types handled by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->9272],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "_Integer", Cell[
    "machine\[Hyphen]size integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "_Real", Cell["\<\
machine\[Hyphen]precision approximate real number (default) \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "_Complex", Cell["\<\
machine\[Hyphen]precision approximate complex number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "|", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[
    "logical variable ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->5911],

Cell["\<\
Nested lists given as input to a compiled function must be full arrays of \
numbers. \
\>", "Notes",
 CellID->2583],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " handles numerical functions, matrix operations, procedural programming \
constructs, list manipulation functions, functional programming constructs, \
etc. "
}], "Notes",
 CellID->2605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->2779],

Cell[TextData[{
 "Compiled code does not handle numerical precision and local variables in \
the same way as ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. "
}], "Notes",
 CellID->8560],

Cell[TextData[{
 "If a compiled function cannot be evaluated with particular arguments using \
compiled code, ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code is used instead. "
}], "Notes",
 CellID->387],

Cell[TextData[{
 "Ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code can be called from within compiled code. Results obtained from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code are assumed to be approximate real numbers, unless specified \
otherwise by the third argument of ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27845],

Cell[TextData[{
 "The number of times and the order in which objects are evaluated by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " may be different from ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. "
}], "Notes",
 CellID->25529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and does not by default do any evaluation before compilation. "
}], "Notes",
 CellID->803],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Compile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compile"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Evaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Evaluate"], "[", 
     StyleBox["expr", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " to specify that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be evaluated symbolically before compilation. "
}], "Notes",
 CellID->19651]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114591104],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->160380396],

Cell[TextData[{
 "Compile the function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["x", "TI"], "]"}], "+", 
   RowBox[{
    StyleBox["x", "TI"], "^", "2"}], "-", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      StyleBox["x", "TI"]}], ")"}]}]}]], "InlineFormula"],
 " for machine real ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->496314472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", " ", "=", " ", 
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "_Real"}], "}"}], "}"}], ",", " ", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"x", "^", "2"}], " ", "-", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347487624],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     SuperscriptBox["x", "2"], "-", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{382, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3573032]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " evaluates with machine numbers:"
}], "ExampleText",
 CellID->668920789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8065710],

Cell[BoxData["9.628151394084135`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62515527]
}, Open  ]],

Cell["Plot the compiled function:", "ExampleText",
 CellID->82259366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"cf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39138142],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFmE1oHVUUx6d5Sd6LtdXWmqSpyXu1flQb22prao0atbZatX4sbBbFRQxC
Amqlxo1udKMb3ehGQezCD7C6qFgqQgWxIBbEglgQFaSC1IVFsLgICOPvnDP3
zcx9d2YSqPhI5t2593/OPR//c+7l7Zmam3n8yam52emp1t0Hpp6emZ1+prVr
/wGmakuiKDrC/xODEeOYkf4fiWO+s8998qzJmn6ivTq7SmcPvv1NMnsLjy5A
vSXohx985+zZv2U4Lo/uFBVFPSVyj+774PTpP2U4xkPEDJ4R1wkRz8o9O3f0
xNe/LtS611/76sND3y3eOoQQXbwcpmHgQq376cc/ph/7SIZ3laDm5//ZueMt
hxKdk7p6qa5OPvL+mTN/yXBHUIeh9j/1yclvf6tCvfrK8Y8Pn6pCpbEpQ7Ed
mzqUbzWUgTjFOvp19r7dB8+dm5fhnSWo2ZnDp77/vQqVMqEM9enRH15+6QuH
Sq3u9/IV1jGgsySLlMnwjhIUilAnw+2lTBnwrL8pXhgfTe7zYz+/+MIxGW6J
y6qsSJ4SpVCL902rc9DL2LZkNeyVoZ9/7rPjX/7S1p5BhW0yqZR/LnJl6DRn
twdRq+N8FU3k8m6rUAJiuNUiHWmsy1BQgyDxLEAN6Wza5W4rQVGslKxDpVbb
Kolgp2Ida+J8Z7i1BJX6VobCKwJJbRegLovzXHY9cjKzShrQ4VY7dQx7zBkv
QdEWaA4y3OqhuoNSI57uLYuQSnk2GieVVoutwPgUs7Tp7bk5g4qS+kmrrOli
RFUKh66Py3pHS2ffe/fkm2+ccLqr0GglZnijuqu9X+siDZHEom1B1OVxvnLH
cplfp6sQDJrJ8MagDkPBanYS+8KoK1yEQPHsyLyhrnQofBWUn2lDXaWz9MBE
1w05q6/O6AjFy3Ss11lqAhTu5fKboq7RABM/gkCIGGwM4ja4OMI1Yh5dF0SN
qjbsZk9ST8g25Czf6HgBi+gh0bVBLZtUC5bTY1BEl1gfxKnf3cYAzILHUn3d
hYzXWPcQMUiPAXRW4c2aDLb4VNKc9+AZLZk2wVVVus0lyX61BTFWGdqDHNJc
QrBC8rLaw4qutO5uVhlcIz80VXYnHMmtIC/TuZ/2sV6SgKeEiC0JKKouVhOr
T/IJedaxl1RhLNtbpaAxWhaXVbTeUurgrH0jybkCeYhftDIosUtt5eiBhOSG
Pwa8XpTjz27VixZ0oZELD0/oJIxcGtR7vzwb5BldMBI6mRu4RAHVgzIPxUm9
Yz0Ri7pIuDuLpRrD0a4neevyVsX6ZuJFVtJ1Zz0zG+i1KyB7tZ2PrH8VSTZL
drQjoBHiSS7zwx0zfkysPtoxV+1RjVhioNRPtYbhSiu67Ms7t/w4d8rJXbHb
yZfaoGdlg3eoAmGMPLCBUmRm6Lz5cD4iPuLnUx51zMRYIzDVSDak9/f/r5ZL
35BMrfVktZ80qCC6DVSmOdN8qDooTjtZWain9R/bmpXx9+pTmzGPqqcOMZg6
pPyt4S2v1NdcoO31OO2c2d7g5lvJt+4ovY5WZT2UMFJ20usu9GRGPJ1WSP5v
LStUI6yhANqN0FJiN/UOCf0dIOnjFhNsSHrTeFBi0O3R7tBw1ZqtnX8dEtpf
6nQSuEK4c/1va1Ci6SKT3SPxY3M7xofacbggxM6Sd/90rcIv9t2vb13v5d3O
PiLAgGPe7+tVepeF1ju8f8B717tmX/udRBFWrgt22yApdt/syMKo4waRt9sB
cHgiZ8K6oMSmjATMs9MbbkjeWm0J4a/mXW4DEALSYY3BhoN6xxRNwLJo/BgK
ordn0IQaQuMv6IEg2u5Q8JmUgKZszJJVQfSEoqlQs8RoicMrct7pL0+9RJaA
WTM31PKgzp15tF3BCPLSIPoeTbxdu7AguS/2BbH3qub2/RD37M7eG0Tv0XcC
RfcQnWHU3pyndmuLlvwLJ1x6Ow==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23910939]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3263],

Cell[TextData[{
 "Compile function to take Newton iterations for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["z", "TI"], "^", "3"}], "-", "1"}]], "InlineFormula"],
 " and identify nearest root:"
}], "ExampleText",
 CellID->54042726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newt", " ", "=", " ", 
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", ",", "_Complex"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "_Integer"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"zn", " ", "=", " ", "z"}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"zn", " ", "=", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "zn"}], " ", "+", 
             RowBox[{"1", "/", 
              RowBox[{"zn", "^", "2"}]}]}], ")"}], "/", "3"}]}], ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "zn", "]"}], ">", "0"}], ",", "1", ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Im", "[", "zn", "]"}], ">", "0"}], ",", "2", ",", "3"}], 
          "]"}]}], "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121080347],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"z", ",", "n"}], "}"}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"zn", "=", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"zn", "=", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "zn"}], "+", 
             FractionBox["1", 
              SuperscriptBox["zn", "2"]]}], ")"}]}]}], ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "zn", "]"}], ">", "0"}], ",", "1", ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Im", "[", "zn", "]"}], ">", "0"}], ",", "2", ",", "3"}], 
          "]"}]}], "]"}]}]}], "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{467, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4285628]
}, Open  ]],

Cell["Plot the basins of attraction for the three roots:", "ExampleText",
 CellID->447273546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"newt", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", "25"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", ".01"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", ".01"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155581519],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnYmtJicMgA2dpKWUsA2kznSVf7gvYwMzBqRYWkW7b97gD2MO20z++vPP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   "], {{0, 0}, {201, 201}}, {0, 3}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->752367348]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompiledFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CompiledFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dispatch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dispatch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6708],

Cell[TextData[ButtonBox["Generating C and Fortran Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneratingCAndFortranExpressions"]], "Tutorials",\

 CellID->3359],

Cell[TextData[{
 ButtonBox["Compiling ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"]
}], "Tutorials",
 CellID->21527]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->410673353],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->217072175],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->82146330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Compile",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Compile"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Compile"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 39.5104512}", "context" -> "System`", 
    "keywords" -> {
     "compilation", "efficiency", "functions", "numerical computation", 
      "optimize", "procedures", "routines", "speed", 
      "machine number evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Compile[{x_1, x_2, ...}, expr] creates a compiled function which \
evaluates expr assuming numerical values of the x_i. Compile[{{x_1, t_1}, \
...}, expr] assumes that x_i is of a type which matches t_i. Compile[{{x_1, \
t_1, n_1}, ...}, expr] assumes that x_i is a rank n_i array of objects each \
of a type which matches t_i. Compile[vars, expr, {{p_1, pt_1}, ...}] assumes \
that subexpressions in expr which match p_i are of types which match pt_i. ", 
    "synonyms" -> {}, "title" -> "Compile", "type" -> "Symbol", "uri" -> 
    "ref/Compile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12292, 408, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114591104]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30172, 959}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2660, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3283, 89, 45, 1, 70, "ObjectName",
 CellID->31694],
Cell[3331, 92, 4205, 138, 70, "Usage",
 CellID->555]
}, Open  ]],
Cell[CellGroupData[{
Cell[7573, 235, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8051, 252, 196, 8, 70, "Notes",
 CellID->9272],
Cell[8250, 262, 1064, 27, 70, "2ColumnTableMod",
 CellID->5911],
Cell[9317, 291, 125, 4, 70, "Notes",
 CellID->2583],
Cell[9445, 297, 321, 9, 70, "Notes",
 CellID->2605],
Cell[9769, 308, 326, 12, 70, "Notes",
 CellID->2779],
Cell[10098, 322, 208, 7, 70, "Notes",
 CellID->8560],
Cell[10309, 331, 224, 7, 70, "Notes",
 CellID->387],
Cell[10536, 340, 466, 15, 70, "Notes",
 CellID->27845],
Cell[11005, 357, 331, 11, 70, "Notes",
 CellID->25529],
Cell[11339, 370, 364, 12, 70, "Notes",
 CellID->803],
Cell[11706, 384, 549, 19, 70, "Notes",
 CellID->19651]
}, Closed]],
Cell[CellGroupData[{
Cell[12292, 408, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114591104],
Cell[CellGroupData[{
Cell[12677, 422, 148, 5, 70, "ExampleSection",
 CellID->160380396],
Cell[12828, 429, 506, 20, 70, "ExampleText",
 CellID->496314472],
Cell[CellGroupData[{
Cell[13359, 453, 448, 14, 28, "Input",
 CellID->347487624],
Cell[13810, 469, 464, 16, 51, "Output",
 CellID->3573032]
}, Open  ]],
Cell[14289, 488, 234, 8, 70, "ExampleText",
 CellID->668920789],
Cell[CellGroupData[{
Cell[14548, 500, 97, 3, 28, "Input",
 CellID->8065710],
Cell[14648, 505, 174, 5, 36, "Output",
 CellID->62515527]
}, Open  ]],
Cell[14837, 513, 69, 1, 70, "ExampleText",
 CellID->82259366],
Cell[CellGroupData[{
Cell[14931, 518, 232, 8, 28, "Input",
 CellID->39138142],
Cell[15166, 528, 2192, 40, 129, "Output",
 Evaluatable->False,
 CellID->23910939]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17407, 574, 215, 7, 70, "ExampleSection",
 CellID->3263],
Cell[17625, 583, 242, 8, 70, "ExampleText",
 CellID->54042726],
Cell[CellGroupData[{
Cell[17892, 595, 1168, 36, 70, "Input",
 CellID->121080347],
Cell[19063, 633, 1143, 37, 74, "Output",
 CellID->4285628]
}, Open  ]],
Cell[20221, 673, 93, 1, 70, "ExampleText",
 CellID->447273546],
Cell[CellGroupData[{
Cell[20339, 678, 479, 16, 70, "Input",
 CellID->155581519],
Cell[20821, 696, 3419, 62, 201, "Output",
 CellID->752367348]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24301, 765, 311, 9, 70, "SeeAlsoSection",
 CellID->28192],
Cell[24615, 776, 1222, 44, 70, "SeeAlso",
 CellID->29410]
}, Open  ]],
Cell[CellGroupData[{
Cell[25874, 825, 313, 9, 70, "TutorialsSection",
 CellID->6708],
Cell[26190, 836, 180, 4, 70, "Tutorials",
 CellID->3359],
Cell[26373, 842, 419, 12, 70, "Tutorials",
 CellID->21527]
}, Open  ]],
Cell[CellGroupData[{
Cell[26829, 859, 319, 9, 70, "MoreAboutSection",
 CellID->410673353],
Cell[27151, 870, 173, 3, 70, "MoreAbout",
 CellID->217072175],
Cell[27327, 875, 147, 3, 70, "MoreAbout",
 CellID->82146330]
}, Open  ]],
Cell[CellGroupData[{
Cell[27511, 883, 305, 8, 70, "RelatedLinksSection"],
Cell[27819, 893, 359, 12, 70, "RelatedLinks"],
Cell[28181, 907, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[28581, 923, 50, 0, 70, "History"],
Cell[28634, 925, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

