(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20667,        758]
NotebookOptionsPosition[     16269,        605]
NotebookOutlinePosition[     17589,        643]
CellTagsIndexPosition[     17504,        638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists as Sets" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsAsSets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Lists as Sets\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Intersection" :> 
          Documentation`HelpLookup["paclet:ref/Intersection"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Intersection\"\>", 2->"\<\"Union\"\>", 
       3->"\<\"Take\"\>", 4->"\<\"Select\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complement", "ObjectName",
 CellID->5349],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Complement",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Complement"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["all", "TI"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the elements in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["all", "TI"]]], "InlineFormula"],
     " which are not in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The list returned by ",
 Cell[BoxData[
  ButtonBox["Complement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complement"]], "InlineFormula"],
 " is sorted into standard order. "
}], "Notes",
 CellID->17097],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Complement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complement"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["all", "TI"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["SameTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to each pair of elements in ",
 Cell[BoxData[
  StyleBox["eall", "TI"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to determine whether they should be considered the same. "
}], "Notes",
 CellID->19122]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->124205294],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->54107851],

Cell["\<\
Find which elements in the first list are not in any of the subsequent lists:\
\
\>", "ExampleText",
 CellID->4056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", "d", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "e"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6799]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2275],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complement"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "b", ",", "a"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12296],

Cell[BoxData[
 RowBox[{"f", "[", "d", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13796]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26983],

Cell["Find divisors of 20 that are not also divisors of 12:", "ExampleText",
 CellID->21556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", "20", "]"}], ",", 
   RowBox[{"Divisors", "[", "12", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "10", ",", "20"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26144],

Cell["\<\
Find which triples of digits do not occur in the binary decomposition of \
12345:\
\>", "ExampleText",
 CellID->29517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"12345", ",", "2"}], "]"}], ",", "3", ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14095],

Cell[TextData[{
 "Find which options to ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " are not also options to ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"First", "/@", 
    RowBox[{"Options", "[", "Plot", "]"}]}], ",", 
   RowBox[{"First", "/@", 
    RowBox[{"Options", "[", "Graphics", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "ColorFunction", ",", "ColorFunctionScaling", ",", "Filling", ",", 
   "FillingStyle", ",", "MaxRecursion", ",", "Mesh", ",", "MeshFunctions", 
   ",", "MeshShading", ",", "MeshStyle", ",", "PlotPoints", ",", "PlotStyle", 
   ",", "RegionFunction"}], "}"}]], "Output",
 ImageSize->{550, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21927],

Cell["\<\
Find which length-5 sequences never occur after 2 steps in any elementary \
cellular automaton:\
\>", "ExampleText",
 CellID->12303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "5"}], "]"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Last", "[", 
      RowBox[{"CellularAutomaton", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "All"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "255"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1098],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25550]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27765],

Cell[TextData[ButtonBox["Lists as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "Tutorials",
 CellID->27172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->30945010],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->732465715],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->565825566],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->67103595],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->22686586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Complement"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complement - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 39.9323370}", "context" -> "System`", 
    "keywords" -> {
     "absent from list", "difference of sets", "list complement", 
      "subtraction of sets"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Complement[e_all, e_1, e_2, ...] gives the elements in e_all which are \
not in any of the e_i. ", "synonyms" -> {}, "title" -> "Complement", "type" -> 
    "Symbol", "uri" -> "ref/Complement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5975, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->124205294]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17361, 631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2570, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3193, 87, 47, 1, 70, "ObjectName",
 CellID->5349],
Cell[3243, 90, 1052, 35, 70, "Usage",
 CellID->26229]
}, Open  ]],
Cell[CellGroupData[{
Cell[4332, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4810, 147, 229, 8, 70, "Notes",
 CellID->17097],
Cell[5042, 157, 896, 32, 70, "Notes",
 CellID->19122]
}, Closed]],
Cell[CellGroupData[{
Cell[5975, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->124205294],
Cell[CellGroupData[{
Cell[6360, 208, 147, 5, 70, "ExampleSection",
 CellID->54107851],
Cell[6510, 215, 125, 4, 70, "ExampleText",
 CellID->4056],
Cell[CellGroupData[{
Cell[6660, 223, 287, 9, 28, "Input",
 CellID->24453],
Cell[6950, 234, 198, 7, 36, "Output",
 CellID->6799]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7197, 247, 238, 7, 70, "ExampleSection",
 CellID->2275],
Cell[7438, 256, 324, 12, 70, "ExampleText",
 CellID->3188],
Cell[CellGroupData[{
Cell[7787, 272, 327, 10, 70, "Input",
 CellID->12296],
Cell[8117, 284, 181, 6, 36, "Output",
 CellID->13796]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8347, 296, 223, 7, 70, "ExampleSection",
 CellID->26983],
Cell[8573, 305, 92, 1, 70, "ExampleText",
 CellID->21556],
Cell[CellGroupData[{
Cell[8690, 310, 198, 6, 70, "Input",
 CellID->6979],
Cell[8891, 318, 211, 7, 36, "Output",
 CellID->12703]
}, Open  ]],
Cell[9117, 328, 121, 3, 70, "ExampleDelimiter",
 CellID->26144],
Cell[9241, 333, 128, 4, 70, "ExampleText",
 CellID->29517],
Cell[CellGroupData[{
Cell[9394, 341, 386, 13, 70, "Input",
 CellID->22376],
Cell[9783, 356, 317, 11, 36, "Output",
 CellID->9504]
}, Open  ]],
Cell[10115, 370, 121, 3, 70, "ExampleDelimiter",
 CellID->14095],
Cell[10239, 375, 341, 13, 70, "ExampleText",
 CellID->5230],
Cell[CellGroupData[{
Cell[10605, 392, 265, 8, 70, "Input",
 CellID->30074],
Cell[10873, 402, 436, 11, 54, "Output",
 CellID->3789]
}, Open  ]],
Cell[11324, 416, 121, 3, 70, "ExampleDelimiter",
 CellID->21927],
Cell[11448, 421, 142, 4, 70, "ExampleText",
 CellID->12303],
Cell[CellGroupData[{
Cell[11615, 429, 630, 20, 70, "Input",
 CellID->7586],
Cell[12248, 451, 359, 12, 36, "Output",
 CellID->374]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12668, 470, 310, 9, 70, "SeeAlsoSection",
 CellID->1098],
Cell[12981, 481, 931, 35, 70, "SeeAlso",
 CellID->25550]
}, Open  ]],
Cell[CellGroupData[{
Cell[13949, 521, 314, 9, 70, "TutorialsSection",
 CellID->27765],
Cell[14266, 532, 135, 3, 70, "Tutorials",
 CellID->27172]
}, Open  ]],
Cell[CellGroupData[{
Cell[14438, 540, 318, 9, 70, "MoreAboutSection",
 CellID->30945010],
Cell[14759, 551, 157, 3, 70, "MoreAbout",
 CellID->732465715],
Cell[14919, 556, 151, 3, 70, "MoreAbout",
 CellID->565825566],
Cell[15073, 561, 189, 4, 70, "MoreAbout",
 CellID->67103595],
Cell[15265, 567, 176, 3, 70, "MoreAbout",
 CellID->22686586]
}, Open  ]],
Cell[CellGroupData[{
Cell[15478, 575, 305, 8, 70, "RelatedLinksSection"],
Cell[15786, 585, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[16189, 601, 50, 0, 70, "History"],
Cell[16242, 603, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

