(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58508,       1899]
NotebookOptionsPosition[     48662,       1550]
NotebookOutlinePosition[     49884,       1585]
CellTagsIndexPosition[     49798,       1580]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Types of Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complexes" :> Documentation`HelpLookup["paclet:ref/Complexes"],
           "Real" :> Documentation`HelpLookup["paclet:ref/Real"], "Re" :> 
          Documentation`HelpLookup["paclet:ref/Re"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Conjugate" :> 
          Documentation`HelpLookup["paclet:ref/Conjugate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Complexes\"\>", 2->"\<\"Real\"\>", 
       3->"\<\"Re\"\>", 4->"\<\"Im\"\>", 5->"\<\"I\"\>", 
       6->"\<\"ComplexExpand\"\>", 
       7->"\<\"Conjugate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Complex Numbers\"\>", 
       3->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complex", "ObjectName",
 CellID->27886],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
     "\[LineSeparator]is the head used for complex numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can enter a complex number in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25066],

Cell[TextData[{
 Cell[BoxData["_Complex"], "InlineFormula"],
 " can be used to stand for a complex number in a pattern. "
}], "Notes",
 CellID->27054],

Cell[TextData[{
 "You have to use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 " to extract parts of ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers. "
}], "Notes",
 CellID->3369]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274359065],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->442220277],

Cell["Enter a complex number:", "ExampleText",
 CellID->178604635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", " ", "+", 
  RowBox[{"2", " ", "I"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36305829],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367988106]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " for complex numbers:"
}], "ExampleText",
 CellID->40731330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8742535],

Cell[BoxData["Complex"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->770583611]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->103243490],

Cell["Enter a purely imaginary number:", "ExampleText",
 CellID->115335823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"4", " ", "I"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789127860],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66525825]
}, Open  ]],

Cell[TextData[{
 "Even though there is no real part it has ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->285503907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207263322],

Cell[BoxData["Complex"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->367424843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->663096904],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a complex number ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->482898940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150288166],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"1", ",", "2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->422550514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145540696],

Cell[TextData[{
 "Enter a complex number using the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->537439717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complex", "[", 
  RowBox[{"2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94567799],

Cell[BoxData[
 RowBox[{"2", "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290397283]
}, Open  ]],

Cell[TextData[{
 "If the imaginary part is exactly zero, then the result is not ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->618591432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complex", "[", 
  RowBox[{"2", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100929683],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349828810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->98839216],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->186564283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781067295],

Cell[TextData[{
 "You have to use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 " to extract parts of ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->427742512],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "I"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308751861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "x", "]"}], ",", 
   RowBox[{"Im", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->737728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75331014]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " does not work:"
}], "ExampleText",
 CellID->201773440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->291925190],

Cell[BoxData[
 RowBox[{
  RowBox[{"Part", "::", "\<\"partd\"\>"}], ":", 
  " ", "\<\"Part specification \\!\\(\\(\\((1 + \\(\\(2\\\\ \
\[ImaginaryI]\\)\\))\\)\\) \[LeftDoubleBracket] 1 \[RightDoubleBracket]\\) is \
longer than depth of object. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partd\\\", ButtonNote -> \
\\\"Part::partd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->135821951],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], "\[LeftDoubleBracket]", "1",
   "\[RightDoubleBracket]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->401015604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8764060],

Cell["\<\
Enter a complex number with machine-number real and imaginary parts:\
\>", "ExampleText",
 CellID->758623237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "+", 
  RowBox[{"2.", "I"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323284923],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305141461]
}, Open  ]],

Cell["\<\
It is considered a machine number when both real and imaginary parts are:\
\>", "ExampleText",
 CellID->133063103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->717652741],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108869328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98436132],

Cell["\<\
Enter a complex number with arbitrary-precision real and imaginary parts:\
\>", "ExampleText",
 CellID->10436801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1`20", "+", 
  RowBox[{"2`30", " ", "I"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268577447],

Cell[BoxData[
 RowBox[{"1.`20.", "+", 
  RowBox[{"2.`30.", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126377913]
}, Open  ]],

Cell["The precision is based on the error in the complex plane:", \
"ExampleText",
 CellID->223974864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8085446],

Cell[BoxData["20.349485002168013`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1753416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42385307],

Cell["\<\
Enter a complex number with an exact real part and approximate imaginary \
part:\
\>", "ExampleText",
 CellID->695796675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"1", "+", 
   RowBox[{"2.", "I"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227655983],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222591274]
}, Open  ]],

Cell["The exactness is kept in computations when possible:", "ExampleText",
 CellID->626359770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", " ", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9089566],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.`"}], "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484929604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "^", "2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->238400842],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.`"}], "+", 
  RowBox[{"4.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->324903797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208905301],

Cell[TextData[{
 Cell[BoxData["_Complex"], "InlineFormula"],
 " can be used to stand for a complex number in a pattern:"
}], "ExampleText",
 CellID->142694097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "I"}]}], ",", "_Complex"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25499390],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->604121434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263294411],

Cell["A rule that switches real and imaginary parts:", "ExampleText",
 CellID->400411987],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", "=", " ", 
   RowBox[{"x_Complex", "\[Rule]", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "+", 
     RowBox[{"I", " ", 
      RowBox[{"Re", "[", "x", "]"}]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107777264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"4", " ", "I"}]}], ",", "5"}], "]"}], " ", "/.", " ", 
  "rule"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->573968836],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"2", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"4", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", "5"}], "]"}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101380876]
}, Open  ]],

Cell["An alternate definition:", "ExampleText",
 CellID->303155929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"4", " ", "I"}]}], ",", "5"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"Complex", "[", 
    RowBox[{"r_", ",", "i_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Complex", "[", 
    RowBox[{"i", ",", "r"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66023991],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"2", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"4", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", "5"}], "]"}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->427051488]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->701201825],

Cell["\<\
Define a function over the complexes by using functions defined over the \
reals: \
\>", "ExampleText",
 CellID->506644916],

Cell[BoxData[
 RowBox[{
  RowBox[{"cosine", "[", "x_Complex", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"Re", "[", "x", "]"}], "]"}], 
    RowBox[{"Cosh", "[", 
     RowBox[{"Im", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{"I", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"Re", "[", "x", "]"}], "]"}], 
    RowBox[{"Sinh", "[", 
     RowBox[{"Im", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124463694],

Cell[BoxData[
 RowBox[{
  RowBox[{"cosine", "[", "x_Real", "]"}], ":=", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125318842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"cosine", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->125627945],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->700220200]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->408036812],

Cell["Complexes are numbers:", "ExampleText",
 CellID->355041735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "I"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272480802],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174880277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180935095],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->927488544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->381237685],

Cell["Complexes are atomic objects with no subexpressions:", "ExampleText",
 CellID->55292171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356562248],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245115557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58801619],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 " to indicate assumptions on domain conditions: "
}], "ExampleText",
 CellID->303528404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", " ", 
     RowBox[{"Conjugate", "[", "z", "]"}]}], "<", "1"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164855179],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", 
   RowBox[{"Re", "[", "z", "]"}], "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
   RowBox[{"Im", "[", "z", "]"}], "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}]], "Output",
 ImageSize->{337, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65065283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->172479399],

Cell[TextData[{
 "Numbers entered in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 " only become ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers on evaluation:"
}], "ExampleText",
 CellID->257534041],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_Complex", "]"}], ":=", 
  RowBox[{
   RowBox[{"Re", "[", "x", "]"}], "-", 
   RowBox[{"Im", "[", "x", "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->296022512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17833755],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[ImaginaryI]"}]}], "]"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330884538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37264585],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20682661]
}, Open  ]],

Cell[TextData[{
 "The unevaluated form is expressed in terms of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->379399591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"HoldForm", "[", 
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"2", " ", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->140518944],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldForm", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Times", "[", 
       RowBox[{"2", ",", "\\[ImaginaryI]"}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->186599502]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9859],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complexes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complexes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29546]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14038],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->28712]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->235678395],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->3286955],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->213773046],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->148807981]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 49.2138246}", "context" -> "System`", 
    "keywords" -> {"complex numbers", "imaginary numbers", "complex plane"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Complex is the head used for complex numbers. ", "synonyms" -> {}, 
    "title" -> "Complex", "type" -> "Symbol", "uri" -> "ref/Complex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5133, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->274359065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49655, 1573}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2599, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3222, 86, 45, 1, 70, "ObjectName",
 CellID->27886],
Cell[3270, 89, 418, 13, 70, "Usage",
 CellID->8025]
}, Open  ]],
Cell[CellGroupData[{
Cell[3725, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4203, 124, 292, 12, 70, "Notes",
 CellID->25066],
Cell[4498, 138, 150, 4, 70, "Notes",
 CellID->27054],
Cell[4651, 144, 445, 18, 70, "Notes",
 CellID->3369]
}, Closed]],
Cell[CellGroupData[{
Cell[5133, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274359065],
Cell[CellGroupData[{
Cell[5518, 181, 148, 5, 70, "ExampleSection",
 CellID->442220277],
Cell[5669, 188, 66, 1, 70, "ExampleText",
 CellID->178604635],
Cell[CellGroupData[{
Cell[5760, 193, 119, 4, 28, "Input",
 CellID->36305829],
Cell[5882, 199, 215, 7, 36, "Output",
 CellID->367988106]
}, Open  ]],
Cell[6112, 209, 319, 12, 70, "ExampleText",
 CellID->40731330],
Cell[CellGroupData[{
Cell[6456, 225, 98, 3, 28, "Input",
 CellID->8742535],
Cell[6557, 230, 164, 5, 36, "Output",
 CellID->770583611]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6770, 241, 220, 7, 70, "ExampleSection",
 CellID->103243490],
Cell[6993, 250, 75, 1, 70, "ExampleText",
 CellID->115335823],
Cell[CellGroupData[{
Cell[7093, 255, 92, 3, 70, "Input",
 CellID->789127860],
Cell[7188, 260, 191, 6, 36, "Output",
 CellID->66525825]
}, Open  ]],
Cell[7394, 269, 339, 13, 70, "ExampleText",
 CellID->285503907],
Cell[CellGroupData[{
Cell[7758, 286, 100, 3, 70, "Input",
 CellID->207263322],
Cell[7861, 291, 164, 5, 36, "Output",
 CellID->367424843]
}, Open  ]],
Cell[8040, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->663096904],
Cell[8168, 304, 630, 26, 70, "ExampleText",
 CellID->482898940],
Cell[CellGroupData[{
Cell[8823, 334, 151, 5, 70, "Input",
 CellID->150288166],
Cell[8977, 341, 349, 13, 50, "Output",
 CellID->422550514]
}, Open  ]],
Cell[9341, 357, 125, 3, 70, "ExampleDelimiter",
 CellID->145540696],
Cell[9469, 362, 216, 8, 70, "ExampleText",
 CellID->537439717],
Cell[CellGroupData[{
Cell[9710, 374, 125, 4, 70, "Input",
 CellID->94567799],
Cell[9838, 380, 192, 6, 36, "Output",
 CellID->290397283]
}, Open  ]],
Cell[10045, 389, 243, 8, 70, "ExampleText",
 CellID->618591432],
Cell[CellGroupData[{
Cell[10313, 401, 126, 4, 70, "Input",
 CellID->100929683],
Cell[10442, 407, 158, 5, 36, "Output",
 CellID->349828810]
}, Open  ]],
Cell[CellGroupData[{
Cell[10637, 417, 99, 3, 70, "Input",
 CellID->98839216],
Cell[10739, 422, 164, 5, 36, "Output",
 CellID->186564283]
}, Open  ]],
Cell[10918, 430, 125, 3, 70, "ExampleDelimiter",
 CellID->781067295],
Cell[11046, 435, 455, 18, 70, "ExampleText",
 CellID->427742512],
Cell[11504, 455, 159, 6, 70, "Input",
 CellID->308751861],
Cell[CellGroupData[{
Cell[11688, 465, 172, 6, 70, "Input",
 CellID->737728],
Cell[11863, 473, 202, 7, 36, "Output",
 CellID->75331014]
}, Open  ]],
Cell[12080, 483, 184, 7, 70, "ExampleText",
 CellID->201773440],
Cell[CellGroupData[{
Cell[12289, 494, 120, 4, 70, "Input",
 CellID->291925190],
Cell[12412, 500, 479, 9, 70, "Message",
 CellID->135821951],
Cell[12894, 511, 311, 10, 36, "Output",
 CellID->401015604]
}, Open  ]],
Cell[13220, 524, 123, 3, 70, "ExampleDelimiter",
 CellID->8764060],
Cell[13346, 529, 119, 3, 70, "ExampleText",
 CellID->758623237],
Cell[CellGroupData[{
Cell[13490, 536, 112, 4, 70, "Input",
 CellID->323284923],
Cell[13605, 542, 240, 7, 36, "Output",
 CellID->305141461]
}, Open  ]],
Cell[13860, 552, 124, 3, 70, "ExampleText",
 CellID->133063103],
Cell[CellGroupData[{
Cell[14009, 559, 110, 3, 70, "Input",
 CellID->717652741],
Cell[14122, 564, 161, 5, 36, "Output",
 CellID->108869328]
}, Open  ]],
Cell[14298, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->98436132],
Cell[14425, 577, 123, 3, 70, "ExampleText",
 CellID->10436801],
Cell[CellGroupData[{
Cell[14573, 584, 121, 4, 70, "Input",
 CellID->268577447],
Cell[14697, 590, 226, 7, 36, "Output",
 CellID->126377913]
}, Open  ]],
Cell[14938, 600, 102, 2, 70, "ExampleText",
 CellID->223974864],
Cell[CellGroupData[{
Cell[15065, 606, 103, 3, 70, "Input",
 CellID->8085446],
Cell[15171, 611, 174, 5, 36, "Output",
 CellID->1753416]
}, Open  ]],
Cell[15360, 619, 124, 3, 70, "ExampleDelimiter",
 CellID->42385307],
Cell[15487, 624, 131, 4, 70, "ExampleText",
 CellID->695796675],
Cell[CellGroupData[{
Cell[15643, 632, 135, 5, 70, "Input",
 CellID->227655983],
Cell[15781, 639, 217, 7, 36, "Output",
 CellID->222591274]
}, Open  ]],
Cell[16013, 649, 95, 1, 70, "ExampleText",
 CellID->626359770],
Cell[CellGroupData[{
Cell[16133, 654, 90, 3, 70, "Input",
 CellID->9089566],
Cell[16226, 659, 212, 7, 36, "Output",
 CellID->484929604]
}, Open  ]],
Cell[CellGroupData[{
Cell[16475, 671, 92, 3, 70, "Input",
 CellID->238400842],
Cell[16570, 676, 237, 8, 36, "Output",
 CellID->324903797]
}, Open  ]],
Cell[16822, 687, 125, 3, 70, "ExampleDelimiter",
 CellID->208905301],
Cell[16950, 692, 159, 4, 70, "ExampleText",
 CellID->142694097],
Cell[CellGroupData[{
Cell[17134, 700, 180, 6, 70, "Input",
 CellID->25499390],
Cell[17317, 708, 161, 5, 36, "Output",
 CellID->604121434]
}, Open  ]],
Cell[17493, 716, 125, 3, 70, "ExampleDelimiter",
 CellID->263294411],
Cell[17621, 721, 89, 1, 70, "ExampleText",
 CellID->400411987],
Cell[17713, 724, 272, 9, 70, "Input",
 CellID->107777264],
Cell[CellGroupData[{
Cell[18010, 737, 273, 10, 70, "Input",
 CellID->573968836],
Cell[18286, 749, 316, 10, 36, "Output",
 CellID->101380876]
}, Open  ]],
Cell[18617, 762, 67, 1, 70, "ExampleText",
 CellID->303155929],
Cell[CellGroupData[{
Cell[18709, 767, 414, 14, 70, "Input",
 CellID->66023991],
Cell[19126, 783, 316, 10, 36, "Output",
 CellID->427051488]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19491, 799, 227, 7, 70, "ExampleSection",
 CellID->701201825],
Cell[19721, 808, 133, 4, 70, "ExampleText",
 CellID->506644916],
Cell[19857, 814, 463, 15, 70, "Input",
 CellID->124463694],
Cell[20323, 831, 161, 5, 70, "Input",
 CellID->125318842],
Cell[CellGroupData[{
Cell[20509, 840, 414, 14, 70, "Input",
 CellID->125627945],
Cell[20926, 856, 18647, 310, 70, "Output",
 Evaluatable->False,
 CellID->700220200]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39622, 1172, 237, 7, 70, "ExampleSection",
 CellID->408036812],
Cell[39862, 1181, 65, 1, 70, "ExampleText",
 CellID->355041735],
Cell[CellGroupData[{
Cell[39952, 1186, 115, 4, 70, "Input",
 CellID->272480802],
Cell[40070, 1192, 215, 7, 36, "Output",
 CellID->174880277]
}, Open  ]],
Cell[CellGroupData[{
Cell[40322, 1204, 103, 3, 70, "Input",
 CellID->180935095],
Cell[40428, 1209, 161, 5, 36, "Output",
 CellID->927488544]
}, Open  ]],
Cell[40604, 1217, 125, 3, 70, "ExampleDelimiter",
 CellID->381237685],
Cell[40732, 1222, 94, 1, 70, "ExampleText",
 CellID->55292171],
Cell[CellGroupData[{
Cell[40851, 1227, 148, 5, 70, "Input",
 CellID->356562248],
Cell[41002, 1234, 161, 5, 36, "Output",
 CellID->245115557]
}, Open  ]],
Cell[41178, 1242, 124, 3, 70, "ExampleDelimiter",
 CellID->58801619],
Cell[41305, 1247, 235, 8, 70, "ExampleText",
 CellID->303528404],
Cell[CellGroupData[{
Cell[41565, 1259, 235, 8, 70, "Input",
 CellID->164855179],
Cell[41803, 1269, 545, 20, 45, "Output",
 CellID->65065283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42397, 1295, 230, 7, 70, "ExampleSection",
 CellID->172479399],
Cell[42630, 1304, 443, 17, 70, "ExampleText",
 CellID->257534041],
Cell[43076, 1323, 312, 10, 70, "Input",
 CellID->296022512],
Cell[CellGroupData[{
Cell[43413, 1337, 143, 5, 70, "Input",
 CellID->17833755],
Cell[43559, 1344, 244, 8, 36, "Output",
 CellID->330884538]
}, Open  ]],
Cell[CellGroupData[{
Cell[43840, 1357, 180, 6, 70, "Input",
 CellID->37264585],
Cell[44023, 1365, 174, 6, 36, "Output",
 CellID->20682661]
}, Open  ]],
Cell[44212, 1374, 344, 13, 70, "ExampleText",
 CellID->379399591],
Cell[CellGroupData[{
Cell[44581, 1391, 198, 6, 70, "Input",
 CellID->140518944],
Cell[44782, 1399, 462, 16, 50, "Output",
 CellID->186599502]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45305, 1422, 310, 9, 70, "SeeAlsoSection",
 CellID->9859],
Cell[45618, 1433, 1644, 62, 70, "SeeAlso",
 CellID->29546]
}, Open  ]],
Cell[CellGroupData[{
Cell[47299, 1500, 314, 9, 70, "TutorialsSection",
 CellID->14038],
Cell[47616, 1511, 141, 3, 70, "Tutorials",
 CellID->28712]
}, Open  ]],
Cell[CellGroupData[{
Cell[47794, 1519, 319, 9, 70, "MoreAboutSection",
 CellID->235678395],
Cell[48116, 1530, 167, 3, 70, "MoreAbout",
 CellID->3286955],
Cell[48286, 1535, 141, 3, 70, "MoreAbout",
 CellID->213773046],
Cell[48430, 1540, 160, 3, 70, "MoreAbout",
 CellID->148807981]
}, Open  ]],
Cell[48605, 1546, 27, 0, 70, "History"],
Cell[48635, 1548, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

