(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40936,       1422]
NotebookOptionsPosition[     34283,       1196]
NotebookOutlinePosition[     35776,       1236]
CellTagsIndexPosition[     35690,       1231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Expressions Involving Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExpressionsInvolvingComplexVariables"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Expressions Involving Complex Variables\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GaussianIntegers" :> 
          Documentation`HelpLookup["paclet:ref/GaussianIntegers"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"], 
          "ExpToTrig" :> Documentation`HelpLookup["paclet:ref/ExpToTrig"], 
          "TrigExpand" :> Documentation`HelpLookup["paclet:ref/TrigExpand"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], 
          "PowerExpand" :> Documentation`HelpLookup["paclet:ref/PowerExpand"],
           "Abs" :> Documentation`HelpLookup["paclet:ref/Abs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GaussianIntegers\"\>", 
       2->"\<\"TrigToExp\"\>", 3->"\<\"ExpToTrig\"\>", 
       4->"\<\"TrigExpand\"\>", 5->"\<\"FunctionExpand\"\>", 
       6->"\<\"PowerExpand\"\>", 7->"\<\"Abs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 2->"\<\"Complex Numbers\"\>", 
       3->"\<\"Formula Manipulation\"\>", 
       4->"\<\"Functions of Complex Variables\"\>", 
       5->"\<\"Hyperbolic Functions\"\>", 
       6->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ComplexExpand", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ComplexExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ComplexExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming that all variables are real. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ComplexExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ComplexExpand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming that variables matching any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are complex. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16836]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The variables given in the second argument of ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " can be patterns. "
}], "Notes",
 CellID->19174],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["TargetFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TargetFunctions"]], "InlineFormula"],
 " can be given as a list of functions from the set ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], ",", 
    ButtonBox["Im",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Im"], ",", 
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], ",", 
    ButtonBox["Arg",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Arg"], ",", 
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], ",", 
    ButtonBox["Sign",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sign"]}], "}"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " will try to give results in terms of functions specified. "
}], "Notes",
 CellID->18490],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    RowBox[{
     ButtonBox["TargetFunctions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TargetFunctions"], "->", 
     RowBox[{"{", 
      RowBox[{
       ButtonBox["Abs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Abs"], ",", 
       ButtonBox["Arg",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arg"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " converts to polar coordinates. "
}], "Notes",
 CellID->20198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333073921],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->76277834],

Cell[TextData[{
 "Assume both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " are real:"
}], "ExampleText",
 CellID->30102464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", " ", "+", " ", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188859825],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259951832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215397],

Cell[TextData[{
 "Take ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to be complex:"
}], "ExampleText",
 CellID->216575424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352545737],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Re", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"Re", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}]}]}]], "Output",
 ImageSize->{328, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560341642]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11955],

Cell["Polynomials:", "ExampleText",
 CellID->41332175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"z", "^", "5"}], "-", 
     RowBox[{"2", 
      RowBox[{"z", "^", "3"}]}], "-", "z", "+", "1"}], "]"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767687620],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"Re", "[", "z", "]"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox[
    RowBox[{"Im", "[", "z", "]"}], "2"], " ", 
   RowBox[{"Re", "[", "z", "]"}]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox[
    RowBox[{"Im", "[", "z", "]"}], "4"], " ", 
   RowBox[{"Re", "[", "z", "]"}]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Re", "[", "z", "]"}], "3"]}], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox[
    RowBox[{"Im", "[", "z", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Re", "[", "z", "]"}], "3"]}], "+", 
  SuperscriptBox[
   RowBox[{"Re", "[", "z", "]"}], "5"]}]], "Output",
 ImageSize->{491, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231386327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->869407952],

Cell["Trigonometric and hyperbolic functions:", "ExampleText",
 CellID->235555410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "+", 
    RowBox[{"Tanh", "[", "z", "]"}]}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470172048],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", 
        RowBox[{"Im", "[", "z", "]"}]}], "]"}], 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", 
         RowBox[{"Im", "[", "z", "]"}]}], "]"}], "+", 
       RowBox[{"Cosh", "[", 
        RowBox[{"2", " ", 
         RowBox[{"Re", "[", "z", "]"}]}], "]"}]}]], "-", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"Sinh", "[", "y", "]"}]}]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{"Sinh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Re", "[", "z", "]"}]}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Im", "[", "z", "]"}]}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Re", "[", "z", "]"}]}], "]"}]}]]}]], "Output",
 ImageSize->{436, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401871495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226616805],

Cell["Inverse trigonometric and inverse hyperbolic functions:", "ExampleText",
 CellID->84003536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "+", 
   RowBox[{"Im", "[", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{"x", "-", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188312547],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Arg", "[", 
    RowBox[{"1", "-", 
     FractionBox["\[ImaginaryI]", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Arg", "[", 
    RowBox[{"1", "+", 
     FractionBox["\[ImaginaryI]", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]]}], "]"}]}], "+", 
  RowBox[{"Arg", "[", 
   RowBox[{"x", "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "-", 
    RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}]}]], "Output",
 ImageSize->{439, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28302658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235552423],

Cell["Exponential and logarithmic functions:", "ExampleText",
 CellID->108778115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"2", "^", "z"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "z"}], "]"}]}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155354850],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"Re", "[", "z", "]"}]], " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Arg", "[", "z", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", "2", "]"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Im", "[", "z", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Re", "[", "z", "]"}], "2"]}], "]"}]}]}], ")"}], 
     "2"]}]]}]], "Output",
 ImageSize->{337, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452927104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->585195240],

Cell["Composition of functions:", "ExampleText",
 CellID->211408762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{"Log", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "^", "2"}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258780342],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "y"}], "]"}]}], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "y"}], "]"}]}], "]"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "y"}], "]"}]}], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "y"}], "]"}]}], "]"}], "2"]}]}], "]"}]}]], "Output",\

 ImageSize->{546, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38943695]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->129461154],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TargetFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->121009123],

Cell[TextData[{
 "This gives an answer in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->232849444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259679931],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"Re", "[", "z", "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Re", "[", "z", "]"}]}], "]"}], "+", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Im", "[", "z", "]"}]}], "]"}]}]]], "Output",
 ImageSize->{188, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535271795]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TargetFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TargetFunctions"], "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], ",", " ", 
     ButtonBox["Arg",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Arg"]}], "}"}]}]], "InlineFormula"],
 ", the answer is given in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->928234448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z", ",", 
   RowBox[{"TargetFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Abs", ",", "Arg"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->537888765],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"Abs", "[", "z", "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Abs", "[", "z", "]"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}], "+", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Abs", "[", "z", "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}]}]]], "Output",
 ImageSize->{362, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237124664]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " as target function:"
}], "ExampleText",
 CellID->146983311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z", ",", 
   RowBox[{"TargetFunctions", "\[Rule]", "Conjugate"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259975017],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"z", "+", 
    RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"z", "-", 
     RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}], "+", 
   RowBox[{"Cos", "[", 
    RowBox[{"z", "+", 
     RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}]}]]], "Output",
 ImageSize->{298, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->273731987]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23672],

Cell[TextData[{
 "This computes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], "[", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    RowBox[{
     StyleBox["x", "TI"], "+", 
     RowBox[{
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"], " ", 
      StyleBox["y", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 " assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " are real:"
}], "ExampleText",
 CellID->7288997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86136305],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cosh", "[", "y", "]"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6516850]
}, Open  ]],

Cell[TextData[{
 "The same computation can be done using ",
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20945845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115758487],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358751257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Re", "[", "%", "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15680323],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cosh", "[", "y", "]"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109362108]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4376],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpToTrig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpToTrig"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27325]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6901],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->831],

Cell[TextData[ButtonBox["Expressions Involving Complex Variables",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsInvolvingComplexVariables"]], "Tutorials",
 CellID->24305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->183989483],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->17521599],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->414031040],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->365606096],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->282546],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->197461491],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->40003940]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComplexExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 40.5573530}", "context" -> "System`", 
    "keywords" -> {
     "expanding into polar form", "expanding into real and imaginary parts", 
      "symbolic complex expressions", "symbolic frequency analysis"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ComplexExpand[expr] expands expr assuming that all variables are real. \
ComplexExpand[expr, {x_1, x_2, ...}] expands expr assuming that variables \
matching any of the x_i are complex. ", "synonyms" -> {"complex expand"}, 
    "title" -> "ComplexExpand", "type" -> "Symbol", "uri" -> 
    "ref/ComplexExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12738, 345, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->333073921]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35546, 1224}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3492, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4115, 103, 4197, 83, 70, "ObjectNameGrid"],
Cell[8315, 188, 1426, 45, 70, "Usage",
 CellID->16836]
}, Open  ]],
Cell[CellGroupData[{
Cell[9778, 238, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10256, 255, 246, 8, 70, "Notes",
 CellID->19174],
Cell[10505, 265, 1044, 35, 70, "Notes",
 CellID->18490],
Cell[11552, 302, 677, 23, 70, "Notes",
 CellID->20198],
Cell[12232, 327, 469, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[12738, 345, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333073921],
Cell[CellGroupData[{
Cell[13123, 359, 147, 5, 70, "ExampleSection",
 CellID->76277834],
Cell[13273, 366, 208, 9, 70, "ExampleText",
 CellID->30102464],
Cell[CellGroupData[{
Cell[13506, 379, 198, 6, 28, "Input",
 CellID->188859825],
Cell[13707, 387, 375, 12, 36, "Output",
 CellID->259951832]
}, Open  ]],
Cell[14097, 402, 122, 3, 70, "ExampleDelimiter",
 CellID->215397],
Cell[14222, 407, 140, 6, 70, "ExampleText",
 CellID->216575424],
Cell[CellGroupData[{
Cell[14387, 417, 163, 5, 70, "Input",
 CellID->352545737],
Cell[14553, 424, 499, 16, 36, "Output",
 CellID->560341642]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15101, 446, 216, 7, 70, "ExampleSection",
 CellID->11955],
Cell[15320, 455, 54, 1, 70, "ExampleText",
 CellID->41332175],
Cell[CellGroupData[{
Cell[15399, 460, 284, 10, 70, "Input",
 CellID->767687620],
Cell[15686, 472, 777, 25, 36, "Output",
 CellID->231386327]
}, Open  ]],
Cell[16478, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->869407952],
Cell[16606, 505, 82, 1, 70, "ExampleText",
 CellID->235555410],
Cell[CellGroupData[{
Cell[16713, 510, 298, 10, 70, "Input",
 CellID->470172048],
Cell[17014, 522, 1122, 37, 85, "Output",
 CellID->401871495]
}, Open  ]],
Cell[18151, 562, 125, 3, 70, "ExampleDelimiter",
 CellID->226616805],
Cell[18279, 567, 97, 1, 70, "ExampleText",
 CellID->84003536],
Cell[CellGroupData[{
Cell[18401, 572, 369, 12, 70, "Input",
 CellID->188312547],
Cell[18773, 586, 886, 30, 54, "Output",
 CellID->28302658]
}, Open  ]],
Cell[19674, 619, 125, 3, 70, "ExampleDelimiter",
 CellID->235552423],
Cell[19802, 624, 81, 1, 70, "ExampleText",
 CellID->108778115],
Cell[CellGroupData[{
Cell[19908, 629, 269, 9, 70, "Input",
 CellID->155354850],
Cell[20180, 640, 711, 25, 60, "Output",
 CellID->452927104]
}, Open  ]],
Cell[20906, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->585195240],
Cell[21034, 673, 68, 1, 70, "ExampleText",
 CellID->211408762],
Cell[CellGroupData[{
Cell[21127, 678, 321, 11, 70, "Input",
 CellID->258780342],
Cell[21451, 691, 1225, 40, 51, "Output",
 CellID->38943695]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22725, 737, 222, 7, 70, "ExampleSection",
 CellID->129461154],
Cell[CellGroupData[{
Cell[22972, 748, 236, 7, 70, "ExampleSubsection",
 CellID->121009123],
Cell[23211, 757, 423, 17, 70, "ExampleText",
 CellID->232849444],
Cell[CellGroupData[{
Cell[23659, 778, 194, 6, 70, "Input",
 CellID->259679931],
Cell[23856, 786, 464, 16, 53, "Output",
 CellID->535271795]
}, Open  ]],
Cell[24335, 805, 812, 31, 70, "ExampleText",
 CellID->928234448],
Cell[CellGroupData[{
Cell[25172, 840, 303, 9, 70, "Input",
 CellID->537888765],
Cell[25478, 851, 696, 22, 53, "Output",
 CellID->237124664]
}, Open  ]],
Cell[26189, 876, 208, 8, 70, "ExampleText",
 CellID->146983311],
Cell[CellGroupData[{
Cell[26422, 888, 256, 7, 70, "Input",
 CellID->259975017],
Cell[26681, 897, 484, 16, 53, "Output",
 CellID->273731987]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27226, 920, 233, 7, 70, "ExampleSection",
 CellID->23672],
Cell[27462, 929, 648, 26, 70, "ExampleText",
 CellID->7288997],
Cell[CellGroupData[{
Cell[28135, 959, 219, 7, 70, "Input",
 CellID->86136305],
Cell[28357, 968, 239, 8, 36, "Output",
 CellID->6516850]
}, Open  ]],
Cell[28611, 979, 350, 13, 70, "ExampleText",
 CellID->20945845],
Cell[CellGroupData[{
Cell[28986, 996, 185, 6, 70, "Input",
 CellID->115758487],
Cell[29174, 1004, 375, 12, 36, "Output",
 CellID->358751257]
}, Open  ]],
Cell[CellGroupData[{
Cell[29586, 1021, 244, 8, 70, "Input",
 CellID->15680323],
Cell[29833, 1031, 241, 8, 36, "Output",
 CellID->109362108]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30135, 1046, 310, 9, 70, "SeeAlsoSection",
 CellID->4376],
Cell[30448, 1057, 1708, 62, 70, "SeeAlso",
 CellID->27325]
}, Open  ]],
Cell[CellGroupData[{
Cell[32193, 1124, 313, 9, 70, "TutorialsSection",
 CellID->6901],
Cell[32509, 1135, 188, 4, 70, "Tutorials",
 CellID->831],
Cell[32700, 1141, 189, 4, 70, "Tutorials",
 CellID->24305]
}, Open  ]],
Cell[CellGroupData[{
Cell[32926, 1150, 319, 9, 70, "MoreAboutSection",
 CellID->183989483],
Cell[33248, 1161, 160, 3, 70, "MoreAbout",
 CellID->17521599],
Cell[33411, 1166, 141, 3, 70, "MoreAbout",
 CellID->414031040],
Cell[33555, 1171, 151, 3, 70, "MoreAbout",
 CellID->365606096],
Cell[33709, 1176, 166, 3, 70, "MoreAbout",
 CellID->282546],
Cell[33878, 1181, 151, 3, 70, "MoreAbout",
 CellID->197461491],
Cell[34032, 1186, 156, 3, 70, "MoreAbout",
 CellID->40003940]
}, Open  ]],
Cell[34203, 1192, 50, 0, 70, "History"],
Cell[34256, 1194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

