(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20947,        766]
NotebookOptionsPosition[     16489,        616]
NotebookOutlinePosition[     17958,        655]
CellTagsIndexPosition[     17873,        650]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplification\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Length" :> Documentation`HelpLookup["paclet:ref/Length"], 
          "StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], 
          "TimeConstraint" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstraint"], 
          "ExcludedForms" :> 
          Documentation`HelpLookup["paclet:ref/ExcludedForms"], 
          "TransformationFunctions" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Length\"\>", 
       2->"\<\"StringLength\"\>", 3->"\<\"TimeConstraint\"\>", 
       4->"\<\"ExcludedForms\"\>", 
       5->"\<\"TransformationFunctions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ComplexityFunction", "ObjectName",
 CellID->12382],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ComplexityFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ComplexityFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Simplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["FullSimplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
     " which gives a function to rank the complexity of different forms of an \
expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ComplexityFunction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", forms are ranked primarily according to their ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 ", with corrections to treat integers with more digits as more complex. "
}], "Notes",
 CellID->18716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"ComplexityFunction", "->", 
     StyleBox["f", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to each intermediate expression generated by ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", treating the one which yields the smallest numerical value as simplest. "
}], "Notes",
 CellID->19718]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->286851719],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->23127786],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["ComplexityFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexityFunction"]], "InlineFormula"],
 " counts the subexpressions and digits of integers:"
}], "ExampleText",
 CellID->184071774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"100", " ", 
   RowBox[{"Log", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218545323],

Cell[BoxData[
 RowBox[{"100", " ", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->791368337]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " counts only the number of subexpressions:"
}], "ExampleText",
 CellID->9568449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"100", " ", 
    RowBox[{"Log", "[", "2", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "LeafCount"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250306141],

Cell[BoxData[
 RowBox[{"Log", "[", "1267650600228229401496703205376", "]"}]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304920958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62029037],

Cell["By default this expression is not simplified:", "ExampleText",
 CellID->70590592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11623231],

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426806266]
}, Open  ]],

Cell[TextData[{
 "This complexity function makes ",
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " more expensive than other functions:"
}], "ExampleText",
 CellID->366508076],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "e_", "]"}], ":=", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{"Count", "[", 
     RowBox[{"e", ",", "_ChebyshevT", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}], "+", 
   RowBox[{"LeafCount", "[", "e", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65307223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73900076],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"n", " ", 
   RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->285283678]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4664],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  ButtonBox["ComplexityFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexityFunction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is simpler than the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->386619267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196362796],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345039516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"FullForm", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], ",", 
     RowBox[{"-", "x"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647098756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Abs", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "x"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170502514]
}, Open  ]],

Cell[TextData[{
 "This complexity function counts characters in the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of the expression:"
}], "ExampleText",
 CellID->42451645],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "e_", "]"}], ":=", 
  RowBox[{"StringLength", "[", 
   RowBox[{"ToString", "[", 
    RowBox[{"InputForm", "[", "e", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->255118767],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is simpler than ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182002952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->74243047],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->425170722]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6868],

Cell["The automatic complexity function:", "ExampleText",
 CellID->677378510],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimplifyCount", "[", "p_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Head", "[", "p", "]"}], "===", "Symbol"}], ",", "1", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"IntegerQ", "[", "p", "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"p", "\[Equal]", "0"}], ",", "1", ",", 
      RowBox[{
       RowBox[{"Floor", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", ",", 
            RowBox[{"Abs", "[", "p", "]"}]}], "]"}], "/", 
          RowBox[{"Log", "[", 
           RowBox[{"2", ",", "10"}], "]"}]}], "]"}], "]"}], "+", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"p", ">", "0"}], ",", "1", ",", "2"}], "]"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Head", "[", "p", "]"}], "===", "Rational"}], ",", 
    RowBox[{
     RowBox[{"SimplifyCount", "[", 
      RowBox[{"Numerator", "[", "p", "]"}], "]"}], "+", 
     RowBox[{"SimplifyCount", "[", 
      RowBox[{"Denominator", "[", "p", "]"}], "]"}], "+", "1"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Head", "[", "p", "]"}], "===", "Complex"}], ",", 
    RowBox[{
     RowBox[{"SimplifyCount", "[", 
      RowBox[{"Re", "[", "p", "]"}], "]"}], "+", 
     RowBox[{"SimplifyCount", "[", 
      RowBox[{"Im", "[", "p", "]"}], "]"}], "+", "1"}], ",", 
    RowBox[{"NumberQ", "[", "p", "]"}], ",", "2", ",", "\[IndentingNewLine]", 
    "True", ",", 
    RowBox[{
     RowBox[{"SimplifyCount", "[", 
      RowBox[{"Head", "[", "p", "]"}], "]"}], "+", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "p", "]"}], "\[Equal]", "0"}], ",", "0", ",", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"SimplifyCount", "/@", 
          RowBox[{"(", 
           RowBox[{"List", "@@", "p"}], ")"}]}], ")"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441424991]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11538],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstraint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstraint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExcludedForms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExcludedForms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19895],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->5447]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComplexityFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 48.8856912}", "context" -> "System`", 
    "keywords" -> {
     "cost function", "goal", "measure of complexity", "simplicity", 
      "expression complexity", "function complexity", "equation complexity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ComplexityFunction is an option for Simplify and FullSimplify which \
gives a function to rank the complexity of different forms of an expression. \
", "synonyms" -> {"complexity function"}, "title" -> "ComplexityFunction", 
    "type" -> "Symbol", "uri" -> "ref/ComplexityFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4824, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->286851719]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17730, 643}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1666, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2289, 67, 56, 1, 70, "ObjectName",
 CellID->12382],
Cell[2348, 70, 807, 24, 70, "Usage",
 CellID->17421]
}, Open  ]],
Cell[CellGroupData[{
Cell[3192, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3670, 116, 488, 14, 70, "Notes",
 CellID->18716],
Cell[4161, 132, 626, 20, 70, "Notes",
 CellID->19718]
}, Closed]],
Cell[CellGroupData[{
Cell[4824, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->286851719],
Cell[CellGroupData[{
Cell[5209, 171, 147, 5, 70, "ExampleSection",
 CellID->23127786],
Cell[5359, 178, 264, 8, 70, "ExampleText",
 CellID->184071774],
Cell[CellGroupData[{
Cell[5648, 190, 160, 5, 28, "Input",
 CellID->218545323],
Cell[5811, 197, 212, 7, 36, "Output",
 CellID->791368337]
}, Open  ]],
Cell[6038, 207, 219, 7, 70, "ExampleText",
 CellID->9568449],
Cell[CellGroupData[{
Cell[6282, 218, 240, 7, 28, "Input",
 CellID->250306141],
Cell[6525, 227, 218, 6, 36, "Output",
 CellID->304920958]
}, Open  ]],
Cell[6758, 236, 124, 3, 70, "ExampleDelimiter",
 CellID->62029037],
Cell[6885, 241, 87, 1, 70, "ExampleText",
 CellID->70590592],
Cell[CellGroupData[{
Cell[6997, 246, 168, 5, 70, "Input",
 CellID->11623231],
Cell[7168, 253, 218, 7, 36, "Output",
 CellID->426806266]
}, Open  ]],
Cell[7401, 263, 254, 8, 70, "ExampleText",
 CellID->366508076],
Cell[7658, 273, 344, 11, 70, "Input",
 CellID->65307223],
Cell[CellGroupData[{
Cell[8027, 288, 240, 7, 70, "Input",
 CellID->73900076],
Cell[8270, 297, 245, 8, 36, "Output",
 CellID->285283678]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8564, 311, 215, 7, 70, "ExampleSection",
 CellID->4664],
Cell[8782, 320, 617, 24, 70, "ExampleText",
 CellID->386619267],
Cell[CellGroupData[{
Cell[9424, 348, 182, 6, 70, "Input",
 CellID->196362796],
Cell[9609, 356, 187, 6, 36, "Output",
 CellID->345039516]
}, Open  ]],
Cell[CellGroupData[{
Cell[9833, 367, 232, 8, 70, "Input",
 CellID->647098756],
Cell[10068, 377, 588, 23, 36, "Output",
 CellID->170502514]
}, Open  ]],
Cell[10671, 403, 252, 8, 70, "ExampleText",
 CellID->42451645],
Cell[10926, 413, 235, 7, 70, "Input",
 CellID->255118767],
Cell[11164, 422, 326, 14, 70, "ExampleText",
 CellID->182002952],
Cell[CellGroupData[{
Cell[11515, 440, 238, 7, 70, "Input",
 CellID->74243047],
Cell[11756, 449, 175, 6, 36, "Output",
 CellID->425170722]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11980, 461, 232, 7, 70, "ExampleSection",
 CellID->6868],
Cell[12215, 470, 77, 1, 70, "ExampleText",
 CellID->677378510],
Cell[12295, 473, 2026, 56, 70, "Input",
 CellID->441424991]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14370, 535, 311, 9, 70, "SeeAlsoSection",
 CellID->11538],
Cell[14684, 546, 1241, 44, 70, "SeeAlso",
 CellID->1869]
}, Open  ]],
Cell[CellGroupData[{
Cell[15962, 595, 314, 9, 70, "TutorialsSection",
 CellID->19895],
Cell[16279, 606, 138, 3, 70, "Tutorials",
 CellID->5447]
}, Open  ]],
Cell[16432, 612, 27, 0, 70, "History"],
Cell[16462, 614, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

