(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28429,       1021]
NotebookOptionsPosition[     23960,        862]
NotebookOutlinePosition[     25279,        900]
CellTagsIndexPosition[     25194,        895]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/PowerSeries"], 
          "Making Power Series Expansions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MakingPowerSeriesExpansions"], 
          "Operations on Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnPowerSeries"],
           "The Representation of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfPowerSeries"], 
          "Composition and Inversion of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CompositionAndInversionOfPowerSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Power Series\"\>", 
       2->"\<\"Making Power Series Expansions\"\>", 
       3->"\<\"Operations on Power Series\"\>", 
       4->"\<\"The Representation of Power Series\"\>", 
       5->"\<\"Composition and Inversion of Power Series\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "InverseSeries" :> 
          Documentation`HelpLookup["paclet:ref/InverseSeries"], "SeriesData" :> 
          Documentation`HelpLookup["paclet:ref/SeriesData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"InverseSeries\"\>", 
       3->"\<\"SeriesData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ComposeSeries", "ObjectName",
 CellID->14893],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ComposeSeries",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ComposeSeries"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["series", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["series", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]composes several power series. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ComposeSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeSeries"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["series", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["series", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " effectively replaces the variable in ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["series", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["series", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " and so on. "
}], "Notes",
 CellID->22483],

Cell["\<\
Two series can only meaningfully be composed when the point about which the \
first series is expanded corresponds to the limiting value of the second \
series at its expansion point. \
\>", "Notes",
 CellID->17807]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29754914],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->414963796],

Cell["Compose two power series:", "ExampleText",
 CellID->20600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "12"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5249],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", "x"}], "+", 
   RowBox[{"22", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"48", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"32", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3, 22, 48, 32}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22798],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "15"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "240"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "90"], "+", 
   FractionBox[
    RowBox[{"31", " ", 
     SuperscriptBox["x", "8"]}], "5760"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "5670"], "-", 
   FractionBox[
    RowBox[{"2951", " ", 
     SuperscriptBox["x", "10"]}], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 0, 
    Rational[-1, 8], 
    Rational[-1, 15], 
    Rational[-1, 240], 
    Rational[1, 90], 
    Rational[31, 5760], 
    Rational[1, 5670], 
    Rational[-2951, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6224],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "15"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "240"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "90"], "+", 
   FractionBox[
    RowBox[{"31", " ", 
     SuperscriptBox["x", "8"]}], "5760"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "5670"], "-", 
   FractionBox[
    RowBox[{"2951", " ", 
     SuperscriptBox["x", "10"]}], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 0, 
    Rational[-1, 8], 
    Rational[-1, 15], 
    Rational[-1, 240], 
    Rational[1, 90], 
    Rational[31, 5760], 
    Rational[1, 5670], 
    Rational[-2951, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11008]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3093],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "6"]}], "120"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "7"]}], "630"], "+", 
   FractionBox[
    RowBox[{"37", " ", 
     SuperscriptBox["x", "8"]}], "1680"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "405"], "-", 
   FractionBox[
    RowBox[{"4043", " ", 
     SuperscriptBox["x", "10"]}], "1814400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 3], 
    Rational[-1, 6], 
    Rational[-1, 5], 
    Rational[-7, 120], 
    Rational[13, 630], 
    Rational[37, 1680], 
    Rational[2, 405], 
    Rational[-4043, 1814400]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", " ", 
      RowBox[{"Exp", "[", "#", "]"}]}], "&"}], "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30523],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "6"]}], "120"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "7"]}], "630"], "+", 
   FractionBox[
    RowBox[{"37", " ", 
     SuperscriptBox["x", "8"]}], "1680"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "405"], "-", 
   FractionBox[
    RowBox[{"4043", " ", 
     SuperscriptBox["x", "10"]}], "1814400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 3], 
    Rational[-1, 6], 
    Rational[-1, 5], 
    Rational[-7, 120], 
    Rational[13, 630], 
    Rational[37, 1680], 
    Rational[2, 405], 
    Rational[-4043, 1814400]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1587]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"u", " ", 
     RowBox[{"Exp", "[", "u", "]"}]}], "/.", 
    RowBox[{"u", "->", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29314],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "6"]}], "120"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "7"]}], "630"], "+", 
   FractionBox[
    RowBox[{"37", " ", 
     SuperscriptBox["x", "8"]}], "1680"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "405"], "-", 
   FractionBox[
    RowBox[{"4043", " ", 
     SuperscriptBox["x", "10"]}], "1814400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 3], 
    Rational[-1, 6], 
    Rational[-1, 5], 
    Rational[-7, 120], 
    Rational[13, 630], 
    Rational[37, 1680], 
    Rational[2, 405], 
    Rational[-4043, 1814400]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u", " ", 
   RowBox[{"Exp", "[", "u", "]"}]}], "/.", 
  RowBox[{"u", "->", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7448],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "6"]}], "120"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "7"]}], "630"], "+", 
   FractionBox[
    RowBox[{"37", " ", 
     SuperscriptBox["x", "8"]}], "1680"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "405"], "-", 
   FractionBox[
    RowBox[{"4043", " ", 
     SuperscriptBox["x", "10"]}], "1814400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 3], 
    Rational[-1, 6], 
    Rational[-1, 5], 
    Rational[-7, 120], 
    Rational[13, 630], 
    Rational[37, 1680], 
    Rational[2, 405], 
    Rational[-4043, 1814400]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25200]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13458],

Cell["\<\
The limiting value of the second series must coincide with the expansion \
point of the first series:\
\>", "ExampleText",
 CellID->6618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20580],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmp\"\>"}], ":", 
  " ", "\<\"The constant term of series \\!\\(\\*InterpretationBox[\\(\\(\\(3\
\\\\ x\\)\\) + \\*InterpretationBox[\\(\\(O[x]\\)\\^5\\), SeriesData[x, 0, \
List[], 1, 5, 1], Rule[Editable, False]]\\), SeriesData[x, 0, List[3], 1, 5, \
1], Rule[Editable, False]]\\) does not match the expansion point of \
\\!\\(\\*InterpretationBox[\\(x + \\(\\(2\\\\ x\\^2\\)\\) + \
\\*InterpretationBox[\\(\\(O[x]\\)\\^10\\), SeriesData[x, 0, List[], 1, 10, \
1], Rule[Editable, False]]\\), SeriesData[x, 0, List[1, 2], 1, 10, 1], \
Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/SeriesData/scmp\\\", ButtonNote -> \
\\\"SeriesData::scmp\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->973936753],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"x", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "10"],
      SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 2}, 1, 10, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"1", "+", 
     RowBox[{"3", " ", "x"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "5"],
      SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 3}, 0, 5, 1],
    Editable->False]}], "]"}]], "Output",
 ImageSize->{297, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->949025150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15281],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", "x"}], "-", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   FractionBox[
    RowBox[{"81", " ", 
     SuperscriptBox["x", "4"]}], "4"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3, 
    Rational[-9, 2], 9, 
    Rational[-81, 4]}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{188, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->718636713]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9514],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2421],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "Tutorials",
 CellID->30232],

Cell[TextData[ButtonBox["Making Power Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingPowerSeriesExpansions"]], "Tutorials",
 CellID->31271],

Cell[TextData[ButtonBox["Operations on Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnPowerSeries"]], "Tutorials",
 CellID->720780250],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfPowerSeries"]], "Tutorials",
 CellID->31832],

Cell[TextData[ButtonBox["Composition and Inversion of Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CompositionAndInversionOfPowerSeries"]], "Tutorials",
 CellID->14310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->388447287],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->298962139]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComposeSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 50.1982248}", "context" -> "System`", 
    "keywords" -> {
     "formal series", "functional composition", "power series", 
      "substitute series"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ComposeSeries[series_1, series_2, ...] composes several power series. ", 
    "synonyms" -> {"compose series"}, "title" -> "ComposeSeries", "type" -> 
    "Symbol", "uri" -> "ref/ComposeSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5566, 176, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29754914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25052, 888}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2714, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3337, 91, 51, 1, 70, "ObjectName",
 CellID->14893],
Cell[3391, 94, 702, 22, 70, "Usage",
 CellID->24648]
}, Open  ]],
Cell[CellGroupData[{
Cell[4130, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4608, 138, 693, 26, 70, "Notes",
 CellID->22483],
Cell[5304, 166, 225, 5, 70, "Notes",
 CellID->17807]
}, Closed]],
Cell[CellGroupData[{
Cell[5566, 176, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29754914],
Cell[CellGroupData[{
Cell[5950, 190, 148, 5, 70, "ExampleSection",
 CellID->414963796],
Cell[6101, 197, 64, 1, 70, "ExampleText",
 CellID->20600],
Cell[CellGroupData[{
Cell[6190, 202, 426, 15, 28, "Input",
 CellID->5249],
Cell[6619, 219, 636, 21, 36, "Output",
 CellID->16519]
}, Open  ]],
Cell[7270, 243, 121, 3, 70, "ExampleDelimiter",
 CellID->31556],
Cell[CellGroupData[{
Cell[7416, 250, 440, 14, 28, "Input",
 CellID->22798],
Cell[7859, 266, 1162, 40, 54, "Output",
 CellID->30303]
}, Open  ]],
Cell[CellGroupData[{
Cell[9058, 311, 243, 8, 70, "Input",
 CellID->6224],
Cell[9304, 321, 1162, 40, 54, "Output",
 CellID->11008]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10515, 367, 233, 7, 70, "ExampleSection",
 CellID->20485],
Cell[CellGroupData[{
Cell[10773, 378, 466, 15, 70, "Input",
 CellID->3093],
Cell[11242, 395, 1262, 44, 54, "Output",
 CellID->14343]
}, Open  ]],
Cell[CellGroupData[{
Cell[12541, 444, 322, 11, 70, "Input",
 CellID->30523],
Cell[12866, 457, 1261, 44, 54, "Output",
 CellID->1587]
}, Open  ]],
Cell[CellGroupData[{
Cell[14164, 506, 323, 11, 70, "Input",
 CellID->29314],
Cell[14490, 519, 1261, 44, 54, "Output",
 CellID->9503]
}, Open  ]],
Cell[CellGroupData[{
Cell[15788, 568, 322, 11, 70, "Input",
 CellID->7448],
Cell[16113, 581, 1262, 44, 54, "Output",
 CellID->25200]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17424, 631, 226, 7, 70, "ExampleSection",
 CellID->13458],
Cell[17653, 640, 147, 4, 70, "ExampleText",
 CellID->6618],
Cell[CellGroupData[{
Cell[17825, 648, 375, 13, 70, "Input",
 CellID->20580],
Cell[18203, 663, 865, 14, 70, "Message",
 CellID->973936753],
Cell[19071, 679, 884, 28, 39, "Output",
 CellID->949025150]
}, Open  ]],
Cell[CellGroupData[{
Cell[19992, 712, 393, 13, 70, "Input",
 CellID->15281],
Cell[20388, 727, 719, 25, 54, "Output",
 CellID->718636713]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21168, 759, 310, 9, 70, "SeeAlsoSection",
 CellID->9514],
Cell[21481, 770, 706, 26, 70, "SeeAlso",
 CellID->14309]
}, Open  ]],
Cell[CellGroupData[{
Cell[22224, 801, 313, 9, 70, "TutorialsSection",
 CellID->2421],
Cell[22540, 812, 134, 3, 70, "Tutorials",
 CellID->30232],
Cell[22677, 817, 168, 3, 70, "Tutorials",
 CellID->31271],
Cell[22848, 822, 164, 3, 70, "Tutorials",
 CellID->720780250],
Cell[23015, 827, 175, 3, 70, "Tutorials",
 CellID->31832],
Cell[23193, 832, 191, 4, 70, "Tutorials",
 CellID->14310]
}, Open  ]],
Cell[CellGroupData[{
Cell[23421, 841, 319, 9, 70, "MoreAboutSection",
 CellID->388447287],
Cell[23743, 852, 145, 3, 70, "MoreAbout",
 CellID->298962139]
}, Open  ]],
Cell[23903, 858, 27, 0, 70, "History"],
Cell[23933, 860, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

