(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14969,        568]
NotebookOptionsPosition[     11067,        435]
NotebookOutlinePosition[     12535,        475]
CellTagsIndexPosition[     12450,        470]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sequences of Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SequencesOfOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Sequences of Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Block" :> Documentation`HelpLookup["paclet:ref/Block"], 
          "Module" :> Documentation`HelpLookup["paclet:ref/Module"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Block\"\>", 
       2->"\<\"Module\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "CompoundExpression ",
 StyleBox["(;)", "OperatorCharacter"]
}], "ObjectName",
 CellID->4144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ";", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ";", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "\[LineSeparator]evaluates the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in turn, giving the last one as the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23196]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CompoundExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"]], "InlineFormula"],
 " evaluates its arguments in a sequence corresponding to the control flow. "
}], "Notes",
 CellID->20222],

Cell[TextData[{
 "The returned value can be the result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7129],

Cell[TextData[{
 "The evaluation of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be affected by ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2161],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["expr", "TI"], 
    StyleBox["1", "TR"]], ";", 
   SubscriptBox[
    StyleBox["expr", "TI"], 
    StyleBox["2", "TR"]], ";"}]], "InlineFormula"],
 " returns value ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". If it is given as input, the resulting output will not be printed. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " will nevertheless be assigned to be the value of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5535]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->722843917],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->566813435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "x", "]"}], ";", 
  RowBox[{"Print", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29510],

Cell[CellGroupData[{

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->4745],

Cell[BoxData["y"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->20649]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"b", "=", "3"}], ";", 
  RowBox[{"a", "+", "b"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8313],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28022],

Cell["Do a computation, but do not print its output:", "ExampleText",
 CellID->2168],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", "^", "200"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14018],

Cell[TextData[{
 Cell[BoxData["%"], "InlineFormula"],
 " is still set to be the output:"
}], "ExampleText",
 CellID->18787],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[2]:=",
 CellID->9905],

Cell[BoxData["1606938044258990275541962092341162602522202993782792835301376"],\
 "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17958]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10202],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " to exit immediately:"
}], "ExampleText",
 CellID->3625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"a", "=", "2"}], ";", 
   RowBox[{"Throw", "[", "a", "]"}], ";", 
   RowBox[{"a", "=", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26477],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->680723317]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26292],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20450],

Cell[TextData[ButtonBox["Sequences of Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SequencesOfOperations"]], "Tutorials",
 CellID->11173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->707161443],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->332097637],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->650533154]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompoundExpression (;) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 50.8232408}", "context" -> "System`", 
    "keywords" -> {
     "evaluate in sequence", "linear order of execution", "semicolon", 
      "sequence of commands", "sequential composition", 
      "sequential evaluation", "sequential expression"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "expr_1; expr_2; ... evaluates the expr_i in turn, giving the last one as \
the result. ", "synonyms" -> {"compound expression", ";", "progn"}, "title" -> 
    "CompoundExpression", "type" -> "Symbol", "uri" -> 
    "ref/CompoundExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5827, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->722843917]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12307, 463}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1964, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2587, 76, 110, 4, 70, "ObjectName",
 CellID->4144],
Cell[2700, 82, 708, 23, 70, "Usage",
 CellID->23196]
}, Open  ]],
Cell[CellGroupData[{
Cell[3445, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3923, 127, 261, 7, 70, "Notes",
 CellID->20222],
Cell[4187, 136, 263, 10, 70, "Notes",
 CellID->7129],
Cell[4453, 148, 560, 23, 70, "Notes",
 CellID->2161],
Cell[5016, 173, 774, 28, 70, "Notes",
 CellID->5535]
}, Closed]],
Cell[CellGroupData[{
Cell[5827, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->722843917],
Cell[CellGroupData[{
Cell[6212, 220, 148, 5, 70, "ExampleSection",
 CellID->566813435],
Cell[CellGroupData[{
Cell[6385, 229, 152, 5, 70, "Input",
 CellID->29510],
Cell[CellGroupData[{
Cell[6562, 238, 86, 2, 70, "Print",
 CellID->4745],
Cell[6651, 242, 87, 2, 70, "Print",
 CellID->20649]
}, Open  ]]
}, Open  ]],
Cell[6765, 248, 121, 3, 70, "ExampleDelimiter",
 CellID->13186],
Cell[CellGroupData[{
Cell[6911, 255, 166, 6, 70, "Input",
 CellID->8313],
Cell[7080, 263, 153, 5, 36, "Output",
 CellID->4474]
}, Open  ]],
Cell[7248, 271, 121, 3, 70, "ExampleDelimiter",
 CellID->28022],
Cell[7372, 276, 84, 1, 70, "ExampleText",
 CellID->2168],
Cell[7459, 279, 132, 5, 70, "Input",
 CellID->14018],
Cell[7594, 286, 123, 4, 70, "ExampleText",
 CellID->18787],
Cell[CellGroupData[{
Cell[7742, 294, 65, 2, 70, "Input",
 CellID->9905],
Cell[7810, 298, 217, 6, 36, "Output",
 CellID->17958]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8076, 310, 216, 7, 70, "ExampleSection",
 CellID->10202],
Cell[8295, 319, 316, 13, 70, "ExampleText",
 CellID->3625],
Cell[CellGroupData[{
Cell[8636, 336, 211, 7, 70, "Input",
 CellID->26477],
Cell[8850, 345, 158, 5, 36, "Output",
 CellID->680723317]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9069, 357, 311, 9, 70, "SeeAlsoSection",
 CellID->26292],
Cell[9383, 368, 441, 17, 70, "SeeAlso",
 CellID->26439]
}, Open  ]],
Cell[CellGroupData[{
Cell[9861, 390, 314, 9, 70, "TutorialsSection",
 CellID->20450],
Cell[10178, 401, 155, 3, 70, "Tutorials",
 CellID->11173]
}, Open  ]],
Cell[CellGroupData[{
Cell[10370, 409, 319, 9, 70, "MoreAboutSection",
 CellID->707161443],
Cell[10692, 420, 145, 3, 70, "MoreAbout",
 CellID->332097637],
Cell[10840, 425, 155, 3, 70, "MoreAbout",
 CellID->650533154]
}, Open  ]],
Cell[11010, 431, 27, 0, 70, "History"],
Cell[11040, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

