(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37034,        927]
NotebookOptionsPosition[     33158,        798]
NotebookOutlinePosition[     34409,        834]
CellTagsIndexPosition[     34324,        829]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Uncompress" :> 
          Documentation`HelpLookup["paclet:ref/Uncompress"], "ByteCount" :> 
          Documentation`HelpLookup["paclet:ref/ByteCount"], "ExportString" :> 
          Documentation`HelpLookup["paclet:ref/ExportString"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"], "Share" :> 
          Documentation`HelpLookup["paclet:ref/Share"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Uncompress\"\>", 2->"\<\"ByteCount\"\>", 
       3->"\<\"ExportString\"\>", 4->"\<\"Hash\"\>", 5->"\<\"InputForm\"\>", 
       6->"\<\"Share\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Compress", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Compress",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Compress"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a compressed representation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string generated by ",
 Cell[BoxData[
  ButtonBox["Compress",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compress"]], "InlineFormula"],
 " contains only printable ASCII characters."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7076204],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->126810781],

Cell[TextData[{
 "A compressed representation of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " with 100-digit precision:"
}], "ExampleText",
 CellID->194484706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compress", "[", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1450575508],

Cell[BoxData["\<\"1:eJwNy7ERA0EIA8BrxQ38ABIgtfEVeBw6cf+ZP9poX5/ffX/\
PObiS2a5ptLxG\\nQZwaAkKtO0pienMMG9sZrQovTT4RscphTGkqZD8oQFWDlbkxemfE9QdwsBfm\\\
n\"\>"], "Output",
 ImageSize->{438, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465418269]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uncompress", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1958890648],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
998628034825342117068`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13636555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112213831],

Cell["Import an image:", "ExampleText",
 CellID->78522307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Import", "[", "\"\<ExampleData/rose.gif\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1591942586],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvXt8U+eZLjq2jCWFlrAP7dj4tg/YartP6yQmO/u0TXJCwMzunn3CJKTM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   "], {{0, 0}, {223, 164}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzFlzmOFEEQRRvEATBxOUnfgSMgYXMVZmGTQOojYDCLiYGBgdFCLcQswNDs
wyIOwAyQ3Xpdypf1p8YjnFL16x8RGRm51NXrN6/duDj6ZxdGo0ujzi4vbDIe
VfZr9X5lYbsNX+oejc/mk/HtzWJPo37tVrEnq3dz9ObEvX+v2LPGP36THv7w
QbHn0T96/m+O3tzxzck7cX7nf0O8rnPnP/G7d4q9XM2T63ewvzDVxfWdqr6T
sTnx6z7p/Kf+ePtmYZFTD+Kk+jhP6zfWi72I9YOfPX+zQX3dp62ePoLXcadN
/er6zJr+Nbe+rluqzzTWB04fDek9PuvN914tLNaX8aX41if/KT79yf+Snv+Z
k1/S13WfrepU9+9sld8Q5x3O7346Pvkl//U6bf0n/vpwYdE/nKe562//cPQe
n/0n7j5K4yMPc48z5ce7+yPx5fwcxfN1fa3Yu8iX9ZzH/ROezs+tx8U+RD28
7uuO72wX+xT57k6xz5EzPvrC+xv5133Tjo8+T/r+c7CLD/f+ab059Un5bW8V
+xg59RnS133b8nQ+4L9eV238Wj9p9OeN7/rYf6ov68oc/3CPD95/j+niJz18
SA93fu4fn0+Mr/8e1I7P9w+Pz9zjS3r2H8dHn7jj+3yj/9Gbo2cfNHf8/vP3
i/aHrj/394p9jevHfEjv+V+O+3jQf1of5vZ/eFDsW9yfTn4X+x79m6f8U3+j
r8+lzv/pSbEf5+b2/+e02M9BTn+k8af1B0dvbv/mzE9an66f1xec/jW3f38f
wNEnTv7mjm/O/KT17fqZo0/ceq9f6/u/f+aq77Th6H1/5P6U7qfwdP9j//J3
FJz9KXH2p5QfvztPc84R3h0fvetH/fvvkV3/998ju/5J/tHD0/zjP81/4vaf
9PRB0ide3w+PmvnnfKrHN4t6z5+556++v84bTv9RH39fkF/i3L8Tt3/2AXPy
G+LOv77ftry+37b+3X9eP6wv8u//PjyO81ef3/OGu38d3zzpNzeKvY/c3xGp
f62H199p7fjS/Nf3p3n4fj1e5W/O/SRx+0/zi97c/s29/h0fnvTk53uq4/ue
7PlD7/ien8R9z3f+Kb71Q9zrz+cL6wRe9/189e71T32tJy4cP3DevQ8ljh84
+wc8xfc+lPTm/O6nOf7N8Z84v7NP8269/cDR+X+pv10f1p/PudT/iZOHOfHh
rq/15u5/+6e/fQ9K3P7N3V/kn+YP7j5K3PNn7vmjPt5HnT/fAc7feucHRz/E
nT/9A3f+zs/6+vvvuOHsr0P+0SeOn7Q+8M97Gh9P6/0/6z0PiQ/peXd9kv/6
+7jNz/Wz3vVLes+z4zuP5D+Nz09z9gmeyb/1zn+I84Sf75ns//O/eAO3Yg==

      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{223, 164},
  PlotRange->{{0, 223}, {0, 164}}]], "Output",
 ImageSize->{227, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->68496810]
}, Open  ]],

Cell["Number of bytes used to store the image:", "ExampleText",
 CellID->1711740011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179222569],

Cell[BoxData["155392"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->447609325]
}, Open  ]],

Cell["Number of bytes of a compressed representation of the image:", \
"ExampleText",
 CellID->1523429665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", 
  RowBox[{"Compress", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1889506499],

Cell[BoxData["27000"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200063573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434732722],

Cell["Compress a general expression: ", "ExampleText",
 CellID->752349621],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"x", "^", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437951246],

Cell["In this case there is almost a factor of 50 compression: ", \
"ExampleText",
 CellID->244932467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ByteCount", "[", "e", "]"}], ",", 
   RowBox[{"ByteCount", "[", 
    RowBox[{"Compress", "[", "e", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240630703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"199752", ",", "4184"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44608014]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Uncompress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Uncompress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Share",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Share"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Compress",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Compress"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->593244231],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->61025717]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compress - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 54.6983400}", "context" -> "System`", 
    "keywords" -> {"compression", "data compression", "information theory"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Compress[expr] gives a compressed representation of expr as a string. ", 
    "synonyms" -> {}, "title" -> "Compress", "type" -> "Symbol", "uri" -> 
    "ref/Compress"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5404, 160, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7076204]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34183, 822}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1832, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2455, 68, 1573, 37, 70, "ObjectNameGrid"],
Cell[4031, 107, 578, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4646, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5124, 147, 243, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[5404, 160, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7076204],
Cell[CellGroupData[{
Cell[5787, 174, 148, 5, 70, "ExampleSection",
 CellID->126810781],
Cell[5938, 181, 188, 6, 70, "ExampleText",
 CellID->194484706],
Cell[CellGroupData[{
Cell[6151, 191, 160, 5, 28, "Input",
 CellID->1450575508],
Cell[6314, 198, 298, 7, 71, "Output",
 CellID->465418269]
}, Open  ]],
Cell[CellGroupData[{
Cell[6649, 210, 107, 3, 28, "Input",
 CellID->1958890648],
Cell[6759, 215, 267, 7, 54, "Output",
 CellID->13636555]
}, Open  ]],
Cell[7041, 225, 125, 3, 70, "ExampleDelimiter",
 CellID->112213831],
Cell[7169, 230, 58, 1, 70, "ExampleText",
 CellID->78522307],
Cell[CellGroupData[{
Cell[7252, 235, 153, 4, 70, "Input",
 CellID->1591942586],
Cell[7408, 241, 20623, 347, 185, "Output",
 CellID->68496810]
}, Open  ]],
Cell[28046, 591, 84, 1, 70, "ExampleText",
 CellID->1711740011],
Cell[CellGroupData[{
Cell[28155, 596, 105, 3, 70, "Input",
 CellID->179222569],
Cell[28263, 601, 163, 5, 36, "Output",
 CellID->447609325]
}, Open  ]],
Cell[28441, 609, 106, 2, 70, "ExampleText",
 CellID->1523429665],
Cell[CellGroupData[{
Cell[28572, 615, 141, 4, 70, "Input",
 CellID->1889506499],
Cell[28716, 621, 162, 5, 36, "Output",
 CellID->200063573]
}, Open  ]],
Cell[28893, 629, 125, 3, 70, "ExampleDelimiter",
 CellID->434732722],
Cell[29021, 634, 74, 1, 70, "ExampleText",
 CellID->752349621],
Cell[29098, 637, 244, 9, 70, "Input",
 CellID->437951246],
Cell[29345, 648, 102, 2, 70, "ExampleText",
 CellID->244932467],
Cell[CellGroupData[{
Cell[29472, 654, 226, 7, 70, "Input",
 CellID->240630703],
Cell[29701, 663, 211, 7, 36, "Output",
 CellID->44608014]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29973, 677, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[30292, 688, 1437, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[31766, 746, 305, 8, 70, "RelatedLinksSection"],
Cell[32074, 756, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32472, 773, 299, 8, 70, "MoreAboutSection"],
Cell[32774, 783, 133, 3, 70, "MoreAbout",
 CellID->593244231],
Cell[32910, 788, 176, 3, 70, "MoreAbout",
 CellID->61025717]
}, Open  ]],
Cell[33101, 794, 27, 0, 70, "History"],
Cell[33131, 796, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

