(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18463,        669]
NotebookOptionsPosition[     14209,        531]
NotebookOutlinePosition[     15931,        574]
CellTagsIndexPosition[     15846,        569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], "Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Conditionals\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Except" :> Documentation`HelpLookup["paclet:ref/Except"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Switch" :> 
          Documentation`HelpLookup["paclet:ref/Switch"], "Which" :> 
          Documentation`HelpLookup["paclet:ref/Which"], "PatternTest" :> 
          Documentation`HelpLookup["paclet:ref/PatternTest"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Except\"\>", 2->"\<\"If\"\>", 
       3->"\<\"Switch\"\>", 4->"\<\"Which\"\>", 5->"\<\"PatternTest\"\>", 
       6->"\<\"Element\"\>", 7->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Condition ",
 StyleBox["(/;)", "OperatorCharacter"]
}], "ObjectName",
 CellID->12043],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["patt", "TI"], "/;", 
       StyleBox["test", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is a pattern which matches only if the evaluation of ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ":>", 
       RowBox[{
        StyleBox["rhs", "TI"], "/;", 
        StyleBox["test", "TI"]}]}]], "InlineFormula"],
     "\[LineSeparator]represents a rule which applies only if the evaluation \
of ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ":=", 
       RowBox[{
        StyleBox["rhs", "TI"], "/;", 
        StyleBox["test", "TI"]}]}]], "InlineFormula"],
     "\[LineSeparator]is a definition to be used only if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->22758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All pattern variables used in ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " must also appear in ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5109],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   RowBox[{
    ButtonBox["Module",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Module"], "[", 
    RowBox[{
     RowBox[{"{", 
      StyleBox["vars", "TI"], "}"}], ",", 
     RowBox[{
      StyleBox["rhs", "TI"], "/;", 
      StyleBox["test", "TI"]}]}], "]"}]}]], "InlineFormula"],
 " allows local variables to be shared between ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ". You can use the same construction with ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->123,
  ButtonNote->"123"]
}], "Notes",
 CellID->17086]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98378263],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->48693808],

Cell[TextData[{
 "Make a definition with the condition that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " should be positive:"
}], "ExampleText",
 CellID->90074859],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ppp", "[", "x", "]"}], "/;", 
   RowBox[{"x", ">", "0"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250955071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14490019],

Cell[BoxData[
 RowBox[{"ppp", "[", "5", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320852668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"-", "6"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->90225760],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"-", "6"}], "]"}]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129300525]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337870057],

Cell["\<\
Replace all elements which satisfy the condition of being negative:\
\>", "ExampleText",
 CellID->147298311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"6", ",", 
    RowBox[{"-", "7"}], ",", "3", ",", "2", ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "2"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"x_", "/;", 
    RowBox[{"x", "<", "0"}]}], "\[Rule]", "w"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152728435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "w", ",", "3", ",", "2", ",", "w", ",", "w"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614542816]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14962],

Cell["Share a variable between a condition and function body:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->123],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{
     RowBox[{"u", "^", "2"}], "/;", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "=", 
         RowBox[{"x", "-", "1"}]}], ")"}], ">", "0"}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3737],

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "6", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10195],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32525]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25627],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Switch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Switch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Which",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Which"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29565],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->3487],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->29577],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->186319736],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->160225184],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->103441009]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Condition (/;) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 55.1202258}", "context" -> "System`", 
    "keywords" -> {
     "applicability of transformation rules", "conditions", "constraints", 
      "criteria", "domain", "matching", "patterns", "provided that", 
      "restriction", "restrictions on transformation rules", "rules", 
      "slash-semi", "transformation rules", "whenever", "where", 
      "pattern condition", "restricted pattern"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "patt /; test is a pattern which matches only if the evaluation of test \
yields True. lhs :> rhs /; test represents a rule which applies only if the \
evaluation of test yields True. lhs := rhs /; test is a definition to be used \
only if test yields True. ", "synonyms" -> {"/;"}, "title" -> "Condition", 
    "type" -> "Symbol", "uri" -> "ref/Condition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6830, 222, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98378263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15704, 562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2677, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3300, 86, 103, 4, 70, "ObjectName",
 CellID->12043],
Cell[3406, 92, 1677, 56, 70, "Usage",
 CellID->22758]
}, Open  ]],
Cell[CellGroupData[{
Cell[5120, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5598, 170, 230, 9, 70, "Notes",
 CellID->5109],
Cell[5831, 181, 962, 36, 70, "Notes",
 CellID->17086]
}, Closed]],
Cell[CellGroupData[{
Cell[6830, 222, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98378263],
Cell[CellGroupData[{
Cell[7214, 236, 147, 5, 70, "ExampleSection",
 CellID->48693808],
Cell[7364, 243, 181, 6, 70, "ExampleText",
 CellID->90074859],
Cell[7548, 251, 201, 7, 70, "Input",
 CellID->250955071],
Cell[CellGroupData[{
Cell[7774, 262, 96, 3, 28, "Input",
 CellID->14490019],
Cell[7873, 267, 187, 6, 36, "Output",
 CellID->320852668]
}, Open  ]],
Cell[CellGroupData[{
Cell[8097, 278, 114, 4, 28, "Input",
 CellID->90225760],
Cell[8214, 284, 203, 7, 36, "Output",
 CellID->129300525]
}, Open  ]],
Cell[8432, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->337870057],
Cell[8560, 299, 118, 3, 70, "ExampleText",
 CellID->147298311],
Cell[CellGroupData[{
Cell[8703, 306, 320, 11, 70, "Input",
 CellID->152728435],
Cell[9026, 319, 247, 8, 36, "Output",
 CellID->614542816]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9322, 333, 216, 7, 70, "ExampleSection",
 CellID->14962],
Cell[9541, 342, 140, 2, 70, "ExampleText",
 CellID->123],
Cell[9684, 346, 396, 15, 70, "Input",
 CellID->24596],
Cell[CellGroupData[{
Cell[10105, 365, 92, 3, 70, "Input",
 CellID->3737],
Cell[10200, 370, 181, 6, 36, "Output",
 CellID->13261]
}, Open  ]],
Cell[CellGroupData[{
Cell[10418, 381, 93, 3, 70, "Input",
 CellID->10195],
Cell[10514, 386, 155, 5, 36, "Output",
 CellID->32525]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10730, 398, 311, 9, 70, "SeeAlsoSection",
 CellID->25627],
Cell[11044, 409, 1655, 62, 70, "SeeAlso",
 CellID->5629]
}, Open  ]],
Cell[CellGroupData[{
Cell[12736, 476, 314, 9, 70, "TutorialsSection",
 CellID->29565],
Cell[13053, 487, 169, 3, 70, "Tutorials",
 CellID->3487],
Cell[13225, 492, 135, 3, 70, "Tutorials",
 CellID->29577],
Cell[13363, 497, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[13539, 505, 319, 9, 70, "MoreAboutSection",
 CellID->186319736],
Cell[13861, 516, 145, 3, 70, "MoreAbout",
 CellID->160225184],
Cell[14009, 521, 128, 3, 70, "MoreAbout",
 CellID->103441009]
}, Open  ]],
Cell[14152, 527, 27, 0, 70, "History"],
Cell[14182, 529, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

